#!/bin/bash
GPU_ID=$1
START=$2
END=$3
ipc=50
export OPENBLAS_NUM_THREADS=2
export OMP_NUM_THREADS=2
export MKL_NUM_THREADS=2

CUDA_VISIBLE_DEVICES=$GPU_ID python -u generate_soft_label.py \
    -a resnet18 \
    -b 1024 \
    -j 8 \
    --epochs 300 \
    --fkd-seed 42 \
    --input-size 224 \
    --min-scale-crops 0.08 \
    --max-scale-crops 1 \
    --use-fp16 \
    --start-epochs $START \
    --epochs $END \
    --fkd-path FKD_cutmix_fp16_lt \
    --mode 'fkd_save' \
    --mix-type 'cutmix' \
    --data ../recover/syn_data/rn18_bn0.01_[4K]_x_l2_x_tv_ipc50.crop \
    --IPC $ipc &> ./log/resnet18_cutmix_fp16_${ipc}_${START}_${END}_lt.log

