wandb disabled
# wandb enabled
wandb offline

CUDA_VISIBLE_DEVICES=0 python -u train_KD.py \
    --wandb-project 'val_rn18_kd' \
    --batch-size 512 \
    --gradient-accumulation-steps 2 \
    --model resnet18 \
    --teacher-model resnet18 \
    --cos \
    -j 4 \
    -T 20 \
    --mix-type 'cutmix' \
    --output-dir ./save/val_rn18_kd/rn18_[4K]_T20 \
    --train-dir ../recover/syn_data/rn18_bn0.01_[4K]_x_l2_x_tv.crop \
    --val-dir "/data0/ImageNet/val" &> ./log/log_rn18_[4K]_T20.txt &

wait

tau=0.1
suffix="logit_tau_${tau}"
CUDA_VISIBLE_DEVICES=2 python -u train_KD_logit_tau.py \
    --wandb-project "val_rn18_kd_${suffix}" \
    --batch-size 512 \
    --gradient-accumulation-steps 2 \
    --model resnet18 \
    --teacher-model resnet18 \
    --cos \
    -j 4 \
    -T 20 \
    --tau $tau \
    --mix-type 'cutmix' \
    --output-dir ./save/val_rn18_kd/rn18_[4K]_T20_${suffix} \
    --train-dir ../recover/syn_data/rn18_bn0.01_[4K]_x_l2_x_tv.crop \
    --val-dir "/data0/ImageNet/val" &> ./log/log_rn18_[4K]_T20_${suffix}.txt &