#!/bin/bash
MODEL="resnet18"
SUFFIX="${MODEL}_Imagenet1k_lt"
data_path="/data0/ImageNet"
output_dir="./output/${SUFFIX}"
# device="cuda"
log_dir="./log/${SUFFIX}.log"

CUDA_VISIBLE_DEVICES="1,2,3,4" torchrun --nproc_per_node=4 train_lt.py --model $MODEL --data-path $data_path --output-dir $output_dir &> $log_dir


MODEL="mobilenet_v2"
SUFFIX="${MODEL}_Imagenet1k_lt"
data_path="/data0/ImageNet"
output_dir="./output/${SUFFIX}"
log_dir="./log/${SUFFIX}.log"
CUDA_VISIBLE_DEVICES="1,2,3,4" torchrun --master_port 29501 --nproc_per_node=4 train_lt.py\
     --model $MODEL --epochs 300 --lr 0.045 --wd 0.00004\
     --lr-step-size 1 --lr-gamma 0.98 --data-path $data_path --output-dir $output_dir &> $log_dir


MODEL="alexnet"
SUFFIX="${MODEL}_Imagenet1k_lt"
data_path="/data0/ImageNet"
output_dir="./output/${SUFFIX}"
log_dir="./log/${SUFFIX}.log"
torchrun --master_port 29517 --nproc_per_node=4 train_lt.py\
    --model $MODEL --lr 1e-2  --data-path $data_path --output-dir $output_dir &> $log_dir

MODEL="shufflenet_v2_x1_5"
SUFFIX="${MODEL}_Imagenet1k_lt"
data_path="/data0/ImageNet"
output_dir="./output/${SUFFIX}"
log_dir="./log/${SUFFIX}.log"
CUDA_VISIBLE_DEVICES="3,4,5,7" torchrun --master_port 29509 --nproc_per_node=4 train_lt.py \
--batch-size=128 \
--model $MODEL \
--lr=0.5 --lr-scheduler=cosineannealinglr --lr-warmup-epochs=5 --lr-warmup-method=linear \
--auto-augment=ta_wide --epochs=120 --random-erase=0.1 --weight-decay=0.00002 \
--norm-weight-decay=0.0 --label-smoothing=0.1 --mixup-alpha=0.2 --cutmix-alpha=1.0 \
--train-crop-size=176 --model-ema --val-resize-size=232 --ra-sampler --ra-reps=4  --data-path $data_path --output-dir $output_dir &> $log_dir


MODEL="efficientnet_v2_s"
SUFFIX="${MODEL}_Imagenet1k_lt"
data_path="/data0/ImageNet"
output_dir="./output/${SUFFIX}"
log_dir="./log/${SUFFIX}.log"

TRAIN_SIZE=300
EVAL_SIZE=384
torchrun --nproc_per_node=2 --master_port 29701 train_lt.py \
--model $MODEL --batch-size 128 --lr 0.5 --lr-scheduler cosineannealinglr \
--lr-warmup-epochs 5 --lr-warmup-method linear --auto-augment ta_wide --epochs 600 --random-erase 0.1 \
--label-smoothing 0.1 --mixup-alpha 0.2 --cutmix-alpha 1.0 --weight-decay 0.00002 --norm-weight-decay 0.0 \
--train-crop-size $TRAIN_SIZE --model-ema --val-crop-size $EVAL_SIZE --val-resize-size $EVAL_SIZE \
--ra-sampler --ra-reps 4 --data-path $data_path --output-dir $output_dir &> $log_dir

