#!/bin/bash
export MKL_NUM_THREADS=16
GPU_ID=$1
# for ipc in 10 50 100
for ipc in 100
do
    time_stamp=$(date +"%Y%m%d_%H%M%S")
    CKPT_DIR="../../store/pretrain"
    LOG_DIR="../../store/edc/recover/log"
    TRAIN_DATA_PATH="/nas/dataset/dataset_distillation/ImageNet-2012"
    SYN_PATH="../../store/edc/recover/syn_data/"
    INTERMEDIATE_PATH="../../store/edc/recover/intermediate_path/"
    PRE_PATCH_MEMORY="../../store/edc/recover/pre_patch_memory.npz"

    python -u data_synthesis_without_optim_lt.py \
        --exp-name "WO_OPTIM_ImageNet_1k_Recover_IPC_${ipc}" \
        --ipc-number $ipc \
        --syn-data-path "${SYN_PATH}" \
        --train-data-path "${TRAIN_DATA_PATH}" \
        --ckpt-dir "${CKPT_DIR}" \
        --pre-patch-memory "${PRE_PATCH_MEMORY}" \
        --intermediate-path "${INTERMEDIATE_PATH}" \
        --gpu-id "${GPU_ID}" 2>&1 | tee ${LOG_DIR}/data_synthesis_without_optim_${ipc}_${SUFFIX}_"${time_stamp}".log
done