#!/bin/bash
GPU_ID=$1
IPC=$2
# for IPC in 1
# do
SUFFIX="AUTO_FIXED"
time_stamp=$(date "+%Y%m%d%H%M%S")
# IPC=10
data="../../store/edc/recover/syn_data/EDC_ImageNet_1k_Recover_IPC_${IPC}"
fkd="../../store/edc/relabel/FKD_EDC_IPC_${IPC}_${SUFFIX}"
log="../../store/edc/relabel/log/FKD_EDC_IPC_${IPC}_${SUFFIX}_${time_stamp}.log"
ckpt="../../store/pretrain"
lt_data="/nas/dataset/dataset_distillation/ImageNet-2012"

CUDA_VISIBLE_DEVICES=$GPU_ID python -u generate_soft_label_with_db_auto.py \
    -b 100 \
    -j 8 \
    --adjust_base_number 5 \
    --epochs 300 \
    --fkd-seed 42 \
    --input-size 224 \
    --min-scale-crops 0.5 \
    --max-scale-crops 1 \
    --use-fp16 --candidate-number 4 \
    --fkd-path "$fkd" \
    --mode 'fkd_save' \
    --mix-type 'cutmix' \
    --ckpt-dir $ckpt \
    --lt-data $lt_data \
    --data "$data" 2>&1 | tee "${log}"
# done