#!/bin/bash
GPU_ID=$1
IPC=$2
data="../../store/edc/recover/syn_data/EDC_ImageNet_1k_Recover_IPC_${IPC}"
fkd="../../store/edc/relabel/FKD_EDC_IPC_${IPC}_LT"
log="../../store/edc/relabel/log/FKD_EDC_IPC_${IPC}_LT.log"
ckpt="../../store/pretrain"
CUDA_VISIBLE_DEVICES=$GPU_ID python generate_soft_label_with_db_lt.py \
    -b 100 \
    -j 8 \
    --epochs 300 \
    --fkd-seed 42 \
    --input-size 224 \
    --min-scale-crops 0.5 \
    --max-scale-crops 1 \
    --use-fp16 --candidate-number 4 \
    --fkd-path ${fkd} \
    --mode 'fkd_save' \
    --mix-type 'cutmix' \
    --ckpt-dir $ckpt \
    --data $data 2>&1 | tee $log &

wait
