#!/bin/bash
wandb offline
wandb disabled
# wandb enabled

GPU_ID=$1
IPC=$2

model="resnet10"
tau=0
EP="checkpoint"
ckpt_path="/data0/xxx/work/imagenet-lt-pretrain/output/resnet18_Imagenet1k_lt/${EP}.pth"
suffix="logit_tau_${tau}_${EP}_${model}_${IPC}"
CUDA_VISIBLE_DEVICES=$GPU_ID python train_KD_logit_tau.py \
    --wandb-project "val_${model}_kd_${suffix}" \
    --batch-size 512 \
    --gradient-accumulation-steps 2 \
    --model ${model} \
    --teacher-model resnet18 \
    --cos \
    --IPC "${IPC}" \
    --ckpt-path "$ckpt_path" \
    -j 4 \
    -T 20 \
    --tau $tau \
    --mix-type 'cutmix' \
    --output-dir ./save/val_${model}_kd/${model}_[4K]_T20_"${suffix}" \
    --train-dir ../recover/syn_data/rn18_bn0.01_[4K]_x_l2_x_tv.crop \
    --val-dir "/data0/ImageNet/val" | tee ./log/log_${model}_[4K]_T20_"${suffix}".txt
wait
