#!/bin/bash
SPECIFIC_LIST=(0 1 2 3 4 5 10 15 20 40 60 80 100)
DEVICE_LIST=(0 1 2 3)
RAND_LIST=(0 1 2)
lr=0.1
EPOCHS=200
IR=-1

echo "[LOG]: start squeeze"

SUFFIX="imb_size10000_extream_lt_specific"
NAME=E${EPOCHS}_lr${lr}_${SUFFIX}
DEVICE_ID=0
fix_number=10000
for SPECIFIC_NUMBER in "${SPECIFIC_LIST[@]}"
do
    for rand_value in "${RAND_LIST[@]}"
    do
    log_dir=./log/${SUFFIX}/rand${rand_value}
    log_path=${log_dir}/${NAME}_${SPECIFIC_NUMBER}_${fix_number}.log
    output_dir=./save/${SUFFIX}/rand${rand_value}/${NAME}_${SPECIFIC_NUMBER}_${fix_number}

    mkdir -p $log_dir
    mkdir -p "$output_dir"
    {
    start_time=$(date +%s)
    CUDA_VISIBLE_DEVICES=${DEVICE_LIST[$DEVICE_ID]} python  squeeze_cifar.py --epochs $EPOCHS --output-dir "$output_dir" --lr $lr --rand-value $rand_value --long-tail --imb-factor $IR --fix-number $fix_number --specific-number "$SPECIFIC_NUMBER" --imb-type 'specific_classes' &> "$log_path"
    end_time=$(date +%s)
    echo "[MY LOG] Start time: $start_time, End time: $end_time"
    cost_time=$((end_time-start_time))
    echo "[MY LOG] Cost time: $cost_time seconds"
    }&> "${log_path}" &
    DEVICE_ID=$((DEVICE_ID+1))
    LEN_DEVICE_LIST=${#DEVICE_LIST[@]}
    DEVICE_ID=$((DEVICE_ID%LEN_DEVICE_LIST))
    done
done

wait

echo "[LOG]: finish squeeze"


echo "[LOG]: start recover"

############ imb #############
SUFFIX_ARCH="imb_size10000_extream_lt_specific"
NAME_ARCH=E${EPOCHS}_lr${lr}_${SUFFIX_ARCH}
SUFFIX="imb_size10000_extream_lt_specific_10ipc"
NAME=E${EPOCHS}_lr${lr}_${SUFFIX}
fix_number=10000
DEVICE_ID=0
IPC=10
for rand_value in "${RAND_LIST[@]}"
do
    for SPECIFIC_NUMBER in "${SPECIFIC_LIST[@]}"
    do
        {
        arch_path=./save/${SUFFIX_ARCH}/rand${rand_value}/${NAME_ARCH}_${SPECIFIC_NUMBER}_${fix_number}/ckpt.pth

        log_dir=./log/${SUFFIX}/rand${rand_value}
        log_path=${log_dir}/recover_${NAME}_${SPECIFIC_NUMBER}_${IPC}.log    # contain specific character
        syn_data_path=./syn_data/${SUFFIX}/rand${rand_value}/
        exp_name=SPEC_NUMBER${SPECIFIC_NUMBER}_IPC${IPC}  # contain special character

        mkdir -p $log_dir
        mkdir -p $syn_data_path

        start=$(date +%s)
        CUDA_VISIBLE_DEVICES=${DEVICE_LIST[$DEVICE_ID]} \
        python recover_cifar.py \
        --arch-name "resnet18" \
        --arch-path "$arch_path" \
        --exp-name "$exp_name" \
        --batch-size $IPC \
        --lr 0.25 \
        --iteration 1000 \
        --r-bn 0.01 \
        --store-best-images \
        --ipc-start 0 --ipc-end $IPC \
        --syn-data-path $syn_data_path \
        --train-data-path "data/cifar100" \
        --verifier &>"$log_path"
        end=$(date +%s)
        echo "start=${start}, end=${end}" >> "$log_path"
        echo "SPEC_NUMBER=${SPECIFIC_NUMBER}, IPC=${IPC} done in $((end-start))s" >> "$log_path"
        }&
    DEVICE_ID=$((DEVICE_ID+1))
    LEN_DEVICE_LIST=${#DEVICE_LIST[@]}
    DEVICE_ID=$((DEVICE_ID%LEN_DEVICE_LIST))
    done
done
wait

echo "[LOG]: finish recover"

#!/bin/bash

echo "[LOG]: start relabel"


STAGE="relabel"

############ imb #############
SUFFIX_IMB="imb_size10000_extream_lt_specific"
NAME_IMB=E${EPOCHS}_lr${lr}_${SUFFIX_IMB}
SUFFIX_CAT_IMB="imb_size10000_extream_lt_specific_10ipc"
NAME_CAT_IMB=E${EPOCHS}_lr${lr}_${SUFFIX_IMB}
SUFFIX="imb_size10000_img_label_with_base_extream_lt_specific_10ipc"
NAME=E${EPOCHS}_lr${lr}_${SUFFIX}
fix_number=10000
DEVICE_ID=0
IPC=10
for rand_value in "${RAND_LIST[@]}"
do
    for SPECIFIC_NUMBER in "${SPECIFIC_LIST[@]}"
    do
        {
        syn_data_path=./syn_data/${SUFFIX_CAT_IMB}/rand${rand_value}/SPEC_NUMBER${SPECIFIC_NUMBER}_IPC${IPC}  # contain special character
        teacher_path=./save/${SUFFIX_IMB}/rand${rand_value}/${NAME_IMB}_100_${fix_number}/ckpt.pth
        
        log_dir=./log/${SUFFIX}/rand${rand_value}
        log_path=${log_dir}/${STAGE}_${NAME}_${SPECIFIC_NUMBER}_${IPC}.log    # contain specific character
        output_dir=./save_post_cifar100/${SUFFIX}/rand${rand_value}/${SPECIFIC_NUMBER}_${IPC}   # contain special character

        mkdir -p $log_dir
        mkdir -p "$output_dir"

        start=$(date +%s)
        CUDA_VISIBLE_DEVICES=${DEVICE_LIST[$DEVICE_ID]} \
        python relabel_cifar.py \
        --epochs 400 \
        --output-dir "$output_dir" \
        --syn-data-path "$syn_data_path" \
        --teacher-path $teacher_path \
        --ipc $IPC --batch-size 128 &> "$log_path"
        end=$(date +%s)
        echo "start=${start}, end=${end}" >> "$log_path"
        echo "SPEC_NUMBER=${SPECIFIC_NUMBER}, IPC=${IPC} done in $((end-start))s" >> "$log_path"
        }&
    DEVICE_ID=$((DEVICE_ID+1))
    LEN_DEVICE_LIST=${#DEVICE_LIST[@]}
    DEVICE_ID=$((DEVICE_ID%LEN_DEVICE_LIST))
    done
done
wait

echo "[LOG]: finish relabel"
