#!/bin/bash
START_DEVICE=0
MAX_DEVICE=4

spec_number_list=(0 1 2 3 4 5 10 15 20 40 60 80 100)
model_ir_list=(0 1 2 3 4 5 10 15 20 40 60 80 100)

# Ensure log directory exists
mkdir -p log/compute_entropy

# Process `spec_number_list` in chunks of 4
chunk_size=4
total_spec=${#spec_number_list[@]}

for ((i = 0; i < total_spec; i += chunk_size)); do
    device=$START_DEVICE

    # Get the next 4 items (or fewer if near the end)
    spec_chunk=("${spec_number_list[@]:i:chunk_size}")

    for spec_number in "${spec_chunk[@]}"; do
        for model_ir in "${model_ir_list[@]}"; do
            log_path="log/compute_entropy/spec_number_${spec_number}_model_ir_${model_ir}.log"
            CUDA_VISIBLE_DEVICES=$device python compute_entropy.py --spec-number $spec_number --model-ir $model_ir &> $log_path &
            device=$((device + 1))
            if [ $device -eq $MAX_DEVICE ]; then
                device=$START_DEVICE
            fi
        done
    done

    # Wait for the current batch to finish before starting the next chunk
    wait
done