#!/bin/bash

device_list=(0 1 2 3 4 5 6)
device_len=${#device_list[@]}
device_id=0
spec_number_list=(0 1 2 3 4 5 10 15 20 40 60 80 100) 

for spec_number in "${spec_number_list[@]:0:4}"
do
    for model_ir in "${spec_number_list[@]}"
    do
        device=${device_list[$device_id]}
        CUDA_VISIBLE_DEVICES=${device} python compute_logit.py --spec_number "${spec_number}" --model_ir "${model_ir}" &
        device_id=$((device_id+1))
        device_id=$((device_id%device_len))
    done
    wait
done
wait

for spec_number in "${spec_number_list[@]:5:8}"
do
    for model_ir in "${spec_number_list[@]}"
    do
        device=${device_list[$device_id]}
        CUDA_VISIBLE_DEVICES=${device} python compute_logit.py --spec_number "${spec_number}" --model_ir "${model_ir}" &
        device_id=$((device_id+1))
        device_id=$((device_id%device_len))
    done
    wait
done
wait

for spec_number in "${spec_number_list[@]:9:12}"
do
    for model_ir in "${spec_number_list[@]}"
    do
        device=${device_list[$device_id]}
        CUDA_VISIBLE_DEVICES=${device} python compute_logit.py --spec_number "${spec_number}" --model_ir "${model_ir}" &
        device_id=$((device_id+1))
        device_id=$((device_id%device_len))
    done
    wait
done
wait
