data_paths=(
    ./data/aime_24.json
    # ./data/aime_25.json
    # ./data/gpqa_Physics.jsonl
    # ./data/gpqa_Chemistry.jsonl
    # ./data/gpqa_Biology.jsonl
)

out_dir="./results"
mkdir -p "$out_dir"

model_path=your_model_path_for_Deepseek-R1
domain=math
expert_configs=(
    "29:126;39:182"  # math 
)


batch_size=30
temperature=0
n=1
steers=(
    64
    )

for data_file in "${data_paths[@]}"; do
    for mask_experts in "${expert_configs[@]}"; do
        for steer in "${steers[@]}"; do
            for log in "${log[@]}"; do
                base_name=$(basename "$data_file" | sed 's/\.jsonl$//;s/\.json$//')
                mask_info=""
                if [ -n "$mask_experts" ]; then
                    mask_info=f"masked_steer${steer}"
                    IFS=';' read -ra layer_configs <<< "$mask_experts"
                    for layer_config in "${layer_configs[@]}"; do
                        IFS=':' read -r layer_idx experts <<< "$layer_config"
                        mask_info+="L${layer_idx}-${experts}_"
                    done
                    mask_info=${mask_info%_}  
                else
                    mask_info="normal"
                    domain=R1
                fi
                log_path="${out_dir}/${domain}_${base_name}_${mask_info}_bs${batch_size}_n${n}_log${log}.log"

                
                echo "Processing $data_file..."
                echo "Log will be saved to: $log_path"
                
                python intervention.py \
                    --model_name_or_path $model_path \
                    --temperature $temperature \
                    --n $n \
                    --batch_size $batch_size \
                    --add_chat_template \
                    --max_tokens 32768 \
                    --steer $steer \
                    --data_path "$data_file" \
                    --domain "$domain" \
                    --mask_experts "$mask_experts" \
                    --output_dir $out_dir | tee "$log_path" 
                
                echo "Finished processing $data_file"
            done
        done
    done
done
