#!/bin/bash
# Unified experiment script for both LoCoOp and CoOp

DATA=$1
DATASET=$2
CFG=$3  # config file
CTP=$4  # class token position (end or middle)
NCTX=$5  # number of context tokens
SHOTS=$6  # number of shots (1, 2, 4, 8, 16)
CSC=$7  # class-specific context (False or True)
lambda=$8
topk=$9
METHOD=${10:-locoop}  # default to locoop if not specified

# Set trainer based on method
if [ "$METHOD" = "coop" ]; then
    TRAINER=LoCoOp
    OUTPUT_DIR=output/${DATASET}/CoOp/${CFG}_${SHOTS}shots/nctx${NCTX}_csc${CSC}_ctp${CTP}/seed1
else
    TRAINER=LoCoOp
    OUTPUT_DIR=output/${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/nctx${NCTX}_csc${CSC}_ctp${CTP}/seed0
fi

echo "Running experiment with method: $METHOD"
echo "Output directory: $OUTPUT_DIR"

python experiment.py \
    --root ${DATA} \
    --seed 1 \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/LoCoOp/${CFG}.yaml \
    --output-dir ${OUTPUT_DIR} \
    --lambda_value ${lambda} \
    --topk ${topk} \
    --method ${METHOD} \
    TRAINER.LOCOOP.N_CTX ${NCTX} \
    TRAINER.LOCOOP.CSC ${CSC} \
    TRAINER.LOCOOP.CLASS_TOKEN_POSITION ${CTP} \
    DATASET.NUM_SHOTS ${SHOTS} 