#!/usr/bin/env python3

import argparse
import sys

def test_arg_parsing():
    parser = argparse.ArgumentParser(
        description="Test improved NPT experiment arguments"
    )
    parser.add_argument(
        "--output-dir", 
        type=str, 
        required=True,
        help="Path to output directory where results will be saved"
    )
    
    # Improved NPT specific arguments
    parser.add_argument(
        "--max-grad-norm",
        type=float,
        default=1.0,
        help="Maximum gradient norm for clipping (default: 1.0)"
    )
    parser.add_argument(
        "--base-weight-decay",
        type=float,
        default=1e-4,
        help="Base weight decay value (default: 1e-4)"
    )
    parser.add_argument(
        "--grad-norm-scale-factor",
        type=float,
        default=0.1,
        help="Scaling factor for adaptive weight decay (default: 0.1)"
    )
    
    args = parser.parse_args()
    
    print(f"Arguments parsed successfully:")
    print(f"  Output dir: {args.output_dir}")
    print(f"  Max grad norm: {args.max_grad_norm}")
    print(f"  Base weight decay: {args.base_weight_decay}")
    print(f"  Grad norm scale factor: {args.grad_norm_scale_factor}")

if __name__ == "__main__":
    test_arg_parsing()