#!/usr/bin/env python3
"""
Quick validation script for proposed_method.py
"""

import sys
import os

def validate_syntax():
    """Check if proposed_method.py has valid syntax"""
    print("Validating proposed_method.py syntax...")
    
    try:
        # Try to compile the file
        with open('proposed_method.py', 'r') as f:
            source = f.read()
        
        compile(source, 'proposed_method.py', 'exec')
        print("✓ Syntax validation passed")
        return True
        
    except SyntaxError as e:
        print(f"✗ Syntax error: {e}")
        return False
    except Exception as e:
        print(f"✗ Validation error: {e}")
        return False

def validate_imports():
    """Check if we can import key components from proposed_method"""
    print("Validating imports...")
    
    try:
        # Import the main functions
        sys.path.insert(0, '.')
        from proposed_method import NPTExperiment, run_npt_experiment, extend_cfg, reset_cfg
        print("✓ Main components imported successfully")
        return True
        
    except ImportError as e:
        print(f"✗ Import error: {e}")
        return False
    except Exception as e:
        print(f"✗ Validation error: {e}")
        return False

def main():
    print("Proposed Method Validation")
    print("=" * 30)
    
    # Check file exists
    if not os.path.exists('proposed_method.py'):
        print("✗ proposed_method.py not found")
        return False
        
    # Validate syntax
    if not validate_syntax():
        return False
        
    # Validate imports
    if not validate_imports():
        return False
        
    print("=" * 30)
    print("✅ proposed_method.py validation passed!")
    print("The script is ready for execution.")
    return True

if __name__ == "__main__":
    success = main()
    sys.exit(0 if success else 1)