## Creating the data for the experiments

This subdirectory contains the code to reproduce the experiments of the paper.
- `clevr/`: [CLEVR and CoGenT Datasets](https://cs.stanford.edu/people/jcjohns/clevr/):
    - download data from the source and place it in `clevr/data`
    - `clevr/scripts/create.sh` performs instance segmentation and feature extraction.
- `credit/`: [CREDIT Dataset](https://www.kaggle.com/datasets/mlg-ulb/creditcardfraud):
    - download data from the source and place the csv in `credit/data`
    - evaluate `credit/credit.ipynb`
- `wine/`: [WINE Dataset](https://archive.ics.uci.edu/dataset/186/wine+quality):
    - download data from the source and place the csv's in `wine/data`
    - evaluate `wine/wine.ipynb`

## Installation
We provide a `conda` environment file `environment.yml` that can be used to re-create our `python` environment and create the figures.
The file explicitely lists all the dependencies required for running our tool.

To create the environment, run:
```shell
conda env create -f environment.yml
```