def normalise_val_in_range(x, a, b):
    return (x - a) / (b - a)


def normalise_val(attr, val):
    match attr:
        case "xpos":
            min1, max1 = 0, 480
        case "ypos":
            min1, max1 = 0, 320
        case "width":
            min1, max1 = 0, 320
        case "height":
            min1, max1 = 0, 480
        case "angle":
            min1, max1 = 0, 90
        case "corners":
            min1, max1 = 3, 8
        case "area":
            min1, max1 = 0, 153600 / 4
        case "relative-area":
            min1, max1 = 0, 1
        case "bb-area":
            min1, max1 = 0, 153600 / 4
        case "bb-area-ratio":
            min1, max1 = 0, 1
        case "wh-ratio":
            min1, max1 = 0, 1
        case "circle-distance":
            min1, max1 = 0, 1
        case "white-level":
            min1, max1 = 0, 1
        case "black-level":
            min1, max1 = 0, 1
        case "lab-mean-l":
            min1, max1 = 0, 100
        case "lab-mean-a":
            min1, max1 = -128, 127
        case "lab-mean-b":
            min1, max1 = -128, 127
        case "lab-std-l":
            min1, max1 = 0, 100
        case "lab-std-a":
            min1, max1 = -128, 127
        case "lab-std-b":
            min1, max1 = -128, 127
        case "rgb-mean-r":
            min1, max1 = 0, 1
        case "rgb-mean-g":
            min1, max1 = 0, 1
        case "rgb-mean-b":
            min1, max1 = 0, 1
        case "rgb-std-r":
            min1, max1 = 0, 1
        case "rgb-std-g":
            min1, max1 = 0, 1
        case "rgb-std-b":
            min1, max1 = 0, 1

    normalised_val = normalise_val_in_range(val, min1, max1)
    return max(0, min(1, normalised_val))
