# How to Contribute

We'd love to accept your patches and contributions to this project. There are
just a few small guidelines you need to follow.

## Contributor License Agreement

Contributions to this project must be accompanied by a Contributor License
Agreement. You (or your employer) retain the copyright to your contribution;
this simply gives us permission to use and redistribute your contributions as
part of the project.

You generally only need to submit a CLA once, so if you've already submitted one
(even if it was for a different project), you probably don't need to do it
again.

## The Contribution Process

The basic workflow is:

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

With multiple contributors and the desire to maintain high quality
code, we need a small bit of process. For example all submissions,
including submissions by project members, require review. We use
GitHub pull requests for this purpose. Consult [GitHub
Help](https://help.github.com/articles/about-pull-requests/) for more
information on using pull requests, and the [contributing
code](https://lisp-stat.dev/docs/contributing/code/) page for more
details.

## Community Guidelines

This project follows a code of conduct that can be found on the
[contributing](https://www.lisp-stat.dev/docs/contributing/) page.

## How to contribute

See the [contribution
guidelines](https://www.lisp-stat.dev/docs/contributing/)
in the Lisp-Stat user guide.
