#!/bin/bash

python scripts/subplot.py \
    --plot-type multi \
    --exp-dir storage/experiments/$1 \
    --monitors communicative-success lexicon-coherence unique-form-usage \
    --average-windows 1000 \
    --window-type "standard" \
    --use-y-axis 1 1 2 \
    --y1-min 0 --y1-max 1 \
    --key-location "best" \
    --x-label "Number of Games" \
    --y1-label "Communicative success / Linguistic coherence"  \
    --y2-label "Average inventory size" \
    --error-bar-modes "filled" \
    --every-x-interactions 100 \
    --graphic-type "pdf" \
    --export --dashed