## Running the experiments

This subdirectory contains the code to reproduce the experiments of the paper.
The code for the multi-agent simulations is written in Common Lisp and requires `sbcl` and `quickload`.
This `/exp` directory consists of two subdirectories: `libs/` and `cle/`.

### 1. CLE : Multi-agent experiments

The `\cle` directory groups all code written for the authors to run the multi-agent experiments/simulations.

Quickstart:
- `params/` contains two csv's with all experiments (and their hyperparameters) of the paper
- `experiments/create_train.py` and `experiments/create_test.py` enables to create a shell script for each experiment
- Then, run experiment by running the respective script
    ```shell
    bash scripts/<exp_name>.sh
    ```
- By default, a `logging` directory is created, where checkpoints and logs are stored.

#### LIBS: Usage of existing Libraries

The `libs/` contains five forked (i.e. existing) Common Lisp packages:
- [cl-json](https://cl-json.common-lisp.dev/cl-json.html)
- [experiment-framework, monitors, utils](https://emergent-languages.org/)
- [distributions](https://lisp-stat.dev/docs/manuals/distributions/)