(in-package :asdf)

(defsystem :cle
  :depends-on (:utils
               :monitors
               :experiment-framework
               :cl-mop
               :cl-json
               :cl-jonathan
               :distributions
               :cl-ppcre
               :jonathan
               )
  :serial t
  :components ((:file "package")
               (:module "dataset"
                :serial t
                :components ((:file "all")
                             (:file "clevr")
                             (:file "wine")
                             (:file "credit")
                             (:file "beans")
                             ))
               (:module "world"
                :serial t
                :components ((:file "world")
                             (:file "object")
                             (:file "scene")
                             (:file "topic")
                             (:file "utils")
                             ))
               (:module "agent"
                :serial t
                :components ((:file "utils")
                             (:file "agent")
                             (:file "adoption")
                             (:file "alignment")
                             (:file "invention")
                             (:file "conceptualisation")
                             (:file "interpretation")
                             (:file "parsing")
                             (:file "production")
                             ))
               (:module "prototype"
                :serial t
                :components ((:file "prototype")
                             (:file "update")))
               (:module "concept"
                :serial t
                :components ((:file "concept")
                             (:file "shift")
                             (:file "similarity")))
               (:module "construction"
                :serial t
                :components ((:file "construction")
                             (:file "competitors")
                             (:file "update")))
               (:module "distribution"
                :serial t
                :components ((:file "gaussian")
                             (:file "welford")
                             (:file "divergence")
                             ))
               (:module "interaction"
                :serial t
                :components ((:file "experiment")
                             (:file "determine-agents")
                             (:file "before")
                             (:file "during")
                             (:file "after")
                             (:file "run")
                             (:file "switch")))
               (:module "utils"
                :serial t
                :components ((:file "decode")
                             (:file "utils")))
               (:module "web"
                :serial t
                :components ((:file "monitors")))))
