(in-package :cle)

;; -----------------------
;; + Update distribution +
;; -----------------------

(defmethod update-prototype ((new-observation number)
                             (interaction-number number)
                             (prototype prototype)
                             &key (save-distribution-history nil)
                             &allow-other-keys)
  "Update the distribution of a prototype."
  ;; update distribution
  (update-distribution new-observation (distribution prototype)))

;; ------------------
;; + Update weights +
;; ------------------
(defgeneric update-weight (prototype delta mode &key &allow-other-keys)
  (:documentation "Method by which to adjust the weight of a feature channel."))

(defmethod update-weight (prototype delta (mode (eql :standard))
                                    &key
                                    (lower-bound 0.0)
                                    (upper-bound 1.0))
  "Standard update with a delta value."
  ;; update the weight
  (setf (weight-val prototype) (+ (weight-val prototype) delta))
  ;; check the boundaries
  (when (> (weight-val prototype) upper-bound)
    (setf (weight-val prototype) upper-bound))
  (when (<= (weight prototype) lower-bound)
    (setf (weight-val prototype) lower-bound)))

(defmethod update-weight (prototype reward (mode (eql :j-interpolation)) &key)
  "Apply the j-interpolation update rule to the weight of a specified channel of a given concept."
  (let* ((old-value (weight-val prototype)))
    (setf (weight-val prototype) (+ old-value reward))))
