(in-package :cle)


;; ---------------------
;; + World - load file +
;; ---------------------

(defmethod load-scene (fpath available-channels)
  "Load a scene from filepath."
  (let* ((dataset (fifth (pathname-directory fpath)))
         (split (seventh (pathname-directory fpath)))
         (s-expr (decode-json-as-alist-from-source fpath)))
    (s-expr->cle-scene s-expr
                       :dataset dataset
                       :dataset-split split
                       :available-channels available-channels)))

;; ---------------------
;; + World - get scene +
;; ---------------------
(defmethod get-scene-by-index ((world dataset-world) index)
  "Get a particular scene by its index."
  (assert (and (>= index 0) (< index (length (scenes world)))))
  (setf (current-scene world)
        (load-scene (nth index (scenes world))
                    (available-channels world)))
  (current-scene world))

(defmethod random-scene ((world dataset-world))
  "Choose a random scene and load it into memory."
  (setf (current-scene world) (load-scene (random-elt (scenes world))
                                          (available-channels world)))
  (current-scene world))