#!/bin/bash

python scripts/plot.py --exp-dir storage/experiments/$1 \
    --monitors communicative-success lexicon-coherence unique-form-usage \
    --captions "Communicative success" "Linguistic coherence" "Average inventory size" \
    --average-windows 1000 \
    --window-type "standard" \
    --use-y-axis 1 1 2 \
    --y1-min 0 --y1-max 1 --y2-max 200 \
    --plot-type single \
    --key-location "lower left" \
    --x-label "Number of Games" \
    --y1-label "Communicative success / Linguistic coherence"  \
    --y2-label "Average inventory size" \
    --error-bar-modes "filled" \
    --every-x-interactions 100 \
    --graphic-type "pdf" \
    --export --dashed