import json
import numpy as np
import os

data_root = os.environ.get("DATA_ROOT")
project_root = os.environ.get("PROJECT_ROOT")

def analyze_column_averages():
    # Read the JSON file
    with open(f'{project_root}/src/code/cot_split/results/simple_split/math_qwen7b_3_4,4_prm_20_agent/data.json', 'r') as f:
        data = json.load(f)
    
    # Get column_averages
    column_averages = data['column_averages']
    
    # Calculate statistics
    mean_value = np.mean(column_averages)
    max_value = np.max(column_averages)
    
    # Split array into two halves and calculate means
    mid_point = len(column_averages) // 2
    first_half = column_averages[:5]
    second_half = column_averages[mid_point:]
    
    first_half_mean = np.mean(first_half)
    second_half_mean = np.mean(second_half)
    
    print(f"Overall mean of column_averages: {mean_value:.4f}")
    print(f"Maximum of column_averages: {max_value:.4f}")
    print(f"First half mean: {first_half_mean:.4f}")
    print(f"Second half mean: {second_half_mean:.4f}")

if __name__ == "__main__":
    analyze_column_averages()
