def check_text_type(text):
    cal = 0
    veri = 0
    
    text = text.lower()

    calc_keywords = ['calculating', 'calculater', 'compute']
    for keyword in calc_keywords:
        if keyword in text:
            cal = 1
            break
    
    verify_keywords = ['check', 'verify', 'confirm']
    for keyword in verify_keywords:
        if keyword in text:
            veri = 1
            break
    
    if 'correct' in text:
        idx = text.find('correct')
        if idx + 7 < len(text) and text[idx + 7] == '?':
            veri = 1
    
    calve = cal * veri
    seek = 1 if (cal == 0 and veri == 0) else 0
    calon = cal - calve
    verion = veri - calve
    
    return calon, verion, calve, seek

# def check_single_word(text):
#     text = text.lower()
#     calc_keywords = ['calculating', 'calculater', 'compute']
#     verify_keywords = ['check', 'verify', 'confirm']
#     for keyword in calc_keywords:
#         if keyword in text:
#             return "calc"
#     for keyword in verify_keywords:
#         if keyword in text:
#             return "verify"
#     return "normal"
def check_single_dewey(text):
    text = text.lower()
    
    problem_keywords = ['recall', 'define', 'since', 'condition', 'theorem', 'inequality', 'obtuse', 'triangle']
    computation_keywords = ['compute', 'calculate', 'formula', 'integral', '∫', '=', '+', '-', '*', '/', '√', 'sin', 'cos', '[']
    verification_keywords = ['check', 'verify', 'inconsistent', 'actually', 'hold on', 'error', 'doubt', '?', 'how', 'whether', 'confirm', 'correct']
    
    # for keyword in conclusion_keywords:
    #     if keyword in text:
    #         return "conclusion"
            
    for keyword in computation_keywords:
        if keyword in text:
            return "computation"
            
    for keyword in verification_keywords:
        if keyword in text:
            return "verification"
            
    for keyword in problem_keywords:
        if keyword in text:
            return "problem_formulation"

    return "normal"

def dewey_what_text_type(text):
    text = text.lower()
    
    keywords = {
        # "problem_formulation": ['recall', 'define', 'since', 'condition', 'theorem', 'inequality', 'obtuse', 'triangle'],
        # "computation": ['compute', 'calculate', 'formula', 'integral', '∫', '=', '+', '-', '*', '/', '√', 'π', 'pi', 'sin', 'cos', '[', ']'],
        # "verification": ['check', 'verify', 'inconsistent', 'but', 'however', 'actually', 'hold on', 'error', 'doubt', 'approx', '≈', '?', 'why', 'how', 'whether', 'confirm', 'correct'],
        # # "conclusion": ['therefore', 'thus', 'conclude', 'final answer', 'answer', 'result', 'boxed', '\\box', 'output', 'solution', 'hence', 'thus', 'finally']
        "problem_formulation": ['recall', 'define', 'since', 'condition', 'theorem', 'inequality', 'obtuse', 'triangle'],
        "computation": ['compute', 'calculate', 'formula', 'integral', '∫', '=', '+', '-', '*', '/', '√', 'sin', 'cos', '['],
        "verification": ['check', 'verify', 'inconsistent', 'actually', 'hold on', 'error', 'doubt', '?', 'how', 'whether', 'confirm', 'correct'],
        # "conclusion": ['therefore', 'thus', 'conclude', 'final answer', 'answer', 'result', 'boxed', '\\box', 'output', 'solution', 'hence', 'thus', 'finally
    }
    
    positions = {}
    for category, words in keywords.items():
        for word in words:
            pos = text.find(word)
            if pos != -1: 
                positions[category] = min(pos, positions.get(category, float('inf')))
    
    if positions:
        return min(positions.items(), key=lambda x: x[1])[0]
    return "problem_formulation"

def dewey_text_type(text):
    text = text.lower()
    
    keywords = {
        "problem_formulation": ['recall', 'define', 'since', 'condition', 'theorem', 'inequality', 'obtuse', 'triangle'],
        "computation": ['compute', 'calculate', 'formula', 'integral', '∫', '=', '+', '-', '*', '/', '√', 'sin', 'cos', '['],
        "verification": ['check', 'verify', 'inconsistent', 'actually', 'hold on', 'error', 'doubt', '?', 'how', 'whether', 'confirm', 'correct'],
        # "conclusion": ['therefore', 'thus', 'conclude', 'final answer', 'answer', 'result', 'boxed', '\\box', 'output', 'solution', 'hence', 'thus', 'finally']
    }
    
    positions = {}
    detected_words = {}
    for category, words in keywords.items():
        for word in words:
            pos = text.find(word)
            if pos != -1: 
                if category not in positions or pos < positions[category]:
                    positions[category] = pos
                    detected_words[category] = word
    
    if positions:
        best_category = min(positions.items(), key=lambda x: x[1])[0]
        return best_category, detected_words[best_category]
    return "problem_formulation", "normal"