#!/bin/bash
#SBATCH --job-name=PPO-f
#SBATCH --partition=CLUSTER
#SBATCH -t 7-00:00

### e.g. request 2 nodes with 1 gpu each, totally 2 gpus (WORLD_SIZE==2)
### Note: --gres=gpu:x should equal to ntasks-per-node
#SBATCH --nodelist=compute-0-2
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=20
#SBATCH --mem-per-cpu=1GB
#SBATCH -o ./output/%x-%j.out
#SBATCH -e ./output/%x-%j.err


module load python/anaconda3
module load cuda/cuda-11.4
source activate tf_tc

n_views="3"
agent_case="1 2 3 4"
sampling_var="0.1"

for v in $n_views
do
  for ac in $agent_case
    do
      for sv in $sampling_var
      do
        python CV_QC_finite_shot_test.py \
        --n-views $v \
        --num-steps 512 \
        --agent-case $ac \
        --action-step 0.3 \
        --sampling-var $sv \
        --learning-rate 8e-4 \
        --num-minibatches 4 \
        --seed 10
      done
    done
done