#!/bin/bash
#SBATCH --job-name=PPO-ft
#SBATCH --partition=CLUSTER
#SBATCH -t 7-00:00

### e.g. request 2 nodes with 1 gpu each, totally 2 gpus (WORLD_SIZE==2)
### Note: --gres=gpu:x should equal to ntasks-per-node
#SBATCH --nodelist=compute-0-2
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=20
#SBATCH --mem-per-cpu=1GB
#SBATCH -o ./output/%x-%j.out
#SBATCH -e ./output/%x-%j.err


module load python/anaconda3
module load cuda/cuda-11.4

source activate tf_tc

n_views="3"
agent_case="1 2 3 4"
sampling_var="0.1"



for v in $n_views
do
  for sv in $sampling_var
  do
      for tc in $agent_case
      do
        python main_CV_alpha_01_decay_case1_finite_shot.py \
        --n-views $v \
        --num-steps 512 \
        --action-step 0.3 \
        --sampling-var $sv \
        --agent-case $tc \
        --learning-rate 8e-4 \
        --num-minibatches 4 \
        --seed 42 \
        --total-timesteps 50000 \
        --anneal-lr True \
        --max-grad-norm 0.5
      done
    done
done