# AdaptDel: Adaptable Deletion Rate Randomized Smoothing for Certified Robustness

## 📝 Abstract
We consider the problem of certified robustness for sequence classification against edit distance perturbations. Naturally occurring inputs of varying lengths (e.g., sentences in natural language processing tasks) present a challenge to current methods that employ fixed-rate deletion mechanisms and lead to suboptimal performance. To this end, we introduce AdaptDel methods with adaptable deletion rates that dynamically adjust based on input properties. We extend the theoretical framework of randomized smoothing to variable-rate deletion, ensuring sound certification with respect to edit distance. We achieve strong empirical results in natural language tasks, observing up to 30 orders of magnitude improvement to median cardinality of the certified region, over SotA certifications.

---

## 📂 Directory Structure

```plaintext
.
├── config
│   ├── certify                       # Sample configurations for certification experiments
│   ├── train                         # Sample configurations for training experiments
│   └── plot                          # Sample configurations for plotting experimental results
├── outputs                           # Directory for experimental outputs
├── scripts                           # Shell scripts for running various steps
│   ├── certify-vardel.sh             # Sample script for running certification on the Roberta model
│   ├── plot-vardel.sh                # Sample script for plotting the certified results
│   └── train-vardel.sh               # Sample script for training the Roberta model
├── src                               # Source code directory
│   ├── certification                 # Package for certification mechanisms and utilities
│   │   └── Various certification scripts (e.g., var_del_mech, edit_certs, masking_mech, smoothed_classifier) 
│   ├── certify.py                    # Main script for the certification process, called by main.py
│   ├── main.py                       # Main entry point for training, rate optmization, certifying, and plotting
│   ├── train.py                      # Script for training models, called by main.py
│   └── visualization.py              # Script for visualization tasks, called by main.py

```

---

## 🚀 Reproducing Experiments

### Environment Setup

Before running any experiments, set up the virtual environment using Pipenv:

```bash
pipenv install
```

### 1. **Model Training**

- Train the smoothed model via `main.py` with `--mode train`.
- Example: See `scripts/train-vardel.sh`.

```bash
pipenv run python main.py --mode train --config_path config/train/$CONFIG_FILE.yaml --override_config
```

### 2. **Optimize AdaptDel+ Rates**

- Perform golden search to optimize AdaptDel+ rates via `main.py` with `--mode optimize_rate`.
- Example: See `scripts/optimize-vardel.sh`.

```bash
pipenv run python main.py --mode optimize_rate --config_path config/optimize_rate/$CONFIG_FILE.yaml --override_config
```

### 3. **Prediction and Certification**

- Save base model confidence scores and compute the certified radius via `main.py` with `--mode certify`.
- Example: See `scripts/certify-vardel.sh`.

```bash
pipenv run python main.py --mode certify --config_path config/certify/$CONFIG_FILE.yaml --override_config
```

### 4. **Visualization**

- Generate certified accuracy visualizations for the results via `main.py` with `--mode plot`.

```bash
pipenv run python main.py --mode plot --config_path config/plot/$CONFIG_FILE.yaml --override_config
```

### Custom Experiments

- You can customize and run your own experiments by defining your own configuration `.yaml` files. Place your custom configuration file in the appropriate `config` subdirectory (`train`, `certify`, `optimize_rate`, or `plot`), and use it with the respective command.

```bash
pipenv run python main.py --mode <mode> --config_path config/<subdir>/$YOUR_CUSTOM_CONFIG.yaml --override_config
```

Replace `<mode>` with one of `train`, `certify`, `optimize_rate`, or `plot` and `<subdir>` with the corresponding subdirectory (`train`, `certify`, `optimize_rate`, `plot`).

## 📊 Datasets

The NLP datasets used in our experiments are automatically downloaded from Hugging Face and the AdvBench repository.
