We compare BETA with our proposed framework SODA on CIFAR-10-C and CIFAR-100-C.

## Datasets

Please download and organize [CIFAR-10-C][https://zenodo.org/record/2535967/files/CIFAR-10-C.tar?download=1]  and [CIFAR-100-C][https://zenodo.org/record/3555552/files/CIFAR-100-C.tar?download=1] in this structure:

```
BETA
├── data
    ├──CIFAR-10
    │   ├── CIFAR-10-C
    │   │   ├── brightness.npy
    │   │   ├── contrast.npy
    │   │   ├── ...
    │   │   ├── labels.npy
    ├──CIFAR-100
    │   ├── CIFAR-100-C
    │   │   ├── brightness.npy
    │   │   ├── contrast.npy
    │   │   ├── ...
    │   │   ├── labels.npy 
```

## Pre-trained Models

The checkpoints of pre-trained Resnet-50 can be downloaded (197MB) using the following command:

```
mkdir -p results/cifar10_joint_resnet50 && cd results/cifar10_joint_resnet50
gdown https://drive.google.com/uc?id=1MZN19o-5b2w-BI1ObIlnsJ8XBZvMuL77 && cd ../..
mkdir -p results/cifar100_joint_resnet50 && cd results/cifar100_joint_resnet50
gdown https://drive.google.com/uc?id=1C7knE2S9kKDYZrqd4Bo4S5lOgp7Le_DP && cd ../..
```

These models are obtained by training on the clean CIFAR10/100 images using [semi-supervised SimCLR](https://github.com/YuejiangLIU/semi-simclr).

## Train on CIFAR-10-C

```
bash scripts/run_beta_cifar10c.sh
```

## Train on CIFAR-100-C

```
bash scripts/run_beta_cifar100c.sh
```

