device = 0

# model
num_classes = 10
tgt_model = dict(type='ResNet', depth=50, num_classes=num_classes)
tgt_head = dict(type='BottleNeckMLP', feature_dim=2048, bottleneck_dim=256, num_classes=num_classes,
                type1='bn', type2='wn')
loss = dict(
    test=dict(type='CrossEntropyLoss'),
)

# data
corruption, level = 'gaussian_noise', 5
info_path = './data'
batch_size = 256
num_workers = 4
mean = (0.4914, 0.4822, 0.4465)
std = (0.2023, 0.1994, 0.2010)
data = dict(
    train=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='test'
        ),
        trans_dict=dict(
            type='cifar_test',
            mean=mean, std=std,
        )
    ),
    test=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='test'
        ),
        trans_dict=dict(
            type='cifar_test',
            mean=mean, std=std,
        )
    ),
)


# training optimizer & scheduler
epochs = 30
lr = 0.01
optimizer = dict(type='SGD', lr=lr, momentum=0.9, weight_decay=1e-3, nesterov=True)

# log & save
log_interval = 100
work_dir = None
resume = None
load = f'./checkpoints/cifar10/{corruption}/last.pth'
port = 10001
