device = 0

# model
num_classes = 10
src_model = dict(type='ResNet50', args=None, num_classes=num_classes)
tgt_model = dict(type='ResNet', depth=50, num_classes=num_classes, pretrained=True)
tgt_head = dict(type='BottleNeckMLP', feature_dim=2048, bottleneck_dim=256, num_classes=num_classes,
                type1='bn', type2='wn')

# DivideMix hyper-parameters
lam_u, lam_p, lam_t = 0., 1.0, 0.1
T_sharpen = 0.5
alpha = 1.0
tau_p = 0.8

# DINE hyper-parameters
ema = 0.6
lam_mix = 1.0
topk = 1

loss = dict(
    train=dict(type='SemiLoss') if lam_u > 0 else dict(type='SmoothCE'),
    test=dict(type='CrossEntropyLoss'),
)

# data
corruption, level = 'gaussian_noise', 5
train_val_split = 1
info_path = './data/CIFAR-10'
test_class_acc = True

batch_size = 256
num_workers = 4
mean = (0.4914, 0.4822, 0.4465)
std = (0.2023, 0.1994, 0.2010)
data = dict(
    warmup=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='warmup'
        ),
        trans_dict=dict(
            type='CifarMultiView', views='t',
            mean=mean, std=std,
        )
    ),
    eval_train=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='eval_train'
        ),
        trans_dict=dict(
            type='CifarMultiView', views='t',
            mean=mean, std=std
        )
    ),
    label=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='label'
        ),
        trans_dict=dict(
            type='CifarMultiView', views='ws',
            mean=mean, std=std
        )
    ),
    unlabel=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='unlabel'
        ),
        trans_dict=dict(
            type='CifarMultiView', views='ws',
            mean=mean, std=std
        )
    ),
    test=dict(
        ds_dict=dict(
            type='SubCifar10C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='test'
        ),
        trans_dict=dict(
            type='CifarMultiView', views='t',
            mean=mean, std=std
        )
    ),
)

# training optimizer & scheduler
epochs = 120
warmup_epochs = 1
rampup_epochs = 0
lr = 0.01
optimizer = dict(type='SGD', lr=lr, momentum=0.9, weight_decay=1e-3, nesterov=True)

# log & save
log_interval = 10
test_interval = 10
pred_interval = epochs // 10
work_dir = None
resume = None
load = './results/cifar10_joint_resnet50/joint_resnet50.pth'
port = 10001
