device = 1

# model
num_classes = 100
tgt_model = dict(type='ResNet', depth=50, num_classes=num_classes)
tgt_head = dict(type='BottleNeckMLP', feature_dim=2048, bottleneck_dim=256, num_classes=num_classes,
                type1='bn', type2='wn')
loss = dict(
    test=dict(type='CrossEntropyLoss'),
)

# data
corruption, level = 'gaussian_noise', 5
info_path = './data/CIFAR-100'
batch_size = 256
num_workers = 4
mean = (0.5070751592371323, 0.48654887331495095, 0.4409178433670343)
std = (0.2673342858792401, 0.2564384629170883, 0.27615047132568404)
data = dict(
    train=dict(
        ds_dict=dict(
            type='SubCifar100C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='test'
        ),
        trans_dict=dict(
            type='cifar_test',
            mean=mean, std=std,
        )
    ),
    test=dict(
        ds_dict=dict(
            type='SubCifar100C',
            info_path=info_path,
            corruption=corruption,
            level=level,
            mode='test'
        ),
        trans_dict=dict(
            type='cifar_test',
            mean=mean, std=std,
        )
    ),
)


# training optimizer & scheduler
epochs = 30
lr = 0.01
optimizer = dict(type='SGD', lr=lr, momentum=0.9, weight_decay=1e-3, nesterov=True)

# log & save
log_interval = 100
work_dir = None
resume = None
load = f'./checkpoints/cifar100/{corruption}/last.pth'
port = 10001
