from pathlib import Path
from typing import List


class CSVWriter(object):

    def __init__(self, csv_path: Path, metric_names: List[str]):
        self.csv_path = csv_path

        header = ",".join(metric_names)
        with open(self.csv_path, "w", encoding="utf-8") as csv_file:
            csv_file.write(header + "\n")

    def write(self, metrics: List):
        line = ",".join([str(metric) for metric in metrics])
        with open(self.csv_path, "a", encoding="utf-8") as csv_file:
            csv_file.write(line + "\n")
