from gym.envs.registration import register

from .robot_manipulation_env import RobotManipulationEnv

ROBOTS = ["Sawyer", "Panda", "UR5e", "Kinova3", "IIWA", "Jaco"]

for robot_name in ROBOTS:
    # print(f"Registered {robot_name}-Lift-v1.")
    register(
        id=f"{robot_name}-Lift-v1",
        entry_point=RobotManipulationEnv,
        max_episode_steps=120,
        kwargs={
            "env_name": "Lift",
            "robots": robot_name,
            "keys": [
                "robot0_proprio-state",
                # "object-state",
            ],
            "image_observation": False,
        },
    )

    register(
        id=f"{robot_name}-Stack-v1",
        entry_point=RobotManipulationEnv,
        max_episode_steps=180,
        kwargs={
            "env_name": "Stack",
            "robots": robot_name,
            "keys": [
                "robot0_proprio-state",
                # "object-state",
            ],
            "image_observation": False,
        },
    )