SELECT movie_title FROM movies WHERE movie_release_year = 1945 ORDER BY movie_popularity DESC LIMIT 1	movie_platform
SELECT movie_title, movie_release_year, director_name FROM movies ORDER BY movie_popularity DESC LIMIT 1 	movie_platform
SELECT movie_title, movie_release_year FROM movies ORDER BY LENGTH(movie_popularity) DESC LIMIT 1	movie_platform
SELECT movie_title FROM movies GROUP BY movie_title ORDER BY COUNT(movie_title) DESC LIMIT 1	movie_platform
SELECT AVG(movie_popularity) FROM movies WHERE director_name = 'Stanley Kubrick'	movie_platform
SELECT AVG(T2.rating_score) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_title = 'When Will I Be Loved'	movie_platform
SELECT T3.user_avatar_image_url, T3.rating_date_utc FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id INNER JOIN ratings_users AS T3 ON T3.user_id = T2.user_id WHERE T3.user_id = 41579158 ORDER BY T3.rating_date_utc DESC LIMIT 1	movie_platform
SELECT CAST(SUM(CASE WHEN user_subscriber = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM ratings	movie_platform
SELECT T1.movie_title FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T2.user_trialist = 1 AND T2.rating_timestamp_utc LIKE '2020-04%'	movie_platform
SELECT T1.user_id FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'Love Will Tear Us Apart' AND T1.rating_score = 1	movie_platform
SELECT DISTINCT T2.movie_title, T2.movie_popularity FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_score = 5	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE CAST(SUBSTR(T1.rating_timestamp_utc, 1, 4) AS INTEGER) = 2020 AND CAST(SUBSTR(T1.rating_timestamp_utc, 6, 2) AS INTEGER) > 4	movie_platform
SELECT T2.movie_title, T1.user_id, T1.rating_score, T1.critic FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.critic IS NOT NULL	movie_platform
SELECT CAST(SUM(CASE WHEN T2.rating_score = 5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_title = 'Welcome to the Dollhouse'	movie_platform
SELECT CAST(SUM(CASE WHEN T1.movie_release_year = 2021 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id	movie_platform
SELECT director_name FROM movies WHERE movie_title = 'Sex, Drink and Bloodshed'	movie_platform
SELECT list_title FROM lists ORDER BY list_followers DESC LIMIT 1	movie_platform
SELECT list_url FROM lists WHERE list_update_timestamp_utc LIKE '2012%' AND list_followers BETWEEN 1 AND 2 ORDER BY list_update_timestamp_utc DESC LIMIT 1	movie_platform
SELECT list_id FROM lists_users WHERE user_id = 85981819 ORDER BY list_creation_date_utc ASC LIMIT 1	movie_platform
SELECT COUNT(*) FROM ratings WHERE movie_id = 1269 AND rating_score <= 2 AND user_eligible_for_trial = 1 AND user_has_payment_method = 1	movie_platform
SELECT movie_title, movie_popularity FROM movies WHERE movie_release_year = 2021 AND director_name = 'Steven Spielberg'	movie_platform
SELECT movie_release_year, director_name FROM movies WHERE movie_release_year IS NOT NULL ORDER BY movie_release_year ASC LIMIT 1	movie_platform
SELECT user_id FROM lists_users WHERE user_subscriber = 1 GROUP BY user_id HAVING MAX(SUBSTR(list_creation_date_utc, 1, 4)) - MIN(SUBSTR(list_creation_date_utc, 1, 4)) >= 10	movie_platform
SELECT COUNT(T2.user_id) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_title = 'Pavee Lackeen: The Traveller Girl' AND T2.rating_score = 4	movie_platform
SELECT T2.user_eligible_for_trial, T1.list_followers FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T1.user_id AND T1.list_id = T2.list_id WHERE T1.list_title = 'World War 2 and Kids'	movie_platform
SELECT T2.movie_release_year, T1.user_id FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_id = ( SELECT movie_id FROM movies WHERE director_name = 'Quentin Tarantino' ORDER BY movie_release_year ASC LIMIT 2, 1 ) AND T1.rating_score = 4	movie_platform
SELECT T2.director_url FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.user_id = 2452551 AND T1.critic_likes = 39	movie_platform
SELECT AVG(T1.rating_score), T2.director_name FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'When Will I Be Loved'	movie_platform
SELECT T1.list_movie_number, T2.user_has_payment_method FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id ORDER BY T1.list_movie_number DESC LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id ORDER BY T1.critic_likes DESC LIMIT 1	movie_platform
SELECT MAX(T2.movie_popularity), MIN(T1.rating_timestamp_utc) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year BETWEEN 1920 AND 1929 AND T1.rating_score = 1 AND T1.user_has_payment_method = 1	movie_platform
SELECT COUNT(T2.movie_title), T1.critic FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.director_name = 'Francis Ford Coppola' AND T2.movie_popularity > 1000	movie_platform
SELECT T2.user_avatar_image_url FROM ratings AS T1 INNER JOIN ratings_users AS T2 ON T1.user_id = T2.user_id WHERE T2.user_id = 1103 AND rating_score = 5 AND T2.rating_date_utc = '2020-04-19'	movie_platform
SELECT T1.list_followers, T2.user_subscriber = 1 FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T2.user_id AND T2.list_id = T2.list_id WHERE T2.user_id = 4208563 ORDER BY T1.list_followers DESC LIMIT 1	movie_platform
SELECT DISTINCT T1.movie_release_year, T1.movie_title FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_release_year = ( SELECT movie_release_year FROM movies GROUP BY movie_release_year ORDER BY COUNT(movie_id) DESC LIMIT 1 ) AND T2.rating_score = 1	movie_platform
SELECT COUNT(T2.user_id) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_release_year = 1924 AND T1.director_name = 'Erich von Stroheim' AND T2.rating_score = 5 AND T2.user_has_payment_method = 1	movie_platform
SELECT AVG(T1.list_movie_number), T2.user_avatar_image_url FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T2.user_id = 8516503	movie_platform
SELECT COUNT(T2.user_id), T2.rating_url FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_title = 'The Magnificent Ambersons' AND T2.rating_score <= 2	movie_platform
SELECT T1.list_followers FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T2.user_id AND T1.list_id = T2.list_id WHERE T2.list_creation_date_utc BETWEEN '2016-02-01' AND '2016-02-29' AND T2.user_eligible_for_trial = 1	movie_platform
SELECT T2.rating_url FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T2.user_id = 22030372 AND T2.rating_score = 5 AND T1.movie_title = 'Riff-Raff'	movie_platform
SELECT T2.director_name FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year BETWEEN 1960 AND 1985 GROUP BY T2.director_name HAVING COUNT(T2.movie_id) > 10	movie_platform
SELECT COUNT(T2.user_id) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T2.user_trialist = 0 AND T2.rating_score <= 2 AND T1.movie_title = 'The South'	movie_platform
SELECT T2.critic_likes FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T2.user_trialist = 0 AND T2.rating_score = 5 AND T1.movie_title = 'Apocalypse Now'	movie_platform
SELECT AVG(T2.rating_score), T1.director_name FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_title = 'The Crowd'	movie_platform
SELECT MIN(movie_release_year) FROM movies WHERE director_name = ( SELECT T2.director_name FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year BETWEEN 1960 AND 1985 GROUP BY T2.director_name ORDER BY COUNT(T2.director_name) DESC LIMIT 1 )	movie_platform
SELECT T1.movie_title, MAX(T2.rating_score) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T1.movie_popularity BETWEEN 400 AND 500 GROUP BY T1.movie_title	movie_platform
SELECT T2.rating_url FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T2.user_id = 45579900 AND T1.movie_title = 'The Vertical Ray of the Sun' AND T2.critic_likes = 20	movie_platform
SELECT AVG(T2.movie_popularity) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.director_name = 'Christopher Nolan'	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id INNER JOIN lists AS T3 ON T3.user_id = T1.user_id WHERE T1.rating_timestamp_utc BETWEEN '2013-01-01' AND '2013-12-31' AND T3.list_title = '100 Greatest Living American Filmmakers'	movie_platform
SELECT AVG(T1.rating_score), T2.movie_release_year FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'Pavee Lackeen: The Traveller Girl'	movie_platform
SELECT COUNT(*) FROM lists WHERE SUBSTR(list_update_timestamp_utc, 1, 4) - SUBSTR(list_creation_timestamp_utc, 1, 4) > 10	movie_platform
SELECT list_description FROM lists WHERE list_title = 'Short and pretty damn sweet'	movie_platform
SELECT list_url FROM lists WHERE list_title = 'Short and pretty damn sweet'	movie_platform
SELECT COUNT(*) FROM lists WHERE list_followers > 200 AND list_update_timestamp_utc > '2010-01-01'	movie_platform
SELECT COUNT(*) FROM lists_users WHERE user_id = 83373278 AND user_subscriber = 1	movie_platform
SELECT movie_release_year FROM movies WHERE movie_title = 'La Antena'	movie_platform
SELECT movie_url FROM movies WHERE movie_title = 'La Antena'	movie_platform
SELECT movie_title FROM movies WHERE movie_title = 'The General' OR movie_title = 'Il grido' ORDER BY movie_popularity DESC LIMIT 1	movie_platform
SELECT COUNT(movie_id) FROM movies WHERE director_name = 'Hong Sang-soo'	movie_platform
SELECT T2.user_trialist FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T1.list_title = '250 Favourite Films'	movie_platform
SELECT T1.list_title FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T1.user_id = 32172230 AND T2.user_eligible_for_trial = 1	movie_platform
SELECT COUNT(*) FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T1.user_id = 85981819 AND T1.list_movie_number > 100 AND T2.user_has_payment_method = 1	movie_platform
SELECT T1.list_description FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T1.user_id = 85981819 ORDER BY T1.list_followers DESC LIMIT 1	movie_platform
SELECT T2.list_update_date_utc FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T1.list_title = '250 Favourite Films' ORDER BY T2.list_update_date_utc DESC LIMIT 1	movie_platform
SELECT T2.user_avatar_image_url FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id AND T1.user_id = T2.user_id WHERE T1.list_title = '250 Favourite Films'	movie_platform
SELECT COUNT(list_id) FROM lists_users WHERE user_id = ( SELECT user_id FROM lists WHERE list_title = '250 Favourite Films' )	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life' AND T1.rating_score = 5	movie_platform
SELECT T1.critic FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life'	movie_platform
SELECT COUNT(*) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'Imitation of Life' AND T1.critic_likes > 1	movie_platform
SELECT T1.user_id FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'When Will I Be Loved' AND T1.critic_comments = 2	movie_platform
SELECT T1.rating_score FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life' AND T1.user_id = 39115684	movie_platform
SELECT T1.rating_url FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life' AND T1.user_id = 39115684	movie_platform
SELECT T1.user_trialist FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life' AND T1.user_id = 39115684	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'When Will I Be Loved' AND T1.user_trialist = 1	movie_platform
SELECT T1.rating_url FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life' AND T1.critic IS NOT NULL	movie_platform
SELECT COUNT(rating_id) FROM ratings WHERE movie_id = ( SELECT movie_id FROM movies ORDER BY movie_popularity DESC LIMIT 1 )	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.user_id = 58149469 AND T1.critic_likes = 1 AND T1.critic_comments = 2	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'When Will I Be Loved' AND T1.rating_score = 1 AND T1.user_trialist = 1	movie_platform
SELECT COUNT(T1.rating_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life' AND T1.rating_timestamp_utc >= '2012-01-01'	movie_platform
SELECT T1.rating_score FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id INNER JOIN lists AS T3 ON T3.user_id = T1.user_id WHERE T2.movie_title = 'Innocence Unprotected' AND T3.list_title = '250 Favourite Films'	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id INNER JOIN lists AS T3 ON T3.user_id = T1.user_id WHERE T3.list_title = '250 Favourite Films'	movie_platform
SELECT AVG(T1.rating_score) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'A Way of Life'	movie_platform
SELECT CAST(SUM(CASE WHEN T1.rating_score = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'When Will I Be Loved'	movie_platform
SELECT SUM(CASE WHEN T2.movie_title = 'Innocence Unprotected' THEN T1.rating_score ELSE 0 END) / SUM(CASE WHEN T2.movie_title = 'Innocence Unprotected' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.movie_title = 'When Will I Be Loved' THEN T1.rating_score ELSE 0 END) / SUM(CASE WHEN T2.movie_title = 'When Will I Be Loved' THEN 1 ELSE 0 END) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id	movie_platform
SELECT director_name FROM movies WHERE movie_title = 'Tokyo Eyes'	movie_platform
SELECT COUNT(*) FROM movies WHERE movie_release_year = 2007	movie_platform
SELECT movie_title FROM movies WHERE movie_release_year = 2006 ORDER BY movie_popularity DESC LIMIT 1	movie_platform
SELECT COUNT(movie_title) FROM movies WHERE director_name = 'Åke Sandgren'	movie_platform
SELECT movie_title FROM movies WHERE director_name = 'Åke Sandgren' ORDER BY movie_popularity DESC LIMIT 1	movie_platform
SELECT movie_release_year FROM movies WHERE movie_title = 'Cops'	movie_platform
SELECT director_id FROM movies WHERE movie_title = 'It''s Winter'	movie_platform
SELECT user_id FROM lists ORDER BY list_followers DESC LIMIT 1	movie_platform
SELECT list_title FROM lists GROUP BY list_title ORDER BY COUNT(list_comments) DESC LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year = 2008 ORDER BY T1.rating_score DESC LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id ORDER BY T1.critic_likes DESC LIMIT 3	movie_platform
SELECT COUNT(T1.user_id) FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_followers > 100 AND T1.list_creation_date_utc LIKE '2009%'	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_score = 5 AND T2.movie_title = 'White Night Wedding'	movie_platform
SELECT T1.user_cover_image_url FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_title LIKE 'Georgia related films'	movie_platform
SELECT SUM(T2.list_followers) FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T1.user_avatar_image_url = 'https://assets.mubicdn.net/images/avatars/74983/images-w150.jpg?1523895214'	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_score = 5 AND T1.user_id = 94978	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year = 2003 AND T1.user_id = 2941	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'Patti Smith: Dream of Life' AND T1.user_trialist = 0	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id GROUP BY T2.movie_title ORDER BY SUM(T1.rating_score) / COUNT(T1.rating_id) DESC LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id ORDER BY T1.critic_comments DESC LIMIT 3	movie_platform
SELECT T2.list_title, T1.user_avatar_image_url FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T1.user_id = 85981819 ORDER BY T2.list_creation_timestamp_utc LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_timestamp_utc LIKE '2020%' GROUP BY T2.movie_title ORDER BY COUNT(T2.movie_title) DESC LIMIT 1	movie_platform
SELECT AVG(T1.rating_score) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title LIKE 'Versailles Rive-Gauche'	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.user_id = 59988436 AND T1.critic_comments = 21	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.critic_likes > 20	movie_platform
SELECT SUM(T1.rating_score) / COUNT(T1.rating_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_timestamp_utc LIKE '2019%' AND T2.movie_title LIKE 'The Fall of Berlin'	movie_platform
SELECT CAST(SUM(CASE WHEN T1.rating_score > 3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.rating_score) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title LIKE 'Patti Smith: Dream of Life'	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.director_name = 'Abbas Kiarostami' GROUP BY T2.movie_title ORDER BY SUM(T1.rating_score) / COUNT(T1.rating_id) DESC LIMIT 1	movie_platform
SELECT movie_release_year FROM movies GROUP BY movie_release_year ORDER BY COUNT(movie_id) DESC LIMIT 1	movie_platform
SELECT director_id FROM movies GROUP BY director_id ORDER BY COUNT(movie_id) DESC LIMIT 1	movie_platform
SELECT COUNT(movie_id) FROM movies WHERE director_id = ( SELECT director_id FROM movies ORDER BY movie_popularity DESC LIMIT 1 )	movie_platform
SELECT COUNT(user_subscriber) FROM ratings_users WHERE user_has_payment_method = 1 AND rating_date_utc > '2014%'	movie_platform
SELECT user_id FROM lists_users WHERE user_subscriber = 0 ORDER BY list_creation_date_utc LIMIT 1	movie_platform
SELECT SUM(T1.list_followers) FROM lists AS T1 INNER JOIN lists_users AS T2 ON T1.list_id = T2.list_id GROUP BY T1.user_id ORDER BY COUNT(T1.list_id) DESC LIMIT 1	movie_platform
SELECT SUM(T2.list_followers) FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_title LIKE 'Non-American Films about World War II'	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'Downfall' AND T1.rating_score = 4	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_score = 5	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id GROUP BY T2.movie_title ORDER BY COUNT(T1.critic_comments) DESC LIMIT 1	movie_platform
SELECT T2.user_avatar_image_url FROM ratings AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T2.user_id WHERE T1.rating_timestamp_utc LIKE '2019-10-17 01:36:36'	movie_platform
SELECT T1.user_avatar_image_url FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_title LIKE 'Vladimir Vladimirovich Nabokov'	movie_platform
SELECT T1.user_has_payment_method FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_movie_number = ( SELECT MAX(list_movie_number) FROM lists )	movie_platform
SELECT T2.user_avatar_image_url FROM ratings AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T2.user_id WHERE T1.rating_score = 5	movie_platform
SELECT COUNT(T1.critic) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_popularity = ( SELECT MAX(movie_popularity) FROM movies )	movie_platform
SELECT T1.user_id FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE rating_score = 4 AND rating_timestamp_utc LIKE '2013-05-04 06:33:32' AND T2.movie_title LIKE 'Freaks'	movie_platform
SELECT T2.movie_url FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE rating_score = 5 AND rating_timestamp_utc LIKE '2013-05-03 05:11:17'	movie_platform
SELECT COUNT(T2.movie_title) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_score = 4 AND T2.movie_release_year = 1998 ORDER BY T2.movie_popularity DESC LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_popularity > 13000 ORDER BY T1.rating_score LIMIT 1	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id INNER JOIN ratings_users AS T3 ON T1.user_id = T3.user_id WHERE T2.movie_title = 'One Flew Over the Cuckoo''s Nest' AND T3.user_has_payment_method = 1	movie_platform
SELECT COUNT(T1.user_id) FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_followers > 3000 AND T1.user_has_payment_method = 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year = 1988 ORDER BY T1.rating_score DESC LIMIT 1	movie_platform
SELECT COUNT(T1.rating_score) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.rating_score < 3 AND T2.movie_release_year = 1995 AND T2.movie_popularity = ( SELECT MAX(movie_popularity) FROM movies WHERE movie_release_year = 1995 )	movie_platform
SELECT CAST(SUM(CASE WHEN T1.rating_score = 5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'Go Go Tales'	movie_platform
SELECT CAST(SUM(CASE WHEN T3.user_subscriber = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id INNER JOIN lists_users AS T3 ON T1.user_id = T3.user_id WHERE T2.movie_title = 'G.I. Jane'	movie_platform
SELECT CAST(SUM(CASE WHEN T1.user_has_payment_method = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id INNER JOIN lists_users AS T3 ON T1.user_id = T3.user_id WHERE T2.movie_title = 'A Shot in the Dark'	movie_platform
SELECT list_title FROM lists WHERE user_id LIKE 4208563	movie_platform
SELECT list_title FROM lists WHERE strftime('%Y', list_update_timestamp_utc) = '2016' ORDER BY list_update_timestamp_utc DESC LIMIT 1	movie_platform
SELECT CAST(SUM(CASE WHEN user_subscriber = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(list_id) FROM lists_users	movie_platform
SELECT DISTINCT T2.list_id FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T1.user_subscriber = 1	movie_platform
SELECT DISTINCT T2.list_title FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T1.user_eligible_for_trial = 1	movie_platform
SELECT COUNT(T1.list_id) FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_followers >= 1 AND T1.user_subscriber = 1	movie_platform
SELECT AVG(list_followers) FROM lists WHERE list_movie_number > 200	movie_platform
SELECT DISTINCT T2.list_title FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_movie_number < 50 AND T1.user_subscriber = 1	movie_platform
SELECT list_title , datetime(CURRENT_TIMESTAMP, 'localtime') - datetime(list_update_timestamp_utc) FROM lists ORDER BY list_update_timestamp_utc LIMIT 1	movie_platform
SELECT T1.user_id, T1.user_subscriber FROM lists_users AS T1 INNER JOIN lists AS T2 ON T1.list_id = T2.list_id WHERE T2.list_title LIKE 'Sound and Vision'	movie_platform
SELECT list_title , 365 * (strftime('%Y', 'now') - strftime('%Y', list_creation_timestamp_utc)) + 30 * (strftime('%m', 'now') - strftime('%m', list_creation_timestamp_utc)) + strftime('%d', 'now') - strftime('%d', list_creation_timestamp_utc) FROM lists WHERE list_followers > 200	movie_platform
SELECT CAST(SUM(CASE WHEN T2.movie_id IS NULL THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.movie_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id	movie_platform
SELECT T2.movie_title, T1.rating_timestamp_utc, T1.rating_score FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.user_id = 39115684	movie_platform
SELECT COUNT(movie_id) FROM movies WHERE movie_release_year BETWEEN '1970' AND '1980' AND movie_popularity > 11000	movie_platform
SELECT COUNT(movie_id) FROM movies WHERE movie_release_year = 1976 AND director_name LIKE 'Felipe Cazals'	movie_platform
SELECT director_url FROM movies WHERE movie_title LIKE 'Red Blooded American Girl'	movie_platform
SELECT list_title FROM lists WHERE list_update_timestamp_utc = ( SELECT list_update_timestamp_utc FROM lists ORDER BY list_update_timestamp_utc DESC LIMIT 1 )	movie_platform
SELECT user_id FROM lists WHERE list_comments = 142	movie_platform
SELECT T2.movie_title, AVG(T1.rating_score) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.director_name = 'Jeannot Szwarc' ORDER BY T2.movie_popularity DESC LIMIT 1	movie_platform
SELECT T2.director_name, T1.rating_score FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_release_year BETWEEN 1970 AND 1979 GROUP BY T2.director_id ORDER BY COUNT(T2.movie_id) DESC LIMIT 1	movie_platform
SELECT COUNT(T1.user_id) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T2.movie_title = 'The Secret Life of Words' AND T1.rating_score = 3 AND T1.user_trialist = 0 AND T1.rating_timestamp_utc BETWEEN '2010%' AND '2020%'	movie_platform
SELECT T2.movie_title, T1.rating_url FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id ORDER BY T1.critic_likes DESC LIMIT 1	movie_platform
SELECT DISTINCT T2.movie_id, SUM(T1.rating_score = 5) FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id ORDER BY T2.movie_popularity DESC LIMIT 5	movie_platform
SELECT CAST(SUM(T4.list_followers) AS REAL) / COUNT(T2.list_id) FROM ratings AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T2.user_id INNER JOIN movies AS T3 ON T1.movie_id = T3.movie_id INNER JOIN lists AS T4 ON T2.list_id = T4.list_id WHERE T3.movie_title LIKE 'Pavee Lackeen: The Traveller Girl' AND T1.rating_timestamp_utc LIKE '2011-03-27 02:06:34'	movie_platform
SELECT COUNT(T1.user_id), T2.movie_image_url FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE datetime(T1.rating_timestamp_utc) BETWEEN '2017-01-01 00:00:00' AND '2017-12-31 00:00:00'	movie_platform
SELECT AVG(T3.list_movie_number) , SUM(CASE WHEN T1.rating_score = 5 THEN 1 ELSE 0 END) FROM ratings AS T1 INNER JOIN lists_users AS T2 ON T1.user_id = T2.user_id INNER JOIN lists AS T3 ON T2.user_id = T3.user_id WHERE T1.user_id = 8516503	movie_platform
SELECT T1.director_name, T1.movie_release_year , SUM(T2.rating_score) / COUNT(T2.user_id) FROM movies AS T1 INNER JOIN ratings AS T2 ON T1.movie_id = T2.movie_id WHERE T2.user_trialist = 1 ORDER BY T1.movie_popularity DESC LIMIT 1	movie_platform
SELECT T2.movie_title FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id WHERE T1.user_id = 57756708 ORDER BY T1.rating_timestamp_utc DESC LIMIT 1	movie_platform
SELECT T2.movie_id, AVG(T1.rating_score), T2.director_name, T2.movie_release_year FROM ratings AS T1 INNER JOIN movies AS T2 ON T1.movie_id = T2.movie_id ORDER BY T1.rating_timestamp_utc ASC LIMIT 10	movie_platform
SELECT ord_date, SUM(qty) FROM sales GROUP BY ord_date ORDER BY SUM(qty) DESC LIMIT 1	book_publishing_company
SELECT T2.title FROM sales AS T1 INNER JOIN titles AS T2 ON T1.title_id = T2.title_id WHERE STRFTIME('%Y', T1.ord_date) = '1992' ORDER BY T1.qty DESC LIMIT 1	book_publishing_company
SELECT T2.title, T2.price, T2.pubdate FROM sales AS T1 INNER JOIN titles AS T2 ON T1.title_id = T2.title_id WHERE T1.payterms = 'ON invoice'	book_publishing_company
SELECT T1.title FROM titles AS T1 INNER JOIN roysched AS T2 ON T1.title_id = T2.title_id WHERE T2.lorange = 0 AND T2.royalty >= 10	book_publishing_company
SELECT T1.title, T2.royalty FROM titles AS T1 INNER JOIN roysched AS T2 ON T1.title_id = T2.title_id WHERE T2.lorange > 10000 AND T2.hirange < 50000 AND T1.title_ID = 'BU2075'	book_publishing_company
SELECT T1.title, T2.lorange FROM titles AS T1 INNER JOIN roysched AS T2 ON T1.title_id = T2.title_id ORDER BY T2.royalty DESC LIMIT 1	book_publishing_company
SELECT T1.title, T2.pub_name FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.country = 'USA'	book_publishing_company
SELECT MAX(T1.ytd_sales) FROM titles AS T1 INNER JOIN roysched AS T2 ON T1.title_id = T2.title_id WHERE T2.lorange > 20000 AND T2.hirange < 20000	book_publishing_company
SELECT T1.title, T1.notes, T2.pub_name FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE STRFTIME('%Y', T1.pubdate) = '1991'	book_publishing_company
SELECT T1.title, T2.qty FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id INNER JOIN stores AS T3 ON T2.stor_id = T3.stor_id WHERE T2.qty > 20 AND T3.state = 'CA'	book_publishing_company
SELECT T3.stor_id, T2.title FROM sales AS T1 INNER JOIN titles AS T2 ON T1.title_id = T2.title_id INNER JOIN stores AS T3 ON T3.stor_id = T1.stor_id WHERE T3.stor_id = ( SELECT stor_id FROM sales GROUP BY stor_id ORDER BY SUM(qty) DESC LIMIT 1 ) GROUP BY T3.stor_id, T2.title ORDER BY SUM(T1.qty) ASC LIMIT 1	book_publishing_company
SELECT T1.title, T3.pub_name, T2.lorange, T2.hirange, T2.royalty FROM titles AS T1 INNER JOIN roysched AS T2 ON T1.title_id = T2.title_id INNER JOIN publishers AS T3 ON T1.pub_id = T3.pub_id WHERE T1.title_id = 'BU2075'	book_publishing_company
SELECT T2.stor_name , CAST(SUM(CASE WHEN payterms = 'Net 30' THEN qty ELSE 0 END) AS REAL) * 100 / SUM(qty) FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id WHERE T1.stor_id = '7066' GROUP BY T2.stor_name	book_publishing_company
SELECT T2.pub_name, AVG(T1.ytd_sales) FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.pub_id = '0877' GROUP BY T2.pub_name	book_publishing_company
SELECT fname, lname FROM employee WHERE STRFTIME('%Y', hire_date) < '1990'	book_publishing_company
SELECT fname, lname, hire_date FROM employee ORDER BY job_lvl LIMIT 1	book_publishing_company
SELECT STRFTIME('%Y', hire_date) FROM employee GROUP BY STRFTIME('%Y', hire_date) ORDER BY COUNT(emp_id) DESC LIMIT 1	book_publishing_company
SELECT T1.fname, T1.lname FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id WHERE T1.job_lvl = T2.max_lvl	book_publishing_company
SELECT T1.fname, T1.lname, T1.hire_date FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id WHERE T2.job_desc = 'Chief Financial Officier'	book_publishing_company
SELECT T1.fname, T1.lname, T2.pub_name FROM employee AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.country != 'USA'	book_publishing_company
SELECT T1.fname, T1.lname, T3.job_desc FROM employee AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id INNER JOIN jobs AS T3 ON T1.job_id = T3.job_id WHERE T2.pub_name = 'GGG&G'	book_publishing_company
SELECT DISTINCT T2.pub_name, T1.type FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id ORDER BY T2.pub_name	book_publishing_company
SELECT T2.pub_name FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE STRFTIME('%Y', T1.pubdate) = '1991' GROUP BY T1.pub_id, T2.pub_name ORDER BY COUNT(T1.title_id) DESC LIMIT 1	book_publishing_company
SELECT T1.title FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.pub_name = 'Binnet & Hardley' ORDER BY T1.price DESC LIMIT 1	book_publishing_company
SELECT T1.fname, T1.lname, T2.job_desc FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id WHERE T1.job_lvl > 200	book_publishing_company
SELECT T3.au_fname, T3.au_lname FROM titles AS T1 INNER JOIN titleauthor AS T2 ON T1.title_id = T2.title_id INNER JOIN authors AS T3 ON T2.au_id = T3.au_id WHERE T1.type = 'business'	book_publishing_company
SELECT T1.title_id, T1.ytd_sales FROM titles AS T1 INNER JOIN titleauthor AS T2 ON T1.title_id = T2.title_id INNER JOIN authors AS T3 ON T2.au_id = T3.au_id WHERE T3.contract = 0	book_publishing_company
SELECT T1.title FROM titles AS T1 INNER JOIN titleauthor AS T2 ON T1.title_id = T2.title_id INNER JOIN authors AS T3 ON T2.au_id = T3.au_id WHERE T3.contract = 0 AND T3.state = 'CA' ORDER BY T1.ytd_sales DESC LIMIT 1	book_publishing_company
SELECT T3.au_fname, T3.au_lname FROM titles AS T1 INNER JOIN titleauthor AS T2 ON T1.title_id = T2.title_id INNER JOIN authors AS T3 ON T2.au_id = T3.au_id WHERE T1.title = 'Sushi, Anyone?'	book_publishing_company
SELECT CAST(SUM(CASE WHEN T2.job_desc IN ('Editor', 'Designer') THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.job_id) FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id	book_publishing_company
SELECT T1.title FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.ytd_sales > ( SELECT AVG(ytd_sales) FROM titles )	book_publishing_company
SELECT COUNT(pub_id) FROM publishers WHERE country = 'USA'	book_publishing_company
SELECT T1.pr_info FROM pub_info AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.pub_name = 'New Moon Books'	book_publishing_company
SELECT T1.fname FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id WHERE T2.job_desc = 'Managing Editor'	book_publishing_company
SELECT T2.max_lvl FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id ORDER BY T1.hire_date LIMIT 1	book_publishing_company
SELECT T2.city FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id GROUP BY T2.city ORDER BY SUM(T1.qty) DESC LIMIT 1	book_publishing_company
SELECT T2.price FROM sales AS T1 INNER JOIN titles AS T2 ON T1.title_id = T2.title_id ORDER BY T1.qty DESC LIMIT 1	book_publishing_company
SELECT T2.stor_name FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id INNER JOIN titles AS T3 ON T1.title_id = T3.title_id WHERE T3.title = 'Life Without Fear'	book_publishing_company
SELECT COUNT(T1.stor_id) FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id INNER JOIN titles AS T3 ON T1.title_id = T3.title_id WHERE T2.state = 'Massachusetts'	book_publishing_company
SELECT T2.country FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.title = 'Life Without Fear'	book_publishing_company
SELECT T2.pub_name FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id ORDER BY T1.price DESC LIMIT 1	book_publishing_company
SELECT COUNT(DISTINCT T1.pub_id) FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.country = 'USA' AND T1.price > 15	book_publishing_company
SELECT T1.notes FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id ORDER BY T2.qty DESC LIMIT 3	book_publishing_company
SELECT SUM(T1.qty) FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id INNER JOIN titles AS T3 ON T1.title_id = T3.title_id WHERE T2.state = 'Massachusetts' AND T3.type = 'business'	book_publishing_company
SELECT CAST(SUM(T2.qty) AS REAL) / COUNT(T1.title_id) FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id WHERE T1.title = 'Life Without Fear'	book_publishing_company
SELECT AVG(T2.job_lvl), T1.max_lvl - AVG(T2.job_lvl) FROM jobs AS T1 INNER JOIN employee AS T2 ON T1.job_id = T2.job_id WHERE T1.job_desc = 'Managing Editor' GROUP BY T2.job_id, T1.max_lvl	book_publishing_company
SELECT title FROM titles WHERE type = 'business' ORDER BY price LIMIT 1	book_publishing_company
SELECT type FROM titles ORDER BY advance DESC LIMIT 1	book_publishing_company
SELECT royalty FROM titles ORDER BY ytd_sales DESC LIMIT 1	book_publishing_company
SELECT job_lvl FROM employee WHERE lname = 'O''Rourke'	book_publishing_company
SELECT emp_id FROM employee WHERE minit = '' ORDER BY job_lvl DESC LIMIT 1	book_publishing_company
SELECT T1.contract FROM authors AS T1 INNER JOIN titleauthor AS T2 ON T1.au_id = T2.au_id INNER JOIN titles AS T3 ON T2.title_id = T3.title_id WHERE T3.title = 'Sushi, Anyone?'	book_publishing_company
SELECT T1.fname, T1.minit, T1.lname FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id ORDER BY T1.job_lvl DESC LIMIT 1	book_publishing_company
SELECT T2.job_desc FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id WHERE T1.fname = 'Pedro' AND T1.minit = 'S' AND T1.lname = 'Afonso'	book_publishing_company
SELECT T2.max_lvl - T1.job_lvl FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id WHERE T1.fname = 'Diego' AND T1.minit = 'W' AND T1.lname = 'Roel'	book_publishing_company
SELECT T1.notes FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id WHERE STRFTIME('%Y-%m-%d', T2.ord_date) = '1994-09-14'	book_publishing_company
SELECT DISTINCT T1.type FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id WHERE STRFTIME('%Y-%m-%d', T2.ord_date) = '1993-05-29'	book_publishing_company
SELECT T1.pr_info FROM pub_info AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.country = 'France'	book_publishing_company
SELECT T2.pub_name FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.title = 'Silicon Valley Gastronomic Treats'	book_publishing_company
SELECT T2.city FROM employee AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.fname = 'Victoria' AND T1.minit = 'P' AND T1.lname = 'Ashworth'	book_publishing_company
SELECT COUNT(T1.ord_num) FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id WHERE T2.city = 'Remulade'	book_publishing_company
SELECT CAST(SUM(CASE WHEN T2.city = 'Fremont' THEN qty END) - SUM(CASE WHEN T2.city = 'Portland' THEN qty END) AS REAL) * 100 / SUM(CASE WHEN T2.city = 'Fremont' THEN qty END) FROM sales AS T1 INNER JOIN stores AS T2 ON T1.stor_id = T2.stor_id WHERE STRFTIME('%Y', T1.ord_date) = '1993'	book_publishing_company
SELECT CAST(SUM(CASE WHEN T2.job_desc = 'publisher' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.job_desc = 'designer' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.job_id) FROM employee AS T1 INNER JOIN jobs AS T2 ON T1.job_id = T2.job_id	book_publishing_company
SELECT fname, minit, lname FROM employee WHERE STRFTIME('%Y', hire_date) BETWEEN '1990' AND '1995' ORDER BY job_lvl DESC	book_publishing_company
SELECT DISTINCT T1.title, T1.type, T1.price FROM titles AS T1 INNER JOIN roysched AS T2 ON T1.title_id = T2.title_id WHERE T2.royalty > ( SELECT CAST(SUM(royalty) AS REAL) / COUNT(title_id) FROM roysched )	book_publishing_company
SELECT DISTINCT T1.title, T1.type, T1.price FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id WHERE T2.ord_date LIKE '1994%' AND T2.Qty < ( SELECT CAST(SUM(T4.qty) AS REAL) / COUNT(T3.title_id) FROM titles AS T3 INNER JOIN sales AS T4 ON T3.title_id = T4.title_id )	book_publishing_company
SELECT T1.title, T1.type, T1.price FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T2.pub_name = 'New Moon Books' ORDER BY T1.price	book_publishing_company
SELECT T1.title FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id INNER JOIN roysched AS T3 ON T1.title_id = T3.title_id WHERE T2.country = 'USA' ORDER BY T1.royalty DESC	book_publishing_company
SELECT (CAST(SUM(CASE WHEN T2.country = 'USA' THEN T1.royalty ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.country = 'USA' THEN 1 ELSE 0 END)) - (CAST(SUM(CASE WHEN T2.country != 'USA' THEN T1.royalty ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.country != 'USA' THEN 1 ELSE 0 END)) FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id INNER JOIN roysched AS T3 ON T1.title_id = T3.title_id	book_publishing_company
SELECT (CAST(SUM(CASE WHEN T1.country = 'USA' THEN job_lvl ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.country = 'USA' THEN 1 ELSE 0 END)) - (CAST(SUM(CASE WHEN T1.country != 'USA' THEN job_lvl ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.country != 'USA' THEN 1 ELSE 0 END)) FROM publishers AS T1 INNER JOIN employee AS T2 ON T1.pub_id = T2.pub_id INNER JOIN jobs AS T3 ON T2.job_id = T3.job_id WHERE T3.job_desc = 'Managing Editor'	book_publishing_company
SELECT T1.title, T2.pub_name, T1.price FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.notes = 'Helpful hints on how to use your electronic resources to the best advantage.'	book_publishing_company
SELECT T1.title, T2.pub_name, T1.ytd_sales FROM titles AS T1 INNER JOIN publishers AS T2 ON T1.pub_id = T2.pub_id WHERE T1.notes = 'Carefully researched study of the effects of strong emotions on the body. Metabolic charts included.'	book_publishing_company
SELECT T1.title FROM titles AS T1 INNER JOIN sales AS T2 ON T1.title_id = T2.title_id INNER JOIN publishers AS T3 ON T1.pub_id = T3.pub_id WHERE T2.qty > ( SELECT CAST(SUM(qty) AS REAL) / COUNT(title_id) FROM sales ) AND T3.state = 'CA' ORDER BY T2.qty DESC LIMIT 5	book_publishing_company
SELECT `Date received` FROM callcenterlogs WHERE ser_time = ( SELECT MAX(ser_time) FROM callcenterlogs )	retail_complains
SELECT MIN(ser_time) FROM callcenterlogs WHERE `Date received` = '2017-03-22'	retail_complains
SELECT CASE WHEN SUM(CASE WHEN `Complaint ID` = 'CR2400594' THEN priority END) > SUM(CASE WHEN `Complaint ID` = 'CR2405641' THEN priority END) THEN 'CR2400594' ELSE 'CR2405641' END FROM callcenterlogs	retail_complains
SELECT first, middle, last FROM client WHERE year > 1990	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Diesel' AND T1.last = 'Galloway'	retail_complains
SELECT T2.`Sub-product` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Diesel' AND T1.last = 'Galloway' AND T2.`Date received` = '2014-07-03'	retail_complains
SELECT CASE WHEN T2.`Consumer consent provided?` IN (NULL, 'N/A', 'Empty') THEN 'No' ELSE 'Yes' END FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Matthew' AND T1.last = 'Pierce' AND T2.`Date received` = '2016-10-28'	retail_complains
SELECT 365 * (strftime('%Y', T2.`Date sent to company`) - strftime('%Y', T2.`Date received`)) + 30 * (strftime('%M', T2.`Date sent to company`) - strftime('%M', T2.`Date received`)) + (strftime('%d', T2.`Date sent to company`) - strftime('%d', T2.`Date received`)) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Matthew' AND T1.last = 'Pierce' AND T2.`Date received` = '2016-10-28'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.`Date received` = '2017-03-27' AND T2.server = 'MICHAL'	retail_complains
SELECT T2.ser_time FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.first = 'Rachel' AND T1.last = 'Hicks' AND T2.`Date received` = '2017-03-27'	retail_complains
SELECT COUNT(T2.Issue) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Issue = 'Deposits and withdrawals' AND T1.city = 'New York City'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Company response to consumer` = 'In progress'	retail_complains
SELECT COUNT(T1.city) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Timely response?` = 'No' AND T1.city = 'New York City'	retail_complains
SELECT COUNT(T1.sex) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE strftime('%Y', T2.`Date received`) = '2016' AND T1.sex = 'Male' AND T2.Product = 'Credit card'	retail_complains
SELECT T2.division FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.first = 'Diesel' AND T1.last = 'Galloway'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.division = 'Pacific' AND T1.sex = 'Male'	retail_complains
SELECT CAST(COUNT(T2.`Complaint ID`) AS REAL) / 3 AS average FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE strftime('%Y', T2.`Date received`) BETWEEN '2015' AND '2017' AND T1.city = 'New York City' AND T2.Product = 'Credit card'	retail_complains
SELECT 100.0 * (SUM(CASE WHEN strftime('%Y', T2.`Date received`) = '2017' THEN 1 ELSE 0 END) - SUM(CASE WHEN strftime('%Y', T2.`Date received`) = '2016' THEN 1 ELSE 0 END)) / SUM(CASE WHEN strftime('%Y', T2.`Date received`) = '2016' THEN 1 ELSE 0 END) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.city = 'New York City'	retail_complains
SELECT T1.ser_time FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.Client_ID = 'C00007127' AND T1.`Date received` = '2017-02-22'	retail_complains
SELECT T1.state FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.email = 'wyatt.collins@gmail.com'	retail_complains
SELECT DISTINCT T2.`Sub-product` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Lennox' AND T1.middle = 'Oliver' AND T1.last = 'Drake' AND T1.sex = 'Male'	retail_complains
SELECT T2.`Sub-issue` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Gunner' AND T1.middle = 'Omer' AND T1.last = 'Fuller' AND T1.sex = 'Male'	retail_complains
SELECT CASE WHEN T2.`Consumer consent provided?` IN (NULL, 'N/A', '') THEN 'No' ELSE 'Yes' END FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Lyric' AND T1.middle = 'Emely' AND T1.last = 'Taylor' AND T1.sex = 'Female' AND T2.`Date received` = '2016-05-20'	retail_complains
SELECT 365 * (strftime('%Y', T2.`Date sent to company`) - strftime('%Y', T2.`Date received`)) + 30 * (strftime('%M', T2.`Date sent to company`) - strftime('%M', T2.`Date received`)) + (strftime('%d', T2.`Date sent to company`) - strftime('%d', T2.`Date received`)) AS days FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Date received` = '2012-05-18' AND T1.sex = 'Male' AND T1.first = 'Brantley' AND T1.middle = 'Julian' AND T1.last = 'Stanley'	retail_complains
SELECT T2.district_id, T2.city FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.Date = '2018-09-11'	retail_complains
SELECT T1.Reviews FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.city = 'Jacksonville' AND T1.Date = '2017-07-22'	retail_complains
SELECT T1.Product FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.city = 'Indianapolis' AND T1.Date = '2016-10-07'	retail_complains
SELECT COUNT(T1.Stars) FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.Product = 'Eagle Capital' AND T2.city = 'Little Rock' AND T1.Date = '2013-04-04'	retail_complains
SELECT T1.month, T1.day FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Complaint ID` = 'CR0217298'	retail_complains
SELECT T1.phone FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Complaint ID` = 'CR0100432'	retail_complains
SELECT CAST(SUM(CASE WHEN T1.sex = 'Female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.sex) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Date received` = '2017-03-27'	retail_complains
SELECT CAST(SUM(CASE WHEN T2.`Consumer consent provided?` = 'Consent provided' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.`Consumer consent provided?`) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.sex = 'Male' AND T1.first = 'Mason' AND T1.middle = 'Javen' AND T1.last = 'Lopez'	retail_complains
SELECT COUNT(`Complaint ID`) FROM callcenterlogs WHERE `Date received` LIKE '2017-01%' AND priority = ( SELECT MAX(priority) FROM callcenterlogs )	retail_complains
SELECT first, middle, last, year, month , day, email FROM client WHERE age > 65 ORDER BY age DESC	retail_complains
SELECT T.Product, MAX(T.num) FROM ( SELECT Product, COUNT(Stars) AS num FROM reviews WHERE Stars = 5 GROUP BY Product ) T	retail_complains
SELECT state FROM state WHERE Region = 'South'	retail_complains
SELECT T1.email FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.outcome = 'HANG'	retail_complains
SELECT CAST(SUM(T1.age) AS REAL) / COUNT(T3.Region) AS average FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T2.state_abbrev = T3.StateCode WHERE T3.Region = 'Midwest'	retail_complains
SELECT T1.first, T1.middle, T1.last, T1.phone FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Submitted via` = 'Fax'	retail_complains
SELECT T2.division FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.Product = 'Eagle Capital' AND T1.Stars > ( SELECT AVG(Stars) FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id )	retail_complains
SELECT COUNT(T1.age) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.age BETWEEN 12 AND 20 AND T2.division = 'Mountain'	retail_complains
SELECT COUNT(T1.sex) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.sex = 'Female' AND T2.Product = 'Credit card'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.year BETWEEN 1980 AND 2000 AND T1.sex = 'Male' AND T2.`Submitted via` = 'Referral'	retail_complains
SELECT T3.`Submitted via` FROM callcenterlogs AS T1 INNER JOIN client AS T2 ON T1.`rand client` = T2.client_id INNER JOIN events AS T3 ON T1.`Complaint ID` = T3.`Complaint ID` WHERE T2.state = 'FL' GROUP BY T1.`Complaint ID` ORDER BY COUNT(T1.`Complaint ID`) DESC LIMIT 1	retail_complains
SELECT STRFTIME('%Y', T3.`Date received`) , CAST(SUM(CASE WHEN T3.`Company response to consumer` = 'Closed with explanation' THEN 1 ELSE 0 END) AS REAL) / COUNT(T3.`Complaint ID`) AS average FROM callcenterlogs AS T1 INNER JOIN client AS T2 ON T1.`rand client` = T2.client_id INNER JOIN events AS T3 ON T1.`Complaint ID` = T3.`Complaint ID` WHERE T2.city = 'New Bedford' GROUP BY strftime('%Y', T3.`Date received`)	retail_complains
SELECT CAST(SUM(CASE WHEN T2.`Consumer disputed?` = 'Yes' AND T1.city = 'Houston' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Tags = 'Servicemember' AND T1.city = 'Syracuse'	retail_complains
SELECT CAST(SUM(CASE WHEN T1.priority = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.priority) FROM callcenterlogs AS T1 INNER JOIN client AS T2 ON T1.`rand client` = T2.client_id INNER JOIN district AS T3 ON T2.district_id = T3.district_id INNER JOIN state AS T4 ON T3.state_abbrev = T4.StateCode WHERE T4.State = 'California'	retail_complains
SELECT (CAST(SUM(CASE WHEN T1.age BETWEEN 35 AND 55 THEN T1.age ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.age BETWEEN 35 AND 55 THEN 1 ELSE 0 END)) - (CAST(SUM(CASE WHEN T1.age > 65 THEN T1.age ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.age > 65 THEN 1 ELSE 0 END)) AS difference FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T2.state_abbrev = T3.StateCode WHERE T3.Region = 'Northeast'	retail_complains
SELECT `Complaint ID` FROM callcenterlogs ORDER BY ser_time DESC LIMIT 3	retail_complains
SELECT COUNT(email) FROM client WHERE email NOT LIKE '%@gmail.com'	retail_complains
SELECT Client_ID FROM events WHERE `Consumer consent provided?` = 'N/A' OR 'Consumer consent provided?' IS NULL OR 'Consumer consent provided?' = ''	retail_complains
SELECT `Complaint ID` FROM events WHERE strftime('%J', `Date sent to company`) - strftime('%J', `Date received`) = ( SELECT MAX(strftime('%J', `Date sent to company`) - strftime('%J', `Date received`)) FROM events WHERE `Date sent to company` = '2014-09-25' ) AND `Date sent to company` = '2014-09-25'	retail_complains
SELECT DISTINCT `Complaint ID` FROM callcenterlogs WHERE priority = 2 ORDER BY `Date received` DESC	retail_complains
SELECT COUNT(outcome) FROM callcenterlogs WHERE outcome != 'AGENT'	retail_complains
SELECT COUNT(T1.`Complaint ID`) FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.Product = 'Credit card' AND T1.server = 'SHARON'	retail_complains
SELECT T3.Region FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T2.state_abbrev = T3.StateCode WHERE T1.Stars = 1 GROUP BY T3.Region ORDER BY COUNT(T3.Region) DESC LIMIT 1	retail_complains
SELECT T1.year FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Sub-product` = '(CD) Certificate of deposit' GROUP BY T1.year ORDER BY COUNT(T1.year) DESC LIMIT 1	retail_complains
SELECT COUNT(T1.Issue) FROM events AS T1 INNER JOIN client AS T2 ON T1.Client_ID = T2.client_id INNER JOIN district AS T3 ON T2.district_id = T3.district_id WHERE T1.Issue = 'Billing disputes' AND T3.division = 'Mountain'	retail_complains
SELECT COUNT(T3.sex) FROM state AS T1 INNER JOIN district AS T2 ON T1.StateCode = T2.state_abbrev INNER JOIN client AS T3 ON T2.district_id = T3.district_id WHERE T1.state = 'Massachusetts' AND T3.sex = 'Male'	retail_complains
SELECT t1.last FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.type = 'PS' AND T2.server = 'TOVA'	retail_complains
SELECT COUNT(T2.age) FROM reviews AS T1 INNER JOIN client AS T2 ON T1.district_id = T2.district_id WHERE T1.Product = 'Eagle National Mortgage' AND T1.Stars = 1 AND T2.age < 35	retail_complains
SELECT COUNT(T1.sex) FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.sex = 'Male' AND T2.priority = 0 AND T1.year = 1997	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Tags = 'Older American' AND T2.`Consumer consent provided?` != 'N/A' AND T2.`Consumer consent provided?` IS NOT NULL AND T2.`Consumer consent provided?` != ''	retail_complains
SELECT T2.state FROM callcenterlogs AS T1 INNER JOIN client AS T2 ON T1.`rand client` = T2.client_id INNER JOIN district AS T3 ON T2.district_id = T3.district_id INNER JOIN state AS T4 ON T3.state_abbrev = T4.StateCode WHERE T1.priority = 0 GROUP BY T2.state ORDER BY COUNT(T2.state) DESC LIMIT 1	retail_complains
SELECT COUNT(T1.`Complaint ID`) FROM callcenterlogs AS T1 INNER JOIN client AS T2 ON T1.`rand client` = T2.client_id INNER JOIN events AS T3 ON T1.`Complaint ID` = T3.`Complaint ID` WHERE T2.sex = 'Female' AND T1.ser_start BETWEEN '15:00:01' AND '23:59:59' AND T3.`Timely response?` = 'Yes'	retail_complains
SELECT COUNT(T1.`Complaint ID`) FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T1.ser_time < '00:05:00' AND T1.server = 'DORIT' AND T2.`Submitted via` = 'Phone' AND T2.`Company response to consumer` = 'Closed with explanation'	retail_complains
SELECT COUNT(T2.client_id) FROM district AS T1 INNER JOIN client AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T1.state_abbrev = T3.StateCode WHERE T2.last = 'Alvarado' AND T2.state = 'MD'	retail_complains
SELECT COUNT(T1.Reviews) FROM reviews AS T1 INNER JOIN client AS T2 ON T1.district_id = T2.district_id WHERE T2.age BETWEEN 30 AND 50 AND T1.Reviews LIKE '%great%'	retail_complains
SELECT T1.address_1, T1.address_2 FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Timely response?` = 'Yes' AND T2.`Consumer disputed?` = 'Yes'	retail_complains
SELECT COUNT(T2.`Submitted via`) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.sex = 'Female' AND T1.year = 2000 AND T2.`Submitted via` != 'Web'	retail_complains
SELECT T2.`Consumer complaint narrative` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Brenda' AND T1.last = 'Mayer'	retail_complains
SELECT COUNT(T1.email) FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE (T2.`Date received` LIKE '2017-02%' OR T2.`Date received` LIKE '2017-01%') AND T1.email LIKE '%@gmail.com'	retail_complains
SELECT CAST(SUM(T3.Stars) AS REAL) / COUNT(T3.Stars) AS average FROM state AS T1 INNER JOIN district AS T2 ON T1.StateCode = T2.state_abbrev INNER JOIN reviews AS T3 ON T2.district_id = T3.district_id WHERE T1.State = 'Oregon'	retail_complains
SELECT CAST(SUM(CASE WHEN T1.age > 50 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.`Submitted via`) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Submitted via` = 'Postal mail'	retail_complains
SELECT CAST(SUM(T1.age) AS REAL) / COUNT(T1.age) AS average FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.city = 'Norwalk'	retail_complains
SELECT COUNT(T1.Stars) FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.city = 'Kansas City' AND T1.Stars = 1	retail_complains
SELECT T2.state_abbrev FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.Stars = 5 GROUP BY T2.state_abbrev ORDER BY COUNT(T2.state_abbrev) DESC LIMIT 1	retail_complains
SELECT T2.division FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.first = 'Noah' AND T1.last = 'Thompson'	retail_complains
SELECT DISTINCT T2.`Submitted via` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Kyran' AND T1.last = 'Muller'	retail_complains
SELECT DISTINCT T2.Product FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.year > 2005	retail_complains
SELECT T3.ser_time FROM events AS T1 INNER JOIN client AS T2 ON T1.Client_ID = T2.client_id INNER JOIN callcenterlogs AS T3 ON T1.`Complaint ID` = T3.`Complaint ID` WHERE T2.first = 'Kendall' AND T2.last = 'Allen' AND T2.sex = 'Female' AND T1.Product = 'Credit card'	retail_complains
SELECT T2.Issue FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T1.ser_time = ( SELECT MAX(ser_time) FROM callcenterlogs )	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.city = 'New York City' AND T2.`Submitted via` = 'Fax'	retail_complains
SELECT CAST(SUM(CASE WHEN T1.sex = 'Male' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.sex) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Product = 'Credit card'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Tags = 'Older American' AND T2.`Consumer consent provided?` IN (NULL, 'N/A', '') LIMIT 2	retail_complains
SELECT day, month, year FROM client ORDER BY year DESC, month DESC, day DESC LIMIT 1	retail_complains
SELECT COUNT(`Timely response?`) FROM events WHERE `Timely response?` = 'No' AND `Consumer disputed?` = 'No'	retail_complains
SELECT COUNT(ser_time) FROM callcenterlogs WHERE strftime('%M', ser_time) > '15'	retail_complains
SELECT T1.Issue FROM events AS T1 INNER JOIN callcenterlogs AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.priority = 2 GROUP BY T1.Issue ORDER BY COUNT(T1.Issue) DESC LIMIT 1	retail_complains
SELECT T2.first, T2.middle, T2.last FROM district AS T1 INNER JOIN client AS T2 ON T1.district_id = T2.district_id WHERE T1.division = 'Pacific'	retail_complains
SELECT T1.social FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID GROUP BY T1.client_id ORDER BY COUNT(T1.client_id) DESC LIMIT 1	retail_complains
SELECT T2.city FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.Stars = 1 GROUP BY T2.city ORDER BY COUNT(T2.city) DESC LIMIT 1	retail_complains
SELECT T1.address_1, T1.address_2 FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Date received` = '2012-03-14' AND T2.`Submitted via` = 'Postal mail'	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.sex = 'Female' AND T2.priority = 1	retail_complains
SELECT DISTINCT T2.server FROM events AS T1 INNER JOIN callcenterlogs AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T1.`Submitted via` = 'Phone' AND T1.`Timely response?` = 'No'	retail_complains
SELECT DISTINCT T2.Issue FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Kaitlyn' AND T1.middle = 'Eliza' AND T1.last = 'Elliott'	retail_complains
SELECT T3.state FROM state AS T1 INNER JOIN district AS T2 ON T1.StateCode = T2.state_abbrev INNER JOIN client AS T3 ON T2.district_id = T3.district_id WHERE T3.email = 'skylar.ramirez@gmail.com'	retail_complains
SELECT T2.division FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id GROUP BY T2.division ORDER BY COUNT(T2.division) DESC LIMIT 1, 1	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.server = 'MORIAH' AND T2.`Date received` = '2013-09-11'	retail_complains
SELECT CAST(SUM(CASE WHEN T1.age > 13 AND T1.age <= 19 THEN 60 * strftime('%H', ser_time) + strftime('%M', ser_time) + strftime('%S', ser_time) / 60 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.age > 13 AND T1.age <= 19 THEN 1 ELSE 0 END) AS teenagerAverageMins, CAST(SUM(CASE WHEN T1.age > 19 AND T1.age <= 65 THEN 60 * strftime('%H', ser_time) + strftime('%M', ser_time) + strftime('%S', ser_time) / 60 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.age > 19 AND T1.age <= 65 THEN 1 ELSE 0 END) AS adultAverageMins , CAST(SUM(CASE WHEN T1.age > 65 THEN 60 * strftime('%H', ser_time) + strftime('%M', ser_time) + strftime('%S', ser_time) / 60 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.age > 65 THEN 1 ELSE 0 END) AS elderAverageMins FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client`	retail_complains
SELECT CAST(SUM(CASE WHEN T1.age > 65 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.age) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID	retail_complains
SELECT CAST(SUM(CASE WHEN sex = 'Male' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(client_id) FROM client WHERE city = 'Indianapolis'	retail_complains
SELECT CASE WHEN SUM(CASE WHEN email LIKE '%@gmail.com' THEN 1 ELSE 0 END) > SUM(CASE WHEN email LIKE '%@outlook.com' THEN 1 ELSE 0 END) THEN 'Google account' ELSE 'Microsoft account' END FROM client WHERE age BETWEEN 13 AND 19	retail_complains
SELECT first, middle, last FROM client WHERE email = 'emily.garcia43@outlook.com'	retail_complains
SELECT T1.first FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.priority = ( SELECT MAX(priority) FROM callcenterlogs )	retail_complains
SELECT T1.email FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.type = 'PS'	retail_complains
SELECT T1.last FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.age > 65 AND T2.server = 'YIFAT'	retail_complains
SELECT COUNT(T2.`rand client`) FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.city = 'New York City' AND T2.outcome = 'AGENT'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Consumer disputed?` = 'Yes'	retail_complains
SELECT T2.`Complaint ID` FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.year = 1931	retail_complains
SELECT CAST(SUM(CASE WHEN T1.email LIKE '%@gmail.com' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.email) FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.server = 'ZOHARI'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE strftime('%M', T2.ser_time) > '20'	retail_complains
SELECT T1.last FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.priority = 0 LIMIT 5	retail_complains
SELECT T2.call_id FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T1.first LIKE 'B%'	retail_complains
SELECT DISTINCT T2.Product FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.first = 'Alexander' AND T1.middle = 'Bronx' AND T1.last = 'Lewis'	retail_complains
SELECT T1.first FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Timely response?` = 'No' AND T1.sex = 'Male'	retail_complains
SELECT T2.Product FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.age > 65 ORDER BY T1.client_id DESC LIMIT 1	retail_complains
SELECT SUM(CASE WHEN T1.age > 13 AND T1.age <= 19 THEN 1 ELSE 0 END), SUM(CASE WHEN T1.age > 19 AND T1.age <= 65 THEN 1 ELSE 0 END) AS adult , SUM(CASE WHEN T1.age > 65 THEN 1 ELSE 0 END) AS elder FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Product = 'Credit card'	retail_complains
SELECT T2.Issue FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE strftime('%M', T1.ser_time) < '10'	retail_complains
SELECT T1.`Date received` FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.`Submitted via` = 'Fax'	retail_complains
SELECT T1.first, T1.middle, T1.last FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Issue = 'Balance transfer'	retail_complains
SELECT T1.email FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Submitted via` = 'Postal mail'	retail_complains
SELECT AVG(T1.age) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Company response to consumer` = 'Closed with relief'	retail_complains
SELECT AVG(T1.age) FROM client AS T1 INNER JOIN callcenterlogs AS T2 ON T1.client_id = T2.`rand client` WHERE T2.type = 'TT'	retail_complains
SELECT `Complaint ID`, call_id, phonefinal FROM callcenterlogs WHERE strftime('%Y', `Date received`) = '2014' AND server = 'AVIDAN'	retail_complains
SELECT AVG(CAST(SUBSTR(ser_time, 4, 2) AS REAL)) FROM callcenterlogs WHERE `Date received` BETWEEN '2017-01-01' AND '2017-04-01'	retail_complains
SELECT strftime('%Y', `Date received`), COUNT(`Date received`) FROM events WHERE product = 'Credit card' AND issue = 'Overlimit fee' GROUP BY strftime('%Y', `Date received`) HAVING COUNT(`Date received`)	retail_complains
SELECT COUNT(T1.sex) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.division = 'Middle Atlantic' AND T1.sex = 'Female' AND T1.age < 18	retail_complains
SELECT T1.year, T1.month, T1.day, T1.email, T1.phone FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.city = 'Indianapolis' ORDER BY T1.year DESC, T1.month DESC, T1.day DESC LIMIT 1	retail_complains
SELECT T2.city FROM reviews AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T1.Stars = 5 AND T1.Date LIKE '2016%' ORDER BY T1.Date DESC LIMIT 5	retail_complains
SELECT MAX(T1.ser_time) FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.issue = 'Arbitration'	retail_complains
SELECT T1.social, T1.state FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T2.state_abbrev = T3.StateCode WHERE T1.phone = '100-121-8371'	retail_complains
SELECT T1.first, T1.middle, T1.last, T1.phone FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.division = 'Pacific'	retail_complains
SELECT T1.social , 365 * (strftime('%Y', T2.`Date sent to company`) - strftime('%Y', T2.`Date received`)) + 30 * (strftime('%M', T2.`Date sent to company`) - strftime('%M', T2.`Date received`)) + (strftime('%d', T2.`Date sent to company`) - strftime('%d', T2.`Date received`)), T2.`Company response to consumer` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID ORDER BY 365 * (strftime('%Y', T2.`Date sent to company`) - strftime('%Y', T2.`Date received`)) + 30 * (strftime('%M', T2.`Date sent to company`) - strftime('%M', T2.`Date received`)) + (strftime('%d', T2.`Date sent to company`) - strftime('%d', T2.`Date received`)) DESC LIMIT 1	retail_complains
SELECT COUNT(sex) FROM client WHERE sex = 'Female' AND age > 30	retail_complains
SELECT first, last FROM client WHERE city = 'New York City'	retail_complains
SELECT MAX(age) FROM client WHERE sex = 'Male'	retail_complains
SELECT T2.division, COUNT(T2.division) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id GROUP BY T2.division	retail_complains
SELECT CAST(SUM(CASE WHEN T1.sex = 'Female' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.sex) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.division = 'South Atlantic'	retail_complains
SELECT AVG(T1.age) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.division = 'South Atlantic'	retail_complains
SELECT T2.city FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T2.state_abbrev = T3.StateCode WHERE T3.Region = 'Midwest' GROUP BY T2.city ORDER BY COUNT(T2.city) LIMIT 1	retail_complains
SELECT COUNT(T1.email) FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id INNER JOIN state AS T3 ON T2.state_abbrev = T3.StateCode WHERE T3.Region = 'Northeast' AND T1.email LIKE '%@outlook.com'	retail_complains
SELECT T2.city FROM client AS T1 INNER JOIN district AS T2 ON T1.district_id = T2.district_id WHERE T2.division = 'West North Central' AND T1.age > 60 GROUP BY T2.city ORDER BY COUNT(T2.city) DESC LIMIT 1	retail_complains
SELECT CAST(SUM(CASE WHEN T1.priority = 2 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.`Complaint ID`) FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE strftime('%Y', T1.`Date received`) = '2017'	retail_complains
SELECT state_abbrev FROM district GROUP BY state_abbrev ORDER BY COUNT(city) DESC LIMIT 1	retail_complains
SELECT T1.first, T1.phone FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Complaint ID` = 'CR0922485'	retail_complains
SELECT T1.email FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Date received` = '2014-07-03'	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.city = 'Omaha' AND strftime('%Y', T2.`Date received`) = '2012' AND T2.Product = 'Credit card'	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE strftime('%Y', T2.`Date received`) BETWEEN '2012' AND '2015' AND T2.`Submitted via` = 'Email' AND T1.sex = 'Male'	retail_complains
SELECT T1.phone, T2.`Complaint ID` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.`Company response to consumer` = 'In progress'	retail_complains
SELECT COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.city = 'Portland' AND T2.`Date received` LIKE '2015%' AND T2.Issue = 'Billing disputes'	retail_complains
SELECT CAST((SUM(CASE WHEN strftime('%J', T2.`Date sent to company`) - strftime('%J', T2.`Date received`) > 5 THEN 1 ELSE 0 END)) AS REAL) * 100 / COUNT(T1.client_id) FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.city = 'Houston' AND strftime('%Y', T2.`Date received`) = '2014'	retail_complains
SELECT COUNT(`Submitted via`) FROM events WHERE strftime('%Y', `Date received`) = '2012' AND `Submitted via` = 'Email'	retail_complains
SELECT T2.Client_ID FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.`Submitted via` = 'Fax' AND T1.`Date received` = '2014-04-16'	retail_complains
SELECT T2.Date FROM district AS T1 INNER JOIN reviews AS T2 ON T1.district_id = T2.district_id WHERE T2.Product = 'Eagle Capital' AND T1.city = 'Indianapolis' AND T1.state_abbrev = 'IN'	retail_complains
SELECT COUNT(T1.`Complaint ID`) FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE strftime('%Y', T1.`Date received`) = '2015' AND T2.`Timely response?` = 'Yes' AND T2.`Company response to consumer` = 'Closed with explanation'	retail_complains
SELECT DISTINCT T3.`Date received` FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID INNER JOIN callcenterlogs AS T3 ON T2.`Complaint ID` = T3.`Complaint ID` WHERE T1.age BETWEEN 20 AND 40 AND T1.sex = 'Female'	retail_complains
SELECT T2.Product FROM district AS T1 INNER JOIN reviews AS T2 ON T1.district_id = T2.district_id WHERE T1.city = 'Newton' AND T1.state_abbrev = 'MA' AND T2.Date = '2016-03-14' AND T2.Stars = 1	retail_complains
SELECT COUNT(T2.Stars) FROM district AS T1 INNER JOIN reviews AS T2 ON T1.district_id = T2.district_id WHERE T1.city = 'Nashville' AND T1.state_abbrev = 'TN' AND T2.Product = 'Eagle National Mortgage' AND T2.Stars = 5	retail_complains
SELECT DISTINCT T2.Issue FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.sex = 'Male' AND T1.age < 25	retail_complains
SELECT DISTINCT T3.Product FROM state AS T1 INNER JOIN district AS T2 ON T1.StateCode = T2.state_abbrev INNER JOIN reviews AS T3 ON T2.district_id = T3.district_id WHERE T1.Region = 'Midwest' AND T3.Stars = 1	retail_complains
SELECT DISTINCT T2.Product FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T1.server = 'TOVA' AND T2.`Date received` LIKE '2017-03%'	retail_complains
SELECT T1.division FROM district AS T1 INNER JOIN reviews AS T2 ON T1.district_id = T2.district_id WHERE T2.Stars = 5 AND T2.Date = '2017-12-17' AND T2.Product = 'Eagle National Mortgage'	retail_complains
SELECT T1.phone FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T2.Product = 'Credit card' ORDER BY T1.age DESC LIMIT 1	retail_complains
SELECT COUNT(T2.`Complaint ID`) FROM callcenterlogs AS T1 INNER JOIN events AS T2 ON T1.`Complaint ID` = T2.`Complaint ID` WHERE T2.`Submitted via` = 'Phone' AND strftime('%Y', T1.`Date received`) = '2014'	retail_complains
SELECT DISTINCT T2.Product, T2.Issue FROM client AS T1 INNER JOIN events AS T2 ON T1.client_id = T2.Client_ID WHERE T1.age * 100 > ( SELECT AVG(age) * 60 FROM client )	retail_complains
SELECT CAST(SUM(CASE WHEN T1.division = 'East North Central' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.division) FROM district AS T1 INNER JOIN reviews AS T2 ON T1.district_id = T2.district_id WHERE T2.Stars = 5	retail_complains
SELECT T1.company_name FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T3.title = 'Four Rooms'	movies_4
SELECT COUNT(CNAME) FROM ( SELECT T1.company_name AS CNAME FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T3.title = 'Four Rooms' )	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Universal Pictures'	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Universal Pictures' ORDER BY T3.release_date DESC LIMIT 1	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End' AND T2.job = 'Director of Photography'	movies_4
SELECT T2.job FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End' AND T3.person_name = 'Dariusz Wolski'	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End'	movies_4
SELECT COUNT(T3.person_id) FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End' AND T2.job = 'Producer'	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End' AND T2.job = 'Producer'	movies_4
SELECT COUNT(T2.movie_id) FROM person AS T1 INNER JOIN movie_crew AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Dariusz Wolski' AND T2.job = 'Director of Photography'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Dariusz Wolski' AND T2.job = 'Director of Photography' ORDER BY T1.vote_average DESC LIMIT 1	movies_4
SELECT T1.release_date FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Dariusz Wolski' ORDER BY T1.release_date DESC LIMIT 1	movies_4
SELECT CAST(COUNT(CASE WHEN T1.vote_average > 5 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.vote_average) FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Dariusz Wolski' AND T2.job = 'Director of Photography'	movies_4
SELECT CAST(SUM(T1.revenue) AS REAL) / COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Dariusz Wolski' AND T2.job = 'Director of Photography'	movies_4
SELECT title FROM movie WHERE revenue = 559852396	movies_4
SELECT T2.job FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'David Rubin' AND T1.title = 'Days of Thunder'	movies_4
SELECT COUNT(T2.movie_id) FROM person AS T1 INNER JOIN movie_crew AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Michael Bay' AND T2.job = 'Director'	movies_4
SELECT COUNT(T2.keyword_id) FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'I Hope They Serve Beer in Hell'	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title = 'Land of the Dead' AND T2.job = 'Director'	movies_4
SELECT COUNT(T2.movie_id) FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id WHERE T1.company_name = 'Paramount Animation'	movies_4
SELECT COUNT(*) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN gender AS T3 ON T2.gender_id = T3.gender_id WHERE T1.title = 'Spider-Man 3' AND T3.gender = 'Female'	movies_4
SELECT T1.keyword_name FROM keyword AS T1 INNER JOIN movie_keywords AS T2 ON T1.keyword_id = T2.keyword_id GROUP BY T1.keyword_name ORDER BY COUNT(T1.keyword_name) DESC LIMIT 1	movies_4
SELECT COUNT(T2.person_id) FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'The Amityville Horror' AND T2.job = 'Producer'	movies_4
SELECT T1.company_name FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T3.title = 'Crazy Heart'	movies_4
SELECT COUNT(T2.movie_id) FROM keyword AS T1 INNER JOIN movie_keywords AS T2 ON T1.keyword_id = T2.keyword_id WHERE keyword_name = 'saving the world'	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Cruel and Unusual Films' ORDER BY T3.popularity DESC LIMIT 1	movies_4
SELECT T4.department_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id INNER JOIN department AS T4 ON T2.department_id = T4.department_id WHERE T3.person_name = 'Marcia Ross' AND T1.title = 'Reign of Fire'	movies_4
SELECT CAST(SUM(T1.budget) AS REAL) / COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Jaume Collet-Serra' AND T2.job = 'Director'	movies_4
SELECT CAST(COUNT(CASE WHEN T3.gender = 'Male' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T3.gender) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN gender AS T3 ON T2.gender_id = T3.gender_id WHERE T1.title = 'Bride Wars'	movies_4
SELECT title FROM movie ORDER BY budget DESC LIMIT 1	movies_4
SELECT COUNT(movie_id) FROM movie WHERE revenue > 1000000000	movies_4
SELECT MIN(release_date) FROM movie WHERE movie_status = 'Released'	movies_4
SELECT COUNT(person_id) FROM person WHERE person_name = 'John Young'	movies_4
SELECT title FROM movie ORDER BY popularity DESC LIMIT 1	movies_4
SELECT person_name FROM person WHERE person_id = 1325273	movies_4
SELECT T1.company_name FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id GROUP BY T1.company_id ORDER BY COUNT(T2.movie_id) DESC LIMIT 1	movies_4
SELECT DISTINCT T3.person_name FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T2.character_name = 'Captain Jack Sparrow' AND T1.title LIKE 'Pirates of the Caribbean%'	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Walt Disney Pictures' ORDER BY T3.popularity DESC LIMIT 1	movies_4
SELECT COUNT(T2.movie_id) FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id WHERE T1.company_name = 'Universal Studios'	movies_4
SELECT T1.company_name FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id GROUP BY T1.company_id ORDER BY SUM(T3.revenue) DESC LIMIT 1	movies_4
SELECT COUNT(T3.gender) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN gender AS T3 ON T2.gender_id = T3.gender_id WHERE T1.title = 'Mr. Smith Goes to Washington' AND T3.gender = 'Female'	movies_4
SELECT T1.company_name FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id GROUP BY T1.company_id HAVING COUNT(T2.movie_id) > 200	movies_4
SELECT COUNT(T2.movie_id) FROM person AS T1 INNER JOIN movie_cast AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Harrison Ford'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Jamie Foxx' ORDER BY T1.release_date DESC LIMIT 1	movies_4
SELECT COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Quentin Tarantino' AND CAST(STRFTIME('%Y', T1.release_date) AS INT) = 1995	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T3.genre_name = 'Crime' ORDER BY T1.release_date LIMIT 1	movies_4
SELECT COUNT(T1.movie_id) FROM movie_genres AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.genre_id WHERE T2.genre_name = 'Horror'	movies_4
SELECT person_id FROM movie_crew WHERE movie_id = 12 AND job = 'Second Film Editor'	movies_4
SELECT COUNT(movie_id) FROM movie_crew WHERE movie_id = 129 AND job = 'Animation'	movies_4
SELECT COUNT(DISTINCT job) FROM movie_crew WHERE movie_id = 19 AND department_id = 7	movies_4
SELECT person_id, character_name FROM movie_cast WHERE movie_id = 285 AND cast_order BETWEEN 1 AND 10	movies_4
SELECT COUNT(T2.movie_id) FROM person AS T1 INNER JOIN movie_cast AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Bob Peterson'	movies_4
SELECT T2.movie_id, T2.character_name FROM person AS T1 INNER JOIN movie_cast AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Jim Carrey'	movies_4
SELECT T2.person_name FROM movie_cast AS T1 INNER JOIN person AS T2 ON T1.person_id = T2.person_id INNER JOIN gender AS T3 ON T1.gender_id = T3.gender_id WHERE T1.movie_id = 1865 AND T3.gender = 'Female'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Jim Carrey'	movies_4
SELECT T2.person_name FROM movie_cast AS T1 INNER JOIN person AS T2 ON T1.person_id = T2.person_id INNER JOIN movie AS T3 ON T1.movie_id = T3.movie_id INNER JOIN movie_crew AS T4 ON T1.movie_id = T4.movie_id WHERE T4.job = 'Director' AND T3.release_date BETWEEN '1916-01-01' AND '1925-12-31'	movies_4
SELECT COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Uma Thurman' AND T1.release_date BETWEEN '1990-01-01' AND '2000-12-31'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T3.genre_name = 'Horror' AND vote_average > 7	movies_4
SELECT T3.genre_name, T1.popularity FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T1.revenue > 120000000 AND T1.release_date BETWEEN '2012-01-01' AND '2015-12-31'	movies_4
SELECT COUNT(T2.movie_id) FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id WHERE T1.revenue > 75000000 AND T1.popularity >= 20 AND T1.release_date BETWEEN '1990-01-01' AND '2003-12-31'	movies_4
SELECT T1.title, T1.revenue, T3.COUNTry_name FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id ORDER BY T1.budget DESC LIMIT 1	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T3.language_name = 'Latin' AND T1.release_date BETWEEN '1990-01-01' AND '1995-12-31'	movies_4
SELECT AVG(T1.revenue) FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id WHERE T3.COUNTry_name = 'United States of America' AND CAST(STRFTIME('%Y', T1.release_date) AS INT) = 2006	movies_4
SELECT AVG(CASE WHEN T3.COUNTry_name = 'United States of America' THEN T1.revenue END) - AVG(CASE WHEN T3.COUNTry_name = 'India' THEN T1.revenue END) AS CALCULATE FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id WHERE CAST(STRFTIME('%Y', T1.release_date) AS INT) = 2016	movies_4
SELECT CAST(COUNT(CASE WHEN T4.genre_name = 'Romance' THEN T1.movie_id ELSE NULL END) AS REAL) * 100 / COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN production_COUNTry AS T3 ON T1.movie_id = T3.movie_id INNER JOIN genre AS T4 ON T2.genre_id = T4.genre_id INNER JOIN COUNTry AS T5 ON T3.COUNTry_id = T5.COUNTry_id WHERE T5.COUNTry_name = 'India' AND T1.release_date BETWEEN '2015-01-01' AND '2015-12-31'	movies_4
SELECT DISTINCT T1.person_name FROM person AS T1 INNER JOIN movie_cast AS T2 ON T1.person_id = T2.person_id WHERE T2.character_name = 'Optimus Prime (voice)'	movies_4
SELECT T2.gender FROM movie_cast AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.gender_id WHERE T1.character_name = 'USAF Master Sgt. Epps'	movies_4
SELECT T1.company_name FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T3.title = 'Ultramarines: A Warhammer 40,000 Movie'	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Radiant Film GmbH'	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T1.title = 'Sky Captain and the World of Tomorrow'	movies_4
SELECT T3.keyword_name FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T1.title = 'Sky Captain and the World of Tomorrow'	movies_4
SELECT T3.COUNTry_name FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id WHERE T1.title = 'Gojira ni-sen mireniamu'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T3.keyword_name = 'extremis'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id WHERE T3.COUNTry_name = 'France' LIMIT 10	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title = 'Transformers' AND T2.job = 'Director'	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title = 'Mad Max: Fury Road' LIMIT 10	movies_4
SELECT CAST(COUNT(CASE WHEN T4.genre_name = 'Animation' THEN T1.movie_id ELSE NULL END) AS REAL) * 100 / COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN production_COUNTry AS T3 ON T1.movie_id = T3.movie_id INNER JOIN genre AS T4 ON T2.genre_id = T4.genre_id INNER JOIN COUNTry AS T5 ON T3.COUNTry_id = T5.COUNTry_id WHERE T5.COUNTry_name = 'Japan'	movies_4
SELECT CAST(COUNT(CASE WHEN T3.gender = 'Male' THEN 1 ELSE NULL END) AS REAL) / COUNT(CASE WHEN T3.gender = 'Female' THEN 1 ELSE NULL END) AS RATIO , COUNT(CASE WHEN T3.gender = 'Unspecified' THEN 1 ELSE NULL END) AS UNGENDERS FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN gender AS T3 ON T2.gender_id = T3.gender_id WHERE T1.title = 'Iron Man'	movies_4
SELECT title FROM movie WHERE CAST(STRFTIME('%Y', release_date) AS INT) < 2000 LIMIT 5	movies_4
SELECT T2.keyword_id FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'Sin City'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T3.keyword_name = 'angel'	movies_4
SELECT T3.keyword_name FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id ORDER BY T1.popularity DESC LIMIT 1	movies_4
SELECT T2.genre_id FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'The Dark Knight'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T3.genre_name = 'Thriller'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T1.movie_status = 'Rumored' AND T3.genre_name = 'Drama' LIMIT 5	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id ORDER BY T1.revenue LIMIT 1	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T1.runtime = 14	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id ORDER BY T1.vote_average DESC, T1.revenue LIMIT 1	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T3.genre_id = T2.genre_id WHERE T1.tagline = 'A long time ago in a galaxy far, far away...'	movies_4
SELECT T2.COUNTry_id FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title LIKE 'Pirates of the Caribbean: Dead Man%s Chest'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id WHERE T3.COUNTry_name = 'Canada'	movies_4
SELECT SUM(T1.budget) FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T3.keyword_name = 'video game'	movies_4
SELECT AVG(T1.revenue) FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T3.keyword_name = 'civil war'	movies_4
SELECT popularity FROM movie ORDER BY vote_COUNT DESC LIMIT 1	movies_4
SELECT title FROM movie WHERE budget = 0 ORDER BY revenue DESC LIMIT 1	movies_4
SELECT T2.company_id FROM movie AS T1 INNER JOIN movie_company AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'Gladiator'	movies_4
SELECT T2.company_id FROM movie AS T1 INNER JOIN movie_company AS T2 ON T1.movie_id = T2.movie_id WHERE CAST(STRFTIME('%Y', T1.release_date) AS INT) = 1916	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Lucasfilm'	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Warner Bros. Pictures' ORDER BY T3.revenue DESC LIMIT 1	movies_4
SELECT T3.release_date FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Twentieth Century Fox Film Corporation'	movies_4
SELECT T2.language_id FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'Walk the Line'	movies_4
SELECT T2.language_id FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id ORDER BY T1.popularity DESC LIMIT 1	movies_4
SELECT T3.language_name FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T1.title LIKE 'C%era una volta il West'	movies_4
SELECT DISTINCT CASE WHEN T1.movie_status = 'Post Production' THEN 'YES' ELSE 'NO' END AS YORN FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T3.language_name = 'Nederlands'	movies_4
SELECT DISTINCT T1.tagline FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T3.language_name = 'Polski'	movies_4
SELECT DISTINCT T1.homepage FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T3.language_name = 'Bahasa indonesia'	movies_4
SELECT SUM(CASE WHEN T3.language_name = 'English' THEN T1.revenue ELSE 0 END) - SUM(CASE WHEN T3.language_name = 'Latin' THEN T1.revenue ELSE 0 END) AS DIFFERENCE FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id	movies_4
SELECT SUM(T3.revenue) FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name IN ('Fantasy Films', 'Live Entertainment')	movies_4
SELECT AVG(T1.revenue) FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T3.language_name = 'Latin'	movies_4
SELECT person_name FROM person GROUP BY person_name ORDER BY COUNT(person_name) DESC LIMIT 1	movies_4
SELECT CAST(SUM(CD) AS REAL) / COUNT(movie_id) FROM ( SELECT movie_id, COUNT(person_id) AS CD FROM movie_crew GROUP BY movie_id )	movies_4
SELECT keyword_name FROM keyword WHERE keyword_name LIKE '%christmas%'	movies_4
SELECT MAX(runtime) FROM movie	movies_4
SELECT COUNTry_iso_code FROM COUNTry WHERE COUNTry_name = 'Kyrgyz Republic'	movies_4
SELECT overview FROM movie WHERE title = 'The Pacifier'	movies_4
SELECT COUNT(T1.movie_id) FROM movie_company AS T1 INNER JOIN production_company AS T2 ON T1.company_id = T2.company_id WHERE T2.company_name = 'Eddie Murphy Productions'	movies_4
SELECT DISTINCT T1.person_name FROM person AS T1 INNER JOIN movie_cast AS T2 ON T1.person_id = T2.person_id WHERE T2.character_name LIKE '%captain%'	movies_4
SELECT T3.keyword_name FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T1.release_date LIKE '2006%' GROUP BY T3.keyword_name ORDER BY COUNT(T3.keyword_name) DESC LIMIT 1	movies_4
SELECT COUNT(T1.movie_id) FROM movie_languages AS T1 INNER JOIN language AS T2 ON T1.language_id = T2.language_id WHERE T2.language_code = 'vi'	movies_4
SELECT T2.genre_name FROM movie_genres AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.genre_id GROUP BY T2.genre_id ORDER BY COUNT(T1.movie_id) LIMIT 2, 1	movies_4
SELECT T3.language_name FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id INNER JOIN language_role AS T4 ON T2.language_role_id = T4.role_id WHERE T4.language_role = 'Original' AND T1.tagline LIKE 'An offer you can%t refuse.'	movies_4
SELECT AVG(T1.revenue) FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id WHERE T3.COUNTry_name = 'France'	movies_4
SELECT T1.character_name FROM movie_cast AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.gender_id WHERE T2.gender = 'Unspecified'	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T2.job = 'Director' ORDER BY T1.popularity DESC LIMIT 5	movies_4
SELECT T3.genre_name, MAX(T1.budget) FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id GROUP BY T3.genre_name	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id GROUP BY T1.title ORDER BY COUNT(T2.keyword_id) DESC LIMIT 1	movies_4
SELECT T1.department_name FROM department AS T1 INNER JOIN movie_crew AS T2 ON T1.department_id = T2.department_id GROUP BY T1.department_id ORDER BY COUNT(T2.department_id) DESC LIMIT 1	movies_4
SELECT CAST(COUNT(CASE WHEN T3.COUNTry_iso_code = 'US' THEN T1.movie_id ELSE NULL END) AS REAL) * 100 / COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN production_COUNTry AS T2 ON T1.movie_id = T2.movie_id INNER JOIN COUNTry AS T3 ON T2.COUNTry_id = T3.COUNTry_id	movies_4
SELECT CAST(COUNT(CASE WHEN T2.gender = 'Female' THEN T1.person_id ELSE NULL END) AS REAL) / COUNT(CASE WHEN T2.gender = 'Male' THEN T1.person_id ELSE NULL END) FROM movie_cast AS T1 INNER JOIN gender AS T2 ON T1.gender_id = T2.gender_id	movies_4
SELECT title FROM movie WHERE CAST(STRFTIME('%Y', release_date) AS INT) = 1945	movies_4
SELECT COUNTry_id, COUNTry_iso_code FROM COUNTry WHERE COUNTry_name = 'Belgium'	movies_4
SELECT T2.character_name FROM person AS T1 INNER JOIN movie_cast AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Catherine Deneuve'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id WHERE T3.language_name = 'Somali'	movies_4
SELECT T1.release_date, T3.language_name FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id ORDER BY T1.popularity DESC LIMIT 1	movies_4
SELECT T3.language_name FROM movie AS T1 INNER JOIN movie_languages AS T2 ON T1.movie_id = T2.movie_id INNER JOIN language AS T3 ON T2.language_id = T3.language_id INNER JOIN language_role AS T4 ON T2.language_role_id = T4.role_id WHERE T4.language_role = 'Original' AND T1.title = 'Four Rooms'	movies_4
SELECT T2.character_name FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id WHERE T1.title = 'Open Water'	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End' ORDER BY T2.cast_order LIMIT 1	movies_4
SELECT T1.person_name FROM person AS T1 INNER JOIN movie_crew AS T2 ON T1.person_id = T2.person_id WHERE T2.job = 'Camera Supervisor'	movies_4
SELECT DISTINCT T2.job FROM person AS T1 INNER JOIN movie_crew AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Sally Menke'	movies_4
SELECT T3.person_name, T4.department_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id INNER JOIN department AS T4 ON T2.department_id = T4.department_id WHERE T1.title LIKE 'Pirates of the Caribbean: At World%s End' AND T2.job = 'Music Editor'	movies_4
SELECT T1.title, T1.revenue FROM movie AS T1 INNER JOIN movie_company AS T2 ON T1.movie_id = T2.movie_id INNER JOIN production_company AS T3 ON T2.company_id = T3.company_id WHERE T3.company_name = 'DreamWorks'	movies_4
SELECT COUNT(T2.movie_id) FROM COUNTry AS T1 INNER JOIN production_COUNTry AS T2 ON T1.COUNTry_id = T2.COUNTry_id WHERE T1.COUNTry_name = 'Canada'	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T1.title = 'Forrest Gump'	movies_4
SELECT T.company_name FROM ( SELECT DISTINCT T3.company_name, T1.runtime FROM movie AS T1 INNER JOIN movie_company AS T2 ON T1.movie_id = T2.movie_id INNER JOIN production_company AS T3 ON T3.company_id = T2.company_id WHERE T1.release_date LIKE '2016%' ) T WHERE T.runtime * 100 > (0.35 * ( SELECT AVG(T1.runtime) FROM movie AS T1 INNER JOIN movie_company AS T2 ON T1.movie_id = T2.movie_id INNER JOIN production_company AS T3 ON T3.company_id = T2.company_id WHERE T1.release_date LIKE '2016%' ) + ( SELECT AVG(T1.runtime) FROM movie AS T1 INNER JOIN movie_company AS T2 ON T1.movie_id = T2.movie_id INNER JOIN production_company AS T3 ON T3.company_id = T2.company_id WHERE T1.release_date LIKE '2016%' )) * 100	movies_4
SELECT CAST((SUM(CASE WHEN T1.keyword_name = 'woman director' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.keyword_name = 'independent film' THEN 1 ELSE 0 END)) AS REAL) * 100 / SUM(CASE WHEN T1.keyword_name = 'independent film' THEN 1 ELSE 0 END) FROM keyword AS T1 INNER JOIN movie_keywords AS T2 ON T1.keyword_id = T2.keyword_id	movies_4
SELECT T3.genre_name FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T1.title = 'Dancer in the Dark'	movies_4
SELECT COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T3.genre_name = 'Adventure' AND CAST(STRFTIME('%Y', T1.release_date) AS INT) = 2000	movies_4
SELECT T3.title FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id INNER JOIN movie AS T3 ON T2.movie_id = T3.movie_id WHERE T1.company_name = 'Paramount Pictures' AND CAST(STRFTIME('%Y', T3.release_date) AS INT) = 2000	movies_4
SELECT T3.keyword_name FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T1.title = 'Finding Nemo'	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id WHERE T3.genre_name = 'Horror' AND T1.vote_average > 7	movies_4
SELECT COUNT(*) FROM ( SELECT T1.company_name AS CNAME FROM production_company AS T1 INNER JOIN movie_company AS T2 ON T1.company_id = T2.company_id GROUP BY T1.company_id HAVING COUNT(T1.company_name) > 150 )	movies_4
SELECT T2.job FROM person AS T1 INNER JOIN movie_crew AS T2 ON T1.person_id = T2.person_id WHERE T1.person_name = 'Mark Hammel'	movies_4
SELECT COUNT(T2.cast_order) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN gender AS T3 ON T3.gender_id = T2.gender_id WHERE T3.gender = 'Male' OR T3.gender = 'Female' AND T1.title = 'Pirates of the Caribbean: At World''s End' AND T2.cast_order = ( SELECT MIN(T2.cast_order) FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN gender AS T3 ON T3.gender_id = T2.gender_id WHERE T3.gender = 'Male' OR T3.gender = 'Female' AND T1.title = 'Pirates of the Caribbean: At World''s End' )	movies_4
SELECT T1.title FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T3.person_name = 'Harrison Ford'	movies_4
SELECT T2.character_name FROM movie AS T1 INNER JOIN movie_cast AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title = 'Pirates of the Caribbean: The Curse of the Black Pearl' AND T3.person_name = 'Orlando Bloom'	movies_4
SELECT CAST(COUNT(CASE WHEN T3.genre_name = 'Horror' THEN T1.movie_id ELSE NULL END) AS REAL) / COUNT(T1.movie_id) FROM movie AS T1 INNER JOIN movie_genres AS T2 ON T1.movie_id = T2.movie_id INNER JOIN genre AS T3 ON T2.genre_id = T3.genre_id	movies_4
SELECT T3.person_name FROM movie AS T1 INNER JOIN movie_crew AS T2 ON T1.movie_id = T2.movie_id INNER JOIN person AS T3 ON T2.person_id = T3.person_id WHERE T1.title = 'Pirates of the Caribbean: The Curse of the Black Pearl' AND T2.job = 'Producer'	movies_4
SELECT AVG(T1.revenue), T1.title FROM movie AS T1 INNER JOIN movie_keywords AS T2 ON T1.movie_id = T2.movie_id INNER JOIN keyword AS T3 ON T2.keyword_id = T3.keyword_id WHERE T3.keyword_name = 'paris'	movies_4
SELECT COUNT(Lang) FROM Method WHERE Lang = 'en' AND CommentIsXml = 1	codebase_comments
SELECT SUBSTR(SUBSTR(Name, INSTR(Name, '.') + 1), 1, INSTR(SUBSTR(Name, INSTR(Name, '.') + 1), '.') - 1) task FROM Method WHERE NameTokenized = 'online median filter test median window filling'	codebase_comments
SELECT DISTINCT SampledAt, SolutionId FROM Method WHERE SampledAt = ( SELECT MAX(SampledAt) FROM Method )	codebase_comments
SELECT Forks, Url FROM Repo WHERE Forks = ( SELECT MAX(Forks) FROM Repo )	codebase_comments
SELECT RepoId FROM solution GROUP BY RepoId ORDER BY COUNT(Path) DESC LIMIT 1	codebase_comments
SELECT Url, Stars FROM Repo WHERE Stars = ( SELECT MAX(Stars) FROM Repo )	codebase_comments
SELECT Path FROM Solution WHERE ProcessedTime = ( SELECT MAX(ProcessedTime) FROM Solution )	codebase_comments
SELECT ProcessedTime FROM Repo WHERE Watchers = ( SELECT MAX(Watchers) FROM Repo )	codebase_comments
SELECT Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE Path = 'nofear_MaraMara.sln'	codebase_comments
SELECT DISTINCT T1.id, T2.WasCompiled FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.ProcessedTime = ( SELECT MAX(ProcessedTime) FROM Repo )	codebase_comments
SELECT DISTINCT T2.NameTokenized FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'maravillas_linq-to-delicious'	codebase_comments
SELECT T2.RepoId, COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars BETWEEN 6000 AND 9000 AND T2.WasCompiled = 0 GROUP BY T2.RepoId ORDER BY COUNT(T2.RepoId) DESC LIMIT 1	codebase_comments
SELECT T3.ApiCalls FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId INNER JOIN Method AS T3 ON T2.Id = T3.SolutionId WHERE T1.Url = 'https://github.com/wallerdev/htmlsharp.git'	codebase_comments
SELECT COUNT(DISTINCT T2.Path) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Watchers = ( SELECT Watchers FROM Repo ORDER BY Watchers DESC LIMIT 1, 1 )	codebase_comments
SELECT CAST(SUM(T2.ProcessedTime) AS REAL) / COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/zphingphong/DiscardCustomerApp.git'	codebase_comments
SELECT T2.FullComment FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'bmatzelle_niniSourceNini.sln' AND T2.NameTokenized = 'alias text add alias'	codebase_comments
SELECT T2.ApiCalls FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'mauriciodeamorim_tdd.encontro2Tdd.Encontro2.sln'	codebase_comments
SELECT COUNT(T2.Path) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/jeffdik/tachy.git' AND T2.WasCompiled = 0	codebase_comments
SELECT DISTINCT T1.ProcessedTime, T2.Lang FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized = 'about box1 dispose'	codebase_comments
SELECT T2.SampledAt FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'maxild_playgroundPlayground.sln' AND T2.Name = 'GitHubRepo.Cli.GitHubClientWrapper.GetReleases'	codebase_comments
SELECT T2.Lang FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'opendns_diagnosticappwindowsOpenDnsDiagnostic.sln'	codebase_comments
SELECT SUBSTR(SUBSTR(Name, INSTR(Name, '.') + 1), 1, INSTR(SUBSTR(Name, INSTR(Name, '.') + 1), '.') - 1) task FROM Method WHERE NameTokenized = 'html parser feed'	codebase_comments
SELECT CASE WHEN CommentIsXml = 0 THEN 'No' WHEN CommentIsXml = 1 THEN 'Yes' END isXMLFormat FROM Method WHERE Name = 'HtmlSharp.HtmlParser.Feed'	codebase_comments
SELECT Name FROM Method WHERE Summary = 'Write a command to the log'	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = ( SELECT MAX(Stars) FROM Repo )	codebase_comments
SELECT DISTINCT T2.Path FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = ( SELECT MAX(Stars) FROM Repo )	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 12	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Forks > 1000 AND T2.WasCompiled = 1	codebase_comments
SELECT CASE WHEN SUM(CASE WHEN T2.Id = 18 THEN T1.Watchers ELSE 0 END) > SUM(CASE WHEN T2.Id = 19 THEN T1.Watchers ELSE 0 END) THEN 'SolutionID18' WHEN SUM(CASE WHEN T2.Id = 18 THEN T1.Watchers ELSE 0 END) < SUM(CASE WHEN T2.Id = 19 THEN T1.Watchers ELSE 0 END) THEN 'SolutionID19' END isMorePopular FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.ProcessedTime = ( SELECT MAX(ProcessedTime) FROM Repo ) AND T2.WasCompiled = 1	codebase_comments
SELECT DISTINCT T2.ProcessedTime FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Path = 'jeffdik_tachysrcTachy.sln'	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 9	codebase_comments
SELECT T2.Path FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/maxild/playground.git'	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.ProcessedTime < 636439500080712000 AND T1.Stars > 200	codebase_comments
SELECT T2.Id FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId ORDER BY T1.Forks DESC LIMIT 3	codebase_comments
SELECT CAST(SUM(T2.ProcessedTime) AS REAL) / COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/jeffdik/tachy.git'	codebase_comments
SELECT CAST((SUM(CASE WHEN T2.Id = 18 THEN T1.Forks ELSE 0 END) - SUM(CASE WHEN T2.Id = 19 THEN T1.Forks ELSE 0 END)) AS REAL) * 100 / SUM(CASE WHEN T2.Id = 19 THEN T1.Forks ELSE 0 END) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId	codebase_comments
SELECT Lang FROM Method WHERE Name = 'PixieTests.SqlConnectionLayerTests.TestSqlCreateGuidColumn'	codebase_comments
SELECT FullComment FROM Method WHERE Name = 'DE2_UE_Fahrradkurier.de2_uebung_fahrradkurierDataSet1TableAdapters.TableAdapterManager.UpdateInsertedRows'	codebase_comments
SELECT DISTINCT Summary FROM Method WHERE Name = 'Castle.MonoRail.Framework.Test.StubViewComponentContext.RenderSection'	codebase_comments
SELECT NameTokenized FROM Method WHERE Name = 'Supay.Irc.Messages.KnockMessage.GetTokens'	codebase_comments
SELECT T1.Stars FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 45997	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = 8094	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'IQ.Data.DbQueryProvider.CanBeEvaluatedLocally'	codebase_comments
SELECT T1.ProcessedTime FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized = 'interp parser expr'	codebase_comments
SELECT T1.RepoId FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'SCore.Poisson.ngtIndex'	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'ExportToRTF.RTFStyleSheet.H6Write'	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Watchers = 8094	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId GROUP BY T2.RepoId ORDER BY COUNT(T2.RepoId) DESC LIMIT 1	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Forks = 1445	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Lang = 'zh-cn' GROUP BY T1.Path ORDER BY COUNT(T1.Path) DESC LIMIT 1	codebase_comments
SELECT T1.Watchers FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 338082	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = 189 AND T2.WasCompiled = 0	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'Mosa.Platform.x86.Instructions.IMul.EmitLegacy'	codebase_comments
SELECT DISTINCT T1.ProcessedTime FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized = 't jadwal entity get single mpic'	codebase_comments
SELECT DISTINCT T1.RepoId FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'Kalibrasi.Data.EntityClasses.THistoryJadwalEntity.GetSingleTjadwal'	codebase_comments
SELECT DISTINCT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Summary = 'Refetches the Entity FROM the persistent storage. Refetch is used to re-load an Entity which is marked "Out-of-sync", due to a save action. Refetching an empty Entity has no effect.'	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = 3060	codebase_comments
SELECT DISTINCT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Lang = 'sw'	codebase_comments
SELECT CAST(SUM(CASE WHEN T2.Id = 83855 THEN T1.Watchers ELSE 0 END) - SUM(CASE WHEN T2.Id = 1502 THEN T1.Watchers ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T2.Id = 1502 THEN T1.Watchers ELSE 0 END) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId	codebase_comments
SELECT CAST(SUM(CASE WHEN T2.Id = 51424 THEN T1.Stars ELSE 0 END) - SUM(CASE WHEN T2.Id = 167053 THEN T1.Stars ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T2.Id = 167053 THEN T1.Stars ELSE 0 END) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId	codebase_comments
SELECT CAST(SUM(CASE WHEN T2.Id = 53546 THEN T1.Forks ELSE 0 END) - SUM(CASE WHEN T2.Id = 1502 THEN T1.Forks ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T2.Id = 1502 THEN T1.Forks ELSE 0 END) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId	codebase_comments
SELECT DISTINCT T2.Name FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.ProcessedTime = 636449700980488000	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/derickbailey/presentations-and-training.git'	codebase_comments
SELECT SUM(T2.ProcessedTime) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Forks = ( SELECT MAX(Forks) FROM Repo )	codebase_comments
SELECT DISTINCT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Lang = 'it'	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'spinachLexer.mT__55'	codebase_comments
SELECT DISTINCT T2.id FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.RepoId = 1093 AND T2.Lang = 'en'	codebase_comments
SELECT DISTINCT T2.Path FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/ecoffey/Bebop.git'	codebase_comments
SELECT DISTINCT T1.RepoId FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Lang = 'ro'	codebase_comments
SELECT T1.RepoId FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized = 'crc parameters get hash code'	codebase_comments
SELECT COUNT(T2.SolutionId) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'maravillas_linq-to-delicious\tasty.sln'	codebase_comments
SELECT T2.Id FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.ProcessedTime = 636430969128176000	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.ProcessedTime = ( SELECT MAX(ProcessedTime) FROM Solution )	codebase_comments
SELECT DISTINCT T2.Id FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Forks > T1.Watchers / 2	codebase_comments
SELECT CAST(T1.Forks AS REAL) * 100 / T1.Stars FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 104086	codebase_comments
SELECT Id FROM Repo WHERE Stars = ( SELECT MAX(Stars) FROM Repo )	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Name = 'HtmlSharp.HtmlParser.Feed'	codebase_comments
SELECT T1.Forks FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 35	codebase_comments
SELECT T2.Id FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Watchers = ( SELECT MAX(Watchers) FROM Repo )	codebase_comments
SELECT T1.Stars FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 20	codebase_comments
SELECT COUNT(T2.SolutionId) , CASE WHEN T1.WasCompiled = 0 THEN 'Needs' ELSE 'NoNeeds' END needToCompile FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.SolutionId = 1	codebase_comments
SELECT CAST(SUM(CASE WHEN T1.WasCompiled = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.SolutionId) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.CommentIsXml = 1	codebase_comments
SELECT T2.Name FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'wallerdev_htmlsharpHtmlSharp.sln'	codebase_comments
SELECT CAST(SUM(CASE WHEN Stars > 2000 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Stars) FROM Repo	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Id = 1	codebase_comments
SELECT Id FROM Repo WHERE Stars = 21 AND Forks = ( SELECT MAX(Forks) FROM Repo WHERE Stars = 21 )	codebase_comments
SELECT CAST(SUM(CASE WHEN Lang = 'en' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Name) FROM Method WHERE CommentIsXml = 1	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized = 'html parser feed'	codebase_comments
SELECT T2.Id FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Forks = 238	codebase_comments
SELECT NameTokenized FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE Lang = 'en' AND WasCompiled = 0	codebase_comments
SELECT COUNT(T2.RepoId) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Forks < T1.Stars * 1 / 3	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.FullComment = 'Feeds data into the parser'	codebase_comments
SELECT COUNT(T2.SolutionId) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.RepoId = 3 AND T2.CommentIsXml = 1	codebase_comments
SELECT CAST(SUM(CASE WHEN T1.WasCompiled = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Lang) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Lang = 'en'	codebase_comments
SELECT CAST(SUM(CASE WHEN T2.Id = 1 THEN T1.Stars ELSE 0 END) - SUM(CASE WHEN T2.Id = 2 THEN T1.Stars ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T2.Id = 2 THEN T1.Stars ELSE 0 END) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId	codebase_comments
SELECT COUNT(DISTINCT T1.Id) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars > CAST(T1.Forks AS REAL) / 3	codebase_comments
SELECT SUBSTR(SUBSTR(Name, INSTR(Name, '.') + 1), 1, INSTR(SUBSTR(Name, INSTR(Name, '.') + 1), '.') - 1) task FROM Method WHERE Id = 2	codebase_comments
SELECT CASE WHEN CommentIsXml = 0 THEN 'isNotXMLFormat' WHEN CommentIsXml = 1 THEN 'isXMLFormat' END format FROM Method WHERE Id = 8	codebase_comments
SELECT Url FROM Repo WHERE Watchers = ( SELECT MAX(Watchers) FROM Repo )	codebase_comments
SELECT DISTINCT SUBSTR(SUBSTR(Name, INSTR(Name, '.') + 1), 1, INSTR(SUBSTR(Name, INSTR(Name, '.') + 1), '.') - 1) task FROM Method WHERE Lang = 'cs'	codebase_comments
SELECT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Id = 3	codebase_comments
SELECT T2.Lang FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Id = 28 AND T1.RepoId = 3	codebase_comments
SELECT T1.ProcessedTime, COUNT(T2.SolutionId) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.SolutionId = 1	codebase_comments
SELECT COUNT(T2.SolutionId) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized LIKE 'query language%'	codebase_comments
SELECT T2.ApiCalls, T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Id = 10	codebase_comments
SELECT COUNT(T2.SolutionId) FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.RepoId = 150 AND T2.FullComment IS NULL AND T2.Summary IS NULL	codebase_comments
SELECT CASE WHEN T2.CommentIsXml = 0 THEN 'isNotXMLFormat' WHEN T2.CommentIsXml = 1 THEN 'isXMLFormat' END format FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.Id = 50 AND T1.Path = 'managedfusion_managedfusionManagedFusion.sln'	codebase_comments
SELECT DISTINCT SUBSTR(SUBSTR(Name, INSTR(Name, '.') + 1), 1, INSTR(SUBSTR(Name, INSTR(Name, '.') + 1), '.') - 1) task FROM Method WHERE NameTokenized = 'string extensions to pascal case'	codebase_comments
SELECT NameTokenized FROM Method WHERE Name = 'Sky.Excel.ExcelBook.TypeConvert'	codebase_comments
SELECT COUNT(DISTINCT T2.Path) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Url = 'https://github.com/jeffdik/tachy.git'	codebase_comments
SELECT T1.Watchers FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Path = 'maff_se3ue7US7.sln'	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.WasCompiled = 1 LIMIT 5	codebase_comments
SELECT DISTINCT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.NameTokenized = 'matrix multiply'	codebase_comments
SELECT COUNT(T3.CommentIsXml) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId INNER JOIN Method AS T3 ON T2.Id = T3.SolutionId WHERE T1.Url = 'https://github.com/dogeth/vss2git.git' AND T3.CommentIsXml = 1	codebase_comments
SELECT DISTINCT T1.Path FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T2.SampledAt = 636431758961741000 LIMIT 5	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Path = 'joeyrobert_bloomfilterDataTypes.BloomFilter.sln'	codebase_comments
SELECT DISTINCT T2.Name FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'graffen_NLog.Targets.SyslogsrcNLog.Targets.Syslog.sln'	codebase_comments
SELECT DISTINCT T2.NameTokenized FROM Solution AS T1 INNER JOIN Method AS T2 ON T1.Id = T2.SolutionId WHERE T1.Path = 'jurney_P4BackupP4BackupP4Backup.sln'	codebase_comments
SELECT T1.Url FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId INNER JOIN Method AS T3 ON T2.Id = T3.SolutionId WHERE T3.Summary = 'A test for Decompose'	codebase_comments
SELECT DISTINCT T1.Stars FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T2.Path = 'ninject_NinjectNinject.sln'	codebase_comments
SELECT COUNT(T2.Path) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = 111 AND T1.Forks = 58 AND T1.Watchers = 111	codebase_comments
SELECT CAST(SUM(T2.ProcessedTime) AS REAL) / COUNT(T2.ProcessedTime) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId WHERE T1.Stars = 254 AND T1.Forks = 88 AND T1.Watchers = 254	codebase_comments
SELECT COUNT(DISTINCT T3.Lang) FROM Repo AS T1 INNER JOIN Solution AS T2 ON T1.Id = T2.RepoId INNER JOIN Method AS T3 ON T2.Id = T3.SolutionId WHERE T1.Url = 'https://github.com/managedfusion/managedfusion.git'	codebase_comments
SELECT COUNT(id) FROM trains WHERE direction = 'east'	trains
SELECT COUNT(id) FROM cars WHERE train_id = 1	trains
SELECT shape FROM cars WHERE train_id = 1 AND position = 4	trains
SELECT train_id FROM cars WHERE shape IN ('elipse', 'bucket') GROUP BY train_id	trains
SELECT COUNT(id) FROM cars WHERE train_id = 1 AND roof = 'none'	trains
SELECT id FROM cars WHERE train_id = 1 AND wheels = 2	trains
SELECT SUM(CASE WHEN T1.shape IN ('bucket', 'elipse') THEN 1 ELSE 0 end)as count FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east'	trains
SELECT T1.id FROM trains AS T1 INNER JOIN ( SELECT train_id, MAX(position) AS carsNum FROM cars GROUP BY train_id ) AS T2 ON T1.id = T2.train_id WHERE T1.direction = 'east' AND T2.carsNum < 4	trains
SELECT T1.id FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east' AND T1.sides = 'double'	trains
SELECT SUM(CASE WHEN T2.longCarsNum > 2 THEN 1 ELSE 0 END)as count FROM trains AS T1 INNER JOIN ( SELECT train_id, COUNT(id) AS longCarsNum FROM cars WHERE len = 'long' GROUP BY train_id ) AS T2 ON T1.id = T2.train_id WHERE T1.direction = 'west'	trains
SELECT T2.direction FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.load_num = 0	trains
SELECT T2.direction FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.shape = 'ellipse'	trains
SELECT SUM(CASE WHEN T1.len = 'short' then 1 ELSE 0 END)as count FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east'	trains
SELECT T1.shape FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east' AND T1.position = 1 GROUP BY T1.shape	trains
SELECT SUM(CASE WHEN T1.roof = 'flat' THEN 1 ELSE 0 END)as count FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east'	trains
SELECT SUM(CASE WHEN T1.load_shape = 'circle' THEN 1 ELSE 0 END)as count FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east' AND T1.roof = 'flat' 	trains
SELECT T1.direction FROM trains AS T1 INNER JOIN ( SELECT train_id, COUNT(id) AS rectCarsNum FROM cars WHERE shape = 'rectangle' GROUP BY train_id ) AS T2 ON T1.id = T2.train_id ORDER BY T2.rectCarsNum DESC	trains
SELECT T2.direction FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.len = 'short' AND T1.position = 4	trains
SELECT CAST(COUNT(T1.id) AS REAL) / COUNT(DISTINCT T1.train_id) FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T2.direction = 'east'	trains
SELECT CAST(COUNT(DISTINCT CASE WHEN T2.direction = 'east' THEN T1.train_id ELSE NULL END) AS REAL) * 100 / COUNT(DISTINCT T1.train_id) FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.shape IN ('bucket', 'ellipse')	trains
SELECT COUNT(id) FROM cars WHERE shape = 'hexagon' AND len = 'short'	trains
SELECT COUNT(id) FROM trains WHERE direction = 'west'	trains
SELECT load_shape FROM cars WHERE shape = 'ellipse' AND len = 'short'	trains
SELECT id FROM trains WHERE direction = 'east'	trains
SELECT SUM(wheels) FROM cars WHERE len = 'long'	trains
SELECT direction FROM trains GROUP BY direction ORDER BY COUNT(id) DESC	trains
SELECT SUM(CASE WHEN T1.direction = 'east' THEN 1 ELSE 0 END)as count FROM trains AS T1 INNER JOIN ( SELECT train_id, COUNT(id) AS carsNum FROM cars GROUP BY train_id ) AS T2 ON T1.id = T2.train_id WHERE T2.carsNum >= 4	trains
SELECT T2.direction FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.position = 2 AND T1.shape = 'rectangle' GROUP BY T2.direction ORDER BY COUNT(T2.id) DESC LIMIT 1	trains
SELECT COUNT(T.train_id) FROM (SELECT T1.train_id FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.position = 3 AND T2.direction = 'west' AND T1.sides = 'double' GROUP BY T1.train_id)as T	trains
SELECT COUNT(T.train_id) FROM (SELECT T1.train_id FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.position = 1 AND T2.direction = 'east' AND T1.shape = 'rectangle' GROUP BY T1.train_id)as T	trains
SELECT SUM(CASE WHEN T1.direction = 'west' THEN 1 ELSE 0 END)as count FROM trains AS T1 INNER JOIN ( SELECT train_id, COUNT(id) FROM cars WHERE roof = 'none' GROUP BY train_id HAVING COUNT(id) = 1 ) AS T2 ON T1.id = T2.train_id 	trains
SELECT T1.direction FROM trains AS T1 INNER JOIN ( SELECT train_id, COUNT(id) AS carsNum FROM cars GROUP BY train_id HAVING carsNum = 3 ) AS T2 ON T1.id = T2.train_id GROUP BY T1.direction	trains
SELECT COUNT(DISTINCT T1.train_id) FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.position = 1 AND T1.load_num = 3	trains
SELECT COUNT(T1.id) FROM trains AS T1 INNER JOIN cars AS T2 ON T1.id = T2.train_id INNER JOIN ( SELECT train_id, MAX(position) AS trailPosi FROM cars GROUP BY train_id ) AS T3 ON T1.id = T3.train_id WHERE T1.direction = 'east' AND T2.position = T3.trailPosi AND T2.sides = 'double'	trains
SELECT T2.direction FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.load_num = 0	trains
SELECT T2.direction FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.position = 2 AND T1.shape = 'diamond'	trains
SELECT SUM(CASE WHEN T2.direction = 'west' THEN 1 ELSE 0 END)as count FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.wheels = 3 AND T1.roof = 'jagged'	trains
SELECT T1.direction FROM trains AS T1 INNER JOIN ( SELECT train_id, MAX(position) AS trailPosi FROM cars GROUP BY train_id ) AS T2 ON T1.id = T2.train_id WHERE T2.trailPosi <= 2	trains
SELECT CAST(COUNT(CASE WHEN T2.trailPosi >= 4 THEN T1.id ELSE NULL END) AS REAL) * 100 / COUNT(T1.id) FROM trains AS T1 INNER JOIN ( SELECT train_id, MAX(position) AS trailPosi FROM cars GROUP BY train_id ) AS T2 ON T1.id = T2.train_id UNION ALL SELECT T1.direction FROM trains AS T1 INNER JOIN ( SELECT train_id, MAX(position) AS trailPosi FROM cars t GROUP BY train_id ) AS T2 ON T1.id = T2.train_id AND T2.trailPosi >= 4	trains
SELECT DISTINCT T3.load_shape FROM ( SELECT load_shape, train_id FROM cars WHERE position = 1 ORDER BY train_id DESC ) AS T3 UNION ALL SELECT T4.load_shape FROM ( SELECT load_shape, train_id FROM cars WHERE position = 1 ORDER BY train_id DESC LIMIT 1 ) AS T4 UNION ALL SELECT (CAST(COUNT(DISTINCT CASE WHEN T2.direction = 'east' THEN T2.id ELSE NULL END) AS REAL) * 100 / COUNT(DISTINCT T2.id)) FROM cars AS T1 INNER JOIN trains AS T2 ON T1.train_id = T2.id WHERE T1.position = 1 AND T1.load_shape = ( SELECT T4.load_shape FROM ( SELECT load_shape, train_id FROM cars AS T WHERE position = 1 ORDER BY train_id DESC LIMIT 1 ) AS T4 )	trains
SELECT T2.`Character Name` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T1.Title = 'Look Who''s Talking'	movie
SELECT T2.`Character Name` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T1.Title = 'Batman' ORDER BY T2.screentime DESC LIMIT 1	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Batman' AND T2.`Character Name` = 'Joker'	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Batman'	movie
SELECT T1.Title FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T2.`Character Name` = 'Dr. Archibald ''Moonlight'' Graham'	movie
SELECT T1.Title FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Tom Cruise'	movie
SELECT COUNT(*) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Morgan Freeman' AND T1.`MPAA Rating` = 'PG'	movie
SELECT T1.Title FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Tom Cruise' ORDER BY T1.Rating DESC LIMIT 1	movie
SELECT T2.`Character Name` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Tom Cruise' AND T1.Title = 'Born on the Fourth of July'	movie
SELECT T1.`Character Name` FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T2.Name = 'Tom Cruise'	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Batman' ORDER BY T3.`Height (Inches)` DESC LIMIT 1	movie
SELECT COUNT(*) FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T2.Gender = 'Male' AND T2.Ethnicity = 'African American'	movie
SELECT AVG(T1.Rating) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Tom Cruise'	movie
SELECT (MAX(CAST(SUBSTR(T2.screentime, 3, 2) AS REAL)) - MIN(CAST(SUBSTR(T2.screentime, 3, 2) AS REAL))) * 100 / MIN(CAST(SUBSTR(T2.screentime, 3, 2) AS REAL)) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T1.Title = 'Batman'	movie
SELECT Title FROM movie ORDER BY Budget DESC LIMIT 1	movie
SELECT T1.`MPAA Rating` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T2.`Character Name` = 'Peter Quill'	movie
SELECT T2.`Character Name` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T2.creditOrder = '1' AND T1.Genre = 'Thriller' ORDER BY T1.Rating DESC LIMIT 1	movie
SELECT T2.Name FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID INNER JOIN movie AS T3 ON T3.MovieID = T1.MovieID WHERE T3.Title = 'Batman' ORDER BY T1.screentime DESC LIMIT 1	movie
SELECT COUNT(*) FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE CAST(REPLACE(REPLACE(T2.NetWorth, ',', ''), '$', '') AS REAL) = ( SELECT MAX(CAST(REPLACE(REPLACE(NetWorth, ',', ''), '$', '') AS REAL)) FROM actor)	movie
SELECT T2.Name FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T1.`Character Name` = 'Chanice Kobolowski'	movie
SELECT T2.`Date of Birth` FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T1.`Character Name` = 'Sully'	movie
SELECT T2.`Birth City` FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T1.`Character Name` = 'Gabriel Martin'	movie
SELECT T2.Biography FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T1.`Character Name` = 'Michael Moscovitz'	movie
SELECT T2.`Height (Inches)` FROM characters AS T1 INNER JOIN actor AS T2 ON T1.ActorID = T2.ActorID WHERE T1.`Character Name` = 'Lurch'	movie
SELECT T2.`Character Name` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID WHERE T1.Title = 'G.I. Joe: The Rise of Cobra' AND T2.creditOrder = '3'	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'American Hustle' AND T2.creditOrder = '2'	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.`Release Date` = '2015-10-26' AND T2.creditOrder = '1'	movie
SELECT CAST(SUM(CASE WHEN T3.`Birth Country` = 'USA' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.`Birth Country`) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Mrs. Doubtfire'	movie
SELECT CAST(SUM(CASE WHEN T3.`Date of Birth` > '1970-01-01' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.`Date of Birth`) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Dawn of the Planet of the Apes'	movie
SELECT MovieID FROM movie WHERE Rating BETWEEN 7 AND 8 AND Budget = 15000000	movie
SELECT COUNT(*) FROM movie WHERE `MPAA Rating` = 'PG' AND `Release Date` LIKE '1990-06%'	movie
SELECT Name FROM actor WHERE ActorID = 439 AND Gender = 'Male' AND Ethnicity = 'White'	movie
SELECT T1.Genre FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.`Birth City` = 'New York City' AND T1.Rating > 5	movie
SELECT COUNT(*) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Genre = 'Romance' AND T3.Name = 'John Travolta'	movie
SELECT T3.`Height (Inches)`, T3.NetWorth FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Three Men and a Little Lady'	movie
SELECT T1.Genre FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.`MPAA Rating` = 'PG' ORDER BY CAST(REPLACE(REPLACE(T3.NetWorth, ',', ''), '$', '') AS REAL) DESC LIMIT 1	movie
SELECT T3.NetWorth FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Misery' AND T3.`Height (Inches)` BETWEEN 60 AND 70 AND T3.Gender = 'Male'	movie
SELECT COUNT(*) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Ghost' AND T3.Gender = 'Male' AND T3.`Birth Country` = 'USA'	movie
SELECT T1.`MPAA Rating`, T1.Title FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Leonardo DiCaprio' ORDER BY T1.Budget DESC LIMIT 1	movie
SELECT T3.NetWorth, T3.`Date of Birth` FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Title = 'Die Hard 2' AND T3.`Height (Inches)` BETWEEN 60 AND 65	movie
SELECT T1.Runtime FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Ethnicity = 'African American' AND T3.`Date of Birth` = '1954-12-28'	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Gross = 136766062 AND T2.`Character Name` = 'Don Altobello' AND T1.Genre = 'Drama'	movie
SELECT SUM(T1.Gross) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE CAST(REPLACE(REPLACE(T3.NetWorth, ',', ''), '$', '') AS REAL) > 375000000 AND T1.Rating < 7 AND T1.Genre = 'Comedy'	movie
SELECT T1.Runtime FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Name = 'Jackie Chan' AND T1.Rating > 7	movie
SELECT SUM(CASE WHEN CAST(REPLACE(REPLACE(T3.NetWorth, ',', ''), '$', '') AS REAL) > 400000000 THEN 1 ELSE 0 END) - SUM(CASE WHEN CAST(REPLACE(REPLACE(T3.NetWorth, ',', ''), '$', '') AS REAL) < 400000000 THEN 1 ELSE 0 END) FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T1.Genre = 'Drama'	movie
SELECT T3.Name FROM movie AS T1 INNER JOIN characters AS T2 ON T1.MovieID = T2.MovieID INNER JOIN actor AS T3 ON T3.ActorID = T2.ActorID WHERE T3.Gender = 'Female' AND T1.Title = 'Godzilla' AND T3.`Birth City` = 'Sherman Oaks' AND T3.`Height (Inches)` * 100 > ( SELECT AVG(`Height (Inches)`) FROM actor ) * 50	movie
SELECT COUNT(TweetID) AS tweet_number FROM twitter WHERE Lang = 'en'	social_media
SELECT text FROM twitter WHERE IsReshare = 'TRUE'	social_media
SELECT COUNT(TweetID) AS tweet_number FROM twitter WHERE Reach > 1000	social_media
SELECT COUNT(TweetID) AS tweet_number FROM twitter WHERE Sentiment > 0 AND Weekday = 'Thursday'	social_media
SELECT text FROM twitter WHERE Likes = ( SELECT MAX( Likes) FROM twitter )	social_media
SELECT City FROM location WHERE City IS NOT NULL AND Country = 'Argentina'	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.Country = 'Argentina' LIMIT 1	social_media
SELECT T2.City FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.Country = 'Argentina' GROUP BY T2.City ORDER BY COUNT(T1.TweetID) DESC LIMIT 1	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.City = 'Buenos Aires' AND T1.IsReshare = 'TRUE'	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T1.Sentiment > 0 AND T2.City = 'Buenos Aires'	social_media
SELECT T2.Country FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID ORDER BY T1.Likes DESC LIMIT 1	social_media
SELECT T2.Country FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.Country IN ('Argentina', 'Australia') AND T1.Sentiment > 0 GROUP BY T2.Country ORDER BY COUNT(T1.TweetID) DESC LIMIT 1	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.City = 'Buenos Aires' AND T1.Weekday = 'Thursday'	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.Likes > 10 AND T2.Gender = 'Male'	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male'	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID ORDER BY T1.Reach DESC LIMIT 1	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID INNER JOIN user AS T3 ON T1.UserID = T3.UserID WHERE T3.Gender = 'Male' AND T2.Country = 'Argentina'	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID INNER JOIN user AS T2 ON T2.UserID = T1.UserID INNER JOIN user AS T3 ON T1.UserID = T3.UserID WHERE T2.City = 'Buenos Aires' AND T3.Gender = 'Male'	social_media
SELECT SUM(CASE WHEN T2.City = 'Buenos Aires' THEN 1.0 ELSE 0 END) / COUNT(T1.TweetID) AS avg FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.Country = 'Argentina'	social_media
SELECT SUM(CASE WHEN T2.Gender = 'Male' THEN 1.0 ELSE 0 END) / COUNT(T1.TweetID) AS per FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.Sentiment > 0	social_media
SELECT COUNT(UserID) AS user_number FROM user WHERE Gender = 'Unknown'	social_media
SELECT COUNT(State) AS State_number FROM location WHERE Country = 'United Kingdom'	social_media
SELECT DISTINCT StateCode FROM location WHERE State = 'Gwynedd'	social_media
SELECT DISTINCT LocationID FROM location WHERE State = 'West Sussex'	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.State = 'Texas' AND T1.IsReshare = 'TRUE'	social_media
SELECT T2.Country FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T1.Reach = 547851	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T1.Sentiment > 0 AND T2.State = 'Ha Noi'	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T2.State = 'Connecticut' ORDER BY T1.Klout DESC LIMIT 1	social_media
SELECT COUNT(T1.Likes) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID INNER JOIN user AS T3 ON T3.UserID = T1.UserID WHERE T2.State = 'Wisconsin' AND T3.Gender = 'Female'	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.TweetID = 'tw-715909161071091712'	social_media
SELECT T2.City FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T1.text = 'One of our favorite stories is @FINRA_News''s move to the cloud with AWS Enterprise Support! https://amp.twimg.com/v/991837f1-4815-4edc-a88f-e68ded09a02a'	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.RetweetCount = 535	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.Weekday = 'Wednesday' ORDER BY T1.Klout DESC LIMIT 1	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID ORDER BY T1.Likes DESC LIMIT 1	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T1.Weekday = 'Thursday' AND T2.State = 'Michigan'	social_media
SELECT T2.StateCode FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE T1.TweetID = 'tw-685681052912873473'	social_media
SELECT SUM(CASE WHEN T3.Gender = 'Male' THEN 1.0 ELSE 0 END) / COUNT(T1.TweetID) AS percentage FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID INNER JOIN user AS T3 ON T3.UserID = T1.UserID WHERE T2.State = 'Florida'	social_media
SELECT SUM(CASE WHEN T1.Sentiment > 0 THEN 1.0 ELSE 0 END) / COUNT(T1.TweetID) AS percentage FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID WHERE State = 'California'	social_media
SELECT Weekday FROM twitter WHERE TweetID = 'tw-682712873332805633'	social_media
SELECT Reach FROM twitter WHERE text = 'Happy New Year to all those AWS instances of ours!'	social_media
SELECT COUNT(DISTINCT TweetID) FROM twitter WHERE Lang = 'en'	social_media
SELECT LocationID FROM twitter WHERE TweetID = 'tw-682714048199311366'	social_media
SELECT COUNT(TweetID) FROM twitter WHERE Weekday = 'Wednesday'	social_media
SELECT text FROM twitter WHERE Weekday = 'Thursday'	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.TweetID = 'tw-682714583044243456'	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Unknown'	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male'	social_media
SELECT T.Gender FROM ( SELECT T2.Gender, COUNT( text) AS num FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.Lang = 'en' GROUP BY T2.Gender ) T ORDER BY T.num DESC LIMIT 1	social_media
SELECT DISTINCT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.RetweetCount > 30	social_media
SELECT COUNT(T1.UserID) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Female' AND T1.IsReshare = 'TRUE'	social_media
SELECT T.Country FROM ( SELECT T2.Country, SUM(T1.Likes) AS num FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID GROUP BY T2.Country ) T ORDER BY T.num DESC LIMIT 1	social_media
SELECT T2.Country FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T1.TweetID = 'tw-682723090279841798'	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T2.Country = 'Australia'	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T2.City = 'Rawang' AND T2.State = 'Selangor' AND T2.Country = 'Malaysia'	social_media
SELECT DISTINCT T1.Lang FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T2.Country = 'Brazil'	social_media
SELECT T.Country FROM ( SELECT T2.Country, SUM(T1.Sentiment) AS num FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T1.Sentiment > 0 GROUP BY T2.Country ) T ORDER BY T.num DESC LIMIT 1	social_media
SELECT SUM(T1.Likes) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T1.Lang = 'ru' AND T2.Gender = 'Male'	social_media
SELECT COUNT(DISTINCT T1.TweetID) / COUNT(DISTINCT T1.UserID) / 7 AS avg FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male' AND T1.Day BETWEEN 1 AND 31	social_media
SELECT COUNT(DISTINCT TweetID) FROM twitter WHERE Klout > 50	social_media
SELECT text FROM twitter WHERE Lang != 'en'	social_media
SELECT UserID FROM twitter GROUP BY UserID ORDER BY COUNT(DISTINCT TweetID) DESC LIMIT 1	social_media
SELECT COUNT(DISTINCT TweetID) FROM twitter WHERE Weekday = 'Monday' AND IsReshare = 'TRUE'	social_media
SELECT text FROM twitter ORDER BY Reach DESC LIMIT 3	social_media
SELECT COUNT(DISTINCT TweetID) FROM twitter WHERE IsReshare = 'TRUE' AND Likes > 100	social_media
SELECT COUNT(DISTINCT T1.TweetID) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male' AND T1.Weekday = 'Monday'	social_media
SELECT T2.Gender FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID ORDER BY T1.Likes DESC LIMIT 1	social_media
SELECT T1.text FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male' AND T1.Lang = 'fr'	social_media
SELECT COUNT(DISTINCT T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T1.Lang = 'fr' AND T2.Country = 'Australia'	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T2.LocationID = T1.LocationID INNER JOIN user AS T3 ON T3.UserID = T1.UserID WHERE T2.Country = 'Australia' AND T3.Gender = 'Male' AND T1.Sentiment > 0	social_media
SELECT SUM(CASE WHEN T1.Sentiment > 0 THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.Sentiment = 0 THEN 1 ELSE 0 END) AS diff FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male'	social_media
SELECT T2.City FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID ORDER BY T1.RetweetCount DESC LIMIT 1	social_media
SELECT SUM(CASE WHEN T2.City = 'Bangkok' THEN 1 ELSE 0 END) AS bNum , SUM(CASE WHEN T2.City = 'Chiang Mai' THEN 1 ELSE 0 END) AS cNum FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T2.City IN ('Bangkok', 'Chiang Mai')	social_media
SELECT COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T1.Day = 31 AND T2.State = 'Santa' AND T2.Country = 'Argentina'	social_media
SELECT T.City FROM ( SELECT T2.City, COUNT(T1.TweetID) AS num FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T2.Country = 'Canada' GROUP BY T2.City ) T ORDER BY T.num DESC LIMIT 3	social_media
SELECT DISTINCT T2.City FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE Sentiment = 0	social_media
SELECT T2.text FROM user AS T1 INNER JOIN twitter AS T2 ON T1.UserID = T2.UserID INNER JOIN location AS T3 ON T2.LocationID = T3.LocationID WHERE T3.Country = 'Argentina' AND T1.Gender = 'Male' ORDER BY T2.Likes DESC LIMIT 1	social_media
SELECT SUM(T1.Likes) / COUNT(T1.TweetID) FROM twitter AS T1 INNER JOIN user AS T2 ON T1.UserID = T2.UserID WHERE T2.Gender = 'Male' AND T1.Weekday = 'Monday'	social_media
SELECT SUM(CASE WHEN T2.City = 'Bangkok' THEN Likes ELSE NULL END) / COUNT(CASE WHEN T2.City = 'Bangkok' THEN 1 ELSE 0 END) AS bNum , SUM(CASE WHEN City = 'Chiang Mai' THEN Likes ELSE NULL END) / COUNT(CASE WHEN City = 'Chiang Mai' THEN TweetID ELSE NULL END) AS cNum FROM twitter AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T2.City IN ('Bangkok', 'Chiang Mai')	social_media
SELECT name FROM course WHERE name = 'Intro to BlockChain' OR name = 'Computer Network' ORDER BY diff DESC LIMIT 1	cs_semester
SELECT name FROM course WHERE credit < ( SELECT credit FROM course WHERE name = 'Machine Learning Theory' )	cs_semester
SELECT COUNT(prof_id) FROM prof WHERE popularity > ( SELECT popularity FROM prof WHERE first_name = 'Zhihua' AND last_name = 'Zhou' )	cs_semester
SELECT phone_number FROM student WHERE l_name = 'Pryor' AND f_name = 'Kerry'	cs_semester
SELECT T1.first_name, T1.last_name FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.f_name = 'Faina' AND T3.l_name = 'Mallinar'	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.first_name = 'Sauveur' AND T2.last_name = 'Skyme'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN RA AS T2 ON T1.student_id = T2.student_id WHERE T2.capability = 5	cs_semester
SELECT COUNT(T1.prof_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.first_name = 'Ogdon' AND T1.salary = 'med' AND T2.last_name = 'Zywicki'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Machine Learning Theory'	cs_semester
SELECT COUNT(student_id) FROM registration WHERE grade = 'B' AND student_id IN ( SELECT student_id FROM student WHERE gpa > 3 AND course_id IN ( SELECT course_id FROM course WHERE name = 'Machine Learning Theory' ) )	cs_semester
SELECT T3.name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T1.f_name = 'Laughton' AND T1.l_name = 'Antonio'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T2.grade IS NULL AND T3.name = 'Intro to Database 2'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE (T1.f_name = 'Laughton' OR T1.f_name = 'Willie') AND (T1.l_name = 'Antonio' OR T1.l_name = 'Rechert') AND T3.name = 'Machine Learning Theory' ORDER BY T2.sat DESC LIMIT 1	cs_semester
SELECT COUNT(*) FROM ( SELECT T2.prof_id FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.gender = 'Male' GROUP BY T1.prof_id HAVING COUNT(T1.student_id) > 3 )	cs_semester
SELECT COUNT(T1.student_id) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Machine Learning Theory' AND T1.type = 'UG'	cs_semester
SELECT T1.first_name, T1.last_name FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.f_name = 'Willie' AND T3.l_name = 'Rechert'	cs_semester
SELECT SUM(T3.gpa) / COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T1.student_id = T3.student_id WHERE T2.first_name = 'Ogdon' AND T2.last_name = 'Zywicki'	cs_semester
SELECT CAST(SUM(T1.sat) AS REAL) / COUNT(T1.student_id) FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T2.name = 'Machine Learning Theory'	cs_semester
SELECT COUNT(student_id) FROM student WHERE type = 'RPG'	cs_semester
SELECT f_name, l_name FROM student WHERE gpa = ( SELECT MAX(gpa) FROM student )	cs_semester
SELECT COUNT(T1.student_id) FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T1.grade = 'A' AND T2.credit = '3' AND T2.diff = 1	cs_semester
SELECT COUNT(T1.student_id) FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T2.diff = 5	cs_semester
SELECT T1.first_name, T1.last_name FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.f_name = 'Oliy' AND T3.l_name = 'Spratling'	cs_semester
SELECT T1.popularity FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.f_name = 'Harrietta' AND T3.l_name = 'Lydford'	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.teachingability = '1' AND T2.gender = 'Female'	cs_semester
SELECT T.first_name, T.last_name FROM ( SELECT T2.first_name, T2.last_name, T2.teachingability FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id GROUP BY T1.prof_id HAVING COUNT(student_id) > 2 ) T ORDER BY T.teachingability DESC LIMIT 1	cs_semester
SELECT CASE grade WHEN 'A' THEN 4 WHEN 'B' THEN 3 WHEN 'C' THEN 2 ELSE 1 END AS result FROM registration WHERE student_id IN ( SELECT student_id FROM student WHERE f_name = 'Rik' AND l_name = 'Unsworth' AND course_id IN ( SELECT course_id FROM course WHERE name = 'Computer Network' ) )	cs_semester
SELECT COUNT(T1.course_id) FROM registration AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T2.f_name = 'Alvera' AND T2.l_name = 'McQuillin'	cs_semester
SELECT T3.f_name, T3.l_name FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T1.first_name = 'Zhihua' AND T3.type = 'RPG' AND T1.last_name = 'Zhou'	cs_semester
SELECT COUNT(T2.student_id) FROM course AS T1 INNER JOIN registration AS T2 ON T1.course_id = T2.course_id WHERE T1.name = 'Statistical learning'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Applied Deep Learning ' AND T2.grade IS NULL	cs_semester
SELECT T1.phone_number FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Intro to BlockChain' AND T2.grade = 'A'	cs_semester
SELECT CAST(SUM(CASE WHEN T3.type = 'TPG' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T1.student_id = T3.student_id WHERE T2.first_name = 'Ogdon' AND T2.last_name = 'Zywicki'	cs_semester
SELECT CAST(SUM(CASE WHEN T1.grade = 'B' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.student_id) FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T2.name = 'Computer Network'	cs_semester
SELECT COUNT(course_id) FROM course WHERE diff = 5	cs_semester
SELECT first_name, last_name FROM prof WHERE graduate_from IN ( 'Brown University',  'Columbia University',  'Cornell University',  'Dartmouth College',  'Harvard University',  'Princeton University',  'University of Pennsylvania',  'Yale University' )	cs_semester
SELECT name FROM course WHERE credit = ( SELECT MAX(credit) FROM course ) AND diff = ( SELECT MAX(diff) FROM course )	cs_semester
SELECT COUNT(student_id) FROM student WHERE type = 'UG' AND intelligence = ( SELECT MAX(intelligence) FROM student )	cs_semester
SELECT COUNT(prof_id) FROM prof WHERE gender = 'Female' AND popularity = ( SELECT MAX(popularity) FROM prof )	cs_semester
SELECT COUNT(student_id) FROM student WHERE type = 'RPG'	cs_semester
SELECT COUNT(T2.student_id) FROM course AS T1 INNER JOIN registration AS T2 ON T1.course_id = T2.course_id WHERE T2.grade = 'A' AND T1.name = 'Applied Deep Learning '	cs_semester
SELECT T2.gpa FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T1.salary = 'free'	cs_semester
SELECT T2.name FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T1.grade = 'A' AND T2.diff = 1 GROUP BY T2.name ORDER BY COUNT(T1.student_id) DESC LIMIT 1	cs_semester
SELECT COUNT(course_id) FROM registration WHERE student_id IN ( SELECT student_id FROM student WHERE gpa = ( SELECT MAX(gpa) FROM student ) )	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.first_name = 'Ogdon' AND T2.last_name = 'Zywicki'	cs_semester
SELECT DISTINCT T2.name FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T1.sat = 5	cs_semester
SELECT T3.name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T2.sat = 1 AND T1.intelligence = 1	cs_semester
SELECT T2.name FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T1.grade = 'A' AND T2.name IN ('Advanced Operating System', 'Intro to BlockChain') GROUP BY T2.name ORDER BY COUNT(T1.student_id) DESC LIMIT 1	cs_semester
SELECT T2.popularity FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id GROUP BY T1.prof_id, T1.capability ORDER BY COUNT(T1.student_id) DESC, T1.capability DESC LIMIT 1	cs_semester
SELECT CAST(COUNT(T1.student_id) AS REAL) / COUNT(DISTINCT T2.course_id) FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T2.diff = 4	cs_semester
SELECT COUNT(T2.student_id) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id WHERE T2.grade IS NULL AND T1.gpa BETWEEN 3 AND 4	cs_semester
SELECT COUNT(T2.student_id) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id WHERE T2.grade = 'A' AND T1.type = 'UG'	cs_semester
SELECT AVG(T2.gpa), T2.f_name, T2.l_name FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T1.salary = 'high' AND T1.capability = 5 GROUP BY T2.student_id	cs_semester
SELECT prof_id, student_id FROM RA WHERE capability = ( SELECT MIN(capability) FROM RA )	cs_semester
SELECT first_name, last_name FROM prof WHERE graduate_from = 'University of Boston'	cs_semester
SELECT course_id, student_id FROM registration WHERE grade IS NULL OR grade = ''	cs_semester
SELECT CAST(SUM(CASE WHEN gender = 'Male' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN gender = 'Female' THEN 1 ELSE 0 END) FROM prof	cs_semester
SELECT name, credit FROM course WHERE diff = ( SELECT MIN(diff) FROM course )	cs_semester
SELECT T3.f_name, T3.l_name, T3.gpa FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id ORDER BY T1.popularity DESC LIMIT 1	cs_semester
SELECT T2.f_name, T2.l_name, T2.email FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T1.salary = 'free'	cs_semester
SELECT T3.f_name, T3.l_name, T2.capability, T3.gpa FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T1.first_name = 'Merwyn' AND T1.last_name = 'Conkay'	cs_semester
SELECT T1.f_name, T1.l_name, T2.grade FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Intro to BlockChain'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T2.grade = 'A' ORDER BY T3.diff DESC LIMIT 1	cs_semester
SELECT T1.first_name, T1.last_name, T1.graduate_from FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.f_name = 'Olia' AND T3.l_name = 'Rabier'	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Advanced Database Systems' ORDER BY T2.sat DESC LIMIT 1	cs_semester
SELECT CAST(SUM(T3.credit * CASE T1.grade WHEN 'A' THEN 4 WHEN 'B' THEN 3 WHEN 'C' THEN 2 WHEN 'D' THEN 1 ELSE 1 END) AS REAL) / COUNT(T3.credit) FROM registration AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T1.course_id = T3.course_id WHERE T2.f_name = 'Laughton' AND T2.l_name = 'Antonio'	cs_semester
SELECT DISTINCT T1.f_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T1.type = 'UG' AND T1.gpa > 3.7	cs_semester
SELECT T3.f_name, T3.l_name, T2.capability FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T1.graduate_from = 'University of Washington'	cs_semester
SELECT f_name, l_name, email, intelligence FROM student WHERE student_id IN ( SELECT student_id FROM RA WHERE salary = 'high' AND capability = ( SELECT MAX(capability) FROM RA ) )	cs_semester
SELECT T5.name, T5.credit FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T1.student_id = T3.student_id INNER JOIN registration AS T4 ON T3.student_id = T4.student_id INNER JOIN course AS T5 ON T4.course_id = T5.course_id WHERE T2.gender = 'Female' ORDER BY T2.teachingability DESC LIMIT 1	cs_semester
SELECT COUNT(prof_id) FROM prof WHERE gender = 'Female'	cs_semester
SELECT name FROM course WHERE diff = ( SELECT MAX(diff) FROM course )	cs_semester
SELECT COUNT(student_id) FROM student WHERE gpa BETWEEN 3.1 AND 3.7 AND type = 'UG'	cs_semester
SELECT credit FROM course WHERE name = 'Computer Vision'	cs_semester
SELECT T2.student_id FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'C for Programmers' AND T1.gpa = 2.5	cs_semester
SELECT T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Intro to Database 2' ORDER BY T2.sat DESC LIMIT 1	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T1.salary = 'high' AND T2.gpa > 3	cs_semester
SELECT T3.name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T1.type = 'UG' ORDER BY T2.sat DESC LIMIT 1	cs_semester
SELECT T1.capability FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T2.type = 'RPG' AND T2.intelligence >= 4	cs_semester
SELECT COUNT(T1.student_id) FROM registration AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T1.grade = 'B' AND T2.intelligence = 3	cs_semester
SELECT T3.diff FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T2.grade = 'A' AND T1.intelligence = 5	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T1.capability = 5 ORDER BY T2.popularity DESC LIMIT 1	cs_semester
SELECT T1.name FROM course AS T1 INNER JOIN registration AS T2 ON T1.course_id = T2.course_id WHERE T2.grade = 'D'	cs_semester
SELECT T2.capability FROM student AS T1 INNER JOIN RA AS T2 ON T1.student_id = T2.student_id WHERE T1.f_name = 'Alvera' AND T1.l_name = 'McQuillin'	cs_semester
SELECT COUNT(T1.student_id) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.credit = 3 AND T1.gpa = 3.2	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T2.gpa = 3.5 AND T1.salary = 'low'	cs_semester
SELECT T2.email FROM registration AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T1.course_id = T3.course_id WHERE T1.grade = 'B' GROUP BY T3.diff HAVING T3.diff > AVG(T3.diff) * 0.8	cs_semester
SELECT CAST(SUM(CASE WHEN T1.salary = 'low' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.salary) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.teachingability < 3	cs_semester
SELECT name FROM course WHERE credit = ( SELECT MAX(credit) FROM course ) AND diff = ( SELECT MAX(diff) FROM course )	cs_semester
SELECT CAST(SUM(teachingability) AS REAL) / COUNT(prof_id) FROM prof WHERE popularity = ( SELECT MAX(popularity) FROM prof )	cs_semester
SELECT CAST(SUM(sat) AS REAL) / COUNT(course_id) FROM registration WHERE grade = 'B'	cs_semester
SELECT f_name, l_name, phone_number FROM student WHERE gpa > 3 AND intelligence < 4	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN RA AS T2 ON T1.student_id = T2.student_id WHERE T2.capability > ( SELECT AVG(capability) FROM RA )	cs_semester
SELECT T1.f_name, T1.l_name, T3.name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T1.intelligence = 5 AND T1.gpa < 3	cs_semester
SELECT CAST(SUM(T1.capability) AS REAL) / COUNT(T1.student_id) FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T2.gpa < 2.5	cs_semester
SELECT T1.first_name, T1.last_name FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.intelligence = 1	cs_semester
SELECT AVG(T1.gpa) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.diff IN (2, 1) GROUP BY T3.diff	cs_semester
SELECT T2.f_name, T2.l_name, T1.capability FROM RA AS T1 INNER JOIN student AS T2 ON T2.student_id = T1.student_id INNER JOIN registration AS T3 ON T2.student_id = T3.student_id WHERE T3.grade IS NULL OR T3.grade = ''	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN registration AS T2 ON T2.student_id = T1.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T1.salary = 'high' AND T3.name = 'Computer Vision'	cs_semester
SELECT T1.first_name, T1.last_name, T1.popularity FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id GROUP BY T1.prof_id ORDER BY COUNT(T2.student_id) DESC LIMIT 1	cs_semester
SELECT T3.name, T2.f_name, T2.l_name FROM registration AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T1.course_id = T3.course_id WHERE T1.grade = 'A' GROUP BY T3.name ORDER BY COUNT(T1.student_id) DESC LIMIT 1	cs_semester
SELECT AVG(T2.sat) - ( SELECT AVG(T2.sat) FROM RA AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id WHERE T1.salary = 'free' ) AS diff FROM RA AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id WHERE T1.salary = 'high'	cs_semester
SELECT T1.graduate_from FROM prof AS T1 INNER JOIN RA AS T2 ON T1.prof_id = T2.prof_id INNER JOIN student AS T3 ON T2.student_id = T3.student_id WHERE T3.type = 'UG' GROUP BY T1.prof_id ORDER BY COUNT(T2.student_id) DESC LIMIT 1	cs_semester
SELECT T2.first_name, T2.last_name, T2.email FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T2.teachingability > ( SELECT AVG(teachingability) FROM prof ) GROUP BY T2.prof_id HAVING COUNT(T1.student_id) >= 2	cs_semester
SELECT CAST(( SELECT COUNT(*) FROM course WHERE name = 'Intro to Database 2' AND course_id IN ( SELECT course_id FROM registration WHERE sat = ( SELECT MAX(sat) FROM registration ) ) ) AS REAL) * 100  / COUNT(T1.student_id) FROM registration AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id WHERE T2.name = 'Intro to Database 2'	cs_semester
SELECT f_name, l_name FROM student WHERE gpa = ( SELECT MAX(gpa) FROM student )	cs_semester
SELECT COUNT(T1.student_id) FROM RA AS T1 INNER JOIN prof AS T2 ON T1.prof_id = T2.prof_id WHERE T1.salary = 'high' ORDER BY T2.teachingability DESC LIMIT 1	cs_semester
SELECT T1.salary FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T2.email = 'grosellg@hku.hk'	cs_semester
SELECT COUNT(T1.student_id) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Statistical learning' AND T2.sat = 4 AND T1.gpa = 3.8	cs_semester
SELECT COUNT(T1.student_id) FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.diff = 3 AND T1.intelligence = 2	cs_semester
SELECT T1.f_name, T1.l_name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T3.name = 'Applied Deep Learning ' AND T2.grade = 'C'	cs_semester
SELECT T3.name FROM student AS T1 INNER JOIN registration AS T2 ON T1.student_id = T2.student_id INNER JOIN course AS T3 ON T2.course_id = T3.course_id WHERE T2.sat = 1 AND T1.type = 'RPG'	cs_semester
SELECT SUM(CASE WHEN T2.type = 'UG' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.type = 'RPG' THEN 1 ELSE 0 END) FROM RA AS T1 INNER JOIN student AS T2 ON T1.student_id = T2.student_id WHERE T1.capability < 3	cs_semester
SELECT CAST(COUNT(p_id) AS REAL) / COUNT(DISTINCT p_id_dummy) AS avgnum FROM advisedBy GROUP BY p_id_dummy	computer_student
SELECT COUNT(DISTINCT p_id) FROM taughtBy WHERE course_id = 18	computer_student
SELECT course_id FROM course WHERE courseLevel = 'Level_500'	computer_student
SELECT COUNT(course_id) FROM course WHERE courseLevel = 'Level_300'	computer_student
SELECT T2.p_id, T2.course_id FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id WHERE T1.professor = 1 AND T1.hasPosition <> 0	computer_student
SELECT T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_400'	computer_student
SELECT T3.course_id FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id INNER JOIN taughtBy AS T3 ON T2.p_id = T3.p_id WHERE T1.p_id = 141	computer_student
SELECT T1.p_id FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.yearsInProgram = 'Year_3'	computer_student
SELECT T1.courseLevel FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T2.p_id = 297	computer_student
SELECT T1.courseLevel, T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T2.course_id = 165	computer_student
SELECT T1.p_id, T2.yearsInProgram FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T1.p_id_dummy = 5	computer_student
SELECT T3.course_id, T3.courseLevel FROM taughtBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T1.course_id WHERE T2.hasPosition = 'Faculty_eme'	computer_student
SELECT T1.p_id_dummy, T2.courseLevel FROM advisedBy AS T1 INNER JOIN course AS T2 ON T1.p_id = T2.course_id INNER JOIN taughtBy AS T3 ON T2.course_id = T3.course_id WHERE T1.p_id = 80	computer_student
SELECT DISTINCT T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_400' OR T1.courseLevel = 'Level_500'	computer_student
SELECT T1.p_id_dummy FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.yearsInProgram = 'Year_12'	computer_student
SELECT T1.course_id, T1.courseLevel FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id GROUP BY T1.course_id, T1.courseLevel ORDER BY COUNT(T1.course_id) DESC LIMIT 1	computer_student
SELECT COUNT(*) FROM course WHERE courseLevel = 'Level_300'	computer_student
SELECT COUNT(*) FROM taughtBy WHERE course_id = 11	computer_student
SELECT course_id FROM taughtBy WHERE course_id = 11 OR course_id = 18 GROUP BY course_id ORDER BY COUNT(course_id) DESC LIMIT 1	computer_student
SELECT COUNT(*) FROM person WHERE hasPosition = 'Faculty_eme'	computer_student
SELECT p_id_dummy FROM advisedBy GROUP BY p_id_dummy HAVING COUNT(p_id_dummy) > 4	computer_student
SELECT COUNT(*) FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id INNER JOIN person AS T3 ON T3.p_id = T2.p_id WHERE T1.courseLevel = 'Level_300' AND T3.professor = 1	computer_student
SELECT T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id INNER JOIN person AS T3 ON T3.p_id = T2.p_id WHERE T1.courseLevel = 'Level_300' AND T3.hasPosition = 'Faculty_eme'	computer_student
SELECT T2.hasPosition FROM taughtBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T1.course_id = 9	computer_student
SELECT T1.courseLevel FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T2.p_id = 79	computer_student
SELECT T1.p_id_dummy FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.yearsInProgram = 'Year_5'	computer_student
SELECT COUNT(DISTINCT T4.p_id) FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id INNER JOIN advisedBy AS T4 ON T4.p_id = T1.p_id WHERE T1.professor = 1 AND T3.courseLevel = 'Level_300'	computer_student
SELECT COUNT(*) FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id INNER JOIN person AS T3 ON T2.p_id = T3.p_id WHERE T3.professor = 1 AND T1.courseLevel = 'Level_300'	computer_student
SELECT T2.course_id FROM taughtBy AS T1 INNER JOIN course AS T2 ON T1.course_id = T2.course_id INNER JOIN advisedBy AS T3 ON T3.p_id = T1.p_id WHERE T1.p_id = 9	computer_student
SELECT T1.courseLevel FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id GROUP BY T2.course_id ORDER BY COUNT(T2.p_id) DESC LIMIT 1	computer_student
SELECT T1.p_id FROM taughtBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.professor = 1 GROUP BY T1.p_id HAVING COUNT(DISTINCT T1.course_id) > 3	computer_student
SELECT T1.p_id FROM taughtBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.professor = 1 GROUP BY T1.p_id ORDER BY COUNT(*) DESC LIMIT 3	computer_student
SELECT COUNT(DISTINCT T1.p_id_dummy) FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.yearsInProgram = 'Year_3'	computer_student
SELECT CAST(COUNT(T1.course_id) AS REAL) / COUNT(DISTINCT T2.p_id) AS num FROM taughtBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.professor = 1	computer_student
SELECT CAST(SUM(CASE  WHEN professor = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE  WHEN student = 1 THEN 1 ELSE 0 END) AS per FROM person	computer_student
SELECT CAST(SUM(CASE  WHEN courseLevel = 'Level_400' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) AS per FROM course	computer_student
SELECT p_id FROM taughtBy WHERE course_id = 18	computer_student
SELECT T2.hasPosition, T1.p_id_dummy FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id_dummy = T2.p_id WHERE T1.p_id = 303	computer_student
SELECT T1.p_id, T3.courseLevel FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id WHERE T1.hasPosition = 'Faculty_aff'	computer_student
SELECT T2.yearsInProgram, T2.inPhase FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id GROUP BY T1.p_id ORDER BY COUNT(*) DESC LIMIT 1	computer_student
SELECT T1.p_id, T2.p_id FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id_dummy = T2.p_id WHERE hasPosition = 'Faculty_eme'	computer_student
SELECT T1.course_id, T1.courseLevel FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T2.p_id BETWEEN 40 AND 50	computer_student
SELECT T1.courseLevel, T1.course_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T2.p_id = 141	computer_student
SELECT T1.p_id, T3.courseLevel FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id WHERE T3.course_id = 104 AND T1.hasPosition <> 0	computer_student
SELECT T1.p_id, T1.hasPosition FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id WHERE T3.courseLevel = 'Level_400' AND T2.course_id < 10	computer_student
SELECT T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_300' AND T1.course_id > 121 AND T1.course_id < 130	computer_student
SELECT T1.p_id_dummy, T2.hasPosition FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.yearsInProgram = 'Year_8'	computer_student
SELECT T1.course_id, T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_500' LIMIT 5	computer_student
SELECT COUNT(*) FROM advisedBy WHERE p_id_dummy = 415	computer_student
SELECT COUNT(*) FROM course WHERE courseLevel = 'Level_500'	computer_student
SELECT COUNT(*) FROM person WHERE hasPosition = 0 AND inPhase = 0	computer_student
SELECT p_id FROM taughtBy GROUP BY p_id ORDER BY COUNT(course_id) ASC LIMIT 1	computer_student
SELECT COUNT(*) FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T1.p_id_dummy = 5 AND T2.student = 1 AND T2.yearsInProgram = 'Year_5'	computer_student
SELECT T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_500' GROUP BY T2.p_id ORDER BY COUNT(T2.course_id) DESC LIMIT 1	computer_student
SELECT COUNT(*) FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id WHERE T1.hasPosition = 'Faculty_aff' AND T1.professor = 1 AND T3.courseLevel = 'Level_500'	computer_student
SELECT T2.p_id FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_500' GROUP BY T2.p_id ORDER BY COUNT(T2.p_id) DESC LIMIT 5	computer_student
SELECT COUNT(T1.p_id_dummy) FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.yearsInProgram = 'Year_1' AND T2.student = 1	computer_student
SELECT COUNT(*) FROM ( SELECT COUNT(T2.p_id) FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_400' GROUP BY T2.p_id HAVING COUNT(DISTINCT T1.course_id) <= 2 )	computer_student
SELECT COUNT(*) FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id WHERE T1.hasPosition = 'Faculty_eme' AND T1.professor = 1 AND T3.courseLevel = 'Level_400'	computer_student
SELECT T1.hasPosition FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id WHERE T1.professor = 1 GROUP BY T1.p_id ORDER BY COUNT(T2.course_id) DESC LIMIT 1	computer_student
SELECT T2.yearsInProgram FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.student = 1 GROUP BY T2.p_id HAVING COUNT(T2.p_id) > 2	computer_student
SELECT COUNT(*) FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_300'	computer_student
SELECT T2.yearsInProgram FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.student = 1 GROUP BY T2.yearsInProgram ORDER BY COUNT(T1.p_id_dummy) DESC LIMIT 1	computer_student
SELECT COUNT(T1.p_id_dummy) FROM advisedBy AS T1 INNER JOIN person AS T2 ON T1.p_id = T2.p_id WHERE T2.inPhase = 'Pre_Quals' AND T2.student = 1	computer_student
SELECT CAST(COUNT(T1.course_id) AS REAL) / COUNT(DISTINCT T2.p_id) FROM course AS T1 INNER JOIN taughtBy AS T2 ON T1.course_id = T2.course_id WHERE T1.courseLevel = 'Level_500'	computer_student
SELECT COUNT(*) FROM ( SELECT COUNT(course_id) FROM taughtBy GROUP BY course_id HAVING COUNT(course_id) > 4 )	computer_student
SELECT COUNT(course_id) FROM course WHERE courseLevel = 'Level_500'	computer_student
SELECT COUNT(*) FROM person WHERE yearsInProgram = 'Year_1' OR yearsInProgram = 'Year_2'	computer_student
SELECT COUNT(*) FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id WHERE T1.professor = 1 AND T1.hasPosition <> 0	computer_student
SELECT T1.p_id, T1.hasPosition FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id GROUP BY T1.p_id ORDER BY COUNT(T2.course_id) DESC LIMIT 1	computer_student
SELECT DISTINCT T2.course_id FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id WHERE T1.professor = 1 AND T1.hasPosition = 0	computer_student
SELECT T1.p_id, T3.courseLevel FROM person AS T1 INNER JOIN taughtBy AS T2 ON T1.p_id = T2.p_id INNER JOIN course AS T3 ON T3.course_id = T2.course_id GROUP BY T1.p_id ORDER BY COUNT(T2.course_id) DESC LIMIT 1	computer_student
SELECT device_id FROM gender_age WHERE age = ( SELECT MAX(age) FROM gender_age )	talkingdata
SELECT COUNT(event_id) FROM `events` WHERE latitude = 40 AND longitude = 97	talkingdata
SELECT COUNT(gender) FROM gender_age WHERE gender = 'M' AND `group` = 'M32-38'	talkingdata
SELECT COUNT(gender) FROM gender_age WHERE age > 50 AND gender = 'F'	talkingdata
SELECT COUNT(is_active) FROM app_events WHERE event_id = 2 AND is_active = 1	talkingdata
SELECT gender FROM gender_age WHERE age = ( SELECT MIN(age) FROM gender_age )	talkingdata
SELECT T.category FROM ( SELECT T2.category, COUNT(T1.app_id) AS num FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T2.label_id = T1.label_id GROUP BY T1.app_id, T2.category ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id ORDER BY T2.age DESC LIMIT 1	talkingdata
SELECT COUNT(T1.app_id) FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T2.label_id = T1.label_id WHERE T2.category = 'Home Decoration'	talkingdata
SELECT COUNT(T3.gender) FROM app_events AS T1 INNER JOIN events_relevant AS T2 ON T2.event_id = T1.event_id INNER JOIN gender_age AS T3 ON T3.device_id = T2.device_id WHERE T1.is_active = 1 AND T3.gender = 'M' AND T2.timestamp LIKE '2016-05-01%'	talkingdata
SELECT COUNT(T1.gender) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T2.device_id = T1.device_id WHERE T1.gender = 'F' AND T2.device_model = 'ZenFone 5'	talkingdata
SELECT T3.age FROM app_events AS T1 INNER JOIN events_relevant AS T2 ON T1.event_id = T2.event_id INNER JOIN gender_age AS T3 ON T2.device_id = T3.device_id WHERE T1.is_active = 1 AND T2.longitude = 121 AND T2.latitude = 31 AND SUBSTR(T2.timestamp, 1, 10) = '2016-05-06' ORDER BY T3.age DESC LIMIT 1	talkingdata
SELECT T2.device_model FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.`group` = 'F27-28' AND T1.gender = 'F' ORDER BY T2.device_id DESC LIMIT 1	talkingdata
SELECT T4.category FROM events_relevant AS T1 INNER JOIN app_events_relevant AS T2 ON T1.event_id = T2.event_id INNER JOIN app_labels AS T3 ON T3.app_id = T2.app_id INNER JOIN label_categories AS T4 ON T3.label_id = T4.label_id ORDER BY T1.timestamp LIMIT 2	talkingdata
SELECT T.gender FROM ( SELECT T2.gender, COUNT(T2.gender) AS num FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'vivo' GROUP BY T2.gender ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T.category FROM ( SELECT T2.category, COUNT(T1.app_id) AS num FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T2.label_id = T1.label_id GROUP BY T1.app_id, T2.category ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT COUNT(T2.app_id) FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T2.label_id = T1.label_id WHERE T1.category = 'MOBA'	talkingdata
SELECT SUM(IIF(T2.gender = 'F', 1, 0)) * 100 / COUNT(T2.device_id) AS perFemale , SUM(IIF(T2.gender = 'M', 1, 0)) * 100 / COUNT(T2.device_id) AS perMale FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'OPPO'	talkingdata
SELECT longitude, latitude FROM `events` WHERE SUBSTR(`timestamp`, 1, 10) = '2016-05-08'	talkingdata
SELECT app_id , IIF(is_installed = 1, 'YES', 'NO') AS status FROM app_events WHERE event_id = 844	talkingdata
SELECT COUNT(event_id) FROM events WHERE SUBSTR(`timestamp`, 1, 10) = '2016-04-30'	talkingdata
SELECT COUNT(device_id) FROM phone_brand_device_model2 WHERE device_model = 'Xplay3S' AND phone_brand = 'vivo'	talkingdata
SELECT SUM(IIF(gender = 'M' AND `group` = 'M27-28', 1, 0)) / SUM(IIF(gender = 'F' AND `group` = 'F27-28', 1, 0)) AS r FROM gender_age	talkingdata
SELECT label_id FROM label_categories WHERE category IN ('online shopping', 'online malls')	talkingdata
SELECT DISTINCT T2.phone_brand, T2.device_model FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T2.device_id = T1.device_id WHERE T1.timestamp LIKE '2016-05-05%' AND T1.longitude = 112 AND T1.latitude = 44	talkingdata
SELECT T1.app_id, T2.timestamp FROM app_events AS T1 INNER JOIN events AS T2 ON T2.event_id = T1.event_id WHERE T2.event_id = 82	talkingdata
SELECT T1.gender, T1.age FROM gender_age AS T1 INNER JOIN events AS T2 ON T2.device_id = T1.device_id WHERE T2.event_id = 15251	talkingdata
SELECT COUNT(T2.event_id) FROM gender_age AS T1 INNER JOIN events AS T2 ON T2.device_id = T1.device_id WHERE T1.gender = 'M' AND SUBSTR(`timestamp`, 1, 10) = '2016-05-04' AND T1.age = 88	talkingdata
SELECT DISTINCT T1.age, T1.gender, COUNT(T2.event_id) FROM gender_age AS T1 INNER JOIN `events` AS T2 ON T2.device_id = T1.device_id WHERE T2.longitude = -102 AND T2.latitude = 38 GROUP BY T1.age, T1.gender, T2.longitude, T2.latitude	talkingdata
SELECT DISTINCT T1.phone_brand, T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN events AS T2 ON T2.device_id = T1.device_id WHERE T2.longitude = 80 AND T2.latitude = 44	talkingdata
SELECT DISTINCT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T2.label_id = T1.label_id INNER JOIN app_events AS T3 ON T3.app_id = T2.app_id WHERE T3.event_id = 155	talkingdata
SELECT T2.device_id FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.device_model = 'Butterfly' AND T2.gender = 'F' AND T1.phone_brand = 'HTC' LIMIT 5	talkingdata
SELECT COUNT(T2.app_id) FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T2.label_id = T1.label_id WHERE T1.category = 'science fiction'	talkingdata
SELECT T2.age, T2.gender FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'LG' AND T1.device_model = 'L70'	talkingdata
SELECT SUM(IIF(T1.category = 'Industry tag', 1, 0)) * 100 / COUNT(T2.app_id) AS per FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T2.label_id = T1.label_id	talkingdata
SELECT SUM(IIF(T1.device_model = 'Nexus 5', 1, 0)) * 100 / COUNT(T1.device_id) AS per , SUM(IIF(T1.device_model = 'Nexus 5' AND T2.gender = 'M', 1, 0)) / SUM(IIF(T1.device_model = 'Nexus 5' AND T2.gender = 'F', 1, 0)) AS r FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'LG'	talkingdata
SELECT COUNT(event_id) FROM app_events WHERE event_id = 2 AND is_active = 0	talkingdata
SELECT COUNT(event_id) FROM `events` WHERE SUBSTR(`timestamp`, 1, 4) = '2016'	talkingdata
SELECT COUNT(event_id) FROM `events` WHERE SUBSTR(`timestamp`, 1, 4) = '2016' AND device_id = 29182687948017100	talkingdata
SELECT COUNT(device_id) FROM gender_age WHERE gender = 'M'	talkingdata
SELECT MAX(age) FROM gender_age	talkingdata
SELECT COUNT(device_id) FROM gender_age WHERE age < 30 AND gender = 'F'	talkingdata
SELECT COUNT(T1.device_id) FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T2.gender = 'F' AND T1.device_model = 'Galaxy Note 2'	talkingdata
SELECT T2.age FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.device_model = 'Galaxy Note 2'	talkingdata
SELECT device_model FROM phone_brand_device_model2 WHERE device_id IN ( SELECT device_id FROM gender_age WHERE age = ( SELECT MAX(age) FROM gender_age ) )	talkingdata
SELECT T.`group` FROM ( SELECT T2.`group`, COUNT(`group`) AS num FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'vivo' GROUP BY T2.`group` ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT COUNT(T1.app_id) FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T2.label_id = T1.label_id WHERE T2.category = 'Securities'	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T2.app_id = 1977658975649780000	talkingdata
SELECT DISTINCT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id INNER JOIN app_events AS T3 ON T2.app_id = T3.app_id WHERE T3.event_id = 2 AND T3.is_active = 0	talkingdata
SELECT DISTINCT T2.longitude, T2.latitude FROM app_events AS T1 INNER JOIN events AS T2 ON T2.event_id = T1.event_id WHERE T2.event_id = 2 AND T1.is_active = 0	talkingdata
SELECT T2.timestamp FROM app_events AS T1 INNER JOIN events AS T2 ON T2.event_id = T1.event_id WHERE T1.is_active = 0 AND T2.event_id = 2 ORDER BY T2.timestamp LIMIT 1	talkingdata
SELECT T2.event_id FROM phone_brand_device_model2 AS T1 INNER JOIN events AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'vivo'	talkingdata
SELECT COUNT(T1.device_id) FROM phone_brand_device_model2 AS T1 INNER JOIN events AS T2 ON T2.device_id = T1.device_id WHERE T1.phone_brand = 'vivo' AND T2.event_id = 2	talkingdata
SELECT T1.timestamp FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.event_id = T2.device_id WHERE T2.phone_brand = 'vivo' AND T1.event_id = '2'	talkingdata
SELECT COUNT(T1.event_id) FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.event_id = T2.device_id WHERE STRFTIME('%Y', T1.timestamp) = '2016' AND T2.phone_brand = 'vivo'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'F' AND T2.phone_brand = 'vivo' AND T1.age < 30	talkingdata
SELECT T.category FROM ( SELECT T1.category, COUNT(T2.app_id) AS num FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id GROUP BY T1.label_id ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT phone_brand FROM phone_brand_device_model2 WHERE device_id IN ( SELECT * FROM ( SELECT device_id FROM gender_age WHERE gender = 'F' ORDER BY age LIMIT 1 ) AS T )	talkingdata
SELECT COUNT(T2.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.`group` = 'M23-26' AND T2.phone_brand = 'vivo'	talkingdata
SELECT SUM(IIF(T1.`group` = 'M23-26', 1.0, 0)) / COUNT(T1.device_id) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo'	talkingdata
SELECT SUM(IIF(T2.phone_brand = 'vivo', 1, 0)) / COUNT(T1.device_id) AS per FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.event_id = T2.device_id WHERE T1.event_id = '2'	talkingdata
SELECT AVG(age) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo'	talkingdata
SELECT COUNT(device_id) FROM gender_age WHERE `group` = 'F27-28' AND gender = 'F'	talkingdata
SELECT MAX(age) FROM gender_age WHERE gender = 'M'	talkingdata
SELECT COUNT(app_id) FROM app_events WHERE is_installed = 1 AND is_active = 0	talkingdata
SELECT MIN(age) FROM gender_age WHERE gender = 'F'	talkingdata
SELECT COUNT(device_id) FROM phone_brand_device_model2 WHERE phone_brand = 'vivo'	talkingdata
SELECT device_model FROM phone_brand_device_model2 WHERE phone_brand = 'OPPO' LIMIT 15	talkingdata
SELECT T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T2.`group` = 'M39+' AND T2.gender = 'M' LIMIT 10	talkingdata
SELECT T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN events AS T2 ON T1.device_id = T2.event_id INNER JOIN app_events AS T3 ON T2.event_id = T3.event_id WHERE T3.is_active = 1 AND T3.is_installed = 1 LIMIT 5	talkingdata
SELECT COUNT(T1.app_id) FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id WHERE T2.category = 'Financial Information'	talkingdata
SELECT COUNT(T1.app_id) FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id WHERE T2.category = 'game-Art Style'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'OPPO' AND T1.gender = 'M'	talkingdata
SELECT device_model FROM phone_brand_device_model2 WHERE device_id IN ( SELECT device_id FROM gender_age WHERE age = ( SELECT MIN(age) FROM gender_age ) )	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id ORDER BY T2.label_id LIMIT 3	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Galaxy Ace Plus' AND T1.gender = 'M'	talkingdata
SELECT T.`group` FROM ( SELECT T1.`group`, COUNT(T1.`group`) AS num FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'OPPO' GROUP BY T1.`group` ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T.device_model FROM ( SELECT T2.device_model, COUNT(T2.device_model) AS num FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'F' GROUP BY T2.device_model ) AS T ORDER BY T.num DESC LIMIT 5	talkingdata
SELECT SUM(IIF(T1.category = '80s Japanese comic', 1, 0)) / COUNT(T1.label_id) AS J8 , SUM(IIF(T1.category = '90s Japanese comic', 1, 0)) / COUNT(T1.label_id) AS J9 FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id	talkingdata
SELECT SUM(IIF(T1.phone_brand = 'OPPO', 1, 0)) / SUM(IIF(T1.device_id = 'R815T', 1, 0)) AS num FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T2.gender = 'F'	talkingdata
SELECT phone_brand FROM phone_brand_device_model2 WHERE device_model = '坚果手机'	talkingdata
SELECT COUNT(device_id) FROM phone_brand_device_model2 WHERE device_model = '中兴'	talkingdata
SELECT `group` FROM gender_age WHERE age = '24'	talkingdata
SELECT timestamp FROM events WHERE event_id = '887711'	talkingdata
SELECT COUNT(event_id) FROM events WHERE SUBSTR(`timestamp`, 1, 10) = '2016-05-06'	talkingdata
SELECT T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN events AS T2 ON T1.device_id = T2.event_id WHERE T2.longitude = '113' AND T2.latitude = '28' AND T2.timestamp = '2016-05-07 23:55:16'	talkingdata
SELECT COUNT(T2.app_id) FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T1.category = 'game-Fishing'	talkingdata
SELECT COUNT(T2.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.`group` = 'F29-32' AND T2.device_model = '魅蓝Note 2'	talkingdata
SELECT COUNT(T3.device_id) FROM app_events AS T1 INNER JOIN events AS T2 ON T1.event_id = T2.event_id INNER JOIN gender_age AS T3 ON T2.device_id = T3.device_id WHERE SUBSTR(`timestamp`, 1, 10) = '2016-05-02' AND T1.is_active = 1 AND T3.age = '30'	talkingdata
SELECT COUNT(T1.event_id) FROM app_events AS T1 INNER JOIN events AS T2 ON T1.event_id = T2.event_id WHERE SUBSTR(T2.`timestamp`, 1, 10) = '2016-05-06' AND T1.is_installed = '1'	talkingdata
SELECT COUNT(T2.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'F' AND T2.phone_brand = 'E派'	talkingdata
SELECT COUNT(T1.device_id) FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T1.device_model = 'Galaxy S5' AND T2.gender = 'M'	talkingdata
SELECT COUNT(T1.app_id) FROM app_events AS T1 INNER JOIN events AS T2 ON T1.event_id = T2.event_id INNER JOIN gender_age AS T3 ON T2.event_id = T3.device_id WHERE SUBSTR(T2.`timestamp`, 1, 10) = '2016-05-07' AND T1.is_active = '1' AND T3.`group` = 'F29-32'	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T2.app_id = '894384172610331000'	talkingdata
SELECT COUNT(T1.app_id) FROM app_events AS T1 INNER JOIN events AS T2 ON T1.event_id = T2.event_id WHERE T2.timestamp = '2016-05-06 14:09:49' AND T1.is_active = '1' AND T2.longitude = '116' AND T2.latitude = '40'	talkingdata
SELECT SUM(IIF(timestamp = '2016-05-02 7:50:28', 1, 0)) / SUM(IIF(timestamp = '2016-05-02 7:41:03', 1, 0)) AS num FROM events AS T1 INNER JOIN app_events AS T2 ON T1.event_id = T2.event_id WHERE T2.is_active = '1'	talkingdata
SELECT COUNT(device_id) FROM phone_brand_device_model2 WHERE phone_brand = 'vivo'	talkingdata
SELECT SUM(IIF(phone_brand = 'vivo', 1, 0)) - SUM(IIF(phone_brand = 'LG', 1, 0)) AS num FROM phone_brand_device_model2	talkingdata
SELECT device_id FROM gender_age WHERE age = ( SELECT MIN(age) FROM gender_age )	talkingdata
SELECT COUNT(device_id) FROM gender_age WHERE age > 30 AND gender = 'F'	talkingdata
SELECT gender FROM gender_age WHERE age = ( SELECT MAX(age) FROM gender_age )	talkingdata
SELECT MIN(age) FROM gender_age WHERE gender = 'F'	talkingdata
SELECT T1.age FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo' ORDER BY T1.age LIMIT 1	talkingdata
SELECT T2.app_id FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T1.category = 'Securities'	talkingdata
SELECT T1.gender FROM gender_age AS T1 INNER JOIN events AS T2 ON T1.device_id = T2.device_id WHERE T2.timestamp = '2016-05-01 00:55:25'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN events AS T2 ON T1.device_id = T2.device_id WHERE STRFTIME('%Y', T2.timestamp) = '2016' AND T1.`group` = 'M23-26'	talkingdata
SELECT T.phone_brand FROM ( SELECT T2.phone_brand, COUNT(T1.device_id) AS num FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.`group` = 'M23-26' GROUP BY T2.phone_brand ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T1.longitude, T1.latitude FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Galaxy Note 2'	talkingdata
SELECT T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T2.gender = 'F'	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T2.app_id = 7324884708820020000	talkingdata
SELECT COUNT(T2.app_id) FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id INNER JOIN app_events AS T3 ON T2.app_id = T3.app_id WHERE T3.is_active = 0 AND T1.category = 'Property Industry 1.0' AND T3.event_id = 2	talkingdata
SELECT COUNT(*) FROM ( SELECT COUNT(DISTINCT T1.category) AS result FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id INNER JOIN app_events AS T3 ON T2.app_id = T3.app_id WHERE T3.event_id = 2 AND T3.is_active = 0 GROUP BY T1.category ) T	talkingdata
SELECT T.device_model FROM ( SELECT T2.device_model, COUNT(T2.device_model) AS num FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.age > 30 AND T1.gender = 'F' GROUP BY T2.device_model ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T2.device_model FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.longitude = 121 AND T1.latitude = 31	talkingdata
SELECT T.category FROM ( SELECT T2.category, COUNT(T1.app_id) AS num FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id GROUP BY T2.category ) AS T ORDER BY T.num DESC LIMIT 3	talkingdata
SELECT T2.event_id FROM gender_age AS T1 INNER JOIN events AS T2 ON T1.device_id = T2.device_id ORDER BY T1.age DESC LIMIT 1	talkingdata
SELECT COUNT(T1.event_id) FROM events AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T2.gender = 'F' GROUP BY T1.event_id, T2.age ORDER BY T2.age LIMIT 1	talkingdata
SELECT COUNT(T1.device_id) FROM events AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T1.timestamp = '2016-05-01' AND T2.gender = 'M'	talkingdata
SELECT IIF(SUM(IIF(T2.category = 'Securities', 1, 0)) - SUM(IIF(T2.category = 'Finance', 1, 0)) > 0, 'Securities', 'Finance') AS diff FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id	talkingdata
SELECT T2.device_model FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.`group` = 'M23-26'	talkingdata
SELECT AVG(T1.age) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo' AND T1.gender = 'F'	talkingdata
SELECT SUM(IIF(T1.gender = 'M', 1, 0)) / SUM(IIF(T1.gender = 'F', 1, 0)) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo'	talkingdata
SELECT SUM(IIF(T2.category = 'Securities', 1, 0)) / SUM(IIF(T2.category = 'Finance', 1, 0)) AS per FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id	talkingdata
SELECT label_id FROM label_categories WHERE category = 'Third-party card management'	talkingdata
SELECT SUM(IIF(is_active = 1, 1, 0)) / SUM(IIF(is_active = 0, 1, 0)) AS per FROM app_events WHERE event_id = 58	talkingdata
SELECT COUNT(event_id) FROM events WHERE device_id = 3915082290673130000	talkingdata
SELECT SUM(IIF(gender = 'M', 1, 0)) / COUNT(device_id) AS per FROM gender_age	talkingdata
SELECT COUNT(event_id) FROM events WHERE longitude = -156	talkingdata
SELECT COUNT(app_id) FROM app_labels WHERE label_id = 48	talkingdata
SELECT COUNT(label_id) FROM label_categories WHERE category LIKE 'game%'	talkingdata
SELECT COUNT(event_id) FROM events WHERE longitude = 80 AND latitude = 37	talkingdata
SELECT T1.label_id, T2.category FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id WHERE T1.app_id = 5758400314709850000	talkingdata
SELECT T2.app_id FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T1.category = 'game-Rowing'	talkingdata
SELECT T1.label_id, T2.app_id FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T1.category = 'Chinese Classical Mythology'	talkingdata
SELECT COUNT(T1.app_id), T2.longitude, T2.latitude FROM app_events AS T1 INNER JOIN events AS T2 ON T1.event_id = T2.event_id WHERE T1.event_id = 79641 GROUP BY T2.longitude, T2.latitude	talkingdata
SELECT T1.longitude, T1.latitude, T1.timestamp FROM events AS T1 INNER JOIN app_events AS T2 ON T1.event_id = T2.event_id WHERE T2.app_id = 8715964299802120000	talkingdata
SELECT COUNT(T1.device_id) FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'OPPO' AND STRFTIME('%Y-%m-%d', T1.`timestamp`) = '2016-05-01'	talkingdata
SELECT SUM(IIF(T1.gender = 'M', 1, 0)) / SUM(IIF(T1.gender = 'F', 1, 0)) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo' AND T2.device_model = 'X5Pro'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'F' AND T2.device_model = 'Z1' AND T1.`group` = 'F23-' AND T2.phone_brand = 'ZUK'	talkingdata
SELECT T2.phone_brand, T2.device_model FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.age < 10	talkingdata
SELECT SUM(IIF(T1.gender = 'F' AND T1.age > 80, 1, 0)) / COUNT(T1.device_id) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'HTC'	talkingdata
SELECT T2.phone_brand, T2.device_model FROM events AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.event_id = 6701	talkingdata
SELECT T.age, T.gender FROM ( SELECT T2.age, T2.gender, COUNT(T1.device_id) AS num FROM events AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id WHERE T1.device_id BETWEEN -9215352913819630000 AND -9222956879900150000 GROUP BY T2.age, T2.gender ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT timestamp FROM events WHERE event_id = 12	talkingdata
SELECT COUNT(app_id) FROM app_events WHERE is_active = 1	talkingdata
SELECT COUNT(device_id) FROM phone_brand_device_model2 WHERE device_model = 'A51'	talkingdata
SELECT gender FROM gender_age WHERE device_id = -9222956879900150000	talkingdata
SELECT COUNT(label_id) FROM label_categories WHERE category = 'game-card'	talkingdata
SELECT T1.`group` FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Galaxy Note 2' AND T1.age < 30	talkingdata
SELECT SUM(IIF(T1.age < 50, 1, 0)) / COUNT(T1.device_id) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'OPPO'	talkingdata
SELECT SUM(T1.age) / COUNT(T1.device_id) AS avg FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'R7'	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T2.app_id = 5902120154267990000	talkingdata
SELECT T1.`group` FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'LG'	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T2.app_id = 4955831798976240000	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'F' AND T2.device_model = 'MI 3'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Desire 820' AND T1.gender = 'M'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'ELIFE E7 Mini' AND T1.age > 20	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.age BETWEEN 20 AND 50 AND T2.device_model = 'Galaxy Premier'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'M' AND T2.phone_brand = 'HTC'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.age BETWEEN 20 AND 60 AND T2.phone_brand = 'TCL'	talkingdata
SELECT SUM(IIF(T1.age > 20, 1, 0)) / COUNT(T1.device_id) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'SUGAR'	talkingdata
SELECT longitude, latitude FROM events WHERE date(timestamp) = '2016-04-30'	talkingdata
SELECT COUNT(device_model) FROM phone_brand_device_model2 WHERE phone_brand = 'HTC'	talkingdata
SELECT app_id FROM app_events WHERE is_active = 1 AND is_installed = 1	talkingdata
SELECT COUNT(app_id) FROM app_labels WHERE label_id = 7	talkingdata
SELECT device_id FROM gender_age_train WHERE age BETWEEN 29 AND 31 AND gender = 'F'	talkingdata
SELECT T2.app_id FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T1.category = 'game-stress reliever'	talkingdata
SELECT T.timestamp FROM ( SELECT T2.timestamp, COUNT(T2.event_id) AS num FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'M' AND T1.age = 40 GROUP BY T2.timestamp ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T.phone_brand FROM ( SELECT T1.phone_brand, COUNT(T4.is_active) AS num FROM phone_brand_device_model2 AS T1 INNER JOIN gender_age AS T2 ON T1.device_id = T2.device_id INNER JOIN events_relevant AS T3 ON T2.device_id = T3.device_id INNER JOIN app_events_relevant AS T4 ON T3.event_id = T4.event_id WHERE T4.is_active = 1 GROUP BY T1.phone_brand ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id INNER JOIN app_events_relevant AS T3 ON T2.event_id = T3.event_id WHERE T1.gender = 'M' AND T3.is_active = 0 AND T1.age < 23	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id INNER JOIN app_events_relevant AS T3 ON T2.event_id = T3.event_id WHERE T1.age < 23 AND T1.gender = 'F' AND T3.is_active = 0 AND T3.is_installed = 1	talkingdata
SELECT T.gender FROM ( SELECT T1.gender, COUNT(T1.device_id) AS num FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE date(T2.timestamp) BETWEEN '2016-05-01' AND '2016-05-10' GROUP BY T1.gender ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT T.`group` FROM ( SELECT T1.`group`, COUNT(T1.device_id) AS num FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'SM-T2558' GROUP BY T1.`group` ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.age > 50 AND T2.device_model != 'One M8 Eye' AND T2.phone_brand != 'HTC'	talkingdata
SELECT T1.device_id FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE T1.gender = 'F' AND T1.age < 30	talkingdata
SELECT SUM(IIF(T1.gender = 'F', 1, 0)) / SUM(IIF(T1.gender = 'M', 1, 0)) AS per FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id INNER JOIN app_events_relevant AS T3 ON T2.event_id = T3.event_id WHERE T3.is_installed = 0	talkingdata
SELECT AVG(T1.age) FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id INNER JOIN app_events_relevant AS T3 ON T2.event_id = T3.event_id WHERE T3.is_installed = 1 AND T3.is_active = 0	talkingdata
SELECT event_id FROM events WHERE timestamp LIKE '2016-05-01%' AND latitude = 31 LIMIT 3	talkingdata
SELECT event_id FROM events WHERE longitude = 0 AND latitude = 0 LIMIT 3	talkingdata
SELECT SUM(IIF(latitude != 0 AND longitude != 0, 1, 0)) - SUM(IIF(latitude = 0 AND longitude = 0, 1, 0)) AS diff FROM events WHERE device_id = '-922956879900150000'	talkingdata
SELECT device_id FROM gender_age WHERE gender = 'F' LIMIT 3	talkingdata
SELECT category, label_id FROM label_categories WHERE category LIKE '%game%' LIMIT 5	talkingdata
SELECT device_model FROM phone_brand_device_model2 WHERE phone_brand = 'OPPO' LIMIT 3	talkingdata
SELECT SUM(IIF(is_installed = 1 AND is_active = 0, 1, 0)) / COUNT(app_id) AS perrcent FROM app_events WHERE event_id = 6	talkingdata
SELECT IIF(SUM(IIF(T1.gender = 'M', 1, 0)) - SUM(IIF(T1.gender = 'F', 1, 0)) > 0, 'M', 'F') AS gender FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Galaxy Note 2'	talkingdata
SELECT COUNT(T1.app_id) AS num FROM app_events AS T1 INNER JOIN events AS T2 ON T1.event_id = T2.event_id WHERE T1.event_id = 2 AND T1.is_active = 1 GROUP BY T2.timestamp	talkingdata
SELECT T1.category FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T2.app_id = 5902120154267990000	talkingdata
SELECT COUNT(T2.app_id) FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id WHERE T1.category = 'comics'	talkingdata
SELECT T1.age, T1.gender FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE T1.device_id = 29182687948017100 AND T2.event_id = 1	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE T2.longitude = 114 AND T1.gender = 'M'	talkingdata
SELECT T1.timestamp FROM events_relevant AS T1 INNER JOIN app_events AS T2 ON T1.event_id = T2.event_id WHERE T2.app_id = -8022267440849930000 AND T1.event_id = 7	talkingdata
SELECT T3.category FROM app_all AS T1 INNER JOIN app_labels AS T2 ON T1.app_id = T2.app_id INNER JOIN label_categories AS T3 ON T2.label_id = T3.label_id WHERE T1.app_id = -9222198347540750000	talkingdata
SELECT T1.`group` FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'LG' AND T2.device_model = 'Nexus 4'	talkingdata
SELECT T1.gender FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Desire 826' AND T2.phone_brand = 'HTC'	talkingdata
SELECT SUM(IIF(T1.category = 'Academic Information', 1.0, 0)) / COUNT(T2.app_id) AS per FROM label_categories AS T1 INNER JOIN app_labels AS T2 ON T1.label_id = T2.label_id	talkingdata
SELECT SUM(IIF(T1.`group` = 'F27-28', 1, 0)) / COUNT(T1.device_id) AS per FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE SUBSTR(T2.timestamp, 1, 10) = '2016-05-03'	talkingdata
SELECT COUNT(device_id) FROM phone_brand_device_model2 WHERE phone_brand = 'OPPO'	talkingdata
SELECT T.num FROM ( SELECT `group`, COUNT(`group`) AS num FROM gender_age GROUP BY `group` ) T	talkingdata
SELECT COUNT(event_id) FROM events WHERE device_id = 4069764298338760000	talkingdata
SELECT COUNT(T1.app_id) FROM app_labels AS T1 INNER JOIN label_categories AS T2 ON T1.label_id = T2.label_id WHERE T2.category = 'Equity Fund'	talkingdata
SELECT T2.longitude, T2.latitude FROM gender_age AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE T1.`group` = 'F24-26' AND T1.gender = 'F'	talkingdata
SELECT COUNT(T1.device_id) FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.device_model = 'Galaxy Note 3' AND T1.gender = 'M'	talkingdata
SELECT T1.phone_brand, T1.device_model FROM phone_brand_device_model2 AS T1 INNER JOIN events_relevant AS T2 ON T1.device_id = T2.device_id WHERE T2.timestamp = '2016-05-07 06:03:22'	talkingdata
SELECT T.phone_brand FROM ( SELECT T2.phone_brand, COUNT(T2.phone_brand) AS num FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T1.age BETWEEN 20 AND 30 GROUP BY T2.phone_brand ) AS T ORDER BY T.num DESC LIMIT 1	talkingdata
SELECT SUM(IIF(T1.gender IS NULL AND T1.age IS NULL AND T1.`group` IS NULL, 1, 0)) / COUNT(T1.device_id) AS per FROM gender_age AS T1 INNER JOIN phone_brand_device_model2 AS T2 ON T1.device_id = T2.device_id WHERE T2.phone_brand = 'vivo'	talkingdata
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Refuge: Part 1'	law_episode
SELECT COUNT(T2.keyword) FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.season = 9 AND T1.episode = 23	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T2.keyword = 'laundering money'	law_episode
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.rating > 8	law_episode
SELECT T2.votes FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Cherished' AND T2.stars = 10	law_episode
SELECT SUM(T2.votes) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Cherished'	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 10 ORDER BY T2.votes DESC LIMIT 1	law_episode
SELECT T2.role FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T1.title = 'Cherished' AND T3.name = 'Park Dietz' AND T2.credited = 'true'	law_episode
SELECT COUNT(T1.episode_id) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Cherished' AND T2.credited = 'false'	law_episode
SELECT T3.name FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T1.title = 'Cherished' AND T2.credited = 'true' AND T2.role = 'technical advisor'	law_episode
SELECT COUNT(T3.person_id) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T2.credited = 'true' AND T3.name = 'Park Dietz'	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T2.credited = 'true' AND T3.name = 'Park Dietz'	law_episode
SELECT T1.credited FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T2.name = 'Anthony Azzara' AND T1.episode_id = 'tt0629204'	law_episode
SELECT COUNT(T2.keyword) FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Disciple'	law_episode
SELECT T2.title FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id WHERE T1.stars = 1 ORDER BY T1.votes DESC LIMIT 1	law_episode
SELECT COUNT(T2.award_id) FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T2.series = 'Law and Order' AND T1.season = 9 AND T1.episode = 20	law_episode
SELECT COUNT(T2.role) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.series = 'Law and Order' AND T1.season = 9 AND T1.episode = 17 AND T2.credited = 'true'	law_episode
SELECT T1.summary FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T2.award_id = 296	law_episode
SELECT T1.role FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T2.name = 'Joseph Blair'	law_episode
SELECT COUNT(T2.award_id) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T1.name = 'Rene Balcer'	law_episode
SELECT T2.air_date FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id GROUP BY T2.episode_id ORDER BY SUM(T1.votes) DESC LIMIT 1	law_episode
SELECT T1.name FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.award_id = 313	law_episode
SELECT COUNT(T1.role) FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T2.name = 'J.K. Simmons'	law_episode
SELECT T2.votes FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 9 AND T1.title = 'Sideshow'	law_episode
SELECT CAST(SUM(CASE WHEN T1.title = 'Refuge: Part 1' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.title = 'Shield' THEN 1 ELSE 0 END) FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id	law_episode
SELECT CAST(COUNT(T1.episode_id) AS REAL) / (193 - 185 + 1) FROM Credit AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.category = 'Cast' AND T1.credited = 'true' AND T2.number_in_series BETWEEN 185 AND 193	law_episode
SELECT T2.name FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.credited = 'false' AND T1.episode_id = 'tt0629391'	law_episode
SELECT COUNT(T1.person_id) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.result = 'Winner' GROUP BY T1.person_id HAVING COUNT(T2.award_id) >= 3	law_episode
SELECT T2.name FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.episode_id = 'tt0629204' AND T1.role = 'script supervisor'	law_episode
SELECT COUNT(T2.award_id) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T1.name = 'Julia Roberts' AND T2.result = 'Nominee'	law_episode
SELECT T2.name FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.role = 'camera operator' ORDER BY T2.height_meters DESC LIMIT 1	law_episode
SELECT COUNT(T1.person_id) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.year = 1999 AND T1.birth_country = 'Canada'	law_episode
SELECT COUNT(T1.episode_id) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 10	law_episode
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Shield'	law_episode
SELECT CAST(SUM(CASE WHEN T2.stars = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.episode_id) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'True North' AND T1.episode_id = 'tt0629477'	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id GROUP BY T1.episode_id ORDER BY COUNT(T2.keyword) DESC LIMIT 1	law_episode
SELECT COUNT(T1.episode_id) FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE strftime('%Y', T1.air_date) = '1998' AND T2.organization = 'International Monitor Awards' AND T2.result = 'Winner'	law_episode
SELECT COUNT(T2.award_id) FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Agony' AND T2.result = 'Winner'	law_episode
SELECT SUM(CASE WHEN T2.season = 9 THEN 1 ELSE 0 END) AS num , CAST(SUM(CASE WHEN T2.season = 9 THEN 1 ELSE 0 END) AS REAL) / COUNT(T1.episode_id) FROM Credit AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.category = 'Cast' AND T2.series = 'Law and Order'	law_episode
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.votes NOT IN ( SELECT MAX(T1.votes) FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id ) ORDER BY T1.votes DESC LIMIT 1	law_episode
SELECT COUNT(T2.award) FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Agony' AND T2.result = 'Winner'	law_episode
SELECT T3.name FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T1.title = 'Flight' AND T2.role = 'Narrator'	law_episode
SELECT T2.organization FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T1.name = 'Constantine Makris' AND T2.result = 'Winner' GROUP BY T2.organization ORDER BY COUNT(T2.award_id) DESC LIMIT 1	law_episode
SELECT T3.name FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T1.episode = 3 AND T2.role = 'stunt coordinator'	law_episode
SELECT COUNT(T2.person_id) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Admissions' AND T2.credited = 'false'	law_episode
SELECT T2.title FROM Credit AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.category = 'Art Department' GROUP BY T2.episode_id ORDER BY COUNT(T1.category) DESC LIMIT 1	law_episode
SELECT COUNT(T1.role) FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T2.name = 'Julia Roberts'	law_episode
SELECT T2.title FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id WHERE T1.votes >= 30 AND T1.stars = 10 ORDER BY T1.votes DESC LIMIT 3	law_episode
SELECT T2.name FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.role = 'Clerk' AND T2.birthdate IS NOT NULL ORDER BY T2.birthdate LIMIT 1	law_episode
SELECT COUNT(T1.episode_id) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.episode = 24 AND T2.stars = 1	law_episode
SELECT T2.name FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.category = 'Cast'	law_episode
SELECT T2.person_id, CAST(COUNT(T2.person_id) AS REAL) * 100 / ( SELECT COUNT(T2.person_id) AS num FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id ) AS per FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id GROUP BY T2.person_id ORDER BY COUNT(T2.person_id) DESC LIMIT 1	law_episode
SELECT DISTINCT episode_id FROM Award WHERE award_category = 'Primetime Emmy'	law_episode
SELECT COUNT(award_id) FROM Award WHERE Result = 'Nominee'	law_episode
SELECT DISTINCT role FROM Credit WHERE credited = 'false'	law_episode
SELECT title FROM Episode ORDER BY rating LIMIT 3	law_episode
SELECT birth_place, birth_region FROM Person WHERE birth_name = 'Rene Chenevert Balcer'	law_episode
SELECT name FROM Person WHERE birth_country = 'USA'	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 1	law_episode
SELECT T1.name FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.Result = 'Winner' AND T2.role = 'director'	law_episode
SELECT SUM(T2.votes) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Juvenile'	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T2.credited = 'false' AND T3.name = 'Anthony Azzara'	law_episode
SELECT DISTINCT T1.year FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T2.title = 'DWB' AND T1.result = 'Winner'	law_episode
SELECT T2.birth_region FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.role = 'president of NBC West Coast'	law_episode
SELECT COUNT(T3.person_id) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T3.name = 'Donna Villella'	law_episode
SELECT T2.role FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.Result = 'Nominee' AND T1.name = 'Julia Roberts'	law_episode
SELECT T2.role FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.person_id = T2.person_id INNER JOIN Award AS T3 ON T2.episode_id = T3.episode_id ORDER BY T1.height_meters DESC LIMIT 1	law_episode
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.result = 'Nominee' GROUP BY T2.episode_id ORDER BY COUNT(T1.result) DESC LIMIT 1	law_episode
SELECT T1.rating FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T3.name = 'Jace Alexander'	law_episode
SELECT T3.name FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T1.episode = 19 AND T1.season = 9	law_episode
SELECT CAST(SUM(T3.stars) AS REAL) / COUNT(T2.episode_id) FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.person_id = T2.person_id INNER JOIN Vote AS T3 ON T2.episode_id = T3.episode_id WHERE T3.stars = 1 AND T1.name = 'Jim Bracchitta'	law_episode
SELECT CAST(SUM(CASE WHEN T2.role = 'Additional Crew' THEN 1 ELSE 0 END) AS REAL ) * 100 / COUNT(T1.episode_id) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'True North'	law_episode
SELECT T2.title, T2.summary, T2.air_date FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id WHERE T1.stars = 10 AND T1.votes = 72	law_episode
SELECT T2.air_date, T2.rating FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id WHERE T1.stars = 6 AND T2.episode = 12	law_episode
SELECT T1.name, T2.role FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.year = 2000 AND T2.award_category = 'Edgar' AND T2.award = 'Best Television Episode'	law_episode
SELECT T2.organization, T2.year, T2.award, T2.award_category FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T1.name = 'Rene Balcer' AND T2.result = 'Winner'	law_episode
SELECT t3.years, t3.episode_id FROM ( SELECT DISTINCT T2.year AS years, T2.episode_id, row_number() OVER (PARTITION BY T2.episode_id ORDER BY T2.year) AS rm FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.award = 'Television' AND T2.award_category = 'Silver Gavel Award' AND T1.name = 'Constantine Makris' AND T2.result = 'Winner' AND T2.organization = 'American Bar Association Silver Gavel Awards for Media and the Arts' ) AS T3 GROUP BY t3.episode_id HAVING COUNT(t3.years - t3.rm) >= 2	law_episode
SELECT t3.name FROM ( SELECT DISTINCT T2.year AS years, T1.name, row_number() OVER (PARTITION BY T1.name ORDER BY T2.year) AS rm FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T2.award = 'Television' AND T2.award_category = 'Silver Gavel Award' AND T2.series = 'Law and Order' AND T2.result = 'Winner' AND T2.organization = 'American Bar Association Silver Gavel Awards for Media and the Arts' ) AS T3 GROUP BY t3.name HAVING COUNT(t3.years - t3.rm) >= 2	law_episode
SELECT COUNT(T2.award_id) FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T2.year = 1999 AND T2.result = 'Nominee' AND T1.episode = 20 AND T2.organization = 'Primetime Emmy Awards' AND T1.series = 'Law and Order'	law_episode
SELECT T3.episode_id, T2.role FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id INNER JOIN Episode AS T3 ON T2.episode_id = T3.episode_id WHERE T2.year = 1999 AND T2.award = 'Outstanding Guest Actress in a Drama Series' AND T2.organization = 'Primetime Emmy Awards' AND T1.name = 'Julia Roberts' AND T2.result = 'Nominee'	law_episode
SELECT T1.title, T1.air_date FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T2.category = 'Produced by' AND T2.role = 'producer' AND T3.name = 'Billy Fox'	law_episode
SELECT COUNT(T1.person_id) FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T1.episode_id = 'tt0629228' AND T1.category = 'Cast' AND T1.credited = 'false' AND T2.birth_country = 'USA'	law_episode
SELECT T1.role FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id INNER JOIN Episode AS T3 ON T1.episode_id = T3.episode_id WHERE T3.episode = 9 AND T2.name = 'Jason Kuschner'	law_episode
SELECT T2.name FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id INNER JOIN Episode AS T3 ON T1.episode_id = T3.episode_id WHERE T3.episode = 1 AND T1.role = 'president of NBC West Coast'	law_episode
SELECT T2.title FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id WHERE T1.stars BETWEEN 1 AND 10 GROUP BY T2.title ORDER BY CAST(SUM(T1.stars * T1.percent) AS REAL) / 100 DESC LIMIT 3	law_episode
SELECT CAST(SUM(CASE WHEN T2.category = 'Cast' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.category), T1.role FROM Award AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Episode AS T3 ON T2.episode_id = T3.episode_id INNER JOIN Person AS T4 ON T2.person_id = T4.person_id WHERE T3.episode = 2 AND T4.birth_country = 'USA'	law_episode
SELECT COUNT(T1.person_id) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id WHERE T1.birth_country = 'Canada'	law_episode
SELECT COUNT(T2.person_id) FROM Credit AS T1 INNER JOIN Person AS T2 ON T2.person_id = T1.person_id WHERE T2.name = 'Jerry Orbach'	law_episode
SELECT T3.name FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T3.person_id = T2.person_id WHERE T1.episode = 9	law_episode
SELECT T2.award FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T1.episode = 20 AND T2.result IN ('Winner', 'Nominee')	law_episode
SELECT T1.name FROM Person AS T1 INNER JOIN Award AS T2 ON T1.person_id = T2.person_id GROUP BY T2.role HAVING COUNT(T2.award_id) > 1	law_episode
SELECT T3.name, T1.episode_id FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Person AS T3 ON T2.person_id = T3.person_id WHERE T2.role = 'director' AND T2.result = 'Winner'	law_episode
SELECT T1.episode FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T2.result = 'Nominee'	law_episode
SELECT SUM(rating) / COUNT(episode_id) FROM Episode WHERE season = 9	law_episode
SELECT SUM(CASE WHEN T2.episode = 24 THEN T1.votes ELSE 0 END) - SUM(CASE WHEN T2.episode = 1 THEN T1.votes ELSE 0 END) FROM Vote AS T1 INNER JOIN Episode AS T2 ON T2.episode_id = T1.episode_id WHERE T1.stars = 10	law_episode
SELECT T1.rating FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id WHERE T2.result = 'Winner' GROUP BY T1.episode_id ORDER BY COUNT(T2.award_id) DESC LIMIT 1	law_episode
SELECT COUNT(T1.person_id) FROM Credit AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.credited = 'true' AND T2.episode BETWEEN 1 AND 10	law_episode
SELECT T1.episode FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T2.Keyword = 'mafia'	law_episode
SELECT T2.person_id FROM Vote AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id ORDER BY T1.percent DESC LIMIT 1	law_episode
SELECT SUM(T1.rating) / COUNT(T1.episode) FROM Episode AS T1 INNER JOIN Award AS T2 ON T1.episode_id = T2.episode_id	law_episode
SELECT COUNT(award_id) FROM Award WHERE result = 'Winner' AND award = 'Television' AND organization = 'American Bar Association Silver Gavel Awards for Media and the Arts'	law_episode
SELECT birth_country FROM Person WHERE name = 'Michael Preston'	law_episode
SELECT T2.name FROM Award AS T1 INNER JOIN Person AS T2 ON T1.person_id = T2.person_id WHERE T1.result = 'Nominee' AND T1.role = 'Katrina Ludlow' AND T1.series = 'Law and Order'	law_episode
SELECT T2.name FROM Award AS T1 INNER JOIN Person AS T2 ON T1.person_id = T2.person_id WHERE T1.result = 'Winner' AND T1.award = 'Best Television Episode'	law_episode
SELECT T2.birthdate FROM Award AS T1 INNER JOIN Person AS T2 ON T1.person_id = T2.person_id WHERE T1.role = 'writer'	law_episode
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.award = 'Outstanding Costume Design for a Series'	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id GROUP BY T1.title ORDER BY SUM(T1.votes) DESC LIMIT 1	law_episode
SELECT T1.name FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.person_id = T2.person_id WHERE T2.role = 'Alex Brown' AND T2.credited = 'true'	law_episode
SELECT DISTINCT T1.birth_place FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.person_id = T2.person_id WHERE T1.person_id = 'nm0007064' AND T2.role = 'Narrator' AND T2.credited = 'false'	law_episode
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Shield'	law_episode
SELECT T2.name FROM Award AS T1 INNER JOIN Person AS T2 ON T1.person_id = T2.person_id WHERE T1.result = 'Winner' AND T2.height_meters > 1.80	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T2.keyword IN ('nun', 'priest')	law_episode
SELECT T2.episode_id FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.award = 'Best Television Episode' AND T1.result = 'Winner' ORDER BY T2.rating DESC LIMIT 2	law_episode
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 10 LIMIT 3	law_episode
SELECT T2.value, T2.units FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.date = '2008-03-11' AND T2.description = 'Body Height'	synthea
SELECT SUM(CASE WHEN strftime('%Y', T2.date) = '2009' THEN T2.VALUE END) - SUM(CASE WHEN strftime('%Y', T2.date) = '2008' THEN T2.VALUE END) AS increase , T2.units FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description = 'Body Height'	synthea
SELECT T2.value, T2.units FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description = 'Systolic Blood Pressure' ORDER BY T2.VALUE DESC LIMIT 1	synthea
SELECT COUNT(T2.description) FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description = 'Systolic Blood Pressure'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T2.VALUE = ( SELECT MAX(VALUE) FROM observations WHERE description = 'Systolic Blood Pressure' ) LIMIT 1	synthea
SELECT strftime('%J', T2.STOP) - strftime('%J', T2.START) AS days FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description LIKE 'Acetaminophen%'	synthea
SELECT DISTINCT T2.description FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss'	synthea
SELECT T2.REASONDESCRIPTION FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description LIKE 'Acetaminophen%'	synthea
SELECT T2.description FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.reasondescription = 'Streptococcal sore throat (disorder)'	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.description LIKE 'Acetaminophen%'	synthea
SELECT T2.description FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.START = '2009-01-08'	synthea
SELECT strftime('%J', T2.STOP) - strftime('%J', T2.START) AS days FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description = 'Cystitis'	synthea
SELECT AVG(T2.VALUE), T2.units FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.description = 'Body Weight'	synthea
SELECT CAST(SUM(CASE WHEN T1.marital = 'M' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.description = 'Cystitis'	synthea
SELECT T2.description, T2.VALUE, T2.units FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mr.' AND T1.first = 'Vincent' AND T1.last = 'Wyman' AND T2.date = '2010-08-02' AND T2.description = 'Body Height'	synthea
SELECT COUNT(T2.PATIENT) FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mrs.' AND T1.first = 'Norman' AND T1.last = 'Berge'	synthea
SELECT T2.reasondescription FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mrs.' AND T1.first = 'Annabelle' AND T1.last = 'Pouros' AND T2.start = '1970-12-19' AND T2.description = 'Leucovorin 100 MG Injection'	synthea
SELECT DISTINCT T1."PREVALENCE PERCENTAGE" FROM all_prevalences AS T1 INNER JOIN conditions AS T2 ON lower(T1.ITEM) = lower(T2.DESCRIPTION) WHERE T2.code = '64859006'	synthea
SELECT DISTINCT T1."PREVALENCE RATE" FROM all_prevalences AS T1 INNER JOIN conditions AS T2 ON lower(T1.ITEM) = lower(T2.DESCRIPTION) WHERE T2.code = '368581000119106'	synthea
SELECT DISTINCT T2.description FROM patients AS T1 INNER JOIN procedures AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Ms.' AND T1.first = 'Jacquelyn' AND T1.last = 'Shanahan' AND T2.DATE = '2009-08-09'	synthea
SELECT COUNT(T2.BILLABLEPERIOD) FROM patients AS T1 INNER JOIN claims AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Ms.' AND T1.first = 'Abbie' AND T1.last = 'Cole' AND T2.BILLABLEPERIOD BETWEEN '2010-12-31' AND '2012-01-01'	synthea
SELECT COUNT(DISTINCT T2.code) FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mrs.' AND T1.first = 'Saundra' AND T1.last = 'Monahan'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN claims AS T2 ON T1.patient = T2.PATIENT WHERE T2.billableperiod = '1947-09-11'	synthea
SELECT T2.description FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mr.' AND T1.first = 'Hubert' AND T1.last = 'Baumbach' AND T2.date = '2008-10-25'	synthea
SELECT T2.description FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Keven' AND T1.last = 'Kuhn' AND T2.start = '2016-09-24' AND T2.stop = '2016-10-10'	synthea
SELECT T2.date FROM patients AS T1 INNER JOIN procedures AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mrs.' AND T1.first = 'Ira' AND T1.last = 'Deckow' AND T2.description = 'Standard pregnancy test'	synthea
SELECT CAST(SUM(strftime('%J', T2.STOP) - strftime('%J', T2.START)) AS REAL) / COUNT(T1.patient) FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Mr.' AND T1.first = 'Wesley' AND T1.last = 'Lemke'	synthea
SELECT CAST(SUM(strftime('%J', T2.STOP) - strftime('%J', T2.START)) AS REAL) / COUNT(T2.PATIENT) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Ms.' AND T1.first = 'Angelena' AND T1.last = 'Kertzmann' AND T2.description = 'Normal pregnancy'	synthea
SELECT PATIENT FROM allergies WHERE STOP IS NOT NULL GROUP BY PATIENT ORDER BY CASE WHEN SUBSTR(STOP, -2, 1) != '9' THEN SUBSTR(STOP, LENGTH(STOP) - 1) + 2000 END - CASE WHEN SUBSTR(START, -2, 1) = '9' THEN SUBSTR(START, LENGTH(START) - 1) + 1900 ELSE SUBSTR(START, LENGTH(START) - 1) + 2000 END LIMIT 1	synthea
SELECT COUNT(PATIENT) FROM conditions WHERE DESCRIPTION = 'Diabetes' AND strftime('%Y', START) = '1988'	synthea
SELECT COUNT(PATIENT) FROM allergies WHERE DESCRIPTION = 'Allergy to eggs'	synthea
SELECT PATIENT FROM conditions WHERE START = ( SELECT MAX(START) FROM conditions WHERE DESCRIPTION = 'Hypertension' )	synthea
SELECT DESCRIPTION FROM allergies GROUP BY DESCRIPTION ORDER BY COUNT(DESCRIPTION) DESC LIMIT 1	synthea
SELECT PATIENT FROM observations WHERE DESCRIPTION = 'Body Height' AND UNITS = 'cm' ORDER BY VALUE DESC LIMIT 1	synthea
SELECT T2.DESCRIPTION FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.gender = 'F' AND T1.ethnicity = 'american' GROUP BY T2.DESCRIPTION ORDER BY COUNT(T2.DESCRIPTION) DESC LIMIT 1	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Ibuprofen 200 MG Oral Tablet' AND T1.ethnicity = 'dominican' AND strftime('%Y', T2.START) = '2016' AND strftime('%m', T2.STOP) - strftime('%m', T2.START) = 1	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE DESCRIPTION = 'Pneumonia' AND strftime('%Y', T1.birthdate) LIKE '192%'	synthea
SELECT DISTINCT T1.first, T1.last, T1.suffix FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Yaz 28 Day Pack' AND strftime('%Y', T2.START) = '2011'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T1.race = 'black' AND T2.DESCRIPTION = 'DTaP' AND strftime('%Y', T2.DATE) = '2013'	synthea
SELECT COUNT(T2.patient) FROM all_prevalences AS T1 INNER JOIN conditions AS T2 ON lower(T1.ITEM) = lower(T2.DESCRIPTION) INNER JOIN immunizations AS T3 ON T2.PATIENT = T3.PATIENT GROUP BY T2.PATIENT ORDER BY T2.START DESC, T1."PREVALENCE RATE" DESC LIMIT 1	synthea
SELECT COUNT(DISTINCT T2.patient) FROM all_prevalences AS T1 INNER JOIN conditions AS T2 ON lower(T1.ITEM) = lower(T2.DESCRIPTION) ORDER BY T1."PREVALENCE RATE" DESC LIMIT 1	synthea
SELECT T2.DESCRIPTION FROM immunizations AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.DESCRIPTION = 'Influenza  seasonal  injectable  preservative free' GROUP BY T2.DESCRIPTION ORDER BY COUNT(T2.DESCRIPTION) DESC LIMIT 1	synthea
SELECT DISTINCT T1.PATIENT FROM conditions AS T1 INNER JOIN all_prevalences AS T2 ON lower(T2.ITEM) = lower(T1.DESCRIPTION) WHERE T2."PREVALENCE PERCENTAGE" = CAST(18.8 AS float)	synthea
SELECT COUNT(DISTINCT T2.DESCRIPTION) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Tyree' AND T1.last = 'Eichmann'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM immunizations AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.DESCRIPTION = 'meningococcal MCV4P' AND T2.DESCRIPTION = 'Viral sinusitis (disorder)'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.gender = 'F' AND T1.DESCRIPTION = 'Prediabetes'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Body Mass Index' AND T2.UNITS = 'kg/m2' ORDER BY T2.VALUE LIMIT 1	synthea
SELECT strftime('%Y', T2.deathdate) - strftime('%Y', T2.birthdate) AS age FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.first = 'Giovanni' AND T2.last = 'Russel' AND T1.DESCRIPTION = 'Hypertension'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM medications AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'oxaliplatin 5 MG/ML [Eloxatin]' AND T2.race = 'asian' AND T2.gender = 'F'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.description = 'Stroke' AND T2.deathdate IS NULL	synthea
SELECT COUNT(T2.patient) FROM allergies AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Allergy to peanuts' AND T2.race = 'asian'	synthea
SELECT AVG(T1.VALUE) FROM observations AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient INNER JOIN conditions AS T3 ON T2.patient = T3.PATIENT WHERE T3.DESCRIPTION = 'Hypertension' AND T1.DESCRIPTION = 'Diastolic Blood Pressure'	synthea
SELECT T1.DESCRIPTION FROM medications AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.ssn = '999-94-3751'	synthea
SELECT T2.ssn FROM allergies AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Allergy to grass pollen' AND T2.ethnicity = 'irish' AND T2.gender = 'F'	synthea
SELECT T2.first, T2.last FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.CODE = 315043002	synthea
SELECT T1.DESCRIPTION FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.deathdate IS NOT NULL ORDER BY strftime('%Y', T2.deathdate) - strftime('%Y', T2.birthdate) DESC LIMIT 1	synthea
SELECT T2.code FROM all_prevalences AS T1 INNER JOIN conditions AS T2 ON T1.ITEM = T2.DESCRIPTION ORDER BY T1.OCCURRENCES DESC LIMIT 1	synthea
SELECT DISTINCT T2.DESCRIPTION, T2.VALUE, T2.UNITS FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Glucose' AND T1.address = '365 Della Crossroad Suite 202 Deerfield MA 01342 US'	synthea
SELECT DISTINCT T2.ssn FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient INNER JOIN all_prevalences AS T3 ON lower(T1.DESCRIPTION) = lower(T3.ITEM) WHERE CAST(T3."PREVALENCE PERCENTAGE" AS REAL) * 100 / ( SELECT AVG('PREVALENCE PERCENTAGE') FROM all_prevalences ) < 30 LIMIT 5	synthea
SELECT CAST(SUM(CASE WHEN T2.gender = 'F' AND T2.race = 'asian' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.gender) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Acute bronchitis (disorder)'	synthea
SELECT COUNT(T2.ID) FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Major' AND T1.last = 'D''Amore'	synthea
SELECT T2.DESCRIPTION FROM patients AS T1 INNER JOIN procedures AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Emmy' AND T1.last = 'Waelchi'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN procedures AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Extraction of wisdom tooth'	synthea
SELECT T2.DESCRIPTION, T2.VALUE, T2.UNITS FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.DESCRIPTION = 'Body Weight'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Allergy to soya'	synthea
SELECT COUNT(T2.CODE) FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Keven' AND T1.last = 'Kuhn' AND T2.DESCRIPTION = 'DTaP'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Clopidogrel 75 MG Oral Tablet' AND strftime('%Y', T2.STOP) - strftime('%Y', T2.START) > 10	synthea
SELECT DISTINCT T1.DESCRIPTION, T3.DESCRIPTION FROM procedures AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT INNER JOIN medications AS T3 ON T2.patient = T3.PATIENT WHERE T2.DESCRIPTION = 'Third degree burn'	synthea
SELECT T2.DESCRIPTION FROM allergies AS T1 INNER JOIN medications AS T2 ON T1.PATIENT = T2.PATIENT WHERE T1.START = '6/6/16' AND T1.DESCRIPTION = 'Allergy to mould'	synthea
SELECT DISTINCT T1.DESCRIPTION FROM careplans AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Secondary malignant neoplasm of colon'	synthea
SELECT T2."PREVALENCE RATE" FROM conditions AS T1 INNER JOIN all_prevalences AS T2 ON lower(T1.DESCRIPTION) = lower(T2.ITEM) WHERE T1.START = '2014-05-09'	synthea
SELECT T2.first, T2.last , CASE WHEN T2.deathdate IS NULL THEN strftime('%Y', T1.DATE) - strftime('%Y', T2.birthdate) ELSE strftime('%Y', T2.deathdate) - strftime('%Y', T2.birthdate) END AS age FROM observations AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Systolic Blood Pressure' AND T1.VALUE = 200 AND T1.UNITS = 'mmHg' AND strftime('%Y', T1.DATE) = '2011'	synthea
SELECT CAST(SUM(CASE WHEN T2.DESCRIPTION = 'Influenza seasonal injectable preservative free' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.patient), SUM(CASE WHEN T1.ethnicity = 'english' THEN 1 ELSE 0 END) FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE strftime('%Y', T2.DATE) = '2017'	synthea
SELECT DISTINCT T1.first FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T2.REASONDESCRIPTION = 'Normal pregnancy'	synthea
SELECT DISTINCT T1.birthdate FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Outpatient Encounter'	synthea
SELECT DISTINCT T1.first FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Cystitis'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Stroke' AND T1.marital = 'M'	synthea
SELECT DISTINCT T1.address FROM patients AS T1 INNER JOIN claims AS T2 ON T1.patient = T2.PATIENT WHERE T2.BILLABLEPERIOD LIKE '2010%'	synthea
SELECT DISTINCT T1.last FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Allergy to dairy product'	synthea
SELECT T2.START FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Adolfo' AND T1.last = 'Schmitt' AND T2.STOP IS NOT NULL	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'House dust mite allergy' AND T1.gender = 'M'	synthea
SELECT T2.DESCRIPTION FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T1.race = 'white' GROUP BY T2.DESCRIPTION ORDER BY COUNT(T2.DESCRIPTION) DESC LIMIT 1	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Influenza  seasonal  injectable  preservative free'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'HPV  quadrivalent' AND T1.gender = 'F'	synthea
SELECT DISTINCT T2.DESCRIPTION FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.birthplace = 'Pittsfield MA US'	synthea
SELECT COUNT(DISTINCT T2.DESCRIPTION) FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T1.ethnicity = 'german'	synthea
SELECT CAST(SUM(CASE WHEN T1.deathdate IS NULL THEN strftime('%Y', T2.STOP) - strftime('%Y', T1.birthdate) ELSE strftime('%Y', T1.deathdate) - strftime('%Y', T1.birthdate) END) AS REAL) / COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T2.REASONDESCRIPTION = 'Prediabetes'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM medications AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.REASONDESCRIPTION = 'Coronary Heart Disease' AND T1.STOP IS NOT NULL AND T2.deathdate IS NULL	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN procedures AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Bone immobilization' AND T1.drivers IS NOT NULL	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT GROUP BY T1.patient ORDER BY COUNT(DISTINCT T2.DESCRIPTION) > 3	synthea
SELECT COUNT(DISTINCT T2.patient) FROM allergies AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient INNER JOIN immunizations AS T3 ON T2.patient = T3.PATIENT WHERE T1.DESCRIPTION = 'Allergy to eggs' AND T3.DESCRIPTION = 'Td (adult) preservative free'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient INNER JOIN observations AS T3 ON T2.patient = T3.PATIENT WHERE T3.DESCRIPTION = 'Body Weight' AND T1.DESCRIPTION = 'Diabetes self management plan' AND T3.VALUE > 100 AND T3.UNITS = 'kg'	synthea
SELECT T1.gender FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Dander (animal) allergy' GROUP BY T1.gender ORDER BY COUNT(T1.gender) DESC LIMIT 1	synthea
SELECT DISTINCT T2.BILLABLEPERIOD FROM patients AS T1 INNER JOIN claims AS T2 ON T1.patient = T2.PATIENT WHERE T1.last = 'Dickinson'	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Otitis media'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.REASONDESCRIPTION = 'Myocardial Infarction' AND T1.ethnicity = 'irish'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.marital = 'M' AND T2.REASONDESCRIPTION = 'Concussion with loss of consciousness'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM careplans AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'rotavirus  monovalent' AND T1.STOP = '2013-11-23'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Nitroglycerin 0.4 MG/ACTUAT [Nitrolingual]' AND T1.gender = 'F'	synthea
SELECT CAST(SUM(CASE WHEN T2.DESCRIPTION = 'Allergy to grass pollen' THEN 1 ELSE 0 END) AS REL) * 100 / COUNT(T1.patient) FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T1.birthplace = 'Pembroke MA US'	synthea
SELECT SUM(T2.VALUE) / COUNT(T1.patient) FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.race = 'asian' AND T2.DESCRIPTION = 'Body Weight' AND T2.UNITS = 'kg'	synthea
SELECT T1.ssn FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Latex allergy'	synthea
SELECT CASE WHEN SUBSTR(T1.STOP, -2, 1) != '9' THEN SUBSTR(T1.STOP, LENGTH(T1.STOP) - 1) + 2000 END - CASE WHEN SUBSTR(T1.START, -2, 1) = '9' THEN SUBSTR(T1.START, LENGTH(T1.START) - 1) + 1900 ELSE SUBSTR(T1.START, LENGTH(T1.START) - 1) + 2000 END AS years , T1.DESCRIPTION FROM allergies AS T1 INNER JOIN patients AS T2 ON T2.patient = T1.PATIENT WHERE T1.STOP IS NOT NULL AND T1.START IS NOT NULL AND T2.first = 'Isadora' AND T2.last = 'Moen'	synthea
SELECT COUNT(T2.PATIENT) FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND T2.START BETWEEN '2009-01-11' AND '2010-10-23'	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.marital = 'M' AND strftime('%J', T2.STOP) - strftime('%J', T2.START) > 60	synthea
SELECT T2.DATE FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Influenza  seasonal  injectable  preservative free' AND T1.first = 'Elly' AND T1.last = 'Koss'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'meningococcal MCV4P' AND T2.DATE BETWEEN '2010-07-09' AND '2013-10-29' AND T1.race = 'black'	synthea
SELECT DISTINCT T2.CODE, T2.DATE FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T1.prefix = 'Ms.' AND T1.first = 'Jacquelyn' AND T1.last = 'Shanahan' AND T2.DESCRIPTION = 'Influenza  seasonal  injectable  preservative free'	synthea
SELECT strftime('%J', T2.STOP) - strftime('%J', T2.START) AS takenDays FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Berry' AND T1.last = 'Keebler' AND T2.REASONDESCRIPTION = 'Acute bronchitis (disorder)' AND T2.DESCRIPTION = 'Acetaminophen 160 MG'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.marital = 'S' AND T2.REASONDESCRIPTION = 'Cystitis' AND T2.DESCRIPTION = 'Nitrofurantoin 5 MG/ML [Furadantin]' AND strftime('%Y', T2.START) = '2010'	synthea
SELECT T2.REASONDESCRIPTION FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T2.DATE = '2013-11-20' AND T1.first = 'Lavelle' AND T1.last = 'Vandervort'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.ethnicity = 'german' AND T2.DATE BETWEEN '2011-01-09' AND '2012-08-29' AND T2.DESCRIPTION = 'Outpatient Encounter'	synthea
SELECT T1.ssn, T1.address FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T2.DATE = '2008-06-13' AND T2.REASONDESCRIPTION = 'Viral sinusitis (disorder)' AND T2.DESCRIPTION = 'Encounter for symptom'	synthea
SELECT T2.REASONDESCRIPTION, T2.DESCRIPTION , strftime('%J', T2.STOP) - strftime('%J', T2.START) AS days , CASE WHEN T1.deathdate IS NULL THEN 'alive' ELSE 'dead' END FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.ENCOUNTER = '23c293ec-dbae-4a22-896e-f12cf3c8bac3'	synthea
SELECT T1.first, T1.last FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Shellfish allergy' AND CAST((strftime('%J', T1.deathdate) - strftime('%J', T1.birthdate)) AS REAL) / 365 < 12	synthea
SELECT strftime('%J', T2.STOP) - strftime('%J', T2.START) AS days FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = ' Amoxicillin 250 MG / Clavulanate 125 MG [Augmentin]' AND T1.first = 'Major' AND T1.last = 'D''Amore'	synthea
SELECT COUNT(DISTINCT T2.DESCRIPTION) FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Major' AND T1.last = 'D''Amore'	synthea
SELECT DISTINCT T2.DESCRIPTION, T2.VALUE, T2.UNITS FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Bella' AND T1.last = 'Rolfson'	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Calcium' AND T2.VALUE < 8.6	synthea
SELECT DISTINCT T2.DESCRIPTION, T2.VALUE, T2.UNITS FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Body Mass Index' GROUP BY T2.VALUE ORDER BY COUNT(T2.VALUE) LIMIT 5	synthea
SELECT COUNT(DISTINCT T2.PATIENT) FROM encounters AS T1 INNER JOIN immunizations AS T2 ON T1.PATIENT = T2.PATIENT WHERE T1.REASONDESCRIPTION = 'Normal pregnancy' AND T1.DATE = T2.DATE	synthea
SELECT T2.DESCRIPTION FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND T1.last = 'Koss' AND strftime('%Y', T2.START) = '2013'	synthea
SELECT DISTINCT T3.DESCRIPTION, T4.DESCRIPTION, T5.DESCRIPTION, T1.first, T1.last FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT INNER JOIN careplans AS T3 ON T1.patient = T3.PATIENT INNER JOIN procedures AS T4 ON T1.patient = T4.PATIENT INNER JOIN medications AS T5 ON T1.patient = T5.PATIENT WHERE T2.ID = '6f2e3935-b203-493e-a9c0-f23e847b9798'	synthea
SELECT COUNT(DISTINCT CASE WHEN T2.gender = 'M' THEN T2.patient END) AS Male , COUNT(DISTINCT CASE WHEN T2.gender = 'F' THEN T2.patient END) AS Female FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Hypertension'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Normal pregnancy' AND T2.gender = 'F' AND T2.marital = 'S'	synthea
SELECT DISTINCT T2.DESCRIPTION, T3.DESCRIPTION FROM encounters AS T1 INNER JOIN procedures AS T2 ON T1.PATIENT = T2.PATIENT INNER JOIN medications AS T3 ON T1.PATIENT = T3.PATIENT WHERE T1.REASONDESCRIPTION = 'Drug overdose'	synthea
SELECT SUM(T1.VALUE) / COUNT(T1.PATIENT) FROM observations AS T1 INNER JOIN ( SELECT DISTINCT PATIENT FROM observations WHERE DESCRIPTION = 'Total Cholesterol' AND VALUE > 200 ) AS T2 ON T1.PATIENT = T2.PATIENT WHERE T1.DESCRIPTION = 'Body Mass Index'	synthea
SELECT SUM(CASE WHEN ROUND((strftime('%J', T2.DATE) - strftime('%J', T1.birthdate)) / 365) BETWEEN 20 AND 30 THEN T2.VALUE ELSE 0 END) / COUNT(CASE WHEN ROUND((strftime('%J', T2.DATE) - strftime('%J', T1.birthdate)) / 365) BETWEEN 20 AND 30 THEN T2.PATIENT END) - SUM(CASE WHEN ROUND((strftime('%J', T2.DATE) - strftime('%J', T1.birthdate)) / 365) BETWEEN 50 AND 60 THEN T2.VALUE ELSE 0 END) / COUNT(CASE WHEN ROUND((strftime('%J', T2.DATE) - strftime('%J', T1.birthdate)) / 365) BETWEEN 50 AND 60 THEN T2.PATIENT END) AS difference FROM patients AS T1 INNER JOIN observations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Glucose'	synthea
SELECT CAST(SUM(CASE WHEN T5.DESCRIPTION = T3.DESCRIPTION THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.patient) FROM ( SELECT T2.DESCRIPTION, T1.patient FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE ROUND((strftime('%J', T2.START) - strftime('%J', T1.birthdate)) / 365) > 60 GROUP BY T2.DESCRIPTION ORDER BY COUNT(T2.DESCRIPTION) DESC LIMIT 1 ) AS T3 INNER JOIN patients AS T4 ON T3.patient = T4.patient INNER JOIN conditions AS T5 ON T4.patient = T5.PATIENT WHERE ROUND((strftime('%J', T5.START) - strftime('%J', T4.birthdate)) / 365) > 60	synthea
SELECT T2.REASONDESCRIPTION FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Walter' AND T1.last = 'Bahringer' AND T2.DATE LIKE '2009-07%'	synthea
SELECT T2.DATE - T1.birthdate AS age FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Stacy' AND T1.last = 'Morar' AND T2.DESCRIPTION = 'Emergency Room Admission' AND T2.REASONDESCRIPTION = 'Drug overdose' ORDER BY T2.DATE LIMIT 1	synthea
SELECT DESCRIPTION FROM medications WHERE REASONDESCRIPTION = 'Child attention deficit disorder' GROUP BY DESCRIPTION ORDER BY COUNT(DESCRIPTION) DESC LIMIT 1	synthea
SELECT T2.first, T2.last FROM procedures AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Transplant of lung (procedure)'	synthea
SELECT CAST(COUNT(PATIENT) AS REAL) / COUNT(DISTINCT strftime('%Y', DATE)) FROM procedures WHERE DESCRIPTION = 'Combined chemotherapy and radiation therapy (procedure)'	synthea
SELECT strftime('%J', T2.STOP) - strftime('%J', T2.START) AS timeFrame , T2.DESCRIPTION FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Jacquelyn' AND T1.last = 'Shanahan' ORDER BY T2.START DESC LIMIT 1	synthea
SELECT T2.START, T2.STOP, T2.DESCRIPTION FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Isadora' AND T1.last = 'Moen'	synthea
SELECT T2.DATE - T1.birthdate AS age FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Laronda' AND T1.last = 'Bernier' ORDER BY T2.DATE DESC LIMIT 1	synthea
SELECT T2.DESCRIPTION FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Joye' AND T1.last = 'Homenick' AND strftime('%Y', T2.START) = '2017'	synthea
SELECT T2.DATE FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Influenza  seasonal  injectable  preservative free' AND T1.first = 'Joye' AND T1.last = 'Homenick' ORDER BY T2.DATE DESC LIMIT 1	synthea
SELECT strftime('%J', T2.STOP) - strftime('%J', T2.START) AS days FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Elly' AND last = 'Koss' AND T2.DESCRIPTION = 'Acetaminophen 160 MG'	synthea
SELECT COUNT(DISTINCT T2.PATIENT), T2.DESCRIPTION FROM encounters AS T1 INNER JOIN careplans AS T2 ON T1.PATIENT = T2.PATIENT WHERE T2.REASONDESCRIPTION = 'Second degree burn'	synthea
SELECT CAST(SUM(CASE WHEN T2.gender = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.PATIENT) FROM encounters AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE strftime('%Y', T1.DATE) = '2010' AND T1.REASONDESCRIPTION = 'Contact dermatitis'	synthea
SELECT COUNT(T1.patient) , CAST(SUM(CASE WHEN T2.DESCRIPTION = 'Prenatal visit' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.patient) FROM patients AS T1 INNER JOIN encounters AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Lorri' AND T1.last = 'Simonis' AND strftime('%Y', T2.DATE) BETWEEN '2010' AND '2017'	synthea
SELECT T1.DESCRIPTION FROM medications AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.first = 'Joye' AND T2.last = 'Homenick'	synthea
SELECT DISTINCT T1.START FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.maiden = 'Adams'	synthea
SELECT T2.first, T2.last FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.gender = 'M' ORDER BY T1.START LIMIT 1	synthea
SELECT CAST(SUM(CASE WHEN T2.race = 'hispanic' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.PATIENT) FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE strftime('%Y', T1.stop) = '2011'	synthea
SELECT DISTINCT T1.REASONDESCRIPTION FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.first = 'Angelo' AND T2.last = 'Buckridge'	synthea
SELECT DISTINCT T1.DESCRIPTION FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.ethnicity = 'american'	synthea
SELECT DISTINCT T1.ENCOUNTER FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.birthplace = 'Pembroke MA US'	synthea
SELECT DISTINCT T1.START FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.deathdate IS NULL	synthea
SELECT COUNT(DISTINCT T1.PATIENT) FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.race = 'white' AND T1.REASONCODE = '10509002'	synthea
SELECT DISTINCT T2.first, T2.last FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Diabetic diet'	synthea
SELECT DISTINCT T1.STOP FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.deathdate IS NOT NULL AND T1.STOP IS NOT NULL	synthea
SELECT COUNT(DISTINCT T2.patient) FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.ethnicity = 'italian' AND T1.CODE = '304510005'	synthea
SELECT CAST(SUM(CASE WHEN T2.gender = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.PATIENT) AS percentage FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE strftime('%Y', T1.START) = '2010'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.race = 'black' AND strftime('%Y', T1.STOP) = '2017'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN conditions AS T2 WHERE T2.DESCRIPTION = 'Prediabetes' AND T1.gender = 'M'	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN allergies AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Allergy to nut'	synthea
SELECT T2.DESCRIPTION FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Wilmer' AND T1.last = 'Koepp'	synthea
SELECT SUM(CASE WHEN T1.gender = 'F' THEN 1 ELSE 0 END), SUM(CASE WHEN T1.gender = 'M' THEN 1 ELSE 0 END) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Viral sinusitis (disorder)'	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Penicillin V Potassium 250 MG' AND strftime('%Y', T2.START) >= '1948'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.patient WHERE strftime('%Y', T1.birthdate) = '1935' AND T1.race = 'white' AND T2.DESCRIPTION = 'Stroke'	synthea
SELECT DISTINCT T2.DESCRIPTION FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT INNER JOIN immunizations AS T3 ON T1.patient = T3.PATIENT WHERE T3.DESCRIPTION = 'IPV'	synthea
SELECT T1.patient FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT INNER JOIN all_prevalences AS T3 ON T3.ITEM = T2.DESCRIPTION ORDER BY T3.OCCURRENCES DESC LIMIT 1	synthea
SELECT DISTINCT T1.first, T1.last FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.patient WHERE T2.DESCRIPTION = 'Cystitis'	synthea
SELECT COUNT(DISTINCT T1.patient) FROM patients AS T1 INNER JOIN immunizations AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'HPV  quadrivalent' AND T1.gender = 'M'	synthea
SELECT DISTINCT T2.start FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Walter' AND T1.last = 'Bahringer'	synthea
SELECT DISTINCT T2.DESCRIPTION FROM patients AS T1 INNER JOIN careplans AS T2 ON T1.patient = T2.PATIENT WHERE T1.first = 'Major' AND T1.last = 'D''Amore'	synthea
SELECT CAST(SUM(CASE WHEN T1.gender = 'M' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.patient) FROM patients AS T1 INNER JOIN conditions AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Viral sinusitis (disorder)'	synthea
SELECT CAST(SUM(CASE WHEN T1.gender = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.patient) FROM patients AS T1 INNER JOIN medications AS T2 ON T1.patient = T2.PATIENT WHERE T2.DESCRIPTION = 'Penicillin V Potassium 250 MG'	synthea
SELECT AVG(T1.VALUE) FROM observations AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.race = 'white' AND T1.DESCRIPTION = 'Body Height'	synthea
SELECT T1.DESCRIPTION FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.address = '179 Sydni Roads Taunton MA 02780 US'	synthea
SELECT T1.DESCRIPTION FROM allergies AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.first = 'Dirk' AND T2.last = 'Langosh' AND T2.ethnicity = 'dominican'	synthea
SELECT COUNT(DISTINCT T2.patient) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient INNER JOIN allergies AS T3 ON T2.patient = T3.PATIENT WHERE T1.DESCRIPTION = 'Asthma' AND T3.DESCRIPTION = 'Allergy to peanuts'	synthea
SELECT T2.first, T2.last FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Drug overdose' AND ROUND((strftime('%J', T2.deathdate) - strftime('%J', T2.birthdate)) / 365) = 44	synthea
SELECT T2.ssn FROM observations AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Systolic Blood Pressure' ORDER BY T1.VALUE DESC LIMIT 1	synthea
SELECT T4.DESCRIPTION FROM all_prevalences AS T1 INNER JOIN conditions AS T2 ON T2.DESCRIPTION = T1.ITEM INNER JOIN encounters AS T3 ON T2.ENCOUNTER = T3.ID INNER JOIN careplans AS T4 ON T4.ENCOUNTER = T3.ID ORDER BY T1."PREVALENCE PERCENTAGE" DESC LIMIT 1	synthea
SELECT DISTINCT T1.DESCRIPTION FROM careplans AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T2.ssn = '999-15-3685'	synthea
SELECT SUM(CASE WHEN T2.deathdate IS NULL THEN ROUND((strftime('%J', date('now')) - strftime('%J', T2.birthdate)) / 365) ELSE ROUND((strftime('%J', T2.deathdate) - strftime('%J', T2.birthdate)) / 365) END) / COUNT(T2.patient) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Hypertension' AND T2.gender = 'M'	synthea
SELECT DISTINCT T2.first, T2.last FROM medications AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.REASONDESCRIPTION = 'Streptococcal sore throat (disorder)' LIMIT 5	synthea
SELECT T2.first, T2.last FROM observations AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Body Weight' AND T1.UNITS = 'kg' AND T1.VALUE = 61.97	synthea
SELECT DISTINCT T2.birthdate FROM medications AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Penicillin V Potassium 250 MG' AND T2.gender = 'M' LIMIT 5	synthea
SELECT DISTINCT T2.first, T2.last FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient INNER JOIN all_prevalences AS T3 ON T1.DESCRIPTION = T3.ITEM WHERE T2.ethnicity = 'irish' AND 100 * CAST(T3.OCCURRENCES AS REAL) / ( SELECT AVG(OCCURRENCES) FROM all_prevalences ) > 96	synthea
SELECT SUM(CASE WHEN T2.marital = 'M' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.marital = 'S' THEN 1 ELSE 0 END) FROM conditions AS T1 INNER JOIN patients AS T2 ON T1.PATIENT = T2.patient WHERE T1.DESCRIPTION = 'Diabetes'	synthea
SELECT country, COUNT(customerNumber) FROM customers GROUP BY country	car_retails
SELECT DISTINCT T1.productVendor, T1.MSRP - T1.buyPrice FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode GROUP BY T1.productVendor, T1.MSRP, T1.buyPrice ORDER BY COUNT(T2.quantityOrdered) DESC LIMIT 1	car_retails
SELECT DISTINCT T3.lastName, T3.firstName FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber INNER JOIN employees AS T3 ON T2.salesRepEmployeeNumber = T3.employeeNumber WHERE STRFTIME('%Y', T1.paymentDate) = '2004' ORDER BY T1.amount DESC LIMIT 1	car_retails
SELECT T3.priceEach * T3.quantityOrdered FROM customers AS T1 INNER JOIN orders AS T2 ON T1.customerNumber = T2.customerNumber INNER JOIN orderdetails AS T3 ON T2.orderNumber = T3.orderNumber WHERE T1.customerName = 'Rovelli Gifts' AND T2.status = 'Shipped' AND STRFTIME('%Y', T2.shippedDate) = '2003'	car_retails
SELECT COUNT(employeeNumber) FROM employees WHERE officeCode = ( SELECT officeCode FROM offices WHERE city = 'Sydney' )	car_retails
SELECT T1.employeeNumber FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T1.reportsTo = 1143 AND T2.city = 'NYC'	car_retails
SELECT CAST(SUM(T1.amount) AS REAL) / 3, MAX(T1.amount) , MIN(T1.amount) FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.paymentDate BETWEEN '2003-01-01' AND '2005-12-31'	car_retails
SELECT DISTINCT T2.country, T2.addressLine1, T2.addressLine2 FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber ORDER BY T1.amount DESC LIMIT 5	car_retails
SELECT COUNT(T1.checkNumber) FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE customerName = 'Euro+ Shopping Channel' AND STRFTIME('%Y', T1.paymentDate) = '2004'	car_retails
SELECT T1.productName FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode WHERE T1.productScale = '1:18' AND T1.productLine = 'Classic Cars' GROUP BY T1.productName ORDER BY SUM(T2.quantityOrdered) DESC LIMIT 1	car_retails
SELECT ( SELECT COUNT(customerNumber) FROM customers WHERE creditLimit <= 100000 AND customerNumber IN ( SELECT customerNumber FROM payments WHERE STRFTIME('%Y', paymentDate) = '2004' ) ), T1.customerName FROM customers AS T1 INNER JOIN payments AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.creditLimit <= 100000 AND STRFTIME('%Y', T2.paymentDate) = '2004' GROUP BY T1.customerNumber, T1.customerName ORDER BY SUM(T2.amount) DESC LIMIT 1	car_retails
SELECT T2.customerName, T2.contactFirstName, T2.contactLastName, SUM(T3.amount) FROM employees AS T1 INNER JOIN customers AS T2 ON T2.salesRepEmployeeNumber = T1.employeeNumber INNER JOIN payments AS T3 ON T2.customerNumber = T3.customerNumber INNER JOIN offices AS T4 ON T1.officeCode = T4.officeCode WHERE T4.city = 'Tokyo' AND T1.reportsTo = 1056 GROUP BY T2.customerName, T2.contactFirstName, T2.contactLastName ORDER BY amount DESC LIMIT 1	car_retails
SELECT T2.productName, SUM(T1.quantityOrdered * T1.priceEach) FROM orderdetails AS T1 INNER JOIN ( SELECT productCode, productName FROM products ORDER BY MSRP - buyPrice DESC LIMIT 1 ) AS T2 ON T1.productCode = T2.productCode UNION SELECT T2.productName, SUM(quantityOrdered * priceEach) FROM orderdetails AS T1 INNER JOIN ( SELECT productCode, productName FROM products ORDER BY MSRP - buyPrice ASC LIMIT 1 ) AS T2 ON T1.productCode = T2.productCode	car_retails
SELECT COUNT(DISTINCT T1.orderNumber) FROM orderdetails AS T1 INNER JOIN orders AS T2 ON T1.orderNumber = T2.orderNumber WHERE T1.quantityOrdered * T1.priceEach > 4000 AND T2.status = 'Cancelled'	car_retails
SELECT COUNT(DISTINCT T1.orderNumber) FROM orderdetails AS T1 INNER JOIN orders AS T2 ON T1.orderNumber = T2.orderNumber WHERE T1.quantityOrdered < 30 AND STRFTIME('%Y', T2.orderDate) = '2003'	car_retails
SELECT SUM(T1.quantityOrdered * T1.priceEach) FROM orderdetails AS T1 INNER JOIN orders AS T2 ON T1.orderNumber = T2.orderNumber WHERE T2.status = 'Cancelled'	car_retails
SELECT SUM(T1.quantityOrdered * T1.priceEach) FROM orderdetails AS T1 INNER JOIN products AS T2 ON T1.productCode = T2.productCode WHERE T2.productLine = 'Motorcycles'	car_retails
SELECT COUNT(T1.productCode) FROM orderdetails AS T1 INNER JOIN products AS T2 ON T1.productCode = T2.productCode WHERE T2.productLine = 'Planes'	car_retails
SELECT COUNT(T1.productCode) FROM orderdetails AS T1 INNER JOIN products AS T2 ON T1.productCode = T2.productCode WHERE T2.MSRP - T2.buyPrice > 100	car_retails
SELECT SUM(T2.quantityOrdered * T2.priceEach) / COUNT(T3.orderNumber) FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode INNER JOIN orders AS T3 ON T2.orderNumber = T3.orderNumber WHERE T1.productVendor = 'Exoto Designs' AND STRFTIME('%Y', T3.orderDate) = '2005'	car_retails
SELECT COUNT(officeCode) FROM employees WHERE jobTitle = 'Sales Rep' AND officeCode = 1	car_retails
SELECT DISTINCT T2.customerName FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.amount > 50000	car_retails
SELECT SUM(T1.amount) FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE T2.country = 'USA'	car_retails
SELECT SUM(amount) FROM payments WHERE STRFTIME('%Y', paymentDate) = '2003' AND customerNumber IN ( SELECT customerNumber FROM customers WHERE creditLimit = 0 )	car_retails
SELECT T2.customerName, T2.phone FROM orders AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.status = 'Cancelled'	car_retails
SELECT COUNT(T2.country) FROM orders AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.status = 'Shipped' AND T2.country = 'France' GROUP BY T2.customerNumber HAVING COUNT(T1.status) = 2	car_retails
SELECT SUM(T3.quantityOrdered * T3.priceEach) / COUNT(T2.orderNumber) FROM customers AS T1 INNER JOIN orders AS T2 ON T1.customerNumber = T2.customerNumber INNER JOIN orderdetails AS T3 ON T2.orderNumber = T3.orderNumber WHERE T2.status = 'Shipped' AND T1.country = 'Germany'	car_retails
SELECT T1.firstName, T1.lastName FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T2.city = 'Tokyo'	car_retails
SELECT T1.firstName, T1.lastName, T1.email FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T2.city = 'Tokyo' AND T1.jobTitle = 'Sales Rep'	car_retails
SELECT T1.email FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T1.reportsTo = 1002 AND T2.city = 'San Francisco'	car_retails
SELECT T1.email, T1.employeeNumber FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T2.state = 'MA' AND T2.country = 'USA'	car_retails
SELECT T1.email FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T1.jobTitle LIKE '%Sales Manager%' AND T2.city = 'Sydney'	car_retails
SELECT T2.email, T3.country FROM customers AS T1 INNER JOIN employees AS T2 ON T1.salesRepEmployeeNumber = T2.employeeNumber INNER JOIN offices AS T3 ON T2.officeCode = T3.officeCode WHERE T3.country = 'Australia' AND T1.creditLimit < 200000 AND T2.jobTitle = 'Sales Rep'	car_retails
SELECT DISTINCT T2.email FROM customers AS T1 INNER JOIN employees AS T2 ON T1.salesRepEmployeeNumber = T2.employeeNumber WHERE T2.jobTitle = 'Sales Rep' AND T1.country = 'UK' ORDER BY T1.creditLimit LIMIT 10	car_retails
SELECT COUNT(creditLimit) FROM customers WHERE creditLimit < 220000 AND country = 'Australia'	car_retails
SELECT customerNumber FROM payments ORDER BY amount DESC LIMIT 3	car_retails
SELECT T1.email, T1.employeeNumber FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T2.country = 'USA' AND T2.state = 'CA' GROUP BY T1.email, T1.officeCode	car_retails
SELECT T1.firstName, T1.lastName FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T2.city = 'Boston'	car_retails
SELECT T2.email FROM customers AS T1 INNER JOIN employees AS T2 ON T1.salesRepEmployeeNumber = T2.employeeNumber WHERE T2.jobTitle = 'Sales Rep' AND T1.country = 'UK' GROUP BY T1.customerName, T2.email ORDER BY SUM(T1.creditLimit) DESC LIMIT 3	car_retails
SELECT COUNT(creditLimit) FROM customers WHERE creditLimit < 220000 AND country = 'Norway'	car_retails
SELECT T1.firstName, T1.lastName, T1.email FROM employees AS T1 INNER JOIN offices AS T2 ON T1.officeCode = T2.officeCode WHERE T2.city = 'Paris'	car_retails
SELECT productCode, quantityInStock FROM products WHERE productLine = 'Motorcycles' ORDER BY quantityInStock DESC LIMIT 5	car_retails
SELECT COUNT(customerNumber) FROM customers WHERE creditLimit = 0 AND country = 'Germany'	car_retails
SELECT COUNT(customernumber) FROM ( SELECT customernumber FROM payments WHERE STRFTIME('%Y', paymentDate) >= '2003' AND STRFTIME('%Y', paymentDate) <= '2004' GROUP BY customernumber HAVING COUNT(customernumber) > 3 ) T	car_retails
SELECT SUM(T1.priceEach - T2.buyPrice) / COUNT(*) FROM orderdetails AS T1 INNER JOIN products AS T2 ON T1.productCode = T2.productCode WHERE T2.productName = '1937 Lincoln Berline'	car_retails
SELECT T1.productName FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode INNER JOIN orders AS T3 ON T2.orderNumber = T3.orderNumber INNER JOIN customers AS T4 ON T3.customerNumber = T4.customerNumber WHERE T1.productLine = 'Motorcycles' AND T1.productScale = '1:10' AND T4.country = 'USA' GROUP BY T1.productName ORDER BY SUM(T2.quantityOrdered) DESC LIMIT 1	car_retails
SELECT T1.checkNumber FROM payments AS T1 INNER JOIN customers AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.paymentDate >= '2003-08-01' AND T1.paymentDate <= '2004-08-30' AND T2.customerName = 'Mini Gifts Distributors Ltd.'	car_retails
SELECT MAX(quantityOrdered * priceEach) - AVG(priceEach) FROM orderdetails WHERE productCode IN ( SELECT productCode FROM products WHERE productLine = 'Planes' )	car_retails
SELECT SUM(T2.priceEach * T2.quantityOrdered) FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode INNER JOIN orders AS T3 ON T2.orderNumber = T3.orderNumber WHERE T3.status = 'Shipped' AND T3.orderDate BETWEEN '2003-01-01' AND '2004-12-31'	car_retails
SELECT T1.firstName, T1.lastName, T1.reportsTo FROM employees AS T1 INNER JOIN customers AS T2 ON T1.employeeNumber = T2.salesRepEmployeeNumber INNER JOIN payments AS T3 ON T2.customerNumber = T3.customerNumber ORDER BY T3.amount DESC LIMIT 1	car_retails
SELECT T2.productName, T1.quantityOrdered * T1.priceEach FROM orderdetails AS T1 INNER JOIN products AS T2 ON T1.productCode = T2.productCode INNER JOIN orders AS T3 ON T1.orderNumber = T3.orderNumber INNER JOIN customers AS T4 ON T3.customerNumber = T4.customerNumber WHERE T4.city = 'Boston' AND T4.salesRepEmployeeNumber IN ( SELECT employeeNumber FROM employees WHERE jobTitle = 'Sales Rep' ) ORDER BY T1.quantityOrdered DESC LIMIT 1	car_retails
SELECT SUM(T2.priceEach - T1.buyPrice) FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode INNER JOIN orders AS T3 ON T2.orderNumber = T3.orderNumber INNER JOIN customers AS T4 ON T3.customerNumber = T4.customerNumber WHERE T3.orderDate > '2003-01-05' AND T3.orderDate < '2005-05-10'	car_retails
SELECT T3.addressLine1, T3.addressLine2, T3.phone FROM orderdetails AS T1 INNER JOIN orders AS T2 ON T1.orderNumber = T2.orderNumber INNER JOIN customers AS T3 ON T2.customerNumber = T3.customerNumber INNER JOIN employees AS T4 ON T3.salesRepEmployeeNumber = T4.employeeNumber INNER JOIN offices AS T5 ON T4.officeCode = T5.officeCode WHERE STRFTIME('%Y', T2.orderDate) = '2005' AND T4.jobTitle = 'Sales Rep' ORDER BY T1.quantityOrdered DESC LIMIT 1	car_retails
SELECT phone FROM customers WHERE contactLastName LIKE 'M%' AND country != 'Germany'	car_retails
SELECT AVG(amount) FROM payments WHERE paymentDate BETWEEN '2004-01-01' AND '2004-06-30'	car_retails
SELECT CAST(SUM(CASE WHEN customerNumber = 186 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(orderNumber) FROM orders WHERE status = 'Shipped' AND shippedDate BETWEEN '2005-01-01' AND '2005-12-31'	car_retails
SELECT COUNT(T1.customerNumber) FROM customers AS T1 INNER JOIN orders AS T2 ON T1.customerNumber = T2.customerNumber WHERE T2.status = 'Cancelled' AND T1.creditLimit > 115000	car_retails
SELECT T3.paymentDate FROM employees AS T1 INNER JOIN customers AS T2 ON T1.employeeNumber = T2.salesRepEmployeeNumber INNER JOIN payments AS T3 ON T2.customerNumber = T3.customerNumber WHERE T1.firstName = 'Barry' AND T1.lastName = 'Jones' AND T1.jobTitle = 'Sales Rep' ORDER BY T2.creditLimit ASC LIMIT 1	car_retails
SELECT T1.reportsTo FROM employees AS T1 INNER JOIN customers AS T2 ON T1.employeeNumber = T2.salesRepEmployeeNumber WHERE T2.country = 'France'	car_retails
SELECT T1.addressLine1, T1.addressLine2 FROM customers AS T1 INNER JOIN orders AS T2 ON T1.customerNumber = T2.customerNumber WHERE T2.shippedDate = '2005-04-04' AND T2.status = 'Shipped'	car_retails
SELECT T2.addressLine1, T2.addressLine2 FROM employees AS T1 INNER JOIN customers AS T2 ON T1.employeeNumber = T2.salesRepEmployeeNumber INNER JOIN offices AS T3 ON T1.officeCode = T3.officeCode WHERE T2.city = 'NYC' AND T1.jobTitle = 'Sales Rep'	car_retails
SELECT T1.addressLine1, T1.addressLine2 FROM customers AS T1 INNER JOIN employees AS T2 ON T1.salesRepEmployeeNumber = T2.employeeNumber WHERE T2.jobTitle = 'Sales Rep'	car_retails
SELECT SUM(T2.MSRP - T2.buyPrice) FROM productlines AS T1 INNER JOIN products AS T2 ON T1.productLine = T2.productLine WHERE T2.productVendor = 'Carousel DieCast Legends' AND T1.textDescription LIKE '%perfect holiday or anniversary gift for executives%'	car_retails
SELECT T1.customerNumber FROM customers AS T1 INNER JOIN payments AS T2 ON T1.customerNumber = T2.customerNumber WHERE T1.city = 'Boston' GROUP BY T1.customerNumber ORDER BY SUM(T2.amount) / COUNT(T2.paymentDate) DESC LIMIT 1	car_retails
SELECT SUM(T2.quantityOrdered) , SUM(T2.quantityOrdered * T2.priceEach) / SUM(T2.quantityOrdered) FROM products AS T1 INNER JOIN orderdetails AS T2 ON T1.productCode = T2.productCode WHERE T1.productName = '18th Century Vintage Horse Carriage'	car_retails
SELECT COUNT(t.productCode) FROM orderdetails t WHERE t.orderNumber = '10252'	car_retails
SELECT T2.firstName, T2.lastName FROM customers AS T1 INNER JOIN employees AS T2 ON T1.salesRepEmployeeNumber = T2.employeeNumber WHERE T1.addressLine1 = '25 Maiden Lane' AND T1.addressLine2 = 'Floor No. 4'	car_retails
SELECT T1.addressLine1, T1.addressLine2 FROM offices AS T1 INNER JOIN employees AS T2 ON T1.officeCode = T2.officeCode WHERE T2.firstName = 'Foon Yue' AND T2.lastName = 'Tseng'	car_retails
SELECT T2.orderDate FROM orderdetails AS T1 INNER JOIN orders AS T2 ON T1.orderNumber = T2.orderNumber WHERE STRFTIME('%Y-%m-%d', T2.orderDate) = '2005-04-08' OR STRFTIME('%Y-%m-%d', T2.orderDate) = '2005-04-10' ORDER BY T1.quantityOrdered * T1.priceEach DESC LIMIT 1	car_retails
SELECT SUM(t2.quantityOrdered) FROM orderdetails AS t2 INNER JOIN ( SELECT t1.productCode FROM products AS t1 ORDER BY t1.MSRP - t1.buyPrice DESC LIMIT 1 ) AS t3 ON t2.productCode = t3.productCode	car_retails
SELECT t1.amount FROM payments AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t2.customerName = 'Petit Auto' AND t1.paymentDate = '2004-08-09'	car_retails
SELECT t2.contactFirstName, t2.contactLastName FROM payments AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t1.checkNumber = 'NR157385'	car_retails
SELECT t2.contactFirstName, t2.contactLastName FROM orders AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t1.orderNumber = '10160'	car_retails
SELECT t2.addressLine1, t2.addressLine2 FROM orders AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t1.orderNumber = '10383'	car_retails
SELECT t1.textDescription FROM productlines AS t1 INNER JOIN products AS t2 ON t1.productLine = t2.productLine WHERE t2.productCode = 'S18_2949'	car_retails
SELECT t2.email FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t1.customerName = 'Dragon Souveniers, Ltd.'	car_retails
SELECT COUNT(t1.customerNumber) FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t1.country = 'France' AND t2.firstName = 'Gerard' AND t2.lastName = 'Hernandez'	car_retails
SELECT t3.productName FROM orderdetails AS t1 INNER JOIN orders AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN products AS t3 ON t1.productCode = t3.productCode WHERE t2.customerNumber = '114' ORDER BY t2.orderDate DESC LIMIT 1	car_retails
SELECT (t1.MSRP - t2.priceEach) / t1.MSRP FROM products AS t1 INNER JOIN orderdetails AS t2 ON t1.productCode = t2.productCode WHERE t1.productCode = 'S18_3482' AND t2.orderNumber = '10108'	car_retails
SELECT t2.firstName, t2.lastName FROM employees AS t1 INNER JOIN employees AS t2 ON t2.employeeNumber = t1.reportsTo WHERE t1.firstName = 'Steve' AND t1.lastName = 'Patterson'	car_retails
SELECT t.email FROM employees t WHERE t.jobTitle = 'President'	car_retails
SELECT t2.firstName, t2.lastName FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t1.customerName = 'Muscle Machine Inc'	car_retails
SELECT t2.email FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t1.customerName = 'Muscle Machine Inc'	car_retails
SELECT t1.customerName FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t2.firstName = 'Steve' AND t2.lastName = 'Patterson'	car_retails
SELECT COUNT(t1.customerNumber) FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t2.firstName = 'William' AND t2.lastName = 'Patterson'	car_retails
SELECT t1.phone FROM customers AS t1 INNER JOIN employees AS t2 ON t1.salesRepEmployeeNumber = t2.employeeNumber WHERE t2.firstName = 'Leslie' AND t2.lastName = 'Jennings' ORDER BY t1.creditLimit DESC LIMIT 3	car_retails
SELECT COUNT(t1.employeeNumber) FROM employees AS t1 INNER JOIN offices AS t2 ON t1.officeCode = t2.officeCode WHERE t2.country = 'USA' AND t1.jobTitle = 'Sales Rep'	car_retails
SELECT t2.addressLine1, t2.addressLine2 FROM employees AS t1 INNER JOIN offices AS t2 ON t1.officeCode = t2.officeCode WHERE t1.jobTitle = 'President'	car_retails
SELECT t2.postalCode FROM employees AS t1 INNER JOIN offices AS t2 ON t1.officeCode = t2.officeCode WHERE t1.jobTitle = 'VP Sales'	car_retails
SELECT SUM(t1.priceEach * t1.quantityOrdered) FROM orderdetails AS t1 INNER JOIN orders AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN customers AS t3 ON t2.customerNumber = t3.customerNumber WHERE t3.customerName = 'Cruz & Sons Co.' AND t2.orderDate = '2003-03-03'	car_retails
SELECT t4.productName FROM orderdetails AS t1 INNER JOIN orders AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN customers AS t3 ON t2.customerNumber = t3.customerNumber INNER JOIN products AS t4 ON t1.productCode = t4.productCode WHERE t3.customerName = 'Cruz & Sons Co.' AND t2.orderDate = '2003-03-03'	car_retails
SELECT t4.productName FROM orderdetails AS t1 INNER JOIN orders AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN customers AS t3 ON t2.customerNumber = t3.customerNumber INNER JOIN products AS t4 ON t1.productCode = t4.productCode WHERE t3.customerName = 'Cruz & Sons Co.' ORDER BY t1.priceEach * t1.quantityOrdered DESC LIMIT 1	car_retails
SELECT t1.shippedDate FROM orders AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t2.customerName = 'Cruz & Sons Co.' AND t1.orderDate = '2003-03-03'	car_retails
SELECT COUNT(T2.customerNumber) FROM orderdetails AS T1 INNER JOIN orders AS T2 ON T1.orderNumber = T2.orderNumber WHERE T1.productCode IN ( SELECT productCode FROM products WHERE productName = '1957 Chevy Pickup' )	car_retails
SELECT t.productName, t.MSRP - t.buyPrice FROM products AS t WHERE t.productLine = 'Classic Cars' ORDER BY t.MSRP - t.buyPrice DESC LIMIT 1	car_retails
SELECT t2.customerName FROM orders AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t1.status = 'In Process'	car_retails
SELECT COUNT(CASE WHEN JULIANDAY(t1.shippeddate) - JULIANDAY(t1.requireddate) > 3 THEN T1.customerNumber ELSE NULL END) FROM orders AS T1 INNER JOIN orderdetails AS T2 ON T1.orderNumber = T2.orderNumber WHERE T1.status = 'Shipped'	car_retails
SELECT t2.customerName FROM payments AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE STRFTIME('%Y', t1.paymentDate) = '2005' GROUP BY t2.customerNumber, t2.customerName ORDER BY SUM(t1.amount) DESC LIMIT 1	car_retails
SELECT productName, MSRP - buyPrice FROM products WHERE productCode = ( SELECT productCode FROM orderdetails ORDER BY quantityOrdered DESC LIMIT 1 )	car_retails
SELECT T2.firstName, T2.lastName FROM offices AS T1 INNER JOIN employees AS T2 ON T1.officeCode = T2.officeCode WHERE T2.employeeNumber = ( SELECT MAX(employeeNumber) FROM employees )	car_retails
SELECT t3.firstName, t3.lastName FROM orders AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber INNER JOIN employees AS t3 ON t2.salesRepEmployeeNumber = t3.employeeNumber WHERE t1.status = 'Disputed'	car_retails
SELECT CAST(COUNT(CASE WHEN t1.city = 'Paris' THEN t2.employeeNumber ELSE NULL END) AS REAL) * 100 / COUNT(t2.employeeNumber) FROM offices AS t1 INNER JOIN employees AS t2 ON t1.officeCode = t2.officeCode	car_retails
SELECT t2.firstName, t2.lastName FROM offices AS t1 INNER JOIN employees AS t2 ON t1.officeCode = t2.officeCode WHERE t2.jobTitle = 'Sale Manager (EMEA)'	car_retails
SELECT t2.firstName, t2.lastName, t2.reportsTo FROM offices AS t1 INNER JOIN employees AS t2 ON t1.officeCode = t2.officeCode WHERE t1.country = 'Japan'	car_retails
SELECT t4.customerName FROM products AS t1 INNER JOIN orderdetails AS t2 ON t1.productCode = t2.productCode INNER JOIN orders AS t3 ON t2.orderNumber = t3.orderNumber INNER JOIN customers AS t4 ON t3.customerNumber = t4.customerNumber WHERE t1.productName = '1939 Chevrolet Deluxe Coupe' ORDER BY t2.priceEach DESC LIMIT 1	car_retails
SELECT SUM(CASE WHEN t1.customerName = 'Atelier graphique' THEN t2.amount ELSE 0 END) * 100 / SUM(t2.amount) FROM customers AS t1 INNER JOIN payments AS t2 ON t1.customerNumber = t2.customerNumber WHERE STRFTIME('%Y', t2.paymentDate) = '2004'	car_retails
SELECT SUM((t1.priceEach - t2.buyPrice) * t1.quantityOrdered) FROM orderdetails AS t1 INNER JOIN products AS t2 ON t1.productCode = t2.productCode WHERE t1.orderNumber = '10100'	car_retails
SELECT SUM(t.amount) FROM payments t WHERE t.customerNumber = '103'	car_retails
SELECT SUM(t.priceEach * t.quantityOrdered) FROM orderdetails t WHERE t.orderNumber = '10100'	car_retails
SELECT t1.productName FROM products AS t1 INNER JOIN orderdetails AS t2 ON t1.productCode = t2.productCode ORDER BY t2.priceEach DESC LIMIT 3	car_retails
SELECT t2.contactFirstName, t2.contactLastName FROM employees AS t1 INNER JOIN customers AS t2 ON t1.employeeNumber = t2.salesRepEmployeeNumber WHERE t1.employeeNumber = '1370' ORDER BY t2.creditLimit DESC LIMIT 1	car_retails
SELECT SUM(t2.quantityOrdered) FROM products AS t1 INNER JOIN orderdetails AS t2 ON t1.productCode = t2.productCode WHERE t1.productName = '2003 Harley-Davidson Eagle Drag Bike'	car_retails
SELECT t1.shippedDate FROM orders AS t1 INNER JOIN orderdetails AS t2 ON t1.orderNumber = t2.orderNumber ORDER BY t2.priceEach DESC LIMIT 1	car_retails
SELECT SUM(t2.quantityOrdered) FROM orders AS t1 INNER JOIN orderdetails AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN products AS t3 ON t2.productCode = t3.productCode WHERE t3.productLine = 'motorcycles' AND STRFTIME('%Y', t1.orderDate) = '2004'	car_retails
SELECT t1.orderNumber FROM orders AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t2.creditLimit = 45300	car_retails
SELECT t3.customerName, (t1.priceEach - t4.buyPrice) * t1.quantityOrdered FROM orderdetails AS t1 INNER JOIN orders AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN customers AS t3 ON t2.customerNumber = t3.customerNumber INNER JOIN products AS t4 ON t1.productCode = t4.productCode GROUP BY t3.customerName, t1.priceEach, t4.buyPrice, t1.quantityOrdered ORDER BY (t1.priceEach - t4.buyPrice) * t1.quantityOrdered DESC LIMIT 1	car_retails
SELECT STRFTIME('%Y', t1.paymentDate), COUNT(t1.customerNumber) FROM payments AS t1 WHERE t1.amount < 10000 GROUP BY STRFTIME('%Y', t1.paymentDate)	car_retails
SELECT t3.productName, SUM(t2.quantityOrdered) FROM orders AS t1 INNER JOIN orderdetails AS t2 ON t1.orderNumber = t2.orderNumber INNER JOIN products AS t3 ON t2.productCode = t3.productCode WHERE STRFTIME('%Y', t1.orderDate) = '2003' GROUP BY t3.productName ORDER BY SUM(t2.quantityOrdered) DESC LIMIT 3	car_retails
SELECT t5.firstName, t5.lastName, SUM(t2.quantityOrdered) FROM products AS t1 INNER JOIN orderdetails AS t2 ON t1.productCode = t2.productCode INNER JOIN orders AS t3 ON t2.orderNumber = t3.orderNumber INNER JOIN customers AS t4 ON t3.customerNumber = t4.customerNumber INNER JOIN employees AS t5 ON t4.salesRepEmployeeNumber = t5.employeeNumber WHERE t1.productName = '1969 Harley Davidson Ultimate Chopper' GROUP BY t5.lastName, t5.firstName	car_retails
SELECT t1.lastName, t1.firstName FROM employees AS t1 INNER JOIN offices AS t2 ON t1.officeCode = t2.officeCode WHERE t2.city = 'NYC' AND t1.jobTitle = 'Sales Rep'	car_retails
SELECT t2.customerName, t2.country FROM payments AS t1 INNER JOIN customers AS t2 ON t1.customerNumber = t2.customerNumber WHERE t1.checkNumber = 'GG31455'	car_retails
SELECT SUM(t1.orderNumber) FROM orderdetails AS t1 INNER JOIN products AS t2 ON t1.productCode = t2.productCode WHERE t2.productName = '2001 Ferrari Enzo'	car_retails
SELECT t2.productName FROM orderdetails AS t1 INNER JOIN products AS t2 ON t1.productCode = t2.productCode GROUP BY t2.productName ORDER BY SUM(t1.quantityOrdered) ASC LIMIT 5	car_retails
SELECT t1.customerName FROM customers AS t1 INNER JOIN orders AS t2 ON t1.customerNumber = t2.customerNumber WHERE t2.status = 'Disputed'	car_retails
SELECT COUNT(t2.orderNumber) FROM customers AS t1 INNER JOIN orders AS t2 ON t1.customerNumber = t2.customerNumber WHERE t2.status = 'On Hold' AND t1.country = 'USA'	car_retails
SELECT SUM(t3.priceEach * t3.quantityOrdered) FROM customers AS t1 INNER JOIN orders AS t2 ON t1.customerNumber = t2.customerNumber INNER JOIN orderdetails AS t3 ON t2.orderNumber = t3.orderNumber INNER JOIN products AS t4 ON t3.productCode = t4.productCode WHERE t4.productLine = 'Classic Cars' AND t1.customerName = 'Land of Toys Inc.' AND t2.status = 'Shipped'	car_retails
SELECT COUNT(id_restaurant) FROM generalinfo WHERE review < 3	restaurant
SELECT food_type FROM generalinfo WHERE review = ( SELECT MAX(review) FROM generalinfo ) LIMIT 4	restaurant
SELECT COUNT(id_restaurant) FROM generalinfo WHERE food_type = 'mediterranean' AND city = 'richmond'	restaurant
SELECT city FROM geographic WHERE county = 'sonoma county'	restaurant
SELECT DISTINCT county FROM geographic WHERE region != 'bay area'	restaurant
SELECT city FROM geographic WHERE region = 'northern california'	restaurant
SELECT id_restaurant FROM location WHERE city = 'oakland' AND street_name = '11th street'	restaurant
SELECT COUNT(id_restaurant) FROM location WHERE street_num = 871	restaurant
SELECT id_restaurant FROM location WHERE City = 'san francisco' AND street_name = '9th avenue'	restaurant
SELECT T1.food_type FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.street_name = 'adeline st' AND T2.city = 'berkeley'	restaurant
SELECT DISTINCT T2.region FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.food_type != 'african'	restaurant
SELECT DISTINCT T2.county FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.label = 'a & w root beer'	restaurant
SELECT T1.street_name, T1.street_num FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.label = 'adelitas taqueria'	restaurant
SELECT T2.food_type FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant INNER JOIN geographic AS T3 ON T2.city = T3.city WHERE T3.County = 'san mateo county' AND T1.street_name = 'alpine rd' AND T1.street_num = 3140	restaurant
SELECT T1.street_name FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'san francisco' AND T2.food_type = 'seafood' AND street_name IS NOT NULL	restaurant
SELECT DISTINCT T2.county FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.label != 'bakers square restaurant & pie shop'	restaurant
SELECT COUNT(DISTINCT T2.county) FROM location AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.street_name = 'appian way'	restaurant
SELECT T1.review FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.street_name = 'atlantic ave'	restaurant
SELECT T1.id_restaurant FROM location AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.county = 'contra costa county'	restaurant
SELECT T1.id_restaurant, T1.label FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.county = 'yolo county'	restaurant
SELECT T1.label FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.street_name = 'drive' AND T1.food_type != 'american' AND T2.city = 'san rafael'	restaurant
SELECT T2.street_name FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'san francisco' AND T1.review = 1.7	restaurant
SELECT T2.label FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.street_name = 'avenida de las pulgas' AND T2.city = 'menlo park' ORDER BY review LIMIT 1	restaurant
SELECT T1.street_name FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant INNER JOIN geographic AS T3 ON T2.city = T3.city WHERE T2.label = 'good heavens' AND T3.county = 'tuolumne county'	restaurant
SELECT DISTINCT T1.street_num FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.label = 'aux delices vietnamese restaurant'	restaurant
SELECT T1.id_restaurant FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.county = 'marin county'	restaurant
SELECT DISTINCT T2.region FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.food_type = 'pizza' AND T2.region != 'unknown'	restaurant
SELECT AVG(T2.review) FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.county = 'santa cruz county'	restaurant
SELECT CAST(SUM(IIF(T2.food_type = 'mexican', 1, 0)) AS REAL) * 100 / COUNT(T2.id_restaurant) FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.county = 'monterey county'	restaurant
SELECT CAST(SUM(IIF(T1.street_name = '11th st', 1, 0)) AS REAL) * 100 / COUNT(T1.id_restaurant) FROM location AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.County = 'alameda county'	restaurant
SELECT label FROM generalinfo WHERE food_type = 'european'	restaurant
SELECT city FROM geographic WHERE region = 'northern california'	restaurant
SELECT label FROM generalinfo WHERE food_type = '24 hour diner'	restaurant
SELECT city FROM geographic WHERE county = 'unknown' AND region = 'unknown' LIMIT 5	restaurant
SELECT county, region FROM geographic WHERE city = 'Davis'	restaurant
SELECT street_name FROM location WHERE city = 'Clayton'	restaurant
SELECT id_restaurant, label FROM generalinfo WHERE city = 'San Francisco' AND review = ( SELECT MAX(review) FROM generalinfo WHERE city = 'San Francisco' )	restaurant
SELECT COUNT(id_restaurant) FROM generalinfo WHERE food_type = 'american' AND city = 'carmel' AND review = ( SELECT MIN(review) FROM generalinfo WHERE food_type = 'american' AND city = 'carmel' )	restaurant
SELECT CAST(SUM(IIF(food_type = 'american food', 1, 0)) AS REAL) * 100 / COUNT(id_restaurant) FROM generalinfo WHERE city = 'dublin'	restaurant
SELECT T2.street_num, T2.street_name, T1.city FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.label = 'Albert''s Café'	restaurant
SELECT T1.id_restaurant FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'Oakland' AND T2.street_name = '19th St'	restaurant
SELECT T1.food_type FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.street_num = 106 AND T2.street_name = 'e 25th ave'	restaurant
SELECT T2.label FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant INNER JOIN geographic AS T3 ON T2.city = T3.city WHERE T3.region = 'unknown' LIMIT 3	restaurant
SELECT T1.label FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.street_num = 104 AND T1.city = 'campbell' AND T2.street_name = 'san tomas aquino road'	restaurant
SELECT COUNT(T1.id_restaurant) FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.food_type = 'thai' AND T1.city = 'albany' AND T2.street_name = 'san pablo ave'	restaurant
SELECT T1.county, T1.region, T2.label FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T2.label = 'plearn-thai cuisine'	restaurant
SELECT T2.label FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.region = 'lake tahoe' AND T1.county = 'el dorado county'	restaurant
SELECT DISTINCT T2.county, T2.region FROM location AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.street_name = 'E. El Camino Real'	restaurant
SELECT T1.id_restaurant FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'berkeley' AND T2.street_name = 'shattuck ave' AND T1.food_type = 'Indian restaurant' ORDER BY T1.review LIMIT 1	restaurant
SELECT CAST(SUM(IIF(T2.review > 4, 1, 0)) AS REAL) * 100 / COUNT(T2.id_restaurant) FROM geographic AS T1 RIGHT JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.region = 'bay area'	restaurant
SELECT city FROM geographic WHERE county = 'san mateo county'	restaurant
SELECT COUNT(id_restaurant) AS cnt FROM generalinfo WHERE review > 4	restaurant
SELECT street_name FROM location GROUP BY street_name ORDER BY COUNT(street_name) DESC LIMIT 1	restaurant
SELECT label FROM generalinfo WHERE food_type = 'chicken' ORDER BY review DESC LIMIT 1	restaurant
SELECT county FROM geographic WHERE city = 'el cerrito'	restaurant
SELECT COUNT(id_restaurant) FROM location WHERE street_name = 'irving'	restaurant
SELECT T1.label FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.county = 'marin county'	restaurant
SELECT T2.street_name FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.label = 'peking duck restaurant'	restaurant
SELECT T2.street_name FROM geographic AS T1 INNER JOIN location AS T2 ON T1.city = T2.city WHERE T1.county = 'alameda county' GROUP BY T2.street_name HAVING COUNT(T2.id_restaurant) > 10	restaurant
SELECT DISTINCT T1.region FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T2.food_type = 'greek'	restaurant
SELECT T2.street_name FROM geographic AS T1 INNER JOIN location AS T2 ON T1.city = T2.city WHERE T1.region = 'unknown'	restaurant
SELECT T2.review FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.street_name = 'murray ave' AND T1.street_num = 8440	restaurant
SELECT T2.food_type FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.county = 'Monterey' GROUP BY T2.food_type ORDER BY COUNT(T2.food_type) DESC LIMIT 1	restaurant
SELECT T2.street_name FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'san francisco' AND T1.food_type = 'burgers' GROUP BY T2.street_name ORDER BY COUNT(T2.id_restaurant) DESC LIMIT 1	restaurant
SELECT T2.region FROM location AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.street_num = 1149 AND T1.street_name = 'el camino real'	restaurant
SELECT T2.county FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.label = 'sankee'	restaurant
SELECT COUNT(T1.city) FROM geographic AS T1 INNER JOIN location AS T2 ON T1.city = T2.city WHERE T1.region = 'northern california'	restaurant
SELECT T2.label FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.street_name = 'park st'	restaurant
SELECT CAST(SUM(IIF(T1.region = 'bay area', 1, 0)) AS REAL) * 100 / COUNT(T2.id_restaurant) FROM geographic AS T1 INNER JOIN location AS T2 ON T1.city = T2.city	restaurant
SELECT AVG(T1.review) FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.food_type = 'chinese' GROUP BY T1.id_restaurant ORDER BY AVG(T1.review) DESC	restaurant
SELECT street_name FROM location WHERE city = 'San Francisco'	restaurant
SELECT id_restaurant FROM location WHERE city = 'Danville'	restaurant
SELECT COUNT(city) FROM geographic WHERE region = 'bay area'	restaurant
SELECT COUNT(T1.label) FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.county = 'unknown'	restaurant
SELECT T1.street_name FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T2.food_type = 'American'	restaurant
SELECT T1.label FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T2.county = 'Santa Cruz county'	restaurant
SELECT T1.review FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.street_name = 'Broadway' AND T2.street_num = 430	restaurant
SELECT T2.street_num, T2.street_name FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant ORDER BY T1.review DESC LIMIT 1	restaurant
SELECT T2.county FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.food_type = 'Italian' GROUP BY T2.county ORDER BY COUNT(T1.id_restaurant) DESC LIMIT 1	restaurant
SELECT CAST(SUM(IIF(region = 'Napa Valley', 1, 0)) AS REAL) * 100 / COUNT(region) FROM geographic	restaurant
SELECT COUNT(city) FROM geographic WHERE region = 'bay area'	restaurant
SELECT city FROM geographic WHERE county = 'unknown'	restaurant
SELECT city FROM geographic WHERE region = 'bay area' AND county = 'santa clara county'	restaurant
SELECT id_restaurant FROM location WHERE city = 'sunnyvale'	restaurant
SELECT COUNT(city) FROM location WHERE street_name = 'railroad' AND street_num < 1000	restaurant
SELECT label FROM generalinfo WHERE food_type = '24 hour diner' AND city = 'san francisco'	restaurant
SELECT T2.review FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.city = 'santa cruz' AND T1.street_name = 'ocean st'	restaurant
SELECT T2.street_num FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.review = 2.7 AND T2.city = 'oakland' AND T1.food_type = 'bar'	restaurant
SELECT COUNT(T1.id_restaurant) FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.food_type = 'bakery' AND T2.city = 'palo alto' AND T1.street_name = 'university ave.'	restaurant
SELECT T1.street_num FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.label = 'Tulocay winery' AND T2.food_type = 'winery'	restaurant
SELECT T2.review, T2.label FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.city = 'hayward' AND T1.street_name = 'mission blvd'	restaurant
SELECT COUNT(T1.id_restaurant) FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.street_name = 'castro st' AND T1.city = 'mountain view' AND T2.food_type = 'indian' AND T2.label LIKE '%cookhouse%'	restaurant
SELECT COUNT(T1.id_restaurant) FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.review = 2 AND T1.street_num < 500	restaurant
SELECT COUNT(T1.id_restaurant) AS num FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.city = 'milpitas' AND T2.food_type = 'asian' AND T1.street_name = 'n milpitas blvd' AND T1.id_restaurant > 385	restaurant
SELECT T2.label, T1.id_restaurant FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'san francisco' AND T1.street_name = 'ocean avenue'	restaurant
SELECT T2.city, T1.street_num, T1.street_name FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.label = 'sanuki restaurant'	restaurant
SELECT T2.food_type FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.street_num = 22779 AND T1.street_name = '6th St' AND T2.city = 'hayward'	restaurant
SELECT COUNT(T2.food_type = 'american') FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'san francisco' AND T1.street_name = 'front'	restaurant
SELECT T1.id_restaurant FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T2.food_type = 'american' AND T1.street_num > 2000 GROUP BY T1.id_restaurant ORDER BY AVG(T2.review) * 0.7 DESC	restaurant
SELECT CAST(SUM(IIF(T2.food_type = 'afghani', 1, 0)) AS REAL) * 100 / COUNT(T1.id_restaurant) FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE 1000 <= T1.street_num <= 2000	restaurant
SELECT label FROM generalinfo WHERE food_type = 'asian' AND city = 'san francisco' AND review = ( SELECT MAX(review) FROM generalinfo WHERE food_type = 'asian' AND city = 'san francisco' )	restaurant
SELECT COUNT(DISTINCT city) FROM geographic WHERE region = 'monterey'	restaurant
SELECT COUNT(id_restaurant) FROM generalinfo WHERE city = 'belmont' AND review > 2 AND food_type = 'deli'	restaurant
SELECT county FROM geographic WHERE region = 'northern california' GROUP BY county ORDER BY COUNT(city) DESC LIMIT 1	restaurant
SELECT COUNT(id_restaurant) FROM location WHERE city = 'concord'	restaurant
SELECT T2.region FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city ORDER BY T1.review DESC LIMIT 4	restaurant
SELECT COUNT(T1.id_restaurant) FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant WHERE T1.city = 'livermore' AND T1.food_type = 'chinese' AND T2.street_name = '1st st'	restaurant
SELECT COUNT(T1.city) FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T2.food_type = 'indian' AND T1.region = 'los angeles area'	restaurant
SELECT T2.food_type FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.region = 'bay area' GROUP BY T2.food_type ORDER BY COUNT(T2.food_type) DESC LIMIT 1	restaurant
SELECT COUNT(T1.id_restaurant) FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.street_name = 'broadway' AND T2.review < 3 AND T1.city = 'oakland'	restaurant
SELECT T2.region AS num FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city WHERE T1.label = 'baskin robbins' GROUP BY T2.region ORDER BY COUNT(T1.city) DESC LIMIT 1	restaurant
SELECT T1.street_name FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T2.food_type = 'pizza' AND T1.city = 'san jose'	restaurant
SELECT COUNT(T2.food_type) FROM geographic AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T1.region = 'yosemite and mono lake area'	restaurant
SELECT T2.street_name, T2.street_num, T2.city FROM generalinfo AS T1 INNER JOIN location AS T2 ON T1.id_restaurant = T2.id_restaurant ORDER BY T1.review DESC LIMIT 1	restaurant
SELECT T2.county FROM generalinfo AS T1 INNER JOIN geographic AS T2 ON T1.city = T2.city GROUP BY T2.county ORDER BY COUNT(T1.label) DESC LIMIT 1	restaurant
SELECT T1.region FROM geographic AS T1 INNER JOIN location AS T2 ON T1.city = T2.city GROUP BY T1.region ORDER BY COUNT(T2.id_restaurant) DESC LIMIT 1	restaurant
SELECT T1.street_num, T1.street_name, T1.city FROM location AS T1 INNER JOIN generalinfo AS T2 ON T1.city = T2.city WHERE T2.review >= 4	restaurant
SELECT COUNT(Player_Id) FROM Player WHERE SUBSTR(DOB, 1, 4) > 1985	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` WHERE SUBSTR(Match_Date, 1, 4) = '2008' AND SUBSTR(Match_Date, 7, 1) = '5'	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` WHERE Man_of_the_Match = 41	soccer_2016
SELECT Match_Id FROM `Match` WHERE SUBSTR(Match_Date, 1, 4) = '2008'	soccer_2016
SELECT COUNT(CASE WHEN T2.Country_Name = 'Australia' THEN T1.Player_Id ELSE NULL END) FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_Id	soccer_2016
SELECT T1.Country_Name FROM Country AS T1 INNER JOIN Player AS T2 ON T2.Country_Name = T1.Country_Id WHERE T2.Country_Name IS NOT NULL ORDER BY T2.DOB LIMIT 1	soccer_2016
SELECT T1.Bowling_Skill FROM Bowling_Style AS T1 INNER JOIN Player AS T2 ON T2.Bowling_skill = T1.Bowling_Id WHERE T2.Player_Name = 'SC Ganguly'	soccer_2016
SELECT SUM(CASE WHEN SUBSTR(T1.DOB, 1, 4) > 1985 THEN 1 ELSE 0 END) FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id WHERE T2.Batting_Hand = 'Right-hand bat'	soccer_2016
SELECT T2.Player_Name FROM Country AS T1 INNER JOIN Player AS T2 ON T2.Country_Name = T1.Country_id INNER JOIN Batting_Style AS T3 ON T2.Batting_hand = T3.Batting_Id WHERE T1.Country_Name = 'Australia' AND T3.Batting_Hand = 'Right-hand bat'	soccer_2016
SELECT T2.Bowling_Skill FROM Player AS T1 INNER JOIN Bowling_Style AS T2 ON T1.Bowling_skill = T2.Bowling_Id INNER JOIN Country AS T3 ON T1.Country_Name = T3.Country_Id WHERE T3.Country_Name = 'Australia' GROUP BY T2.Bowling_Skill	soccer_2016
SELECT MIN(T1.DOB) FROM Player AS T1 INNER JOIN Bowling_Style AS T2 ON T1.Bowling_skill = T2.Bowling_Id WHERE T2.Bowling_Skill = 'Legbreak'	soccer_2016
SELECT T1.Bowling_Skill FROM Bowling_Style AS T1 INNER JOIN Player AS T2 ON T2.Bowling_skill = T1.Bowling_Id GROUP BY T1.Bowling_Skill ORDER BY COUNT(T1.Bowling_Skill) DESC LIMIT 1	soccer_2016
SELECT T2.Player_Name FROM Match AS T1 INNER JOIN Player AS T2 ON T2.Player_Id = T1.Man_of_the_Match WHERE T1.Match_Date = '2008-04-18'	soccer_2016
SELECT SUM(CASE WHEN T3.Role_Desc = 'Captain' THEN 1 ELSE 0 END) FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T2.Role_Id = T3.Role_Id WHERE T1.Player_Name = 'SC Ganguly'	soccer_2016
SELECT T2.Role_Id FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T2.Role_Id = T3.Role_Id INNER JOIN Match AS T4 ON T2.Match_Id = T4.Match_Id WHERE T1.Player_Name = 'SC Ganguly' AND T4.Match_Date = '2008-04-18'	soccer_2016
SELECT MAX(T3.Win_Margin) FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Match AS T3 ON T2.Match_Id = T3.Match_Id WHERE T1.Player_Name = 'SC Ganguly'	soccer_2016
SELECT CAST(SUM(T3.Win_Margin) AS REAL) / COUNT(*) FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Match AS T3 ON T2.Match_Id = T3.Match_Id WHERE T1.Player_Name = 'SC Ganguly'	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Batting_Hand = 'Right-hand bat' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Player_Id) FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id WHERE SUBSTR(T1.DOB, 1, 4) > 1985	soccer_2016
SELECT Player_Name FROM Player ORDER BY DOB DESC LIMIT 1	soccer_2016
SELECT SUM(CASE WHEN Toss_Winner = ( SELECT Team_Id FROM Team WHERE Team_Name = 'Sunrisers Hyderabad' ) THEN 1 ELSE 0 END) FROM `Match`	soccer_2016
SELECT T2.Player_Name FROM Ball_by_Ball AS T1 INNER JOIN Player AS T2 ON T1.Striker = T2.Player_Id WHERE T1.Match_Id = 419169 AND T1.Over_Id = 3 AND T1.Ball_Id = 2 AND T1.Innings_No = 2	soccer_2016
SELECT T2.Venue_Name FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE T1.Win_Margin = 138	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match WHERE T2.Match_Date = '2008-05-12'	soccer_2016
SELECT T3.Player_Name FROM Player_Match AS T1 INNER JOIN Rolee AS T2 ON T1.Role_Id = T2.Role_Id INNER JOIN Player AS T3 ON T1.Player_Id = T3.Player_Id WHERE T1.Match_Id = '419117' AND T2.Role_Desc = 'CaptainKeeper'	soccer_2016
SELECT T2.Player_Name FROM Season AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Series = T2.Player_Id WHERE T1.Season_Year = 2013	soccer_2016
SELECT T2.DOB FROM Season AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Series = T2.Player_Id WHERE T1.Season_Year = 2014 AND T1.Orange_Cap IS NOT NULL	soccer_2016
SELECT T3.Country_Name FROM Season AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Series = T2.Player_Id INNER JOIN Country AS T3 ON T2.Country_Name = T3.Country_Id WHERE T1.Season_Id = 7 AND T1.Purple_Cap IS NOT NULL	soccer_2016
SELECT T2.Country_Name FROM City AS T1 INNER JOIN Country AS T2 ON T1.Country_Id = T2.Country_Id WHERE T1.City_Name = 'Ranchi'	soccer_2016
SELECT SUM(CASE WHEN T2.Country_Name = 'India' THEN 1 ELSE 0 END) FROM City AS T1 INNER JOIN Country AS T2 ON T1.Country_Id = T2.Country_Id	soccer_2016
SELECT T1.City_Name FROM City AS T1 INNER JOIN Venue AS T2 ON T1.City_Id = T2.City_Id GROUP BY T1.City_Id ORDER BY COUNT(T2.Venue_Id) DESC LIMIT 1	soccer_2016
SELECT T2.Batting_hand FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id WHERE T1.Player_Name = 'MK Pandey'	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Country_Name = 'India' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.Country_Name = 'South Africa' THEN 1 ELSE 0 END) FROM City AS T1 INNER JOIN Country AS T2 ON T1.Country_Id = T2.Country_Id	soccer_2016
SELECT SUM(CASE WHEN T2.Venue_Name = 'M Chinnaswamy Stadium' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.Venue_Name = 'Maharashtra Cricket Association Stadium' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id	soccer_2016
SELECT Player_Name FROM Player ORDER BY DOB ASC LIMIT 1	soccer_2016
SELECT SUM(CASE WHEN SUBSTR(Match_Date, 7, 1) = '5' THEN 1 ELSE 0 END) FROM `Match` WHERE SUBSTR(Match_Date, 1, 4) = '2008'	soccer_2016
SELECT COUNT(Player_Id) AS cnt FROM Player WHERE DOB BETWEEN '1990-01-01' AND '1999-12-31'	soccer_2016
SELECT SUM(CASE WHEN Team_1 = 10 OR Team_2 = 10 THEN 1 ELSE 0 END) FROM `Match` WHERE SUBSTR(Match_Date, 1, 4) = '2012'	soccer_2016
SELECT Orange_Cap FROM Season GROUP BY Orange_Cap HAVING COUNT(Season_Year) > 1	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` WHERE Season_Id = 7	soccer_2016
SELECT SUM(CASE WHEN T1.Country_Name = 'South Africa' THEN 1 ELSE 0 END) FROM Country AS T1 INNER JOIN Umpire AS T2 ON T1.Country_ID = T2.Umpire_Country	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match GROUP BY T2.Man_of_the_Match ORDER BY COUNT(T2.Man_of_the_Match) DESC LIMIT 1	soccer_2016
SELECT T1.Country_Name FROM Country AS T1 INNER JOIN Player AS T2 ON T1.Country_Id = T2.Country_Name GROUP BY T2.Country_Name ORDER BY COUNT(T2.Country_Name) DESC LIMIT 1	soccer_2016
SELECT SUM(CASE WHEN T1.Player_Name = 'CH Gayle' THEN 1 ELSE 0 END) AS cnt FROM Player AS T1 INNER JOIN Season AS T2 ON T1.Player_Id = T2.Orange_Cap	soccer_2016
SELECT T1.Season_Id FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE T2.Venue_Name = 'M Chinnaswamy Stadium' GROUP BY T1.Season_Id ORDER BY COUNT(T1.Season_Id) DESC LIMIT 1	soccer_2016
SELECT Team_Name FROM Team WHERE Team_Id = ( SELECT Match_Winner FROM `Match` WHERE season_Id = 1 GROUP BY Match_Winner ORDER BY COUNT(Match_Winner) DESC LIMIT 1 )	soccer_2016
SELECT T3.Venue_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Team_1 INNER JOIN Venue AS T3 ON T2.Venue_Id = T3.Venue_Id WHERE T1.Team_Name = 'Kolkata Knight Riders' GROUP BY T3.Venue_Id ORDER BY COUNT(T3.Venue_Id) DESC LIMIT 1	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN ( SELECT COUNT(Team_1) AS a, Team_1 FROM Match WHERE Team_1 <> Match_Winner GROUP BY Team_1 UNION SELECT COUNT(Team_2) AS a, Team_2 FROM Match WHERE Team_2 <> Match_Winner GROUP BY Team_2 ORDER BY a DESC LIMIT 1 ) AS T2 ON T1.Team_Id = T2.Team_1	soccer_2016
SELECT Player_Name FROM Player WHERE Player_Id = ( SELECT Man_of_the_Match FROM `Match` ORDER BY match_date ASC LIMIT 1 )	soccer_2016
SELECT Match_Date FROM `Match` WHERE team_1 = ( SELECT Team_Id FROM Team WHERE Team_Name = 'Chennai Super Kings' ) OR Team_2 = ( SELECT Team_Id FROM Team WHERE Team_Name = 'Chennai Super Kings' ) ORDER BY Match_Date ASC LIMIT 1	soccer_2016
SELECT SUM(CASE WHEN T1.Batting_hand = 'Left-hand bat' THEN 1 ELSE 0 END) AS cnt FROM Batting_Style AS T1 INNER JOIN Player AS T2 ON T1.Batting_Id = T2.Batting_hand INNER JOIN Country AS T3 ON T2.Country_Name = T3.Country_Id WHERE T3.Country_Name = 'India'	soccer_2016
SELECT T4.Player_Name FROM Team AS T1 INNER JOIN Player_Match AS T2 ON T1.Team_id = T2.Team_id INNER JOIN Rolee AS T3 ON T2.Role_Id = T3.Role_Id INNER JOIN Player AS T4 ON T2.Player_Id = T4.Player_Id WHERE T1.Team_Name = 'Deccan Chargers' AND T1.Team_Id = 8 AND T3.Role_Desc = 'Captain' AND T3.Role_Id = 1 GROUP BY T4.Player_Id ORDER BY COUNT(T3.Role_Id) DESC LIMIT 1	soccer_2016
SELECT CAST(SUM(CASE WHEN T1.Batting_hand = 'Right-hand bat' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.Player_Id) FROM Batting_Style AS T1 INNER JOIN Player AS T2 ON T2.Batting_hand = T1.Batting_Id	soccer_2016
SELECT Player_name FROM Player WHERE DOB = '1981-07-07'	soccer_2016
SELECT SUM(CASE WHEN Player_Id = 2 THEN 1 ELSE 0 END) FROM Player_Match	soccer_2016
SELECT T2.Team_Name FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_1 ORDER BY T1.Win_Margin DESC LIMIT 1	soccer_2016
SELECT T3.Country_Name FROM Venue AS T1 INNER JOIN City AS T2 ON T2.City_Id = T1.City_Id INNER JOIN Country AS T3 ON T3.Country_Id = T2.Country_id WHERE T1.Venue_Name = 'St George''s Park'	soccer_2016
SELECT T3.Team_Name FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T2.Player_Id = T1.Player_Id INNER JOIN Team AS T3 ON T3.Team_Id = T2.Team_Id WHERE T2.Match_Id = 335990 AND T3.Team_Name = 'Mumbai Indians' GROUP BY T3.Team_Name	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Match_Winner WHERE T2.Match_Date = '2009-05-07' AND T2.Win_Margin = 7	soccer_2016
SELECT SUM(CASE WHEN T2.Outcome_Type = 'Superover' THEN 1 ELSE 0 END) FROM Match AS T1 INNER JOIN Outcome AS T2 ON T2.Outcome_Id = T1.Outcome_type	soccer_2016
SELECT T1.City_Name FROM City AS T1 INNER JOIN Country AS T2 ON T2.Country_Id = T1.Country_id WHERE T2.Country_Name = 'U.A.E'	soccer_2016
SELECT SUM(CASE WHEN T2.Team_Name = 'Pune Warriors' THEN 1 ELSE 0 END) FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Match_Winner	soccer_2016
SELECT T2.Team_Name FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Match_Winner WHERE T1.Match_Date LIKE '2015%' AND T1.Match_Id = 829768	soccer_2016
SELECT T3.Role_Desc FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T2.Player_Id = T1.Player_Id INNER JOIN Rolee AS T3 ON T3.Role_Id = T2.Role_Id WHERE T2.Match_Id = 335992 AND T1.Player_Name = 'K Goel'	soccer_2016
SELECT SUM(CASE WHEN T2.Country_Name = 'South Africa' THEN 1 ELSE 0 END) FROM City AS T1 INNER JOIN Country AS T2 ON T2.Country_Id = T1.Country_id	soccer_2016
SELECT SUM(CASE WHEN T2.Venue_Name = 'Newlands' THEN 1 ELSE 0 END) FROM Match AS T1 INNER JOIN Venue AS T2 ON T2.Venue_Id = T1.Venue_Id	soccer_2016
SELECT T1.Win_Margin FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_1 INNER JOIN Team AS T3 ON T3.Team_Id = T1.Team_2 WHERE (T2.Team_Name = 'Mumbai Indians' AND T3.Team_Name = 'Royal Challengers Bangalore' AND T1.Match_Date = '2008-05-28') OR (T2.Team_Name = 'Royal Challengers Bangalore' AND T3.Team_Name = 'Mumbai Indians' AND T1.Match_Date = '2008-05-28')	soccer_2016
SELECT DISTINCT CASE WHEN T1.Win_Margin < ( SELECT AVG(Win_Margin) * 0.3 FROM Match WHERE Match_Date LIKE '2011%' ) THEN T2.Team_Name END, CASE WHEN T1.Win_Margin < ( SELECT AVG(Win_Margin) * 0.3 FROM Match WHERE Match_Date LIKE '2011%' ) THEN T3.Team_Name END FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_1 INNER JOIN Team AS T3 ON T3.Team_Id = T1.Team_2 WHERE T1.Match_Date LIKE '2011%'	soccer_2016
SELECT CAST(SUM(CASE WHEN T1.Role_Desc = 'Captain' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Role_Id) FROM Rolee AS T1 INNER JOIN Player_Match AS T2 ON T2.Role_Id = T1.Role_Id INNER JOIN Player AS T3 ON T3.Player_Id = T2.Player_Id WHERE T3.DOB LIKE '1977%'	soccer_2016
SELECT COUNT(Over_Id) FROM Ball_by_Ball WHERE Match_Id = 335996 AND Innings_No = 1	soccer_2016
SELECT Over_Id, Ball_Id, Innings_No FROM Batsman_Scored WHERE Match_Id = 336004 ORDER BY Runs_Scored DESC LIMIT 1	soccer_2016
SELECT Match_Id FROM Ball_by_Ball WHERE Over_Id = 20 GROUP BY Match_Id LIMIT 5	soccer_2016
SELECT SUM(CASE WHEN Match_Id = 548335 THEN 1 ELSE 0 END) FROM Wicket_Taken WHERE Innings_No = 1	soccer_2016
SELECT Player_name FROM Player WHERE DOB LIKE '1971%'	soccer_2016
SELECT Match_Id FROM Match WHERE Match_Date LIKE '%2015-04-18%'	soccer_2016
SELECT T1.Match_Id FROM Wicket_Taken AS T1 INNER JOIN Out_Type AS T2 ON T2.Out_Id = T1.Kind_Out WHERE T2.Out_Name = 'hit wicket'	soccer_2016
SELECT SUM(CASE WHEN T1.Innings_No = 2 THEN 1 ELSE 0 END) FROM Wicket_Taken AS T1 INNER JOIN Out_Type AS T2 ON T2.Out_Id = T1.Kind_Out WHERE T2.Out_Name = 'stumped'	soccer_2016
SELECT SUM(CASE WHEN T2.Player_Name = 'Yuvraj Singh' THEN 1 ELSE 0 END) FROM Match AS T1 INNER JOIN Player AS T2 ON T2.Player_Id = T1.Man_of_the_Match	soccer_2016
SELECT T2.Player_Name, T2.DOB FROM Country AS T1 INNER JOIN Player AS T2 ON T2.Country_Name = T1.Country_Id WHERE T2.DOB LIKE '1977%' AND T1.Country_Name = 'England'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Match AS T2 ON T2.Man_of_the_Match = T1.Player_Id INNER JOIN Season AS T3 ON T3.Season_Id = T2.Season_Id WHERE T3.Season_Year = 2010 GROUP BY T1.Player_Name	soccer_2016
SELECT CAST(SUM(CASE WHEN T1.Match_Winner = 3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Match_Id) FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_1 INNER JOIN Team AS T3 ON T3.Team_Id = T1.Team_2 WHERE T2.Team_Name = 'Chennai Super Kings' OR T3.Team_Name = 'Chennai Super Kings'	soccer_2016
SELECT T4.Player_Name, T5.Country_Name FROM Player_Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_Id INNER JOIN Match AS T3 ON T3.Match_Id = T1.Match_Id INNER JOIN Player AS T4 ON T4.Player_Id = T1.Player_Id INNER JOIN Country AS T5 ON T5.Country_Id = T4.Country_Name WHERE T2.Team_Name = 'Gujarat Lions' AND T3.Match_Date = '2016-04-11'	soccer_2016
SELECT T1.Player_Name, T1.DOB FROM Player AS T1 INNER JOIN Bowling_Style AS T2 ON T2.Bowling_Id = T1.Bowling_skill WHERE T2.Bowling_skill = 'Left-arm fast'	soccer_2016
SELECT T1.Country_Name FROM Country AS T1 INNER JOIN Umpire AS T2 ON T2.Umpire_Country = T1.Country_Id WHERE T2.Umpire_Name = 'BR Doctrove'	soccer_2016
SELECT T3.Player_Name FROM Player_Match AS T1 INNER JOIN Match AS T2 ON T2.Match_Id = T1.Match_Id INNER JOIN Player AS T3 ON T3.Player_Id = T1.Player_Id INNER JOIN Rolee AS T4 ON T4.Role_Id = T1.Role_Id WHERE T2.Match_Date = '2008-06-01' AND T4.Role_Desc = 'Captain' AND T2.Match_Winner = T1.Team_Id	soccer_2016
SELECT T3.Team_Name, COUNT(T2.Match_Id) FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T2.Player_Id = T1.Player_Id INNER JOIN Team AS T3 ON T3.Team_Id = T2.Team_Id WHERE T1.Player_Name = 'CK Kapugedera'	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Venue_Name = 'Wankhede Stadium' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.Match_Id) FROM City AS T1 INNER JOIN Venue AS T2 ON T2.City_Id = T1.City_Id INNER JOIN Match AS T3 ON T3.Venue_Id = T2.Venue_Id WHERE T1.City_Name = 'Mumbai'	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Out_Name = 'bowled' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Player_Out) FROM Wicket_Taken AS T1 INNER JOIN Out_Type AS T2 ON T2.Out_Id = T1.Kind_Out WHERE T1.Match_Id = 392187	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Toss_Name = 'field' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.Toss_Id) FROM Match AS T1 INNER JOIN Toss_Decision AS T2 ON T2.Toss_Id = T1.Toss_Decide WHERE T1.Match_Date BETWEEN '2010-01-01' AND '2016-12-31'	soccer_2016
SELECT Toss_Winner FROM Match WHERE Toss_Decide = 2	soccer_2016
SELECT T1.Match_Id FROM Match AS T1 INNER JOIN Player AS T2 ON T2.Player_Id = T1.Man_of_the_Match WHERE T2.Player_Name = 'BB McCullum'	soccer_2016
SELECT T2.DOB FROM Match AS T1 INNER JOIN Player AS T2 ON T2.Player_Id = T1.Man_of_the_Match	soccer_2016
SELECT T2.Team_Name FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Toss_Winner WHERE T1.Match_Id BETWEEN 336010 AND 336020	soccer_2016
SELECT SUM(CASE WHEN T2.Team_Name = 'Mumbai Indians' THEN 1 ELSE 0 END) FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Match_Winner	soccer_2016
SELECT T2.Team_Name FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_2 WHERE T1.Team_1 = ( SELECT Team_Id FROM Team WHERE Team_Name = 'Pune Warriors' ) GROUP BY T2.Team_Name	soccer_2016
SELECT T2.Team_Name FROM Match AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Match_Winner WHERE T1.Match_Id = 336000	soccer_2016
SELECT T1.Match_Id FROM Match AS T1 INNER JOIN Venue AS T2 ON T2.Venue_Id = T1.Venue_Id WHERE T2.Venue_Name = 'Brabourne Stadium'	soccer_2016
SELECT T2.Venue_Name FROM Match AS T1 INNER JOIN Venue AS T2 ON T2.Venue_Id = T1.Venue_Id WHERE T1.Season_Id = 2 GROUP BY T2.Venue_Name	soccer_2016
SELECT T1.City_Name FROM City AS T1 INNER JOIN Venue AS T2 ON T2.City_Id = T1.City_Id WHERE T2.Venue_Name = 'M Chinnaswamy Stadium'	soccer_2016
SELECT T2.Venue_Name FROM City AS T1 INNER JOIN Venue AS T2 ON T2.City_Id = T1.City_Id WHERE T1.City_Name = 'Mumbai'	soccer_2016
SELECT T2.Match_Winner FROM Venue AS T1 INNER JOIN Match AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE T1.Venue_Name LIKE 'St George%'	soccer_2016
SELECT T2.City_Name FROM Venue AS T1 INNER JOIN City AS T2 ON T1.City_Id = T2.City_Id WHERE T1.Venue_Name LIKE 'St George%'	soccer_2016
SELECT SUM(T2.Match_Winner) FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Match_Winner WHERE T1.Team_Name = 'Deccan Chargers'	soccer_2016
SELECT SUM(T1.Venue_Name) FROM Venue AS T1 INNER JOIN City AS T2 ON T1.City_Id = T2.City_Id WHERE T2.City_Name = 'Pune'	soccer_2016
SELECT Ball_Id FROM Ball_by_Ball WHERE Non_Striker = Ball_Id ORDER BY Ball_Id DESC LIMIT 1	soccer_2016
SELECT CAST(SUM(CASE WHEN 1 < Over_Id AND Over_Id < 25 THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(Runs_Scored) FROM Batsman_Scored WHERE Innings_No = 1	soccer_2016
SELECT AVG(Innings_No) FROM Extra_Runs WHERE Innings_No = 2	soccer_2016
SELECT CAST(COUNT(CASE WHEN Win_Margin > 100 THEN 1 ELSE 0 END) AS REAL) * 100 / TOTAL(Match_Id) FROM `Match`	soccer_2016
SELECT Player_Name FROM Player WHERE DOB BETWEEN '1970-01-01' AND '1990-12-31' ORDER BY DOB DESC	soccer_2016
SELECT SUM(CASE WHEN Fielders = '' THEN 1 ELSE 0 END) FROM Wicket_Taken WHERE Over_Id = 3	soccer_2016
SELECT T2.Country_Id, COUNT(T1.Umpire_Id) FROM Umpire AS T1 INNER JOIN Country AS T2 ON T2.Country_Id = T1.Umpire_Country GROUP BY T2.Country_Id ORDER BY COUNT(T1.Umpire_Id) DESC LIMIT 1	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Role_Desc = 'CaptainKeeper' THEN 1 ELSE 0 END) AS REAL) * 100 / TOTAL(T1.Player_Id) FROM Player_Match AS T1 INNER JOIN Rolee AS T2 ON T1.Role_Id = T2.Role_Id	soccer_2016
SELECT Player_Out FROM Wicket_Taken AS T1 INNER JOIN Out_Type AS T2 ON T1.Kind_Out = T2.Out_Id WHERE Out_Name = 'hit wicket'	soccer_2016
SELECT CAST(SUM(CASE WHEN T1.Batting_hand = 'Right-hand bat' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.Country_Name) FROM Batting_Style AS T1 INNER JOIN Player AS T2 ON T1.Batting_id = T2.Batting_hand	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Bowling_skill = ' Legbreak' THEN 1 ELSE 0 END) AS REAL) * 100 / TOTAL(T1.Player_Id) FROM Player AS T1 INNER JOIN Bowling_Style AS T2 ON T1.Bowling_skill = T2.Bowling_Id	soccer_2016
SELECT COUNT(T2.Win_Id) FROM `Match` AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id WHERE T2.Win_Type = 'wickets' AND T1.Win_Margin < 50	soccer_2016
SELECT SUM(CASE WHEN T1.Team_2 = T1.Match_Winner THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE T1.Team_1 = T1.Toss_Winner	soccer_2016
SELECT T2.Player_Name, T3.Country_Name FROM Season AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Series = T2.Player_Id INNER JOIN Country AS T3 ON T2.Country_Name = T3.Country_Id WHERE T1.Season_Year = 2012	soccer_2016
SELECT T2.Venue_Name FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id GROUP BY T2.Venue_Name ORDER BY COUNT(T2.Venue_Id) DESC LIMIT 1	soccer_2016
SELECT T4.City_Name FROM `Match` AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id INNER JOIN Venue AS T3 ON T1.Venue_Id = T3.Venue_Id INNER JOIN City AS T4 ON T3.City_Id = T4.City_Id WHERE T2.Win_Type = 'NO Result' GROUP BY T4.City_Id ORDER BY COUNT(T2.Win_Type) ASC LIMIT 1	soccer_2016
SELECT T2.Player_Name FROM Season AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Series = T2.Player_Id WHERE T1.Man_of_the_Series > 1	soccer_2016
SELECT T1.Player_Name, T4.Country_Name FROM Player AS T1 INNER JOIN Wicket_Taken AS T2 ON T1.Player_Id = T2.Fielders INNER JOIN Out_Type AS T3 ON T2.Kind_Out = T3.Out_Id INNER JOIN Country AS T4 ON T1.Country_Name = T4.Country_Id GROUP BY T1.Player_Name ORDER BY COUNT(T3.Out_Name) ASC	soccer_2016
SELECT CAST(COUNT(CASE WHEN T1.Team_1 = T1.Match_Winner = T1.Toss_Winner THEN 1 ELSE 0 END) AS REAL) * 100 / TOTAL(T1.Team_1) FROM `Match` AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id INNER JOIN Toss_Decision AS T3 ON T1.Toss_Decide = T3.Toss_Id WHERE T3.Toss_Name = 'field' AND T2.Win_Type = 'runs'	soccer_2016
SELECT AVG(T1.Player_Out) FROM Wicket_Taken AS T1 INNER JOIN Out_Type AS T2 ON T1.Kind_Out = T2.Out_Id WHERE T2.Out_Name = 'lbw'	soccer_2016
SELECT DISTINCT Over_Id FROM Ball_by_Ball WHERE Striker = 7	soccer_2016
SELECT COUNT(Team_1) FROM `Match` WHERE Team_1 = Toss_Winner AND Toss_Decide = 2	soccer_2016
SELECT SUM(CASE WHEN Match_Date LIKE '2010-03%' THEN 1 ELSE 0 END) FROM `Match`	soccer_2016
SELECT SUM(CASE WHEN DOB < '1990-06-29' THEN 1 ELSE 0 END) FROM Player WHERE Player_Name != 'Gurkeerat Singh'	soccer_2016
SELECT SUM(CASE WHEN T2.Player_Name = 'SR Watson' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Match = T2.Player_Id	soccer_2016
SELECT T3.Player_Name FROM Player_Match AS T1 INNER JOIN Team AS T2 ON T1.Team_Id = T2.Team_Id INNER JOIN Player AS T3 ON T1.Player_Id = T3.Player_Id WHERE T2.Team_Name = 'Delhi Daredevils' GROUP BY T3.Player_Name ORDER BY COUNT(T1.Role_Id) DESC LIMIT 1	soccer_2016
SELECT T3.Player_Name FROM Season AS T1 INNER JOIN Match AS T2 ON T1.Man_of_the_Series = T2.Man_of_the_Match INNER JOIN Player AS T3 ON T2.Man_of_the_Match = T3.Player_Id GROUP BY T3.Player_Name ORDER BY COUNT(T1.Man_of_the_Series) DESC LIMIT 1	soccer_2016
SELECT T4.Season_Year, T4.Orange_Cap FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Match AS T3 ON T2.Match_Id = T3.Match_Id INNER JOIN Season AS T4 ON T3.Season_Id = T4.Season_Id WHERE T1.Player_Name = 'SP Narine' GROUP BY T4.Season_Year, T4.Orange_Cap	soccer_2016
SELECT T5.Team_Name, T1.Orange_Cap, T1.Purple_Cap FROM Season AS T1 INNER JOIN Match AS T2 ON T1.Season_Id = T2.Season_Id INNER JOIN Player_Match AS T3 ON T2.Match_Id = T3.Match_Id INNER JOIN Player AS T4 ON T3.Player_Id = T4.Player_Id INNER JOIN Team AS T5 ON T3.Team_Id = T5.Team_Id GROUP BY T5.Team_Name, T1.Orange_Cap, T1.Purple_Cap	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_Id WHERE T2.Country_Name = 'Zimbabwea'	soccer_2016
SELECT SUM(CASE WHEN T2.Batting_hand = 'Left-hand bat' THEN 1 ELSE 0 END) FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id	soccer_2016
SELECT SUM(CASE WHEN T2.Win_Type != 'runs' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id	soccer_2016
SELECT T1.Umpire_Name FROM Umpire AS T1 INNER JOIN Country AS T2 ON T1.Umpire_Country = T2.Country_Id WHERE T2.Country_Name = 'New Zealand'	soccer_2016
SELECT T3.Country_Name FROM Bowling_Style AS T1 INNER JOIN Player AS T2 ON T1.Bowling_Id = T2.Bowling_skill INNER JOIN Country AS T3 ON T2.Country_Name = T3.Country_Id WHERE T1.Bowling_skill = 'Slow left-arm chinaman'	soccer_2016
SELECT T1.Venue_Name FROM Venue AS T1 INNER JOIN Match AS T2 ON T1.Venue_Id = T2.Venue_Id INNER JOIN Team AS T3 ON T2.Team_1 = T3.Team_Id WHERE T3.Team_Name = 'Kochi Tuskers Kerala' GROUP BY T1.Venue_Name	soccer_2016
SELECT COUNT(T1.Runs_Scored) FROM Batsman_Scored AS T1 INNER JOIN Ball_by_Ball AS T2 ON T1.Match_Id = T2.Match_Id INNER JOIN Match AS T3 ON T2.Match_Id = T3.Match_Id INNER JOIN Team AS T4 ON T3.Team_1 = T4.Team_Id WHERE T2.Team_Batting = 1 OR T2.Team_Batting = 2 AND T4.Team_Name = 'Delhi Daredevils'	soccer_2016
SELECT CAST(COUNT(CASE WHEN T2.Win_Margin < 10 THEN 1 ELSE 0 END) AS REAL) * 100 / TOTAL(T1.Venue_Id) FROM Venue AS T1 INNER JOIN Match AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE T1.Venue_Name = 'Dr DY Patil Sports Academy'	soccer_2016
SELECT AVG(T1.Extra_Runs) FROM Extra_Runs AS T1 INNER JOIN Extra_Type AS T2 ON T1.Extra_Type_Id = T2.Extra_Id WHERE T2.Extra_Name = 'noballs'	soccer_2016
SELECT Player_Id FROM Player ORDER BY Bowling_skill DESC LIMIT 5	soccer_2016
SELECT COUNT(*) FROM Player WHERE DOB < '1975-10-16' AND Bowling_skill < 3	soccer_2016
SELECT Player_Name FROM Player ORDER BY DOB DESC LIMIT 1	soccer_2016
SELECT Man_of_the_Series FROM Season WHERE 2011 < Season_Year < 2015	soccer_2016
SELECT SUM(Runs_Scored) FROM Batsman_Scored WHERE Match_Id = 335988 AND Innings_No = 2	soccer_2016
SELECT SUM(CASE WHEN Runs_Scored > 3 THEN 1 ELSE 0 END) FROM Batsman_Scored WHERE 335989 < Match_Id < 337000 AND Innings_No = 1 AND Over_Id = 1 AND Ball_Id = 1	soccer_2016
SELECT T1.Match_Id, T1.Match_Date FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE T2.Venue_Name = 'Kingsmead'	soccer_2016
SELECT SUM(CASE WHEN Venue_Name = 'MA Chidambaram Stadium' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id WHERE Match_Date BETWEEN '2009-05-09' AND '2011-08-08'	soccer_2016
SELECT T2.Venue_Name, T3.City_Name FROM `Match` AS T1 INNER JOIN Venue AS T2 ON T1.Venue_Id = T2.Venue_Id INNER JOIN City AS T3 ON T2.City_Id = T3.City_Id WHERE T1.Match_Id = '336005'	soccer_2016
SELECT T2.Toss_Name, T1.Toss_Decide, T1.Toss_Winner FROM `Match` AS T1 INNER JOIN Toss_Decision AS T2 ON T1.Toss_Decide = T2.Toss_Id WHERE T1.Match_Id = '336011'	soccer_2016
SELECT SUM(CASE WHEN T1.DOB < '1980-4-11' THEN 1 ELSE 0 END) FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_Id WHERE T2.Country_Name = 'South Africa'	soccer_2016
SELECT T2.Player_Name FROM Bowling_Style AS T1 INNER JOIN Player AS T2 ON T1.Bowling_Id = T2.Bowling_skill WHERE T1.Bowling_skill = 'Legbreak'	soccer_2016
SELECT T1.Match_Date, T4.Role_Desc FROM `Match` AS T1 INNER JOIN Player_Match AS T2 ON T1.Match_Id = T2.Match_Id INNER JOIN Player AS T3 ON T2.Player_Id = T3.Player_Id INNER JOIN Rolee AS T4 ON T2.Role_Id = T4.Role_Id ORDER BY T3.DOB DESC LIMIT 1	soccer_2016
SELECT T1.Match_Id FROM `Match` AS T1 INNER JOIN Player AS T2 ON T1.Man_of_the_Match = T2.Player_Id WHERE T2.Player_Name = 'V Kohli'	soccer_2016
SELECT SUM(CASE WHEN T1.Match_Date BETWEEN '2011%' AND '2012%' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Player AS T2 ON T2.Player_Id = T1.Man_of_the_Match INNER JOIN Country AS T3 ON T3.Country_Id = T2.Country_Name WHERE T3.Country_Name = 'Australia'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Season AS T2 ON T1.Player_Id = T2.Man_of_the_Series = T2.Orange_Cap	soccer_2016
SELECT T1.Match_Date FROM `Match` AS T1 INNER JOIN Team AS T2 ON T1.Match_Winner = T2.Team_Id WHERE T2.Team_Name = 'Sunrisers Hyderabad'	soccer_2016
SELECT T1.Umpire_Name, T1.Umpire_Id FROM Umpire AS T1 INNER JOIN Country AS T2 ON T1.Umpire_Country = T2.Country_Id WHERE T2.Country_Name = 'England'	soccer_2016
SELECT CAST(COUNT(CASE WHEN T1.Toss_Name = 'bat' THEN T3.Runs_Scored ELSE NULL END) AS REAL) / SUM(CASE WHEN T1.Toss_Name = 'field' THEN 1 ELSE 0 END) FROM Toss_Decision AS T1 INNER JOIN Match AS T2 ON T1.Toss_Id = T2.Toss_Decide INNER JOIN Batsman_Scored AS T3 ON T2.Match_Id = T3.Match_Id WHERE T2.Match_Id = 335987 AND T2.Match_Date = '2008-04-18' GROUP BY T3.Over_Id HAVING COUNT(T1.Toss_Name = 'field') = 17	soccer_2016
SELECT CAST(COUNT(CASE WHEN T1.Toss_Name = 'bat' THEN T3.Runs_Scored ELSE NULL END) AS REAL) / SUM(CASE WHEN T1.Toss_Name = 'field' THEN 1 ELSE 0 END) FROM Toss_Decision AS T1 INNER JOIN Match AS T2 ON T1.Toss_Id = T2.Toss_Decide INNER JOIN Batsman_Scored AS T3 ON T2.Match_Id = T3.Match_Id WHERE T2.Match_Id = 335987 AND T2.Match_Date = '2008-04-18' GROUP BY T3.Over_Id HAVING COUNT(T1.Toss_Name = 'field') = 16	soccer_2016
SELECT Match_Id FROM `Match` ORDER BY Match_Winner DESC LIMIT 1	soccer_2016
SELECT DOB FROM Player GROUP BY DOB ORDER BY COUNT(DOB) DESC LIMIT 1	soccer_2016
SELECT Match_Date FROM `Match` ORDER BY Win_Margin DESC LIMIT 1	soccer_2016
SELECT Season_Id FROM `Match` GROUP BY Season_Id ORDER BY COUNT(Match_Id) LIMIT 1	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` GROUP BY Man_of_the_Match HAVING COUNT(Match_Id) >= 5	soccer_2016
SELECT T1.Player_name FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match WHERE T2.Season_Id = 9 ORDER BY T2.Match_Date DESC LIMIT 1	soccer_2016
SELECT T1.Team_Name FROM team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Match_Winner WHERE T2.Season_Id = 1 ORDER BY T2.Match_Date LIMIT 1	soccer_2016
SELECT SUM(CASE WHEN T2.Country_Name = 'U.A.E' THEN 1 ELSE 0 END) FROM City AS T1 INNER JOIN country AS T2 ON T1.Country_id = T2.Country_id	soccer_2016
SELECT T1.Umpire_Name FROM Umpire AS T1 INNER JOIN country AS T2 ON T2.Country_Id = T1.Umpire_Country WHERE T2.Country_Name = 'England'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Bowling_Style AS T2 ON T1.Bowling_skill = T2.Bowling_Id WHERE T2.Bowling_skill = 'Legbreak'	soccer_2016
SELECT SUM(CASE WHEN T1.Season_Id = 8 THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Team AS T2 ON T1.Team_1 = T2.Team_Id OR T1.Team_2 = T2.Team_Id WHERE T2.Team_Name = 'Rajasthan Royals'	soccer_2016
SELECT T2.Country_Name FROM Umpire AS T1 INNER JOIN country AS T2 ON T2.Country_Id = T1.Umpire_Country WHERE T1.Umpire_Name = 'TH Wijewardene'	soccer_2016
SELECT T1.Venue_Name FROM Venue AS T1 INNER JOIN City AS T2 ON T1.City_Id = T2.City_Id WHERE T2.City_Name = 'Abu Dhabi'	soccer_2016
SELECT T1.Country_Name FROM Country AS T1 INNER JOIN Player AS T2 ON T1.Country_Id = T2.Country_Name ORDER BY T2.DOB DESC LIMIT 1	soccer_2016
SELECT T3.Player_Name FROM `Match` AS T1 INNER JOIN Player_Match AS T2 ON T1.Match_Winner = T2.Team_Id INNER JOIN Player AS T3 ON T2.Player_Id = T3.Player_Id WHERE T1.Season_Id = 1 ORDER BY T1.Match_Date LIMIT 1	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Season AS T2 ON T1.Player_Id = T2.Purple_Cap ORDER BY T2.Season_Year - SUBSTR(T1.DOB, 1, 4) LIMIT 1	soccer_2016
SELECT T1.Venue_Name, T2.City_Name, T3.Country_Name FROM Venue AS T1 INNER JOIN City AS T2 ON T1.City_Id = T2.City_Id INNER JOIN Country AS T3 ON T2.Country_Id = T3.Country_Id INNER JOIN Match AS T4 ON T1.Venue_Id = T4.Venue_Id ORDER BY T4.Match_Date DESC LIMIT 1	soccer_2016
SELECT SUM(CASE WHEN Innings_No = 1 THEN 1 ELSE 0 END) AS IN1 , SUM(CASE WHEN Innings_No = 2 THEN 1 ELSE 0 END) AS IN2 FROM Ball_by_Ball WHERE Match_Id = 336011	soccer_2016
SELECT Ball_Id, Runs_Scored, Innings_No FROM Batsman_Scored WHERE Match_Id = 335988 AND Over_Id = 20	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` WHERE Match_Date LIKE '2011%'	soccer_2016
SELECT 2022 - SUBSTR(DOB, 1, 4) FROM Player WHERE Player_Name = 'Ishan Kishan'	soccer_2016
SELECT CAST(SUM(CASE WHEN Toss_Winner = Match_Winner THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN Match_Date LIKE '2012%' THEN 1 ELSE 0 END) FROM `Match`	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` WHERE Match_Date LIKE '2009%' AND Win_Margin < 10	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Match AS T3 ON T2.Match_Id = T3.Match_Id WHERE SUBSTR(T3.Match_Date, 1, 4) = '2014' AND SUBSTR(T3.Match_Date, 7, 1) = '6' LIMIT 2	soccer_2016
SELECT SUM(CASE WHEN T2.Player_Name = 'Mohammad Hafeez' THEN 1 ELSE 0 END) FROM Player_Match AS T1 INNER JOIN Player AS T2 ON T1.Player_Id = T2.Player_Id	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_Id WHERE T2.Country_Name = 'South Africa' AND T1.DOB LIKE '1984%'	soccer_2016
SELECT CAST(SUM(CASE WHEN T1.Match_Winner = T2.Team_Id THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Match_Id) FROM `Match` AS T1 INNER JOIN Team AS T2 ON T1.Team_1 = T2.Team_Id OR T1.Team_2 = T2.Team_Id WHERE T2.Team_Name = 'Mumbai Indians' AND T1.Match_Date LIKE '2009%'	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Batting_hand = 'Left-hand bat' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.Batting_hand = 'Right-hand bat' THEN 1 ELSE 0 END) FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id	soccer_2016
SELECT T1.Player_Name, T2.Country_Name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_Id ORDER BY T1.DOB LIMIT 1	soccer_2016
SELECT T1.Bowling_skill FROM Bowling_Style AS T1 INNER JOIN Player AS T2 ON T1.Bowling_Id = T2.Bowling_skill INNER JOIN Country AS T3 ON T2.Country_Name = T3.Country_Id WHERE T3.Country_Name = 'Zimbabwea'	soccer_2016
SELECT T1.Umpire_Id, T1.Umpire_Name FROM Umpire AS T1 INNER JOIN Country AS T2 ON T1.Umpire_Country = T2.Country_Id WHERE T2.Country_Name = 'New Zealand'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Team AS T3 ON T2.Team_Id = T3.Team_Id INNER JOIN Rolee AS T4 ON T2.Role_Id = T4.Role_Id WHERE T3.Team_Name = 'Rising Pune Supergiants' AND T4.Role_Desc = 'CaptainKeeper' GROUP BY T1.Player_Name	soccer_2016
SELECT SUM(CASE WHEN Match_Date LIKE '2013%' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Team AS T2 ON T1.Match_Winner = T2.Team_Id WHERE T2.Team_Name = 'Sunrisers Hyderabad'	soccer_2016
SELECT T1.Match_Id FROM Extra_Runs AS T1 INNER JOIN Extra_Type AS T2 ON T1.Extra_Type_Id = T2.Extra_Id WHERE T2.Extra_Name = 'penalty'	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Team_1 OR T1.Team_Id = T2.Team_2 INNER JOIN Win_By AS T3 ON T2.Win_Type = T3.Win_Id WHERE SUBSTR(T2.Match_Date, 1, 4) = '2015' AND T3.Win_Type = 'Tie' LIMIT 1	soccer_2016
SELECT CAST(COUNT(T1.Player_Out) AS REAL) / COUNT(T1.Match_Id), SUM(CASE WHEN T2.Out_Name = 'lbw' THEN 1 ELSE 0 END) FROM Wicket_Taken AS T1 INNER JOIN Out_Type AS T2 ON T1.Kind_Out = T2.Out_Id WHERE T1.Innings_No = 2	soccer_2016
SELECT COUNT(Match_Id) FROM `Match` WHERE Match_Date LIKE '2008%'	soccer_2016
SELECT COUNT(Match_Id) FROM Wicket_Taken WHERE innings_no = 2	soccer_2016
SELECT T1.Country_Name FROM Country AS T1 INNER JOIN city AS T2 ON T1.Country_Id = T2.Country_Id WHERE city_name = 'Rajkot'	soccer_2016
SELECT SUM(CASE WHEN T2.win_type = 'wickets' THEN 1 ELSE 0 END) FROM `Match` AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Team_1 WHERE T2.win_margin = 38 AND match_date = '2009-04-30'	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Player_Match AS T2 ON T1.Team_Id = T2.Team_Id INNER JOIN Player AS T3 ON T2.Player_Id = T3.Player_Id WHERE T2.match_id = 335989 AND T3.player_name = 'T Kohli'	soccer_2016
SELECT COUNT(T1.Venue_name) FROM Venue AS T1 INNER JOIN City AS T2 ON T1.City_Id = T2.City_Id INNER JOIN Country AS T3 ON T2.Country_Id = T3.Country_Id WHERE T3.country_name = 'South Africa' AND T2.city_name = 'Centurion'	soccer_2016
SELECT COUNT(T1.Match_Winner) FROM `Match` AS T1 INNER JOIN Team AS T2 ON T2.Team_Id = T1.Team_1 OR T2.Team_Id = T1.Team_2 WHERE T2.team_name = 'Delhi Daredevils' AND T1.Match_Date LIKE '2014%'	soccer_2016
SELECT T2.match_id FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner WHERE T1.team_name = 'Royal Challengers Bangalore' AND T2.match_date LIKE '2012%' ORDER BY T2.win_margin DESC LIMIT 1	soccer_2016
SELECT COUNT(T1.Match_Id) FROM Player_Match AS T1 INNER JOIN Player AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T1.Role_Id = T3.Role_Id WHERE T2.Player_Name = 'K Goel' AND T3.Role_Id = 3	soccer_2016
SELECT AVG(T1.win_margin) FROM Match AS T1 INNER JOIN Venue AS T2 ON T1.venue_id = T2.venue_id WHERE T2.venue_name = 'Newlands'	soccer_2016
SELECT Team_Name FROM Team WHERE Team_Id = ( SELECT CASE WHEN Team_1 = Match_Winner THEN Team_2 ELSE Team_1 END FROM Match WHERE match_id = 336039 )	soccer_2016
SELECT T1.Venue_Name FROM Venue AS T1 INNER JOIN Match AS T2 ON T1.venue_id = T2.venue_id WHERE T2.match_id = 829768	soccer_2016
SELECT T1.team_name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.team_2 ORDER BY T2.win_margin LIMIT 1	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Match_Winner = 7 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.Match_Winner) FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Match_Winner WHERE T2.Match_Date LIKE '2013%'	soccer_2016
SELECT SUM(CASE WHEN T3.Role_Id = 1 THEN 1 ELSE 0 END) - SUM(CASE WHEN T3.Role_Id > 1 THEN 1 ELSE 0 END) FROM Player_Match AS T1 INNER JOIN Player AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T1.Role_Id = T3.Role_Id WHERE T2.Player_Name = 'SC Ganguly'	soccer_2016
SELECT COUNT(Player_Name) FROM Player WHERE Bowling_skill > 2	soccer_2016
SELECT COUNT(Player_Name) FROM Player WHERE DOB LIKE '1970%'	soccer_2016
SELECT COUNT(Player_Name) FROM Player WHERE DOB LIKE '198%' AND Bowling_skill = 2	soccer_2016
SELECT COUNT(Match_Id) FROM Match WHERE Match_date LIKE '2008-04%'	soccer_2016
SELECT City_Name FROM City WHERE Country_ID = 3	soccer_2016
SELECT COUNT(Match_Id) FROM Match WHERE Match_Date LIKE '2008%' AND Match_Winner IS NOT NULL	soccer_2016
SELECT Country_id FROM City WHERE City_Name = 'East London'	soccer_2016
SELECT 2008 - strftime('%Y', DOB) FROM Player WHERE Player_Name = 'SC Ganguly'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id WHERE T2.Batting_hand = 'Left-hand bat'	soccer_2016
SELECT COUNT(T1.Player_Id) FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_ID WHERE T2.Country_Name = 'India'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_ID WHERE T2.Country_Name = 'England'	soccer_2016
SELECT T1.Venue_Name FROM Venue AS T1 INNER JOIN City AS T2 ON T1.City_ID = T2.City_ID WHERE T2.City_Name = 'Bangalore'	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match INNER JOIN Player_Match AS T3 ON T3.Player_Id = T1.Player_Id INNER JOIN Season AS T4 ON T2.Season_Id = T4.Season_Id WHERE T4.Season_Year = 2008 GROUP BY T1.Player_Name	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Batsman_Scored AS T3 ON T2.Match_ID = T3.Match_ID WHERE T3.Runs_Scored < 3 GROUP BY T1.Player_Name	soccer_2016
SELECT T3.Role_Desc FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T2.Role_Id = T3.Role_Id WHERE T1.Player_Name = 'SC Ganguly' GROUP BY T3.Role_Desc	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T2.Role_Id = T3.Role_Id WHERE T3.Role_Desc = 'Keeper' GROUP BY T1.Player_Name	soccer_2016
SELECT T1.Player_Name FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Team AS T3 ON T2.Team_Id = T3.Team_Id WHERE T3.Team_Id = 1 GROUP BY T1.Player_Name	soccer_2016
SELECT COUNT(T1.Player_Id) FROM Player_Match AS T1 INNER JOIN Match AS T2 ON T1.Match_Id = T2.Match_Id INNER JOIN Rolee AS T3 ON T1.Role_Id = T3.Role_Id WHERE T3.Role_Desc = 'Captain' AND T2.Match_Date LIKE '2008%'	soccer_2016
SELECT T5.Team_Name FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match INNER JOIN Player_Match AS T3 ON T3.Player_Id = T1.Player_Id INNER JOIN Season AS T4 ON T2.Season_Id = T4.Season_Id INNER JOIN Team AS T5 ON T3.Team_Id = T5.Team_Id WHERE T4.Season_Year = 2008 AND T1.Player_Name = 'SC Ganguly' GROUP BY T5.Team_Name	soccer_2016
SELECT T2.Win_Type FROM Match AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id WHERE T1.Match_Id = 336000	soccer_2016
SELECT T2.Country_Name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_ID WHERE T1.Player_Name = 'SB Joshi'	soccer_2016
SELECT COUNT(T1.Player_Id) FROM Player AS T1 INNER JOIN Bowling_Style AS T2 ON T1.Bowling_skill = T2.Bowling_Id WHERE T2.Bowling_skill = 'Left-arm fast'	soccer_2016
SELECT T2.Outcome_Type FROM Match AS T1 INNER JOIN Outcome AS T2 ON T1.Outcome_type = T2.Outcome_Id WHERE T1.Match_Id = '392195'	soccer_2016
SELECT T3.City_Name FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_Id INNER JOIN City AS T3 ON T2.Country_Id = T3.Country_Id ORDER BY T1.DOB LIMIT 1	soccer_2016
SELECT COUNT(DISTINCT T2.Match_Id) FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner INNER JOIN Player_Match AS T3 ON T1.Team_Id = T3.Team_Id INNER JOIN Season AS T4 ON T2.Season_Id = T4.Season_Id WHERE T1.Team_Name = 'Kings XI Punjab' AND T4.Season_Year = 2008	soccer_2016
SELECT COUNT(T.Season_Year) FROM ( SELECT T4.Season_Year FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner INNER JOIN Player_Match AS T3 ON T1.Team_Id = T3.Team_Id INNER JOIN Season AS T4 ON T2.Season_Id = T4.Season_Id WHERE T1.Team_Name = 'Pune Warriors' GROUP BY T4.Season_Year ) T	soccer_2016
SELECT T1.DOB, T3.Role_Desc FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T2.Role_Id = T3.Role_Id WHERE T1.Player_Name = 'R Dravid' GROUP BY T1.DOB, T3.Role_Desc	soccer_2016
SELECT COUNT(T2.Man_of_the_Match) FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match INNER JOIN Player_Match AS T3 ON T3.Player_Id = T1.Player_Id WHERE T1.Player_Name = 'SC Ganguly'	soccer_2016
SELECT COUNT(T.Match_Id) FROM ( SELECT T2.Match_Id FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner INNER JOIN Player_Match AS T3 ON T1.Team_Id = T3.Team_Id WHERE T1.Team_Name = 'Mumbai Indians' AND T2.Match_Date LIKE '2008%' GROUP BY T2.Match_Id ) T	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner INNER JOIN Player_Match AS T3 ON T1.Team_Id = T3.Team_Id INNER JOIN Win_By AS T4 ON T2.Win_Type = T4.Win_Id WHERE T2.Match_Id = '335993' GROUP BY T1.Team_Name	soccer_2016
SELECT COUNT(T1.Match_Id) FROM Match AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id WHERE T2.Win_type = 'wickets'	soccer_2016
SELECT T4.Role_Desc FROM Player AS T1 INNER JOIN Player_Match AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Match AS T3 ON T2.Match_Id = T3.Match_Id INNER JOIN Rolee AS T4 ON T2.Role_Id = T4.Role_Id INNER JOIN Season AS T5 ON T3.Season_Id = T5.Season_Id WHERE T1.Player_name = 'W Jaffer' AND T5.Season_Year = 2012	soccer_2016
SELECT CASE WHEN COUNT(T2.Man_of_the_Match) > 5 THEN T1.Player_Name ELSE 0 END FROM Player AS T1 INNER JOIN Match AS T2 ON T1.Player_Id = T2.Man_of_the_Match INNER JOIN Player_Match AS T3 ON T3.Player_Id = T1.Player_Id INNER JOIN Season AS T4 ON T2.Season_Id = T4.Season_Id WHERE T4.Season_Year = 2008	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Country_Name = 'India' THEN 1 ELSE 0 END) AS REAL) / COUNT(T1.Player_Id) FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_ID WHERE strftime('%Y', T1.DOB) BETWEEN '1975' AND '1985'	soccer_2016
SELECT CAST(SUM(CASE WHEN T2.Batting_hand = 'Left-hand bat' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Player_Id) FROM Player AS T1 INNER JOIN Batting_Style AS T2 ON T1.Batting_hand = T2.Batting_Id	soccer_2016
SELECT CAST(SUM(CASE WHEN T1.win_type = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.Win_Type) FROM Match AS T1 INNER JOIN Win_By AS T2 ON T1.Win_Type = T2.Win_Id	soccer_2016
SELECT COUNT(Match_Id) FROM Match WHERE win_margin = 7	soccer_2016
SELECT COUNT(Player_Id) FROM Player WHERE strftime('%Y', DOB) BETWEEN '1970' AND '1975'	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner WHERE T2.Win_Margin = 6 AND T2.Match_Date = '2009-04-26'	soccer_2016
SELECT T1.Team_Name FROM Team AS T1 INNER JOIN Match AS T2 ON T1.team_id = T2.match_winner INNER JOIN Win_By AS T3 ON T2.win_type = T3.win_id WHERE T2.Match_Id = 419135	soccer_2016
SELECT T2.Match_Id FROM Venue AS T1 INNER JOIN Match AS T2 ON T1.venue_id = T2.venue_id WHERE T1.Venue_Name = 'St George''s Park' ORDER BY T2.Win_Margin DESC LIMIT 1	soccer_2016
SELECT COUNT(*) FROM Player AS T1 INNER JOIN Country AS T2 ON T1.Country_Name = T2.Country_ID WHERE T2.Country_Name = 'Sri Lanka'	soccer_2016
SELECT T2.Player_Name FROM Player_Match AS T1 INNER JOIN Player AS T2 ON T1.Player_Id = T2.Player_Id INNER JOIN Rolee AS T3 ON T1.Role_Id = T3.Role_Id WHERE T3.Role_Desc = 'Captain' GROUP BY T2.Player_Name	soccer_2016
SELECT T1.Venue_Name, T3.Team_Name FROM Venue AS T1 INNER JOIN Match AS T2 ON T1.venue_id = T2.venue_id INNER JOIN Team AS T3 ON T2.match_winner = T3.Team_Id WHERE T2.Match_Id = 392194	soccer_2016
SELECT CAST(SUM(CASE WHEN T3.Win_Type = 'wickets' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.Win_Type) FROM Team AS T1 INNER JOIN Match AS T2 ON T1.Team_Id = T2.Match_Winner INNER JOIN Win_By AS T3 ON T2.Win_Type = T3.Win_Id WHERE T1.Team_Name = 'Delhi Daredevils'	soccer_2016
SELECT groupName FROM torrents WHERE artist LIKE 'ron hunt & ronnie g & the sm crew' AND groupYear = 1979 AND releaseType LIKE 'single' AND totalSnatched = 239	music_tracker
SELECT totalSnatched FROM torrents WHERE artist LIKE 'blowfly' AND groupYear = 1980	music_tracker
SELECT T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.releaseType = 'album' ORDER BY T1.totalSnatched DESC LIMIT 1	music_tracker
SELECT T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.releaseType = 'album' ORDER BY T1.totalSnatched DESC LIMIT 5	music_tracker
SELECT T1.groupName FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag LIKE 'funk' AND T1.releaseType = 'single' ORDER BY T1.groupYear LIMIT 1	music_tracker
SELECT T1.groupName FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag LIKE 'alternative' AND T1.releaseType = 'ep'	music_tracker
SELECT T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.releaseType = 'album' ORDER BY T1.totalSnatched LIMIT 5	music_tracker
SELECT T2.tag, T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.releaseType = 'single' ORDER BY T1.totalSnatched DESC LIMIT 1	music_tracker
SELECT COUNT(id) FROM tags WHERE tag LIKE '1980s'	music_tracker
SELECT totalSnatched FROM torrents WHERE groupName LIKE 'city funk'	music_tracker
SELECT groupName FROM torrents WHERE totalSnatched > 20000	music_tracker
SELECT T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupName = 'sugarhill gang'	music_tracker
SELECT COUNT(T2.tag) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupName = 'city funk'	music_tracker
SELECT T1.groupName FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = '1980s'	music_tracker
SELECT T1.groupName FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = '1980s' ORDER BY T1.totalSnatched DESC LIMIT 1	music_tracker
SELECT COUNT(T1.groupName) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'pop' AND T1.artist = 'michael jackson'	music_tracker
SELECT COUNT(T1.groupName) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'pop' AND T1.releaseType = 'album' AND T1.groupYear = 2000	music_tracker
SELECT CAST(SUM(T1.totalSnatched) AS REAL) / COUNT(T2.tag) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = '1980s'	music_tracker
SELECT groupName FROM torrents ORDER BY totalSnatched DESC LIMIT 3	music_tracker
SELECT artist, groupName FROM torrents WHERE groupYear = 2012 AND releaseType LIKE 'Single' ORDER BY totalSnatched DESC LIMIT 1	music_tracker
SELECT COUNT(id), ( SELECT COUNT(id) FROM torrents WHERE groupYear BETWEEN 2010 AND 2015 AND artist LIKE '50 cent' AND releaseType LIKE 'album' ) FROM torrents WHERE groupYear BETWEEN 2010 AND 2015 AND artist LIKE '50 cent' AND releaseType LIKE 'Single'	music_tracker
SELECT ( SELECT groupYear FROM torrents WHERE artist LIKE '2Pac' AND releaseType LIKE 'album' ORDER BY groupYear LIMIT 1, 1 ) - groupYear FROM torrents WHERE artist LIKE '2Pac' AND releaseType LIKE 'album' AND groupYear = 1991	music_tracker
SELECT AVG(totalSnatched) FROM torrents WHERE artist LIKE '2Pac' AND releaseType LIKE 'Single' AND groupYear BETWEEN 2001 AND 2013	music_tracker
SELECT T1.groupName, T1.groupYear, T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.releaseType = 'live album' ORDER BY T1.totalSnatched DESC LIMIT 1	music_tracker
SELECT artist FROM torrents WHERE groupYear = 2016 AND releaseType LIKE 'bootleg' GROUP BY artist HAVING COUNT(releaseType) > 2	music_tracker
SELECT artist FROM torrents WHERE groupYear BETWEEN 1980 AND 1982 AND releaseType LIKE 'single'	music_tracker
SELECT groupName FROM torrents WHERE totalSnatched >= 20 AND releaseType LIKE 'single' AND id BETWEEN 10 AND 20	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'disco' AND T1.groupYear BETWEEN 1980 AND 1982	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'funk' AND T1.groupYear = 1980 AND T1.totalSnatched <= 100	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'soul' AND T1.releaseType = 'single' GROUP BY T1.artist ORDER BY COUNT(T1.releaseType) DESC LIMIT 1	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'funk' AND T1.groupYear = 1980 AND T1.id BETWEEN 10 AND 30	music_tracker
SELECT T1.groupName FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'jazz' AND T1.groupYear >= 1982 ORDER BY T1.totalSnatched DESC LIMIT 1	music_tracker
SELECT T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.id = 16	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.id BETWEEN 10 AND 50 AND T2.tag LIKE 'new.york' ORDER BY T1.totalSnatched DESC LIMIT 1	music_tracker
SELECT COUNT(T1.artist) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'dance' AND T1.groupYear BETWEEN 1980 AND 1985 AND T1.releaseType LIKE 'album' OR T1.releaseType LIKE 'mixtape'	music_tracker
SELECT COUNT(T2.tag) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'soul' AND T1.groupYear BETWEEN 1979 AND 1981 AND T1.releaseType LIKE 'single'	music_tracker
SELECT COUNT(releaseType) FROM torrents WHERE releaseType LIKE 'single' AND groupYear = 1979	music_tracker
SELECT COUNT(releaseType) FROM torrents WHERE artist LIKE 'sugar daddy' AND releaseType LIKE 'Single' AND groupYear = 1980	music_tracker
SELECT COUNT(T1.id) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T2.tag = 'christmas' AND T1.groupYear = 2004 AND T1.releaseType LIKE 'album'	music_tracker
SELECT T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupYear BETWEEN 2000 AND 2010 AND T1.artist LIKE 'kurtis blow'	music_tracker
SELECT T1.groupName, T2.tag FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupYear = 1980 AND T1.artist LIKE 'millie jackson' AND T1.releaseType LIKE 'album'	music_tracker
SELECT T1.groupName FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupYear = 2005 AND T2.tag LIKE 'jazz'	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupYear BETWEEN 1980 AND 2000 AND T2.tag LIKE 'disco' GROUP BY T1.artist ORDER BY COUNT(T2.tag) DESC LIMIT 1	music_tracker
SELECT T1.artist FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.releaseType = 'single' AND T2.tag LIKE '1970s'	music_tracker
SELECT CAST(SUM(CASE WHEN T2.tag LIKE 'united.states' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.releaseType) FROM torrents AS T1 INNER JOIN tags AS T2 ON T1.id = T2.id WHERE T1.groupYear BETWEEN 1979 AND 1982 AND T1.releaseType LIKE 'album'	music_tracker
SELECT COUNT(CountryCode) FROM Country WHERE LendingCategory = 'IDA' AND OtherGroups = 'HIPC'	world_development_indicators
SELECT ShortName, ExternalDebtReportingStatus FROM Country WHERE LendingCategory = 'IDA'	world_development_indicators
SELECT T2.Description FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.ShortName = 'Aruba' AND T2.Seriescode = 'SM.POP.TOTL'	world_development_indicators
SELECT T1.SHORTNAME, T2.Description FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.Region = 'Latin America & Caribbean' AND T2.Seriescode = 'SM.POP.TOTL'	world_development_indicators
SELECT COUNT(T1.Countrycode) FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Seriescode = 'SM.POP.TOTL' AND T1.IncomeGroup = 'Low income'	world_development_indicators
SELECT T2.Description FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.LendingCategory = 'IDA' AND T2.Seriescode = 'SM.POP.TOTL'	world_development_indicators
SELECT COUNT(T1.Countrycode) FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.LendingCategory = 'IDA' AND T2.Seriescode = 'SM.POP.TOTL' AND IncomeGroup = 'Low income'	world_development_indicators
SELECT COUNT(T1.Countrycode) FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.IncomeGroup = 'High income: OECD' AND T1.CurrencyUnit = 'Euro' AND T2.Seriescode = 'SP.DYN.AMRT.FE'	world_development_indicators
SELECT T1.LongName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Estimates are derived FROM data on foreign-born population.' AND T2.Seriescode = 'SM.POP.TOTL'	world_development_indicators
SELECT T2.Description FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.ShortName = 'Aruba' AND T2.Seriescode = 'AG.LND.FRST.K2' AND T2.Year = 'YR1990'	world_development_indicators
SELECT T2.Year FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.ShortName = 'Aruba' AND T2.Seriescode = 'AG.LND.FRST.K2'	world_development_indicators
SELECT T1.SHORTNAME FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Data are classified as official aid.' AND T2.Seriescode = 'DC.DAC.AUSL.CD' AND T2.Year LIKE '%2002%'	world_development_indicators
SELECT COUNT(T2.SeriesCode) FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.ShortName = 'Aruba' AND T2.Year = 'YR2002'	world_development_indicators
SELECT COUNT(T2.Year) FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.ShortName = 'Aruba' AND T2.Seriescode = 'BX.KLT.DINV.CD.WD'	world_development_indicators
SELECT AVG(T2.Value) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName LIKE 'adolescent fertility rate%'	world_development_indicators
SELECT DISTINCT T1.SpecialNotes FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Value = ( SELECT Value FROM Indicators WHERE IndicatorName LIKE 'Adolescent fertility rate%' ORDER BY Value DESC LIMIT 1 )	world_development_indicators
SELECT CountryCode, Alpha2Code FROM Country WHERE Region = 'East Asia & Pacific' AND IncomeGroup = 'High income: nonOECD'	world_development_indicators
SELECT LongName, Alpha2Code FROM Country WHERE LatestTradeData = 2013 AND LatestWaterWithdrawalData = 2013	world_development_indicators
SELECT CAST(SUM(Value) AS REAL) / COUNT(CountryCode) FROM Indicators WHERE CountryName = 'Algeria' AND Year > 1974 AND Year < 1981 AND IndicatorName = 'Adjusted net enrolment rate, primary, both sexes (%)'	world_development_indicators
SELECT IndicatorName, AggregationMethod FROM Series WHERE Topic = 'Economic Policy & Debt: Balance of payments: Capital & financial account'	world_development_indicators
SELECT SeriesCode FROM Series WHERE Topic = 'Environment: Emissions' AND LicenseType = 'Restricted'	world_development_indicators
SELECT COUNT(T2.CountryCode)  FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Region = 'Middle East & North Africa' AND T1.IndicatorName = 'CO2 emissions FROM gaseous fuel consumption (kt)' AND T1.Year = 1970 AND T1.Value > 600	world_development_indicators
SELECT DISTINCT T1.CountryCode, T1.Year, T1.Value FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Region = 'Latin America & Caribbean' AND T1.IndicatorName = 'CO2 emissions (kt)' AND T1.Year > 1965 AND T1.Year < 1980 ORDER BY T1.Value DESC LIMIT 3	world_development_indicators
SELECT T2.Description FROM Series AS T1 INNER JOIN SeriesNotes AS T2 ON T1.SeriesCode = T2.Seriescode WHERE T1.SeriesCode = 'SP.DYN.TO65.MA.ZS' AND T1.Topic = 'Health: Mortality' AND T2.Year = 'YR1967'	world_development_indicators
SELECT DISTINCT T1.Description FROM FootNotes AS T1 INNER JOIN Country AS T2 ON T1.Countrycode = T2.CountryCode WHERE T1.Year = 'YR1981' AND T2.ShortName = 'Albania'	world_development_indicators
SELECT DISTINCT T1.Description FROM FootNotes AS T1 INNER JOIN Country AS T2 ON T1.Countrycode = T2.CountryCode WHERE T1.Year = 'YR1984' AND T2.ShortName = 'The Bahamas' AND T1.Seriescode = 'SH.DTH.IMRT'	world_development_indicators
SELECT T2.ShortName FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IndicatorName = 'Net bilateral aid flows FROM DAC donors, Sweden (current US$)' AND T1.Year = 1970 AND T1.Value = 570000	world_development_indicators
SELECT DISTINCT T1.Wb2code, T1.LendingCategory FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Data source : Human Mortality Database by University of California, Berkeley, and Max Planck Institute for Demographic Research.' AND T1.LendingCategory != ''	world_development_indicators
SELECT T2.Topic, T2.Seriescode, T2.LicenseType FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T1.Year = 1961 AND T1.CountryName = 'Haiti' AND T1.IndicatorName = 'Total reserves minus gold (current US$)' AND T1.Value = 3000000	world_development_indicators
SELECT COUNT(T1.CountryCode) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IndicatorName = 'Adjusted net national income per capita (constant 2005 US$)' AND T1.ExternalDebtReportingStatus = 'Preliminary' AND T2.Value > 1000	world_development_indicators
SELECT CountryName FROM Indicators WHERE Year = 1979 AND IndicatorName = 'Fertility rate, total (births per woman)' AND value >= 4 AND Value <= 5	world_development_indicators
SELECT TableName, SourceOfMostRecentIncomeAndExpenditureData FROM Country WHERE Region = 'South Asia' AND IncomeGroup = 'Low income'	world_development_indicators
SELECT DISTINCT T2.Source FROM Footnotes AS T1 INNER JOIN Series AS T2 ON T1.Seriescode = T2.SeriesCode INNER JOIN Country AS T3 ON T1.Countrycode = T3.CountryCode WHERE T3.Region = 'Latin America & Caribbean' AND T2.IndicatorName = 'Children out of school, primary'	world_development_indicators
SELECT T2.Source FROM CountryNotes AS T1 INNER JOIN Series AS T2 ON T1.Seriescode = T2.SeriesCode INNER JOIN Country AS T3 ON T1.Countrycode = T3.CountryCode INNER JOIN SeriesNotes AS T4 ON T2.SeriesCode = T4.Seriescode WHERE T4.Year LIKE '%2002%' AND T2.IndicatorName = 'Net migration'	world_development_indicators
SELECT DISTINCT T3.Description FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode INNER JOIN CountryNotes AS T3 ON T2.CountryCode = T3.Countrycode WHERE T1.Region = 'North America' AND T2.IndicatorName = 'Out-of-school children of primary school age, both sexes (number)'	world_development_indicators
SELECT DISTINCT T1.CountryCode, T2.Value FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.LatestTradeData = 2013 AND T2.IndicatorName LIKE 'GDP growth (annual %)' AND T2.year = 2014 AND T2.Value > 0 ORDER BY T2.Value ASC	world_development_indicators
SELECT DISTINCT T1.CountryCode, T3.Description FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode INNER JOIN CountryNotes AS T3 ON T1.CountryCode = T3.Countrycode WHERE T2.IndicatorName = 'Out-of-pocket health expenditure (% of private expenditure on health)' AND T2.Value > 0 AND T2.year = 2005 ORDER BY T2.Value DESC LIMIT 10	world_development_indicators
SELECT COUNT(CountryCode) FROM Country WHERE Region = 'South Asia' AND IncomeGroup = 'Low income'	world_development_indicators
SELECT ShortName FROM Country WHERE LatestTradeData > 2010	world_development_indicators
SELECT  CAST(SUM(CASE WHEN Region = 'Sub-Saharan Africa' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(CountryCode) FROM Country WHERE SystemOfTrade = 'Special trade system'	world_development_indicators
SELECT CAST(SUM(T2.Value) AS REAL) / COUNT(T1.CountryCode) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Region = 'Europe & Central Asia' AND T2.IndicatorName = 'Arms imports (SIPRI trend indicator values)'	world_development_indicators
SELECT T1.CountryCode FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup = 'Upper middle income' AND T2.IndicatorName = 'CO2 emissions (kt)' ORDER BY T2.Value ASC LIMIT 1	world_development_indicators
SELECT MIN(T2.Value) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.OtherGroups = 'HIPC' AND T2.IndicatorName = 'International migrant stock, total'	world_development_indicators
SELECT DISTINCT T2.IndicatorName FROM Footnotes AS T1 INNER JOIN Series AS T2 ON T1.Seriescode = T2.SeriesCode WHERE T1.Year = 'YR2000' AND T2.Topic = 'Education: Inputs'	world_development_indicators
SELECT COUNT(DISTINCT T2.SeriesCode)  FROM Footnotes AS T1 INNER JOIN Series AS T2 ON T1.Seriescode = T2.SeriesCode WHERE T1.Year IN ('YR2001', 'YR2002', 'YR2003') AND T2.Periodicity = 'Annual' AND T2.AggregationMethod = 'Sum'	world_development_indicators
SELECT T1.Seriescode, T2.Source FROM Footnotes AS T1 INNER JOIN Series AS T2 ON T1.Seriescode = T2.SeriesCode WHERE T1.Year LIKE '%2005%' AND T2.Source LIKE 'International Monetary Fund%'	world_development_indicators
SELECT CAST(SUM(CASE WHEN T2.value > 50 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.CountryCode) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Region = 'South Asia' AND T2.IndicatorName = 'Life expectancy at birth, female (years)'	world_development_indicators
SELECT CountryName FROM Indicators WHERE Year BETWEEN 1960 AND 1965 AND IndicatorName = 'Death rate, crude (per 1,000 people)' ORDER BY Value DESC LIMIT 1	world_development_indicators
SELECT IndicatorName FROM Indicators WHERE CountryName = 'Arab World' AND Year = 1960 AND Value > 50	world_development_indicators
SELECT CountryName FROM Indicators WHERE IndicatorName = 'Merchandise imports by the reporting economy (current US$)' ORDER BY Value DESC LIMIT 1	world_development_indicators
SELECT DISTINCT T2.IndicatorName FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T1.Year = 1965 AND T1.Value > 100 AND T2.Periodicity = 'Annual'	world_development_indicators
SELECT DISTINCT T1.IndicatorName FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T1.Year >= 1968 AND T1.Year < 1971 AND T2.LicenseType = 'Open' AND T1.Value < 100	world_development_indicators
SELECT T1.CountryName, T1.IndicatorName FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T2.Topic = 'Private Sector & Trade: Exports' ORDER BY T1.Value DESC LIMIT 1	world_development_indicators
SELECT T1.IndicatorName, MIN(T1.Value) FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T2.AggregationMethod = 'Weighted average'	world_development_indicators
SELECT T1.IndicatorName FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T1.CountryName = 'Sudan' AND T1.Year = 1961 AND T2.Periodicity = 'Annual'	world_development_indicators
SELECT CountryName FROM Indicators WHERE Value = ( SELECT MIN(T1.Value) FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName WHERE T1.Year >= 1960 AND T1.Year < 1966 AND T2.Topic = 'Health: Population: Structure' )	world_development_indicators
SELECT SUM(CASE WHEN T2.IndicatorName = 'CO2 emissions FROM liquid fuel consumption (% of total)' AND t2.Value < 80 THEN 1 ELSE 0 END) * 1.0 / COUNT(T1.CountryCode) persent FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup = 'Upper middle income'	world_development_indicators
SELECT DISTINCT IndicatorCode FROM Indicators WHERE IndicatorName = 'Rural population'	world_development_indicators
SELECT TableName  FROM Country WHERE SystemOfNationalAccounts = 'Country uses the 2008 System of National Accounts methodology.'	world_development_indicators
SELECT DISTINCT T2.SeriesCode FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.CurrencyUnit = 'Euro'	world_development_indicators
SELECT T1.LongName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.SeriesCode = 'DT.DOD.DSTC.CD'	world_development_indicators
SELECT T2.SeriesCode FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.CurrencyUnit = 'Hong Kong dollar'	world_development_indicators
SELECT T1.TableName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Seriescode = 'SP.DYN.TO65.MA.ZS'	world_development_indicators
SELECT DISTINCT T2.CountryName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup = 'Low income'	world_development_indicators
SELECT T2.SeriesCode, T2.CountryCode FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.Region = 'Latin America & Caribbean' AND t1.incomegroup = 'Low income'	world_development_indicators
SELECT T1.CountryCode, T2.SeriesCode FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.CurrencyUnit = 'Australian dollar' AND T1.IncomeGroup = 'Lower middle income'	world_development_indicators
SELECT DISTINCT T1.CountryName FROM indicators AS T1 INNER JOIN country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IncomeGroup = 'Upper middle income' UNION SELECT longname FROM ( SELECT longname FROM country WHERE NationalAccountsBaseYear <> '' ORDER BY NationalAccountsBaseYear ASC LIMIT 1 )	world_development_indicators
SELECT DISTINCT T1.CountryCode, T2.CountryName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.CurrencyUnit = 'Euro' AND (T1.IncomeGroup = 'High income: OECD' OR T1.IncomeGroup = 'High income: nonOECD')	world_development_indicators
SELECT T1.TableName, T1.CurrencyUnit FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.SeriesCode = 'FP.CPI.TOTL'	world_development_indicators
SELECT DISTINCT T1.CountryCode, T2.CountryName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup = 'High income: nonOECD'	world_development_indicators
SELECT DISTINCT T1.CountryCode, T1.CurrencyUnit, T1.IncomeGroup FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.CurrencyUnit = 'Pound sterling' AND T1.IncomeGroup LIKE '%high income%'	world_development_indicators
SELECT CountryCode, ShortName FROM Country LIMIT 10	world_development_indicators
SELECT COUNT(ShortName) FROM Country WHERE ShortName LIKE 'A%' UNION SELECT alpha2code FROM country WHERE shortname LIKE 'A%'	world_development_indicators
SELECT TableName FROM Country WHERE CurrencyUnit = 'Euro'	world_development_indicators
SELECT COUNT(LongName) FROM Country WHERE SpecialNotes = '' UNION SELECT longname FROM country WHERE specialnotes = ''	world_development_indicators
SELECT CountryCode, Region FROM Country WHERE (IncomeGroup = 'High income: OECD' OR IncomeGroup = 'High income: nonOECD') AND Region LIKE '%Asia%'	world_development_indicators
SELECT LongName FROM Country WHERE NationalAccountsBaseYear < '1980' AND NationalAccountsBaseYear != ''	world_development_indicators
SELECT T1.CountryCode FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.IncomeGroup = 'Low income' AND T2.Seriescode = 'DT.DOD.DECT.CD'	world_development_indicators
SELECT DISTINCT T1.TableName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Covers mainland Tanzania only.'	world_development_indicators
SELECT T2.Description, T2.Seriescode FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.TableName = 'Benin' AND T2.Year = 'YR2005'	world_development_indicators
SELECT DISTINCT T2.Description FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T1.TableName = 'Finland' AND T2.Year = 'YR2000'	world_development_indicators
SELECT DISTINCT T2.Year, T1.TableName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IndicatorName = 'Air transport, passengers carried'	world_development_indicators
SELECT DISTINCT T1.LongName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Year = 1980 AND T2.IndicatorName IS NOT NULL	world_development_indicators
SELECT T1.currencyunit, T2.IndicatorCode FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.TableName = 'Malaysia' AND T2.Year = 1970	world_development_indicators
SELECT DISTINCT T1.CountryCode, T1.Region FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode ORDER BY T2.Value DESC LIMIT 5	world_development_indicators
SELECT COUNT(DISTINCT T1.Countrycode) FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Sources: UN Energy Statistics (2014)' UNION SELECT DISTINCT t1.CurrencyUnit FROM country AS t1 INNER JOIN countrynotes AS t2 ON t1.CountryCode = t2.Countrycode WHERE t2.Description = 'Sources: UN Energy Statistics (2014)'	world_development_indicators
SELECT COUNT(T2.Description) FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Year = 'YR1980' UNION ALL SELECT DISTINCT T1.TableName FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Year = 'YR1980'	world_development_indicators
SELECT T2.seriescode, T1.Wb2Code FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Data sources : Eurostat'	world_development_indicators
SELECT T2.CountryName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup = 'Low income' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' ORDER BY T2.Value LIMIT 1	world_development_indicators
SELECT SUM(T2.Value) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup LIKE '%middle income' AND T2.Year = 1960 AND T2.IndicatorName = 'Urban population'	world_development_indicators
SELECT T2.countryname, T1.CurrencyUnit FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IndicatorName = 'Adjusted net national income (annual % growth)' AND T2.Year = 1980 AND T1.CurrencyUnit != '' ORDER BY T2.Value DESC LIMIT 1	world_development_indicators
SELECT COUNT(CountryCode) FROM Country WHERE SystemOfNationalAccounts = 'Country uses the 1993 System of National Accounts methodology.'	world_development_indicators
SELECT ShortName FROM Country WHERE VitalRegistrationComplete = 'Yes'	world_development_indicators
SELECT ShortName, LongName FROM Country WHERE LatestPopulationCensus >= 2010 AND LatestPopulationCensus < 2013 AND VitalRegistrationComplete = 'Yes'	world_development_indicators
SELECT CountryName FROM Indicators WHERE Year = 1960 AND IndicatorName = 'CO2 emissions (metric tons per capita)' ORDER BY Value DESC LIMIT 1	world_development_indicators
SELECT CAST(MAX(value) AS REAL) / MIN(value) FROM indicators WHERE indicatorname = 'Number of infant deaths' AND year = '1971' UNION ALL SELECT countryname FROM ( SELECT countryname, MAX(value) FROM indicators WHERE indicatorname = 'Number of infant deaths' AND year = '1971' ) UNION SELECT countryname FROM ( SELECT countryname, MIN(value) FROM indicators WHERE indicatorname = 'Number of infant deaths' AND year = '1971' )	world_development_indicators
SELECT T1.ShortName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.SeriesCode = 'SP.DYN.CBRT.IN'	world_development_indicators
SELECT DISTINCT T1.CountryCode FROM Country AS T1 INNER JOIN FootNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Data are classified as official aid.'	world_development_indicators
SELECT DISTINCT T1.ShortName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Estimates are based on regression.'	world_development_indicators
SELECT DISTINCT T1.CountryCode FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Year = 1970 AND T1.Region = 'East Asia & Pacific' AND T2.Value > 2000000 AND t2.indicatorname = 'Urban population'	world_development_indicators
SELECT MAX(T2.Value) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IncomeGroup = 'Upper middle income' AND T2.Year = 1960 AND T2.IndicatorName = 'Population, total'	world_development_indicators
SELECT COUNT(CountryCode)  FROM Country WHERE SystemOfNationalAccounts = 'Country uses the 1968 System of National Accounts methodology.'	world_development_indicators
SELECT DISTINCT T1.ShortName FROM Country AS T1 INNER JOIN footnotes AS T2 ON T1.CountryCode = T2.CountryCode INNER JOIN Series AS T3 ON T2.Seriescode = T3.SeriesCode WHERE T1.IncomeGroup = 'Upper middle income' AND T1.Region = 'East Asia & Pacific' AND T3.Topic = 'Social Protection & Labor: Migration'	world_development_indicators
SELECT DISTINCT T1.LongName FROM Country AS T1 INNER JOIN footnotes AS T2 ON T1.CountryCode = T2.Countrycode INNER JOIN Series AS T3 ON T2.Seriescode = T3.SeriesCode WHERE T3.Topic = 'Poverty: Shared prosperity'	world_development_indicators
SELECT DISTINCT T1.TableName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.LatestTradeData = 2013 AND T2.IndicatorCode = 'SP.DYN.CDRT.IN'	world_development_indicators
SELECT DISTINCT T3.LongName FROM SeriesNotes AS T1 INNER JOIN CountryNotes AS T2 ON T1.SeriesCode = T2.Seriescode INNER JOIN Country AS T3 ON T2.Countrycode = T3.CountryCode WHERE T3.Region = 'Sub-Saharan Africa' AND T1.SeriesCode = 'SP.DYN.AMRT.FE'	world_development_indicators
SELECT ShortName FROM country WHERE currencyunit = 'U.S. dollar' LIMIT 3	world_development_indicators
SELECT LongName FROM Country WHERE IncomeGroup = 'Low income' AND Region = 'South Asia'	world_development_indicators
SELECT LongName FROM Country WHERE SystemOfTrade = 'Special trade system' LIMIT 2	world_development_indicators
SELECT CountryName FROM Indicators WHERE IndicatorName LIKE 'CO2 emissions FROM transport%' ORDER BY Value DESC LIMIT 1	world_development_indicators
SELECT CountryName FROM Indicators WHERE IndicatorName LIKE 'Arable land (% of land area)' ORDER BY Value DESC LIMIT 1	world_development_indicators
SELECT DISTINCT Topic FROM Series WHERE LicenseType = 'Restricted'	world_development_indicators
SELECT CountryCode FROM Country WHERE IncomeGroup = 'Upper middle income' AND ExternalDebtReportingStatus = 'Preliminary'	world_development_indicators
SELECT CAST(SUM(CASE WHEN ExternalDebtReportingStatus = 'Actual' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(CountryCode) FROM Country WHERE region = 'Middle East & North Africa'	world_development_indicators
SELECT SUM(CASE WHEN GovernmentAccountingConcept = 'Budgetary central government' THEN 1 ELSE 0 END), SUM(CASE WHEN GovernmentAccountingConcept = 'Consolidated central government' THEN 1 ELSE 0 END) central_nums FROM country WHERE ExternalDebtReportingStatus = 'Actual'	world_development_indicators
SELECT COUNT(CountryCode)  FROM Country WHERE Region = 'East Asia & Pacific' AND ExternalDebtReportingStatus = 'Estimate'	world_development_indicators
SELECT SUM(CASE WHEN IncomeGroup = 'Lower middle income' THEN 1 ELSE 0 END) * 100.0 / COUNT(CountryCode) persentage FROM Country WHERE Region = 'Sub-Saharan Africa'	world_development_indicators
SELECT MAX(T1.Value) FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Year >= 1961 AND T1.Year < 1981 AND T1.IndicatorName LIKE 'Agricultural land (% of land area)' AND T2.LongName = 'Republic of Benin'	world_development_indicators
SELECT DISTINCT T2.LongName FROM CountryNotes AS T1 INNER JOIN Country AS T2 ON T1.Countrycode = T2.CountryCode WHERE T1.Description = 'Sources: UN Energy Statistics (2014)' LIMIT 3	world_development_indicators
SELECT T1.Value FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.LongName = 'Commonwealth of Australia' AND T1.IndicatorName = 'Deposit interest rate (%)' AND T1.Year = 1979	world_development_indicators
SELECT T1.Seriescode, T1.Description FROM CountryNotes AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.ShortName = 'Germany'	world_development_indicators
SELECT DISTINCT T3.Topic FROM CountryNotes AS T1 INNER JOIN Country AS T2 ON T1.Countrycode = T2.CountryCode INNER JOIN Series AS T3 ON T1.Seriescode = T3.SeriesCode WHERE T2.ShortName = 'Austria'	world_development_indicators
SELECT DISTINCT T1.Topic, T2.Description FROM Series AS T1 INNER JOIN SeriesNotes AS T2 ON T1.SeriesCode = T2.Seriescode WHERE T1.SeriesCode = 'SP.DYN.AMRT.MA'	world_development_indicators
SELECT COUNT(DISTINCT T1.CountryCode)  FROM Country AS T1 INNER JOIN Footnotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Unspecified' OR T2.Description = 'Not specified' UNION SELECT T1.LongName FROM Country AS T1 INNER JOIN Footnotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Description = 'Unspecified' OR T2.Description = 'Not specified' LIMIT 4	world_development_indicators
SELECT T2.CountryCode FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IndicatorName LIKE 'Land under cereal production%' AND T1.Value = 3018500 AND T1.Year = 1980 AND T2.ExternalDebtReportingStatus = 'Actual'	world_development_indicators
SELECT CAST(SUM(CASE WHEN T1.Value > 50 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.CountryCode) FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Year = 1961 AND T2.Region = 'Latin America & Caribbean' AND indicatorname = 'Agricultural land (% of land area)'	world_development_indicators
SELECT LongName FROM Country WHERE IncomeGroup = 'Low income' AND Region = 'South Asia'	world_development_indicators
SELECT DISTINCT IndicatorCode FROM Indicators WHERE CountryName = 'Brazil' AND IndicatorName = 'Mobile cellular subscriptions'	world_development_indicators
SELECT COUNT(longname) FROM country WHERE region = 'Europe & Central Asia' AND currencyunit = 'Danish krone' UNION SELECT longname FROM country WHERE currencyunit = 'Danish krone' AND region = 'Europe & Central Asia'	world_development_indicators
SELECT countryname, MAX(value) FROM indicators WHERE indicatorname = 'Rural population (% of total population)'	world_development_indicators
SELECT COUNT(LongName) FROM country WHERE LatestPopulationCensus = '2011' UNION ALL SELECT LongName FROM country WHERE LatestPopulationCensus = '2011'	world_development_indicators
SELECT Value FROM Indicators WHERE IndicatorName = 'Agricultural land (sq. km)' AND Year = 1968 AND CountryName = 'Italy'	world_development_indicators
SELECT MAX(T1.value), T1.year FROM indicators AS T1 INNER JOIN country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Region = 'Sub-Saharan Africa' AND T1.IndicatorName = 'Out-of-school children of primary school age, female (number)'	world_development_indicators
SELECT DISTINCT T3.Seriescode FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode INNER JOIN CountryNotes AS T3 ON T2.CountryCode = T3.Countrycode WHERE T2.IndicatorName = 'Number of infant deaths' AND T1.LongName = 'Islamic State of Afghanistan' AND T2.Year = 1965	world_development_indicators
SELECT COUNT(DISTINCT T1.CountryCode) FROM indicators AS T1 INNER JOIN country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Region = 'Middle East & North Africa' AND T2.SystemOfNationalAccounts = 'Country uses the 1968 System of National Accounts methodology.' AND T1.IndicatorName = 'CO2 emissions FROM solid fuel consumption (kt)' UNION SELECT * FROM ( SELECT T1.CountryName FROM indicators AS T1 INNER JOIN country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Region = 'Middle East & North Africa' AND T2.SystemOfNationalAccounts = 'Country uses the 1968 System of National Accounts methodology.' AND T1.IndicatorName = 'CO2 emissions FROM solid fuel consumption (kt)' GROUP BY T1.CountryName ORDER BY SUM(T1.value) DESC LIMIT 1 )	world_development_indicators
SELECT DISTINCT T1.IndicatorCode FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Year = 1960 AND T2.LongName = 'Republic of Albania'	world_development_indicators
SELECT T1.LendingCategory FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IndicatorName = 'Cereal production (metric tons)' AND T2.Value = 6140000 AND T2.Year = 1966	world_development_indicators
SELECT T2.CountryCode, T2.Region FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IndicatorName = 'Population in largest city' AND T1.Year >= 1960 AND T1.Year < 1980 ORDER BY T2.Region DESC LIMIT 1	world_development_indicators
SELECT SUM(T1.Value), T1.Year FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IndicatorName = 'CO2 emissions (kt)' AND T1.Year >= 1975 AND T1.Year < 1981 AND T1.CountryCode = 'WLD' AND T2.SpecialNotes = 'World aggregate.'	world_development_indicators
SELECT T1.CountryName, SUM(T1.Value) area, T2.IncomeGroup FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IndicatorName = 'Land area (sq. km)' AND T1.Year >= 1961 AND T1.Year < 1980 GROUP BY T1.CountryCode ORDER BY SUM(T1.Value) ASC LIMIT 1	world_development_indicators
SELECT AVG(T1.Value), T2.SystemOfTrade FROM Indicators AS T1 INNER JOIN Country AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.IndicatorName = 'Air transport, passengers carried' AND T1.Year >= 1970 AND T1.Year < 1981 AND T1.CountryName = 'Bulgaria'	world_development_indicators
SELECT LatestHouseholdSurvey, PppSurveyYear FROM Country WHERE ShortName = 'Angola'	world_development_indicators
SELECT COUNT(CountryCode) FROM Country WHERE VitalRegistrationComplete = 'Yes' AND Region = 'North America'	world_development_indicators
SELECT T2.Year FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)'	world_development_indicators
SELECT T1.LongName FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IndicatorName = 'Arms exports (SIPRI trend indicator values)' AND T2.Year = 1960 AND T2.Value = 3000000	world_development_indicators
SELECT T1.Alpha2Code FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.IndicatorName = 'Rural population' AND T2.Year = 1960	world_development_indicators
SELECT DISTINCT T1.CountryCode, T1.SpecialNotes FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T2.Value = ( SELECT Value FROM Indicators WHERE IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND Year = 1960 ORDER BY Value DESC LIMIT 1 )	world_development_indicators
SELECT ( SELECT T2.Value FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND T2.Year = 1961 ) - ( SELECT T2.Value FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND T2.Year = 1960 ) DIFF	world_development_indicators
SELECT T2.Description FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode WHERE T2.Seriescode = 'SP.ADO.TFRT' AND T1.ShortName = 'Australia'	world_development_indicators
SELECT T2.Description FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode INNER JOIN Series AS T3 ON T2.Seriescode = T3.SeriesCode WHERE T1.ShortName = 'Aruba' AND T3.Topic = 'Environment: Energy production & use'	world_development_indicators
SELECT T1.ShortName FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode INNER JOIN Series AS T3 ON T2.Seriescode = T3.SeriesCode WHERE T3.Seriescode = 'BX.KLT.DINV.CD.WD'	world_development_indicators
SELECT T1.Region FROM Country AS T1 INNER JOIN CountryNotes AS T2 ON T1.CountryCode = T2.Countrycode INNER JOIN Series AS T3 ON T2.Seriescode = T3.SeriesCode WHERE T3.IndicatorName = 'Inflation, consumer prices (annual %)'	world_development_indicators
SELECT COUNT(T1.Countrycode)  FROM CountryNotes AS T1 INNER JOIN Series AS T2 ON T1.Seriescode = T2.SeriesCode WHERE T2.IndicatorName = 'Stocks traded, turnover ratio of domestic shares (%)'	world_development_indicators
SELECT T2.AggregationMethod FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName INNER JOIN Country AS T3 ON T1.CountryCode = T3.CountryCode WHERE T3.ShortName = 'Arab World' AND T1.Value = 133 AND T1.Year = 1960	world_development_indicators
SELECT T1.Value FROM Indicators AS T1 INNER JOIN Series AS T2 ON T1.IndicatorName = T2.IndicatorName INNER JOIN Country AS T3 ON T1.CountryCode = T3.CountryCode WHERE T2.LongDefinition = 'Adolescent fertility rate is the number of births per 1,000 women ages 15-19.' AND T3.ShortName = 'Arab World' AND T1.Year = 1960	world_development_indicators
SELECT (( SELECT T2.Value FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND T2.Year = 1961 ) - ( SELECT T2.Value FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND T2.Year = 1960 )) * 1.0 / ( SELECT SUM(T2.Value) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)' AND T2.Year = 1960 )	world_development_indicators
SELECT CAST(SUM(T2.Value) AS REAL) * 100 / COUNT(T2.Year) FROM Country AS T1 INNER JOIN Indicators AS T2 ON T1.CountryCode = T2.CountryCode WHERE T1.Alpha2Code = '1A' AND T2.IndicatorName = 'Adolescent fertility rate (births per 1,000 women ages 15-19)'	world_development_indicators
SELECT DISTINCT T2.directorid FROM u2base AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.rating > 4	movielens
SELECT COUNT(T1.userid) FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.rating = 5 AND T2.u_gender = 'M'	movielens
SELECT T2.genre FROM movies2actors AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T1.actorid = T3.actorid WHERE T3.actorid = 851	movielens
SELECT COUNT(T1.movieid) FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'USA' AND T1.rating < 3	movielens
SELECT COUNT(T1.movieid) FROM movies2directors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'France' AND T1.genre = 'drama'	movielens
SELECT AVG(T2.occupation) FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.rating < 2	movielens
SELECT T1.movieid FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'USA' GROUP BY T1.movieid ORDER BY AVG(T1.rating) DESC LIMIT 10	movielens
SELECT AVG(T2.cast_num) FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'USA'	movielens
SELECT DISTINCT T1.movieid FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'other' AND T2.isEnglish = 'F' LIMIT 5	movielens
SELECT COUNT(T1.actorid) FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid INNER JOIN u2base AS T3 ON T2.movieid = T3.movieid WHERE T1.a_quality = 5 AND T3.rating = 5	movielens
SELECT AVG(T1.rating) FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'france' AND T2.year = 4	movielens
SELECT COUNT(T1.movieid) FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'UK' AND T2.runningtime < 2 AND T1.rating = 5	movielens
SELECT T1.userid FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid INNER JOIN users AS T3 ON T1.userid = T3.userid WHERE T2.country = 'France' AND T2.runningtime = 2 AND T1.rating < 3 AND T3.u_gender = 'M'	movielens
SELECT COUNT(T1.userid) FROM u2base AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T2.actorid = T3.actorid INNER JOIN users AS T4 ON T1.userid = T4.userid WHERE T3.a_quality = 0 AND T1.rating > 3 AND T4.u_gender = 'F'	movielens
SELECT userid FROM u2base WHERE rating = 5 GROUP BY userid ORDER BY COUNT(movieid) DESC LIMIT 1	movielens
SELECT T2.actorid, T4.genre FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T2.actorid = T3.actorid INNER JOIN movies2directors AS T4 ON T1.movieid = T4.movieid WHERE T4.directorid = 22397	movielens
SELECT T2.actorid, T1.directorid FROM movies2directors AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.genre = 'Action'	movielens
SELECT COUNT(T2.actorid) FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T2.actorid = T3.actorid WHERE T3.a_gender = 'F' AND T1.year = 4	movielens
SELECT T2.actorid FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T2.actorid = T3.actorid WHERE T3.a_quality = 3 AND T1.country = 'USA' AND T1.isEnglish = 'T'	movielens
SELECT T1.movieid FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid INNER JOIN directors AS T3 ON T2.directorid = T3.directorid WHERE T1.runningtime = 3 AND T3.avg_revenue = 1	movielens
SELECT T2.genre FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'UK'	movielens
SELECT T1.genre FROM movies2directors AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid INNER JOIN users AS T3 ON T2.userid = T3.userid WHERE T3.age = 18 GROUP BY T1.genre ORDER BY COUNT(T1.movieid) DESC LIMIT 1	movielens
SELECT T3.actorid FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid INNER JOIN movies2actors AS T3 ON T2.movieid = T3.movieid WHERE T1.occupation = 5 GROUP BY T2.movieid ORDER BY COUNT(T1.userid) DESC LIMIT 1	movielens
SELECT DISTINCT T2.age FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.rating = 3	movielens
SELECT T3.country FROM movies2directors AS T1 INNER JOIN directors AS T2 ON T1.directorid = T2.directorid INNER JOIN movies AS T3 ON T1.movieid = T3.movieid WHERE T1.genre = 'Action' GROUP BY T3.country ORDER BY COUNT(T3.country) DESC LIMIT 1	movielens
SELECT T2.movieid FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid GROUP BY T2.actorid ORDER BY AVG(T1.a_quality) DESC LIMIT 5	movielens
SELECT T1.movieid FROM movies2directors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'UK' AND T1.genre = 'Adventure' AND T2.isEnglish = 'F' LIMIT 5	movielens
SELECT CAST(SUM(IIF(T2.u_gender = 'F', 1, 0)) AS REAL) * 100 / COUNT(T2.userid) FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.rating = 2	movielens
SELECT SUM(IIF(T2.u_gender = 'F', 1, 0)) - SUM(IIF(T2.u_gender = 'M', 1, 0)) FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid INNER JOIN movies2directors AS T3 ON T3.movieid = T1.movieid WHERE T3.genre = 'horror'	movielens
SELECT T2.genre FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.year = 4 AND T1.isEnglish = 'T'	movielens
SELECT COUNT(T1.movieid) FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'USA' AND T1.isEnglish = 'F' AND T2.genre = 'Action'	movielens
SELECT COUNT(T1.movieid) FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.rating = 5 AND T2.age < 18 AND T2.u_gender = 'M'	movielens
SELECT T1.movieid FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T2.u_gender = 'F' GROUP BY T1.movieid ORDER BY COUNT(T2.userid) DESC LIMIT 1	movielens
SELECT COUNT(DISTINCT T1.movieid) FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'UK' AND T1.rating = 5	movielens
SELECT DISTINCT T1.movieid FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.year = 4 AND T1.rating = 1	movielens
SELECT COUNT(DISTINCT T1.movieid) FROM movies AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid WHERE T1.year = 1 AND T2.rating = 1 AND T1.isEnglish = 'T'	movielens
SELECT COUNT(DISTINCT T2.userid) FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid INNER JOIN movies AS T3 ON T2.movieid = T3.movieid WHERE T1.u_gender = 'F' AND T3.country = 'France'	movielens
SELECT COUNT(DISTINCT T2.directorid) FROM movies2directors AS T2 INNER JOIN directors AS T3 ON T2.directorid = T3.directorid WHERE T2.genre = 'Action' AND T3.d_quality = 4	movielens
SELECT T2.genre FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.avg_revenue = 4	movielens
SELECT COUNT(DISTINCT T1.actorid) FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid INNER JOIN movies AS T3 ON T2.movieid = T3.movieid WHERE T3.isEnglish = 'T' AND T1.a_gender = 'M' AND T1.a_quality = 5	movielens
SELECT T3.country FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid INNER JOIN movies AS T3 ON T2.movieid = T3.movieid WHERE T1.a_gender = 'F' AND T1.a_quality = 0	movielens
SELECT AVG(T2.rating) FROM movies AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid INNER JOIN movies2directors AS T3 ON T1.movieid = T3.movieid WHERE T1.country = 'USA' AND T3.genre = 'Action' GROUP BY T1.movieid ORDER BY AVG(T2.rating) DESC LIMIT 1	movielens
SELECT COUNT(*) FROM ( SELECT DISTINCT T2.movieid FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid INNER JOIN u2base AS T3 ON T2.movieid = T3.movieid WHERE T1.d_quality = 5 GROUP BY T2.movieid HAVING AVG(T3.rating) > 3.5 ) AS T1	movielens
SELECT T1.movieid FROM movies2directors AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid WHERE T1.genre = 'Adventure' GROUP BY T1.movieid ORDER BY AVG(T2.rating) DESC LIMIT 1	movielens
SELECT COUNT(T1.userid) FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid WHERE T2.userid = 2462959 AND T1.u_gender = 'F'	movielens
SELECT DISTINCT T1.movieid FROM movies AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid WHERE T1.runningtime = 0 AND T2.rating = ( SELECT MAX(rating) FROM u2base )	movielens
SELECT T1.actorid, T1.a_quality FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid WHERE T2.movieid = 1722327	movielens
SELECT T1.directorid FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.d_quality = 5 GROUP BY T1.directorid ORDER BY COUNT(T2.movieid) DESC LIMIT 1	movielens
SELECT COUNT(DISTINCT T2.movieid) FROM u2base AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T2.genre = 'drama' AND T1.rating = 3	movielens
SELECT COUNT(T1.movieid) FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.rating = 5 AND T2.age BETWEEN 25 AND 35	movielens
SELECT T1.movieid FROM u2base AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.rating = 1 AND T2.genre = 'Horror'	movielens
SELECT T2.directorid FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'France'	movielens
SELECT T2.userid, T2.age FROM u2base AS T1 INNER JOIN users AS T2 ON T1.userid = T2.userid WHERE T1.movieid = 1695219	movielens
SELECT T2.genre FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.isEnglish = 'F' GROUP BY T2.genre ORDER BY COUNT(T1.movieid) DESC LIMIT 1	movielens
SELECT T1.actorid, T2.directorid FROM movies2actors AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.movieid = 1949144	movielens
SELECT CAST(SUM(IIF(T3.a_quality >= 3, 1, 0)) AS REAL) * 100 / COUNT(T1.movieid) FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T2.actorid = T3.actorid WHERE T1.country = 'UK'	movielens
SELECT CAST(SUM(IIF(T2.avg_revenue > T2.d_quality, 1, 0)) AS REAL) * 100 / COUNT(T1.movieid) FROM movies2directors AS T1 INNER JOIN directors AS T2 ON T1.directorid = T2.directorid WHERE T1.genre = 'Action'	movielens
SELECT T1.actorid FROM movies2actors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.year = 4	movielens
SELECT T2.actorid FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.runningtime = 2 AND T1.isEnglish = 'T'	movielens
SELECT T2.actorid FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'France' GROUP BY T2.actorid HAVING COUNT(T1.movieid) > 2	movielens
SELECT COUNT(T2.actorid) FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'USA' AND T2.cast_num > 1	movielens
SELECT DISTINCT T1.movieid FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.year = 1 AND T2.cast_num = 0	movielens
SELECT COUNT(T1.actorid) FROM movies2actors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'USA' OR T2.country = 'UK'	movielens
SELECT COUNT(T1.directorid) FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.avg_revenue = 4 AND (T2.genre = 'Adventure' OR T2.genre = 'Action')	movielens
SELECT T1.directorid FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.d_quality >= 3 GROUP BY T1.directorid HAVING COUNT(T2.movieid) >= 2	movielens
SELECT COUNT(T1.movieid) FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'USA' AND T2.genre = 'comedy'	movielens
SELECT COUNT(T1.movieid) FROM movies2directors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.year = 4 AND T1.genre IN ('Action', 'drama')	movielens
SELECT T1.movieid FROM movies2directors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.runningtime >= 2 AND T1.genre = 'Horror'	movielens
SELECT CAST(SUM(IIF(T1.rating = 1, 1, 0)) AS REAL) * 100 / COUNT(T1.movieid) FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'USA'	movielens
SELECT COUNT(DISTINCT T1.movieid) FROM movies2directors AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid WHERE T2.rating = 1 AND T1.genre = 'comedy'	movielens
SELECT DISTINCT T1.avg_revenue FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.d_quality = 5	movielens
SELECT COUNT(movieid) FROM movies WHERE country = 'France' AND movieid IN ( SELECT movieid FROM u2base WHERE rating = ( SELECT MAX(rating) FROM u2base ) )	movielens
SELECT T2.movieid FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid WHERE T1.age = 25 GROUP BY T2.movieid ORDER BY COUNT(T1.userid) DESC LIMIT 1	movielens
SELECT COUNT(DISTINCT T2.userid) FROM movies AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid INNER JOIN users AS T3 ON T2.userid = T3.userid WHERE T1.country = 'UK' AND T3.age = 35	movielens
SELECT T1.userid, T1.age FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid WHERE T2.movieid = '2409051' AND T2.rating = 2	movielens
SELECT DISTINCT T1.movieid FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T1.rating = 5 AND T2.year = 1	movielens
SELECT DISTINCT T1.movieid FROM u2base AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid WHERE T2.country = 'France' AND T1.rating = 1	movielens
SELECT COUNT(T2.actorid) FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.country IN ('France', 'USA')	movielens
SELECT COUNT(DISTINCT T2.actorid) FROM u2base AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid WHERE T1.rating = 5	movielens
SELECT T2.movieid FROM u2base AS T2 INNER JOIN movies2directors AS T3 ON T2.movieid = T3.movieid WHERE T3.genre = 'Crime' GROUP BY T2.movieid ORDER BY AVG(T2.rating) LIMIT 1	movielens
SELECT CAST(SUM(IIF(T3.a_gender = 'M', 1, 0)) AS REAL) / SUM(IIF(T3.a_gender = 'F', 1, 0)) FROM movies AS T1 INNER JOIN movies2actors AS T2 ON T1.movieid = T2.movieid INNER JOIN actors AS T3 ON T2.actorid = T3.actorid WHERE T1.country = 'UK'	movielens
SELECT COUNT(T1.userid) FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid WHERE T2.rating = 3 AND T2.movieid = '1711133' AND T1.age = 35 AND T1.u_gender = 'F'	movielens
SELECT COUNT(T2.userid) FROM movies AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'UK' AND T1.runningtime = 2 AND T2.rating = 1 AND T1.year = 2	movielens
SELECT DISTINCT T1.directorid FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.d_quality = 3 AND T1.avg_revenue = 2 AND T2.genre != 'Comedy'	movielens
SELECT CAST(SUM(IIF(T2.cast_num = 2 AND T1.a_quality = 2, 1, 0)) AS REAL) * 100 / COUNT(T1.actorid) FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid WHERE T2.movieid = 1672580 AND T1.a_gender = 'F'	movielens
SELECT CAST(SUM(IIF(a_gender = 'M', 1, 0)) AS REAL) / SUM(IIF(a_gender = 'F', 1, 0)) FROM actors WHERE a_quality = 0	movielens
SELECT actorid FROM movies2actors GROUP BY actorid ORDER BY COUNT(movieid) DESC LIMIT 1	movielens
SELECT genre FROM movies2directors GROUP BY genre ORDER BY COUNT(movieid) DESC LIMIT 1	movielens
SELECT T2.genre FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid WHERE T1.d_quality = 0 GROUP BY T2.genre ORDER BY COUNT(T2.movieid) DESC LIMIT 1	movielens
SELECT T2.movieid FROM movies AS T1 INNER JOIN u2base AS T2 ON T1.movieid = T2.movieid WHERE T1.isEnglish = 'F' AND T1.country = 'USA' ORDER BY T2.rating LIMIT 1	movielens
SELECT CAST(SUM(CASE WHEN T1.d_quality = 4 AND T1.avg_revenue = 4 THEN 1 ELSE 0 END) AS REAL) / COUNT(T2.movieid) FROM directors AS T1 INNER JOIN movies2directors AS T2 ON T1.directorid = T2.directorid	movielens
SELECT T2.movieid FROM users AS T1 INNER JOIN u2base AS T2 ON T1.userid = T2.userid INNER JOIN movies AS T3 ON T2.movieid = T3.movieid WHERE T1.u_gender = 'F' AND T1.occupation = 3 AND T2.rating = 5	movielens
SELECT SUM(IIF(T1.a_gender = 'F', 1, 0)) , T3.country, T3.runningtime FROM actors AS T1 INNER JOIN movies2actors AS T2 ON T1.actorid = T2.actorid INNER JOIN movies AS T3 ON T2.movieid = T3.movieid WHERE T2.movieid = 2312852 GROUP BY T3.country, T3.runningtime	movielens
SELECT COUNT(T1.movieid) FROM movies2directors AS T1 INNER JOIN movies AS T2 ON T1.movieid = T2.movieid INNER JOIN directors AS T3 ON T1.directorid = T3.directorid WHERE T1.genre = 'horror' AND T3.d_quality = 0	movielens
SELECT T2.genre FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.runningtime <= 2 AND T1.isEnglish = 'T' AND T1.country = 'other'	movielens
SELECT DISTINCT T1.movieid FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid INNER JOIN u2base AS T3 ON T1.movieid = T3.movieid INNER JOIN users AS T4 ON T3.userid = T4.userid WHERE T1.country = 'UK' AND T2.genre = 'Comedy' AND T1.runningtime = 3 AND T3.rating = 5 AND T4.age BETWEEN 45 AND 50 AND T1.isEnglish = 'T'	movielens
SELECT CAST(SUM(IIF(T1.isEnglish = 'T', 1, 0)) - SUM(IIF(T1.isEnglish = 'F', 1, 0)) AS REAL) * 100 / COUNT(T1.movieid) FROM movies AS T1 INNER JOIN movies2directors AS T2 ON T1.movieid = T2.movieid WHERE T1.country = 'other' AND T1.year = 3	movielens
SELECT SUM(IIF(a_gender = 'M', 1, 0)) , SUM(IIF(a_gender = 'F', 1, 0)) , CAST(SUM(IIF(a_quality = 5, 1, 0)) AS REAL) * 100 / COUNT(*) , CAST(SUM(IIF(a_quality = 0, 1, 0)) AS REAL) * 100 / COUNT(*), ( SELECT directorid FROM movies2directors WHERE movieid = 1684910 ) , ( SELECT genre FROM movies2directors WHERE movieid = 1684910 ) FROM actors WHERE actorid IN ( SELECT actorid FROM movies2actors WHERE movieid = 1684910 )	movielens
SELECT DISTINCT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Order ID` = 'CA-2011-112326'	superstore
SELECT MAX(strftime('%J', `Ship Date`) - strftime('%J', `Order Date`)) AS longestTimeDays FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Aimee Bixby'	superstore
SELECT COUNT(DISTINCT T2.`Order ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Aimee Bixby' AND T2.`Ship Mode` = 'Standard Class'	superstore
SELECT COUNT(DISTINCT T2.`Order ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Aimee Bixby'	superstore
SELECT DISTINCT T2.`Order ID` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Aimee Bixby' GROUP BY T2.`Product ID` HAVING COUNT(T2.`Product ID`) > 3	superstore
SELECT COUNT(DISTINCT T2.`Order ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T3.Category = 'Furniture' AND T1.`Customer Name` = 'Aimee Bixby'	superstore
SELECT DISTINCT T3.`Product Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Aimee Bixby' AND STRFTIME('%Y', T2.`Ship Date`) = '2016'	superstore
SELECT SUM(T1.Quantity) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Telescoping Adjustable Floor Lamp'	superstore
SELECT DISTINCT T1.`Customer Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T3.`Product Name` = 'Telescoping Adjustable Floor Lamp'	superstore
SELECT COUNT(DISTINCT T1.`Customer Name`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T3.`Product Name` = 'Telescoping Adjustable Floor Lamp' AND T1.Segment = 'Consumer'	superstore
SELECT SUM(T2.Quantity) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Aimee Bixby' AND T3.`Product Name` = 'Xerox 1952' AND T2.`Order Date` = '2014-09-10'	superstore
SELECT COUNT(DISTINCT T2.`Order ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Aimee Bixby' AND T3.`Product Name` = 'Xerox 1952'	superstore
SELECT DISTINCT T2.Sales / (1 - T2.Discount) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Aimee Bixby' AND T3.`Product Name` = 'Xerox 1952' AND T2.`Order Date` = '2014-09-10'	superstore
SELECT DISTINCT (T2.Sales / (1 - T2.discount)) * T2.Quantity - Profit FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Aimee Bixby' AND T3.`Product Name` = 'Xerox 1952' AND T2.`Order Date` = '2014-09-10'	superstore
SELECT COUNT(DISTINCT T1.`Product ID`) FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Sub-Category` = 'Art' AND T1.Region = 'East' AND STRFTIME('%Y', T1.`Order Date`) = '2013'	superstore
SELECT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` GROUP BY T1.`Order ID`, T2.`Customer Name` ORDER BY SUM((T1.Sales / (1 - T1.Discount)) * T1.Quantity - T1.Profit) DESC LIMIT 1	superstore
SELECT T2.`Product Name` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` ORDER BY (T1.Sales / (1 - T1.Discount)) DESC LIMIT 1	superstore
SELECT T3.`Product Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Darren Powers' ORDER BY T2.`Order Date` DESC LIMIT 1	superstore
SELECT SUM(T1.Quantity) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Advantus Plastic Paper Clips'	superstore
SELECT T1.`Order ID` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Logitech G600 MMO Gaming Mouse' GROUP BY T1.`Order ID` ORDER BY SUM((T1.Sales / (1 - T1.Discount)) * T1.Quantity - T1.Profit) DESC LIMIT 1	superstore
SELECT DISTINCT T3.`Product Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Alejandro Grove'	superstore
SELECT COUNT(DISTINCT T1.`Customer ID`) FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.`Product Name` = 'Cardinal EasyOpen D-Ring Binders' AND T2.City = 'Chicago' AND T1.Quantity > 10	superstore
SELECT DISTINCT T2.`Product Name` FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.Profit > 1000	superstore
SELECT T2.`Product Name` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Mode` = 'First Class' AND T2.Region = 'East' LIMIT 10	superstore
SELECT DISTINCT T3.`Product Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Becky Martin' AND T3.Region = 'Central'	superstore
SELECT DISTINCT T2.`Customer Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.Region = 'West' AND T1.`Ship Mode` = 'Second Class' LIMIT 5	superstore
SELECT SUM(T2.Profit) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Patrick Gardner' AND T1.Region = 'Central'	superstore
SELECT T2.`Product Name` FROM south_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Date` = '2013-03-04' AND T2.Region = 'South' AND T1.`Order Date` = '2013-03-04'	superstore
SELECT SUM(T1.Sales) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Avery Hi-Liter EverBold Pen Style Fluorescent Highlighters, 4/Pack' AND T2.Region = 'Central'	superstore
SELECT T3.`Product Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Jonathan Doherty' AND T2.Region = 'East' ORDER BY T1.Quantity DESC LIMIT 1	superstore
SELECT SUM(T1.Quantity), T2.`Product Name` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Date` = '2015-03-25' AND T2.Region = 'East'	superstore
SELECT DISTINCT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.`Product Name` = 'Global High-Back Leather Tilter, Burgundy' AND T1.`Order Date` = '2013-10-13' AND T1.Region = 'East'	superstore
SELECT DISTINCT T3.Category FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Katherine Murray' AND T1.`Order Date` = '2018-11-04' AND T2.Region = 'South'	superstore
SELECT CAST(SUM(CASE  WHEN T2.Category = 'Furniture' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(T1.Quantity) FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'West' AND T1.`Ship Mode` = 'Standard Class'	superstore
SELECT T2.`Ship Date` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Ann Chong' AND T1.Region = 'Central'	superstore
SELECT DISTINCT T2.Segment FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.Region = 'West' AND T1.`Order ID` = 'CA-2011-108189'	superstore
SELECT SUM(T1.Sales) FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Hon Valutask Swivel Chairs' AND T1.Region = 'West'	superstore
SELECT T1.`Order ID` FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T2.Region = 'South' AND T2.`Customer Name` = 'Frank Olsen'	superstore
SELECT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Order Date` = '2018-04-26' AND T1.`Ship Date` = '2018-04-27' AND T2.Region = 'Central'	superstore
SELECT T5.City, T5.State FROM west_superstore AS T1 INNER JOIN east_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN central_superstore AS T3 ON T3.`Customer ID` = T2.`Customer ID` INNER JOIN south_superstore AS T4 ON T4.`Customer ID` = T3.`Customer ID` INNER JOIN people AS T5 ON T5.`Customer ID` = T4.`Customer ID` ORDER BY T2.Sales DESC LIMIT 1	superstore
SELECT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.Region = 'East' ORDER BY T1.Profit DESC LIMIT 1	superstore
SELECT T1.Quantity FROM west_superstore AS T1 INNER JOIN east_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN central_superstore AS T3 ON T3.`Customer ID` = T2.`Customer ID` INNER JOIN south_superstore AS T4 ON T4.`Customer ID` = T3.`Customer ID` INNER JOIN people AS T5 ON T5.`Customer ID` = T4.`Customer ID` WHERE T5.City = 'Chicago' AND T5.State = 'Illinois' ORDER BY T1.Quantity DESC LIMIT 1	superstore
SELECT T1.`Order Date`, T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Order ID` = 'CA-2011-137274' AND T2.Region = 'Central'	superstore
SELECT DISTINCT T2.`Customer Name` FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T1.Region = 'South' AND T3.`Product Name` = 'Xerox 23'	superstore
SELECT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Category = 'Office Supplies' AND T2.Region = 'Central' ORDER BY T1.Sales DESC LIMIT 1	superstore
SELECT T2.`Customer Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.Region = 'West' ORDER BY T1.Discount DESC LIMIT 1	superstore
SELECT DISTINCT T2.`Product Name` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'East' AND T1.Profit > ( SELECT AVG(Profit) * 0.98 FROM east_superstore )	superstore
SELECT DISTINCT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.Region = 'East' AND T1.Sales / (1 - T1.Discount) * T1.Quantity - T1.Profit > 80000	superstore
SELECT COUNT(DISTINCT T1.`Order ID`) FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T2.`Customer Name` = 'Maxwell Schwartz' AND STRFTIME('%Y', T1.`Order Date`) = '2015'	superstore
SELECT DISTINCT T2.`Customer Name` FROM central_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.`Product Name` = 'Bush Mission Pointe Library' AND T3.Region = 'Central'	superstore
SELECT SUM(T1.Profit) + SUM(T2.Profit) + SUM(T3.Profit) + SUM(T4.Profit) AS totalProfit FROM west_superstore AS T1 INNER JOIN east_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN central_superstore AS T3 ON T3.`Customer ID` = T2.`Customer ID` INNER JOIN south_superstore AS T4 ON T4.`Customer ID` = T3.`Customer ID` INNER JOIN product AS T5 ON T5.`Product ID` = T4.`Product ID` WHERE T5.`Product Name` = 'Cisco SPA301'	superstore
SELECT DISTINCT T3.`Product Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Anne McFarland'	superstore
SELECT DISTINCT T3.`Product Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.City = 'Coachella'	superstore
SELECT east, west FROM ( SELECT COUNT(`Order ID`) AS east , ( SELECT COUNT(`Order ID`) FROM west_superstore WHERE `Order Date` LIKE '2015%' ) AS west FROM east_superstore WHERE `Order Date` LIKE '2015%' )	superstore
SELECT DISTINCT T3.`Product Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Matt Abelman' AND STRFTIME('%Y', T1.`Order Date`) = '2013'	superstore
SELECT SUM((T1.Sales / (1 - T1.Discount)) * T1.Quantity - T1.Profit) AS cost FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T1.`Product ID` = T3.`Product ID` AND T1.Region = T3.Region WHERE T1.Region = 'East' AND T2.`Customer Name` = 'Brad Thomas' AND strftime('%Y', T1.`Order Date`) = '2016'	superstore
SELECT DISTINCT T2.`Customer Name`, T2.City, T2.Country FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.`Product Name` = 'Plantronics Single Ear Headset'	superstore
SELECT DISTINCT T2.`Ship Date`, T3.`Product Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Gene Hale'	superstore
SELECT COUNT(T1.`Order ID`) FROM south_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Mode` = 'First Class' AND T2.Category = 'Furniture'	superstore
SELECT COUNT(*) FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.Category = 'Office Supplies' AND T2.`Customer Name` = 'Cindy Stewart'	superstore
SELECT T2.Category FROM south_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` ORDER BY T1.Profit DESC LIMIT 1	superstore
SELECT T3.`Product Name` FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Cindy Stewart'	superstore
SELECT T2.`Product Name` FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Mode` = 'Same Day' AND T1.`Ship Date` LIKE '2013%'	superstore
SELECT DISTINCT T3.Category FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` LEFT JOIN central_superstore AS T4 ON T3.`Product ID` = T4.`Product ID` WHERE T2.`Customer Name` = 'Sam Craven'	superstore
SELECT SUM(T1.Quantity) FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Cindy Stewart' AND T3.`Product Name` = 'Lexmark X 9575 Professional All-in-One Color Printer'	superstore
SELECT DISTINCT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Mode` = 'Standard Class' AND T1.Quantity >= 10	superstore
SELECT T2.Category FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` ORDER BY T1.Sales LIMIT 1	superstore
SELECT SUM(T1.Profit) FROM south_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` GROUP BY T2.`Product Name` = 'Memorix Froggy Flash Drive 8 GB'	superstore
SELECT SUM(T1.Sales) FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE STRFTIME('%Y', T1.`Order Date`) = '2016' AND T2.Category = 'Furniture'	superstore
SELECT AVG(T1.Sales) FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.`Product Name` = 'Sharp AL-1530CS Digital Copier'	superstore
SELECT CAST(SUM(CASE  WHEN T3.Category = 'Office Supplies' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.Category) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID`	superstore
SELECT CAST(SUM(CASE  WHEN State = 'Texas' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE  WHEN State = 'Indiana' THEN 1 ELSE 0 END) FROM people	superstore
SELECT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Sub-Category` = 'Art' GROUP BY T2.`Product Name` ORDER BY COUNT(T2.`Product ID`) DESC LIMIT 1	superstore
SELECT DISTINCT T2.`Customer Name` FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE STRFTIME('%Y', T1.`Order Date`) = '2015' GROUP BY T2.`Customer Name` HAVING COUNT(T2.`Customer Name`) > 3	superstore
SELECT MAX(T2.Profit) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Anna Chung'	superstore
SELECT COUNT(T2.`Customer ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Corey Roper' AND STRFTIME('%Y', T2.`Ship Date`) = '2015'	superstore
SELECT SUM(T1.Sales) - SUM(T2.Sales) AS difference FROM east_superstore AS T1 INNER JOIN west_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID`	superstore
SELECT DISTINCT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'Central' AND T1.Profit < 0	superstore
SELECT DISTINCT T2.`Product Name`, T1.`Ship Mode` FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'West' ORDER BY T1.`Ship Date` - T1.`Order Date` LIMIT 1	superstore
SELECT COUNT(DISTINCT T1.`Order ID`) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'O''Sullivan Plantations 2-Door Library in Landvery Oak' AND T2.Region = 'Central' AND T1.`Ship Mode` = 'First Class'	superstore
SELECT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T2.Segment = 'Corporate' AND T2.State = 'Rhode Island' AND T2.Region = 'East' AND STRFTIME('%Y', T1.`Order Date`) = '2016' GROUP BY T2.`Customer Name` ORDER BY COUNT(T2.`Customer Name`) DESC LIMIT 1	superstore
SELECT COUNT(DISTINCT T1.`Order ID`) FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` INNER JOIN people AS T3 ON T3.`Customer ID` = T1.`Customer ID` WHERE T1.Sales > 5000 AND T3.State = 'California' AND T2.Region = 'West'	superstore
SELECT T2.Segment FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T1.Region = 'East' ORDER BY (T1.Sales / (1 - T1.Discount)) DESC LIMIT 1	superstore
SELECT DISTINCT strftime('%J', `Ship Date`) - strftime('%J', `Order Date`) AS duration FROM central_superstore WHERE `Order ID` = 'CA-2011-134103'	superstore
SELECT COUNT(DISTINCT `Order ID`) FROM central_superstore WHERE Quantity > 5 AND `Ship Mode` = 'First Class'	superstore
SELECT `Order ID` FROM central_superstore WHERE Profit < 0 LIMIT 3	superstore
SELECT DISTINCT T3.`Product Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Phillina Ober'	superstore
SELECT T2.`Customer Name` FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T3.`Product Name` = 'Hon Multipurpose Stacking Arm Chairs' GROUP BY T2.`Customer Name` ORDER BY COUNT(T2.`Customer Name`) DESC LIMIT 1	superstore
SELECT DISTINCT T1.Profit FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'O''Sullivan Living Dimensions 2-Shelf Bookcases'	superstore
SELECT SUM(T1.Quantity) FROM west_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Hon Pagoda Stacking Chairs'	superstore
SELECT COUNT(*) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Aaron Bergman' AND T2.`Ship Mode` = 'Standard Class'	superstore
SELECT T1.Sales / (1 - T1.Discount) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Blackstonian Pencils'	superstore
SELECT DISTINCT T3.`Product Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T1.`Product ID` WHERE T2.`Customer Name` = 'Aimee Bixby'	superstore
SELECT DISTINCT T1.Profit FROM south_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Sauder Camden County Barrister Bookcase, Planked Cherry Finish'	superstore
SELECT COUNT(T2.Category) FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Ship Mode` = 'Standard Class'	superstore
SELECT T1.`Order ID` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T2.City = 'Houston' AND T2.State = 'Texas' ORDER BY T1.Profit DESC LIMIT 1	superstore
SELECT COUNT(*) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Category = 'Furniture'	superstore
SELECT DISTINCT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE strftime('%Y-%m', T1.`Ship Date`) = '2013-03'	superstore
SELECT COUNT(DISTINCT T2.`Order ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.State = 'Texas'	superstore
SELECT COUNT(DISTINCT T2.`Order ID`) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Customer Name` = 'Alan Barnes' AND STRFTIME('%Y', T2.`Order Date`) = '2015'	superstore
SELECT DISTINCT T2.`Product Name` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Order ID` = 'CA-2011-141817'	superstore
SELECT CAST(SUM(CASE  WHEN T2.Discount = 0.2 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.State = 'Texas'	superstore
SELECT CAST(SUM(CASE  WHEN T1.`Ship Mode` = 'First Class' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Category = 'Furniture' AND STRFTIME('%Y', T1.`Ship Date`) = '2013'	superstore
SELECT DISTINCT T2.`Customer Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Order Date` = '2013-08-12' AND T1.Discount = 0.2 AND T1.Region = 'West'	superstore
SELECT DISTINCT T1.`Order ID` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.`Product Name` = 'Security-Tint Envelopes' AND T1.`Order Date` = '2013-06-03'	superstore
SELECT DISTINCT T3.`Product Name` FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.`Customer Name` = 'Bill Shonely' AND T2.Region = 'Central'	superstore
SELECT DISTINCT T2.`Customer Name` FROM west_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.Quantity = 8 AND T1.Region = 'West'	superstore
SELECT SUM(T2.Profit) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` INNER JOIN product AS T3 ON T3.`Product ID` = T2.`Product ID` WHERE T1.City = 'Houston' AND T1.State = 'Texas' AND T2.Region = 'Central'	superstore
SELECT DISTINCT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Ship Date` = '2013-03-05'	superstore
SELECT T2.`Product Name` FROM central_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'Central' AND STRFTIME('%Y', T1.`Order Date`) = '2016' ORDER BY T1.Profit ASC LIMIT 1	superstore
SELECT DISTINCT T2.`Customer Name` FROM east_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T1.`Order ID` = 'CA-2011-118976' AND T2.Region = 'East'	superstore
SELECT T2.`Product Name` FROM south_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'South' ORDER BY T1.Sales DESC LIMIT 1	superstore
SELECT T1.Sales, T1.Profit, T2.`Sub-Category` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T1.`Order ID` = 'US-2011-126571' AND T2.Region = 'East'	superstore
SELECT T2.`Product Name` FROM east_superstore AS T1 INNER JOIN product AS T2 ON T1.`Product ID` = T2.`Product ID` WHERE T2.Region = 'East' ORDER BY T1.Quantity DESC LIMIT 1	superstore
SELECT DISTINCT T2.`Customer Name` FROM south_superstore AS T1 INNER JOIN people AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T2.Region = 'South' AND T1.`Ship Mode` = 'Standard Class' AND 100 * T1.Sales / ( SELECT AVG(Sales) FROM south_superstore ) > 88	superstore
SELECT CAST(SUM(CASE  WHEN T2.Discount = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM people AS T1 INNER JOIN central_superstore AS T2 ON T1.`Customer ID` = T2.`Customer ID` WHERE T2.Region = 'Central' AND T1.State = 'Indiana'	superstore
SELECT CAST(SUM(IIF(race = 'W', 1, 0)) AS REAL) * 100 / COUNT(case_number) FROM officers WHERE gender = 'M'	shooting
SELECT CAST(SUM(IIF(officer_count > 3, 1, 0)) AS REAL) * 100 / COUNT(case_number) FROM incidents WHERE STRFTIME('%Y', date) BETWEEN '2010' AND '2015'	shooting
SELECT STRFTIME('%Y', date) FROM incidents WHERE subject_weapon = 'Handgun' GROUP BY STRFTIME('%Y', date) ORDER BY COUNT(case_number) DESC LIMIT 1	shooting
SELECT CAST(SUM(subject_statuses = 'Injured') AS REAL) * 100 / COUNT(case_number) FROM incidents WHERE grand_jury_disposition = 'No Bill'	shooting
SELECT SUM(IIF(STRFTIME('%Y', date) = '2007', 1, 0)) - SUM(IIF(STRFTIME('%Y', date) = '2008', 1, 0)) FROM incidents WHERE subject_weapon = 'Vehicle'	shooting
SELECT CAST(SUM(subject_statuses = 'Shoot and Miss') AS REAL) * 100 / COUNT(case_number) FROM incidents WHERE subject_weapon = 'Handgun'	shooting
SELECT T2.last_name, T2.gender FROM incidents AS T1 INNER JOIN officers AS T2 ON T1.case_number = T2.case_number WHERE T1.grand_jury_disposition = 'No Bill'	shooting
SELECT T1.case_number, T1.subject_statuses, T1.subject_weapon FROM incidents AS T1 INNER JOIN subjects AS T2 ON T1.case_number = T2.case_number WHERE T2.gender = 'F'	shooting
SELECT T1.case_number, T1.location, T1.subject_statuses FROM incidents AS T1 INNER JOIN subjects AS T2 ON T1.case_number = T2.case_number WHERE T2.gender = 'M'	shooting
SELECT T1.case_number, T1.grand_jury_disposition FROM incidents AS T1 INNER JOIN officers AS T2 ON T1.case_number = T2.case_number WHERE T2.first_name = 'George' AND T2.last_name = 'Evenden'	shooting
SELECT T2.last_name, T1.subject_statuses FROM incidents AS T1 INNER JOIN officers AS T2 ON T1.case_number = T2.case_number WHERE T1.case_number = '134472-2015'	shooting
SELECT T2.last_name, T2.gender, T2.race, T2.case_number FROM incidents AS T1 INNER JOIN subjects AS T2 ON T1.case_number = T2.case_number WHERE T1.subject_statuses = 'Deceased'	shooting
SELECT CAST(SUM(T1.subject_weapon = 'Vehicle') AS REAL) * 100 / COUNT(T1.case_number) FROM incidents T1 INNER JOIN subjects T2 ON T1.case_number = T2.case_number WHERE T2.gender = 'F'	shooting
SELECT CAST(SUM(T1.subject_weapon = 'Knife') AS REAL) * 100 / SUM(T1.subject_weapon = 'Handgun') FROM incidents AS T1 INNER JOIN subjects AS T2 ON T1.case_number = T2.case_number WHERE T1.subject_statuses = 'Injured'	shooting
SELECT case_number FROM incidents WHERE STRFTIME('%Y', date) > '2011' AND subject_statuses = 'Deceased'	shooting
SELECT CAST(SUM(race = 'B') AS REAL) * 100 / COUNT(case_number) FROM officers WHERE gender = 'M'	shooting
SELECT COUNT(T1.case_number) FROM incidents AS T1 INNER JOIN officers AS T2 ON T1.case_number = T2.case_number WHERE T1.subject_weapon = 'Vehicle' AND T2.gender = 'F'	shooting
SELECT COUNT(T1.case_number) FROM incidents AS T1 INNER JOIN subjects AS T2 ON T1.case_number = T2.case_number WHERE T2.gender = 'F' AND T1.subject_statuses = 'Deceased'	shooting
SELECT COUNT(T1.case_number) FROM officers AS T1 INNER JOIN incidents AS T2 ON T2.case_number = T1.case_number WHERE T1.race = 'B' AND T2.date BETWEEN '2010-01-01' AND '2015-12-31'	shooting
SELECT COUNT(case_number) FROM incidents WHERE date BETWEEN '2015-06-01' AND '2015-06-30'	shooting
SELECT COUNT(location) FROM incidents WHERE subject_weapon = 'Handgun' AND subject_statuses = 'Injured' AND date BETWEEN '2006-01-01' AND '2013-12-31'	shooting
SELECT subject_weapon FROM incidents WHERE subject_statuses = 'Deceased' GROUP BY subject_weapon ORDER BY COUNT(case_number) DESC LIMIT 1	shooting
SELECT CAST(SUM(gender = 'M') AS REAL) / SUM(gender = 'F') FROM officers WHERE race = 'W'	shooting
SELECT SUM(race = 'B') - SUM(race = 'W') FROM subjects WHERE gender = 'F'	shooting
SELECT CAST(SUM(subject_statuses = 'Deceased') AS REAL) * 100 / COUNT(case_number) FROM incidents WHERE subject_weapon = 'Rifle'	shooting
SELECT T1.subject_weapon, T2.race, T2.gender FROM incidents AS T1 INNER JOIN subjects AS T2 ON T1.case_number = T2.case_number WHERE T1.case_number = '031347-2015'	shooting
SELECT T1.case_number, T3.race, T3.gender FROM incidents AS T1 INNER JOIN officers AS T2 ON T1.case_number = T2.case_number INNER JOIN subjects AS T3 ON T1.case_number = T3.case_number WHERE T2.first_name = 'Fredirick' AND T2.last_name = 'Ruben'	shooting
SELECT CAST(SUM(T2.gender = 'M') AS REAL) * 100 / COUNT(T1.case_number) FROM incidents T1 INNER JOIN officers T2 ON T1.case_number = T2.case_number WHERE T1.subject_statuses = 'Injured'	shooting
SELECT T1.Chromosome FROM Genes AS T1 INNER JOIN Classification AS T2 ON T1.GeneID = T2.GeneID WHERE T2.Localization = 'plasma membrane'	genes
SELECT COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Classification AS T2 ON T1.GeneID = T2.GeneID WHERE T2.Localization = 'nucleus' AND T1.Essential = 'Non-Essential'	genes
SELECT COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Classification AS T2 ON T1.GeneID = T2.GeneID WHERE T2.Localization = 'vacuole' AND T1.Phenotype = 'Nucleic acid metabolism defects'	genes
SELECT T2.Localization FROM Genes AS T1 INNER JOIN Classification AS T2 ON T1.GeneID = T2.GeneID ORDER BY T1.Chromosome DESC LIMIT 1	genes
SELECT T2.Expression_Corr FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 INNER JOIN Genes AS T3 ON T3.GeneID = T2.GeneID2 WHERE T1.Localization = 'nucleus' AND T3.Localization = 'nucleus' ORDER BY T2.Expression_Corr DESC LIMIT 1	genes
SELECT T1.Function FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 ORDER BY T2.Expression_Corr ASC LIMIT 1	genes
SELECT COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T2.Expression_Corr < 0 AND T1.Class = 'Motorproteins'	genes
SELECT T2.Expression_Corr FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Chromosome = 6 OR T1.Chromosome = 8 ORDER BY T2.Expression_Corr DESC LIMIT 1	genes
SELECT T2.GeneID1, T2.GeneID2 FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Localization = 'cytoplasm' AND T1.Chromosome = 7	genes
SELECT COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Localization != 'cytoplasm' AND T1.Function = 'TRANSCRIPTION' AND T1.Essential = 'NON-Essential'	genes
SELECT COUNT(T2.GeneID2) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T2.Expression_Corr > 0 AND T1.Essential = 'Non-Essential'	genes
SELECT CAST(SUM(IIF(T1.Chromosome > 10 AND T3.Chromosome > 10, 1, 0)) AS REAL) * 100 / COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 INNER JOIN Genes AS T3 ON T3.GeneID = T2.GeneID2 WHERE T2.Expression_Corr > 0	genes
SELECT AVG(T2.Expression_Corr) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Class = 'ATPases'	genes
SELECT DISTINCT GeneID FROM Genes WHERE Localization = 'cytoplasm' AND Function = 'METABOLISM'	genes
SELECT COUNT(GeneID) FROM Classification WHERE Localization IN ('plasma', 'nucleus')	genes
SELECT Expression_Corr FROM Interactions WHERE Type = 'Physical' UNION ALL SELECT CAST(SUM(Expression_Corr < 0) AS REAL) * 100 / COUNT(*) FROM Interactions WHERE Type = 'Physical'	genes
SELECT SUM(Localization = 'cytoskeleton' AND Phenotype = 'Conditional phenotypes') , CAST(SUM(Localization = 'cytoskeleton') AS REAL) * 100 / COUNT(GeneID) FROM Genes;	genes
SELECT T2.Type FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Function = 'TRANSCRIPTION' AND T1.Essential = 'Non-Essential'	genes
SELECT T1.GeneID FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T2.Expression_Corr > 0 AND T1.Localization = 'nucleus'	genes
SELECT T2.GeneID1 FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Localization = 'nucleus' AND T1.Class = 'Transcription factors' AND T1.Essential = 'Essential' AND T2.Expression_Corr != 0	genes
SELECT COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T2.Type != 'Physical' AND T1.Phenotype = 'Cell cycle defects' AND T1.Class != 'Motorproteins' AND T1.Essential = 'Non-Essential'	genes
SELECT CAST(SUM(IIF(T2.Expression_Corr > 0, 1, 0)) AS REAL) * 100 / COUNT(T2.GeneID1) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T1.Phenotype = 'Nucleic acid metabolism defects' AND T1.Motif = 'PS00107'	genes
SELECT CAST(COUNT(T1.GeneID) AS REAL) * 100 / ( SELECT COUNT(T1.GeneID) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T2.Expression_Corr < 0 ) FROM Genes AS T1 INNER JOIN Interactions AS T2 ON T1.GeneID = T2.GeneID1 WHERE T2.Expression_Corr < 0 AND T1.Essential = 'Non-Essential'	genes
SELECT DISTINCT Translated_Review FROM user_reviews WHERE App IN ( SELECT App FROM playstore WHERE `Last Updated` BETWEEN 'January 1, 2018' AND 'January 31, 2018' ) AND Sentiment = 'Positive'	app_store
SELECT COUNT(T2.Sentiment_Polarity), T1."Last Updated" FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = '7 Minute Workout' AND T2.Sentiment_Polarity BETWEEN 0 AND 0.5	app_store
SELECT COUNT(T1.Rating), T1.Rating FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'HTC Weather' AND T2.Sentiment = 'Neutral'	app_store
SELECT DISTINCT T1.App, T1.Category FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Sentiment_Polarity = '-1.0'	app_store
SELECT AVG(T2.Sentiment_Polarity), T1."Content Rating" FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Cooking Fever'	app_store
SELECT MIN(T2.Sentiment_Polarity), T1.Installs FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Basketball Stars'	app_store
SELECT COUNT(T2.Sentiment_Subjectivity), T1."Current Ver" FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Akinator' AND T2.Sentiment_Subjectivity < 0.5	app_store
SELECT COUNT(App) FROM playstore WHERE Rating = 5	app_store
SELECT App FROM playstore WHERE Price = 0 ORDER BY CAST(REPLACE(REPLACE(Installs, ',', ''), '+', '') AS INTEGER) DESC LIMIT 5	app_store
SELECT DISTINCT App FROM playstore ORDER BY Reviews DESC LIMIT 10	app_store
SELECT COUNT(T2.App), T1.Category FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = '10 Best Foods for You' AND T2.Sentiment = 'Neutral'	app_store
SELECT DISTINCT T1.App, T1.Installs FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Sentiment_Polarity > 0	app_store
SELECT T1.App, T2.Translated_Review FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Rating = 3.9	app_store
SELECT DISTINCT Sentiment FROM user_reviews WHERE App IN ( SELECT App FROM playstore WHERE `Android Ver` = '8.0 and up' )	app_store
SELECT SUM(T2.Sentiment_Subjectivity) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Genres > 1	app_store
SELECT DISTINCT App, Sentiment FROM user_reviews WHERE App IN ( SELECT App FROM playstore WHERE CAST(SUBSTR('Last Updated', -4, 4) AS INTEGER) < 2015 )	app_store
SELECT SUM(T1.Installs), T2.Translated_Review FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1."Content Rating" = 'Adults only 18+'	app_store
SELECT T1.App, T2.Sentiment_Polarity FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App ORDER BY T1.Price * CAST(REPLACE(REPLACE(Installs, ',', ''), '+', '') AS INTEGER) DESC LIMIT 1	app_store
SELECT AVG(T1.Rating) , COUNT(CASE WHEN T2.Sentiment = 'Positive' THEN 1 ELSE NULL END) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Category = 'COMICS'	app_store
SELECT Rating FROM playstore WHERE APP = 'Draw A Stickman'	app_store
SELECT COUNT(App) FROM user_reviews WHERE App = 'Brit + Co' AND Translated_Review IS NOT NULL	app_store
SELECT DISTINCT App FROM playstore WHERE Genres = 'Shopping' GROUP BY App ORDER BY COUNT(App) DESC LIMIT 5	app_store
SELECT COUNT(App) FROM user_reviews WHERE App = 'Dino War: Rise of Beasts' AND Sentiment = 'Neutral'	app_store
SELECT DISTINCT App FROM playstore WHERE Installs = '5,000+'	app_store
SELECT Translated_Review FROM user_reviews WHERE App = 'Dog Run - Pet Dog Simulator' AND Sentiment = 'Negative'	app_store
SELECT T1.App FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Type = 'Free' AND T2.Sentiment = 'Negative' GROUP BY T1.App ORDER BY COUNT(T2.Sentiment) DESC LIMIT 1	app_store
SELECT COUNT(T2.Sentiment) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Installs = '100,000,000+' AND T2.Sentiment = 'Negative'	app_store
SELECT DISTINCT T1.`Content Rating` FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Translated_Review LIKE '%gr8%'	app_store
SELECT SUM(T2.Sentiment_Polarity) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Price = ( SELECT MAX(Price) FROM playstore )	app_store
SELECT T1.Rating, T2.Translated_Review FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Garden Coloring Book'	app_store
SELECT T1.App FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Genres = 'Photography' GROUP BY T1.App ORDER BY SUM(T2.Sentiment_Subjectivity) DESC LIMIT 1	app_store
SELECT T2.Translated_Review FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1."Content Rating" = 'Mature 17+' ORDER BY T1.Rating LIMIT 1	app_store
SELECT T1.Installs FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App GROUP BY T1.App ORDER BY SUM(T2.Sentiment_Polarity) DESC LIMIT 1	app_store
SELECT COUNT(T2.Sentiment) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Genres = 'Weather' AND T2.Sentiment = 'Neutral'	app_store
SELECT T1.App FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Installs = '1,000,000+' AND T2.Translated_Review = 'nan' GROUP BY T1.App ORDER BY COUNT(T2.Translated_Review) DESC LIMIT 1	app_store
SELECT T1.Rating, SUM(T2.Sentiment_Subjectivity) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Onefootball - Soccer Scores'	app_store
SELECT CAST(COUNT(CASE WHEN T1.`Content Rating` = 'Teen' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.App) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Translated_Review = 'nan'	app_store
SELECT DISTINCT App FROM playstore WHERE Rating = 5	app_store
SELECT DISTINCT App FROM playstore WHERE Reviews > 75000000 AND `Content Rating` = 'Teen'	app_store
SELECT Genres FROM playstore WHERE Installs = '1,000,000,000+' GROUP BY Genres	app_store
SELECT AVG(Price) FROM playstore WHERE Genres = 'Dating'	app_store
SELECT AVG(CAST(REPLACE(REPLACE(Installs, ',', ''), '+', '') AS INTEGER)) FROM playstore WHERE Category = 'ENTERTAINMENT' AND Size < '1.0M'	app_store
SELECT AVG(Reviews) FROM playstore WHERE Rating = 5	app_store
SELECT Genres FROM playstore WHERE App IN ( SELECT App FROM user_reviews WHERE Sentiment = 'Positive' AND Sentiment_Polarity > 0.5 ORDER BY Sentiment_Polarity DESC LIMIT 3 )	app_store
SELECT CAST(COUNT(CASE WHEN ( SELECT COUNT(CASE WHEN Sentiment = 'Positive' THEN 1 ELSE NULL END) - COUNT(CASE WHEN Sentiment = 'Negative' THEN 1 ELSE NULL END) FROM user_reviews GROUP BY App ) > 0 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.Sentiment) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Rating = 4.7	app_store
SELECT T1.App, AVG(T2.Sentiment_Polarity) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Sentiment != 'Negative' GROUP BY T1.App	app_store
SELECT CAST((( SELECT COUNT(*) Po FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE SUBSTR(T1."Last Updated", -4, 4) > '2015' AND T2.Sentiment = 'Positive' ) - ( SELECT COUNT(*) Ne FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE SUBSTR(T1."Last Updated", -4, 4) > '2015' AND T2.Sentiment = 'Negative' )) AS REAL) * 100 / ( SELECT COUNT(*) NUM FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE SUBSTR(T1."Last Updated", -4, 4) > '2015' )	app_store
SELECT CAST(SUM(CASE WHEN SUBSTR('Last Updated', -4) > '2018' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(App) PER FROM playstore WHERE Type = 'Free' AND Rating >= 4.5	app_store
SELECT DISTINCT Genres FROM playstore WHERE App = 'Honkai Impact 3rd'	app_store
SELECT DISTINCT Rating FROM playstore WHERE App = 'Learn C++'	app_store
SELECT AVG(Price) FROM playstore WHERE 'Content Rating' = 'Everyone 10+' AND Genres = 'Arcade'	app_store
SELECT T1.Size, COUNT(T1.App) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Browser 4G' AND T2.Sentiment_Polarity >= 0.5	app_store
SELECT DISTINCT T1.App, T1.Installs FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Sentiment_Polarity = 0.3	app_store
SELECT AVG(T2.Sentiment_Polarity), T1.Rating FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Golf GPS Rangefinder: Golf Pad'	app_store
SELECT T1.App, COUNT(T1.App) COUNTNUMBER FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T2.Sentiment = 'Negative' GROUP BY T1.App ORDER BY T1.Rating LIMIT 5	app_store
SELECT CAST(SUM(CASE WHEN T2.Sentiment = 'Positive' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN T2.Sentiment = 'Negative' THEN 1 ELSE 0 END), T1.`Current Ver` FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Fate/Grand Order (English)' AND T1.`Current Ver` = '1.18.0'	app_store
SELECT T1.Installs , CAST(SUM(CASE WHEN T2.Sentiment = 'Positive' THEN 1 ELSE 0 END) * 100 / SUM(CASE WHEN T2.Sentiment IS NOT NULL THEN 1.0 ELSE 0 END) AS REAL) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'FREEDOME VPN Unlimited anonymous Wifi Security'	app_store
SELECT MAX(T2.Sentiment_Polarity), T1.Genres FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Honkai Impact 3rd' AND T2.Sentiment_Polarity > 0.5 GROUP BY T1.Genres	app_store
SELECT T1.Rating, COUNT(T2.Sentiment_Polarity) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.App = 'Dragon Ball Legends' AND CAST(Sentiment_Polarity AS INTEGER) < -0.5	app_store
SELECT T1.App, T2.Translated_Review FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Category = 'EDUCATION' GROUP BY T1.App, T2.Translated_Review ORDER BY T1.Rating ASC LIMIT 1	app_store
SELECT T1.App, T2.Translated_Review FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Type = 'Free' AND T1.Category = 'SPORTS'	app_store
SELECT COUNT(T1.App), AVG(T2.Sentiment_Polarity) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1."Content Rating" = 'Teen' AND T1.Genres = 'Role Playing'	app_store
SELECT AVG(T1.Rating), CAST(COUNT(CASE WHEN T2.Sentiment = 'Positive' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.Sentiment) FROM playstore AS T1 INNER JOIN user_reviews AS T2 ON T1.App = T2.App WHERE T1.Genres = 'Racing'	app_store
SELECT Region FROM `Sales Team` GROUP BY Region ORDER BY COUNT(DISTINCT `Sales Team`) DESC LIMIT 1	regional_sales
SELECT T FROM ( SELECT IIF(`Customer Names` LIKE '%Group%', `Customer Names`, NULL) AS T FROM Customers ) WHERE T IS NOT NULL	regional_sales
SELECT AVG(`Median Income`) FROM `Store Locations` WHERE Type = 'City'	regional_sales
SELECT T2.`Sales Team`, T2.Region FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.OrderNumber = 'SO - 000137'	regional_sales
SELECT DISTINCT T1.ProductID, T1.`Product Name` FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Sales Team` AS T3 ON T3.SalesTeamID = T2._SalesTeamID WHERE T3.`Sales Team` = 'Douglas Tucker'	regional_sales
SELECT DISTINCT T1.`Customer Names` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products AS T3 ON T3.ProductID = T2._ProductID WHERE T3.`Product Name` = 'Cocktail Glasses' AND SUBSTR(T2.OrderDate, -2) = '20' AND T2.`Discount Applied` = ( SELECT T2.`Discount Applied` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products AS T3 ON T3.ProductID = T2._ProductID WHERE T3.`Product Name` = 'Cocktail Glasses' AND T2.OrderDate LIKE '%/%/20' ORDER BY T2.`Discount Applied` DESC LIMIT 1 )	regional_sales
SELECT DISTINCT T1.OrderNumber, T2.`City Name` FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.`Sales Channel` = 'In-Store'	regional_sales
SELECT T2.OrderNumber, T1.`Customer Names`, T2.OrderDate FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products AS T3 ON T3.ProductID = T2._ProductID ORDER BY T2.`Unit Cost` DESC LIMIT 1	regional_sales
SELECT DISTINCT T FROM ( SELECT CASE  WHEN T1.OrderDate LIKE '%/%/18' AND T2.`Customer Names` = 'Rochester Ltd' THEN T1.OrderNumber ELSE NULL END AS T FROM `Sales Orders` T1 INNER JOIN Customers T2 ON T2.CustomerID = T1._CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT DISTINCT T1.`Product Name`, T3.`Sales Team` FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Sales Team` AS T3 ON T3.SalesTeamID = T2._SalesTeamID WHERE T2.WarehouseCode = 'WARE-NMK1003'	regional_sales
SELECT T FROM ( SELECT CASE  WHEN T2.`Sales Channel` = 'Online' THEN T1.`Customer Names` ELSE NULL END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT AVG(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', ''))  FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T2.`Product Name` = 'Bakeware'	regional_sales
SELECT T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.OrderDate LIKE '%/%/20' GROUP BY T2.`Sales Team` ORDER BY SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) DESC LIMIT 1	regional_sales
SELECT T1.OrderNumber , REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')  FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.`Sales Team` = 'Joshua Bennett'	regional_sales
SELECT SUM(CASE WHEN T2.`Product Name` = 'Home Fragrances' THEN 1 ELSE 0 END) * 100 / COUNT(T1.OrderNumber)  FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T1.ShipDate LIKE '7/%/18'	regional_sales
SELECT DISTINCT CustomerID, `Customer Names` FROM Customers WHERE `Customer Names` LIKE 'W%' ORDER BY `Customer Names` DESC	regional_sales
SELECT ProductID, T FROM ( SELECT ProductID , CASE  WHEN `Product Name` LIKE '%Outdoor%' THEN `Product Name` ELSE NULL END AS T FROM Products ) WHERE T IS NOT NULL ORDER BY T DESC	regional_sales
SELECT COUNT(DISTINCT T) FROM ( SELECT CASE  WHEN `Sales Channel` = 'In-Store' AND WarehouseCode = 'WARE-NMK1003' AND `Discount Applied` = '0.4' THEN OrderNumber ELSE NULL END AS T FROM `Sales Orders` ) WHERE T IS NOT NULL	regional_sales
SELECT `City Name`, `Median Income` FROM `Store Locations` WHERE State = 'Florida' ORDER BY Population DESC LIMIT 1	regional_sales
SELECT DISTINCT T2.StoreID, T2.`City Name`, T1.Region FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T2.County = 'Allen County'	regional_sales
SELECT DISTINCT T2.StoreID, T2.`City Name`, T1.State, T2.Type FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T2.Type = 'Borough' OR T2.Type = 'CDP'	regional_sales
SELECT T2.Region, T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.SalesTeamID = 18 AND T1.`Sales Channel` = 'In-Store' OR T1.`Sales Channel` = 'Online'	regional_sales
SELECT CAST(SUM(CASE WHEN T1.`Sales Channel` = 'In-Store' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1._CustomerID) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID WHERE T2.`Customer Names` = 'Medline '	regional_sales
SELECT T1.`Customer Names`, T2.DeliveryDate FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products AS T3 ON T3.ProductID = T2._ProductID WHERE T2.`Sales Channel` = 'Wholesale' AND T3.`Product Name` = 'Bedroom Furniture' AND T2.OrderDate LIKE '%/%/19'	regional_sales
SELECT DISTINCT `Customer Names`, `Product Name` FROM ( SELECT T1.`Customer Names`, T3.`Product Name` , REPLACE(T2.`Unit Price`, ',', '') - REPLACE(T2.`Unit Cost`, ',', '') AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products T3 ON T3.ProductID = T2._ProductID ) WHERE T > 3800	regional_sales
SELECT DISTINCT T2.`City Name` FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T2.State = 'California' AND T2.`Water Area` = '0'	regional_sales
SELECT CAST(SUM(CASE WHEN T2.`Sales Team` = 'Carlos Miller' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID	regional_sales
SELECT SUM(CASE WHEN T2.`Product Name` = 'Platters' THEN 1 ELSE 0 END) AS num1 , SUM(CASE WHEN T2.`Product Name` = 'Serveware' THEN 1 ELSE 0 END) AS num2 FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID	regional_sales
SELECT SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID ORDER BY T2.`Median Income` DESC LIMIT 1	regional_sales
SELECT COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.Region = 'South' AND T2.SalesTeamID BETWEEN 1 AND 9 GROUP BY T2.SalesTeamID HAVING COUNT(T1.OrderNumber)	regional_sales
SELECT SUM(IIF(OrderDate = '5/31/18', 1, 0)) FROM `Sales Orders`	regional_sales
SELECT DISTINCT T FROM ( SELECT IIF(DeliveryDate = '6/13/18', OrderNumber, NULL) AS T FROM `Sales Orders` ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(IIF(`Order Quantity` > 5, 1, 0)) FROM `Sales Orders`	regional_sales
SELECT T FROM ( SELECT IIF(StateCode = 'GA', State, NULL) AS T FROM Regions ) WHERE T IS NOT NULL	regional_sales
SELECT COUNT(DISTINCT T) FROM ( SELECT CASE  WHEN Region = 'Midwest' THEN StateCode ELSE NULL END AS T FROM Regions ) WHERE T IS NOT NULL	regional_sales
SELECT T FROM ( SELECT DISTINCT IIF(T1.`Unit Cost` = 781.22, T2.`Product Name`, NULL) AS T FROM `Sales Orders` T1 INNER JOIN Products T2 ON T2.ProductID = T1._ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT T FROM ( SELECT DISTINCT IIF(T2.`Product Name` = 'Cookware', T1.DeliveryDate, NULL) AS T FROM `Sales Orders` T1 INNER JOIN Products T2 ON T2.ProductID = T1._ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN T1.OrderDate LIKE '%/%/18' AND T2.`Product Name` = 'Furniture Cushions' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID	regional_sales
SELECT T FROM ( SELECT DISTINCT IIF(T1.`Discount Applied` = 0.1, T2.`Product Name`, NULL) AS T FROM `Sales Orders` T1 INNER JOIN Products T2 ON T2.ProductID = T1._ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) / COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T2.`Product Name` = 'Phones' AND T1.`Sales Channel` = 'Distributor'	regional_sales
SELECT SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) / COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T2.`Product Name` = 'Bar Tools' AND T1.`Order Quantity` > 5	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T1.Region = 'South' THEN T2.`City Name` END AS T FROM Regions T1 INNER JOIN `Store Locations` T2 ON T2.StateCode = T1.StateCode ) WHERE T IS NOT NULL	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.Type = 'Town' THEN T1.Region END AS T FROM Regions T1 INNER JOIN `Store Locations` T2 ON T2.StateCode = T1.StateCode ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN T1.`Customer Names` = 'Medsep Group' THEN 1 ELSE 0 END) FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T1.`Customer Names` = 'Ole Group' THEN T2.`Discount Applied` END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.ShipDate = '7/8/18' THEN T1.`Customer Names` END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN T1.`Order Quantity` > 4 AND T2.`Customer Names` = 'Ei ' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID	regional_sales
SELECT SUM(CASE WHEN T1.`Discount Applied` = 0.05 AND T2.`Customer Names` = 'Pacific Ltd' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.`Unit Cost` > 4000 THEN T1.`Customer Names` END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT StoreID, Latitude, Longitude FROM `Store Locations` WHERE `City Name` = 'Birmingham'	regional_sales
SELECT `City Name` FROM `Store Locations` ORDER BY Population DESC LIMIT 1	regional_sales
SELECT SUM(CASE WHEN State = 'California' AND Type = 'CDP' THEN 1 ELSE 0 END) FROM `Store Locations`	regional_sales
SELECT T1.OrderNumber, T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE REPLACE(T1.`Unit Price`, ',', '') = ( SELECT REPLACE(T1.`Unit Price`, ',', '') FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID ORDER BY REPLACE(T1.`Unit Price`, ',', '') LIMIT 1 )	regional_sales
SELECT T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T1.OrderDate LIKE '%/%/19' ORDER BY REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') DESC LIMIT 1	regional_sales
SELECT AVG(REPLACE(T1.`Unit Price`, ',', '')) FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T2.`Product Name` = 'Cookware'	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T1.OrderDate = '5/31/18' THEN T2.`Sales Team` ELSE NULL END AS T FROM `Sales Orders` T1 INNER JOIN `Sales Team` T2 ON T2.SalesTeamID = T1._SalesTeamID ) WHERE T IS NOT NULL	regional_sales
SELECT T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.OrderDate LIKE '%/%/19' GROUP BY T2.`Sales Team` ORDER BY COUNT(T1.OrderNumber) ASC LIMIT 1	regional_sales
SELECT SUBSTR(T1.OrderDate, -2, 2) FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.`Sales Team` = 'George Lewis' GROUP BY SUBSTR(T1.OrderDate, -2, 2) ORDER BY COUNT(T1.OrderNumber) DESC LIMIT 1	regional_sales
SELECT CAST(SUM(CASE WHEN T2.County = 'Orange County' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.OrderDate LIKE '%/%/18'	regional_sales
SELECT OrderNumber FROM `Sales Orders` WHERE REPLACE(`Unit Price`, ',', '') = ( SELECT REPLACE(`Unit Price`, ',', '') FROM `Sales Orders` ORDER BY REPLACE(`Unit Price`, ',', '') DESC LIMIT 1 )	regional_sales
SELECT _SalesTeamID FROM `Sales Orders` WHERE OrderDate LIKE '%/%/18' GROUP BY _SalesTeamID ORDER BY COUNT(_SalesTeamID) DESC LIMIT 1	regional_sales
SELECT DISTINCT T FROM ( SELECT IIF(OrderNumber = 'SO - 000103', `Unit Cost`, NULL) AS T FROM `Sales Orders` ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN T2.County = 'Maricopa County' AND OrderDate LIKE '%/%/20' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID	regional_sales
SELECT T2.Latitude, T2.Longitude FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.OrderNumber = 'SO - 000115'	regional_sales
SELECT COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.OrderDate LIKE '%/%/19' GROUP BY T2.`City Name` HAVING COUNT(T1.OrderNumber)	regional_sales
SELECT DISTINCT IIF(COUNT(T2.CustomerID) > 3, T2.`Customer Names`, NULL) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID WHERE T1.OrderDate LIKE '%/%/18' GROUP BY T1._CustomerID HAVING COUNT(T2.CustomerID)	regional_sales
SELECT SUM(CASE WHEN SUBSTR(T1.OrderDate, -2) IN ('18', '19', '20') AND T2.`Customer Names` = 'Medsep Group' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN SUM(T1.`Order Quantity`) > 5 THEN T2.`Customer Names` END AS T FROM `Sales Orders` T1 INNER JOIN Customers T2 ON T2.CustomerID = T1._CustomerID WHERE T1.OrderDate = '6/1/18' GROUP BY T1._CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT CAST(SUM(CASE WHEN REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') > 1000 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.`Sales Team` = 'Stephen Payne'	regional_sales
SELECT SUM(CASE WHEN Region = 'Northeast' THEN 1 ELSE 0 END) FROM `Sales Team`	regional_sales
SELECT DISTINCT `City Name`, Latitude, Longitude FROM `Store Locations` WHERE County = 'Maricopa County'	regional_sales
SELECT OrderNumber FROM `Sales Orders` WHERE REPLACE(`Unit Cost`, ',', '') = ( SELECT REPLACE(`Unit Cost`, ',', '') FROM `Sales Orders` ORDER BY REPLACE(`Unit Cost`, ',', '') DESC LIMIT 1 )	regional_sales
SELECT T FROM ( SELECT CASE  WHEN ProductID BETWEEN 30 AND 40 THEN `Product Name` ELSE NULL END AS T FROM Products ) WHERE T IS NOT NULL	regional_sales
SELECT ( SELECT REPLACE(`Unit Cost`, ',', '') FROM `Sales Orders` WHERE REPLACE(`Unit Cost`, ',', '') = ( SELECT REPLACE(`Unit Cost`, ',', '') FROM `Sales Orders` ORDER BY REPLACE(`Unit Cost`, ',', '') DESC LIMIT 1 ) ORDER BY REPLACE(`Unit Cost`, ',', '') DESC LIMIT 1 ) / ( SELECT REPLACE(`Unit Cost`, ',', '') FROM `Sales Orders` WHERE REPLACE(`Unit Cost`, ',', '') = ( SELECT REPLACE(`Unit Cost`, ',', '') FROM `Sales Orders` ORDER BY REPLACE(`Unit Cost`, ',', '') ASC LIMIT 1 ) ORDER BY REPLACE(`Unit Cost`, ',', '') ASC LIMIT 1 )	regional_sales
SELECT T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T1.OrderDate LIKE '%/%/18' GROUP BY T1._ProductID ORDER BY COUNT(T1._ProductID) DESC LIMIT 1	regional_sales
SELECT SUM(CASE WHEN T2.`Sales Team` = 'Adam Hernandez' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.`City Name` = 'Daly City' THEN T1.OrderNumber END AS T FROM `Sales Orders` T1 INNER JOIN `Store Locations` T2 ON T2.StoreID = T1._StoreID ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN T1.`Customer Names` = 'Rochester Ltd' THEN 1 ELSE 0 END) FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID	regional_sales
SELECT T1.OrderNumber FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID WHERE T2.`Customer Names` = 'Qualitest ' ORDER BY T1.`Order Quantity` DESC LIMIT 1	regional_sales
SELECT DISTINCT T1.OrderNumber, T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T1.`Sales Channel` = 'In-Store'	regional_sales
SELECT SUM(CASE WHEN T1.OrderDate LIKE '5/%/18' AND T1.`Sales Channel` = 'Online' AND T2.`City Name` = 'Norman' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID	regional_sales
SELECT T1.`Product Name` FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Store Locations` AS T3 ON T3.StoreID = T2._StoreID WHERE T3.County = 'Maricopa County' ORDER BY T2.`Order Quantity` ASC LIMIT 1	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.`Sales Team` = 'Samuel Fowler' THEN T1.OrderNumber ELSE NULL END AS T FROM `Sales Orders` T1 INNER JOIN `Sales Team` T2 ON T2.SalesTeamID = T1._SalesTeamID ) WHERE T IS NOT NULL	regional_sales
SELECT COUNT(T2.OrderNumber) FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID WHERE T1.`Product Name` = 'Baseball' AND T2.OrderDate LIKE '12/%/18'	regional_sales
SELECT CAST(SUM(T2.`Order Quantity`) AS REAL) / 12 FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID WHERE T1.`Product Name` = 'Ornaments' AND T2.OrderDate LIKE '%/%/18'	regional_sales
SELECT CAST(SUM(CASE WHEN T3.`City Name` = 'Burbank' THEN T2.`Order Quantity` ELSE 0 END) AS REAL) * 100 / SUM(T2.`Order Quantity`) FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Store Locations` AS T3 ON T3.StoreID = T2._StoreID WHERE T2.OrderDate LIKE '%/%/18'	regional_sales
SELECT SUM(IIF(WarehouseCode = 'WARE-MKL1006', 1, 0)) - SUM(IIF(WarehouseCode = 'WARE-NBV1002', 1, 0)) AS difference FROM `Sales Orders`	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.DeliveryDate LIKE '%/%/21' AND T1.`Customer Names` = 'Sundial ' THEN T3.`Product Name` END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products T3 ON T3.ProductID = T2._ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT DISTINCT T2.StoreID, T1.Region FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T2.State = 'Michigan'	regional_sales
SELECT SUM(CASE WHEN T2.`Customer Names` = 'Apollo Ltd' THEN 1 ELSE 0 END), SUM(CASE WHEN T2.`Customer Names` = 'Pacific Ltd' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID	regional_sales
SELECT T2.StoreID FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T2.`City Name` = 'Aurora (Township)' OR T2.`City Name` = 'Babylon (Town)' GROUP BY T2.StoreID ORDER BY COUNT(T1.OrderNumber) DESC LIMIT 1	regional_sales
SELECT DISTINCT T1.`Customer Names`, T4.`Product Name` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN `Sales Team` AS T3 ON T3.SalesTeamID = T2._SalesTeamID INNER JOIN Products AS T4 ON T4.ProductID = T2._ProductID WHERE T3.`Sales Team` = 'Anthony Torres' AND T2.`Sales Channel` = 'Distributor'	regional_sales
SELECT DISTINCT `Customer Names`, CustomerID FROM ( SELECT T2.`Customer Names`, T2.CustomerID , SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) AS T FROM `Sales Orders` T1 INNER JOIN Customers T2 ON T2.CustomerID = T1._CustomerID WHERE T1.`Sales Channel` = 'Online' GROUP BY T2.CustomerID ) WHERE T > 5000	regional_sales
SELECT SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T1.DeliveryDate LIKE '%/%/21' AND T2.`Product Name` = 'Floral'	regional_sales
SELECT COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T2.Population BETWEEN 3000000 AND 4000000	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T3.`Time Zone` = 'Pacific/Honolulu' AND T2.`Sales Channel` = 'Wholesale' THEN T1.`Product Name` ELSE NULL END AS T FROM Products T1 INNER JOIN `Sales Orders` T2 ON T2._ProductID = T1.ProductID INNER JOIN `Store Locations` T3 ON T3.StoreID = T2._StoreID ) WHERE T IS NOT NULL	regional_sales
SELECT DISTINCT OrderNumber, `Product Name` FROM ( SELECT IIF(T2.OrderDate = '6/6/18', T2.OrderNumber, NULL) AS "OrderNumber" , IIF(T2.OrderDate = '6/6/18', T1.`Product Name`, NULL) AS "Product Name" FROM Products T1 INNER JOIN `Sales Orders` T2 ON T2._ProductID = T1.ProductID ) WHERE OrderNumber IS NOT NULL AND `Product Name` IS NOT NULL	regional_sales
SELECT COUNT(T1.OrderNumber) / 3 FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID WHERE (T1.OrderDate LIKE '%/%/18' AND T2.`Customer Names` = 'Weimei Corp') OR (T1.OrderDate LIKE '%/%/19' AND T2.`Customer Names` = 'Weimei Corp') OR (T1.OrderDate LIKE '%/%/20' AND T2.`Customer Names` = 'Weimei Corp')	regional_sales
SELECT CAST(SUM(CASE WHEN T2.WarehouseCode = 'WARE-NMK1003' THEN 1 ELSE 0 END) AS REAL) / 12 , CAST(SUM(CASE WHEN T2.WarehouseCode = 'WARE-NMK1003' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.OrderNumber), COUNT(CASE WHEN T1.`Product Name` = 'Floor Lamps' AND T2.WarehouseCode = 'WARE-NMK1003' THEN T2.`Order Quantity` ELSE NULL END) FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID WHERE T2.OrderDate LIKE '%/%/19'	regional_sales
SELECT DISTINCT T FROM ( SELECT IIF(_CustomerID = 11, ProcuredDate, NULL) AS T FROM `Sales Orders` ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN `Order Quantity` = 1 AND `Sales Channel` = 'Distributor' THEN 1 ELSE 0 END) FROM `Sales Orders`	regional_sales
SELECT DISTINCT T FROM ( SELECT CASE  WHEN `Discount Applied` = '0.1' AND `Sales Channel` = 'In-Store' THEN _SalesTeamID ELSE NULL END AS T FROM `Sales Orders` ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN Population < 3000000 AND Type = 'Borough' AND `City Name` = 'Brooklyn' THEN 1 ELSE 0 END) FROM `Store Locations`	regional_sales
SELECT COUNT(DISTINCT T) FROM ( SELECT CASE  WHEN Region = 'Midwest' THEN State ELSE NULL END AS T FROM Regions ) WHERE T IS NOT NULL	regional_sales
SELECT T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID GROUP BY T1._ProductID ORDER BY SUM(REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '')) DESC LIMIT 10	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.`Order Quantity` = 3 AND T2.OrderDate LIKE '2/%/18' THEN T1.`Customer Names` END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) WHERE T IS NOT NULL	regional_sales
SELECT DISTINCT T3.`Sales Team` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN `Sales Team` AS T3 ON T3.SalesTeamID = T2._SalesTeamID WHERE T1.`Customer Names` = 'Apotheca, Ltd'	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T3.WarehouseCode = 'WARE-UHY1004' THEN T1.Region END AS T FROM Regions T1 INNER JOIN `Store Locations` T2 ON T2.StateCode = T1.StateCode INNER JOIN `Sales Orders` T3 ON T3._StoreID = T2.StoreID ) WHERE T IS NOT NULL	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T4.`Product Name` = 'Audio' AND T3.`Sales Team` = 'Shawn Torres' THEN T1.`City Name` ELSE NULL END AS T FROM `Store Locations` T1 INNER JOIN `Sales Orders` T2 ON T2._StoreID = T1.StoreID INNER JOIN `Sales Team` T3 ON T3.SalesTeamID = T2._SalesTeamID INNER JOIN Products T4 ON T4.ProductID = T2._ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT T3.`Product Name`, T1.`Customer Names` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products AS T3 ON T3.ProductID = T2._ProductID WHERE T2.OrderDate = '10/21/18' AND T2.DeliveryDate = '11/21/19'	regional_sales
SELECT SUM(CASE WHEN T1.ProcuredDate = '10/27/18' AND T2.`City Name` = 'Orlando' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID	regional_sales
SELECT `Sales Channel` FROM ( SELECT T1.`Sales Channel` FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID ORDER BY T2.`Median Income` DESC LIMIT 3 ) GROUP BY `Sales Channel` ORDER BY COUNT(`Sales Channel`) DESC LIMIT 1	regional_sales
SELECT T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID ORDER BY REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') DESC LIMIT 5	regional_sales
SELECT MAX(T1.`Discount Applied`) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T2.State = 'Colorado' AND T2.`Land Area` = 111039036	regional_sales
SELECT COUNT(DISTINCT T2.`Time Zone`) FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T1.Region = 'Northeast'	regional_sales
SELECT DISTINCT CASE WHEN MAX(T2.Population) THEN T2.Type END FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode	regional_sales
SELECT T2.Region FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.WarehouseCode = 'WARE-MKL1006' GROUP BY T2.Region ORDER BY COUNT(T1.OrderNumber) DESC LIMIT 1	regional_sales
SELECT T2.`City Name` FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE REPLACE(T1.`Unit Price`, ',', '') = ( SELECT REPLACE(T1.`Unit Price`, ',', '') FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID ORDER BY REPLACE(T1.`Unit Price`, ',', '') DESC LIMIT 1 ) ORDER BY REPLACE(T1.`Unit Price`, ',', '') DESC LIMIT 1	regional_sales
SELECT SUM(CASE WHEN T1.`Sales Channel` = 'Online' AND T2.`Customer Names` = 'Ole Group' AND T1.OrderDate LIKE '5/%/19' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID	regional_sales
SELECT SUM(CASE WHEN T1.`Order Quantity` = 1 AND T1.`Sales Channel` = 'Distributor' AND T2.County = 'Washtenaw County' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID	regional_sales
SELECT T1.`Product Name` FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Store Locations` AS T3 ON T3.StoreID = T2._StoreID WHERE T3.`City Name` = 'Santa Clarita' GROUP BY T1.`Product Name` ORDER BY COUNT(T1.`Product Name`) ASC LIMIT 1	regional_sales
SELECT T2.Latitude, T2.Longitude FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.WarehouseCode = 'WARE-PUJ1005' GROUP BY T2.StoreID ORDER BY COUNT(T1.WarehouseCode) ASC LIMIT 1	regional_sales
SELECT CAST(SUM(CASE WHEN T2.State = 'New York' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.OrderNumber) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.OrderDate = '4/4/20'	regional_sales
SELECT AVG(T2.`Land Area`) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T1.`Unit Price` = '998.30'	regional_sales
SELECT AVG(T2.`Household Income`) FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T2.State = 'New Hampshire' AND T2.Type = 'City'	regional_sales
SELECT SUM(CASE WHEN Region = 'Midwest' THEN 1 ELSE 0 END) FROM `Sales Team`	regional_sales
SELECT DISTINCT T FROM ( SELECT CASE  WHEN OrderDate > '1/1/18' THEN OrderNumber ELSE NULL END AS T FROM `Sales Orders` ) WHERE T IS NOT NULL	regional_sales
SELECT COUNT(T1.`Sales Channel`) FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.Region = 'Midwest'	regional_sales
SELECT T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE REPLACE(T1.`Unit Price`, ',', '') = ( SELECT REPLACE(T1.`Unit Price`, ',', '') FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID ORDER BY REPLACE(T1.`Unit Price`, ',', '') DESC LIMIT 1 ) ORDER BY REPLACE(T1.`Unit Price`, ',', '') DESC LIMIT 1	regional_sales
SELECT T2.Region FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.`Sales Channel` = 'Online' ORDER BY T1.`Discount Applied` DESC LIMIT 1	regional_sales
SELECT T1.OrderNumber, T1.OrderDate FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID WHERE T2.`Customer Names` = 'Apollo Ltd' ORDER BY T1.`Unit Price` DESC LIMIT 1	regional_sales
SELECT DISTINCT T1.OrderNumber, T1.WarehouseCode FROM `Sales Orders` AS T1 INNER JOIN Customers AS T2 ON T2.CustomerID = T1._CustomerID WHERE T2.`Customer Names` = 'Elorac, Corp'	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T3.`Product Name` = 'Cocktail Glasses' AND T2.`Sales Channel` = 'Online' THEN T1.`Customer Names` END AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID INNER JOIN Products T3 ON T3.ProductID = T2._ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT T2.StoreID FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID WHERE T2.State = 'Arizona' ORDER BY T1.`Unit Price` - T1.`Unit Cost` DESC LIMIT 1	regional_sales
SELECT SUM(CASE WHEN T3.State = 'Florida' THEN T2.`Unit Price` ELSE 0 END) - SUM(CASE WHEN T3.State = 'Texas' THEN T2.`Unit Price` ELSE 0 END) FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Store Locations` AS T3 ON T3.StoreID = T2._StoreID WHERE T1.`Product Name` = 'Computers'	regional_sales
SELECT DISTINCT T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T2.Region = 'Midwest' AND T1.`Order Quantity` > 5	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.State = 'California' AND T1.`Sales Channel` = 'In-Store' AND T1.`Discount Applied` = 0.2 THEN T2.StoreID END AS T FROM `Sales Orders` T1 INNER JOIN `Store Locations` T2 ON T2.StoreID = T1._StoreID ) WHERE T IS NOT NULL	regional_sales
SELECT T1.`Customer Names` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID WHERE T2.OrderDate LIKE '%/%/18' OR T2.OrderDate LIKE '%/%/19' OR T2.OrderDate LIKE '%/%/20' ORDER BY T2.`Order Quantity` DESC LIMIT 1	regional_sales
SELECT SUM(CASE WHEN T1.`Product Name` = 'Candles' THEN T2.`Order Quantity` ELSE 0 END), CAST(SUM(CASE WHEN T1.`Product Name` = 'Candles' THEN T2.`Order Quantity` ELSE 0 END) AS REAL) * 100 / SUM(T2.`Order Quantity`) FROM Products AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._ProductID = T1.ProductID INNER JOIN `Store Locations` AS T3 ON T3.StoreID = T2._StoreID	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN `Sales Team` = 'Joshua Bennett' THEN Region ELSE NULL END AS T FROM `Sales Team` ) WHERE T IS NOT NULL	regional_sales
SELECT CASE WHEN MAX(Population) THEN StoreID END FROM `Store Locations`	regional_sales
SELECT SUM(CASE WHEN Region = 'Midwest' THEN 1 ELSE 0 END) FROM `Sales Team`	regional_sales
SELECT CASE WHEN MAX(`Water Area`) THEN Type END FROM `Store Locations`	regional_sales
SELECT SUM(IIF(ShipDate LIKE '6/%/18' AND `Sales Channel` = 'Online', 1, 0)) FROM `Sales Orders`	regional_sales
SELECT `Discount Applied` FROM `Sales Orders` WHERE REPLACE(`Unit Price`, ',', '') = ( SELECT REPLACE(`Unit Price`, ',', '') FROM `Sales Orders` ORDER BY REPLACE(`Unit Price`, ',', '') DESC LIMIT 1 ) ORDER BY REPLACE(`Unit Price`, ',', '') DESC LIMIT 1	regional_sales
SELECT T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID ORDER BY REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') DESC LIMIT 1	regional_sales
SELECT AVG(T2.`Household Income`) FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode WHERE T1.Region = 'Northeast' GROUP BY T2.State ORDER BY COUNT(T2.StoreID) DESC LIMIT 1	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.`Median Income` < 30000 THEN T1.Region END AS T FROM Regions T1 INNER JOIN `Store Locations` T2 ON T2.StateCode = T1.StateCode ) WHERE T IS NOT NULL	regional_sales
SELECT SUM(CASE WHEN T1.Region = 'West' AND T2.`Land Area` < 20000000 THEN 1 ELSE 0 END) FROM Regions AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StateCode = T1.StateCode	regional_sales
SELECT `Customer Names` FROM ( SELECT T1.`Customer Names`, T2.`Unit Price` - T2.`Unit Cost` AS "net profit" FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) ORDER BY `net profit` DESC LIMIT 1	regional_sales
SELECT COUNT(T1.OrderNumber), T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.OrderDate LIKE '%/%/19' AND T1.ShipDate LIKE '%/%/19' GROUP BY T2.`Sales Team` ORDER BY COUNT(T1.OrderNumber) DESC LIMIT 1	regional_sales
SELECT T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID WHERE T1.`Order Quantity` > 5 AND ShipDate LIKE '5/%/19' ORDER BY REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') ASC LIMIT 1	regional_sales
SELECT T2.Latitude, T2.Longitude FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID ORDER BY REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') DESC LIMIT 3, 1	regional_sales
SELECT COUNT(T1.OrderNumber), T2.`Sales Team` FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE T1.ShipDate LIKE '%/%/20' GROUP BY T2.`Sales Team` ORDER BY COUNT(T1.OrderNumber) DESC LIMIT 1	regional_sales
SELECT CAST(COUNT(T1.OrderNumber) AS REAL) / 3 FROM `Sales Orders` AS T1 INNER JOIN `Sales Team` AS T2 ON T2.SalesTeamID = T1._SalesTeamID WHERE (T2.`Sales Team` = 'Carl Nguyen' AND ShipDate LIKE '%/%/18') OR (T2.`Sales Team` = 'Carl Nguyen' AND ShipDate LIKE '%/%/19') OR (T2.`Sales Team` = 'Carl Nguyen' AND ShipDate LIKE '%/%/20')	regional_sales
SELECT T1.`Unit Price` * T1.`Discount Applied`, T2.`Product Name` FROM `Sales Orders` AS T1 INNER JOIN Products AS T2 ON T2.ProductID = T1._ProductID ORDER BY REPLACE(T1.`Unit Price`, ',', '') - REPLACE(T1.`Unit Cost`, ',', '') DESC LIMIT 1	regional_sales
SELECT `Customer Names` FROM ( SELECT T1.`Customer Names` , REPLACE(T2.`Unit Price`, ',', '') * T2.`Order Quantity` - REPLACE(T2.`Unit Price`, ',', '') * T2.`Discount Applied` AS T FROM Customers T1 INNER JOIN `Sales Orders` T2 ON T2._CustomerID = T1.CustomerID ) ORDER BY T DESC LIMIT 3	regional_sales
SELECT `Sales Channel` FROM `Sales Orders` WHERE OrderDate LIKE '1/%/20' GROUP BY `Sales Channel` ORDER BY COUNT(`Sales Channel`) DESC LIMIT 1	regional_sales
SELECT T FROM ( SELECT DISTINCT CASE  WHEN T2.OrderNumber = 'SO - 0005951' THEN T1.`Product Name` ELSE NULL END AS T FROM Products T1 INNER JOIN `Sales Orders` T2 ON T2._ProductID = T1.ProductID ) WHERE T IS NOT NULL	regional_sales
SELECT T3.`Sales Team`, T1.`City Name` FROM `Store Locations` AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._StoreID = T1.StoreID INNER JOIN `Sales Team` AS T3 ON T3.SalesTeamID = T2._SalesTeamID WHERE T2.OrderNumber = 'SO - 0001004'	regional_sales
SELECT T1.`Customer Names` FROM Customers AS T1 INNER JOIN `Sales Orders` AS T2 ON T2._CustomerID = T1.CustomerID INNER JOIN `Store Locations` AS T3 ON T3.StoreID = T2._StoreID WHERE T3.`City Name` = 'Gilbert' AND T2.ProcuredDate LIKE '%/%/19' ORDER BY REPLACE(T2.`Unit Price`, ',', '') - REPLACE(T2.`Unit Cost`, ',', '') DESC LIMIT 1	regional_sales
SELECT SUM(CASE WHEN T2.`City Name` = 'Chandler' AND T1.OrderDate LIKE '%/%/20' THEN 1 ELSE 0 END) FROM `Sales Orders` AS T1 INNER JOIN `Store Locations` AS T2 ON T2.StoreID = T1._StoreID	regional_sales
SELECT AVG(`Household Income`) FROM `Store Locations` WHERE `City Name` = 'Glendale'	regional_sales
SELECT MAX(`Discount Applied`) FROM `Sales Orders` WHERE OrderDate LIKE '%/%/20'	regional_sales
SELECT COUNT(*) FROM matchs WHERE season = 2008 AND AwayTeam = 'Ebbsfleet' AND FTR = 'D'	european_football_1
SELECT CAST(COUNT(CASE WHEN country = 'England' THEN division ELSE NULL END) AS REAL) * 100 / COUNT(division) FROM divisions	european_football_1
SELECT CAST(COUNT(CASE WHEN FTR = 'H' THEN 1 ELSE NULL END) / COUNT(HomeTeam) AS REAL) * 100, CAST(COUNT(CASE WHEN FTR = 'A' THEN 1 ELSE NULL END) AS REAL) / COUNT(HomeTeam), CAST(COUNT(CASE WHEN FTR = 'D' THEN 1 ELSE NULL END) AS REAL) / COUNT(HomeTeam) FROM matchs WHERE HomeTeam = 'Cittadella'	european_football_1
SELECT AwayTeam FROM matchs WHERE HomeTeam = 'Caen' AND season = 2010 AND FTR = 'A' GROUP BY AwayTeam ORDER BY COUNT(AwayTeam) DESC LIMIT 1	european_football_1
SELECT CAST(SUM(CASE WHEN Div = 'F1' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Div) FROM matchs WHERE Date = '2005-07-30' 	european_football_1
SELECT CAST(SUM(CASE WHEN HomeTeam = 'Sassuolo' OR AwayTeam = 'Sassuolo' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(FTR) FROM matchs WHERE FTR = 'D'	european_football_1
SELECT CAST(SUM(CASE WHEN FTAG = 2 THEN 1 ELSE 0 END) / COUNT(FTAG) AS REAL) * 100 FROM matchs WHERE season = 2017	european_football_1
SELECT T1.HomeTeam,T1.AwayTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div=T2.division WHERE T2.name = 'EFL League One' and T1.Div = 'E2' 	european_football_1
SELECT COUNT(DISTINCT CASE WHEN T1.FTHG >= 4 THEN HomeTeam ELSE NULL end) + COUNT(DISTINCT CASE WHEN T1.FTAG >= 4 THEN AwayTeam ELSE NULL end) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.country = 'Greece' 	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2019 AND T2.name = 'Scottish Championship' AND T1.FTAG = 2 AND T1.FTHG = 2	european_football_1
SELECT T1.HomeTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.country = 'Scotland' AND T1.FTHG = 10	european_football_1
SELECT T1.HomeTeam HWHT , CAST(COUNT(CASE WHEN T1.FTR = 'H' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(HomeTeam) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'LaLiga' AND T2.country = 'Spain' AND T1.season = 2017	european_football_1
SELECT ( SELECT COUNT(T1.Div) AS total FROM matchs T1 INNER JOIN divisions T2 ON T2.division = T1.Div WHERE T2.country = 'England' AND T1.season = 2012 ) AS num , CASE WHEN 1 THEN T.result END AS percentage FROM ( SELECT 100.0 * COUNT(T1.Div) / ( SELECT COUNT(T1.Div) FROM matchs T1 INNER JOIN divisions T2 ON T2.division = T1.Div WHERE T2.country = 'England' AND T1.season = 2012 ) AS result FROM matchs T1 INNER JOIN divisions T2 ON T2.division = T1.Div WHERE T2.country = 'England' AND T1.season = 2012 GROUP BY T2.division ) AS T	european_football_1
SELECT ( SELECT MAX(MAX(FTAG), MAX(FTHG)) FROM matchs WHERE season = 2021 ) AS T1, AwayTeam FROM matchs WHERE season = 2021 AND FTHG = T1 OR FTAG = T1	european_football_1
SELECT HomeTeam FROM matchs WHERE Div = 'P1' AND season = 2021 ORDER BY FTHG DESC LIMIT 1	european_football_1
SELECT CAST(COUNT(CASE WHEN FTR = 'H' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(FTR) - CAST(COUNT(CASE WHEN FTR = 'A' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(FTR) DIFFERENCE FROM matchs WHERE season = 2010	european_football_1
SELECT Div FROM matchs WHERE season = 2008 AND FTR = 'D' GROUP BY Div ORDER BY COUNT(FTR) DESC LIMIT 1	european_football_1
SELECT HomeTeam FROM matchs WHERE Div = 'EC' AND Date = '2008-01-20' AND FTR = 'H'	european_football_1
SELECT T2.name FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.Date = '2009-09-13' and T1.HomeTeam = 'Club Brugge' AND T1.AwayTeam = 'Genk'	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Scottish Premiership' AND (T1.season BETWEEN 2006 AND 2008)	european_football_1
SELECT DISTINCT T2.division,T2.country FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.HomeTeam = 'Hearts' AND T1.AwayTeam = 'Hibernian'	european_football_1
SELECT T1.AwayTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div=T2.division WHERE T2.name = 'Bundesliga' ORDER BY T1.FTAG DESC LIMIT 1	european_football_1
SELECT T1.AwayTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div=T2.division WHERE T2.country = 'Italy' LIMIT 3	european_football_1
SELECT T2.name FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2019 AND T1.FTR = 'D' GROUP BY T2.division ORDER BY COUNT(FTR) LIMIT 1	european_football_1
SELECT COUNT(T1.HomeTeam) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'LaLiga' AND T1.HomeTeam = 'Valencia' AND T1.FTR = 'H'	european_football_1
SELECT COUNT(T1.FTR) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Seria A' AND T1.FTR = 'D'	european_football_1
SELECT COUNT(division) FROM divisions WHERE country = 'England'	european_football_1
SELECT name FROM divisions WHERE country = 'Netherlands'	european_football_1
SELECT CASE WHEN FTR = 'H' THEN 'East Fife' ELSE 'Dumbarton' END WINNER FROM matchs WHERE Date = '2009-10-10' AND HomeTeam = 'East Fife' AND AwayTeam = 'Dumbarton'	european_football_1
SELECT FTHG, FTAG FROM matchs WHERE Date = '2009-04-26' AND HomeTeam = 'Bursaspor' AND AwayTeam = 'Denizlispor'	european_football_1
SELECT MIN(Date) FROM matchs WHERE FTHG + FTAG > 10	european_football_1
SELECT CASE WHEN T1.FTR = 'H' THEN T1.HomeTeam ELSE T1.AwayTeam END WINNER FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Ligue 2' ORDER BY T1.FTAG + T1.FTHG DESC LIMIT 1	european_football_1
SELECT COUNT(T1.FTR) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'LaLiga 2' AND T1.Date = '2016-03-27' AND T1.FTR = 'A'	european_football_1
SELECT COUNT(T1.FTR) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'National League' AND T1.Date = '2018-08-07' AND T1.FTR = 'D'	european_football_1
SELECT T2.country FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division GROUP BY T2.country ORDER BY SUM(T1.FTAG) DESC LIMIT 1	european_football_1
SELECT T2.division, T2.name FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2011 AND T1.FTHG = 1 AND T1.FTAG = 8	european_football_1
SELECT T2.division, T2.name FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.Date = '2020-02-22' AND T1.FTAG + T1.FTHG > 5 ORDER BY T1.FTAG + T1.FTHG DESC LIMIT 1	european_football_1
SELECT T2.name FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.FTAG = 0 AND T1.FTHG = 0 GROUP BY T2.division ORDER BY COUNT(T1.FTAG) DESC LIMIT 1	european_football_1
SELECT COUNT(T1.Date) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Scottish League One' AND T1.Date = ( SELECT Date FROM matchs WHERE FTHG = 5 AND FTAG = 2 AND HomeTeam = 'Pro Vercelli' AND AwayTeam = 'Pescara' )	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.country = 'Greece' AND T1.FTHG = 5 AND T1.FTAG = 0	european_football_1
SELECT DISTINCT T2.country FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.HomeTeam = 'Bradford' OR T1.AwayTeam = 'Bradford'	european_football_1
SELECT COUNT(DISTINCT T1.HomeTeam) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Eredivisie' AND T1.season = 2008	european_football_1
SELECT CAST(COUNT(CASE WHEN T1.FTR = 'H' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.FTR) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2021 AND T2.name = 'Bundesliga'	european_football_1
SELECT CAST(COUNT(CASE WHEN T2.name = 'Liga NOS' THEN T1.Div ELSE NULL END) AS REAL) * 100 / COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.FTHG = 1 AND FTAG = 1	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2021 AND T2.name = 'Premier League'	european_football_1
SELECT T1.HomeTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.Date = '2020-10-02' AND T2.name = 'Bundesliga'	european_football_1
SELECT CASE WHEN T1.FTR = 'H' THEN T1.HomeTeam WHEN T1.FTR = 'A' THEN T1.AwayTeam END WINNER FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.Date = '2020-10-02' AND T2.name = 'Bundesliga'	european_football_1
SELECT T1.HomeTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Bundesliga' AND T1.FTR = 'H' GROUP BY T1.HomeTeam ORDER BY COUNT(T1.FTR) DESC LIMIT 1	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Bundesliga' AND T1.AwayTeam = 'Werder Bremen' AND T1.FTR = 'A'	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Bundesliga' AND T1.FTR = 'A' AND T1.season = 2021	european_football_1
SELECT COUNT(T1.Div) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Bundesliga' AND T1.FTR = 'D'	european_football_1
SELECT COUNT(CASE WHEN T2.name = 'Bundesliga' THEN 1 ELSE NULL END) - COUNT(CASE WHEN T2.name = 'Premier League' THEN 1 ELSE NULL END) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2021 AND T1.FTR = 'H'	european_football_1
SELECT DISTINCT T1.HomeTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2021 AND T1.FTR = 'H' AND T2.name = 'Bundesliga'	european_football_1
SELECT CASE WHEN COUNT(CASE WHEN T1.HomeTeam = 'Augsburg' THEN 1 ELSE NULL END) - COUNT(CASE WHEN T1.HomeTeam = ' Mainz' THEN 1 ELSE NULL END) > 0 THEN 'Augsburg' ELSE 'Mainz' END FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2021 AND T1.FTR = 'H'	european_football_1
SELECT T1.HomeTeam FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Bundesliga' AND T1.season = 2021 ORDER BY T1.FTHG DESC LIMIT 1	european_football_1
SELECT SUM(T1.FTHG) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T2.name = 'Bundesliga' AND T1.season = 2021	european_football_1
SELECT CAST(COUNT(CASE WHEN T1.FTR = 'H' THEN 1 ELSE NULL END) + COUNT(CASE WHEN T1.FTR = 'A' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(t1.FTR) FROM matchs AS T1 INNER JOIN divisions AS T2 ON T1.Div = T2.division WHERE T1.season = 2021 AND T1.AwayTeam = 'Club Brugge' OR T1.HomeTeam = 'Club Brugge'	european_football_1
SELECT CAST(homeWon AS REAL) * 100 / won  FROM teams	professional_basketball
SELECT name FROM teams WHERE CAST(lost AS REAL) * 100 / games > 75	professional_basketball
SELECT T1.name, T1.won FROM teams AS T1 INNER JOIN ( SELECT * FROM teams WHERE year = 2004 ) AS T2 on T1.tmID = T2.tmID WHERE T1.year = 2005 and T1.won > T2.won	professional_basketball
SELECT name, o_pts FROM teams WHERE CAST((homeWon - homeLost) AS REAL) * 100 / games > 80	professional_basketball
SELECT CAST(SUM(CASE WHEN rank = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(name) FROM teams	professional_basketball
SELECT coachID, won, lost FROM coaches WHERE year = 1950 AND tmID = 'BOS'	professional_basketball
SELECT coachID, tmID FROM coaches WHERE year BETWEEN 1970 AND 1980 ORDER BY stint DESC LIMIT 1	professional_basketball
SELECT T1.coachID, T2.name, T2.won FROM coaches AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year = 2000 AND T2.won > 50	professional_basketball
SELECT DISTINCT T1.coachID, T2.tmID, T1.year FROM coaches AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year BETWEEN 2000 AND 2010 AND T2.lost > T2.won	professional_basketball
SELECT T2.name, T1.year, T2.o_pts FROM coaches AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year BETWEEN 1990 AND 1995 AND T1.coachID = 'adelmri01'	professional_basketball
SELECT DISTINCT T2.name, T1.year, T1.coachID FROM coaches AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID WHERE CAST(T2.won AS REAL) * 100 / T2.games > 90	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T1.birthState = 'NY' AND T2.award = 'All-Defensive First Team' AND T2.year BETWEEN 1980 AND 2000	professional_basketball
SELECT DISTINCT T3.divID FROM awards_coaches AS T1 INNER JOIN coaches AS T2 ON T1.coachID = T2.coachID INNER JOIN teams AS T3 ON T2.tmID = T3.tmID WHERE T1.year = 1977 AND T1.award = 'NBA Coach of the Year' AND T3.year = 1976	professional_basketball
SELECT DISTINCT T2.coachID FROM coaches AS T1 INNER JOIN awards_coaches AS T2 ON T1.coachID = T2.coachID INNER JOIN teams AS T3 ON T3.tmID = T1.tmID WHERE T2.award = 'NBA Coach of the Year' AND T2.year BETWEEN 1970 AND 1979 AND T1.year = 1981 AND T3.name = 'Chicago Bulls'	professional_basketball
SELECT T2.nameNick FROM player_allstar AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID WHERE T1.blocks = 2 AND T1.conference = 'West' AND T1.season_id = 2006	professional_basketball
SELECT T2.year FROM series_post AS T1 INNER JOIN teams AS T2 ON T1.tmIDWinner = T2.tmID WHERE T1.round = 'DSF' AND T1.tmIDLoser = 'HSM' ORDER BY T2.rank ASC LIMIT 1	professional_basketball
SELECT T1.birthDate FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.season_id = 1985 ORDER BY T2.assists DESC LIMIT 1	professional_basketball
SELECT DISTINCT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.birthCity = 'Winter Haven' AND T2.season_id BETWEEN 1980 AND 1989 AND T2.minutes = 12	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.conference = 'East' AND T2.minutes <= 5 AND T1.college = 'Illinois'	professional_basketball
SELECT COUNT(DISTINCT playerID) FROM player_allstar WHERE CAST(d_rebounds AS REAL) * 100 / rebounds > 75 AND season_id BETWEEN 1990 AND 2007	professional_basketball
SELECT year FROM coaches WHERE coachID = 'costela01' ORDER BY CAST(won AS REAL) / (won + lost) DESC LIMIT 1	professional_basketball
SELECT SUM(T2.minutes) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.birthCity = 'Brooklyn' AND T1.nameNick LIKE '%Superman%'	professional_basketball
SELECT T3.tmID FROM awards_coaches AS T1 INNER JOIN coaches AS T2 ON T1.coachID = T2.coachID INNER JOIN teams AS T3 ON T3.tmID = T2.tmID WHERE T1.year = 1994 AND T1.award = 'NBA Coach of the Year' GROUP BY T3.tmID ORDER BY SUM(T3.homeLost) DESC LIMIT 1	professional_basketball
SELECT DISTINCT T2.tmID FROM series_post AS T1 INNER JOIN teams AS T2 ON T1.tmIDWinner = T2.tmID WHERE T2.won > 60 AND T1.year = 1996 AND T1.round = 'CSF' AND T1.tmIDLoser = 'LAL'	professional_basketball
SELECT T2.lgID FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID GROUP BY T2.lgID, T1.weight HAVING T1.weight = MAX(T1.weight) - MAX(T1.weight) * 0.4	professional_basketball
SELECT coachID FROM coaches GROUP BY coachID HAVING COUNT(DISTINCT tmID) > 2	professional_basketball
SELECT coachID FROM coaches ORDER BY post_wins DESC LIMIT 1	professional_basketball
SELECT coachID FROM coaches WHERE lgID = 'NBA' AND post_wins != 0 AND post_losses != 0 AND coachID IN ( SELECT coachID FROM coaches WHERE lgID = 'NBA' GROUP BY coachID HAVING COUNT(tmID) > 2 ) ORDER BY post_losses ASC LIMIT 1	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.lgID = 'ABA' AND (T1.pos = 'C' OR T1.pos = 'F-C')	professional_basketball
SELECT DISTINCT T1.firstName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE (T1.pos = 'F' OR T1.pos = 'F-C') AND T2.lgID = 'NBA'	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.hsCity = 'Chicago' AND T2.conference = 'West'	professional_basketball
SELECT DISTINCT T1.college FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.conference = 'East'	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T1.birthCity = 'Spencer' AND T2.lgID = 'NBL'	professional_basketball
SELECT T1.birthDate FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Most Valuable Player' GROUP BY T1.playerID, T1.birthDate ORDER BY COUNT(award) DESC LIMIT 1	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Most Valuable Player' AND T1.birthCity = 'Houston'	professional_basketball
SELECT T1.height FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Rookie of the Year' ORDER BY T1.height DESC LIMIT 1	professional_basketball
SELECT AVG(T1.weight) FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Rookie of the Year'	professional_basketball
SELECT AVG(T1.height) FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Most Valuable Player' AND T1.birthCity = 'New York'	professional_basketball
SELECT tmID FROM players_teams WHERE year = 2000 GROUP BY tmID ORDER BY SUM(PostPoints) DESC LIMIT 10	professional_basketball
SELECT name FROM teams WHERE CAST(won AS REAL) * 100 / (won + lost) < 50	professional_basketball
SELECT coachID FROM coaches GROUP BY tmID, coachID, won, lost HAVING CAST(won AS REAL) * 100 / (won + lost) > 80	professional_basketball
SELECT coachID FROM coaches WHERE lgID = 'NBA' GROUP BY coachID HAVING MAX(year) - MIN(year) > 10	professional_basketball
SELECT COUNT(DISTINCT T4.name) FROM ( SELECT T1.name, SUM(T2.points) FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year INNER JOIN awards_players AS T3 ON T2.playerID = T3.playerID WHERE T3.award = 'Most Valuable Player' GROUP BY T1.name HAVING SUM(T2.points) >= 3800 ) AS T4	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.tmID = 'AFS' ORDER BY T1.height DESC LIMIT 1	professional_basketball
SELECT T1.lastName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.tmID = 'BLB'	professional_basketball
SELECT COUNT(DISTINCT coachID) FROM awards_coaches WHERE year BETWEEN 1962 AND 1975	professional_basketball
SELECT coachID FROM awards_coaches WHERE year BETWEEN 1970 AND 1990 GROUP BY coachID, award HAVING COUNT(award) = 2	professional_basketball
SELECT COUNT(DISTINCT coachID) FROM awards_coaches WHERE year BETWEEN 1962 AND 2011 AND award = 'ABA Coach of the Year' AND coachID IN ( SELECT coachID FROM awards_coaches WHERE year BETWEEN 1962 AND 2011 AND award = 'NBA Coach of the Year' )	professional_basketball
SELECT AVG(T2.points) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.season_id = 1975	professional_basketball
SELECT DISTINCT T1.lastName, T1.firstName FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.height > 75	professional_basketball
SELECT MIN(T1.weight) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.college = 'UCLA'	professional_basketball
SELECT MAX(T1.weight) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.birthCountry = 'USA'	professional_basketball
SELECT SUM(T2.points) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.season_id BETWEEN 1960 AND 1970 AND T1.deathDate = '0000-00-00'	professional_basketball
SELECT DISTINCT T1.lastName, T1.firstName FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.birthDate > 1950 AND CAST(T2.o_rebounds AS REAL) * 100 / T2.rebounds > 30	professional_basketball
SELECT COUNT(playerID) FROM awards_players WHERE year BETWEEN 1969 AND 2010 AND award = 'Rookie of the Year'	professional_basketball
SELECT T1.tmID FROM players_teams AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID GROUP BY T1.tmID HAVING COUNT(DISTINCT T1.playerID) >= 3	professional_basketball
SELECT MAX(T2.points) FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year BETWEEN 1950 AND 1970 AND T1.rank = 1	professional_basketball
SELECT T5.lastName, T5.firstName FROM players_teams AS T4 INNER JOIN players AS T5 ON T4.playerID = T5.playerID WHERE T4.year BETWEEN 1937 AND 1940 AND T4.tmID IN ( SELECT DISTINCT T1.tmID FROM teams AS T1 INNER JOIN teams AS T2 INNER JOIN teams AS T3 ON T1.tmID = T2.tmID AND T2.tmID = T3.tmID AND T3.year - T2.year = 1 AND T2.year - T1.year = 1 WHERE T1.rank = 1 AND T1.year BETWEEN 1937 AND 1940 )	professional_basketball
SELECT DISTINCT T1.name FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.rank = 3 AND T1.year BETWEEN 1937 AND 1940 ORDER BY T2.points DESC LIMIT 1	professional_basketball
SELECT COUNT(*) FROM ( SELECT T2.name, SUM(T1.points) FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year = 1937 GROUP BY T2.name HAVING SUM(points) >= 500 ) AS T3	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE CAST(T2.won AS REAL) * 100 / CAST(T2.games AS REAL) > 75 AND T1.year = 1990	professional_basketball
SELECT firstName, lastName FROM players WHERE race = 'B' AND height > 0 ORDER BY height ASC LIMIT 3	professional_basketball
SELECT COUNT(DISTINCT playerID) FROM draft WHERE firstName = 'Joe' AND draftYear = 1970	professional_basketball
SELECT COUNT(fg_made) FROM player_allstar WHERE first_name = 'George' AND last_name = 'Mikan' AND season_id BETWEEN 1951 AND 1953	professional_basketball
SELECT MIN(CAST(weight AS REAL) / (height * height)) , MAX(CAST(weight AS REAL) / (height * height)) FROM players	professional_basketball
SELECT name FROM teams ORDER BY CAST(homeWon AS REAL) / (homeWon + homeLost) DESC LIMIT 1	professional_basketball
SELECT draftYear - strftime('%Y', birthDate) FROM draft AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID WHERE T1.firstName = 'Alexis' AND T1.lastName = 'Ajinca' AND draftRound = 1	professional_basketball
SELECT T1.firstName, T1.lastName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID INNER JOIN teams AS T3 ON T3.tmID = T2.tmID WHERE T3.name = 'Denver Nuggets' AND T2.year > 1980 ORDER BY T1.height DESC LIMIT 1	professional_basketball
SELECT T1.playerID FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE deathDate IS NOT NULL GROUP BY T1.playerID ORDER BY COUNT(award) DESC LIMIT 1	professional_basketball
SELECT T3.name FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID INNER JOIN teams AS T3 ON T3.tmID = T2.tmID WHERE T1.college = 'UCLA' GROUP BY T3.name ORDER BY COUNT(DISTINCT T1.playerID) DESC LIMIT 1	professional_basketball
SELECT AVG(CAST(T1.weight AS REAL) / (T1.height * T1.height)) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID	professional_basketball
SELECT T1.name FROM teams AS T1 INNER JOIN ( SELECT * FROM teams WHERE lgID = 'ABA' AND year = 1972 ) AS T2 ON T1.tmID = T2.tmID WHERE T1.lgID = 'ABA' AND T1.year = 1973 ORDER BY (CAST(T1.won AS REAL) / (T1.won + T1.lost) - (CAST(T2.won AS REAL) / (T2.won + T2.lost))) DESC LIMIT 1	professional_basketball
SELECT T1.firstName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.lgID = 'NBL' GROUP BY T1.playerID, T1.firstName ORDER BY COUNT(PF) DESC LIMIT 1	professional_basketball
SELECT AVG(DISTINCT height) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE conference = 'East'	professional_basketball
SELECT T1.coachID FROM coaches AS T1 INNER JOIN awards_coaches AS T2 ON T1.coachID = T2.coachID WHERE T2.award = 'ABA Coach of the Year' GROUP BY T1.coachID, T1.won ORDER BY T1.won DESC LIMIT 1	professional_basketball
SELECT name FROM teams AS T1 INNER JOIN coaches AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year INNER JOIN awards_coaches AS T3 ON T2.coachID = T3.coachID AND T2.year = T3.year WHERE T3.year = 1992 AND award = 'NBA Coach of the Year'	professional_basketball
SELECT T1.firstName, T1.lastName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE year = 1973 ORDER BY CAST(T2.fgMade AS REAL) / T2.fgAttempted DESC LIMIT 1	professional_basketball
SELECT T1.name FROM teams AS T1 INNER JOIN draft AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.draftYear WHERE T2.firstName = 'Mike' AND T2.lastName = 'Lynn'	professional_basketball
SELECT COUNT(DISTINCT T2.playerID) FROM awards_players AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID WHERE T1.award = 'Most Improved Player' AND T2.birthCountry = 'USA' AND T1.year BETWEEN 1985 AND 1990	professional_basketball
SELECT DISTINCT T1.firstName, T1.lastName FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.college = 'California'	professional_basketball
SELECT COUNT(coachID) FROM awards_coaches WHERE year BETWEEN 1950 AND 1970 GROUP BY coachID HAVING COUNT(coachID) > 1	professional_basketball
SELECT COUNT(DISTINCT playerID) FROM awards_players WHERE year BETWEEN 1969 AND 1975 AND award = 'Most Valuable Player'	professional_basketball
SELECT DISTINCT name FROM teams WHERE tmID IN ( SELECT tmID FROM players_teams AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID WHERE T2.birthState IS NOT NULL GROUP BY T1.tmID, T2.birthState HAVING COUNT(*) > 5 )	professional_basketball
SELECT COUNT(*) FROM ( SELECT tmID FROM players_teams AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.lgID = 'NBA' GROUP BY T1.tmID HAVING COUNT(DISTINCT T1.playerID) > 3 ) AS T3	professional_basketball
SELECT T1.birthState FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID GROUP BY T1.birthState ORDER BY COUNT(DISTINCT T1.playerID) DESC LIMIT 1	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID INNER JOIN teams AS T3 ON T3.tmID = T2.tmID WHERE T3.year = 1937 AND T3.rank = 6	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID INNER JOIN teams AS T3 ON T3.tmID = T2.tmID WHERE CAST(T3.lost AS REAL) * 100 / (T3.lost + T3.won) < 20	professional_basketball
SELECT firstName, middleName, lastName FROM players WHERE birthCountry != 'USA'	professional_basketball
SELECT coachID FROM coaches GROUP BY coachID HAVING COUNT(DISTINCT tmID) > 2	professional_basketball
SELECT coachID FROM coaches WHERE year = 1988 ORDER BY won - lost DESC LIMIT 1	professional_basketball
SELECT DISTINCT T1.tmID FROM coaches AS T1 INNER JOIN awards_coaches AS T2 ON T1.coachID = T2.coachID WHERE T2.year = 2010 AND T2.award = 'NBA Coach of the Year'	professional_basketball
SELECT DISTINCT T1.firstName, T1.lastName, T1.height, T1.weight FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.ft_attempted > 0 AND ft_attempted = ft_made	professional_basketball
SELECT DISTINCT T1.firstName, T1.lastName, T3.name FROM players AS T1 INNER JOIN draft AS T2 ON T1.playerID = T2.playerID INNER JOIN teams AS T3 ON T2.tmID = T3.tmID WHERE T2.draftFrom = 'Seattle' AND T2.draftYear BETWEEN 1965 AND 1970	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName , 2003 - strftime('%Y', T1.birthDate) FROM awards_players AS T2 JOIN players AS T1 ON T2.playerID = T1.playerID WHERE T2.award = 'Finals MVP' AND T2.year = 2003	professional_basketball
SELECT DISTINCT T1.name, T2.year FROM teams AS T1 JOIN series_post AS T2 ON T1.tmID = T2.tmIDWinner WHERE T2.round = 'F' AND T2.year BETWEEN 1950 AND 1960	professional_basketball
SELECT DISTINCT T1.coachID, T3.name FROM coaches AS T1 JOIN series_post AS T2 ON T1.tmID = T2.tmIDWinner JOIN teams AS T3 ON T3.tmID = T1.tmID WHERE T2.round = 'QF' AND T2.year = 1946	professional_basketball
SELECT DISTINCT T3.firstName, T3.middleName, T3.lastName FROM series_post AS T1 INNER JOIN players_teams AS T2 ON T1.tmIDWinner = T2.tmID INNER JOIN players AS T3 ON T3.playerID = T2.playerID WHERE T1.year = 1970 AND T1.round = 'F'	professional_basketball
SELECT college FROM players WHERE playerID = ( SELECT playerID FROM awards_players WHERE year = 1970 GROUP BY playerID ORDER BY COUNT(award) DESC LIMIT 1 )	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Rookie of the Year' ORDER BY T1.birthDate DESC LIMIT 1	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN draft AS T2 ON T1.playerID = T2.playerID WHERE T2.draftRound = 1 AND T1.birthCountry != 'USA' AND T2.draftYear = 1973	professional_basketball
SELECT CAST(SUM(T2.o_rebounds) AS REAL) * 100 / SUM(T2.rebounds) FROM players_teams AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.year = 2000	professional_basketball
SELECT DISTINCT T1.year, T2.name, T1.coachID FROM coaches AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID WHERE CAST(T1.won AS REAL) / CAST((T1.won + T1.lost) AS REAL) > 0.75	professional_basketball
SELECT DISTINCT coachID FROM coaches AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID WHERE name = 'Oklahoma City Thunder'	professional_basketball
SELECT COUNT(playerID) FROM players_teams WHERE CAST(oRebounds AS REAL) * 100 / dRebounds <= 50 AND year = 1990	professional_basketball
SELECT COUNT(DISTINCT playerID) FROM player_allstar WHERE season_id BETWEEN 2000 AND 2005 AND steals <= 10	professional_basketball
SELECT T1.playerID FROM draft AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.award = 'Rookie of the Year' AND T1.draftYear = 1971 AND T1.draftRound = 2	professional_basketball
SELECT COUNT(DISTINCT T1.playerID) FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.season_id = 1973 AND T1.race = 'B'	professional_basketball
SELECT T2.tmID FROM series_post AS T1 INNER JOIN teams AS T2 ON T1.tmIDWinner = T2.tmID WHERE T1.year = 1947 AND T1.round = 'QF' AND T2.d_pts = 3513	professional_basketball
SELECT CAST(SUM(lost) AS REAL) * 100 / SUM(games) FROM teams WHERE name = 'Houston Mavericks'	professional_basketball
SELECT playerID FROM awards_players WHERE year > 1990 AND award = 'Most Valuable Player' AND lgID = 'NBA'	professional_basketball
SELECT COUNT(DISTINCT T2.year) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.tmID = 'LAL' AND T2.year BETWEEN 1975 AND 1980 AND T1.playerID = 'abdulka01'	professional_basketball
SELECT CAST(SUM(CASE WHEN award = 'NBA Coach of the Year' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM awards_coaches WHERE year = 1969	professional_basketball
SELECT CAST(SUM(CASE WHEN year = 1947 AND tmIDWinner = 'CHS' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN year = 1947 THEN 1 ELSE 0 END) - CAST(SUM(CASE WHEN year = 1946 AND tmIDWinner = 'CHS' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(CASE WHEN year = 1946 THEN 1 ELSE 0 END) FROM series_post	professional_basketball
SELECT COUNT(T1.award) FROM awards_players AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID WHERE T1.year = 2010 AND T2.hsCity = 'Chicago'	professional_basketball
SELECT CAST(SUM(CASE WHEN T2.award = 'All-Defensive Second Team' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T1.college = 'Auburn'	professional_basketball
SELECT DISTINCT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T2.season_id = 1997 ORDER BY T2.steals DESC LIMIT 5	professional_basketball
SELECT T1.college FROM players AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE T2.year = 1990 AND T2.award = 'Finals MVP'	professional_basketball
SELECT playerID FROM player_allstar WHERE season_id = 1996 AND CAST(ft_made AS REAL) * 100 / ft_attempted > 70	professional_basketball
SELECT DISTINCT T2.playerID FROM player_allstar AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.year BETWEEN 1980 AND 1983 AND T1.three_made / T1.three_attempted > 0.6	professional_basketball
SELECT DISTINCT T2.coachID FROM coaches AS T1 INNER JOIN awards_coaches AS T2 ON T1.coachID = T2.coachID WHERE T1.tmID = 'STL' AND T1.lgID = 'NBA'	professional_basketball
SELECT COUNT(DISTINCT T2.coachID) FROM coaches AS T1 INNER JOIN awards_coaches AS T2 ON T1.coachID = T2.coachID WHERE T1.tmID = 'CHI' AND T2.award = 'NBA Coach of the Year'	professional_basketball
SELECT T3.firstname, T3.lastname FROM player_allstar AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID INNER JOIN draft AS T3 ON T1.playerID = T3.playerID WHERE T2.year BETWEEN 1990 AND 2000 ORDER BY T1.points DESC LIMIT 1	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.college = 'Wake Forest' AND T2.o_rebounds > T2.d_rebounds	professional_basketball
SELECT T1.firstName, T1.lastName, T2.tmID FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T1.birthCity = 'Atlanta' ORDER BY T2.blocks DESC LIMIT 1	professional_basketball
SELECT T1.name FROM teams AS T1 INNER JOIN series_post AS T2 ON T1.tmID = T2.tmIDLoser AND T1.year = T2.year WHERE T1.rank < 5 AND T2.lgIDLoser > 2 AND T2.year BETWEEN 1980 AND 2000	professional_basketball
SELECT tmID FROM players_teams WHERE year BETWEEN 1991 AND 2000 ORDER BY CAST(points AS REAL) / minutes DESC LIMIT 1	professional_basketball
SELECT CAST(SUM(IIF(T2.lgID = 'ABA', 1970 - strftime('%Y', T3.birthDate), 0)) AS REAL) / COUNT(IIF(T2.lgID = 'ABA', 1, 0)) - CAST(SUM(IIF(T2.lgID = 'NBA', 1970 - strftime('%Y', T3.birthDate), 0)) AS REAL) / COUNT(IIF(T2.lgID = 'NBA', 1, 0)) FROM draft AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID INNER JOIN players AS T3 ON T2.playerID = T3.playerID WHERE T1.draftYear BETWEEN 1970 AND 1970	professional_basketball
SELECT playerID FROM players_teams WHERE year = 2011 ORDER BY GP DESC LIMIT 1	professional_basketball
SELECT COUNT(T2.playerID) FROM draft AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID WHERE T1.draftYear = 1996 AND T1.draftRound = 1	professional_basketball
SELECT DISTINCT T3.tmID FROM players_teams AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID INNER JOIN teams AS T3 ON T1.tmID = T3.tmID AND T1.year = T3.year WHERE T2.year = 1997 AND T2.award = 'Finals MVP' LIMIT 1	professional_basketball
SELECT T2.W FROM teams AS T1 INNER JOIN series_post AS T2 ON T1.tmID = T2.tmIDLoser AND T1.year = T2.year WHERE T2.year = 2001 ORDER BY T1.o_fgm DESC LIMIT 1	professional_basketball
SELECT AVG(T2.turnovers) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.year = 2003 GROUP BY T1.playerID, T2.assists ORDER BY T2.assists DESC LIMIT 1	professional_basketball
SELECT COUNT(T1.playerID) FROM player_allstar AS T1 INNER JOIN awards_players AS T2 ON T1.playerID = T2.playerID WHERE first_name = 'Ray' AND last_name = 'Allen'	professional_basketball
SELECT (CAST(SUM(CASE WHEN T1.year = 2004 THEN T1.won ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.year = 2004 THEN T1.won + T1.lost ELSE 0 END)) - (CAST(SUM(CASE WHEN T1.year = 2003 THEN T1.won ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.year = 2003 THEN T1.won + T1.lost ELSE 0 END)) FROM teams AS T1 INNER JOIN draft AS T2 ON T1.tmID = T2.tmID WHERE T2.draftRound = 1 AND T2.draftYear = 2003	professional_basketball
SELECT COUNT(T1.id) FROM awards_coaches AS T1 INNER JOIN teams AS T2 ON T1.year = T2.year WHERE T1.year BETWEEN 1971 AND 1975 AND T1.award = 'NBA Coach of the Year' AND T2.tmID = 'POR'	professional_basketball
SELECT CAST(SUM(IIF(T2.steals IS NOT NULL AND T1.tmID = 'LAL', 1, 0)) AS REAL) * 100 / COUNT(T1.tmID) FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year	professional_basketball
SELECT T1.playerID FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.year = 1996 AND T2.PostGP = 0 ORDER BY T2.steals DESC LIMIT 1	professional_basketball
SELECT T2.playerID FROM players_teams AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID WHERE T1.PostGP = 0 AND T1.year = 1988 ORDER BY T1.turnovers DESC LIMIT 1	professional_basketball
SELECT T2.tmID FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.PostGP = 0 AND T1.year = 2000 ORDER BY CAST(T2.won AS REAL) / (T2.won + T2.lost) DESC LIMIT 1	professional_basketball
SELECT T2.tmID FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year = 1998 AND T1.PostGP = 0 ORDER BY T1.points DESC LIMIT 1	professional_basketball
SELECT T2.tmID FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.PostGP = 0 ORDER BY T2.won DESC LIMIT 1	professional_basketball
SELECT T2.tmID FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.PostGP = 0 AND T1.year = 1997 ORDER BY T1.rebounds DESC LIMIT 1	professional_basketball
SELECT T2.tmID FROM draft AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.draftYear = T2.year WHERE T1.draftRound = 1 AND T1.draftSelection = 6 AND T1.draftYear = 1976	professional_basketball
SELECT T2.homeWon FROM draft AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.draftYear = T2.year WHERE T1.draftRound = 1 AND T1.draftSelection = 12 AND T1.draftYear = 1998	professional_basketball
SELECT T1.weight, T1.height FROM players AS T1 INNER JOIN player_allstar AS T2 ON T1.playerID = T2.playerID ORDER BY T2.rebounds DESC LIMIT 1	professional_basketball
SELECT T2.highSchool FROM player_allstar AS T1 INNER JOIN players AS T2 ON T1.playerID = T2.playerID ORDER BY T1.rebounds DESC LIMIT 1	professional_basketball
SELECT T2.tmID FROM players_teams AS T1 INNER JOIN teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year INNER JOIN player_allstar AS T3 ON T3.playerID = T1.playerID WHERE T3.season_id = 1997 ORDER BY T1.rebounds DESC LIMIT 1	professional_basketball
SELECT SUM(T2.points) FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T1.pos = 'C-F-G' GROUP BY T2.playerID, T2.year ORDER BY T2.year DESC LIMIT 1	professional_basketball
SELECT T1.tmID FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year INNER JOIN players AS T3 ON T2.playerID = T3.playerID WHERE T3.pos = 'F-G' AND T2.lgID = 'NBA' ORDER BY T3.birthDate DESC LIMIT 1	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.lgID = 'PBLA' AND T2.GP = 10 AND T1.college = 'Central Missouri State' GROUP BY T1.firstName, T1.middleName, T1.lastName ORDER BY COUNT(T2.id) DESC LIMIT 1	professional_basketball
SELECT T1.tmID FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T2.GP = 82 AND T2.year = 2000 GROUP BY T1.tmID ORDER BY SUM(T2.PostMinutes) ASC LIMIT 1	professional_basketball
SELECT T1.firstName, T1.middleName, T1.lastName FROM players AS T1 INNER JOIN players_teams AS T2 ON T1.playerID = T2.playerID WHERE T2.GP = 82 AND T2.year = 1995 ORDER BY T2.turnovers DESC LIMIT 1	professional_basketball
SELECT T1.tmID FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year = 2011 AND T2.GP = T2.GS GROUP BY T1.tmID, T2.steals ORDER BY T2.steals DESC LIMIT 1	professional_basketball
SELECT DISTINCT T1.tmID FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T2.GP = T2.GS	professional_basketball
SELECT birthDate FROM players WHERE playerID = ( SELECT playerID FROM players_teams WHERE year = 2001 GROUP BY playerID ORDER BY SUM(rebounds + dRebounds) DESC LIMIT 1 )	professional_basketball
SELECT T1.name FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T2.year = 1997 GROUP BY T1.name ORDER BY SUM(rebounds + dRebounds) DESC LIMIT 1	professional_basketball
SELECT T1.tmID FROM teams AS T1 INNER JOIN players_teams AS T2 ON T1.tmID = T2.tmID AND T1.year = T2.year WHERE T1.year = 2011 AND T2.rebounds > 600	professional_basketball
SELECT COUNT(id) FROM works WHERE Date < 1602	shakespeare
SELECT COUNT(T1.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Act = 1 AND T1.Title = 'Twelfth Night'	shakespeare
SELECT T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Twelfth Night' AND T2.Act = 1 AND T2.Scene = 2	shakespeare
SELECT SUM(IIF(T2.Act = 1, 1, 0)) - SUM(IIF(T2.Act = 5, 1, 0)) AS more FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Twelfth Night'	shakespeare
SELECT DISTINCT T1.Title FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T4.CharName = 'Lord Abergavenny'	shakespeare
SELECT DISTINCT T4.CharName FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.Title = 'Twelfth Night'	shakespeare
SELECT SUM(T3.ParagraphNum) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id WHERE T2.Act = 1 AND T2.Scene = 1 AND T1.Title = 'Twelfth Night'	shakespeare
SELECT T3.PlainText FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id WHERE T2.Act = 1 AND T2.Scene = 1 AND T1.Title = 'Twelfth Night'	shakespeare
SELECT SUM(T1.ParagraphNum) FROM paragraphs AS T1 INNER JOIN characters AS T2 ON T1.character_id = T2.id WHERE T2.CharName = 'Lord Abergavenny'	shakespeare
SELECT T1.id FROM paragraphs AS T1 INNER JOIN characters AS T2 ON T1.character_id = T2.id WHERE T2.Description = 'son to Tamora'	shakespeare
SELECT COUNT(T2.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Description = 'OLIVIA’S house.' AND T1.Title = 'Twelfth Night'	shakespeare
SELECT COUNT(DISTINCT T4.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.Title = 'Twelfth Night'	shakespeare
SELECT T.Title FROM ( SELECT T1.Title, COUNT(T3.character_id) AS num FROM works T1 INNER JOIN chapters T2 ON T1.id = T2.work_id INNER JOIN paragraphs T3 ON T2.id = T3.chapter_id INNER JOIN characters T4 ON T3.character_id = T4.id GROUP BY T3.character_id, T1.Title ) T ORDER BY T.num DESC LIMIT 1	shakespeare
SELECT SUM(DISTINCT T4.id) / COUNT(T1.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id	shakespeare
SELECT SUM(T2.Scene) / COUNT(T2.Act) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Twelfth Night'	shakespeare
SELECT COUNT(id) FROM works WHERE GenreType = 'Comedy'	shakespeare
SELECT MIN(Date) FROM works WHERE GenreType = 'Poem'	shakespeare
SELECT DISTINCT Abbrev FROM characters WHERE CharName = 'Earl of Westmoreland'	shakespeare
SELECT T1.Description FROM chapters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.chapter_id ORDER BY T2.ParagraphNum DESC LIMIT 1	shakespeare
SELECT T1.CharName FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.PlainText = 'Would he do so, I''ld beg your precious mistress,Which he counts but a trifle.'	shakespeare
SELECT COUNT(DISTINCT T3.character_id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id WHERE T1.Title = 'Titus Andronicus'	shakespeare
SELECT DISTINCT T1.Act FROM chapters AS T1 INNER JOIN works AS T2 ON T1.id = T1.work_id WHERE T2.LongTitle = 'Two Gentlemen of Verona'	shakespeare
SELECT T1.Description FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.id = '640171'	shakespeare
SELECT DISTINCT T1.Title FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T4.CharName = 'Shylock'	shakespeare
SELECT COUNT(T2.Scene) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'King John'	shakespeare
SELECT COUNT(DISTINCT T2.chapter_id) FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.CharName = 'Demetrius'	shakespeare
SELECT T1.Title FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T2.id = '324' AND T2.Description = 'friend to Caesar'	shakespeare
SELECT T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Act = '2' AND T2.Scene = '2' AND T1.Title = 'Midsummer Night''s Dream'	shakespeare
SELECT T.LongTitle FROM ( SELECT T1.LongTitle, COUNT(T2.Scene) AS num FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.GenreType = 'Tragedy' GROUP BY T1.LongTitle, T2.Scene ) AS T ORDER BY T.num DESC LIMIT 1	shakespeare
SELECT SUM(T2.ParagraphNum) FROM chapters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.chapter_id WHERE T1.Description = 'A Sea-port in Cyprus. An open place near the quay.'	shakespeare
SELECT CAST(SUM(IIF(T2.GenreType = 'Tragedy', 1, 0)) AS REAL) * 100 / COUNT(T1.Scene) FROM chapters AS T1 INNER JOIN works AS T2 ON T1.work_id = T2.id WHERE T2.Date = '1594'	shakespeare
SELECT CAST(COUNT(T1.id) AS REAL) / COUNT(DISTINCT T2.id) FROM chapters AS T1 INNER JOIN works AS T2 ON T1.work_id = T2.id WHERE T2.Date = '1599'	shakespeare
SELECT COUNT(id) FROM characters WHERE Description = 'servant to Timon'	shakespeare
SELECT Title FROM works WHERE Date = ( SELECT MIN(Date) FROM works )	shakespeare
SELECT COUNT(id) FROM works WHERE GenreType = 'Poem'	shakespeare
SELECT COUNT(id) FROM chapters WHERE work_id = 7 AND Act = 1	shakespeare
SELECT COUNT(id) FROM works WHERE GenreType = 'Tragedy' AND Date BETWEEN 1500 AND 1599	shakespeare
SELECT CharName FROM characters WHERE Description = 'Daughter to Capulet'	shakespeare
SELECT ParagraphNum FROM paragraphs WHERE PlainText = 'Ay, surely, mere the truth: I know his lady.'	shakespeare
SELECT T2.LongTitle FROM chapters AS T1 INNER JOIN works AS T2 ON T1.work_id = T2.id WHERE T1.Act = 1 ORDER BY T1.Scene DESC LIMIT 1	shakespeare
SELECT T2.Description FROM paragraphs AS T1 INNER JOIN chapters AS T2 ON T1.chapter_id = T2.id ORDER BY T1.ParagraphNum DESC LIMIT 1	shakespeare
SELECT T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.LongTitle = 'Twelfth Night, Or What You Will' AND T2.Scene = 2 AND T2.Act = 2	shakespeare
SELECT DISTINCT T2.Description FROM paragraphs AS T1 INNER JOIN chapters AS T2 ON T1.chapter_id = T2.id WHERE T1.ParagraphNum < 150	shakespeare
SELECT T2.Title FROM chapters AS T1 INNER JOIN works AS T2 ON T1.work_id = T2.id WHERE T1.Description = 'A field near Windsor.'	shakespeare
SELECT T1.ParagraphNum FROM paragraphs AS T1 INNER JOIN chapters AS T2 ON T1.chapter_id = T2.id WHERE T2.Act = 1 ORDER BY T2.Scene DESC LIMIT 1	shakespeare
SELECT T.CharName FROM ( SELECT T3.CharName, COUNT(T3.id) AS num FROM paragraphs AS T1 INNER JOIN chapters AS T2 ON T1.chapter_id = T2.id INNER JOIN characters AS T3 ON T1.character_id = T3.id WHERE T2.Description = 'The sea-coast.' AND T3.CharName != '(stage directions)' AND T1.chapter_id = 18709 GROUP BY T3.id, T3.CharName ) AS T WHERE T.num = 5	shakespeare
SELECT COUNT(T3.chapter_id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id WHERE T1.Title = 'As You Like It' AND T3.ParagraphNum < 50	shakespeare
SELECT T1.character_id FROM paragraphs AS T1 INNER JOIN chapters AS T2 ON T1.chapter_id = T2.id WHERE T1.PlainText = 'His name, I pray you.' AND T2.Description = 'Florence. Without the walls. A tucket afar off.'	shakespeare
SELECT COUNT(DISTINCT T3.character_id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id WHERE T1.Title = 'Hamlet'	shakespeare
SELECT SUM(T2.Scene) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Act = 5 AND T1.LongTitle = 'History of Henry VIII'	shakespeare
SELECT COUNT(DISTINCT T2.work_id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Act = 1 AND T2.Scene < 2 AND T1.GenreType = 'History'	shakespeare
SELECT SUM(DISTINCT T2.Act) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Sonnets'	shakespeare
SELECT T2.Description FROM paragraphs AS T1 INNER JOIN chapters AS T2 ON T1.chapter_id = T2.id INNER JOIN characters AS T3 ON T1.character_id = T3.id WHERE T3.Abbrev = '1Play' ORDER BY T1.chapter_id LIMIT 1	shakespeare
SELECT DISTINCT T1.Title, T1.GenreType FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Act = 1	shakespeare
SELECT MAX(T2.ParagraphNum) FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.CharName = 'Sir Richard Ratcliff'	shakespeare
SELECT T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Act = 1 AND T2.Scene = 1 AND T1.Title = 'A Lover''s Complaint'	shakespeare
SELECT T1.Date, T1.id FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Scene = 154	shakespeare
SELECT CAST(SUM(T2.Scene) AS REAL) / COUNT(T1.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.GenreType = 'Comedy'	shakespeare
SELECT SUM(IIF(T4.CharName = 'Romeo', 1, 0)), SUM(IIF(T4.CharName = 'Juliet', 1, 0)), CAST(SUM(IIF(T4.CharName = 'Romeo', 1, 0)) + SUM(IIF(T4.CharName = 'Juliet', 1, 0)) AS REAL) * 100 / COUNT(T1.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id	shakespeare
SELECT ParagraphNum FROM paragraphs WHERE PlainText = 'This is Illyria, lady.'	shakespeare
SELECT COUNT(ParagraphNum) FROM paragraphs WHERE chapter_id = 18881	shakespeare
SELECT Title FROM works WHERE GenreType = 'History' LIMIT 5	shakespeare
SELECT COUNT(Scene) FROM chapters WHERE work_id = 9 AND Act = 5	shakespeare
SELECT DISTINCT T1.CharName, T1.Description FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.Chapter_id = 18710	shakespeare
SELECT COUNT(T2.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Midsummer Night''s Dream'	shakespeare
SELECT COUNT(T3.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id WHERE T2.Act = 5 AND T2.Scene = 1 AND T1.Title = 'Comedy of Errors'	shakespeare
SELECT DISTINCT T4.CharName, T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.Title = 'Venus and Adonis'	shakespeare
SELECT DISTINCT T1.title FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T4.CharName = 'Froth'	shakespeare
SELECT COUNT(T2.chapter_id) FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.CharName = 'First Witch'	shakespeare
SELECT T2.Scene, T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.LongTitle = 'Pericles, Prince of Tyre' AND T2.Act = 1	shakespeare
SELECT DISTINCT T1.LongTitle FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T4.Description = 'Servant to Montague'	shakespeare
SELECT T2.Act, T2.Scene, T1.Title FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Description = 'The house of ANTIPHOLUS of Ephesus.'	shakespeare
SELECT T1.CharName, T2.ParagraphNum, T2.PlainText FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.Description = 'cousin to the king'	shakespeare
SELECT CAST(SUM(T2.Scene) AS REAL) / COUNT(T2.act) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Antony and Cleopatra'	shakespeare
SELECT CAST(SUM(IIF(T1.Title = 'All''s Well That Ends Well', 1, 0)) AS REAL) * 100 / COUNT(T3.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id	shakespeare
SELECT COUNT(id) FROM characters WHERE Abbrev = 'All'	shakespeare
SELECT Title FROM works WHERE GenreType = 'comedy' LIMIT 3	shakespeare
SELECT SUM(IIF(GenreType = 'Comedy', 1, 0)) - SUM(IIF(GenreType = 'History', 1, 0)) FROM works WHERE Date > 1593	shakespeare
SELECT LongTitle FROM works WHERE GenreType = 'History' ORDER BY Date DESC LIMIT 1	shakespeare
SELECT id FROM works WHERE Title LIKE '%Henry%'	shakespeare
SELECT CharName FROM characters WHERE Description = 'a senator of Venice'	shakespeare
SELECT T1.CharName FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.ParagraphNum = 8 AND T2.chapter_id = 18820	shakespeare
SELECT DISTINCT T3.Description FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id INNER JOIN chapters AS T3 ON T2.chapter_id = T3.id WHERE T1.CharName = 'Orsino' AND T3.ID = 18704	shakespeare
SELECT COUNT(T2.Scene) AS cnt FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.LongTitle = 'Cymbeline, King of Britain'	shakespeare
SELECT T1.Description FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.ParagraphNum = 20	shakespeare
SELECT COUNT(DISTINCT T2.chapter_id) FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.CharName = 'Gratiano' AND T1.Description = 'friend to Antonio and Bassiano'	shakespeare
SELECT T2.Description FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.id = 18706 AND T1.Title = 'All''s Well That Ends Well'	shakespeare
SELECT DISTINCT T1.CharName FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.ParagraphNum = 3	shakespeare
SELECT T2.ParagraphNum FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.CharName = 'Aedile'	shakespeare
SELECT T1.CharName FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.chapter_id = 18708 LIMIT 2	shakespeare
SELECT COUNT(T1.ACT) FROM chapters AS T1 LEFT JOIN works AS T2 ON T1.work_id = T2.id WHERE T2.GenreType = 'Comedy' AND T2.Title = 'Two Gentlemen of Verona'	shakespeare
SELECT CAST(( SELECT COUNT(T1.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.GenreType = 'History' AND T1.DATE BETWEEN 1500 AND 1599 GROUP BY T1.id HAVING COUNT(T2.Scene) >= 5 ) AS REAL) * 100 / COUNT(id) FROM works WHERE GenreType = 'History' AND DATE BETWEEN 1500 AND 1599	shakespeare
SELECT CAST(SUM(IIF(T2.act = 5, 1, 0)) AS REAL) * 100 / COUNT(T2.act) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Titus Andronicus'	shakespeare
SELECT COUNT(id) FROM works WHERE GenreType = 'Tragedy'	shakespeare
SELECT COUNT(id) FROM works WHERE Title LIKE '%Henry%'	shakespeare
SELECT character_id FROM paragraphs WHERE PlainText = 'O my poor brother! and so perchance may he be.'	shakespeare
SELECT T2.ParagraphNum, T2.id FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T1.CharName = 'Sir Andrew Aguecheek'	shakespeare
SELECT T1.Title, T4.CharName FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id ORDER BY T1.Date DESC LIMIT 1	shakespeare
SELECT T1.description FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.PlainText = 'a sea captain, friend to Sebastian' AND T2.ParagraphNum BETWEEN 1500 AND 1950	shakespeare
SELECT T1.LongTitle FROM works AS T1 RIGHT JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T2.Description = 'Mytilene. A street before the brothel.'	shakespeare
SELECT T1.CharName FROM characters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.character_id WHERE T2.PlainText = 'This is Illyria, lady.'	shakespeare
SELECT COUNT(DISTINCT T2.work_id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.DATE BETWEEN 1600 AND 1610 AND T4.CharName = 'Third Servingman'	shakespeare
SELECT T2.Description FROM works AS T1 RIGHT JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.Title = 'Venus and Adonis' ORDER BY T2.Scene DESC LIMIT 1	shakespeare
SELECT COUNT(T4.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T2.Act = 1 AND T2.Scene = 2 AND T4.id = 1238 AND T4.CharName = 'Viola' AND T1.Title = 'Twelfth Night'	shakespeare
SELECT T2.character_id, T1.work_id FROM chapters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.chapter_id WHERE T2.PlainText = 'Fear not thou, man, thou shalt lose nothing here.'	shakespeare
SELECT T1.id, T1.Description FROM chapters AS T1 INNER JOIN paragraphs AS T2 ON T1.id = T2.chapter_id WHERE T2.PlainText = 'What, wilt thou hear some music, my sweet love?'	shakespeare
SELECT DISTINCT T2.Scene FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.Title = 'Twelfth Night' AND T4.CharName = 'Sir Toby Belch'	shakespeare
SELECT DISTINCT T1.title FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.DATE < 1600 AND T1.GenreType = 'Tragedy' AND T4.CharName = 'Tybalt'	shakespeare
SELECT T2.id FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id WHERE T1.DATE > ( SELECT AVG(DATE) FROM works ) * 0.89	shakespeare
SELECT CAST(SUM(IIF(T4.CharName = 'antonio', 1, 0)) AS REAL) * 100 / COUNT(T1.id) FROM works AS T1 INNER JOIN chapters AS T2 ON T1.id = T2.work_id INNER JOIN paragraphs AS T3 ON T2.id = T3.chapter_id INNER JOIN characters AS T4 ON T3.character_id = T4.id WHERE T1.GenreType = 'Comedy'	shakespeare
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.cylinders = 8 ORDER BY T2.price DESC LIMIT 1	cars
SELECT COUNT(T1.car_name) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.weight > 3000 AND T2.price < 30000	cars
SELECT T1.acceleration FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T2.price DESC LIMIT 1	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'ford torino'	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T1.car_name = 'ford torino' AND T2.model_year = 1970	cars
SELECT COUNT(*) FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin WHERE T1.model_year = 1970 AND T2.country = 'USA'	cars
SELECT DISTINCT T1.car_name FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T2.country = T3.origin WHERE T3.country = 'USA'	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T2.price DESC LIMIT 3	cars
SELECT DISTINCT T1.model_year FROM production AS T1 INNER JOIN data AS T2 ON T1.ID = T2.ID WHERE T2.car_name = 'chevrolet impala'	cars
SELECT COUNT(*) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.acceleration > 10 AND T2.price BETWEEN 20000 AND 30000	cars
SELECT T1.weight FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price > 40000	cars
SELECT MAX(T1.acceleration) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price > 40000	cars
SELECT AVG(T2.price) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.cylinders = 8	cars
SELECT MAX(T1.displacement / T1.cylinders) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price < 30000	cars
SELECT COUNT(*) FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin WHERE T2.country = 'Europe'	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T1.car_name = 'chevrolet malibu'	cars
SELECT T1.mpg FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T2.price DESC LIMIT 1	cars
SELECT DISTINCT T2.country FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin WHERE T1.ID = 382	cars
SELECT T3.country FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T1.price = 44274.40748	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'volkswagen dasher' AND T1.acceleration = '14.1'	cars
SELECT T1.displacement FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price = '37443.85589'	cars
SELECT T1.model FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price = '32650.65157'	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'toyota corona hardtop'	cars
SELECT T1.cylinders FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY price ASC LIMIT 1	cars
SELECT T1.ID, T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T1.weight DESC LIMIT 1	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country ORDER BY T1.horsepower DESC LIMIT 1	cars
SELECT CAST(SUM(CASE WHEN T2.country = 'Japan' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin	cars
SELECT T1.displacement / T1.cylinders FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price = 34538.97449	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T2.price DESC LIMIT 1	cars
SELECT COUNT(*) FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin WHERE T2.country = 'USA' AND T1.model_year = 1981	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T1.displacement / T1.cylinders DESC LIMIT 1	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T3.country = 'Japan' ORDER BY T1.horsepower DESC LIMIT 1	cars
SELECT COUNT(T2.model_year) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'ford maverick'	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country ORDER BY T1.mpg DESC LIMIT 1	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name LIKE 'dodge%' ORDER BY T2.price ASC LIMIT 1	cars
SELECT T4.car_name FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN data AS T4 ON T4.ID = T1.ID WHERE T3.country = 'USA' ORDER BY T1.price DESC LIMIT 1	cars
SELECT COUNT(*) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.displacement > 400 AND T2.price > 30000	cars
SELECT T1.model_year FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin WHERE T2.country = 'Europe' GROUP BY T1.model_year ORDER BY COUNT(T1.model_year) DESC LIMIT 1	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'peugeot 505s turbo diesel'	cars
SELECT T4.acceleration FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN data AS T4 ON T4.ID = T1.ID WHERE T3.country = 'USA' ORDER BY T1.price ASC LIMIT 1	cars
SELECT T2.country, CAST(COUNT(T1.ID) AS REAL) / COUNT(DISTINCT T1.model_year) FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin GROUP BY T2.country ORDER BY COUNT(T2.country) DESC LIMIT 1	cars
SELECT CAST(SUM(CASE WHEN T3.country = 'Japan' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T1.displacement / T1.cylinders > 30	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T2.model_year = 1975	cars
SELECT AVG(T1.price) FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T3.country = 'Europe'	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.ID = 15	cars
SELECT COUNT(*) FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN data AS T4 ON T4.ID = T1.ID WHERE T3.country = 'Japan' AND T4.weight < 3000	cars
SELECT COUNT(*) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T2.model_year = 1973 AND T1.horsepower < 100	cars
SELECT T4.ID FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN data AS T4 ON T4.ID = T1.ID WHERE T3.country = 'Japan' AND T1.price > 3500 AND T4.acceleration = 14	cars
SELECT T2.model_year FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID ORDER BY T1.weight DESC LIMIT 1	cars
SELECT T1.horsepower, T2.model_year FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'subaru dl'	cars
SELECT T4.car_name FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN data AS T4 ON T4.ID = T1.ID WHERE T3.country = 'Japan' ORDER BY T1.price DESC LIMIT 1	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price = 20000	cars
SELECT COUNT(*) FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T3.country = 'USA' AND T1.price > 40000	cars
SELECT DISTINCT T1.price, T3.country FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN data AS T4 ON T4.ID = T1.ID WHERE T4.car_name = 'ford maverick'	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T2.price * 100 > ( SELECT AVG(price) * 85 FROM price )	cars
SELECT SUM(CASE WHEN T2.model_year = 1970 THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.model_year = 1976 THEN 1 ELSE 0 END) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T1.horsepower = 130	cars
SELECT T1.ID FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin WHERE T2.country = 'Japan' AND T1.model_year = 1979	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country ORDER BY T1.mpg ASC LIMIT 1	cars
SELECT T1.car_name, T1.model, T1.displacement / T1.cylinders, T2.model_year FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID ORDER BY T1.weight DESC LIMIT 1	cars
SELECT T1.car_name, T1.horsepower FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T2.model_year = 1977 AND T3.country = 'Europe'	cars
SELECT T1.car_name, T1.model FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T2.price DESC LIMIT 1	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'chevrolet bel air'	cars
SELECT AVG(T1.price) FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T3.country = 'Japan'	cars
SELECT T3.country FROM price AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country ORDER BY T1.price ASC LIMIT 1	cars
SELECT T1.ID, T1.car_name, T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T2.model_year = 1975 ORDER BY T1.cylinders DESC LIMIT 1	cars
SELECT T1.acceleration, T1.cylinders, T2.model_year FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN price AS T3 ON T3.ID = T2.ID ORDER BY T3.price ASC LIMIT 1	cars
SELECT T2.car_name, T1.price FROM price AS T1 INNER JOIN data AS T2 ON T1.ID = T2.ID WHERE T2.model = 82 AND T2.mpg > 30	cars
SELECT COUNT(DISTINCT T2.model_year) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'ford maverick'	cars
SELECT CAST(SUM(CASE WHEN T2.country = 'USA' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM production AS T1 INNER JOIN country AS T2 ON T1.country = T2.origin	cars
SELECT CAST(COUNT(T1.ID) AS REAL) / 9 FROM production AS T1 INNER JOIN data AS T2 ON T2.ID = T1.ID WHERE T1.model_year BETWEEN 1971 AND 1980 UNION ALL SELECT DISTINCT T2.car_name FROM production AS T1 INNER JOIN data AS T2 ON T2.ID = T1.ID WHERE T1.model_year BETWEEN 1971 AND 1980 AND T2.weight < 1800	cars
SELECT AVG(T2.price) FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.model = 70	cars
SELECT T2.price FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'chevrolet vega 2300'	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T1.car_name = 'chevy c20'	cars
SELECT DISTINCT T3.price FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN price AS T3 ON T3.ID = T2.ID WHERE T1.car_name LIKE 'ford%' AND T2.model_year BETWEEN 1970 AND 1980	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T2.model_year = '1975' ORDER BY T1.mpg DESC LIMIT 1	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T1.mpg DESC, T2.price DESC LIMIT 1	cars
SELECT COUNT(*) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T3.country = 'USA' AND T1.acceleration < 12	cars
SELECT COUNT(*) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T3.country = 'Japan' AND T1.weight > 2000	cars
SELECT T1.car_name FROM data AS T1 INNER JOIN price AS T2 ON T1.ID = T2.ID ORDER BY T2.price DESC LIMIT 1	cars
SELECT T2.model_year FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T1.car_name = 'buick skylark 320'	cars
SELECT T3.country FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country INNER JOIN price AS T4 ON T4.ID = T1.ID WHERE T2.model_year = 1970 ORDER BY T4.price DESC LIMIT 1	cars
SELECT COUNT(T2.model_year) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID WHERE T1.horsepower > 200 AND T2.model_year = 1975	cars
SELECT CAST(SUM(CASE WHEN T3.country = 'USA' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country	cars
SELECT AVG(T1.weight) FROM data AS T1 INNER JOIN production AS T2 ON T1.ID = T2.ID INNER JOIN country AS T3 ON T3.origin = T2.country WHERE T2.model_year BETWEEN 1975 AND 1980 AND T1.cylinders = 4 AND T3.country = 'Japan'	cars
SELECT SUM(donation_total) FROM donations WHERE donation_timestamp LIKE '2012%'	donor
SELECT donation_timestamp, donation_total FROM donations WHERE donation_total = ( SELECT donation_total FROM donations ORDER BY donation_total DESC LIMIT 1 )	donor
SELECT SUM(donation_total) FROM donations WHERE donation_timestamp LIKE '2011%' AND via_giving_page = 't' AND for_honoree = 't'	donor
SELECT donor_acctid, donation_optional_support / donation_total FROM donations WHERE is_teacher_acct = 'f'	donor
SELECT T1.title FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.primary_focus_subject = 'Literacy'	donor
SELECT T1.title FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.poverty_level LIKE 'highest%'	donor
SELECT T2.primary_focus_subject FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title = 'Toot Your Flute!'	donor
SELECT T1.title FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donation_message LIKE 'Donation on behalf of Matt Carpenter because I''m a strong believer in education.'	donor
SELECT T1.title, T2.total_price_excluding_optional_support FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.students_reached = 320	donor
SELECT T2.donation_message, T1.title FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donor_city = 'Texas City'	donor
SELECT T1.vendor_name, T1.item_name, T1.item_unit_price FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN essays AS T3 ON T2.projectid = T3.projectid WHERE T3.title = 'Lights, Camera, Action!'	donor
SELECT SUM(T2.donation_to_project) FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title = 'Whistle While We Work!'	donor
SELECT T1.title, T1.short_description FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.teacher_ny_teaching_fellow = 't'	donor
SELECT DISTINCT T2.title, T1.total_price_excluding_optional_support FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T1.students_reached >= 600 AND T1.poverty_level LIKE 'moderate poverty'	donor
SELECT CAST(SUM(CASE WHEN T2.school_metro = 'rural' THEN T1.donation_to_project ELSE 0 END) AS REAL) * 100 / SUM(donation_to_project) FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid	donor
SELECT T1.title, SUM(T3.donation_to_project), CAST((T2.total_price_excluding_optional_support - SUM(T3.donation_to_project)) AS REAL) * 100 / SUM(T3.donation_to_project) FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid ORDER BY T2.total_price_excluding_optional_support DESC LIMIT 1	donor
SELECT COUNT(poverty_level) FROM projects WHERE school_district = 'West New York School District' AND poverty_level = 'highest poverty'	donor
SELECT COUNT(donationid) FROM donations WHERE is_teacher_acct = 't' AND donor_state = 'CO'	donor
SELECT projectid FROM projects ORDER BY total_price_including_optional_support DESC LIMIT 1	donor
SELECT DISTINCT donor_state FROM donations WHERE for_honoree = 't' AND payment_included_campaign_gift_card = 't' AND payment_method = 'paypal' AND donor_state = ( SELECT donor_state FROM donations GROUP BY donor_state ORDER BY SUM(donation_total) DESC LIMIT 1 )	donor
SELECT donationid, donation_total FROM donations ORDER BY donation_total DESC LIMIT 1	donor
SELECT T1.projectid, T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid ORDER BY T2.total_price_including_optional_support - T2.total_price_excluding_optional_support DESC LIMIT 1	donor
SELECT DISTINCT T1.item_name, T1.item_quantity, T2.teacher_prefix FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.projectid = 'd6ef27c07c30c81f0c16c32b6acfa2ff'	donor
SELECT SUM(T1.total_price_including_optional_support) FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title = 'Recording Rockin'' Readers'	donor
SELECT T1.school_latitude, T1.school_longitude FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title = 'Smile for the Camera!!!'	donor
SELECT T2.donation_total, T1.title FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donation_total = ( SELECT MAX(donation_total) FROM donations )	donor
SELECT project_resource_type FROM ( SELECT T1.donor_acctid, T3.project_resource_type FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN resources AS T3 ON T2.projectid = T3.projectid ORDER BY T1.donation_total DESC LIMIT 10 ) GROUP BY project_resource_type ORDER BY COUNT(project_resource_type) DESC LIMIT 1	donor
SELECT T2.date_posted, T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.date_posted = ( SELECT date_posted FROM projects ORDER BY date_posted ASC LIMIT 1 )	donor
SELECT DISTINCT T1.vendor_name FROM resources AS T1 INNER JOIN essays AS T3 ON T1.projectid = T3.projectid WHERE T3.title = 'iMath'	donor
SELECT T2.date_posted, T2.grade_level FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid ORDER BY T1.item_quantity DESC LIMIT 1	donor
SELECT AVG(T3.donation_to_project) FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T1.title = 'Recording Rockin'' Readers'	donor
SELECT T1.title, T3.donor_acctid, CAST(T3.donation_to_project AS REAL) / T2.total_price_excluding_optional_support FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid ORDER BY T3.donation_to_project DESC LIMIT 1	donor
SELECT T1.school_state, T2.donor_acctid, AVG(T2.donation_optional_support), T1.resource_type FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid ORDER BY T2.donation_optional_support DESC LIMIT 5	donor
SELECT T1.projectid, T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_city LIKE 'Brooklyn' GROUP BY T1.item_name ORDER BY COUNT(T1.item_name) DESC LIMIT 1	donor
SELECT COUNT(T2.schoolid) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.resource_type = 'Books' AND T2.school_metro = 'urban'	donor
SELECT T2.schoolid FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.vendor_name LIKE 'Amazon' GROUP BY T2.schoolid ORDER BY COUNT(T1.vendor_name) DESC LIMIT 1	donor
SELECT COUNT(T2.schoolid) FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.donor_city = 'Los Angeles' AND T2.school_city NOT LIKE 'Los Angeles'	donor
SELECT T2.teacher_prefix FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Reading About Other Cultures'	donor
SELECT T2.students_reached FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Fit Firsties!'	donor
SELECT T1.title, T3.donor_acctid FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T2.school_city LIKE 'Chicago'	donor
SELECT T1.title FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.teacher_prefix LIKE 'Dr.' AND T2.students_reached > 300	donor
SELECT DISTINCT T1.vendor_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.primary_focus_subject LIKE 'Literacy'	donor
SELECT T1.title FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.projectid = ( SELECT projectid FROM resources ORDER BY item_unit_price * item_quantity DESC LIMIT 1 )	donor
SELECT COUNT(donationid) FROM donations WHERE is_teacher_acct = 't' AND donor_city = 'New York'	donor
SELECT COUNT(donationid) FROM donations WHERE for_honoree = 't' AND donor_state = 'NJ'	donor
SELECT donation_message FROM donations WHERE donationid = 'a84dace1ff716f6f0c7af8ef9090a5d5'	donor
SELECT DISTINCT project_resource_type FROM resources WHERE vendor_name = 'Lakeshore Learning Materials'	donor
SELECT item_name FROM resources WHERE vendor_name = 'Lakeshore Learning Materials' ORDER BY item_quantity DESC LIMIT 1	donor
SELECT COUNT(T1.projectid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.teacher_ny_teaching_fellow = 't' AND T2.donor_city = 'New York'	donor
SELECT COUNT(T1.projectid) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.vendor_name = 'Lakeshore Learning Materials' AND T2.teacher_prefix = 'Dr.'	donor
SELECT T1.vendor_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.poverty_level = 'highest poverty'	donor
SELECT T2.schoolid FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.vendor_name = 'Lakeshore Learning Materials' ORDER BY T2.fulfillment_labor_materials DESC LIMIT 1	donor
SELECT T1.vendor_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid ORDER BY T2.total_price_including_optional_support - T2.total_price_including_optional_support DESC LIMIT 1	donor
SELECT SUM(T2.donation_total) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.school_city = 'Brooklyn'	donor
SELECT T2.donation_message FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.school_city = 'Brooklyn' AND T1.school_magnet = 't'	donor
SELECT COUNT(T1.projectid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.payment_included_acct_credit = 't' AND T1.school_year_round = 't'	donor
SELECT SUM(T2.dollar_amount) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.primary_focus_area = 'Literacy & Language'	donor
SELECT T2.donor_acctid FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.primary_focus_area = 'Literacy & Language' ORDER BY T2.donation_total DESC LIMIT 1	donor
SELECT T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.primary_focus_area = 'Literacy & Language' AND T1.project_resource_type = 'Supplies' ORDER BY T1.item_quantity DESC LIMIT 1	donor
SELECT T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.primary_focus_area = 'Literacy & Language' ORDER BY T1.item_unit_price DESC LIMIT 1	donor
SELECT SUM(T2.donation_total) / COUNT(donationid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.school_city = 'Brooklyn'	donor
SELECT DISTINCT donor_city FROM donations WHERE donor_acctid = '22cbc920c9b5fa08dfb331422f5926b5'	donor
SELECT DISTINCT is_teacher_acct FROM donations WHERE donor_acctid = '22cbc920c9b5fa08dfb331422f5926b5'	donor
SELECT CASE WHEN teacher_prefix = 'Dr.' THEN 'Yes' ELSE 'NO' END FROM projects WHERE teacher_acctid = '42d43fa6f37314365d08692e08680973'	donor
SELECT teacher_ny_teaching_fellow end FROM projects WHERE teacher_acctid = '42d43fa6f37314365d08692e08680973'	donor
SELECT T2.title FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T1.school_city LIKE 'Abington'	donor
SELECT T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.teacher_acctid = '822b7b8768c17456fdce78b65abcc18e'	donor
SELECT COUNT(T1.schoolid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.school_magnet = 't' AND T2.payment_included_acct_credit = 'f'	donor
SELECT DISTINCT T1.project_resource_type FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T3.donationid LIKE 'b39547f29dfc25fb13c6e9e8d940dc43'	donor
SELECT CAST(SUM(CASE WHEN T1.project_resource_type = 'Books' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.projectid) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_magnet = 't'	donor
SELECT COUNT(T2.schoolid) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_magnet = 't' AND T1.vendor_name = 'ABC School Supply'	donor
SELECT COUNT(T1.schoolid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.poverty_level = 'highest poverty' AND T2.donor_acctid = '000eebf28658900e63b538cf8a73afbd'	donor
SELECT T2.short_description FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T1.schoolid = '301c9bf0a45d159d162b65a93fddd74e'	donor
SELECT T1.school_city FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title LIKE 'iMath'	donor
SELECT T2.payment_method FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.teacher_acctid = '822b7b8768c17456fdce78b65abcc18e'	donor
SELECT T2.donation_total FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.teacher_acctid = '822b7b8768c17456fdce78b65abcc18e'	donor
SELECT T2.is_teacher_acct FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.schoolid = 'd4af834b1d3fc8061e1ee1b3f1a77b85'	donor
SELECT CAST(SUM(CASE WHEN T1.school_city LIKE 'Brooklyn' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.teacher_acctid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.is_teacher_acct = 't'	donor
SELECT CAST(SUM(CASE WHEN T1.students_reached > 30 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.projectid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.is_teacher_acct = 't'	donor
SELECT COUNT(schoolid) FROM projects WHERE school_city = 'Bethlehem' AND school_metro = 'suburban'	donor
SELECT COUNT(school_year_round) FROM projects WHERE school_city = 'Los Angeles' AND school_year_round = 't'	donor
SELECT COUNT(schoolid) FROM projects WHERE school_county = 'New York (Manhattan)' AND school_magnet = 't'	donor
SELECT COUNT(teacher_acctid) FROM projects WHERE school_county = 'Twin Falls' AND primary_focus_area = 'Math & Science'	donor
SELECT COUNT(teacher_acctid) FROM projects WHERE teacher_prefix = 'Mr.' AND primary_focus_subject = 'Literature & Writing'	donor
SELECT COUNT(projectid) FROM projects WHERE school_district = 'Boston Public School District' AND grade_level = 'Grades 3-5'	donor
SELECT T2.school_city FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title = 'ABC Read'	donor
SELECT T2.teacher_prefix FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Creating Memories and Inspiring Dreams%'	donor
SELECT T2.is_teacher_acct FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Calculate, Financial Security For Tomorrow Starts Today! '	donor
SELECT T1.title FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donation_message LIKE 'Donation on behalf of Matt Carpenter because I''m a strong believer in education.'	donor
SELECT SUM(T2.donation_total) FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'A Rug For Reaching Readers'	donor
SELECT SUM(T2.donation_to_project) + SUM(T2.donation_optional_support) FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Engaging Young Readers with a Leveled Classroom Library '	donor
SELECT T2.donation_optional_support FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Armenian Genocide'	donor
SELECT T1.short_description FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donation_timestamp LIKE '2012-09-06 14:44:29'	donor
SELECT T2.donation_included_optional_support FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'I Can''t See It...Can You Help Me???'	donor
SELECT T1.teacher_acctid FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donation_timestamp LIKE '2008-07-29 11:38:43.361'	donor
SELECT T2.schoolid FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Virtual Aquarium Needs Help!'	donor
SELECT T1.title FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.donation_total = ( SELECT MAX(donation_total) FROM donations )	donor
SELECT CAST(SUM(T2.donation_optional_support) AS REAL) * 100 / SUM(T2.donation_total) FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Awesome Audiobooks Make Avid Readers'	donor
SELECT CAST(SUM(CASE WHEN T2.payment_method LIKE 'creditcard' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(donationid) FROM essays AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Bringing Drama to Life'	donor
SELECT short_description FROM essays WHERE title = 'Future Einsteins Of America'	donor
SELECT need_statement FROM essays WHERE title = 'Family History Project'	donor
SELECT COUNT(projectid) FROM projects WHERE school_district = 'Livingston Parish School Dist' AND school_metro = 'suburban'	donor
SELECT DISTINCT vendor_name FROM resources WHERE item_name = 'Classroom Keepers Management Center'	donor
SELECT DISTINCT project_resource_type FROM resources WHERE vendor_name = 'Sax Arts & Crafts'	donor
SELECT school_county FROM projects WHERE poverty_level = 'low poverty' AND school_state = 'NY' GROUP BY school_state ORDER BY COUNT(poverty_level) DESC LIMIT 1	donor
SELECT T1.school_district FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title LIKE 'Future Einsteins Of America'	donor
SELECT T3.payment_method FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T1.title = 'Needed Resource Materials For My Students'	donor
SELECT COUNT(T1.projectid) FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.payment_method = 'creditcard' AND T2.school_district = 'Memphis City School District'	donor
SELECT T2.school_district FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.vendor_name = 'Barnes and Noble'	donor
SELECT T2.school_latitude, T2.school_longitude FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.item_name = 'R & A Plant Genetics' AND T1.vendor_name = 'Benchmark Education'	donor
SELECT T1.payment_method FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_state = 'GA' GROUP BY T2.school_state ORDER BY COUNT(T1.payment_method) DESC LIMIT 1	donor
SELECT T2.school_latitude, T2.school_longitude, T2.resource_type FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Look, Look, We Need a Nook!'	donor
SELECT T1.donation_message FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_latitude = 40.735332 AND T2.school_longitude = -74.196014 AND T2.school_district = 'Newark School District'	donor
SELECT T1.date_posted FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title LIKE 'Lets Share Ideas'	donor
SELECT T3.donation_message FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T1.title = 'Lets Share Ideas' AND T3.payment_method = 'creditcard'	donor
SELECT T1.project_resource_type FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_district = 'Los Angeles Unif Sch Dist' GROUP BY T2.school_district ORDER BY COUNT(T1.project_resource_type) DESC LIMIT 1	donor
SELECT T2.school_city FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_district = 'Los Angeles Unif Sch Dist' AND T1.vendor_name = 'Quill.com'	donor
SELECT T2.item_unit_price * T2.item_quantity price, T1.school_latitude, T1.school_longitude FROM projects AS T1 INNER JOIN resources AS T2 ON T1.projectid = T2.projectid WHERE T2.vendor_name = 'ABC School Supply' AND T2.project_resource_type = 'Other' AND T1.school_district = 'Hillsborough Co Pub Sch Dist'	donor
SELECT SUM(T3.donation_total), school_city, poverty_level FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T1.title = 'Lets Share Ideas' AND T3.payment_method = 'paypal'	donor
SELECT COUNT(donationid) FROM donations WHERE donor_city = 'Pocatello' AND is_teacher_acct = 'f'	donor
SELECT COUNT(schoolid) FROM projects WHERE teacher_prefix = 'Dr.' AND school_county = 'Suffolk'	donor
SELECT SUM(donation_to_project) + SUM(donation_optional_support) FROM donations WHERE payment_method = 'amazon'	donor
SELECT COUNT(donationid) FROM donations WHERE dollar_amount = '100_and_up' AND for_honoree = 't'	donor
SELECT vendorid FROM resources WHERE project_resource_type = 'Technology' AND item_unit_price <= 15	donor
SELECT COUNT(projectid) FROM resources WHERE vendor_name = 'Quill.com' AND item_quantity BETWEEN 5 AND 10	donor
SELECT schoolid FROM projects WHERE school_district = 'Union Pub School District I-9' AND teacher_ny_teaching_fellow = 't'	donor
SELECT school_city FROM projects WHERE school_metro = 'suburban' AND school_county = 'Los Angeles'	donor
SELECT DISTINCT vendorid, projectid FROM resources WHERE project_resource_type = 'Books'	donor
SELECT CAST(SUM(CASE WHEN payment_included_campaign_gift_card = 't' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(donationid) FROM donations WHERE payment_method = 'no_cash_received'	donor
SELECT CAST(SUM(CASE WHEN school_metro = 'suburban' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(projectid) FROM projects WHERE school_city = 'Santa Barbara'	donor
SELECT payment_method , CAST(COUNT(donationid) AS REAL) * 100 / 51090 FROM donations WHERE donation_timestamp LIKE '2013-03%' GROUP BY payment_method	donor
SELECT SUM(item_unit_price) / SUM(item_quantity) FROM resources WHERE vendor_name = 'AKJ Books'	donor
SELECT COUNT(T2.schoolid) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T2.school_city = 'Brooklyn' AND T2.school_metro = 'urban' AND T3.for_honoree = 't' AND T1.item_name = 'TT992 - Refill Pack for Safety Name Tags'	donor
SELECT COUNT(T1.schoolid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.payment_included_campaign_gift_card = 't' AND T1.poverty_level = 'highest poverty'	donor
SELECT T2.school_city FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.dollar_amount = 'under_10' GROUP BY T2.school_city ORDER BY COUNT(T2.schoolid) DESC LIMIT 1	donor
SELECT T1.title FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_latitude = 42003718 AND T2.school_longitude = -87668289	donor
SELECT T2.teacher_ny_teaching_fellow FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.title LIKE 'Team More Books!'	donor
SELECT T1.vendor_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.primary_focus_area LIKE 'Literacy%' GROUP BY T1.vendor_name ORDER BY COUNT(T2.primary_focus_area) DESC LIMIT 1	donor
SELECT DISTINCT T1.vendor_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.grade_level = 'Grades 9-12'	donor
SELECT COUNT(DISTINCT T2.teacher_acctid) FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.is_teacher_acct = 't' AND T2.school_city = 'Chicago'	donor
SELECT COUNT(DISTINCT T1.teacher_acctid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.school_city = 'Rock Hill' AND is_teacher_acct = 't'	donor
SELECT SUM(T2.dollar_amount) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.students_reached > 300 AND t2.donation_included_optional_support = 't'	donor
SELECT SUM(T1.item_quantity) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.school_metro = 'urban' AND T2.school_district = 'Onslow Co School District'	donor
SELECT SUM(T2.donation_optional_support + T2.donation_to_project) / COUNT(donationid) FROM projects AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T1.school_county = 'Fresno'	donor
SELECT CAST(SUM(CASE WHEN T2.title LIKE 'ABC Read' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.school_county) FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid	donor
SELECT AVG(T1.item_quantity) FROM resources AS T1 INNER JOIN donations AS T2 ON T1.projectid = T2.projectid WHERE T2.for_honoree = 't'	donor
SELECT T1.date_posted FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title LIKE 'Photojournalists Want to Exhibit Their Best Works'	donor
SELECT T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T2.primary_focus_subject = 'Mathematics' ORDER BY T1.item_unit_price DESC LIMIT 1	donor
SELECT T2.school_city, T2.school_latitude, T2.school_longitude FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.item_name = 'Viewscreen LCD FROM Texas Instruments, TI-84 Plus'	donor
SELECT SUM(T3.donation_total) FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN donations AS T3 ON T2.projectid = T3.projectid WHERE T1.title = 'Look, Look, We Need a Nook!'	donor
SELECT DISTINCT T2.poverty_level FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.donor_zip = 7079	donor
SELECT T3.vendor_name FROM essays AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid INNER JOIN resources AS T3 ON T2.projectid = T3.projectid WHERE T1.title = 'Bloody Times'	donor
SELECT T2.school_zip, T1.item_name FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.vendor_name = 'Sax Arts & Crafts'	donor
SELECT T1.school_longitude, T1.school_latitude FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title LIKE 'Wiping Away Bad Grades'	donor
SELECT DISTINCT T2.primary_focus_subject FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.payment_included_campaign_gift_card = 't'	donor
SELECT T1.item_name, T2.short_description FROM resources AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T1.project_resource_type = 'Books' ORDER BY T1.item_unit_price DESC LIMIT 1	donor
SELECT T1.grade_level FROM projects AS T1 INNER JOIN essays AS T2 ON T1.projectid = T2.projectid WHERE T2.title LIKE 'Too Close for Comfort'	donor
SELECT SUM(T2.students_reached) FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.donor_zip = 22205	donor
SELECT CAST(SUM(CASE WHEN T1.via_giving_page = 't' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(donation_total), ( SELECT T2.primary_focus_area FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.via_giving_page = 't' GROUP BY T2.primary_focus_area ORDER BY SUM(T1.donation_total) DESC LIMIT 1 ) result FROM donations AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid	donor
SELECT CAST(SUM(CASE WHEN T1.vendor_name = 'Best Buy for Business' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.projectid) FROM resources AS T1 INNER JOIN projects AS T2 ON T1.projectid = T2.projectid WHERE T1.project_resource_type = 'Technology' UNION ALL SELECT DISTINCT T1.date_posted FROM projects AS T1 INNER JOIN resources AS T2 ON T1.projectid = T2.projectid WHERE T2.vendor_name = 'Best Buy for Business' AND T2.project_resource_type = 'Technology'	donor
SELECT (SUM(CASE WHEN T.game_platform_id = 50 THEN T.num_sales ELSE 0 END) - SUM(CASE WHEN T.game_platform_id = 51 THEN T.num_sales ELSE 0 END)) * 100000 AS nums FROM region_sales AS T WHERE T.region_id = 1	video_games
SELECT T1.game_name FROM game AS T1 WHERE T1.genre_id = ( SELECT T.genre_id FROM game AS T WHERE T.game_name = '3D Lemmings' )	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Action'	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = '3D Lemmings'	video_games
SELECT T3.publisher_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T1.game_name = '3D Lemmings'	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T3.publisher_name = '10TACLE Studios'	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T4.genre_name = 'Puzzle' AND T3.publisher_name = '10TACLE Studios'	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T3.publisher_name = '10TACLE Studios' AND T4.genre_name = 'Puzzle'	video_games
SELECT T.publisher_name FROM ( SELECT T2.publisher_name, COUNT(DISTINCT T2.id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id GROUP BY T1.publisher_id ORDER BY COUNT(T2.id) DESC LIMIT 1 ) t	video_games
SELECT T5.platform_name FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN game AS T3 ON T1.game_id = T3.id INNER JOIN game_platform AS T4 ON T1.id = T4.game_publisher_id INNER JOIN platform AS T5 ON T4.platform_id = T5.id WHERE T3.game_name = 'Panzer Tactics' AND T4.release_year = 2007	video_games
SELECT T4.release_year FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN game AS T3 ON T1.game_id = T3.id INNER JOIN game_platform AS T4 ON T1.id = T4.game_publisher_id INNER JOIN platform AS T5 ON T4.platform_id = T5.id WHERE T3.game_name = 'Panzer Tactics' AND T5.platform_name = 'DS'	video_games
SELECT DISTINCT T3.publisher_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T4.genre_name = 'Puzzle'	video_games
SELECT T.publisher_name FROM ( SELECT T3.publisher_name, COUNT(DISTINCT T1.id) FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T4.genre_name = 'Puzzle' GROUP BY T3.publisher_name ORDER BY COUNT(DISTINCT T1.id) DESC LIMIT 1 ) t	video_games
SELECT COUNT(T.publisher_name) FROM ( SELECT T3.publisher_name, COUNT(DISTINCT T1.id) FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T4.genre_name = 'Puzzle' GROUP BY T3.publisher_name HAVING COUNT(DISTINCT T1.id) > 3 ) t	video_games
SELECT CAST(COUNT(CASE WHEN T4.genre_name = 'Sports' THEN T1.id ELSE NULL END) AS REAL) * 100/ COUNT(T1.id) FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T3.publisher_name = 'Nintendo'	video_games
SELECT SUM(T1.num_sales) * 100000 / 4 FROM region_sales AS T1 INNER JOIN game_platform AS T2 ON T1.game_platform_id = T2.id INNER JOIN platform AS T3 ON T2.platform_id = T3.id WHERE T3.platform_name = 'DS'	video_games
SELECT DISTINCT T.game_id FROM game_publisher AS T WHERE T.publisher_id = 352	video_games
SELECT T.genre_id FROM game AS T WHERE T.game_name = 'Pro Evolution Soccer 2012'	video_games
SELECT T.id FROM region AS T WHERE T.region_name = 'Japan'	video_games
SELECT T1.game_platform_id FROM ( SELECT T.game_platform_id, SUM(T.num_sales) FROM region_sales AS T WHERE T.region_id = 2 GROUP BY T.game_platform_id ORDER BY SUM(T.num_sales) DESC LIMIT 1 ) T1	video_games
SELECT genre_id FROM ( SELECT T.genre_id, COUNT(T.id) FROM game AS T GROUP BY T.genre_id ORDER BY COUNT(T.id) DESC LIMIT 1 )	video_games
SELECT T.genre_id FROM game AS T WHERE T.game_name = 'Resident Evil Archives: Resident Evil'	video_games
SELECT COUNT(DISTINCT T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T1.platform_name = 'X360' AND T2.release_year = 2010	video_games
SELECT T1.publisher_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T3.game_name = 'ModNation Racers'	video_games
SELECT T.game_platform_id FROM ( SELECT T2.game_platform_id, MAX(T2.num_sales) FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'Japan' ) t	video_games
SELECT COUNT(T2.id) FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id INNER JOIN game_publisher AS T3 ON T1.game_publisher_id = T3.id INNER JOIN game AS T4 ON T3.game_id = T4.id WHERE T4.game_name = 'Pro Evolution Soccer 2016'	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Sports'	video_games
SELECT T2.publisher_name FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T1.game_id = 10031	video_games
SELECT T.publisher_name FROM ( SELECT T2.publisher_name, COUNT(DISTINCT T1.game_id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id GROUP BY T2.publisher_name ORDER BY COUNT(DISTINCT T1.game_id) DESC LIMIT 1 ) t	video_games
SELECT COUNT(CASE WHEN T1.genre_name = 'Sports' THEN T2.id ELSE NULL END) - COUNT(CASE WHEN T1.genre_name = 'Simulation' THEN T2.id ELSE NULL END) FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = 'Resident Evil: Revelations'	video_games
SELECT T2.num_sales * 100000 FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'Europe' AND T2.game_platform_id = 3871	video_games
SELECT COUNT(T2.game_id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id WHERE T1.publisher_name = 'Ascaron Entertainment GmbH'	video_games
SELECT T2.platform_name FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id ORDER BY T1.release_year ASC LIMIT 1	video_games
SELECT CAST(COUNT(CASE WHEN T4.genre_name = 'Adventure' THEN T1.id ELSE NULL END) AS REAL) * 100 / COUNT(T1.id) FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id INNER JOIN genre AS T4 ON T1.genre_id = T4.id WHERE T3.publisher_name = 'Namco Bandai Games'	video_games
SELECT CAST(COUNT(CASE WHEN T1.publisher_name = 'Atari' THEN T2.game_id ELSE NULL END) AS REAL) / COUNT(CASE WHEN T1.publisher_name = 'Athena' THEN T2.game_id ELSE NULL END) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id	video_games
SELECT COUNT(DISTINCT T2.game_id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id WHERE T1.publisher_name = 'Electronic Arts'	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = 'Advent Rising'	video_games
SELECT COUNT(T3.id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T4.genre_name = 'Role-Playing' AND T1.publisher_name = 'Microsoft Game Studios'	video_games
SELECT T.publisher_name FROM ( SELECT T2.publisher_name, COUNT(DISTINCT T1.game_id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id GROUP BY T2.publisher_name ORDER BY COUNT(DISTINCT T1.game_id) DESC LIMIT 1 ) t	video_games
SELECT T4.platform_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T3.release_year = 2004 AND T1.publisher_name = 'Codemasters'	video_games
SELECT COUNT(DISTINCT T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T1.platform_name = 'PS4' AND T2.release_year = 2014	video_games
SELECT DISTINCT T3.publisher_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id ORDER BY T1.release_year LIMIT 1	video_games
SELECT COUNT(T3.game_publisher_id) FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T4.platform_name = 'X360' AND T3.release_year = 2011 AND T1.region_name = 'Japan'	video_games
SELECT T.platform_name FROM ( SELECT T4.platform_name, SUM(T2.num_sales) FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T1.region_name = 'Europe' ORDER BY T2.num_sales DESC LIMIT 1 ) t	video_games
SELECT T.release_year FROM ( SELECT T2.release_year, COUNT(DISTINCT T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T1.platform_name = 'PC' GROUP BY T2.release_year ORDER BY COUNT(DISTINCT T3.game_id) DESC LIMIT 1 ) t	video_games
SELECT T.publisher_name FROM ( SELECT T2.publisher_name, COUNT(DISTINCT T1.game_id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id GROUP BY T2.publisher_name HAVING COUNT(DISTINCT T1.game_id) = 1 ) t	video_games
SELECT T3.game_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.publisher_name = '505 Games'	video_games
SELECT T.genre_id FROM game AS T WHERE T.game_name = '25 to Life'	video_games
SELECT T.id FROM game AS T WHERE T.genre_id = 2	video_games
SELECT T.release_year FROM game_platform AS T WHERE T.id BETWEEN 1 AND 10	video_games
SELECT T.game_publisher_id FROM game_platform AS T WHERE T.platform_id = 15	video_games
SELECT T.id FROM game_platform AS T WHERE T.release_year BETWEEN 2000 AND 2003	video_games
SELECT T.num_sales * 100000 FROM region_sales AS T WHERE T.region_id = 2 AND T.game_platform_id = 9615	video_games
SELECT DISTINCT T1.platform_name FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id WHERE T2.release_year = 2016	video_games
SELECT T1.release_year FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T3.game_name = '3DS Classic Collection'	video_games
SELECT AVG(T2.num_sales) * 100000 AS avg_japan FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'Japan'	video_games
SELECT DISTINCT T4.genre_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T1.release_year BETWEEN 2000 AND 2002	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T3.publisher_name = '3DO'	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Role-Playing'	video_games
SELECT DISTINCT T1.region_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T2.num_sales * 100000 > 300000	video_games
SELECT T.publisher_name FROM ( SELECT T5.publisher_name, SUM(T2.num_sales) * 100000 FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN game_publisher AS T4 ON T3.game_publisher_id = T4.id INNER JOIN publisher AS T5 ON T4.publisher_id = T5.id WHERE T1.region_name = 'North America' GROUP BY T5.publisher_name ORDER BY SUM(T2.num_sales) * 100000 DESC LIMIT 1 ) t	video_games
SELECT T3.release_year FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id WHERE T2.num_sales * 100000 = 350000 AND T1.region_name = 'North America'	video_games
SELECT T1.platform_name FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id INNER JOIN game AS T4 ON T3.game_id = T4.id WHERE T4.game_name = 'Counter Force'	video_games
SELECT T2.publisher_name FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T1.game_id = 75	video_games
SELECT T.game_name FROM ( SELECT T5.game_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN game_publisher AS T4 ON T3.game_publisher_id = T4.id INNER JOIN game AS T5 ON T4.game_id = T5.id WHERE T1.region_name = 'Japan' ORDER BY T2.num_sales DESC LIMIT 1 ) t	video_games
SELECT DISTINCT T5.publisher_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN game_publisher AS T4 ON T3.game_publisher_id = T4.id INNER JOIN publisher AS T5 ON T4.publisher_id = T5.id WHERE T2.num_sales * 10000000 > ( SELECT AVG(T2.num_sales) * 100000 * 90 FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'Japan' )	video_games
SELECT CAST(COUNT(CASE WHEN T1.platform_name = 'PSP' THEN T3.game_id ELSE NULL END) AS REAL) * 100 / COUNT(T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T2.release_year = 2004	video_games
SELECT COUNT(T.id) FROM game_platform AS T WHERE T.release_year = 1981	video_games
SELECT T.genre_id FROM game AS T WHERE T.game_name = '2Xtreme'	video_games
SELECT SUM(T.num_sales) * 100000 FROM region_sales AS T WHERE T.game_platform_id = 9658	video_games
SELECT T.id FROM publisher AS T WHERE T.publisher_name = '1C Company'	video_games
SELECT T.genre_name FROM genre AS T WHERE T.id = 3	video_games
SELECT T.id FROM game_platform AS T WHERE T.release_year = 2017	video_games
SELECT T3.release_year FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id WHERE T1.game_name = 'Adventure Island'	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Puzzle'	video_games
SELECT T4.game_name FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id INNER JOIN game_publisher AS T3 ON T1.game_publisher_id = T3.id INNER JOIN game AS T4 ON T3.game_id = T4.id WHERE T2.platform_name = 'SCD'	video_games
SELECT COUNT(DISTINCT T1.game_id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T2.publisher_name = 'Acclaim Entertainment'	video_games
SELECT T3.publisher_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T1.game_name = 'Chronicles of the Sword'	video_games
SELECT SUM(T1.num_sales * 100000) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id INNER JOIN game_platform AS T3 ON T1.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T2.region_name = 'North America' AND T4.platform_name = 'PS4'	video_games
SELECT T.game_platform_id FROM ( SELECT T1.game_platform_id, SUM(T1.num_sales) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id WHERE T2.region_name = 'Europe' GROUP BY T1.game_platform_id ORDER BY SUM(T1.num_sales) DESC LIMIT 1 ) t	video_games
SELECT T3.game_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.release_year = 2011	video_games
SELECT COUNT(T1.id) FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id WHERE T2.platform_name = 'Wii'	video_games
SELECT T3.game_name, T1.release_year FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T4.genre_name = 'Sports' LIMIT 5	video_games
SELECT T2.id FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = '2Xtreme'	video_games
SELECT T4.platform_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T1.game_name = 'Panzer Tactics'	video_games
SELECT (SUM(CASE WHEN T2.region_name = 'North America' THEN T1.num_sales ELSE 0 END) - AVG(T1.num_sales)) * 100.0 / AVG(T1.num_sales) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id WHERE T1.game_platform_id = 9577	video_games
SELECT T.game_name FROM game AS T ORDER BY LENGTH(T.game_name) DESC LIMIT 1	video_games
SELECT COUNT(T.id) FROM game_platform AS T WHERE T.release_year = 2001	video_games
SELECT SUM(T.num_sales) * 100000 FROM region_sales t	video_games
SELECT CAST(COUNT(T.game_id) AS REAL) / COUNT(DISTINCT T.publisher_id) FROM game_publisher AS T	video_games
SELECT MIN(T.release_year) FROM game_platform t	video_games
SELECT T.game_name FROM ( SELECT T2.game_name, COUNT(T2.id) FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id GROUP BY T2.game_name ORDER BY COUNT(T2.id) ASC LIMIT 1 ) t	video_games
SELECT T1.publisher_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T3.game_name = 'Prism: Light the Way'	video_games
SELECT T1.platform_name FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id GROUP BY T2.release_year, T1.platform_name ORDER BY COUNT(DISTINCT T3.game_id) DESC	video_games
SELECT COUNT(*) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id WHERE T2.region_name = 'Europe' AND T1.num_sales = 0	video_games
SELECT T3.game_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.release_year = 2006	video_games
SELECT T1.genre_name FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id WHERE T2.game_name = 'Mario vs. Donkey Kong'	video_games
SELECT T.publisher_name FROM ( SELECT T1.publisher_name, COUNT(DISTINCT T2.game_id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id GROUP BY T1.publisher_name ORDER BY COUNT(DISTINCT T2.game_id) DESC LIMIT 1 ) t	video_games
SELECT T2.game_name FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id WHERE T1.genre_name = 'Platform'	video_games
SELECT T2.release_year FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id WHERE T1.platform_name = 'WiiU' ORDER BY T2.release_year DESC LIMIT 1	video_games
SELECT T5.game_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN game_publisher AS T4 ON T3.game_publisher_id = T4.id INNER JOIN game AS T5 ON T4.game_id = T5.id WHERE T1.region_name = 'Japan' ORDER BY T2.num_sales DESC LIMIT 1	video_games
SELECT T3.game_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.publisher_name = 'Activision'	video_games
SELECT COUNT(DISTINCT T1.publisher_id) FROM game_publisher AS T1 INNER JOIN game AS T2 ON T1.game_id = T2.id WHERE T2.game_name LIKE 'Marvel%'	video_games
SELECT CAST(COUNT(CASE WHEN T1.genre_name = 'Sports' THEN T2.id ELSE NULL END) AS REAL) * 100 / COUNT(T2.id) FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id	video_games
SELECT SUM(CASE WHEN T2.region_name = 'North America' THEN T1.num_sales ELSE 0 END) / SUM(CASE WHEN T2.region_name = 'Japan' THEN T1.num_sales ELSE 0 END) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id	video_games
SELECT T1.release_year FROM ( SELECT T.release_year, COUNT(id) FROM game_platform AS T GROUP BY T.release_year ORDER BY COUNT(T.id) DESC LIMIT 1 ) T1	video_games
SELECT COUNT(T.id) FROM publisher AS T WHERE T.publisher_name LIKE '%Interactive%'	video_games
SELECT T4.platform_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T1.region_name = 'North America' ORDER BY T2.num_sales DESC LIMIT 2	video_games
SELECT COUNT(DISTINCT T2.game_id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id WHERE T3.release_year = 2012	video_games
SELECT T3.publisher_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T1.release_year = 2007 GROUP BY T3.publisher_name ORDER BY COUNT(DISTINCT T2.game_id) DESC LIMIT 1	video_games
SELECT COUNT(T2.publisher_id) FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id WHERE T1.game_name = 'Minecraft'	video_games
SELECT T.publisher_name FROM ( SELECT T4.publisher_name, COUNT(DISTINCT T2.id) FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id INNER JOIN game_publisher AS T3 ON T2.id = T3.game_id INNER JOIN publisher AS T4 ON T3.publisher_id = T4.id WHERE T1.genre_name = 'Action' GROUP BY T4.publisher_name ORDER BY COUNT(DISTINCT T2.id) DESC LIMIT 1 ) t	video_games
SELECT COUNT(T3.id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T4.genre_name = 'Sports' AND T1.publisher_name = 'Nintendo'	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = '2 Games in 1: Sonic Advance & ChuChu Rocket!'	video_games
SELECT COUNT(DISTINCT T2.id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN region_sales AS T3 ON T1.id = T3.game_platform_id INNER JOIN region AS T4 ON T3.region_id = T4.id WHERE T1.platform_name = 'DS' AND T4.region_name = 'Other' AND T3.num_sales > 0	video_games
SELECT T3.game_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.publisher_name = 'American Softworks'	video_games
SELECT COUNT(CASE WHEN T1.genre_name = 'Strategy' THEN T2.id ELSE NULL END) FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id	video_games
SELECT T3.publisher_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T1.game_name = 'Overwatch'	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T2.id = T1.genre_id GROUP BY T2.genre_name ORDER BY COUNT(T1.genre_id) DESC LIMIT 1	video_games
SELECT T2.num_sales * 100000 AS nums_eur FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T2.game_platform_id = 26 AND T1.region_name = 'Europe'	video_games
SELECT COUNT(id) FROM game_platform AS T WHERE T.release_year = 2001	video_games
SELECT COUNT(*) FROM ( SELECT T.game_name FROM game AS T WHERE T.game_name LIKE '%Box%' )	video_games
SELECT T.game_platform_id, SUM(T.num_sales) * 100000 FROM region_sales AS T GROUP BY game_platform_id ORDER BY SUM(T.num_sales) * 100000 DESC LIMIT 3	video_games
SELECT T.release_year FROM game_platform AS T ORDER BY T.release_year ASC LIMIT 1	video_games
SELECT T.publisher_name FROM publisher AS T WHERE T.publisher_name LIKE '%Entertainment%'	video_games
SELECT T2.game_name FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id WHERE T1.genre_name = 'Adventure'	video_games
SELECT T3.game_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.publisher_name = 'Pioneer LDC'	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T4.platform_name = 'SCD'	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN region_sales AS T4 ON T3.id = T4.game_platform_id INNER JOIN region AS T5 ON T4.region_id = T5.id WHERE T5.region_name = 'Japan'	video_games
SELECT T4.genre_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T1.publisher_name = 'Agatsuma Entertainment'	video_games
SELECT COUNT(T2.id) FROM genre AS T1 INNER JOIN game AS T2 ON T1.id = T2.genre_id WHERE T1.genre_name NOT IN ('Role-Playing', 'Shooter', 'Simulation')	video_games
SELECT T.region_name FROM ( SELECT T1.platform_name, T4.region_name, SUM(T3.num_sales) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN region_sales AS T3 ON T1.id = T3.game_platform_id INNER JOIN region AS T4 ON T3.region_id = T4.id GROUP BY T1.platform_name, T4.region_name ORDER BY SUM(T3.num_sales) DESC LIMIT 1 ) t	video_games
SELECT T.publisher_name FROM ( SELECT T1.publisher_name, COUNT(T3.id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T4.genre_name = 'Puzzle' GROUP BY T1.publisher_name ORDER BY COUNT(T3.id) DESC LIMIT 1 ) t	video_games
SELECT T.game_name FROM ( SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN region_sales AS T4 ON T3.id = T4.game_platform_id ORDER BY T4.num_sales LIMIT 1 ) t	video_games
SELECT T1.publisher_name FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T3.game_name = 'Pachi-Slot Kanzen Kouryaku 3: Universal Koushiki Gaido Volume 3'	video_games
SELECT T5.region_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN region_sales AS T4 ON T3.id = T4.game_platform_id INNER JOIN region AS T5 ON T4.region_id = T5.id WHERE T1.game_name = 'Pengo'	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id WHERE T3.release_year = '2010'	video_games
SELECT SUM(T3.num_sales * 100000) / COUNT(T1.id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN region_sales AS T3 ON T2.id = T3.game_platform_id WHERE T1.platform_name = 'PS2'	video_games
SELECT CAST(COUNT(CASE WHEN T1.publisher_name = 'Brash Entertainment' THEN T2.game_id ELSE NULL END) AS REAL) * 100 / COUNT(T2.game_id) FROM publisher AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.publisher_id	video_games
SELECT SUM(T.num_sales * 100000) FROM region_sales AS T WHERE T.region_id = 1	video_games
SELECT COUNT(*) FROM ( SELECT T.game_name FROM game AS T WHERE T.game_name LIKE '%FIFA%' )	video_games
SELECT T.platform_name FROM ( SELECT T4.platform_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T1.region_name = 'Europe' ORDER BY T2.num_sales DESC LIMIT 1 ) t	video_games
SELECT T2.publisher_name FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN game AS T3 ON T1.game_id = T3.id WHERE T3.game_name = '2002 FIFA World Cup'	video_games
SELECT T2.platform_name FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id INNER JOIN game_publisher AS T3 ON T1.game_publisher_id = T3.id INNER JOIN game AS T4 ON T3.game_id = T4.id WHERE T4.game_name = '3Xtreme'	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = '2010 FIFA World Cup South Africa'	video_games
SELECT T.region_name FROM ( SELECT T2.region_name, SUM(T1.num_sales) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id INNER JOIN game_platform AS T3 ON T1.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id GROUP BY T4.platform_name ORDER BY SUM(T1.num_sales) DESC LIMIT 1 ) t	video_games
SELECT SUM(T1.num_sales * 100000) FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id INNER JOIN game_platform AS T3 ON T1.game_platform_id = T3.id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T2.region_name = 'Japan' AND T4.platform_name = 'PS3'	video_games
SELECT T3.game_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.release_year = 2007	video_games
SELECT COUNT(DISTINCT T3.id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id INNER JOIN game AS T3 ON T1.game_id = T3.id WHERE T2.publisher_name = 'Activision'	video_games
SELECT DISTINCT T3.release_year FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id WHERE T2.num_sales * 100000 > 200000 AND T1.region_name = 'Japan'	video_games
SELECT COUNT(T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T1.platform_name = 'PS3' AND T2.release_year = 2010	video_games
SELECT T.publisher_name FROM ( SELECT T2.publisher_name, COUNT(DISTINCT T1.game_id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id GROUP BY T2.publisher_name ORDER BY COUNT(DISTINCT T1.game_id) DESC LIMIT 1 ) t	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Shooter'	video_games
SELECT CAST(COUNT(CASE WHEN T2.platform_name = 'PS4' THEN T3.game_id ELSE NULL END) AS REAL) * 100 / COUNT(T3.game_id) FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id INNER JOIN game_publisher AS T3 ON T1.game_publisher_id = T3.id WHERE T1.release_year = 2014	video_games
SELECT SUM(T.num_sales) * 100000 FROM region_sales AS T WHERE T.region_id = 4	video_games
SELECT T.game_platform_id FROM region_sales AS T WHERE T.region_id = 1	video_games
SELECT SUM(CASE WHEN T.region_id = 2 THEN T.num_sales ELSE 0 END) - SUM(CASE WHEN T.region_id = 3 THEN T.num_sales ELSE 0 END) FROM region_sales t	video_games
SELECT DISTINCT T.platform_id FROM game_platform AS T WHERE T.release_year = 2007	video_games
SELECT T.game_publisher_id FROM game_platform AS T WHERE T.platform_id = 16	video_games
SELECT COUNT(T.game_publisher_id) FROM game_platform AS T WHERE T.release_year = 1984	video_games
SELECT T2.id FROM region_sales AS T1 INNER JOIN game_platform AS T2 ON T1.game_platform_id = T2.id WHERE T1.region_id = 3	video_games
SELECT SUM(CASE WHEN T2.region_name = 'Japan' THEN T1.num_sales ELSE 0 END) AS nums FROM region_sales AS T1 INNER JOIN region AS T2 ON T1.region_id = T2.id	video_games
SELECT COUNT(T1.game_publisher_id) FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id WHERE T2.platform_name = 'X360'	video_games
SELECT DISTINCT T2.platform_name FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id WHERE T1.release_year = 2000	video_games
SELECT COUNT(CASE WHEN T2.platform_name = 'PS3' THEN T1.game_publisher_id ELSE NULL END) - COUNT(CASE WHEN T2.platform_name = 'X360' THEN T1.game_publisher_id ELSE NULL END) FROM game_platform AS T1 INNER JOIN platform AS T2 ON T1.platform_id = T2.id	video_games
SELECT T1.game_id FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T2.publisher_name = 'Bethesda Softworks'	video_games
SELECT COUNT(DISTINCT T1.game_id) FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T2.publisher_name IN ('Capcom', 'Sony Computer Entertainment')	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = 'Grand Theft Auto V'	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Racing'	video_games
SELECT COUNT(T1.id) FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Fighting'	video_games
SELECT DISTINCT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id INNER JOIN game_publisher AS T3 ON T1.id = T3.game_id WHERE T3.publisher_id = 464	video_games
SELECT T4.platform_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN game_platform AS T3 ON T2.id = T3.game_publisher_id INNER JOIN platform AS T4 ON T3.platform_id = T4.id WHERE T1.game_name = 'Final Fantasy XIII-2'	video_games
SELECT SUM(T1.num_sales) FROM region_sales AS T1 INNER JOIN game_platform AS T2 ON T1.game_platform_id = T2.id WHERE T2.release_year = 2000	video_games
SELECT SUM(CASE WHEN T2.release_year = 2000 THEN T1.num_sales ELSE 0 END) - SUM(CASE WHEN T2.release_year = 1990 THEN T1.num_sales ELSE 0 END) FROM region_sales AS T1 INNER JOIN game_platform AS T2 ON T1.game_platform_id = T2.id	video_games
SELECT DISTINCT T.platform_id FROM game_platform AS T WHERE T.release_year = 2006	video_games
SELECT AVG(T.num_sales * 100000) FROM region_sales AS T WHERE T.region_id = 3	video_games
SELECT T.release_year FROM game_platform AS T WHERE T.game_publisher_id = 6657 AND T.id = 19	video_games
SELECT SUM(T.num_sales) * 100000 FROM region_sales AS T WHERE T.game_platform_id = 66	video_games
SELECT T.game_name FROM game AS T WHERE T.id = 44	video_games
SELECT T4.game_name FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id INNER JOIN game AS T4 ON T3.game_id = T4.id WHERE T1.platform_name = 'Wii'	video_games
SELECT T3.game_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T1.release_year = 2015	video_games
SELECT COUNT(DISTINCT T3.id) FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN genre AS T4 ON T3.genre_id = T4.id WHERE T4.genre_name = 'Adventure' AND T1.release_year = 2005	video_games
SELECT T3.publisher_name FROM game AS T1 INNER JOIN game_publisher AS T2 ON T1.id = T2.game_id INNER JOIN publisher AS T3 ON T2.publisher_id = T3.id WHERE T1.game_name = 'Adventure Time: Explore the Dungeon Because I Don''t Know!'	video_games
SELECT T2.game_platform_id, T1.region_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T2.num_sales * 100000 <= 20000	video_games
SELECT T3.game_name FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id INNER JOIN publisher AS T4 ON T2.publisher_id = T4.id WHERE T4.publisher_name = '505 Games' AND T1.release_year = 2006	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.id = 119	video_games
SELECT T1.game_id FROM game_publisher AS T1 INNER JOIN publisher AS T2 ON T1.publisher_id = T2.id WHERE T2.publisher_name = 'Abylight'	video_games
SELECT DISTINCT T1.region_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id ORDER BY T2.num_sales LIMIT 1	video_games
SELECT T1.game_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T2.genre_name = 'Strategy'	video_games
SELECT T3.platform_name FROM game_publisher AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.game_publisher_id INNER JOIN platform AS T3 ON T2.platform_id = T3.id WHERE T1.game_id = 178	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name IN ('Airlock', 'Airline Tycoon', 'Airblade')	video_games
SELECT SUM(T2.num_sales) * 100000 AS nums FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'North America'	video_games
SELECT T.publisher_name FROM ( SELECT DISTINCT T5.publisher_name FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id INNER JOIN game_publisher AS T4 ON T3.game_publisher_id = T4.id INNER JOIN publisher AS T5 ON T4.publisher_id = T5.id WHERE T1.region_name = 'North America' AND T2.num_sales * 100000 < 10000 LIMIT 5 ) t	video_games
SELECT T1.platform_id FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id INNER JOIN game AS T3 ON T2.game_id = T3.id WHERE T3.game_name = 'Airborne Troops: Countdown to D-Day'	video_games
SELECT COUNT(T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T1.platform_name = 'PSP' AND T2.release_year = 2004	video_games
SELECT T2.genre_name FROM game AS T1 INNER JOIN genre AS T2 ON T1.genre_id = T2.id WHERE T1.game_name = '999: Nine Hours, Nine Persons, Nine Doors'	video_games
SELECT T1.release_year FROM game_platform AS T1 INNER JOIN game_publisher AS T2 ON T1.game_publisher_id = T2.id WHERE T2.game_id = 156	video_games
SELECT COUNT(CASE WHEN T1.platform_name = 'SNES' THEN T3.game_id ELSE NULL END) - COUNT(CASE WHEN T1.platform_name = 'DS' THEN T3.game_id ELSE NULL END) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id INNER JOIN publisher AS T4 ON T3.publisher_id = T4.id WHERE T4.publisher_name = 'Culture Brain'	video_games
SELECT CAST(COUNT(CASE WHEN T2.release_year = 2007 THEN T3.game_id ELSE NULL END) AS REAL) * 100 / COUNT(T3.game_id) FROM platform AS T1 INNER JOIN game_platform AS T2 ON T1.id = T2.platform_id INNER JOIN game_publisher AS T3 ON T2.game_publisher_id = T3.id WHERE T1.platform_name = 'Wii'	video_games
SELECT DISTINCT T3.platform_id FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id INNER JOIN game_platform AS T3 ON T2.game_platform_id = T3.id WHERE T1.region_name = 'Europe' AND T2.num_sales * 100 * 100000 < ( SELECT AVG(T2.num_sales * 100000) * 30 FROM region AS T1 INNER JOIN region_sales AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'Europe' )	video_games
SELECT COUNT(Id) FROM Author WHERE Affiliation = 'University of California Berkeley'	authors
SELECT Keyword FROM Paper WHERE Title = 'Stitching videos streamed by mobile phones in real-time'	authors
SELECT T2.Title FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Concepts in Magnetic Resonance Part A' AND T2.Year = 2008	authors
SELECT COUNT(T2.Id) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Concepts in Magnetic Resonance Part A'	authors
SELECT T1.HomePage FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T2.Title = 'Area Effects in Cepaea'	authors
SELECT COUNT(T2.Id) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T2.Year = 2011 AND T1.FullName = 'Molecular Brain'	authors
SELECT COUNT(T2.Id) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T2.Year = 2011 AND T1.ShortName = 'Mol Brain'	authors
SELECT COUNT(T1.AuthorId) FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T2.Title = 'Equation Solving in Geometrical Theories'	authors
SELECT T1.Name FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T2.Title = 'Area Effects in Cepaea'	authors
SELECT COUNT(T1.AuthorId) FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Affiliation = 'University of Tokyo' AND T2.Title = 'FIBER: A Generalized Framework for Auto-tuning Software'	authors
SELECT T2.Title FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Name = 'Klaus Zimmermann'	authors
SELECT T1.Name FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T2.Title = 'Incremental Extraction of Keyterms for Classifying Multilingual Documents in the Web' AND T1.Affiliation = 'National Taiwan University Department of Computer Science and Information Engineering Taiwan'	authors
SELECT T2.Title FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Name = 'Thomas Wiegand' AND T2.Year = 1995	authors
SELECT COUNT(T2.Title) FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Name = 'Thomas Wiegand' AND T2.Year = 1995	authors
SELECT CAST(COUNT(T2.Id) AS REAL) / COUNT(DISTINCT T2.Year) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Molecular Brain' AND T2.Year BETWEEN 2008 AND 2011	authors
SELECT SUM(CASE WHEN T1.FullName = 'Cases Journal' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.FullName = 'Molecular Brain' THEN 1 ELSE 0 END) AS DIFF FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId	authors
SELECT COUNT(Id) FROM Journal WHERE FullName LIKE '%computing%'	authors
SELECT PaperId, AuthorId FROM PaperAuthor WHERE Affiliation LIKE 'Cairo Microsoft Innovation Lab%'	authors
SELECT ShortName, FullName FROM Conference WHERE HomePage = 'http://www.informatik.uni-trier.de/~ley/db/conf/ices/index.html'	authors
SELECT AuthorId FROM PaperAuthor WHERE Name = 'Peter'	authors
SELECT DISTINCT T1.Title, T2.ShortName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.ConferenceId BETWEEN 160 AND 170	authors
SELECT T1.Title, T2.HomePage FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id ORDER BY T1.Year DESC LIMIT 1	authors
SELECT T1.Title, T3.ShortName FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Conference AS T3 ON T1.ConferenceId = T3.Id WHERE T1.Year = 1999 AND T2.Name LIKE 'Philip%'	authors
SELECT COUNT(T2.ConferenceId), T1.HomePage FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T2.Year BETWEEN 1990 AND 2000 AND T2.ConferenceId = 187	authors
SELECT DISTINCT T2.Title FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Affiliation = 'Department of Network Science, Graduate School of Information Systems, The University of Electro-Communications' AND T2.Year = 2003	authors
SELECT T2.Name, T3.ShortName FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T1.JournalId BETWEEN 245 AND 250 AND T1.Title LIKE '%chemiluminescence%'	authors
SELECT DISTINCT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.ConferenceId = 0 AND T1.JournalId < 100	authors
SELECT DISTINCT T1.Title, T2.AuthorId FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Year = 2006 AND T1.ConferenceId < 100	authors
SELECT T1.Id FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.HomePage LIKE 'http://www.informatik.uni-trier.de/~ley/db/conf/%'	authors
SELECT T3.HomePage, T2.AuthorId FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T1.Year BETWEEN 2000 AND 2005 AND T1.Title LIKE '%SOCIAL%'	authors
SELECT DISTINCT T2.AuthorId, T2.Affiliation FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.JournalId = 0 AND T1.Year = 2009 AND T2.Affiliation IS NOT NULL	authors
SELECT CAST(SUM(CASE WHEN T1.ConferenceId = 0 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.ConferenceId) FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.JournalId BETWEEN 200 AND 300 AND T2.ShortName LIKE 'A%'	authors
SELECT CAST(SUM(CASE WHEN Year = 2001 THEN 1 ELSE 0 END) AS REAL) / COUNT(Id) FROM Paper WHERE Year >= 2001 AND Year < 2011	authors
SELECT FullName, Homepage FROM Conference WHERE ShortName = 'ICWE'	authors
SELECT Affiliation FROM Author WHERE Affiliation IN ('Stanford University', 'Massachusetts Institute of Technology') GROUP BY Affiliation ORDER BY COUNT(Id) DESC LIMIT 1	authors
SELECT CAST(SUM(CASE WHEN Affiliation IS NULL THEN 1 ELSE 0 END) AS REAL) / COUNT(*) FROM Author	authors
SELECT Name, id FROM Author WHERE Affiliation = 'University of Oulu'	authors
SELECT T1.Title, T2.Affiliation FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Roger J. Marshall' AND T1.ConferenceID = 0 AND T1.JournalID = 0	authors
SELECT T1.Id, T1.Title, T1.Year, T3.FullName FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id GROUP BY T2.AuthorId ORDER BY COUNT(T2.AuthorId) DESC LIMIT 1	authors
SELECT DISTINCT T1.Title, T1.Year, T3.ShortName, T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Conference AS T3 ON T1.ConferenceId = T3.Id WHERE T1.Id = 15	authors
SELECT T2.Id, T2.Year, T2.Keyword FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.AuthorId < 1000 AND T1.Affiliation = 'Zurich, ETH'	authors
SELECT T2.Name, T1.Id FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Inspection resistant memory: Architectural support for security FROM physical examination' AND T2.Affiliation = 'Microsoft Research, USA'	authors
SELECT T2.Name, T2.Affiliation, T3.ShortName, T3.FullName FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T1.Title = 'Decreased Saliva Secretion and Down-Regulation of AQP5 in Submandibular Gland in Irradiated Rats'	authors
SELECT DISTINCT T2.Title, T2.JournalId FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T1.FullName = 'International Symposium of Robotics Research' AND T2.Year = 2003	authors
SELECT T2.Title, T2.Year, T2.Keyword FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.AuthorId = 661002 AND T1.Affiliation = 'Scientific Computing and Imaging Institute, University of Utah, UT 84112, USA'	authors
SELECT SUM(CASE WHEN T2.Year = 2000 THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.Year = 2010 THEN 1 ELSE 0 END) AS DIFF FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.ShortName = 'IWC'	authors
SELECT DISTINCT T2.JournalId, T1.ShortName, T1.FullName FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T2.Year = 2013 AND T2.JournalId != 0 AND T2.JournalId != -1 LIMIT 4	authors
SELECT T2.title, T3.name, T1.FullName FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.id = T2.ConferenceId INNER JOIN PaperAuthor AS T3 ON T1.id = T3.PaperId WHERE T1.ShortName = 'MICRO' AND T2.Year BETWEEN '1971' AND '1980'	authors
SELECT COUNT(Id) FROM Paper WHERE Year = 0	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'The Dissimilarity Representation as a Tool for Three-Way Data Classification: A 2D Measure'	authors
SELECT T2.HomePage FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'Energy-efficiency bounds for noise-tolerant dynamic circuits'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Id > 100 AND T1.Id < 106	authors
SELECT T2.PaperId, T4.ShortName FROM Author AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.AuthorId INNER JOIN Paper AS T3 ON T2.PaperId = T3.Id INNER JOIN Conference AS T4 ON T3.ConferenceId = T4.Id WHERE T3.Year = 2009 LIMIT 10	authors
SELECT T2.HomePage FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Title = '364: Induction of Mixed Chimerism and Transplantation Tolerance in a Non-Human Primate Lung Allograft Model: Early Results'	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.FullName = 'International Conference on Internet Computing' AND T1.Title <> ''	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Year = 2005 AND T1.Keyword = 'KEY WORDS: LOAD IDE SNP haplotype asso- ciation studies'	authors
SELECT COUNT(DISTINCT T2.Name) FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = '145 GROWTH HORMONE RECEPTORS AND THE ONSET OF HYPERINSULINEMIA IN THE OBESE ZUCKER RAT: '	authors
SELECT T2.AuthorId, T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Jei Keon Chae'	authors
SELECT T1.ConferenceId, T1.JournalId, T2.Name, T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Conference AS T3 ON T1.ConferenceId = T3.Id INNER JOIN Journal AS T4 ON T1.JournalId = T4.Id WHERE T2.Name = 'Shueh-Lin Yau'	authors
SELECT COUNT(id) FROM Paper WHERE Year BETWEEN '1990' AND '2000' AND ConferenceId = 0 AND JournalId = 0	authors
SELECT Name FROM Author WHERE Affiliation = 'Birkbeck University of London'	authors
SELECT ShortName FROM Conference WHERE FullName LIKE 'International Symposium%'	authors
SELECT COUNT(HomePage) FROM Journal WHERE HomePage = ''	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Year = 0	authors
SELECT T2.Affiliation FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Keyword = 'Quantum Physics'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.ConferenceId != 0 AND T1.JournalId = 0 AND T1.Year != 0	authors
SELECT T2.Title FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T1.HomePage = '' AND T2.Title <> ''	authors
SELECT DISTINCT T2.Year, FullName FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.ShortName = ''	authors
SELECT T1.Affiliation FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T2.Title = 'A combined search for the standard model Higgs boson at s = 1.96 Â TeV'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Year = 2001 AND T1.ConferenceId > 0 AND T1.JournalId > 0	authors
SELECT T1.Name FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T2.Title = 'Particle identification using the time-over-threshold method in the ATLAS Transition Radiation Tracker'	authors
SELECT COUNT(T1.Id) AS PAPER, COUNT(DISTINCT T1.Year) AS YEARS FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE year != 0 AND T2.FullName = 'International Conference on Database Theory'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Keyword = 'Sustainability'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Conference AS T3 ON T1.ConferenceId = T3.Id WHERE T3.FullName LIKE '%Workshop%'	authors
SELECT CAST((SUM(CASE WHEN T1.Affiliation LIKE '%INFN%' THEN 1 ELSE 0 END)) AS REAL) * 100 / COUNT(T2.Id) FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T2.Title LIKE '%Charged particle multiplicity%'	authors
SELECT CAST((SUM(CASE WHEN T1.ShortName LIKE 'ANN%' THEN 1 ELSE 0 END)) AS REAL) * 100 / COUNT(T1.ShortName) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T2.Year = 1989	authors
SELECT COUNT(PaperId) FROM PaperAuthor WHERE Affiliation LIKE '%Microsoft Research%'	authors
SELECT Keyword, Year FROM Paper WHERE Title = 'A Formal Approach to Service Component Architecture'	authors
SELECT CAST(SUM(CASE WHEN Year > 2000 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(Id) FROM Paper	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Hypermethylation of the <I>TPEF/HPP1</I> Gene in Primary and Metastatic Colorectal Cancers'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Title = 'Multiple paternity in a natural population of a salamander with long-term sperm storage'	authors
SELECT COUNT(T1.JournalId) FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T2.FullName = 'Iet Software/iee Proceedings - Software'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Id = 5	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name LIKE 'Jun du%' LIMIT 2	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Cheng Huang' AND T2.Affiliation = 'Microsoft'	authors
SELECT DISTINCT T3.FullName FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Conference AS T3 ON T1.ConferenceId = T3.Id WHERE T2.Name = 'Jean-luc Hainaut' LIMIT 1	authors
SELECT T3.FullName FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T2.Name = 'Andrew Cain'	authors
SELECT DISTINCT T2.Affiliation FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'FIBER: A Generalized Framework for Auto-tuning Software'	authors
SELECT T1.Title, T2.FullName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Year < 1 LIMIT 2	authors
SELECT T2.ShortName, T2.FullName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Keyword LIKE '%Materials%'	authors
SELECT Name FROM Author WHERE Affiliation = 'University of Oxford' ORDER BY Name ASC	authors
SELECT ShortName, HomePage FROM Conference WHERE FullName LIKE 'International Conference on Artificial Intelligence%'	authors
SELECT Title FROM Paper WHERE year = 1996	authors
SELECT T1.Title, T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T3.FullName = 'Neoplasia' AND T1.Year = 2007	authors
SELECT T2.Title, T1.Name FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Affiliation = 'Soongsil University' AND T2.Year = 2000	authors
SELECT T1.Title, T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Keyword LIKE '%optical properties%' AND T1.Year BETWEEN 2000 AND 2005 AND T1.Title <> ''	authors
SELECT CAST(SUM(CASE WHEN T2.FullName = 'International Congress Series' THEN 1 ELSE 0 END) AS REAL) / COUNT(T1.Id) AS Div1, T1.Year FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id GROUP BY T1.YEAR HAVING Div1 != 0	authors
SELECT DISTINCT T2.Name, T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.ConferenceId = 0 AND T1.JournalId = 0 AND T1.Year = 1997 AND T1.Title <> ''	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T2.Name = 'Adam Jones' AND T1.Year BETWEEN 2005 AND 2010	authors
SELECT COUNT(Name) FROM Author WHERE Affiliation = 'Otterbein University'	authors
SELECT COUNT(DISTINCT T2.Name) FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Subcellular localization of nuclease in barley aleurone'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'Extended Fuzzy Regression Models'	authors
SELECT COUNT(T1.Id) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.FullName = 'Mathematics of Program Construction'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Open Sourcing Social Solutions (Building Communities of Change)'	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Jianli Hua'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Testing timed automata'	authors
SELECT COUNT(T1.Id) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Year = 2000 AND T2.ShortName = 'SSPR'	authors
SELECT DISTINCT T1.Title FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T2.FullName = 'Theoretical Computer Science' AND T1.Year = 2003 AND T1.Title <> ''	authors
SELECT T2.HomePage FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'Quality evaluation of long duration audiovisual content'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Affiliation = 'Asan Medical Center, University of Ulsan College of Medicine, Seoul, Korea' AND T1.Title = 'A Randomized Comparison of Sirolimus- Versus Paclitaxel-Eluting Stent Implantation in Patients With Diabetes Mellitus'	authors
SELECT COUNT(T1.Id) FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T2.FullName = 'Software - Practice and Experience'	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.HomePage = 'http://www.irma-international.org/'	authors
SELECT CAST(COUNT(T1.Id) AS REAL) / COUNT(DISTINCT T1.Year) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.FullName = 'Information and Knowledge Engineering' AND T1.Year >= 2002 AND T1.Year <= 2010	authors
SELECT SUM(CASE WHEN T2.FullName = 'Informatik & Schule' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.FullName = 'International Conference on Supercomputing' THEN 1 ELSE 0 END) AS DIFF FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Year > 1990 AND T1.Year < 2001	authors
SELECT ShortName FROM Journal WHERE FullName = 'Software - Concepts and Tools / Structured Programming'	authors
SELECT T1.FullName FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T2.Title = 'Education, democracy and growth'	authors
SELECT COUNT(T2.Id) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'IEEE Transactions on Nuclear Science' AND T2.Year = 1999	authors
SELECT T2.Title FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'IEEE Transactions on Pattern Analysis and Machine Intelligence' AND T2.Year = 2011 AND T2.Title <> ''	authors
SELECT T2.Keyword FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Modeling Identification and Control' AND T2.Year = 1994	authors
SELECT CASE WHEN T1.Year = 0 THEN 'TRUE' ELSE 'FALSE' END FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Zvezdan Protić' AND T1.ConferenceId = 0 AND T1.JournalId = 0	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'Skew-Circulant Preconditioners for Systems of LMF-Based ODE Codes'	authors
SELECT COUNT(T1.Id) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.FullName = 'International Symposium on Software Testing and Analysis'	authors
SELECT DISTINCT T2.HomePage FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'Increasing the Concurrency in Estelle'	authors
SELECT COUNT(T2.AuthorId) FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'An Improved Active Suspension Model for Attitude Control of Electric Vehicles'	authors
SELECT T2.ShortName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Year = '2012' GROUP BY T1.ConferenceId ORDER BY COUNT(T1.Id) DESC LIMIT 1	authors
SELECT COUNT(T1.Id) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.ShortName = 'ECSQARU' AND T1.Year = '2003'	authors
SELECT T1.Keyword FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.FullName = 'International Radar Symposium' AND T1.Year = 2012	authors
SELECT CAST(SUM(CASE WHEN T2.FullName = 'International Conference on Thermoelectrics' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.FullName = 'International Conference on Wireless Networks, Communications and Mobile Computing' THEN 1 ELSE 0 END) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id	authors
SELECT CAST(SUM(CASE WHEN T1.ConferenceId = 0 AND T1.JournalId = 0 THEN 1 ELSE 0 END) AS REAL) / COUNT(T1.Id) FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'John Van Reenen'	authors
SELECT Title FROM Paper WHERE Year > 0 ORDER BY Year ASC LIMIT 1	authors
SELECT FullName FROM Conference ORDER BY LENGTH(FullName) DESC LIMIT 1	authors
SELECT COUNT(Name) FROM Author WHERE Affiliation = 'NASA Langley Research Center'	authors
SELECT COUNT(ShortName) FROM Journal WHERE ShortName = ''	authors
SELECT COUNT(Id) FROM Paper WHERE ConferenceId = 0 AND JournalId = 0	authors
SELECT T2.Title FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id GROUP BY T1.PaperId ORDER BY COUNT(T1.PaperId) DESC LIMIT 1	authors
SELECT T2.Title FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.ShortName = 'TUBERCLE LUNG DIS' ORDER BY T2.Year ASC LIMIT 1	authors
SELECT T2.Title FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Name = 'Karin Rengefors'	authors
SELECT COUNT(T2.Id) FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T1.FullName = 'Virtual Reality, IEEE Annual International Symposium' AND T2.Year = 2012	authors
SELECT T2.ShortName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Title = 'A Case of Unilateral Ashy Dermatosis'	authors
SELECT T1.Affiliation FROM PaperAuthor AS T1 INNER JOIN Author AS T2 ON T1.AuthorId = T2.Id WHERE T2.Name = 'Mark A. Musen'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Determination of Planetary Meteorology FROM Aerobot Flight Sensors'	authors
SELECT T1.Title, T1.JournalId FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Year >= 1960 AND T1.Year <= 1970	authors
SELECT T2.Year FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T1.FullName = 'Internet, Multimedia Systems and Applications' GROUP BY T2.Year ORDER BY COUNT(T2.Id) DESC LIMIT 1	authors
SELECT DISTINCT T1.Name FROM PaperAuthor AS T1 INNER JOIN Author AS T2 ON T1.AuthorId = T2.Id WHERE T2.Name = 'Randall Davis' AND T1.Name != 'Randall Davis'	authors
SELECT DISTINCT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Year = 2008	authors
SELECT T2.HomePage FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id GROUP BY T1.JournalId ORDER BY COUNT(T1.JournalId) DESC LIMIT 1	authors
SELECT CAST(SUM(CASE WHEN T1.Keyword = 'cancer' THEN 1 ELSE 0 END) AS REAL) / COUNT(T1.Id), T2.Name, T2.Affiliation FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId	authors
SELECT Name FROM Author WHERE Id = 1722	authors
SELECT COUNT(Id) FROM Paper WHERE Year = 0 OR (ConferenceId = 0 AND JournalId = 0)	authors
SELECT Name FROM Author WHERE Affiliation = 'University of Illinois Chicago'	authors
SELECT SUM(CASE WHEN Year = 2005 THEN 1 ELSE 0 END) , SUM(CASE WHEN year = 2005 THEN 1 ELSE 0 END) - SUM(CASE WHEN year = 2004 THEN 1 ELSE 0 END) AS diff FROM Paper	authors
SELECT T2.Title FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Ibm Journal of Research and Development'	authors
SELECT T2.Name, T2.Affiliation FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Education, democracy and growth'	authors
SELECT COUNT(T2.Name) FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId INNER JOIN Journal AS T3 ON T1.JournalId = T3.Id WHERE T3.FullName = 'IEEE Computer'	authors
SELECT T2.FullName FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T1.Title = 'A context-based navigation paradigm for accessing Web data'	authors
SELECT COUNT(T1.Id) FROM Paper AS T1 INNER JOIN Conference AS T2 ON T1.ConferenceId = T2.Id WHERE T2.FullName = 'International Workshop on Inductive Logic Programming' AND T1.Year BETWEEN 2001 AND 2009	authors
SELECT CAST(COUNT(DISTINCT T2.AuthorId) AS REAL) / COUNT(DISTINCT T1.Title) FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Year BETWEEN 1990 AND 2000	authors
SELECT T1.Year, T2.FullName FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id WHERE T1.Title = 'Area Effects in Cepaea'	authors
SELECT T2.Name FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T1.Title = 'Real-Time Automata'	authors
SELECT Name FROM Author WHERE Affiliation = 'ABB Electrical Machines'	authors
SELECT COUNT(T2.JournalId) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Academic Medicine' AND T2.Year BETWEEN 2005 AND 2010	authors
SELECT T2.Title FROM PaperAuthor AS T1 INNER JOIN Paper AS T2 ON T1.PaperId = T2.Id WHERE T1.Name = 'Zuliang Du' ORDER BY T2.Year DESC LIMIT 1	authors
SELECT COUNT(T2.ConferenceId) FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T1.FullName = 'Adaptive Multimedia Retrieval' AND T2.Year = 2007	authors
SELECT CAST(COUNT(T2.JournalId) AS REAL) / COUNT(DISTINCT T2.Year) FROM Journal AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.JournalId WHERE T1.FullName = 'Information Sciences'	authors
SELECT COUNT(PaperId) FROM PaperAuthor WHERE Name = 'Howard F. Lipson'	authors
SELECT CAST(SUM(CASE WHEN T1.Keyword = 'Turbulent Fluids' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.FullName = 'Physics of Fluids' THEN 1 ELSE 0 END) FROM Paper AS T1 INNER JOIN Journal AS T2 ON T1.JournalId = T2.Id	authors
SELECT COUNT(Name) FROM Author WHERE Affiliation = 'Arizona State University'	authors
SELECT FullName, HomePage FROM Conference WHERE ShortName = 'ICCI'	authors
SELECT T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Joe Lograsso'	authors
SELECT COUNT(T2.PaperId) FROM Author AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.AuthorId WHERE T1.Affiliation = 'University of Hong Kong'	authors
SELECT T1.Year, T1.Title FROM Paper AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.PaperId WHERE T2.Name = 'Barrasa'	authors
SELECT T1.Name, T3.Year FROM Author AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.AuthorId INNER JOIN Paper AS T3 ON T2.PaperId = T3.Id WHERE T2.PaperId = 2	authors
SELECT T1.Name, T3.Keyword FROM Author AS T1 INNER JOIN PaperAuthor AS T2 ON T1.Id = T2.AuthorId INNER JOIN Paper AS T3 ON T2.PaperId = T3.Id WHERE T2.PaperId = 5	authors
SELECT T1.FullName FROM Conference AS T1 INNER JOIN Paper AS T2 ON T1.Id = T2.ConferenceId WHERE T2.Title = '2004 YD5'	authors
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year = 2007 AND T2.race = 'Ai' GROUP BY T1.chronname ORDER BY COUNT(T1.chronname) DESC LIMIT 1	college_completion
SELECT T1.chronname, T1.site FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year = 2011 AND T2.grad_cohort = 209	college_completion
SELECT COUNT(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year BETWEEN 2011 AND 2013 AND T1.chronname = 'Gateway Community College' AND T2.gender = 'F'	college_completion
SELECT COUNT(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year = 2012 AND T2.gender = 'M' ORDER BY T1.aid_value DESC LIMIT 1	college_completion
SELECT AVG(T1.med_sat_value) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year = 2013 AND T2.gender = 'M' GROUP BY T2.grad_cohort ORDER BY COUNT(T2.grad_cohort) DESC LIMIT 1	college_completion
SELECT T1.state, T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year = 2012 AND T1.control = 'Private for-profit' GROUP BY T2.grad_cohort ORDER BY COUNT(T2.grad_cohort) DESC LIMIT 1	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T1.state = T2.state WHERE T2.year = 2013 AND T1.control = 'Public' ORDER BY T2.grad_cohort LIMIT 1	college_completion
SELECT T1.chronname, T2.grad_cohort FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T2.year = 2013 AND T2.gender = 'B' AND T2.race = 'X' AND T2.grad_cohort < 200	college_completion
SELECT COUNT(*) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T2.year = 2013 AND T2.gender = 'F' AND T2.race = 'X' AND T1.chronname = 'Oakwood University'	college_completion
SELECT COUNT(*) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T2.gender = 'F' AND T2.race = 'A' AND T1.chronname = 'University of Alaska at Anchorage' AND T2.cohort = '4y other'	college_completion
SELECT SUM(CASE WHEN T2.year = 2011 THEN T2.grad_cohort ELSE 0 END), SUM(CASE WHEN T2.year = 2012 THEN T2.grad_cohort ELSE 0 END), SUM(CASE WHEN T2.year = 2013 THEN T2.grad_cohort ELSE 0 END) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T2.gender = 'B' AND T2.race = 'X' AND T1.chronname = 'Auburn University'	college_completion
SELECT CAST(SUM(CASE WHEN T2.race = 'B' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T2.race = 'B' AND T1.control = 'Private for-profit'	college_completion
SELECT CAST(SUM(CASE WHEN T2.race = 'A' THEN 1 ELSE 0 END) AS REAL) * 100 / SUM(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T2.year = 2013 AND T1.state = 'Alabama'	college_completion
SELECT CAST(SUM(CASE WHEN T2.Gender = 'M' THEN T2.grad_cohort ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.Gender = 'F' THEN T2.grad_cohort ELSE 0 END) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T1.chronname = 'Harvard University' AND T2.year = 2013 AND T2.race = 'A'	college_completion
SELECT chronname FROM institution_details WHERE chronname IN ('Amridge University', 'Auburn University') ORDER BY grad_100_value LIMIT 1	college_completion
SELECT COUNT(*) FROM institution_details WHERE control = 'Private not-for-profit'	college_completion
SELECT SUM(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T1.chronname = 'Amridge University' AND T2.gender = 'M' AND T2.race = 'H'	college_completion
SELECT COUNT(T1.unitid) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T1.chronname = 'Lincoln College' AND T2.year = 2011 AND T2.cohort = '4y bach'	college_completion
SELECT SUM(T2.grad_100) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T1.chronname = 'Central Alabama Community College' AND T2.year = 2011 AND T2.gender = 'M' AND T2.race = 'H'	college_completion
SELECT T2.grad_cohort FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T1.unitid = T2.unitid WHERE T1.chronname = 'Central Alabama Community College' AND T2.year = 2011	college_completion
SELECT IIF(SUM(CASE WHEN T2.gender = 'F' THEN T2.grad_150 ELSE 0 END) > SUM(CASE WHEN T2.gender = 'M' THEN T2.grad_150 ELSE 0 END), 'female White students', 'male White students') FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Central Alabama Community College' AND T2.year = 2011 AND T2.race = 'W'	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.year = 2011 AND T2.gender = 'M' AND T2.race = 'W' AND T2.grad_150 = ( SELECT MAX(T2.grad_150) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.year = 2011 AND T2.gender = 'M' AND T2.race = 'W' )	college_completion
SELECT T FROM ( SELECT DISTINCT CASE WHEN T2.grad_150 > 20 THEN T1.chronname ELSE NULL END AS T FROM institution_details T1 INNER JOIN institution_grads T2 ON T2.unitid = T1.unitid WHERE T2.year = 2011 AND T2.gender = 'M' AND T2.race = 'W' ) WHERE T IS NOT NULL	college_completion
SELECT SUM(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE  T2.cohort = '2y all' AND T2.year = 2011 AND T1.state = 'Alabama'	college_completion
SELECT SUM(CASE WHEN T2.year = 2012 THEN T2.grad_cohort ELSE 0 END) - SUM(CASE WHEN T2.year = 2011 THEN T2.grad_cohort ELSE 0 END) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Central Alabama Community College'	college_completion
SELECT COUNT(DISTINCT T1.chronname) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.state = 'Alabama' AND T1.med_sat_percentile = '100' AND T2.year = 2011 AND T2.grad_cohort > 500	college_completion
SELECT COUNT(T1.chronname) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.state = 'Alabama' AND T1.control = 'Public' AND T2.year = 2011 AND T2.grad_100 > 30	college_completion
SELECT DISTINCT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.state = 'Alabama' AND T2.year = 2011 AND T2.race = 'X' AND T2.grad_cohort > 500	college_completion
SELECT AVG(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Central Alabama Community College' AND T2.year IN (2011, 2012, 2013) AND T2.gender = 'B' AND T2.race = 'X'	college_completion
SELECT AVG(T2.grad_100_rate) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Central Alabama Community College'	college_completion
SELECT T FROM ( SELECT DISTINCT CASE WHEN chronname = 'Swarthmore College' THEN site ELSE NULL END AS T FROM institution_details ) WHERE T IS NOT NULL	college_completion
SELECT T FROM ( SELECT DISTINCT CASE WHEN chronname = 'Mercer University' THEN state ELSE NULL END AS T FROM institution_details ) WHERE T IS NOT NULL	college_completion
SELECT T FROM ( SELECT DISTINCT CASE WHEN chronname = 'Rensselaer Polytechnic Institute' THEN city ELSE NULL END AS T FROM institution_details ) WHERE T IS NOT NULL	college_completion
SELECT T FROM ( SELECT DISTINCT CASE WHEN state = 'Delaware' THEN state_abbr ELSE NULL END AS T FROM state_sector_grads ) WHERE T IS NOT NULL	college_completion
SELECT COUNT(stateid) FROM state_sector_details WHERE state = 'California' AND level = '2-year' AND control = 'Public'	college_completion
SELECT T FROM ( SELECT DISTINCT CASE WHEN state = 'Idaho' THEN state_post ELSE NULL END AS T FROM state_sector_details ) WHERE T IS NOT NULL	college_completion
SELECT DISTINCT T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'NJ' AND T1.level = '4-year' AND T1.student_count = ( SELECT MAX(T1.student_count) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'NJ' AND T1.level = '4-year' )	college_completion
SELECT DISTINCT T1.site FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'PA' AND T1.lat_y = ( SELECT MAX(T1.lat_y) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'PA' )	college_completion
SELECT COUNT(DISTINCT T1.chronname) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'UT' AND T1.level = '4-year' AND T1.control = 'Public' AND T1.awards_per_value > T1.awards_per_state_value	college_completion
SELECT COUNT(DISTINCT T1.chronname) FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'CT' AND T2.level = '2-year' AND T1.control = 'Private not-for-profit' AND T1.awards_per_value < T1.awards_per_natl_value	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'ID' AND T1.level = '4-year' AND T1.control = 'Public' GROUP BY T1.chronname ORDER BY SUM(T1.grad_100_value) ASC LIMIT 1	college_completion
SELECT T1.chronname, T1.unitid FROM institution_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.state = T1.state WHERE T2.state_abbr = 'KY' AND T1.level = '4-year' AND T1.control = 'Private for-profit' GROUP BY T1.chronname ORDER BY SUM(T1.grad_150_value) DESC LIMIT 1	college_completion
SELECT SUM(T2.grad_100) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Pennsylvania State University-Altoona' AND T2.gender = 'F' AND T2.race = 'H'	college_completion
SELECT DISTINCT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.cohort_size = ( SELECT MAX(T1.cohort_size) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid )	college_completion
SELECT COUNT(T1.chronname) FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state WHERE T2.level = '4-year' AND T2.control = 'Private not-for-profit' AND T1.chronname = 'Brevard Community College'	college_completion
SELECT SUM(T2.grad_cohort) FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T1.state = 'Alabama' AND T2.year = 2011 AND T1.level = '2-year' AND T1.control = 'Public' AND T2.race = 'X'	college_completion
SELECT COUNT(T2.grad_cohort) FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T2.level = '2-year' AND T2.control = 'Public' AND T2.gender = 'B' AND T2.race = 'A' AND T2.cohort = '2y all' AND T1.schools_count = 113	college_completion
SELECT CAST(COUNT(DISTINCT CASE WHEN T1.state = ( SELECT T1.state FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state WHERE T1.chronname = 'Madison Area Technical College' ) AND T1.level = '4-year' AND T1.control = 'Public' THEN T1.chronname ELSE NULL END) AS REAL) * 100 / COUNT(DISTINCT CASE WHEN T2.state = 'Alabama' THEN T1.chronname ELSE NULL END) FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state	college_completion
SELECT DISTINCT T1.state, T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.race = 'B' AND T2.year BETWEEN 2010 AND 2012	college_completion
SELECT DISTINCT T1.state FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T2.year = 2011 AND T1.awards_per_natl_value <= 20	college_completion
SELECT DISTINCT T1.control, T1.level FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.race = 'X' AND T1.student_count = ( SELECT MAX(T1.student_count) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.race = 'X' )	college_completion
SELECT DISTINCT T2.race FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T1.schools_count <= 20 AND T1.control = 'Public'	college_completion
SELECT DISTINCT T1.basic, T2.race FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.year = 2012 AND T2.gender = 'M' AND t2.race = 'X'	college_completion
SELECT COUNT(T2.race) FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T1.schools_count = 1 AND T2.year BETWEEN 2011 AND 2013 AND T2.race = 'W' AND T1.state = 'Alaska'	college_completion
SELECT DISTINCT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.grad_cohort BETWEEN 1 AND 3 AND T2.race = 'Ai'	college_completion
SELECT SUM(T2.grad_cohort) FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T2.state LIKE 'A%' AND T1.awards_per_natl_value = 16.5 AND T2.year = 2012	college_completion
SELECT DISTINCT T1.site FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.student_count BETWEEN 500 AND 1000 AND T2.year = ( SELECT MAX(T2.year) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid )	college_completion
SELECT DISTINCT T1.state FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T2.gender = 'M' AND T2.race = 'B' AND T1.control = 'Private for-profit' AND T2.year = 2011	college_completion
SELECT DISTINCT T1.site, T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.year = 2011 AND T2.race = 'B' AND T2.grad_cohort BETWEEN 20 AND 30	college_completion
SELECT COUNT(T2.race) FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T2.gender = 'F' AND schools_count BETWEEN 10 AND 20 AND T2.year = 2012	college_completion
SELECT DISTINCT T2.race FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.student_count > ( SELECT AVG(T1.student_count) * 0.9 FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.state = 'Alabama' ) AND T1.state = 'Alabama'	college_completion
SELECT CAST(SUM(CASE WHEN T2.level = '2-year' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.level) FROM state_sector_details AS T1 INNER JOIN state_sector_grads AS T2 ON T2.stateid = T1.stateid WHERE T2.state = 'Hawaii' AND T2.year = 2010	college_completion
SELECT chronname FROM institution_details WHERE state = 'Connecticut' AND retain_percentile = ( SELECT MAX(retain_percentile) FROM institution_details WHERE state = 'Connecticut' )	college_completion
SELECT T1.site FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.race = 'W' AND T2.cohort = '2y all' AND T2.year = 2008 ORDER BY T2.grad_cohort DESC LIMIT 1	college_completion
SELECT T2.year FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Harvard University' GROUP BY T2.year ORDER BY SUM(T2.grad_cohort) DESC LIMIT 1	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state INNER JOIN institution_grads AS T3 ON T3.unitid = T1.unitid WHERE T1.student_count = ( SELECT MIN(T1.student_count) FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state INNER JOIN institution_grads AS T3 ON T3.unitid = T1.unitid WHERE T3.year = 2010 ) AND T3.year = 2010 GROUP BY T1.state ORDER BY SUM(T2.state_appr_value) DESC LIMIT 1	college_completion
SELECT AVG(T2.grad_cohort) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'Yale University' AND T2.year BETWEEN 2002 AND 2005 AND T2.race = 'B' AND T2.cohort = '4y bach'	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname IN ( 'Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University' ) AND T2.race = 'H' GROUP BY T1.chronname ORDER BY SUM(T2.grad_cohort) DESC LIMIT 1	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 WHERE T2.level = '4-year' AND T2.control = 'Public' AND T2.state = 'Florida'	college_completion
SELECT T1.state FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state WHERE T1.chronname IN ( 'Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University' ) GROUP BY T1.state ORDER BY SUM(T2.state_appr_value) ASC LIMIT 1	college_completion
SELECT COUNT(t1.unitid), t1.chronname FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON t1.state = t2.state WHERE t1.ft_pct > 90 ORDER BY t2.schools_count DESC LIMIT 1	college_completion
SELECT AVG(t1.med_sat_value) FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON t1.state = t2.state ORDER BY t2.state_appr_value LIMIT 1	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T2.gender = 'F' AND T2.cohort = '4y other' ORDER BY T2.grad_cohort DESC LIMIT 1	college_completion
SELECT T1.chronname FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname IN ( 'Brown University', 'Columbia University', 'Cornell University', 'Dartmouth College', 'Harvard University', 'Princeton University', 'University of Pennsylvania', 'Yale University' ) AND T2.year = 2013 AND T2.race = 'B' AND T2.cohort = '4y bach' ORDER BY T2.grad_cohort DESC LIMIT 1	college_completion
SELECT AVG(T2.grad_150) FROM institution_details AS T1 INNER JOIN institution_grads AS T2 ON T2.unitid = T1.unitid WHERE T1.chronname = 'United Education Institute-Huntington Park Campus' AND T2.year BETWEEN 2011 AND 2013 AND T2.gender = 'M' AND T2.race = 'H'	college_completion
SELECT T1.chronname, T2.state_appr_value FROM institution_details AS T1 INNER JOIN state_sector_details AS T2 ON T2.state = T1.state ORDER BY T1.awards_per_value - T2.awards_per_natl_value DESC LIMIT 1	college_completion
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND stars < 3	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND active LIKE 'False'	public_review_platform
SELECT COUNT(review_length) FROM Reviews WHERE user_id = 36139 AND review_length LIKE 'long'	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_fans LIKE 'Uber'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name LIKE 'Open 24 Hours' AND T2.attribute_value LIKE 'TRUE'	public_review_platform
SELECT T2.attribute_value FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.business_id = 10172 AND T1.attribute_name LIKE 'wi-fi'	public_review_platform
SELECT COUNT(T1.category_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id WHERE T1.category_name LIKE 'Bars'	public_review_platform
SELECT SUM(CASE WHEN T1.category_name LIKE 'Buffets' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.category_name LIKE 'Gyms' THEN 1 ELSE 0 END) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Reviews AS T4 ON T3.business_id = T4.business_id WHERE T4.review_stars = 5 GROUP BY T1.category_name ORDER BY COUNT(T1.category_name) DESC LIMIT 1	public_review_platform
SELECT T2.user_yelping_since_year FROM Reviews AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.review_stars = 5 GROUP BY T2.user_yelping_since_year ORDER BY COUNT(T1.review_stars) DESC LIMIT 1	public_review_platform
SELECT CAST(SUM(T1.review_stars) AS REAL) / COUNT(T1.review_stars) FROM Reviews AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.review_length LIKE 'Long' GROUP BY T1.user_id ORDER BY COUNT(T1.review_length) DESC LIMIT 1	public_review_platform
SELECT T4.category_name FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T1.review_length LIKE 'Long' GROUP BY T2.business_id ORDER BY COUNT(T1.review_length) DESC LIMIT 1	public_review_platform
SELECT DISTINCT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Tips AS T4 ON T3.business_id = T4.business_id WHERE T4.tip_length LIKE 'short'	public_review_platform
SELECT T2.user_yelping_since_year FROM Tips AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.tip_length LIKE 'short' GROUP BY T2.user_yelping_since_year ORDER BY COUNT(T1.tip_length) DESC LIMIT 1	public_review_platform
SELECT T4.category_name FROM Tips AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T1.user_id = 70271	public_review_platform
SELECT T2.stars FROM Tips AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T1.user_id = 69722	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.category_name LIKE 'Automotive' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.business_id) AS "percentage" FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.category_name LIKE 'Women''s Clothing' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.business_id) - CAST(SUM(CASE WHEN T2.category_name LIKE 'Men''s Clothing' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.business_id) AS "more percentage" FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year = 2004	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year = 2005 AND user_fans LIKE 'None'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Tolleson' AND active LIKE 'TRUE'	public_review_platform
SELECT COUNT(review_length) FROM Reviews WHERE user_id = 21679	public_review_platform
SELECT COUNT(review_length) FROM Reviews WHERE business_id = 10682 AND review_stars = 5	public_review_platform
SELECT T1.business_id FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city LIKE 'Sun City' AND T1.active LIKE 'FALSE' GROUP BY T1.business_id ORDER BY COUNT(T2.review_length) DESC LIMIT 1	public_review_platform
SELECT COUNT(T2.review_length) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city LIKE 'Yuma' AND T2.review_length LIKE 'Medium'	public_review_platform
SELECT DISTINCT CASE WHEN T1.attribute_name LIKE 'Has TV' THEN 'yes' ELSE 'no' END FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.business_id = 4960	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name LIKE 'Dogs Allowed' AND T2.attribute_value LIKE 'TRUE'	public_review_platform
SELECT T1.closing_time - T1.opening_time AS "hour" FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T2.day_of_week LIKE 'Saturday' AND T1.business_id = 5734	public_review_platform
SELECT COUNT(T1.category_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id WHERE T1.category_name LIKE 'Hair Removal'	public_review_platform
SELECT SUM(CASE WHEN T1.category_name LIKE 'Chinese' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.category_name LIKE 'Filipino' THEN 1 ELSE 0 END) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Tips AS T2 ON T1.business_id = T2.business_id WHERE T2.likes = 1 AND T2.user_id = 63469	public_review_platform
SELECT COUNT(T1.attribute_name) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_value LIKE 'TRUE' AND T2.business_id = 1141	public_review_platform
SELECT COUNT(T1.compliment_type) FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.compliment_type LIKE 'cute' AND T2.user_id = 57400	public_review_platform
SELECT user_id FROM Users_Compliments WHERE compliment_id IN ( SELECT compliment_id FROM Compliments WHERE compliment_type LIKE 'funny' )	public_review_platform
SELECT T2.business_id FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.business_id < 1000 AND T3.city LIKE 'Scottsdale' AND T1.attribute_name LIKE 'Drive-Thru' AND T2.attribute_value LIKE 'TRUE'	public_review_platform
SELECT CAST(SUM(T3.stars) AS REAL) / COUNT(T2.business_id) AS "avg" FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name LIKE 'Open 24 Hours' AND T2.attribute_value LIKE 'TRUE'	public_review_platform
SELECT CAST(SUM(CASE WHEN T3.city LIKE 'Phoenix' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.business_id) AS "percentage" FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name LIKE 'BYOB' AND T2.attribute_value LIKE 'TRUE'	public_review_platform
SELECT business_id FROM Business WHERE state LIKE 'AZ' AND stars = 5	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE review_count LIKE 'Low' AND active LIKE 'TRUE'	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_id BETWEEN 1 AND 20 AND user_fans LIKE 'None' AND user_review_count LIKE 'Low'	public_review_platform
SELECT T4.opening_time FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id WHERE T1.category_name LIKE 'Fashion'	public_review_platform
SELECT COUNT(T3.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id WHERE T4.opening_time < '8AM' AND T1.category_name LIKE 'Shopping'	public_review_platform
SELECT T3.business_id FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id WHERE T4.closing_time > '9PM' AND T1.category_name LIKE 'Pets'	public_review_platform
SELECT COUNT(T2.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id INNER JOIN Days AS T5 ON T4.day_id = T5.day_id WHERE T5.day_of_week LIKE 'Monday' OR T5.day_of_week LIKE 'Tuesday' OR T5.day_of_week LIKE 'Wednesday' OR T5.day_of_week LIKE 'Thursday'	public_review_platform
SELECT COUNT(*) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name = 'Active Life' AND T3.city = 'Phoenix'	public_review_platform
SELECT T2.business_id FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name LIKE 'Men''s Clothing' AND T3.stars < 5	public_review_platform
SELECT DISTINCT T1.business_id FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T2.active LIKE 'FALSE' AND T1.review_votes_useful LIKE 'Low'	public_review_platform
SELECT T4.category_name FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T1.review_length LIKE 'Long' AND T3.category_id BETWEEN 1 AND 20 GROUP BY T4.category_name	public_review_platform
SELECT T2.attribute_value FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T1.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T4.category_name LIKE 'Fashion' AND T1.city LIKE 'Scottsdale'	public_review_platform
SELECT COUNT(T1.number_of_compliments) FROM Users_Compliments AS T1 INNER JOIN Reviews AS T2 ON T1.user_id = T2.user_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.city LIKE 'Phoenix' AND T1.number_of_compliments LIKE 'Medium'	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id WHERE T3.city LIKE 'Tempe' AND T4.opening_time < '8AM'	public_review_platform
SELECT COUNT(T1.category_name) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id WHERE T3.city LIKE 'Glendale' AND T4.opening_time LIKE '8AM' AND T4.closing_time LIKE '6PM'	public_review_platform
SELECT SUM(CASE WHEN T3.city LIKE 'Phoenix' THEN 1 ELSE 0 END) AS "num" , CAST(SUM(CASE WHEN T3.city LIKE 'Phoenix' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.city) FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id	public_review_platform
SELECT SUM(CASE WHEN T2.category_name LIKE 'Active Life' THEN 1 ELSE 0 END) AS "num" , CAST(SUM(CASE WHEN T3.city LIKE 'Phoenix' THEN 1 ELSE 0 END) AS REAL) * 100 / ( SELECT COUNT(T3.review_count) FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T3.review_count LIKE 'Low' ) FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Phoenix' AND active LIKE 'TRUE'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Scottsdale' AND stars > 3	public_review_platform
SELECT CAST(SUM(stars) AS REAL) / COUNT(business_id) AS "average" FROM Business WHERE active LIKE 'FALSE'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id WHERE T2.attribute_value LIKE 'beer_and_wine' AND T1.state LIKE 'AZ'	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id WHERE T2.attribute_value LIKE 'full_bar' GROUP BY T1.city	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.stars = 5 AND T3.category_name LIKE 'Fashion'	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.review_count LIKE 'High' AND T3.category_name LIKE 'Food' GROUP BY T1.city	public_review_platform
SELECT T1.business_id FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city LIKE 'Mesa' AND T2.review_stars > 3 GROUP BY T1.business_id	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T2.review_votes_funny LIKE 'low' GROUP BY T1.city	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.stars = 5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.business_id) AS "percentage" FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.city LIKE 'Chandler' AND T3.category_name LIKE 'Real Estate'	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year = 2012 AND user_votes_funny LIKE 'High'	public_review_platform
SELECT review_votes_useful FROM Reviews WHERE user_id = 52592 AND business_id = 2	public_review_platform
SELECT attribute_id FROM Attributes WHERE attribute_name LIKE '%payment%'	public_review_platform
SELECT review_length FROM Reviews WHERE user_id = 612 AND review_stars = 5 AND business_id = 2	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Gilbert' AND active LIKE 'True'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND review_count LIKE 'Low'	public_review_platform
SELECT DISTINCT T2.business_id FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T2.state LIKE 'AZ' AND T1.review_stars = 5 LIMIT 3	public_review_platform
SELECT T1.attribute_name FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_value LIKE 'none' LIMIT 1	public_review_platform
SELECT COUNT(T2.compliment_type) FROM Users_Compliments AS T1 INNER JOIN Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.user_id = 33 AND T2.compliment_type LIKE 'cool'	public_review_platform
SELECT T1.closing_time - T1.opening_time AS "opening hours" FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T2.day_of_week LIKE 'Friday' AND T1.business_id = 53	public_review_platform
SELECT T1.attribute_name FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_value LIKE 'TRUE' AND T2.business_id = 56	public_review_platform
SELECT T2.category_name FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id WHERE T1.business_id = 15	public_review_platform
SELECT COUNT(T2.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.city LIKE 'Scottsdale' AND T1.category_name LIKE 'Beauty & Spas'	public_review_platform
SELECT T1.user_id FROM Users_Compliments AS T1 INNER JOIN Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.number_of_compliments LIKE 'Uber' AND T2.compliment_type LIKE 'cute' LIMIT 2	public_review_platform
SELECT COUNT(T2.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.stars > 3 AND T1.category_name LIKE 'Accessories'	public_review_platform
SELECT T2.closing_time - T2.opening_time AS "hour" FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T1.business_id = 12 AND T1.city LIKE 'Scottsdale' AND T2.day_id = 3	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Checkins AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.label_time_4 LIKE 'None' AND T1.state LIKE 'AZ' AND T3.day_of_week LIKE 'Thursday'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Scottsdale'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND active LIKE 'True'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Scottsdale' AND stars > 3	public_review_platform
SELECT city FROM Business ORDER BY review_count DESC LIMIT 1	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND stars > 4	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ'	public_review_platform
SELECT city FROM Business WHERE stars = 5 GROUP BY city	public_review_platform
SELECT COUNT(review_length) FROM Reviews WHERE user_id = 3	public_review_platform
SELECT COUNT(review_length) FROM Reviews WHERE user_id = 3 AND review_length LIKE 'Long'	public_review_platform
SELECT COUNT(review_length) FROM Reviews WHERE user_id = 3 AND review_length LIKE 'Long' AND review_votes_useful LIKE 'Medium'	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year = 2012	public_review_platform
SELECT user_id FROM Users WHERE user_fans LIKE 'High' GROUP BY user_id	public_review_platform
SELECT COUNT(T1.attribute_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name LIKE 'Alcohol' AND T2.attribute_value LIKE 'none'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name LIKE 'Alcohol' AND T2.attribute_value LIKE 'none' AND T3.state LIKE 'AZ'	public_review_platform
SELECT T2.business_id FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name LIKE 'Good for Kids' AND T2.attribute_value LIKE 'TRUE'	public_review_platform
SELECT COUNT(T1.category_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id WHERE T1.category_name LIKE 'Shopping'	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id WHERE T2.business_id = 1	public_review_platform
SELECT COUNT(T3.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Tips AS T4 ON T3.business_id = T4.business_id WHERE T1.category_name LIKE 'Food' AND T3.active LIKE 'TRUE'	public_review_platform
SELECT COUNT(T3.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name LIKE 'Food' AND T3.city LIKE 'Anthem'	public_review_platform
SELECT T2.business_id FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name LIKE 'Food' ORDER BY T3.stars DESC LIMIT 1	public_review_platform
SELECT COUNT(T3.stars) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Attributes AS T4 ON T3.business_id = T4.business_id INNER JOIN Attributes AS T5 ON T4.attribute_id = T5.attribute_id WHERE T1.category_name LIKE 'Food' AND T5.attribute_name LIKE 'Good for Kids' AND T4.attribute_value LIKE 'TRUE'	public_review_platform
SELECT COUNT(T2.business_id) FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T2.state LIKE 'AZ' AND T1.user_id = 3	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.state LIKE 'AZ' GROUP BY T1.category_name	public_review_platform
SELECT T1.closing_time - T1.opening_time AS "opening hours" FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T2.day_of_week LIKE 'Tuesday' AND T1.business_id = 1	public_review_platform
SELECT T1.opening_time FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T2.day_of_week LIKE 'Tuesday' AND T1.business_id = 1	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T2.day_of_week LIKE 'Monday' AND T1.closing_time > '8PM'	public_review_platform
SELECT T1.opening_time FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T2.day_of_week LIKE 'Monday' AND T3.city LIKE 'Anthem' AND T3.active LIKE 'True' GROUP BY T1.opening_time	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T2.day_of_week LIKE 'Sunday' AND T1.closing_time LIKE '12PM' AND T3.state LIKE 'AZ'	public_review_platform
SELECT T4.category_name FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business_Categories AS T3 ON T1.business_id = T3.business_id INNER JOIN Categories AS T4 ON T4.category_id = T4.category_id WHERE T1.closing_time = '12PM' AND T2.day_of_week = 'Sunday' GROUP BY T4.category_name	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business_Attributes AS T3 ON T1.business_id = T3.business_id INNER JOIN Attributes AS T4 ON T4.attribute_id = T4.attribute_id WHERE T2.day_id IN (1, 2, 3, 4, 5, 6, 7) AND T4.attribute_name = 'Good for Kids' AND T3.attribute_value = 'true'	public_review_platform
SELECT COUNT(T1.user_id) FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id WHERE T1.user_yelping_since_year = T2.year_id	public_review_platform
SELECT T1.closing_time + 12 - T1.opening_time AS "hour" FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id INNER JOIN Business_Categories AS T4 ON T3.business_id = T4.business_id INNER JOIN Categories AS T5 ON T4.category_id = T5.category_id WHERE T2.day_of_week LIKE 'Monday' AND T5.category_name LIKE 'Shopping' ORDER BY T1.closing_time + 12 - T1.opening_time DESC LIMIT 1	public_review_platform
SELECT T1.business_id FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T1.closing_time + 12 - T1.opening_time > 12 AND T2.day_of_week LIKE 'Sunday' GROUP BY T1.business_id	public_review_platform
SELECT COUNT(T1.user_id) FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id INNER JOIN Reviews AS T3 ON T1.user_id = T3.user_id WHERE T3.business_id = 1	public_review_platform
SELECT COUNT(T4.user_id) FROM ( SELECT T1.user_id FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id INNER JOIN Reviews AS T3 ON T1.user_id = T3.user_id WHERE T3.user_id IS NOT NULL GROUP BY T3.user_id HAVING COUNT(T3.user_id) > 10 ) T4	public_review_platform
SELECT T1.user_id FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T2.state LIKE 'AZ' GROUP BY T1.user_id ORDER BY COUNT(T1.user_id) DESC LIMIT 1	public_review_platform
SELECT AVG(T2.review_stars) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city LIKE 'Anthem'	public_review_platform
SELECT AVG(T2.review_stars) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.state LIKE 'AZ' AND T2.user_id = 3	public_review_platform
SELECT T1.closing_time + 12 - T1.opening_time AS "avg opening hours" FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T1.business_id = 1 AND (T2.day_of_week = 'Sunday' OR T2.day_of_week = 'Sunday')	public_review_platform
SELECT CAST(SUM(T3.stars) AS REAL) / COUNT(T1.business_id) AS "average stars" FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T2.day_of_week LIKE 'Sunday' AND T1.closing_time LIKE '12PM'	public_review_platform
SELECT COUNT(city) FROM Business WHERE city LIKE 'Casa Grande'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND active LIKE 'True' AND review_count LIKE 'low'	public_review_platform
SELECT business_id FROM Business WHERE city LIKE 'Mesa' AND stars BETWEEN 2 AND 3	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year BETWEEN 2011 AND 2013 AND user_fans LIKE 'High'	public_review_platform
SELECT review_length FROM Reviews WHERE user_id = 35026 AND business_id = 2	public_review_platform
SELECT DISTINCT T3.attribute_id, T3.attribute_name FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.attribute_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.review_count = 'Low' AND T1.city = 'Chandler'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.stars < 4 AND T3.category_name LIKE 'Mexican'	public_review_platform
SELECT T1.business_id, T1.stars FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.active LIKE 'TRUE' AND T3.category_name LIKE 'Fashion'	public_review_platform
SELECT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id ORDER BY T1.stars DESC LIMIT 1	public_review_platform
SELECT T4.category_name FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T1.review_length LIKE 'Medium' AND T2.business_id BETWEEN 6 AND 9 ORDER BY T1.review_stars DESC LIMIT 1	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T3.attribute_name LIKE 'Caters' AND T1.review_count LIKE 'Low' AND T1.active LIKE 'TRUE'	public_review_platform
SELECT T2.closing_time, T2.opening_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T1.city LIKE 'Tempe' ORDER BY T1.stars DESC LIMIT 1	public_review_platform
SELECT T3.category_name, T5.attribute_name FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id INNER JOIN Business_Attributes AS T4 ON T1.business_id = T4.business_id INNER JOIN Attributes AS T5 ON T4.attribute_id = T5.attribute_id WHERE T1.active LIKE 'TRUE' AND T1.state LIKE 'AZ' AND T1.city LIKE 'Chandler' AND T1.review_count LIKE 'Medium'	public_review_platform
SELECT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.active LIKE 'TRUE' AND T1.state LIKE 'AZ' AND T1.city LIKE 'Surprise' GROUP BY T3.category_name	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.closing_time LIKE '9PM' AND T2.opening_time LIKE '8AM' AND T3.day_of_week LIKE 'Friday' GROUP BY T1.city	public_review_platform
SELECT T2.attribute_value FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.state LIKE 'AZ' AND T1.review_count LIKE 'High' AND T1.active LIKE 'TRUE' AND T1.city LIKE 'Mesa' AND T1.stars = 3	public_review_platform
SELECT DISTINCT T2.opening_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Chandler' AND T1.active LIKE 'TRUE' AND T1.review_count LIKE 'Medium'	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.stars < 4 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.stars) AS "percentage" FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T3.category_name LIKE 'Accessories'	public_review_platform
SELECT T2.closing_time, T3.day_of_week FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Tempe' AND T1.active LIKE 'TRUE' AND T1.stars > 0.7 * ( SELECT AVG(T1.stars) FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Tempe' AND T1.active LIKE 'TRUE' )	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city LIKE 'Phoenix' AND active LIKE 'True'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE review_count LIKE 'High'	public_review_platform
SELECT COUNT(business_id) FROM Business_Attributes WHERE attribute_id = 1 AND attribute_value = 'beer_and_wine'	public_review_platform
SELECT COUNT(attribute_id) FROM Business_Attributes WHERE business_id = 2	public_review_platform
SELECT COUNT(T1.user_id) FROM Users_Compliments AS T1 INNER JOIN Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.number_of_compliments LIKE 'High' AND T2.compliment_id = 1	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.city LIKE 'Phoenix' AND T3.attribute_name LIKE 'waiter_service' AND T2.attribute_id = 2	public_review_platform
SELECT T5.attribute_name FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id INNER JOIN Business_Attributes AS T4 ON T3.business_id = T4.business_id INNER JOIN Attributes AS T5 ON T4.attribute_id = T5.attribute_id WHERE T2.day_id LIKE '1' AND '2' AND '3' AND '4' AND '5' AND '6' AND '7' AND T1.opening_time = T1.closing_time GROUP BY T5.attribute_name	public_review_platform
SELECT T3.business_id FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Reviews AS T4 ON T3.business_id = T4.business_id WHERE T1.category_name LIKE 'Fashion' AND T1.category_id = 7 GROUP BY T3.business_id ORDER BY COUNT(T4.user_id) DESC LIMIT 1	public_review_platform
SELECT DISTINCT T4.category_name FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T2.state LIKE 'AZ' AND T1.review_stars >= 3	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.user_average_stars = 1 THEN 1 ELSE 0 END) AS REAL) / COUNT(T2.user_id) , SUM(CASE WHEN T1.user_average_stars = 5 THEN 1 ELSE 0 END) * 1.0 / COUNT(T2.user_id) FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id WHERE T2.year_id = 2013	public_review_platform
SELECT CAST(COUNT(CASE WHEN year_id < 2014 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(CASE WHEN year_id = 2005 THEN 1.0 ELSE NULL END) AS increment FROM Elite	public_review_platform
SELECT COUNT(T1.business_id) , strftime('%Y', 'now') - T2.user_yelping_since_year FROM Reviews AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.user_id = 3	public_review_platform
SELECT COUNT(review_stars) / (strftime('%Y', 'now') - T1.user_yelping_since_year) FROM Users AS T1 INNER JOIN Reviews AS T2 ON T1.user_id = T2.user_id WHERE T1.user_id = 3	public_review_platform
SELECT CAST(COUNT(T1.user_id) AS REAL) / COUNT(DISTINCT T1.business_id) FROM Reviews AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id	public_review_platform
SELECT T2.user_average_stars, COUNT(T3.likes) FROM Elite AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id INNER JOIN Tips AS T3 ON T3.user_id = T2.user_id GROUP BY T1.user_id HAVING COUNT(T1.user_id) > 5	public_review_platform
SELECT T2.category_id FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Reviews AS T3 ON T3.business_id = T1.business_id WHERE T2.category_name = 'Hotels & Travel' GROUP BY T2.category_id ORDER BY COUNT(T2.category_id) DESC LIMIT 1	public_review_platform
SELECT CAST(SUM(T2.review_stars) AS REAL) / COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE active LIKE 'True'	public_review_platform
SELECT business_id FROM Business WHERE city LIKE 'Phoenix' AND review_count LIKE 'Low'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE state LIKE 'AZ' AND review_count LIKE 'High' AND active LIKE 'True'	public_review_platform
SELECT business_id FROM Business WHERE city LIKE 'Tempe' AND stars BETWEEN 3 AND 4	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year BETWEEN 2010 AND 2012 AND user_fans LIKE 'Low'	public_review_platform
SELECT review_length FROM Reviews WHERE user_id = 60776 AND business_id = 1	public_review_platform
SELECT T3.attribute_name FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.review_count LIKE 'High' AND T1.city LIKE 'Scottsdale' GROUP BY T3.attribute_name	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T3.category_name LIKE 'Automotive' AND T1.stars < 3	public_review_platform
SELECT T1.business_id, T1.stars FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.active LIKE 'TRUE' AND T3.category_name LIKE 'Pets'	public_review_platform
SELECT T3.attribute_name FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id ORDER BY T1.stars DESC LIMIT 1	public_review_platform
SELECT T4.category_name FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T1.review_length LIKE 'Short' AND T2.business_id BETWEEN 5 AND 10 ORDER BY T1.review_stars DESC LIMIT 1	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T3.attribute_name LIKE 'Wi-Fi' AND T1.active LIKE 'TRUE' AND T1.review_count LIKE 'Medium'	public_review_platform
SELECT T2.closing_time, T2.opening_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T1.city LIKE 'Gilbert' ORDER BY T1.stars DESC LIMIT 1	public_review_platform
SELECT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T1.review_count = 'Low' AND T1.city = 'Mesa' AND T1.active = 'true' AND T1.state = 'AZ'	public_review_platform
SELECT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.active LIKE 'FALSE' AND T1.state LIKE 'AZ'	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.closing_time LIKE '9PM' AND T2.opening_time LIKE '9AM' AND T3.day_of_week LIKE 'Saturday' GROUP BY T1.city	public_review_platform
SELECT T2.attribute_value FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.state LIKE 'AZ' AND T1.review_count LIKE 'Medium' AND T1.active LIKE 'FALSE' AND T1.city LIKE 'Phoenix' AND T1.stars = 3.5	public_review_platform
SELECT T2.opening_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Surprise' AND T1.active LIKE 'TRUE' AND T1.review_count LIKE 'Low' GROUP BY T2.opening_time	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.stars < 3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.stars) AS "percentage" FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T3.category_name LIKE 'Local Services'	public_review_platform
SELECT T2.closing_time, T3.day_of_week FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Scottsdale' AND T1.active LIKE 'TRUE' AND T1.stars > 0.6 * ( SELECT AVG(T1.stars) FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Scottsdale' AND T1.active LIKE 'TRUE' )	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year = 2004 AND user_fans LIKE 'None'	public_review_platform
SELECT user_id FROM Users_Compliments WHERE number_of_compliments LIKE 'Low' GROUP BY user_id ORDER BY COUNT(number_of_compliments) > 5 LIMIT 5	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_average_stars = 4 LIMIT 10	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.opening_time LIKE '10AM' AND T2.closing_time LIKE '12PM' AND T3.day_of_week LIKE 'Sunday'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_value LIKE 'TRUE' AND T1.attribute_name LIKE 'Open 24 Hours'	public_review_platform
SELECT T2.business_id FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T2.attribute_value LIKE 'TRUE' AND T1.attribute_name LIKE 'Good for Dancing' AND T1.attribute_name LIKE 'Good for Groups' LIMIT 5	public_review_platform
SELECT T1.business_id FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city LIKE 'Ahwatukee' AND T1.active LIKE 'TRUE' AND T3.day_of_week LIKE 'Sunday'	public_review_platform
SELECT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.active LIKE 'TRUE' AND T1.state NOT LIKE 'AZ'	public_review_platform
SELECT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories ON T1.business_id = Business_Categories.business_id INNER JOIN Categories AS T3 ON Business_Categories.category_id = T3.category_id WHERE T1.stars = 2 AND T1.review_count LIKE 'High'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_value = 'true' AND T1.attribute_name = 'ambience_romantic'	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.closing_time LIKE '6PM' AND T2.opening_time LIKE '1PM' AND T3.day_of_week LIKE 'Saturday'	public_review_platform
SELECT COUNT(T1.user_fans) FROM Users AS T1 INNER JOIN Tips AS T2 ON T1.user_id = T2.user_id ORDER BY COUNT(T2.likes) DESC LIMIT 1	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.closing_time = '1AM' AND T2.opening_time = '12AM' AND T3.day_of_week = 'Saturday'	public_review_platform
SELECT COUNT(T2.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name = 'Shopping Centers' AND T3.review_count = 'High'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Attributes AS T1 INNER JOIN Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_name = 'Accepts Insurance' AND T1.attribute_value = 'true'	public_review_platform
SELECT 1.0 * (( SELECT SUM(T1.stars) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.state = 'SC' ) + ( SELECT SUM(T1.stars) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.state = 'CA' )) / ( SELECT SUM(T1.stars) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id ) AS reslut	public_review_platform
SELECT SUM(CASE WHEN T3.day_of_week = 'Monday' THEN 1 ELSE 0 END) - SUM(CASE WHEN T3.day_of_week = 'Tuesday' THEN 1 ELSE 0 END) AS DIFF FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.opening_time = '10AM' AND T2.closing_time = '9PM'	public_review_platform
SELECT attribute_id FROM Attributes WHERE attribute_name = 'Accepts Insurance'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE active = 'true' AND city = 'Phoenix'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE stars = 4 AND city = 'Mesa'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE review_count = 'High' AND city = 'Gilbert'	public_review_platform
SELECT DISTINCT T1.business_id FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.active = 'true' AND T1.city = 'Gilbert' AND T1.review_count = 'Uber'	public_review_platform
SELECT COUNT(T2.review_length) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Tempe' AND T1.stars = '3.5' AND T1.review_count = 'Uber' AND T2.review_length = 'Long'	public_review_platform
SELECT T3.attribute_name FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.city = 'Mesa' AND T1.review_count = 'Uber' AND T3.attribute_name = 'Noise Level'	public_review_platform
SELECT T1.attribute_value FROM Business_Attributes AS T1 INNER JOIN Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_name = 'good_for_dinner' AND T1.business_id = 14033	public_review_platform
SELECT SUBSTR(T1.closing_time, 1, 2) + 12 - SUBSTR(T1.opening_time, 1, 2) AS YYSJ FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T2.day_of_week = 'Monday' AND T1.business_id = 15098	public_review_platform
SELECT T1.business_id FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Phoenix' AND T2.review_stars = 5 AND T2.review_votes_funny = 'Uber'	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Tips AS T2 ON T1.business_id = T2.business_id WHERE T2.tip_length = 'Medium' AND T2.likes = 3	public_review_platform
SELECT COUNT(T2.user_id) FROM Users AS T1 INNER JOIN Users_Compliments AS T2 ON T1.user_id = T2.user_id INNER JOIN Compliments AS T3 ON T2.compliment_id = T3.compliment_id WHERE T1.user_yelping_since_year = 2010 AND T1.user_average_stars = 4.5 AND T1.user_fans = 'Uber' AND T3.compliment_type = 'funny'	public_review_platform
SELECT COUNT(T2.number_of_compliments) FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.compliment_type = 'cool' AND T2.user_id = 41717	public_review_platform
SELECT T1.attribute_value FROM Business_Attributes AS T1 INNER JOIN Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.business_id = 11825 AND T2.attribute_name = 'parking_lot'	public_review_platform
SELECT T1.attribute_value FROM Business_Attributes AS T1 INNER JOIN Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.business_id = 12476 AND T2.attribute_name = 'payment_types_mastercard'	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.category_name = 'Pets' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.category_name) FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.category_name = 'Women''s Clothing' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.category_name = 'Men''s Clothing' THEN 1 ELSE 0 END) AS TIMES FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT business_id, active, city FROM Business WHERE state = 'CA' AND active = 'true'	public_review_platform
SELECT CAST(SUM(CASE WHEN active = 'true' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(business_id) FROM Business	public_review_platform
SELECT attribute_id, attribute_name FROM Attributes WHERE attribute_name LIKE 'music%'	public_review_platform
SELECT year_id FROM Elite WHERE year_id IN (2006, 2007) GROUP BY year_id ORDER BY COUNT(user_id) DESC LIMIT 1	public_review_platform
SELECT CAST(SUM(CASE WHEN number_of_compliments = 'Low' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(user_id) FROM Users_compliments	public_review_platform
SELECT business_id, user_id FROM Reviews WHERE review_votes_cool = 'Uber'	public_review_platform
SELECT T1.user_id, T2.business_id, T2.tip_length FROM Users AS T1 INNER JOIN Tips AS T2 ON T1.user_id = T2.user_id WHERE T1.user_yelping_since_year = 2004 AND T1.user_fans = 'High'	public_review_platform
SELECT T1.business_id, T1.active, T3.user_id, T3.user_yelping_since_year FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id INNER JOIN Users AS T3 ON T2.user_id = T3.user_id WHERE T2.review_votes_cool = 'Uber' AND T2.review_votes_funny = 'Uber' AND T2.review_length = 'Long'	public_review_platform
SELECT T1.attribute_id, T2.business_id, T3.city FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name = 'music_playlist' AND T3.active = 'false'	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.attribute_name = 'Accepts Credit Cards' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.attribute_name) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id	public_review_platform
SELECT T2.user_id, T2.review_length FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'San Tan Valley' AND T1.active = 'false' AND T2.review_stars = 5	public_review_platform
SELECT T2.user_average_stars, T1.year_id, T4.compliment_type, T3.number_of_compliments FROM Elite AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id INNER JOIN Users_Compliments AS T3 ON T2.user_id = T3.user_id INNER JOIN Compliments AS T4 ON T3.compliment_id = T4.compliment_id INNER JOIN Years AS T5 ON T1.year_id = T5.year_id WHERE T3.number_of_compliments = 'Uber' AND T3.user_id = 6027	public_review_platform
SELECT T2.business_id, T3.state, T3.city FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name = 'Coffee & Tea' LIMIT 5	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id GROUP BY T2.category_id HAVING COUNT(T2.business_id) > ( SELECT COUNT(T3.business_id) FROM Business_Categories AS T3 ) * 0.1	public_review_platform
SELECT T3.user_id, T3.user_fans FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id INNER JOIN Users AS T3 ON T2.user_id = T3.user_id WHERE T1.city = 'Sun Lakes' AND T1.stars = 5	public_review_platform
SELECT SUM(CASE WHEN T1.category_name = 'Men''s Clothing' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.category_name = 'Women''s Clothing' THEN 1 ELSE 0 END) AS diff FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT T1.compliment_type, T3.user_fans FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id INNER JOIN Users AS T3 ON T2.user_id = T3.user_id WHERE T2.number_of_compliments = 'Uber' AND T2.user_id < 100	public_review_platform
SELECT DISTINCT business_id FROM Business_Hours WHERE closing_time = '8PM'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city = 'Phoenix' AND state = 'AZ' AND stars = 2	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city = 'Phoenix' AND stars > 3	public_review_platform
SELECT user_id FROM Users WHERE user_yelping_since_year = 2012 AND user_average_stars < 3	public_review_platform
SELECT CAST(SUM(CASE WHEN stars = 5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(stars) FROM Business	public_review_platform
SELECT ( SELECT COUNT(business_id) FROM Reviews GROUP BY business_id ORDER BY COUNT(business_id) DESC LIMIT 1 ) - ( SELECT COUNT(business_id) FROM Reviews GROUP BY business_id ORDER BY COUNT(business_id) ASC LIMIT 1 ) AS DIFF	public_review_platform
SELECT DISTINCT T2.business_id FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id INNER JOIN Business_Hours AS T4 ON T3.business_id = T4.business_id WHERE T1.category_name = 'Tires' GROUP BY T2.business_id HAVING COUNT(day_id) = 7	public_review_platform
SELECT DISTINCT T1.user_id FROM Elite AS T1 INNER JOIN Years AS T2 ON T1.year_id = T2.year_id WHERE T2.actual_year = 2012	public_review_platform
SELECT T1.business_id FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Shopping' AND T1.stars = 4	public_review_platform
SELECT COUNT(T2.business_id) FROM Days AS T1 INNER JOIN Checkins AS T2 ON T1.day_id = T2.day_id WHERE T1.day_of_week = 'Sunday' AND T2.label_time_10 = 'Low'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Glendale' AND T2.user_id = 20241	public_review_platform
SELECT T1.city FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Pet Services'	public_review_platform
SELECT COUNT(T1.user_id) FROM Users AS T1 INNER JOIN Users_Compliments AS T2 ON T1.user_id = T2.user_id INNER JOIN Compliments AS T3 ON T2.compliment_id = T3.compliment_id INNER JOIN Reviews AS T4 ON T1.user_id = T4.user_id WHERE T3.compliment_type = 'photos' AND T4.review_votes_cool = 'High'	public_review_platform
SELECT COUNT(*) FROM Business WHERE business_id IN ( SELECT T1.business_id FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id WHERE T1.active = 'false' GROUP BY T1.business_id HAVING COUNT(DISTINCT T2.attribute_id) > 10 )	public_review_platform
SELECT T1.business_id FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.city = 'Mesa' AND T3.attribute_name = 'Alcohol'	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.review_votes_funny = 'Low' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Phoenix'	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.category_name = 'Shopping' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T2.category_name = 'Pets' THEN 1 ELSE 0 END) AS radio FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id	public_review_platform
SELECT COUNT(T2.business_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id WHERE T1.category_name = 'Banks & Credit Unions'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE active = 'true' AND city = 'Casa Grande'	public_review_platform
SELECT T1.opening_time FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T1.business_id = 12 AND T2.day_of_week = 'Monday'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name = 'Good for Kids' AND T2.attribute_value = 'true'	public_review_platform
SELECT business_id FROM Business WHERE city = 'Gilbert' AND active = 'true' AND review_count = 'High' ORDER BY stars DESC LIMIT 1	public_review_platform
SELECT T1.business_id, T3.category_name FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T1.city = 'Ahwatukee' AND T1.stars = 5	public_review_platform
SELECT CAST(SUM(CASE WHEN stars > 3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(stars) FROM Business WHERE city = 'Avondale' AND active = 'false'	public_review_platform
SELECT DISTINCT T2.user_id FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id WHERE T1.user_yelping_since_year = 2004	public_review_platform
SELECT CAST(SUM(CASE WHEN review_length = 'Long' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(review_length) FROM Reviews WHERE review_stars = 5	public_review_platform
SELECT CAST(SUM(CASE WHEN user_fans = 'None' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(user_id) FROM Users WHERE user_average_stars >= 4	public_review_platform
SELECT COUNT(business_id) FROM Tips WHERE business_id = 2 AND tip_length = 'Short'	public_review_platform
SELECT user_id FROM Users WHERE user_average_stars = 5 ORDER BY user_yelping_since_year ASC LIMIT 1	public_review_platform
SELECT T2.opening_time, T2.closing_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city = 'Black Canyon City' GROUP BY t2.business_id HAVING T1.review_count > AVG(T1.review_count)	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.compliment_type = 'cute' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.user_id) FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T2.number_of_compliments = 'High'	public_review_platform
SELECT COUNT(business_id) FROM Business_Attributes WHERE attribute_value IN ('none', 'no', 'false')	public_review_platform
SELECT opening_time, closing_time FROM Business_Hours WHERE business_id = 1 AND day_id = 2	public_review_platform
SELECT DISTINCT T1.city FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T2.review_length = 'Medium'	public_review_platform
SELECT T2.closing_time FROM Days AS T1 INNER JOIN Business_Hours AS T2 ON T1.day_id = T2.day_id WHERE T1.day_of_week = 'Sunday' AND T2.business_id = 4	public_review_platform
SELECT DISTINCT T1.business_id FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Phoenix' AND T2.review_length = 'Short'	public_review_platform
SELECT COUNT(T1.user_id) FROM Users AS T1 INNER JOIN Users_Compliments AS T2 ON T1.user_id = T2.user_id WHERE T2.number_of_compliments = 'High' AND T1.user_fans = 'Medium'	public_review_platform
SELECT DISTINCT T2.user_id FROM Users AS T1 INNER JOIN Users_Compliments AS T2 ON T1.user_id = T2.user_id WHERE T1.user_yelping_since_year = 2012 AND T2.number_of_compliments = 'Low'	public_review_platform
SELECT COUNT(T2.business_id) FROM Business_Attributes AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T2.city = 'Gilbert' AND T1.attribute_value IN ('None', 'no', 'false')	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Attributes AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T1.attribute_value = 'full_bar'	public_review_platform
SELECT DISTINCT T1.state FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T2.opening_time = '1AM'	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id WHERE T2.business_id = 5	public_review_platform
SELECT T2.user_id FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.compliment_type = 'photos'	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.tip_length = 'Medium' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.tip_length), T2.user_yelping_since_year FROM Tips AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id	public_review_platform
SELECT CAST(COUNT(T1.city) AS REAL) * 100 / ( SELECT COUNT(business_id) FROM Business ), T2.attribute_value FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Mesa'	public_review_platform
SELECT DISTINCT T1.state FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T2.closing_time = '12AM'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Attributes AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T2.city = 'Peoria' AND T1.attribute_value = 'beer_and_wine'	public_review_platform
SELECT T2.user_id FROM Users AS T1 INNER JOIN Users_Compliments AS T2 ON T1.user_id = T2.user_id WHERE T2.number_of_compliments = 'High' AND T1.user_yelping_since_year = ( SELECT MIN(user_yelping_since_year) FROM Users )	public_review_platform
SELECT business_id FROM Reviews GROUP BY business_id ORDER BY COUNT(user_id) DESC LIMIT 1	public_review_platform
SELECT year_id FROM Elite GROUP BY year_id ORDER BY COUNT(user_id) DESC LIMIT 1	public_review_platform
SELECT COUNT(business_id) FROM Reviews WHERE review_stars = 5 AND review_votes_funny = 'Uber'	public_review_platform
SELECT COUNT(DISTINCT user_id) FROM Reviews WHERE review_votes_funny = 'Uber'	public_review_platform
SELECT business_id FROM Business_Hours ORDER BY closing_time - opening_time LIMIT 1	public_review_platform
SELECT DISTINCT business_id FROM Business_Hours WHERE day_id >= 1 AND day_id < 8 AND opening_time = closing_time	public_review_platform
SELECT T3.tip_length, SUM(T3.likes) AS likes FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Tips AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name = 'Hotels & Travel' GROUP BY T3.tip_length	public_review_platform
SELECT COUNT(T2.user_id) AS USER_IDS, T2.user_average_stars FROM Reviews AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.review_votes_funny = 'Uber' AND T1.review_votes_useful = 'Uber' AND T1.review_votes_cool = 'Uber'	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.stars BETWEEN 3.5 AND 5 THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.stars BETWEEN 1 AND 2.5 THEN 1 ELSE 0 END) AS ratio FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id	public_review_platform
SELECT T2.business_id, T3.category_name FROM Reviews AS T1 INNER JOIN Business_categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id GROUP BY T2.business_id ORDER BY COUNT(T1.user_id) DESC LIMIT 10	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE business_id IN ( SELECT DISTINCT T1.business_id FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T1.state = 'AZ' GROUP BY T1.business_id HAVING SUM(T2.review_stars) / COUNT(T2.user_id) < 3 )	public_review_platform
SELECT CAST((( SELECT COUNT(user_id) FROM Users ) - ( SELECT COUNT(DISTINCT user_id) FROM Elite )) AS REAL) * 100 / ( SELECT COUNT(user_id) FROM Users )	public_review_platform
SELECT DISTINCT T3.compliment_type FROM Users AS T1 INNER JOIN Users_Compliments AS T2 ON T1.user_id = T2.user_id INNER JOIN Compliments AS T3 ON T2.compliment_id = T3.compliment_id WHERE T1.user_fans = 'Uber'	public_review_platform
SELECT CAST(SUM(T2.year_id - T1.user_yelping_since_year) AS REAL) / COUNT(T1.user_id) FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id WHERE T1.user_fans = 'Uber'	public_review_platform
SELECT CAST(SUM(T2.year_id - T1.user_yelping_since_year) AS REAL) / COUNT(T1.user_id) FROM Users AS T1 INNER JOIN Elite AS T2 ON T1.user_id = T2.user_id	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.active = 'true' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.business_id) AS ACT FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Mesa'	public_review_platform
SELECT DISTINCT T4.category_name FROM Business_Hours AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T2.active = 'true' AND T2.city = 'Phoenix' AND T1.opening_time >= '5PM' LIMIT 3	public_review_platform
SELECT T3.user_id FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Reviews AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name = 'Delivery' GROUP BY T3.user_id ORDER BY COUNT(T2.business_id) DESC LIMIT 1	public_review_platform
SELECT AVG(T3.user_id) FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Reviews AS T3 ON T1.business_id = T3.business_id WHERE T1.active = 'true' GROUP BY T2.closing_time - T2.opening_time HAVING SUM(T2.closing_time - T2.opening_time) < 30	public_review_platform
SELECT DISTINCT business_id FROM Business_Hours WHERE opening_time = '8AM' AND closing_time = '6PM'	public_review_platform
SELECT DISTINCT business_id FROM Business_Hours WHERE day_id = 6 AND opening_time = '10AM'	public_review_platform
SELECT DISTINCT day_id FROM Business_Hours WHERE opening_time = '8AM' AND closing_time = '6PM'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE stars > 4	public_review_platform
SELECT DISTINCT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business_Hours AS T3 ON T2.business_id = T3.business_id INNER JOIN Days AS T4 ON T3.day_id = T4.day_id WHERE T4.day_of_week = 'Sunday' AND T3.opening_time <> ''	public_review_platform
SELECT DISTINCT T4.day_of_week FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business_Hours AS T3 ON T1.business_id = T3.business_id INNER JOIN Days AS T4 ON T3.day_id = T4.day_id WHERE T2.category_name = 'Pets'	public_review_platform
SELECT DISTINCT T3.opening_time, T3.day_id FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business_Hours AS T3 ON T1.business_id = T3.business_id INNER JOIN Days AS T4 ON T3.day_id = T4.day_id WHERE T2.category_name = 'Doctors'	public_review_platform
SELECT T2.category_name FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business_Hours AS T3 ON T1.business_id = T3.business_id INNER JOIN Days AS T4 ON T3.day_id = T4.day_id GROUP BY T2.category_name ORDER BY COUNT(T3.day_id) DESC LIMIT 1	public_review_platform
SELECT T1.business_id, T3.closing_time FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business_Hours AS T3 ON T1.business_id = T3.business_id INNER JOIN Days AS T4 ON T3.day_id = T4.day_id WHERE T2.category_name = 'Arts & Entertainment' AND T4.day_of_week = 'Sunday'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'DJs' AND T1.stars < 5	public_review_platform
SELECT DISTINCT T4.business_id FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business_Hours AS T3 ON T2.business_id = T3.business_id INNER JOIN Business AS T4 ON T3.business_id = T4.business_id WHERE T4.active = 'true' AND T3.opening_time = '7AM' AND T3.closing_time = '8PM'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T2.category_name = 'Stadiums & Arenas' AND T3.stars = ( SELECT MAX(stars) FROM Business )	public_review_platform
SELECT COUNT(DISTINCT T1.category_id) FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.review_count = 'Low' AND T3.stars > 2	public_review_platform
SELECT T1.business_id FROM Business_Hours AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Accessories' AND SUBSTR(T1.opening_time, -4, 2) * 1 < 7 AND T1.opening_time LIKE '%AM'	public_review_platform
SELECT COUNT(DISTINCT T2.business_id) FROM Business_Hours AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Business_Categories AS T3 ON T2.business_id = T3.business_id INNER JOIN Categories AS T4 ON T3.category_id = T4.category_id WHERE T2.active = 'true' AND T2.state = 'AZ' AND T1.opening_time > '12PM'	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Tips AS T3 ON T2.business_id = T3.business_id WHERE T3.user_id = 16328	public_review_platform
SELECT T3.business_id, CAST((( SELECT COUNT(business_id) FROM Business WHERE stars < 2 ) - ( SELECT COUNT(business_id) FROM Business WHERE stars > 2 )) AS REAL) * 100 / ( SELECT COUNT(stars) FROM Business ) FROM Business_Categories AS T1 INNER JOIN Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T1.business_id = T3.business_id WHERE T2.category_name = 'Food'	public_review_platform
SELECT CAST(SUM(CASE WHEN T3.category_name = 'Food' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.category_name) FROM Business_Categories AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T1.category_id = T3.category_id	public_review_platform
SELECT SUM(CASE WHEN review_count = 'High' THEN 1 ELSE 0 END) AS high , SUM(CASE WHEN review_count = 'Medium' THEN 1 ELSE 0 END) AS Medium , SUM(CASE WHEN review_count = 'Low' THEN 1 ELSE 0 END) AS low FROM Business WHERE city = 'Cave Creek' AND active = 'true'	public_review_platform
SELECT AVG(user_id) FROM Users WHERE user_yelping_since_year >= 2005 AND user_yelping_since_year <= 2015	public_review_platform
SELECT CAST(SUM(CASE WHEN active = 'true' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN active = 'false' THEN 1 ELSE 0 END) AS radio FROM Business WHERE review_count = 'Low'	public_review_platform
SELECT user_id FROM Elite WHERE year_id = 2006 LIMIT 5	public_review_platform
SELECT category_id, category_name FROM Categories WHERE category_name LIKE 'P%' LIMIT 5	public_review_platform
SELECT user_id, review_stars FROM Reviews WHERE business_id = 15 AND review_length = 'Medium'	public_review_platform
SELECT T2.business_id, T2.attribute_value FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name = 'payment_types_visa'	public_review_platform
SELECT T2.business_id, T3.active FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.category_name = 'Diagnostic Imaging'	public_review_platform
SELECT T2.user_id, T2.user_yelping_since_year FROM Reviews AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.business_id = 143 AND T1.review_stars = 5	public_review_platform
SELECT T3.user_id, T3.user_yelping_since_year FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id INNER JOIN Users AS T3 ON T2.user_id = T3.user_id WHERE T1.compliment_type = 'profile' AND T2.number_of_compliments = 'Uber' LIMIT 5	public_review_platform
SELECT T1.user_id, T1.business_id, T2.review_length FROM Tips AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id ORDER BY T1.likes DESC LIMIT 1	public_review_platform
SELECT T2.user_id, T2.number_of_compliments FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id INNER JOIN Elite AS T3 ON T2.user_id = T3.user_id WHERE T3.year_id BETWEEN 2005 AND 2014 AND T1.compliment_type = 'photos'	public_review_platform
SELECT CAST(SUM(CASE WHEN T2.opening_time = '9AM' AND T2.closing_time = '9PM' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.day_id) FROM Days AS T1 INNER JOIN Business_Hours AS T2 ON T1.day_id = T2.day_id WHERE T1.day_of_week = 'Sunday'	public_review_platform
SELECT T2.business_id, T3.day_of_week FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city = 'Black Canyon City' AND T1.active = 'true'	public_review_platform
SELECT T2.user_id, T2.review_length FROM Users AS T1 INNER JOIN Reviews AS T2 ON T1.user_id = T2.user_id WHERE T1.user_yelping_since_year = 2004 AND T1.user_average_stars = 5	public_review_platform
SELECT DISTINCT T2.business_id, T2.city FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T1.review_stars >= 4 AND ( SELECT CAST(( SELECT COUNT(DISTINCT T1.user_id) FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T1.review_stars >= 4 ) AS REAL) * 100 / ( SELECT COUNT(user_id) FROM Users ) > 65 )	public_review_platform
SELECT SUM(CASE WHEN city = 'Glendale' THEN 1 ELSE 0 END) - SUM(CASE WHEN city = 'Mesa' THEN 1 ELSE 0 END) AS diff FROM Business WHERE active = 'true'	public_review_platform
SELECT SUM(T2.likes) FROM Users AS T1 INNER JOIN Tips AS T2 ON T1.user_id = T2.user_id WHERE T1.user_yelping_since_year = 2010	public_review_platform
SELECT T2.tip_length FROM Users AS T1 INNER JOIN Tips AS T2 ON T1.user_id = T2.user_id WHERE T1.user_average_stars = 3 GROUP BY T2.tip_length ORDER BY COUNT(T2.tip_length) DESC LIMIT 1	public_review_platform
SELECT SUM(T2.likes) AS likes FROM Business AS T1 INNER JOIN Tips AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Goodyear'	public_review_platform
SELECT DISTINCT T1.state FROM Business AS T1 INNER JOIN Tips AS T2 ON T1.business_id = T2.business_id WHERE T2.tip_length = 'Long'	public_review_platform
SELECT SUM(T2.closing_time - T2.opening_time) FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'El Mirage' AND T1.state = 'AZ'	public_review_platform
SELECT T3.day_id - T2.day_id FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.state = 'SC'	public_review_platform
SELECT DISTINCT T3.category_name FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T1.stars = 5	public_review_platform
SELECT DISTINCT T2.state FROM Business_Attributes AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T1.attribute_value = 'beer_and_wine'	public_review_platform
SELECT COUNT(T2.user_id) FROM Compliments AS T1 INNER JOIN Users_Compliments AS T2 ON T1.compliment_id = T2.compliment_id WHERE T1.compliment_type = 'photos' AND T2.number_of_compliments = 'Medium'	public_review_platform
SELECT T3.business_id FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name = 'Wi-Fi' AND T2.attribute_value = 'true' AND T3.state = 'SC'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name = 'ambience_romantic' AND T2.attribute_value = 'true'	public_review_platform
SELECT CAST(SUM(CASE WHEN attribute_name = 'Good for Kids' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T2.attribute_value = 'true'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city = 'Mesa' AND active = 'true'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE stars IN (1, 2)	public_review_platform
SELECT business_id FROM Business WHERE stars > 3 AND city = 'Paradise Valley' AND review_count = 'Low'	public_review_platform
SELECT COUNT(business_id) FROM Business_Attributes WHERE attribute_value > 1	public_review_platform
SELECT COUNT(business_id) FROM Business_Hours WHERE opening_time = '8AM' AND closing_time = '6PM'	public_review_platform
SELECT COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Reviews AS T2 ON T1.business_id = T2.business_id WHERE T2.review_votes_funny = 'Uber' AND T1.active = 'true'	public_review_platform
SELECT COUNT(T2.user_id) FROM Users_Compliments AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id WHERE T1.number_of_compliments = 'High' AND T2.user_fans = 'None'	public_review_platform
SELECT T2.compliment_type FROM Users_Compliments AS T1 INNER JOIN Compliments AS T2 ON T1.compliment_id = T2.compliment_id GROUP BY T2.compliment_type ORDER BY COUNT(T2.compliment_type) DESC LIMIT 1	public_review_platform
SELECT T2.user_average_stars FROM Tips AS T1 INNER JOIN Users AS T2 ON T1.user_id = T2.user_id GROUP BY T2.user_id ORDER BY SUM(T1.likes) DESC LIMIT 3	public_review_platform
SELECT T1.category_name FROM Categories AS T1 INNER JOIN Business_Categories AS T2 ON T1.category_id = T2.category_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T3.city = 'Arcadia'	public_review_platform
SELECT T1.business_id FROM Business_Hours AS T1 INNER JOIN Days AS T2 ON T1.day_id = T2.day_id WHERE T1.day_id = 1	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id INNER JOIN Business AS T3 ON T2.business_id = T3.business_id WHERE T1.attribute_name = 'music_karaoke' AND T3.active = 'false' AND T2.attribute_value IN ('none', 'no', 'false')	public_review_platform
SELECT COUNT(DISTINCT T2.business_id) FROM Reviews AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id WHERE T1.review_length = 'Long' AND T2.active = 'true' AND T2.city = 'Phoenix'	public_review_platform
SELECT COUNT(DISTINCT T1.user_id) FROM Users AS T1 INNER JOIN Reviews AS T2 ON T1.user_id = T2.user_id WHERE T1.user_votes_cool = 'Low' AND T2.review_votes_cool = 'Low'	public_review_platform
SELECT COUNT(DISTINCT T1.user_id) FROM Users AS T1 INNER JOIN Tips AS T2 ON T1.user_id = T2.user_id WHERE T2.tip_length = 'Long' AND T2.likes = 2 AND T1.user_fans = 'High'	public_review_platform
SELECT COUNT(T2.business_id) FROM Attributes AS T1 INNER JOIN Business_Attributes AS T2 ON T1.attribute_id = T2.attribute_id WHERE T1.attribute_name = 'ambience_trendy' AND T2.attribute_value IN ('none', 'no', 'false')	public_review_platform
SELECT COUNT(DISTINCT T2.business_id) FROM Business AS T1 INNER JOIN Business_hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city = 'Scottsdale' AND T3.day_of_week = 'Sunday' AND T2.opening_time = '12PM'	public_review_platform
SELECT CAST(SUM(T1.stars) AS REAL) / COUNT(T1.business_id) FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Obstetricians & Gynecologists'	public_review_platform
SELECT CAST(SUM(CASE WHEN T3.user_fans = 'High' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.user_fans) FROM Years AS T1 INNER JOIN Elite AS T2 ON T1.year_id = T2.year_id INNER JOIN Users AS T3 ON T2.user_id = T3.user_id WHERE T1.actual_year = 2011	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE city = 'Surprise'	public_review_platform
SELECT business_id FROM Business WHERE review_count = 'High' AND city = 'Tempe'	public_review_platform
SELECT COUNT(business_id) FROM Business WHERE review_count = 'Medium' AND state = 'AZ' AND active = 'true'	public_review_platform
SELECT business_id FROM Business WHERE stars >= 3 AND stars < 6 AND city = 'Chandler'	public_review_platform
SELECT COUNT(user_id) FROM Users WHERE user_yelping_since_year >= 2009 AND user_yelping_since_year < 2012 AND user_fans = 'Low'	public_review_platform
SELECT review_length FROM Reviews WHERE user_id = 11021 AND business_id = 3	public_review_platform
SELECT DISTINCT T3.attribute_name FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.city = 'Tempe' AND T1.review_count = 'Medium'	public_review_platform
SELECT COUNT(DISTINCT T1.business_id) FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Food' AND T1.stars < 3	public_review_platform
SELECT DISTINCT T1.business_id, T1.stars FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Food' AND T1.active = 'true'	public_review_platform
SELECT DISTINCT T3.category_name, T5.attribute_name FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id INNER JOIN Business_Attributes AS T4 ON T2.business_id = T4.business_id INNER JOIN Attributes AS T5 ON T4.attribute_id = T5.attribute_id WHERE T1.stars = ( SELECT MAX(stars) FROM Business )	public_review_platform
SELECT DISTINCT T3.category_name FROM Reviews AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T2.business_id >= 7 AND T2.business_id < 15 AND T1.review_length = 'Short' AND T1.review_stars = ( SELECT MAX(review_stars) FROM Reviews )	public_review_platform
SELECT COUNT(DISTINCT T1.business_id) FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T3.attribute_name = 'BYOB' AND T1.review_count = 'High' AND T1.active = 'true'	public_review_platform
SELECT T2.opening_time, T2.closing_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id WHERE T1.city = 'Glendale' ORDER BY T1.stars DESC LIMIT 1	public_review_platform
SELECT T3.category_name, T5.attribute_name FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id INNER JOIN Business_Attributes AS T4 ON T1.business_id = T4.business_id INNER JOIN Attributes AS T5 ON T4.attribute_id = T5.attribute_id WHERE T1.review_count = 'High' AND T1.city = 'Goodyear' AND T1.state = 'AZ' AND T1.active = 'true'	public_review_platform
SELECT DISTINCT T3.category_name FROM Business_Categories AS T1 INNER JOIN Business AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T1.category_id = T3.category_id WHERE T2.active = 'true' AND T2.state = 'AZ' AND T2.city = 'Glendale'	public_review_platform
SELECT DISTINCT T1.city FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T2.opening_time = '7AM' AND T2.closing_time = '7PM' AND T3.day_of_week = 'Wednesday'	public_review_platform
SELECT DISTINCT T2.attribute_value FROM Business AS T1 INNER JOIN Business_Attributes AS T2 ON T1.business_id = T2.business_id INNER JOIN Attributes AS T3 ON T2.attribute_id = T3.attribute_id WHERE T1.state = 'AZ' AND T1.city = 'Goodyear' AND T1.active = 'true' AND T1.stars = 3 AND T1.review_count = 'Low'	public_review_platform
SELECT DISTINCT T2.opening_time FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.city = 'Glendale' AND T1.review_count = 'Medium' AND T1.active = 'true'	public_review_platform
SELECT CAST(SUM(CASE WHEN T1.stars > 3 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.stars) FROM Business AS T1 INNER JOIN Business_Categories AS T2 ON T1.business_id = T2.business_id INNER JOIN Categories AS T3 ON T2.category_id = T3.category_id WHERE T3.category_name = 'Food'	public_review_platform
SELECT DISTINCT T2.closing_time, T3.day_of_week FROM Business AS T1 INNER JOIN Business_Hours AS T2 ON T1.business_id = T2.business_id INNER JOIN Days AS T3 ON T2.day_id = T3.day_id WHERE T1.active = 'true' AND T1.city = 'Goodyear' AND T1.stars > ( SELECT AVG(stars) * 0.8 FROM Business WHERE active = 'true' AND city = 'Goodyear' )	public_review_platform
SELECT CAST(COUNT(CASE WHEN class_label = 'Agents' THEN paper_id ELSE NULL END) AS REAL) * 100 / COUNT(paper_id) FROM paper	citeseer
SELECT word_cited_id, COUNT(paper_id) FROM content GROUP BY word_cited_id ORDER BY COUNT(word_cited_id) DESC LIMIT 1	citeseer
SELECT COUNT(DISTINCT T2.word_cited_id) FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.class_label = 'AI'	citeseer
SELECT T1.class_label, T2.word_cited_id FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.paper_id = 315017	citeseer
SELECT T2.word_cited_id FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.class_label = 'DB' GROUP BY T2.word_cited_id ORDER BY COUNT(T2.word_cited_id) DESC LIMIT 1	citeseer
SELECT CAST(COUNT(DISTINCT CASE WHEN T1.class_label = 'Agents' THEN T2.word_cited_id ELSE NULL END) AS REAL) * 100 / COUNT(DISTINCT T2.word_cited_id) FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id	citeseer
SELECT T1.paper_id, T1.class_label FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id GROUP BY T1.paper_id, T1.class_label ORDER BY COUNT(T2.word_cited_id) DESC LIMIT 1	citeseer
SELECT T1.paper_id, T1.class_label FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T2.word_cited_id = 'word1002'	citeseer
SELECT DISTINCT T2.word_cited_id FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.class_label = 'AI'	citeseer
SELECT DISTINCT T1.class_label, COUNT(T2.word_cited_id) FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.paper_id = 'chakrabarti01integrating' GROUP BY T1.class_label	citeseer
SELECT DISTINCT T1.paper_id, T1.class_label FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id GROUP BY T2.paper_id, T1.class_label HAVING COUNT(T2.word_cited_id) > 20	citeseer
SELECT DISTINCT T2.word_cited_id FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.class_label = 'AI' OR T1.class_label = 'IR'	citeseer
SELECT cited_paper_id, COUNT(cited_paper_id), ( SELECT cited_paper_id FROM cites GROUP BY cited_paper_id ORDER BY COUNT(cited_paper_id) ASC LIMIT 1 ), ( SELECT COUNT(cited_paper_id) FROM cites GROUP BY cited_paper_id ORDER BY COUNT(cited_paper_id) ASC LIMIT 1 ) FROM cites GROUP BY cited_paper_id ORDER BY COUNT(cited_paper_id) DESC LIMIT 1	citeseer
SELECT CAST(COUNT(CASE WHEN class_label = 'ML' THEN paper_id ELSE NULL END) AS REAL) / COUNT(paper_id) FROM paper	citeseer
SELECT DISTINCT T2.word_cited_id FROM cites AS T1 INNER JOIN content AS T2 ON T1.cited_paper_id = T2.paper_id WHERE T1.citing_paper_id = 'sima01computational'	citeseer
SELECT COUNT(T2.paper_id) FROM cites AS T1 INNER JOIN content AS T2 ON T1.cited_paper_id = T2.paper_id WHERE T1.citing_paper_id = 'schmidt99advanced' AND T2.word_cited_id = 'word3555'	citeseer
SELECT DISTINCT T1.class_label FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T2.word_cited_id = 'word1163'	citeseer
SELECT T1.paper_id FROM paper AS T1 INNER JOIN content AS T2 ON T1.paper_id = T2.paper_id WHERE T1.class_label = 'DB' GROUP BY T1.paper_id ORDER BY COUNT(T2.word_cited_id) DESC LIMIT 1	citeseer
SELECT COUNT(T1.paper_id) FROM paper AS T1 INNER JOIN cites AS T2 ON T1.paper_id = T2.citing_paper_id WHERE T1.class_label = 'ML' AND T2.cited_paper_id = 'butz01algorithmic'	citeseer
SELECT name FROM Person WHERE birthdate IS NOT NULL ORDER BY birthdate ASC LIMIT 1;	simpson_episodes
SELECT nickname FROM Person WHERE name = 'Dan Castellaneta';	simpson_episodes
SELECT COUNT(name) FROM Person WHERE birth_region = 'New York' AND SUBSTR(birthdate, 1, 4) > '1970';	simpson_episodes
SELECT T1.birth_country FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.award = 'Outstanding Voice-Over Performance' AND T2.year = 2009 AND T2.result = 'Winner';	simpson_episodes
SELECT T2.award FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T1.nickname = 'Doofus' AND T2.result = 'Winner';	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T1.birth_country = 'USA' AND T2.result = 'Nominee' AND T2.award = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND T2.year = 2009;	simpson_episodes
SELECT DISTINCT T1.character FROM Character_Award AS T1 INNER JOIN Award AS T2 ON T1.award_id = T2.award_id WHERE T2.award = 'Outstanding Voice-Over Performance' AND T2.year = 2009 AND T2.result = 'Winner';	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Lost Verizon';	simpson_episodes
SELECT COUNT(T2.keyword) FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.air_date = '2008-10-19';	simpson_episodes
SELECT T2.rating FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.award = 'Outstanding Voice-Over Performance' AND SUBSTR(T1.year, 1, 4) = '2009' AND T1.person = 'Dan Castellaneta';	simpson_episodes
SELECT COUNT(*) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Lost Verizon' AND T2.stars = 7;	simpson_episodes
SELECT T2.stars FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Lost Verizon' ORDER BY T2.votes DESC LIMIT 1;	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.votes > 200 AND T2.stars = 10;	simpson_episodes
SELECT COUNT(*) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE SUBSTR(T1.air_date, 1, 4) = '2009' AND T2.stars = 10 AND T2.percent > 15;	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 7 ORDER BY T2.votes DESC LIMIT 1;	simpson_episodes
SELECT CAST(SUM(T2.votes * T2.stars) AS REAL) / SUM(T2.votes) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Lost Verizon';	simpson_episodes
SELECT CAST(SUM(CASE WHEN T1.award_category = 'Primetime Emmy' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T2.rating > 7 AND T1.result = 'Nominee';	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.person = 'Pamela Hayden' AND T2.role = 'Ruthie';	simpson_episodes
SELECT T2.role, T1.episode, T1.number_in_series FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.person = 'Matt Groening' AND T1.title = 'In the Name of the Grandfather';	simpson_episodes
SELECT T1.title, T1.summary FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T2.keyword = 'eviction';	simpson_episodes
SELECT AVG(T2.stars) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Wedding for Disaster';	simpson_episodes
SELECT T1.title, T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.air_date = '2009-03-22';	simpson_episodes
SELECT DISTINCT T1.birth_name FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T2.role = 'Helen Lovejoy';	simpson_episodes
SELECT CAST(SUM(CASE WHEN T2.credited = 'false' THEN 1 END) AS REAL) * 100 / SUM(CASE WHEN T2.credited = 'true' THEN 1 END), T3.title, T2.person FROM Award AS T1 INNER JOIN Credit AS T2 ON T2.episode_id = T1.episode_id INNER JOIN Episode AS T3 ON T1.episode_id = T3.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2017' AND T1.award_category = 'Jupiter Award' AND T1.award = 'Best International TV Series' AND T1.result = 'Winner';	simpson_episodes
SELECT COUNT(episode_id) FROM Episode WHERE votes > 1000;	simpson_episodes
SELECT COUNT(name) FROM Person WHERE birth_place = 'New York City' AND birth_country = 'USA';	simpson_episodes
SELECT award_id, award_category FROM Award WHERE person = 'Marc Wilmore';	simpson_episodes
SELECT COUNT(name) FROM Person WHERE nickname IS NOT NULL;	simpson_episodes
SELECT AVG(height_meters) FROM Person;	simpson_episodes
SELECT MAX(votes) - MIN(votes) FROM Vote;	simpson_episodes
SELECT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.year = 2009 AND T1.award = 'Outstanding Voice-Over Performance';	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.year = 2009 AND T2.award = 'Comedy Series' AND T1.birth_region = 'California';	simpson_episodes
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2017' AND T1.award = 'Best International TV Series' AND T1.result = 'Winner';	simpson_episodes
SELECT T2.person FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'How the Test Was Won' AND T2.credited = 'false';	simpson_episodes
SELECT DISTINCT T1.title FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T2.keyword IN ('riot', 'cake');	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 10 ORDER BY T1.votes DESC LIMIT 1;	simpson_episodes
SELECT DISTINCT T2.person FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.air_date, 6, 2) BETWEEN '10' AND '11';	simpson_episodes
SELECT T2.person FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Treehouse of Horror XIX' AND T2.role = 'director';	simpson_episodes
SELECT COUNT(DISTINCT T2.role) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.episode = 5;	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Take My Life, Please';	simpson_episodes
SELECT CAST(SUM(CASE WHEN T1.award = 'Outstanding Voice-Over Performance' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.episode_id) FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T2.votes > 950 AND T1.year = 2009;	simpson_episodes
SELECT CAST(SUM(CASE WHEN T1.title = 'No Loan Again, Naturally' THEN T1.votes ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.title = 'Coming to Homerica' THEN T1.votes ELSE 0 END) AS ratio FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 5;	simpson_episodes
SELECT COUNT(award_id) FROM Award WHERE person = 'Ian Maxtone-Graham' AND organization = 'Writers Guild of America, USA' AND result = 'Nominee';	simpson_episodes
SELECT person FROM Award WHERE result = 'Nominee' GROUP BY person ORDER BY COUNT(person) DESC LIMIT 1;	simpson_episodes
SELECT title FROM Episode ORDER BY rating LIMIT 1;	simpson_episodes
SELECT year FROM Award WHERE result = 'Winner' AND award = 'Favorite Animated Comedy' ORDER BY year DESC LIMIT 1;	simpson_episodes
SELECT COUNT(*) FROM Credit WHERE person = 'Dell Hake' AND credited = 'false';	simpson_episodes
SELECT T2.year - CAST(SUBSTR(T1.birthdate, 1, 4) AS int) AS age FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.award = 'Outstanding Voice-Over Performance' AND T2.organization = 'Primetime Emmy Awards' AND T2.result = 'Winner';	simpson_episodes
SELECT DISTINCT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.person = 'Dan Castellaneta' AND T1.award = 'Outstanding Voice-Over Performance' AND T1.organization = 'Primetime Emmy Awards' AND T1.year = 2009;	simpson_episodes
SELECT COUNT(T1.episode_id) FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2009' AND T2.air_date LIKE '2009-04%';	simpson_episodes
SELECT T1.birth_place FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.award = 'Best Voice-Over Performance' AND T2.organization = 'Online Film & Television Association' AND T2.year = 2009;	simpson_episodes
SELECT SUM(T1.votes) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 10 ORDER BY T1.rating DESC LIMIT 4;	simpson_episodes
SELECT COUNT(*) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'No Loan Again, Naturally' AND T2.votes < 50;	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T1.birth_country = 'USA' AND T2.result = 'Winner';	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T1.nickname = 'Doofus' AND T2.credited = 'true' AND T2.episode_id = 'S20-E11';	simpson_episodes
SELECT T2.award, T1.name FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.result = 'Winner' ORDER BY T2.year LIMIT 1;	simpson_episodes
SELECT T2.percent FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Sex, Pies and Idiot Scrapes' AND T2.stars = 9;	simpson_episodes
SELECT award, person FROM Award WHERE result = 'Winner' AND SUBSTR(year, 1, 4) = '2009';	simpson_episodes
SELECT name, birthdate FROM Person WHERE birth_place = 'Los Angeles' AND height_meters >= 1.8;	simpson_episodes
SELECT episode, title, rating FROM Episode WHERE SUBSTR(air_date, 1, 7) LIKE '2008-10%';	simpson_episodes
SELECT T1.award_id, T1.award, T1.person FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T2.character = 'Homer Simpson' AND T1.result = 'Winner';	simpson_episodes
SELECT DISTINCT T1.award, T1.result, T2.category, T2.credited FROM Award AS T1 INNER JOIN Credit AS T2 ON T2.episode_id = T1.episode_id WHERE T2.person = 'Billy Kimball';	simpson_episodes
SELECT T1.person, T1.award, T1.organization, T1.result, T2.credited FROM Award AS T1 INNER JOIN Credit AS T2 ON T2.episode_id = T1.episode_id WHERE T2.episode_id = 'S20-E13' AND T2.role = 'assistant director';	simpson_episodes
SELECT T1.birth_country, T1.height_meters, T1.name FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T2.category = 'Cast' AND T2.credited = 'false';	simpson_episodes
SELECT T3.person, T1.keyword, T1.episode_id FROM Keyword AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Award AS T3 ON T2.episode_id = T3.episode_id WHERE T2.title = 'The Good, the Sad and the Drugly' AND T3.result = 'Nominee';	simpson_episodes
SELECT T2.votes, T2.percent FROM Keyword AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.keyword = 'arab stereotype' AND T2.stars = 10;	simpson_episodes
SELECT T1.award, T2.air_date, T2.rating FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.organization = 'Jupiter Award' AND T1.result = 'Winner';	simpson_episodes
SELECT DISTINCT T3.episode_id, T2.title, T1.keyword FROM Keyword AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Vote AS T3 ON T2.episode_id = T3.episode_id WHERE T3.stars = 1 ORDER BY T3.votes DESC LIMIT 3;	simpson_episodes
SELECT T2.title, T2.episode_image, T1.award, T1.person FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T2.rating BETWEEN 7 AND 10 AND SUBSTR(T2.air_date, 1, 4) = '2008' AND T1.result = 'Nominee';	simpson_episodes
SELECT DISTINCT T1.award, T1.person, T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T2.award_id = 326;	simpson_episodes
SELECT T1.name, T1.birth_place, T2.role, 2022 - CAST(SUBSTR(T1.birthdate, 1, 4) AS int) AS age FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T1.birthdate IS NOT NULL ORDER BY T1.birthdate LIMIT 1;	simpson_episodes
SELECT DISTINCT T2.credited, T2.category, T2.role, T1.birth_place FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T1.birth_country = 'North Korea';	simpson_episodes
SELECT T3.rate, T4.person, T4.award, T5.title, T4.role FROM ( SELECT CAST(SUM(CASE WHEN T1.result = 'Winner' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN T1.result IN ('Winner', 'Nominee') THEN 1 ELSE 0 END) AS rate , T1.person, T1.award, T2.title, T1.role FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2010' ) AS T3 INNER JOIN Award AS T4 INNER JOIN Episode AS T5 ON T4.episode_id = T5.episode_id WHERE T4.year = 2010 AND T4.result = 'Winner';	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id ORDER BY T2.stars DESC, T2.votes DESC LIMIT 1;	simpson_episodes
SELECT COUNT(award_id) FROM Award WHERE result = 'Winner';	simpson_episodes
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.organization = 'Primetime Emmy Awards' AND T1.award = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND T1.result = 'Nominee' GROUP BY T1.episode_id HAVING COUNT(T1.episode_id) = 21;	simpson_episodes
SELECT AVG(T2.stars), T1.summary FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.episode_id = 'S20-E12';	simpson_episodes
SELECT T1.person FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T2.character = 'Homer simpson 20' AND T1.organization = 'Primetime Emmy Awards' AND T1.award = 'Outstanding Voice-Over Performance' AND T1.result = 'Winner';	simpson_episodes
SELECT DISTINCT T1.birth_name, T2.role FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T1.name = 'Al Jean';	simpson_episodes
SELECT COUNT(award_id) FROM Award WHERE person = 'Billy Kimball' AND SUBSTR(year, 1, 4) = '2010' AND result = 'Nominee';	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Take My Life, Please';	simpson_episodes
SELECT award, award_category FROM Award WHERE result = 'Winner' ORDER BY year DESC LIMIT 1;	simpson_episodes
SELECT CAST(SUM(CASE WHEN result = 'Winner' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(award) AS rate FROM Award;	simpson_episodes
SELECT COUNT(episode_id) FROM Episode WHERE air_date LIKE '2008-10%' OR air_date LIKE '2008-11%';	simpson_episodes
SELECT episode_id FROM Episode WHERE air_date LIKE '2009%' ORDER BY rating LIMIT 1;	simpson_episodes
SELECT DISTINCT category, role FROM Credit WHERE person = 'Bonita Pietila';	simpson_episodes
SELECT name FROM Person WHERE birthdate = '1957-10-29' AND birth_place = 'Chicago' AND birth_region = 'Illinois';	simpson_episodes
SELECT DISTINCT person FROM Credit WHERE role = 'producer';	simpson_episodes
SELECT T1.year - T2.birthdate AS ageIn2009, T2.name FROM Award AS T1 INNER JOIN Person AS T2 ON T1.person = T2.name WHERE T1.role = 'composer' AND T1.organization = 'Primetime Emmy Awards' AND T1.award = 'Outstanding Music Composition for a Series (Original Dramatic Score)' AND T1.result = 'Nominee' AND T1.year = 2009;	simpson_episodes
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id GROUP BY T1.episode_id ORDER BY COUNT(*) DESC LIMIT 1;	simpson_episodes
SELECT birth_place FROM Person WHERE name = 'Dan Castellaneta';	simpson_episodes
SELECT COUNT(name) FROM Person WHERE birth_country = 'USA';	simpson_episodes
SELECT name FROM Person WHERE SUBSTR(birthdate, 1, 4) < '1970';	simpson_episodes
SELECT name FROM Person WHERE SUBSTR(birthdate, 1, 4) = '1958' AND birth_place = 'California' AND birth_country = 'USA';	simpson_episodes
SELECT episode_id FROM Vote WHERE stars = 5 AND votes > 100;	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Double, Double, Boy in Trouble';	simpson_episodes
SELECT DISTINCT T1.episode FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.episode BETWEEN 10 AND 20 AND T2.votes > 200;	simpson_episodes
SELECT T2.keyword FROM Award AS T1 INNER JOIN Keyword AS T2 ON T2.episode_id = T1.episode_id WHERE T1.award_category = 'Primetime Emmy';	simpson_episodes
SELECT T1.person FROM Award AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.award_category = 'Primetime Emmy' ORDER BY T2.votes DESC LIMIT 1;	simpson_episodes
SELECT DISTINCT T1.episode_id FROM Award AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.award = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND T2.stars = 10;	simpson_episodes
SELECT T1.person FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.role = 'director' AND T1.award = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND T2.title = 'No Loan Again, Naturally';	simpson_episodes
SELECT T1.person FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2009' AND T1.role = 'writer' AND T2.votes > 5;	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.award_category = 'WGA Award (TV)' AND T1.birth_country = 'USA' AND T2.year BETWEEN 2009 AND 2010;	simpson_episodes
SELECT DISTINCT T1.episode_id FROM Award AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.role = 'composer' AND T1.award = 'Outstanding Music Composition for a Series (Original Dramatic Score)' AND T2.votes > 200;	simpson_episodes
SELECT T2.episode_id FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2009' AND T1.person = 'Al Jean' AND T1.award_category = 'Primetime Emmy';	simpson_episodes
SELECT SUM(CASE WHEN T1.episode = 1 THEN T2.votes ELSE 0 END) - SUM(CASE WHEN T1.episode = 5 THEN T2.votes ELSE 0 END) AS diff FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id;	simpson_episodes
SELECT DISTINCT T1.award FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.year = 2009 AND T2.character = 'Homer Simpson';	simpson_episodes
SELECT SUM(CASE WHEN T2.votes < 100 THEN 1 ELSE 0 END) AS num , CAST(SUM(CASE WHEN T2.votes < 100 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM Award AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Episode AS T3 ON T1.episode_id = T3.episode_id WHERE T1.award = 'Outstanding Animated Program (For Programming Less Than One Hour)';	simpson_episodes
SELECT SUM(CASE WHEN T1.birth_country = 'USA' THEN 1 ELSE 0 END) AS num , CAST(SUM(CASE WHEN T1.birth_country = 'USA' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.award_category = 'Primetime Emmy' AND T2.person = 'Dan Castellaneta';	simpson_episodes
SELECT person FROM Award WHERE result = 'Nominee' AND award = 'Outstanding Voice-Over Performance' AND episode_id LIKE 'S20%' LIMIT 2;	simpson_episodes
SELECT COUNT(*) FROM Award WHERE role = 'executive producer' AND result = 'Nominee' AND award = 'Outstanding Animated Program (For Programming Less Than One Hour)';	simpson_episodes
SELECT name FROM Person WHERE SUBSTR(birthdate, 1, 4) = '1962' AND birth_region = 'California';	simpson_episodes
SELECT COUNT(name) FROM Person WHERE height_meters > 1.70 AND birth_country = 'Canada';	simpson_episodes
SELECT COUNT(*) FROM Award WHERE award = 'Animation' AND result = 'Nominee';	simpson_episodes
SELECT title FROM Episode WHERE rating BETWEEN 7 AND 10 LIMIT 3;	simpson_episodes
SELECT episode_id FROM Episode ORDER BY votes DESC LIMIT 5;	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = ( SELECT MIN(stars) FROM Vote ) ORDER BY T2.votes DESC LIMIT 3;	simpson_episodes
SELECT DISTINCT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.award LIKE '%Voice-Over%' AND T1.person = 'Dan Castellaneta';	simpson_episodes
SELECT T1.episode_id FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE SUBSTR(T1.air_date, 1, 4) = '2008' ORDER BY T2.votes DESC LIMIT 1;	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Take My Life, Please';	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T2.keyword = '1930s to 2020s' LIMIT 2;	simpson_episodes
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.year, 1, 4) = '2010' AND T1.person = 'Joel H. Cohen';	simpson_episodes
SELECT SUM(T2.votes) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Lisa the Drama Queen' AND T2.stars = 5;	simpson_episodes
SELECT T2.votes FROM Keyword AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 10 AND T1.keyword = 'reference to the fantastic four';	simpson_episodes
SELECT SUM(CASE WHEN T2.stars = 10 THEN T2.votes ELSE 0 END) - SUM(CASE WHEN T2.stars = 1 THEN T2.votes ELSE 0 END) AS Difference FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'The Burns and the Bees';	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id ORDER BY T1.votes LIMIT 1;	simpson_episodes
SELECT DISTINCT T1.episode_id FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 2 AND T2.votes > 20 AND T1.rating > 5.0 AND T1.rating <= 7.0;	simpson_episodes
SELECT episode FROM Episode WHERE votes = ( SELECT MAX(votes) FROM Episode );	simpson_episodes
SELECT name FROM Person ORDER BY birthdate ASC LIMIT 1;	simpson_episodes
SELECT episode_id FROM Credit WHERE person = 'Oscar Cervantes' AND credited = 'true';	simpson_episodes
SELECT T2.role FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T1.birth_country != 'USA';	simpson_episodes
SELECT COUNT(*) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 1 ORDER BY T1.rating LIMIT 1;	simpson_episodes
SELECT DISTINCT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.award = 'Outstanding Voice-Over Performance' AND T1.result = 'Winner';	simpson_episodes
SELECT T1.summary FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.person = 'Emily Blunt';	simpson_episodes
SELECT T2.role FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T1.nickname = 'The Tiny Canadian';	simpson_episodes
SELECT T1.episode_id FROM Award AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 5 ORDER BY T2.percent DESC LIMIT 1;	simpson_episodes
SELECT DISTINCT T2.person FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'In the Name of the Grandfather' AND T2.category = 'Cast' AND T2.credited = 'true';	simpson_episodes
SELECT T1.birthdate FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.result = 'Winner';	simpson_episodes
SELECT T1.person FROM Credit AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T1.role = 'Writer' AND T2.stars = 10 GROUP BY T1.person ORDER BY COUNT(*) DESC LIMIT 1;	simpson_episodes
SELECT T1.award FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.result = 'Winner' AND T2.air_date = '2008-11-30';	simpson_episodes
SELECT DISTINCT person, name, birthdate, birth_name, birth_place , birth_region, birth_country, height_meters, nickname FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T2.category = 'Music Department';	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.number_in_series = 426;	simpson_episodes
SELECT DISTINCT T1.episode_id FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 7 AND T2.votes > 0.7 * ( SELECT CAST(COUNT(votes) AS REAL) / COUNT(CASE WHEN stars = 7 THEN 1 ELSE 0 END) FROM Vote );	simpson_episodes
SELECT CAST(SUM(CASE WHEN T1.result = 'Nominee' THEN T2.votes ELSE 0 END) AS REAL) * 100 / SUM(T2.votes) FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id;	simpson_episodes
SELECT name FROM Person WHERE nickname IS NOT NULL;	simpson_episodes
SELECT birth_country FROM Person ORDER BY height_meters DESC LIMIT 1;	simpson_episodes
SELECT AVG(height_meters) FROM Person WHERE birth_country = 'USA';	simpson_episodes
SELECT CAST(SUM(CASE WHEN birth_region = 'California' AND SUBSTR(birthdate, 1, 4) > '1970' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(birthdate) FROM Person;	simpson_episodes
SELECT COUNT(name) FROM Person WHERE birth_region != 'Connecticut' AND birth_country != 'USA';	simpson_episodes
SELECT title FROM Episode WHERE episode_id IN ('S20-E1', 'S20-E2', 'S20-E3');	simpson_episodes
SELECT episode_image FROM Episode WHERE episode = 5;	simpson_episodes
SELECT votes FROM Episode WHERE rating > 7;	simpson_episodes
SELECT COUNT(*) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.category = 'Casting Department';	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T2.role = 'additional timer' AND T1.birth_country = 'USA';	simpson_episodes
SELECT COUNT(*) FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE STRFTIME(T1.birthdate) > '1970' AND T2.role = 'animation executive producer';	simpson_episodes
SELECT T1.summary FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.credited = 'false';	simpson_episodes
SELECT T1.rating FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.person = 'Jason Bikowski';	simpson_episodes
SELECT AVG(T1.height_meters) FROM Person AS T1 INNER JOIN Credit AS T2 ON T1.name = T2.person WHERE T2.category = 'Animation Department';	simpson_episodes
SELECT DISTINCT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.award_category = 'Primetime Emmy' AND T1.year = 2009 AND T1.result = 'Winner';	simpson_episodes
SELECT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.award_category = 'Primetime Emmy' AND T1.year BETWEEN 2009 AND 2010 AND T1.result != 'Winner';	simpson_episodes
SELECT SUM(T1.votes) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.person = 'Adam Kuhlman';	simpson_episodes
SELECT T1.keyword, T2.person FROM Keyword AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.episode_id = 'S20-E1';	simpson_episodes
SELECT T1.keyword FROM Keyword AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id WHERE T2.stars = 10 AND T2.percent > 29;	simpson_episodes
SELECT CAST(SUM(CASE WHEN T2.stars = 5 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'Sex, Pies and Idiot Scrapes';	simpson_episodes
SELECT CASE WHEN T2.Keyword = 'limbo dancing' THEN 'Yes' ELSE 'No' END AS result FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Dangerous Curves';	simpson_episodes
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.award = 'Best International TV Series' AND SUBSTR(T1.year, 1, 4) = '2017';	simpson_episodes
SELECT T2.keyword FROM Award AS T1 INNER JOIN Keyword AS T2 ON T2.episode_id = T1.episode_id WHERE T1.award_category = 'WGA Award (TV)';	simpson_episodes
SELECT T1.birth_place FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.award = 'Outstanding Animated Program (For Programming Less Than One Hour)' AND T2.role = 'co-executive producer';	simpson_episodes
SELECT T2.stars, SUM(T2.stars) FROM Award AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.award_category = 'Blimp Award' AND T2.stars BETWEEN 1 AND 5 GROUP BY T2.stars;	simpson_episodes
SELECT SUM(T2.rating) FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.award_category IN ('Jupiter Award ', 'WGA Award (TV)');	simpson_episodes
SELECT SUM(T2.percent) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'No Loan Again, Naturally' AND T1.rating = 6.8 AND T2.stars BETWEEN 5 AND 10;	simpson_episodes
SELECT COUNT(DISTINCT episode_id) FROM Vote WHERE stars > 8;	simpson_episodes
SELECT episode_id FROM Vote ORDER BY votes DESC LIMIT 1;	simpson_episodes
SELECT COUNT(episode_id) FROM Keyword WHERE keyword = '2d animation';	simpson_episodes
SELECT organization FROM Award WHERE award_id = 328;	simpson_episodes
SELECT COUNT(award_id) FROM Award WHERE SUBSTR(year, 1, 4) = '2009';	simpson_episodes
SELECT COUNT(award_id) FROM Award WHERE award_category = 'Primetime Emmy';	simpson_episodes
SELECT T1.birth_name FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.role = 'co-executive producer' AND T1.height_meters > 1.60;	simpson_episodes
SELECT CAST(SUM(CASE WHEN T1.birth_country = 'USA' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.result = 'Nominee';	simpson_episodes
SELECT CAST(SUM(CASE WHEN T1.height_meters > 1.75 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.result = 'Winner';	simpson_episodes
SELECT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars = 2;	simpson_episodes
SELECT T2.stars FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.title = 'How the Test Was Won';	simpson_episodes
SELECT COUNT(DISTINCT T2.episode_id) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE strftime('%Y', T1.air_date) = '2008' AND T2.stars > 5;	simpson_episodes
SELECT T2.character FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T1.year = 2009;	simpson_episodes
SELECT DISTINCT T1.year FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T2.character = 'Mr. Burns';	simpson_episodes
SELECT DISTINCT T1.award_category FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T2.character = 'Lenny';	simpson_episodes
SELECT DISTINCT T1.person FROM Award AS T1 INNER JOIN Character_Award AS T2 ON T1.award_id = T2.award_id WHERE T2.character = 'Smithers';	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'Dangerous Curves';	simpson_episodes
SELECT T2.keyword FROM Episode AS T1 INNER JOIN Keyword AS T2 ON T1.episode_id = T2.episode_id WHERE SUBSTR(T1.air_date, 1, 4) = '2008';	simpson_episodes
SELECT COUNT(DISTINCT T2.episode_id) FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE strftime('%Y', T1.air_date) = '2009' AND T2.stars < 8;	simpson_episodes
SELECT T1.birth_name FROM Person AS T1 INNER JOIN Award AS T2 ON T1.name = T2.person WHERE T2.role = 'director' AND T1.birth_country = 'South Korea';	simpson_episodes
SELECT COUNT(award_id) FROM Award WHERE SUBSTR(year, 1, 4) = '2009' AND result = 'Winner';	simpson_episodes
SELECT COUNT(episode_id) FROM Episode WHERE rating < 7;	simpson_episodes
SELECT name FROM Person WHERE birth_region = 'California' AND birth_country = 'USA';	simpson_episodes
SELECT COUNT(credited) FROM Credit WHERE episode_id IN ( 'S20-E5',  'S20-E6',  'S20-E7',  'S20-E8',  'S20-E9',  'S20-E10' ) AND credited = 'true' AND role = 'casting';	simpson_episodes
SELECT episode_id FROM Vote WHERE stars = 2 AND votes = 9;	simpson_episodes
SELECT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.organization = 'Primetime Emmy Awards' AND T1.year = 2009 AND T1.result = 'Winner';	simpson_episodes
SELECT DISTINCT T1.episode_id FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE SUBSTR(T1.air_date, 1, 4) = '2008' AND T2.stars < 5;	simpson_episodes
SELECT T2.category FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.person = 'Carlton Batten' AND T2.credited = 'true' ORDER BY T1.votes DESC LIMIT 1;	simpson_episodes
SELECT T2.percent FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE SUBSTR(T1.air_date, 1, 4) = '2008' AND T1.votes BETWEEN 950 AND 960;	simpson_episodes
SELECT T1.episode_id, T1.title FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.credited = 'true' AND T2.person = 'Bonita Pietila' AND T2.role = 'casting';	simpson_episodes
SELECT COUNT(*) FROM Award AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T1.organization = 'Annie Awards' AND T1.result = 'Nominee' AND T2.percent > 6;	simpson_episodes
SELECT DISTINCT T2.title FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T2.votes > 1000 AND T1.award_category = 'WGA Award (TV)' AND T1.result = 'Nominee';	simpson_episodes
SELECT T2.person FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T1.title = 'How the Test Was Won' AND T2.role = 'additional timer' AND T2.credited = 'true' AND T2.category = 'Animation Department';	simpson_episodes
SELECT T2.stars FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE SUBSTR(T1.air_date, 1, 7) = '2008-11';	simpson_episodes
SELECT T3.title FROM Award AS T1 INNER JOIN Vote AS T2 ON T1.episode_id = T2.episode_id INNER JOIN Episode AS T3 ON T1.episode_id = T3.episode_id WHERE T3.air_date = '2009-04-19' AND T1.award_category = 'Prism Award' AND T2.stars = 5 AND T1.result = 'Nominee';	simpson_episodes
SELECT T1.award_category FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T1.result = 'Nominee' ORDER BY T2.votes DESC LIMIT 1;	simpson_episodes
SELECT COUNT(*) FROM Episode AS T1 INNER JOIN Credit AS T2 ON T1.episode_id = T2.episode_id WHERE T2.credited = 'true' AND T2.person = 'Sam Im' AND SUBSTR(T1.air_date, 1, 4) = '2009' AND T2.role = 'additional timer';	simpson_episodes
SELECT DISTINCT T1.title FROM Episode AS T1 INNER JOIN Vote AS T2 ON T2.episode_id = T1.episode_id WHERE T2.stars > 0.7 * ( SELECT AVG(stars) FROM Vote );	simpson_episodes
SELECT CAST((SUM(CASE WHEN T1.result = 'Nominee' THEN 1 ELSE 0 END) - SUM(CASE WHEN T1.result = 'Winner' THEN 1 ELSE 0 END)) AS REAL) * 100 / COUNT(T1.result) FROM Award AS T1 INNER JOIN Episode AS T2 ON T1.episode_id = T2.episode_id WHERE T2.title = 'Gone Maggie Gone' AND T1.year = 2009;	simpson_episodes
SELECT COUNT(name) FROM longest_absense_from_school WHERE `month` = 0	student_loan
SELECT MAX(month) FROM longest_absense_from_school	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'navy'	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN male AS T2 ON T1.`name` = T2.`name` WHERE T1.`month` >= 5	student_loan
SELECT T1.name FROM enlist AS T1 INNER JOIN male AS T2 ON T1.`name` = T2.`name` WHERE T1.organ = 'navy'	student_loan
SELECT COUNT(T1.name) FROM filed_for_bankrupcy AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.`name` = T2.`name` WHERE T2.`month` > 5	student_loan
SELECT COUNT(T1.name) FROM enlist AS T1 INNER JOIN no_payment_due AS T2 ON T1.`name` = T2.`name` WHERE T1.organ = 'navy' AND T2.bool = 'pos'	student_loan
SELECT T1.name, T2.name, T3.name FROM disabled AS T1 INNER JOIN male AS T2 ON T1.`name` = T2.`name` INNER JOIN filed_for_bankrupcy AS T3 ON T1.`name` = T3.`name`	student_loan
SELECT COUNT(name) FROM disabled WHERE name NOT IN ( SELECT name FROM male )	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN no_payment_due AS T2 ON T1.`name` = T2.`name`	student_loan
SELECT T1.month FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T2.organ = 'navy' ORDER BY T1.`month` DESC LIMIT 1	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.`name` = T2.`name` WHERE T1.`month` = 0	student_loan
SELECT T2.organ FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T1.`month` = 9	student_loan
SELECT T2.organ, COUNT(T1.name) FROM disabled AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` GROUP BY T2.organ ORDER BY COUNT(T1.name) DESC LIMIT 1	student_loan
SELECT name FROM filed_for_bankrupcy WHERE name NOT IN ( SELECT name FROM male )	student_loan
SELECT CAST(COUNT(T2.name) AS REAL) * 100 / COUNT(T1.name) FROM enlist AS T1 LEFT JOIN male AS T2 ON T1.`name` = T2.`name` WHERE T1.organ = 'navy'	student_loan
SELECT AVG(T1.month) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.`name` = T2.`name`	student_loan
SELECT name FROM enlist WHERE organ = 'foreign_legion'	student_loan
SELECT bool FROM no_payment_due WHERE name = 'student348'	student_loan
SELECT school FROM enrolled WHERE name = 'student829'	student_loan
SELECT month FROM longest_absense_from_school WHERE name = 'student217'	student_loan
SELECT name FROM longest_absense_from_school WHERE `month` = 6	student_loan
SELECT organ FROM enlist WHERE name = 'student285'	student_loan
SELECT T2.name, T1.school FROM enrolled AS T1 INNER JOIN disabled AS T2 ON T1.`name` = T2.`name` WHERE T1.name = 'student281'	student_loan
SELECT T1.name, T1.school FROM enrolled AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T2.organ = 'air_force'	student_loan
SELECT T1.name FROM no_payment_due AS T1 INNER JOIN person AS T2 ON T1.`name` = T2.`name` WHERE T2.`name` NOT IN ( SELECT name FROM male ) AND T1.bool = 'neg'	student_loan
SELECT T2.organ, T1.name FROM no_payment_due AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T1.bool = 'pos' LIMIT 5	student_loan
SELECT T2.name FROM enrolled AS T1 INNER JOIN disabled AS T2 ON T1.`name` = T2.`name` WHERE T1.school = 'smc'	student_loan
SELECT T2.name FROM enlist AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.`name` = T2.`name` WHERE T1.organ = 'foreign_legion'	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN male AS T2 ON T1.name = T2.name WHERE T1.bool = 'neg'	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T2.organ = 'marines' AND T1.`month` = 6	student_loan
SELECT T2.name FROM enrolled AS T1 INNER JOIN unemployed AS T2 ON T1.`name` = T2.`name` WHERE T1.school = 'smc'	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN unemployed AS T2 ON T1.`name` = T2.name WHERE T1.`month` = 6	student_loan
SELECT COUNT(T1.name) FROM enlist AS T1 INNER JOIN enrolled AS T2 ON T1.`name` = T2.`name` WHERE T2.school = 'ucsd' AND T1.organ = 'peace_corps'	student_loan
SELECT T2.month, T1.organ FROM enlist AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.`name` = T2.`name` WHERE T1.name = 'student21'	student_loan
SELECT CAST(SUM(IIF(T1.bool = 'pos', 1, 0)) AS REAL) * 100 / SUM(IIF(T1.bool = 'neg', 1, 0)) FROM no_payment_due AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T2.organ = 'foreign_legion'	student_loan
SELECT CAST(SUM(IIF(T1.school = 'occ', 1.0, 0)) AS REAL) * 100 / COUNT(T1.name) FROM enrolled AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T2.organ = 'navy'	student_loan
SELECT name FROM longest_absense_from_school WHERE `month` = ( SELECT MAX(month) FROM longest_absense_from_school )	student_loan
SELECT COUNT(name) FROM person	student_loan
SELECT name, month FROM longest_absense_from_school WHERE `month` = ( SELECT MAX(month) FROM longest_absense_from_school )	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month = 4	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name	student_loan
SELECT DISTINCT T2.organ FROM disabled AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name`	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name INNER JOIN no_payment_due AS T3 ON T2.name = T3.name WHERE T3.bool = 'pos'	student_loan
SELECT IIF(T2.name IS NULL, 'female', 'male') FROM male AS T1 LEFT JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.name = 'student124'	student_loan
SELECT ( SELECT COUNT(name) FROM disabled WHERE name IN ('student180', 'student117') ), ( SELECT COUNT(name) FROM unemployed WHERE name IN ('student180', 'student117') ), ( SELECT COUNT(name) FROM male WHERE name IN ('student180', 'student117') ), ( SELECT COUNT(name) FROM no_payment_due WHERE name IN ('student180', 'student117'))	student_loan
SELECT COUNT(name) FROM enlist WHERE organ IN ('marines', 'air_force') AND name NOT IN ( SELECT name FROM male )	student_loan
SELECT T1.school, T2.organ FROM enrolled AS T1 INNER JOIN enlist AS T2 ON T1.`name` = T2.`name` WHERE T1.`name` IN ('student27,student17,studetn101')	student_loan
SELECT CAST(SUM(IIF(T2.name IS NULL, 1, 0)) AS REAL) * 100 / COUNT(T2.name) FROM disabled AS T1 LEFT JOIN male AS T2 ON T1.`name` = T2.`name`	student_loan
SELECT COUNT(name) FROM person WHERE name NOT IN ( SELECT name FROM male ) AND name NOT IN ( SELECT name FROM enrolled )	student_loan
SELECT T1.name FROM filed_for_bankrupcy AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T2.bool = 'neg'	student_loan
SELECT AVG(month) FROM longest_absense_from_school	student_loan
SELECT AVG(month) FROM longest_absense_from_school WHERE name NOT IN ( SELECT name FROM unemployed )	student_loan
SELECT AVG(T1.month) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name	student_loan
SELECT organ FROM enlist WHERE name = 'studenT113'	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'fire_department'	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month = 0	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month > 2	student_loan
SELECT COUNT(name) FROM no_payment_due WHERE bool = 'neg'	student_loan
SELECT COUNT(name) FROM no_payment_due WHERE bool = 'pos'	student_loan
SELECT T1.name FROM disabled AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name = T2.name WHERE T2.month = 0	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'navy'	student_loan
SELECT COUNT(T1.name) FROM male AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'foreign_legion'	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'air_force' AND name NOT IN ( SELECT name FROM male )	student_loan
SELECT T1.name FROM disabled AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name = T2.name ORDER BY T2.month DESC LIMIT 1	student_loan
SELECT T1.name FROM unemployed AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'marines'	student_loan
SELECT AVG(T1.month) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name	student_loan
SELECT CAST(SUM(IIF(T1.month > 5, 1, 0)) AS REAL) * 100 / COUNT(T1.month) FROM longest_absense_from_school AS T1 INNER JOIN unemployed AS T2 ON T1.name = T2.name	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN unemployed AS T2 ON T1.name = T2.name INNER JOIN disabled AS T3 ON T2.name = T3.name WHERE T1.month = 8	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN unemployed AS T2 ON T1.name = T2.name ORDER BY T1.month DESC LIMIT 1	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN unemployed AS T2 ON T1.name = T2.name WHERE T1.month = 0	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.month = 3	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name WHERE T1.month = 0	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name ORDER BY T1.month DESC LIMIT 1	student_loan
SELECT IIF(T.result = 0, 'female', 'male') AS re FROM ( SELECT COUNT(name) AS result FROM male WHERE name = 'studenT1000' ) T	student_loan
SELECT COUNT(name) FROM disabled	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month > 6	student_loan
SELECT name FROM longest_absense_from_school WHERE month = ( SELECT MAX(month) FROM longest_absense_from_school )	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'army'	student_loan
SELECT AVG(month) FROM longest_absense_from_school	student_loan
SELECT COUNT(name) FROM enlist WHERE organ IN ('army', 'peace_corps', 'foreign_legion')	student_loan
SELECT COUNT(T1.name) FROM enlist AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.organ = 'marines'	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T2.bool = 'pos'	student_loan
SELECT T2.name FROM male AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name <> T2.name WHERE T2.month = 0	student_loan
SELECT T.school FROM ( SELECT T2.school, COUNT(T2.name) AS num FROM disabled AS T1 INNER JOIN enrolled AS T2 ON T1.name = T2.name GROUP BY T2.school ) T ORDER BY T.num DESC LIMIT 1	student_loan
SELECT T2.organ FROM filed_for_bankrupcy AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name	student_loan
SELECT COUNT(T.a) FROM ( SELECT COUNT(DISTINCT T1.name) AS a, COUNT(T2.organ) AS num FROM male AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name GROUP BY T1.name ) T WHERE T.num > 1	student_loan
SELECT T1.name FROM disabled AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'navy'	student_loan
SELECT COUNT(T1.name) FROM enrolled AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name = T2.name WHERE T1.school = 'smc' AND T2.month = 7	student_loan
SELECT T1.name FROM disabled AS T1 INNER JOIN male AS T2 ON T1.name <> T2.name	student_loan
SELECT CAST(( SELECT COUNT(name) FROM unemployed ) AS REAL ) / ( SELECT COUNT(name) FROM disabled )	student_loan
SELECT CAST(COUNT(T2.name) AS REAL) * 100 / COUNT(T1.name) FROM enlist AS T1 LEFT JOIN male AS T2 ON T1.name = T2.name WHERE T1.organ = 'fire_department'	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month = 5	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'army'	student_loan
SELECT COUNT(name) FROM enrolled WHERE school = 'ucla'	student_loan
SELECT name FROM longest_absense_from_school ORDER BY month DESC LIMIT 5	student_loan
SELECT COUNT(name) FROM enlist WHERE organ >= 2	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'navy'	student_loan
SELECT COUNT(T1.name) FROM male AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T2.bool = 'neg'	student_loan
SELECT COUNT(T1.name) FROM enlist AS T1 INNER JOIN enrolled AS T2 ON T1.name = T2.name WHERE T1.organ = 'peace_corps' AND T2.school = 'ucsd'	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T2.bool = 'neg'	student_loan
SELECT COUNT(name) FROM no_payment_due WHERE name NOT IN ( SELECT name FROM male )	student_loan
SELECT COUNT(T2.name) FROM longest_absense_from_school AS T1 INNER JOIN unemployed AS T2 ON T2.name = T1.name WHERE T1.month = 0	student_loan
SELECT T1.name FROM no_payment_due AS T1 INNER JOIN enlist AS T2 ON T2.name = T1.name WHERE T1.bool = 'neg' AND T2.organ = 'fire_department' LIMIT 10	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'navy' AND name NOT IN ( SELECT name FROM male )	student_loan
SELECT COUNT(T1.name) FROM enlist AS T1 INNER JOIN unemployed AS T2 ON T2.name = T1.name WHERE T1.organ = 'army'	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN unemployed AS T2 ON T2.name = T1.name WHERE T1.bool = 'pos'	student_loan
SELECT T1.name FROM no_payment_due AS T1 INNER JOIN enlist AS T2 ON T2.name = T1.name WHERE T2.organ = 'peace_corps' AND T1.bool = 'pos' LIMIT 5	student_loan
SELECT COUNT(name) FROM disabled WHERE name NOT IN ( SELECT name FROM male )	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 INNER JOIN no_payment_due AS T2 ON T2.name = T1.name WHERE T2.bool = 'pos'	student_loan
SELECT CAST(SUM(IIF(T3.name IS NULL, 1, 0)) AS REAL) / COUNT(T1.name) FROM disabled AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T2.name = T3.name WHERE T2.organ = 'foreign_legion'	student_loan
SELECT CAST(SUM(IIF(T2.name IS NULL, 1, 0)) AS REAL) * 100 / COUNT(T1.name), CAST(SUM(IIF(T2.name IS NOT NULL, 1, 0)) AS REAL) * 100 / COUNT(T1.name) FROM enlist AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name WHERE T1.organ = 'fire_department'	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'navy'	student_loan
SELECT CAST(SUM(IIF(month = 0, 1, 0)) AS REAL) * 100 / COUNT(name) FROM longest_absense_from_school	student_loan
SELECT CAST(SUM(IIF(`bool` = 'pos', 1, 0)) AS REAL) / SUM(IIF(`bool` = 'neg', 1, 0)) FROM no_payment_due	student_loan
SELECT name, school FROM enrolled WHERE month = 15	student_loan
SELECT CAST(COUNT(NAME) AS REAL) * 100 / COUNT(DISTINCT organ) FROM enlist	student_loan
SELECT school, month FROM enrolled WHERE name = 'student214'	student_loan
SELECT CAST(COUNT(T2.name) AS REAL) * 100 / COUNT(T1.name) FROM person AS T1 LEFT JOIN disabled AS T2 ON T2.name = T1.name	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 LEFT JOIN longest_absense_from_school AS T2 ON T2.name = T1.name WHERE T2.month = 9	student_loan
SELECT name FROM person WHERE name NOT IN ( SELECT name FROM filed_for_bankrupcy )	student_loan
SELECT T1.name FROM enlist AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name WHERE T2.name IS NULL AND T1.organ = 'air_force' LIMIT 5	student_loan
SELECT COUNT(CASE  WHEN T2.name IS NULL THEN T1.name END) AS "number" FROM person AS T1 LEFT JOIN disabled AS T2 ON T2.name = T1.name	student_loan
SELECT IIF(T2.name IS NULL, 'female', 'male') AS gen , T1.school FROM enrolled AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name WHERE T1.name = 'student995'	student_loan
SELECT T1.name FROM disabled AS T1 INNER JOIN unemployed AS T2 ON T2.name = T1.name LIMIT 5	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T2.name = T1.name	student_loan
SELECT T2.name, T2.organ FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T2.name = T1.name WHERE T1.month = 4 LIMIT 5	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN unemployed AS T2 ON T2.name = T1.name WHERE T1.bool = 'pos'	student_loan
SELECT T1.organ, T2.bool FROM enlist AS T1 INNER JOIN no_payment_due AS T2 ON T2.name = T1.name WHERE T1.name = 'student160'	student_loan
SELECT T1.name FROM enlist AS T1 INNER JOIN male AS T2 ON T2.name = T1.name WHERE T1.organ = 'foreign_legion' LIMIT 10	student_loan
SELECT CAST(SUM(IIF(T2.name IS NULL, 1, 0)) AS REAL) * 100 / COUNT(T1.name) FROM person AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name	student_loan
SELECT COUNT(name) FROM filed_for_bankrupcy	student_loan
SELECT COUNT(name) FROM enrolled WHERE school = 'smc' AND month = 1	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'air_force'	student_loan
SELECT organ FROM enlist WHERE name = 'student168'	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name INNER JOIN enlist AS T3 ON T3.name = T2.name	student_loan
SELECT COUNT(T1.name) FROM enrolled AS T1 INNER JOIN disabled AS T2 ON T2.name = T1.name GROUP BY T1.school	student_loan
SELECT IIF(T2.name IS NULL, 'female', 'male') AS gender FROM enlist AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name GROUP BY T1.organ	student_loan
SELECT T.name FROM ( SELECT T1.name, COUNT(T1.organ) AS num FROM enlist AS T1 INNER JOIN enrolled AS T2 ON T1.name = T2.name GROUP BY T1.name ) T WHERE T.num = 2	student_loan
SELECT CAST(((SUM(IIF(month = 0, 1, 0)) - SUM(IIF(month = 9, 1, 0)))) AS REAL) * 100 / SUM(IIF(month = 0, 1, 0)) FROM longest_absense_from_school	student_loan
SELECT T.school, num FROM ( SELECT T1.school, COUNT(T2.name) AS num FROM enrolled AS T1 LEFT JOIN filed_for_bankrupcy AS T2 ON T2.name = T1.name GROUP BY T1.school ) T ORDER BY T.num DESC LIMIT 1	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 INNER JOIN unemployed AS T2 ON T2.name = T1.name	student_loan
SELECT T1.name FROM enlist AS T1 INNER JOIN enrolled AS T2 ON T2.name = T1.name WHERE T2.school = 'occ' AND T1.organ = 'fire_department'	student_loan
SELECT T1.name FROM unemployed AS T1 INNER JOIN disabled AS T2 ON T2.name = T1.name INNER JOIN longest_absense_from_school AS T3 ON T3.name = T2.name WHERE T3.month = 5	student_loan
SELECT name FROM enrolled WHERE school IN ('occ', 'ulca') AND name NOT IN ( SELECT name FROM male )	student_loan
SELECT T2.school, T1.organ FROM enlist AS T1 INNER JOIN enrolled AS T2 ON T2.name = T1.name WHERE T1.name = 'student211'	student_loan
SELECT COUNT(T2.name) - SUM(IIF(T2.name IS NULL, 1, 0)) AS num FROM filed_for_bankrupcy AS T1 LEFT JOIN male AS T2 ON T2.name = T1.name	student_loan
SELECT AVG(T2.month) AS avg FROM unemployed AS T1 INNER JOIN longest_absense_from_school AS T2 ON T2.name = T1.name INNER JOIN male AS T3 ON T3.name = T2.name	student_loan
SELECT CAST((SUM(IIF(T2.name IS NOT NULL AND T1.month = 0, 1, 0)) - SUM(IIF(T2.name IS NULL AND T1.month = 0, 1, 0))) AS REAL) * 100 / COUNT(T1.name), IIF(SUM(IIF(T2.name IS NOT NULL AND T1.month = 0, 1, 0)) - SUM(IIF(T2.name IS NULL AND T1.month = 0, 1, 0)) > 0, 'YES', 'NO') AS isHigh FROM longest_absense_from_school AS T1 LEFT JOIN disabled AS T2 ON T2.name = T1.name	student_loan
SELECT AVG(T1.month) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T2.name = T1.name INNER JOIN male AS T3 ON T3.name = T2.name	student_loan
SELECT CAST(SUM(IIF(T2.month = 0, 1, 0)) AS REAL) * 100 / COUNT(T1.name) FROM unemployed AS T1 INNER JOIN longest_absense_from_school AS T2 ON T2.name = T1.name	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN male AS T2 ON T2.name = T1.name WHERE T1.bool = 'pos'	student_loan
SELECT COUNT(T1.name) FROM filed_for_bankrupcy AS T1 INNER JOIN no_payment_due AS T2 ON T2.name = T1.name WHERE T2.bool = 'pos'	student_loan
SELECT `bool` FROM no_payment_due WHERE name = 'student124'	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.bool = 'neg'	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T2.bool = 'neg' ORDER BY T1.month DESC LIMIT 1	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T1.month = 5 AND T2.bool = 'neg'	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'marines'	student_loan
SELECT COUNT(T1.NAME) FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'peace_corps' ORDER BY T1.month DESC LIMIT 1	student_loan
SELECT COUNT(T1.name) FROM enlist AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name WHERE T1.organ = 'navy'	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T1.bool = 'pos' AND T2.organ = 'marines'	student_loan
SELECT 100 * SUM(IIF(T2.month = 0, 1, 0)) AS num FROM disabled AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name = T2.name	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'air_force'	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month < 4	student_loan
SELECT COUNT(*) FROM person AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T1.name = T3.name WHERE T2.organ = 'marines' AND T3.name IS NULL	student_loan
SELECT AVG(T2.month) FROM person AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T1.name = T3.name WHERE T3.name IS NULL	student_loan
SELECT T1.name FROM person AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T1.name = T3.name WHERE T3.name IS NULL	student_loan
SELECT bool FROM no_payment_due WHERE name = 'student299'	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'air_force'	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month > 1	student_loan
SELECT name FROM enlist WHERE organ = 'fire_department'	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.bool = 'pos'	student_loan
SELECT COUNT(T1.name) FROM filed_for_bankrupcy AS T1 INNER JOIN enrolled AS T2 ON T1.name = T2.name WHERE T2.school = 'occ'	student_loan
SELECT COUNT(T1.name) FROM male AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name	student_loan
SELECT T1.name FROM enlist AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.organ = 'navy'	student_loan
SELECT T1.name FROM male AS T1 INNER JOIN no_payment_due AS T2 ON T1.name = T2.name WHERE T2.bool = 'pos'	student_loan
SELECT T1.bool FROM no_payment_due AS T1 INNER JOIN unemployed AS T2 ON T1.name = T2.name WHERE T1.name = 'student110'	student_loan
SELECT CAST(COUNT(T2.name) AS REAL) * 100 / COUNT(T1.name) FROM person AS T1 LEFT JOIN male AS T2 ON T1.name = T2.name	student_loan
SELECT T1.school , IIF(T3.name IS NULL, 'female', 'male') AS gender FROM enrolled AS T1 INNER JOIN person AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T2.name = T3.name WHERE T2.name = 'student34'	student_loan
SELECT T1.month FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'fire_department' ORDER BY T1.month DESC LIMIT 1	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T1.month = 1 AND T2.organ = 'air_force'	student_loan
SELECT T2.NAME FROM unemployed AS T1 INNER JOIN male AS T2 ON T1.name = T2.name INNER JOIN disabled AS T3 ON T3.name = T2.name	student_loan
SELECT COUNT(T1.name) FROM enrolled AS T1 INNER JOIN male AS T2 ON T1.name = T2.name WHERE T1.school = 'occ'	student_loan
SELECT CAST(COUNT(T4.name) AS REAL) * 100 / COUNT(T2.name) FROM enlist AS T1 INNER JOIN person AS T2 ON T1.name = T2.name INNER JOIN enrolled AS T3 ON T3.name = T2.name LEFT JOIN male AS T4 ON T2.name = T4.name WHERE T3.school = 'ucla' AND T1.organ = 'air_force'	student_loan
SELECT CAST(SUM(IIF(T1.school = 'uci' AND T4.name IS NULL, 1, 0)) AS REAL) / COUNT(T1.name) FROM enrolled AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name INNER JOIN person AS T3 ON T1.name = T3.name LEFT JOIN male AS T4 ON T3.name = T4.name	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month = 0	student_loan
SELECT name FROM enlist WHERE organ = 'marines'	student_loan
SELECT COUNT(name) FROM enlist WHERE organ = 'navy'	student_loan
SELECT name FROM longest_absense_from_school WHERE month = ( SELECT MAX(month) FROM longest_absense_from_school )	student_loan
SELECT organ FROM ( SELECT organ, COUNT(organ) AS num FROM enlist GROUP BY organ ) T ORDER BY T.num DESC LIMIT 1	student_loan
SELECT COUNT(name) FROM longest_absense_from_school WHERE month < 3	student_loan
SELECT COUNT(T1.name) FROM no_payment_due AS T1 INNER JOIN unemployed AS T2 ON T1.name = T2.name WHERE T1.bool = 'pos'	student_loan
SELECT SUM(IIF(T3.name IS NULL, 1, 0)) AS "result" FROM enlist AS T1 INNER JOIN person AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T2.name = T3.name WHERE T1.organ = 'army'	student_loan
SELECT T.organ FROM ( SELECT T2.organ, COUNT(T1.name) AS num FROM male AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name GROUP BY T2.organ ) T ORDER BY T.num LIMIT 1	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 INNER JOIN longest_absense_from_school AS T2 ON T1.name = T2.name WHERE T2.month = 0	student_loan
SELECT COUNT(T1.name) FROM unemployed AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name	student_loan
SELECT T1.name FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name WHERE T1.month > 5	student_loan
SELECT COUNT(T1.name) FROM filed_for_bankrupcy AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name WHERE T2.organ = 'marines'	student_loan
SELECT COUNT(T1.name) FROM disabled AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name	student_loan
SELECT T1.month FROM longest_absense_from_school AS T1 INNER JOIN enlist AS T2 ON T1.name = T2.name ORDER BY T1.month DESC LIMIT 1	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN filed_for_bankrupcy AS T2 ON T1.name = T2.name INNER JOIN enlist AS T3 ON T3.name = T2.name WHERE T3.organ = 'fire_department'	student_loan
SELECT COUNT(T1.name) FROM longest_absense_from_school AS T1 INNER JOIN disabled AS T2 ON T1.name = T2.name INNER JOIN unemployed AS T3 ON T3.name = T2.name WHERE T1.month = 0	student_loan
SELECT T.organ, T.per FROM ( SELECT T1.organ, CAST(COUNT(T3.name) AS REAL) / COUNT(T2.name) AS per , COUNT(T3.name) AS num FROM enlist AS T1 INNER JOIN person AS T2 ON T1.name = T2.name LEFT JOIN male AS T3 ON T2.name = T3.name GROUP BY T1.organ ) T ORDER BY T.num DESC LIMIT 1	student_loan
SELECT COUNT(QuestionID) FROM Answer WHERE QuestionID = 19 AND AnswerText LIKE 'No'	mental_health_survey
SELECT SurveyID, COUNT(UserID) FROM Answer WHERE QuestionID = 13 AND SurveyID BETWEEN 2016 AND 2019 GROUP BY SurveyID	mental_health_survey
SELECT T1.UserID FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.SurveyID = 2018 AND T2.questionid = 1 AND T1.AnswerText BETWEEN '27' AND '35'	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN ( SELECT T2.questionid FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.SurveyID = 2019 AND T2.questionid = 6 AND T1.AnswerText LIKE 'Yes' ) AS T2 ON T1.QuestionID = T2.questionid WHERE T1.SurveyID = 2019 AND T2.questionid = 3 AND T1.AnswerText LIKE 'United States'	mental_health_survey
SELECT T1.SurveyID FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.SurveyID BETWEEN 2016 AND 2019 AND T2.questionid = 34 AND T1.AnswerText LIKE 'Yes' GROUP BY T1.SurveyID ORDER BY COUNT(T1.UserID) DESC LIMIT 1	mental_health_survey
SELECT COUNT(*) FROM ( SELECT T2.UserID FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID INNER JOIN Survey AS T3 ON T2.SurveyID = T3.SurveyID WHERE T3.Description = 'mental health survey for 2017' AND T1.questionid = 2 AND T2.AnswerText = 'Female' UNION SELECT T2.UserID FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID INNER JOIN Survey AS T3 ON T2.SurveyID = T3.SurveyID WHERE T1.questionid = 4 AND T2.AnswerText = 'Nebraska' AND T3.Description = 'mental health survey for 2017' )	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 54 AND T1.AnswerText LIKE 'Yes'	mental_health_survey
SELECT MAX(T1.AnswerText), MIN(T1.AnswerText) , ( SELECT T1.UserID FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 1 ORDER BY T1.AnswerText LIMIT 1 ) AS "youngest id" FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 1	mental_health_survey
SELECT T1.AnswerText FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 3 GROUP BY T1.AnswerText ORDER BY COUNT(T1.UserID) DESC LIMIT 1	mental_health_survey
SELECT CAST(SUM(T1.AnswerText) AS REAL) / COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN ( SELECT T1.UserID FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 3 AND T1.AnswerText = 'United States' ) AS T2 ON T1.UserID = T2.UserID INNER JOIN Question AS T3 ON T1.QuestionID = T3.questionid WHERE T3.questionid = 1	mental_health_survey
SELECT CAST(SUM(CASE  WHEN T1.AnswerText LIKE 'Yes' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 12	mental_health_survey
SELECT COUNT(QuestionID) FROM Answer WHERE SurveyID LIKE 2014 GROUP BY QuestionID ORDER BY COUNT(QuestionID) > 200 LIMIT 1	mental_health_survey
SELECT T2.AnswerText FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T1.questiontext = 'What is your age?' AND T2.SurveyID = 2014 ORDER BY T2.AnswerText DESC LIMIT 1	mental_health_survey
SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T1.questiontext = 'Would you bring up a mental health issue with a potential employer in an interview?' AND T2.SurveyID = 2014 AND T2.AnswerText LIKE 'NO'	mental_health_survey
SELECT T2.UserID FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T1.questiontext = 'Do you think that discussing a physical health issue with your employer would have negative consequences?' AND T2.AnswerText LIKE 'Yes' AND T2.SurveyID = 2014	mental_health_survey
SELECT COUNT(DISTINCT T1.UserID) FROM Answer AS T1 INNER JOIN Survey AS T2 ON T1.SurveyID = T2.SurveyID WHERE T2.Description = 'mental health survey for 2014'	mental_health_survey
SELECT T2.AnswerText FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T1.questiontext = 'Any additional notes or comments' AND T2.SurveyID = 2014 AND T2.AnswerText <> -1	mental_health_survey
SELECT T1.questiontext FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID IN (2014, 2016) GROUP BY T1.questiontext	mental_health_survey
SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID = 2018 AND T1.questiontext = 'What country do you live in?' AND T2.AnswerText = 'Canada'	mental_health_survey
SELECT T2.questiontext FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid INNER JOIN Survey AS T3 ON T1.SurveyID = T3.SurveyID WHERE T3.Description LIKE 'mental health survey for 2014' GROUP BY T2.questiontext	mental_health_survey
SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID = 2016 AND T1.questiontext LIKE 'Have you had a mental health disorder in the past?' AND T2.AnswerText = 'Yes'	mental_health_survey
SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID IN (2016, 2017, 2018) AND T1.questiontext LIKE 'Have you had a mental health disorder in the past?' AND T2.AnswerText = 'Yes'	mental_health_survey
SELECT CAST(SUM(T2.AnswerText) AS REAL) / COUNT(T2.UserID) AS "avg" FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID = 2014 AND T1.questiontext LIKE 'What is your age?'	mental_health_survey
SELECT CAST(( SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID = 2019 AND T1.questiontext LIKE 'Do you currently have a mental health disorder?' AND T2.AnswerText = 'Yes' ) - ( SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID = 2016 AND T1.questiontext LIKE 'Do you currently have a mental health disorder?' AND T2.AnswerText = 'Yes' ) AS REAL) * 100 / ( SELECT COUNT(T2.UserID) FROM Question AS T1 INNER JOIN Answer AS T2 ON T1.questionid = T2.QuestionID WHERE T2.SurveyID = 2016 AND T1.questiontext LIKE 'Do you currently have a mental health disorder?' AND T2.AnswerText = 'Yes' )	mental_health_survey
SELECT questionid FROM Question WHERE questiontext LIKE 'Would you bring up a physical health issue with a potential employer in an interview?'	mental_health_survey
SELECT MAX(UserID) - MIN(UserID) + 1 FROM Answer WHERE QuestionID = 20	mental_health_survey
SELECT COUNT(QuestionID) FROM Answer WHERE UserID = 5	mental_health_survey
SELECT COUNT(DISTINCT UserID) FROM Answer WHERE SurveyID LIKE 2016	mental_health_survey
SELECT COUNT(T1.QuestionID) FROM Answer AS T1 INNER JOIN Survey AS T2 ON T1.SurveyID = T2.SurveyID WHERE T2.Description = 'mental health survey for 2018'	mental_health_survey
SELECT COUNT(DISTINCT T1.QuestionID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid INNER JOIN Survey AS T3 ON T1.SurveyID = T3.SurveyID WHERE T2.questiontext = 'What country do you work in?'	mental_health_survey
SELECT T1.AnswerText FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext = 'Do you currently have a mental health disorder?' AND T1.UserID = 2681	mental_health_survey
SELECT COUNT(DISTINCT T1.UserID) FROM Answer AS T1 INNER JOIN Survey AS T2 ON T1.SurveyID = T2.SurveyID WHERE T2.Description = 'mental health survey for 2016'	mental_health_survey
SELECT T1.AnswerText FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext = 'What country do you work in?' GROUP BY T1.AnswerText ORDER BY COUNT(T1.AnswerText) DESC LIMIT 1	mental_health_survey
SELECT COUNT(DISTINCT T1.AnswerText) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext LIKE 'Describe the conversation you had with your previous employer about your mental health, including their reactions and actions taken to address your mental health issue/questions.'	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext LIKE 'What US state or territory do you work in?' AND T1.AnswerText = 'Kansas'	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext LIKE 'Any additional notes or comments' AND T1.AnswerText IS NOT NULL	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext LIKE 'Have you ever been diagnosed with a mental health disorder?' AND T1.AnswerText = 'Yes'	mental_health_survey
SELECT COUNT(DISTINCT T1.UserID) FROM Answer AS T1 INNER JOIN Survey AS T2 ON T1.SurveyID = T2.SurveyID WHERE T2.Description = 'mental health survey for 2018'	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext LIKE 'Overall, how much importance does your employer place on physical health?'	mental_health_survey
SELECT T1.AnswerText FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questionid = 2183 AND T1.AnswerText = 'Mood Disorder (Depression, Bipolar Disorder, etc)'	mental_health_survey
SELECT CAST(SUM(CASE  WHEN T1.AnswerText LIKE 'Yes' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T2.questiontext LIKE 'Has your employer ever formally discussed mental health (for example, as part of a wellness campaign or other official communication)?'	mental_health_survey
SELECT CAST(COUNT(T1.UserID) AS REAL) / ( SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Survey AS T2 ON T1.SurveyID = T2.SurveyID WHERE T2.Description = 'mental health survey for 2018' ) FROM Answer AS T1 INNER JOIN Survey AS T2 ON T1.SurveyID = T2.SurveyID WHERE T2.Description = 'mental health survey for 2017'	mental_health_survey
SELECT CAST(SUM(CASE  WHEN T1.AnswerText LIKE 'Yes' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.SurveyID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.QuestionID = 32 AND T1.SurveyID = 2016	mental_health_survey
SELECT COUNT(DISTINCT T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.QuestionID = 1 AND T1.SurveyID = 2016 AND T1.AnswerText <= 25	mental_health_survey
SELECT CAST(COUNT(SurveyID) AS REAL) / 5 FROM Answer WHERE SurveyID BETWEEN 2014 AND 2019	mental_health_survey
SELECT COUNT(T1.UserID) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.QuestionID = 7 AND T1.SurveyID = 2019 AND T1.AnswerText = 1	mental_health_survey
SELECT COUNT(T1.AnswerText) FROM Answer AS T1 INNER JOIN Question AS T2 ON T1.QuestionID = T2.questionid WHERE T1.QuestionID = 93 AND T1.SurveyID = 2014 AND T1.AnswerText = 'Yes'	mental_health_survey
SELECT COUNT(questiontext) FROM Question	mental_health_survey
SELECT COUNT(AnswerText) FROM Answer WHERE AnswerText LIKE 'Substance Use Disorder'	mental_health_survey
SELECT AnswerText FROM Answer WHERE QuestionID = 85 AND SurveyID = 2017 GROUP BY AnswerText ORDER BY COUNT(AnswerText) DESC LIMIT 3	mental_health_survey
SELECT SUM(CASE WHEN `Year` = 1998 THEN Total ELSE 0 END) - SUM(CASE WHEN `Year` = 1997 THEN Total ELSE 0 END) FROM revenue	disney
SELECT CASE WHEN 'Studio Entertainment[NI 1]' > 'Disney Media Networks' THEN 'Studio Entertainment[NI 1]' ELSE 'Disney Media Networks' END FROM revenue WHERE `Year` = 1998	disney
SELECT director FROM director WHERE name = 'Pinocchio'	disney
SELECT T2.villian FROM director AS T1 INNER JOIN characters AS T2 ON T1.name = T2.movie_title WHERE T1.director = 'Wolfgang Reitherman' AND T2.villian IS NOT NULL	disney
SELECT COUNT(movie_title) FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE SUBSTR(release_date, INSTR(release_date, '-') + 1, 3) = 'Dec' AND T2.director = 'Wolfgang Reitherman'	disney
SELECT T2.director FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T1.song = 'Once Upon a Dream'	disney
SELECT T1.`voice-actor` FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title WHERE T1.character LIKE '%' OR T2.villian OR '%' AND T2.movie_title = 'Alice in Wonderland'	disney
SELECT T2.release_date FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title WHERE T1.`voice-actor` = 'Alan Tudyk'	disney
SELECT COUNT(T2.movie) FROM characters AS T1 INNER JOIN `voice-actors` AS T2 ON T1.movie_title = T2.movie WHERE T2.`voice-actor` = 'Alan Tudyk' AND SUBSTR(release_date, INSTR(release_date, '-') + 5) > 12	disney
SELECT COUNT(T3.name) FROM ( SELECT T2.name FROM `movies_total_gross` AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Wolfgang Reitherman' AND T1.genre = 'Comedy' GROUP BY T2.name ) T3	disney
SELECT T2.movie_title FROM director AS T1 INNER JOIN movies_total_gross AS T2 ON T1.name = T2.movie_title WHERE T1.director = 'Wolfgang Reitherman' ORDER BY T2.total_gross DESC LIMIT 1	disney
SELECT T1.movie_title FROM `movies_total_gross` AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T1.MPAA_rating = 'G' AND T2.director = 'Wolfgang Reitherman'	disney
SELECT T2.villian FROM `movies_total_gross` AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title ORDER BY T1.total_gross DESC LIMIT 1	disney
SELECT T2.genre FROM characters AS T1 INNER JOIN movies_total_gross AS T2 ON T2.movie_title = T1.movie_title WHERE T1.villian = 'Commander Rourke'	disney
SELECT villian FROM characters WHERE movie_title = 'Beauty and the Beast'	disney
SELECT movie_title FROM characters WHERE hero = 'Robin Hood'	disney
SELECT movie_title FROM characters WHERE song = 'I Thought I Lost You'	disney
SELECT `voice-actor` FROM `voice-actors` WHERE character = 'Binkie Muddlefoot'	disney
SELECT T1.hero FROM characters AS T1 INNER JOIN movies_total_gross AS T2 ON T2.movie_title = T1.movie_title WHERE T2.total_gross = '$222,527,828'	disney
SELECT T2.song FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title WHERE CAST(SUBSTR(T1.release_date, INSTR(T1.release_date, ', ') + 1) AS int) BETWEEN 1970 AND 1979 ORDER BY CAST(REPLACE(SUBSTR(T1.total_gross, 2), ',', '') AS float) DESC LIMIT 1	disney
SELECT T1.hero FROM characters AS T1 INNER JOIN director AS T2 ON T2.name = T1.movie_title WHERE T2.director = 'Will Finn'	disney
SELECT T2.`voice-actor` FROM characters AS T1 INNER JOIN `voice-actors` AS T2 ON T2.movie = T1.movie_title WHERE T1.movie_title = 'The Little Mermaid' AND T2.character = T1.hero	disney
SELECT T1.director FROM director AS T1 INNER JOIN `voice-actors` AS T2 ON T2.movie = T1.name WHERE T2.character = 'Aunt Sarah' AND T2.`voice-actor` = 'Verna Felton'	disney
SELECT T1.release_date FROM characters AS T1 INNER JOIN `voice-actors` AS T2 ON T2.movie = T1.movie_title WHERE T2.character = 'Hyacinth Hippo' AND T2.`voice-actor` = 'Tress MacNeille'	disney
SELECT T1.director FROM director AS T1 INNER JOIN movies_total_gross AS T2 ON T2.movie_title = T1.name WHERE T2.genre = 'Adventure' AND T2.release_date = 'Mar 30, 2007'	disney
SELECT T1.movie_title FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Wolfgang Reitherman' ORDER BY CAST(REPLACE(SUBSTR(inflation_adjusted_gross, 2), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T1.hero FROM characters AS T1 INNER JOIN movies_total_gross AS T2 ON T2.movie_title = T1.movie_title WHERE T2.genre = 'Adventure' AND T1.release_date = '4-Mar-16'	disney
SELECT T1.movie_title FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title WHERE T2.hero = 'Donald Duck' ORDER BY CAST(REPLACE(SUBSTR(total_gross, 2), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT COUNT(name) FROM director WHERE director = 'Wolfgang Reitherman'	disney
SELECT director FROM director GROUP BY director ORDER BY COUNT(name) DESC LIMIT 1	disney
SELECT COUNT(movie_title) FROM movies_total_gross WHERE MPAA_rating = 'R' AND genre = 'Horror' AND CAST(SUBSTR(release_date, INSTR(release_date, ', ') + 1) AS int) BETWEEN 1990 AND 2015	disney
SELECT character FROM `voice-actors` WHERE 'voice-actor' = 'Frank Welker'	disney
SELECT T1.total_gross FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T2.movie_title = T1.movie_title WHERE T2.song = 'Little Wonders'	disney
SELECT T1.MPAA_rating FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T2.movie_title = T1.movie_title WHERE T2.villian = 'Turbo'	disney
SELECT COUNT(T.movie) FROM ( SELECT T1.movie FROM `voice-actors` AS T1 INNER JOIN movies_total_gross AS T2 ON T1.movie = T2.movie_title WHERE MPAA_rating = 'PG' AND `voice-actor` = 'Bill Thompson' GROUP BY T1.movie ) AS T	disney
SELECT COUNT(T.name) FROM ( SELECT T1.name FROM director AS T1 INNER JOIN movies_total_gross AS T2 ON T1.name = T2.movie_title WHERE T1.director = 'Gary Trousdale' AND T2.genre = 'Adventure' GROUP BY T1.name ) T	disney
SELECT director FROM director AS T1 INNER JOIN `voice-actors` AS T2 ON T1.name = T2.movie WHERE T2.`voice-actor` = 'Bill Thompson' GROUP BY director ORDER BY COUNT(director) DESC LIMIT 1	disney
SELECT T2.name FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T2.name = T1.movie_title WHERE T2.director = 'Ron Clements' ORDER BY CAST(REPLACE(SUBSTR(total_gross, 2), ',', '') AS int) DESC LIMIT 1	disney
SELECT T2.`voice-actor` FROM director AS T1 INNER JOIN `voice-actors` AS T2 INNER JOIN movies_total_gross AS T3 ON T1.name = T2.movie AND T2.movie = T3.movie_title WHERE T1.director = 'Ben Sharpsteen' AND T3.release_date = 'Feb 9, 1940' AND T2.`voice-actor` != 'None' GROUP BY T2.`voice-actor`	disney
SELECT COUNT(*) FROM director AS T1 INNER JOIN movies_total_gross AS T2 ON T1.name = T2.movie_title WHERE T1.director = 'Ron Clements' AND T2.MPAA_rating = 'PG' AND T2.genre = 'Adventure'	disney
SELECT COUNT(movie_title) FROM `movies_total_gross` WHERE genre = 'Horror'	disney
SELECT villian FROM characters WHERE movie_title = 'The Great Mouse Detective'	disney
SELECT 'voice-actor' FROM `voice-actors` WHERE movie = 'Meet the Robinsons'	disney
SELECT director, COUNT(name) FROM director GROUP BY director ORDER BY COUNT(name) DESC LIMIT 1	disney
SELECT `Year` FROM revenue WHERE `Year` BETWEEN 2000 AND 2010 ORDER BY `Studio Entertainment[NI 1]` DESC LIMIT 1	disney
SELECT song FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title WHERE T1.genre = 'Drama' GROUP BY song	disney
SELECT T2.`voice-actor` FROM characters AS T1 INNER JOIN `voice-actors` AS T2 ON T2.character = T1.hero WHERE T2.movie = T1.movie_title	disney
SELECT T2.director FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name AND CAST(SUBSTR(release_date, INSTR(release_date, ', ') + 1) AS int) BETWEEN 1990 AND 2000 GROUP BY T2.director	disney
SELECT T1.`voice-actor` FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T2.movie_title = T1.movie WHERE T2.movie_title = 'The Rescuers' AND T1.character = T2.villian	disney
SELECT T1.name, T2.`voice-actor` FROM director AS T1 INNER JOIN `voice-actors` AS T2 ON T1.name = T2.movie WHERE T1.director = 'Wolfgang Reitherman'	disney
SELECT DISTINCT T2.character FROM movies_total_gross AS T1 INNER JOIN `voice-actors` AS T2 ON T1.movie_title = T2.movie WHERE T1.MPAA_rating = 'PG'	disney
SELECT T1.movie_title FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T2.movie_title = T1.movie_title WHERE T2.song IS NULL ORDER BY CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T2.director, COUNT(DISTINCT T1.`voice-actor`) FROM `voice-actors` AS T1 INNER JOIN director AS T2 ON T1.movie = T2.name GROUP BY T2.director ORDER BY COUNT(DISTINCT T1.`voice-actor`) DESC LIMIT 1	disney
SELECT T2.`voice-actor` FROM movies_total_gross AS T1 INNER JOIN `voice-actors` AS T2 ON T1.movie_title = T2.movie WHERE T1.release_date = 'Nov 24, 2010'	disney
SELECT T2.director FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T1.song IS NOT NULL GROUP BY T2.director	disney
SELECT T2.movie_title FROM `voice-actors` AS T1 INNER JOIN movies_total_gross AS T2 ON T2.movie_title = T1.movie WHERE T1.`voice-actor` = 'Jim Cummings' ORDER BY CAST(REPLACE(trim(T2.total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T2.movie_title FROM director AS T1 INNER JOIN movies_total_gross AS T2 ON T1.name = T2.movie_title WHERE T1.director = 'Ron Clements' ORDER BY CAST(REPLACE(trim(T2.total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT SUM(CAST(REPLACE(trim(T2.total_gross, '$'), ',', '') AS REAL)) / COUNT(T2.movie_title) FROM `voice-actors` AS T1 INNER JOIN movies_total_gross AS T2 ON T1.movie = T2.movie_title WHERE T1.`voice-actor` = 'Sterling Holloway'	disney
SELECT CAST(COUNT(CASE WHEN T1.song IS NOT NULL THEN T2.movie_title ELSE NULL END) AS REAL) * 100 / COUNT(T2.movie_title) FROM characters AS T1 INNER JOIN movies_total_gross AS T2 ON T1.movie_title = T2.movie_title	disney
SELECT movie_title, genre FROM movies_total_gross WHERE SUBSTR(release_date, LENGTH(release_date) - 3, LENGTH(release_date)) = '2016'	disney
SELECT villian FROM characters WHERE movie_title = 'Little Mermaid'	disney
SELECT name FROM director WHERE director = 'Jack Kinney'	disney
SELECT movie_title, CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL) / CAST(REPLACE(trim(total_gross, '$'), ',', '') AS REAL) FROM movies_total_gross ORDER BY CAST(REPLACE(trim(total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT movie_title, release_date FROM movies_total_gross WHERE MPAA_rating = 'PG-13' AND genre = 'Romantic Comedy'	disney
SELECT movie, character FROM `voice-actors` WHERE 'voice-actor' = 'Bill Thompson'	disney
SELECT T1.movie_title, T1.song FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Ron Clements'	disney
SELECT T1.movie_title, T2.hero, T2.song FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title INNER JOIN director AS T3 ON T1.movie_title = T3.name WHERE T3.director = 'Wolfgang Reitherman' AND SUBSTR(T1.release_date, LENGTH(T1.release_date) - 3, LENGTH(T1.release_date)) = '1977'	disney
SELECT T1.movie_title, T2.director FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T1.hero = 'Donald Duck'	disney
SELECT T1.hero, T2.director, T1.release_date FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T1.movie_title = 'Mulan'	disney
SELECT T1.movie_title, T1.total_gross, T1.MPAA_rating FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title INNER JOIN director AS T3 ON T3.name = T1.movie_title WHERE T2.hero = 'Elsa'	disney
SELECT T1.movie, T3.director, T2.release_date FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title INNER JOIN director AS T3 ON T3.name = T2.movie_title WHERE T1.`voice-actor` = 'Freddie Jones'	disney
SELECT T1.movie_title, T1.total_gross FROM movies_total_gross AS T1 INNER JOIN `voice-actors` AS T2 ON T1.movie_title = T2.movie WHERE T2.`voice-actor` = 'Frank Welker' AND CAST(REPLACE(trim(T1.inflation_adjusted_gross, '$'), ',', '') AS REAL) * 1.0 / CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) * 1.0 < 2	disney
SELECT T2.director FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name ORDER BY CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T1.`voice-actor`, T2.villian FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title WHERE T2.movie_title = 'Cinderella'	disney
SELECT T1.`voice-actor` FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title WHERE T2.movie_title = 'Lion King' AND T1.character = 'Lion King'	disney
SELECT T2.director, T1.MPAA_rating FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T1.genre = 'Musical' AND SUBSTR(T1.release_date, LENGTH(T1.release_date) - 3, LENGTH(T1.release_date)) = '1993'	disney
SELECT CAST(COUNT(CASE WHEN T1.genre = 'Comedy' THEN T1.movie_title ELSE NULL END) AS REAL) * 100 / COUNT(T1.movie_title), group_concat(T1.movie_title), group_concat(T2.director) FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE SUBSTR(T1.release_date, LENGTH(T1.release_date) - 3, LENGTH(T1.release_date)) BETWEEN '1991' AND '2000'	disney
SELECT T2.name, T2.director FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE SUBSTR(T1.release_date, LENGTH(T1.release_date) - 3, LENGTH(T1.release_date)) BETWEEN '2001' AND '2005' AND CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) / ( SELECT SUM(CAST(REPLACE(trim(T3.total_gross, '$'), ',', '') AS REAL)) / COUNT(T3.movie_title) AS avg_gross FROM movies_total_gross AS T3 INNER JOIN director AS T4 ON T3.movie_title = T4.name WHERE SUBSTR(T3.release_date, LENGTH(T3.release_date) - 3, LENGTH(T3.release_date)) BETWEEN '2001' AND '2005' ) - 1 > 1	disney
SELECT `voice-actor` FROM `voice-actors` WHERE movie = 'Hercules' AND character = 'Calliope'	disney
SELECT COUNT('voice-actor') FROM `voice-actors` WHERE movie = 'Aladdin'	disney
SELECT movie FROM `voice-actors` WHERE 'voice-actor' = 'Jeff Bennett'	disney
SELECT director FROM director WHERE name = 'Wreck-It Ralph'	disney
SELECT name FROM director WHERE director = 'Jack Kinney'	disney
SELECT COUNT(movie_title) FROM characters WHERE SUBSTR(release_date, LENGTH(release_date) - 1, LENGTH(release_date)) BETWEEN '37' AND '50'	disney
SELECT T1.song FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Ben Sharpsteen'	disney
SELECT T1.release_date FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Roger Allers' AND T1.movie_title = 'The Lion King'	disney
SELECT T1.villian FROM characters AS T1 INNER JOIN `voice-actors` AS T2 ON T1.movie_title = T2.movie WHERE T2.`voice-actor` = 'Scott Weinger Brad Kane'	disney
SELECT T1.movie_title FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Wolfgang Reitherman' AND T1.villian IS NULL	disney
SELECT T1.movie_title FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Jack Kinney' AND SUBSTR(T1.release_date, LENGTH(T1.release_date) - 1, LENGTH(T1.release_date)) < '47'	disney
SELECT DISTINCT T2.director FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name INNER JOIN movies_total_gross AS T3 ON T1.movie_title = T3.movie_title WHERE CAST(REPLACE(trim(T3.total_gross, '$'), ',', '') AS REAL) > 100000000	disney
SELECT T2.song FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title ORDER BY CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T2.director FROM characters AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name INNER JOIN movies_total_gross AS T3 ON T3.movie_title = T1.movie_title WHERE SUBSTR(T3.release_date, LENGTH(T3.release_date) - 3, LENGTH(T3.release_date)) BETWEEN '1937' AND '1990' ORDER BY CAST(REPLACE(trim(T3.total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T2.hero FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title WHERE T1.genre = 'Comedy'	disney
SELECT T2.hero, T1.`voice-actor` FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title INNER JOIN director AS T3 ON T3.name = T2.movie_title WHERE T3.director = 'Wolfgang Reitherman'	disney
SELECT T1.genre FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title WHERE T2.hero = 'Taran'	disney
SELECT T1.`voice-actor`, T3.director FROM `voice-actors` AS T1 INNER JOIN characters AS T2 ON T1.movie = T2.movie_title INNER JOIN director AS T3 ON T2.movie_title = T3.name WHERE T2.hero = 'Elsa'	disney
SELECT CAST(COUNT(DISTINCT CASE WHEN CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) > 100000000 THEN T3.director ELSE NULL END) AS REAL) * 100 / COUNT(DISTINCT T3.director) FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title INNER JOIN director AS T3 ON T1.movie_title = T3.name	disney
SELECT CAST(COUNT(CASE WHEN T1.genre = 'Drama' THEN T3.`voice-actor` ELSE NULL END) AS REAL) * 100 / COUNT(T3.`voice-actor`) FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title INNER JOIN `voice-actors` AS T3 ON T3.movie = T1.movie_title	disney
SELECT movie_title FROM characters ORDER BY SUBSTR(release_date, LENGTH(release_date) - 1, LENGTH(release_date)) ASC LIMIT 1	disney
SELECT COUNT(movie_title) FROM characters WHERE SUBSTR(release_date, LENGTH(release_date) - 1, LENGTH(release_date)) BETWEEN '10' AND '16'	disney
SELECT villian FROM characters ORDER BY SUBSTR(release_date, LENGTH(release_date) - 1, LENGTH(release_date)) DESC LIMIT 1	disney
SELECT movie_title FROM movies_total_gross WHERE genre = 'Action' ORDER BY CAST(REPLACE(trim(total_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT `voice-actor` FROM `voice-actors` WHERE character = 'Akela'	disney
SELECT SUM(Total) FROM revenue WHERE `Year` BETWEEN 2010 AND 2016	disney
SELECT T2.hero FROM movies_total_gross AS T1 INNER JOIN characters AS T2 ON T1.movie_title = T2.movie_title WHERE T1.genre = 'Adventure' ORDER BY CAST(REPLACE(trim(T1.inflation_adjusted_gross, '$'), ',', '') AS REAL) DESC LIMIT 1	disney
SELECT T2.director FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name ORDER BY CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) ASC LIMIT 1	disney
SELECT SUM(`Walt Disney Parks and Resorts`) / SUM(Total) * 100 FROM revenue WHERE year = 2010	disney
SELECT SUM(CAST(REPLACE(trim(total_gross, '$'), ',', '') AS REAL)) / COUNT(movie_title) FROM movies_total_gross WHERE MPAA_rating = 'PG-13'	disney
SELECT COUNT(DISTINCT 'voice-actor') FROM `voice-actors` WHERE movie = 'Bambi'	disney
SELECT SUM(CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL)) / SUM(CAST(REPLACE(trim(total_gross, '$'), ',', '') AS REAL)) FROM movies_total_gross WHERE SUBSTR(release_date, LENGTH(release_date) - 3, LENGTH(release_date)) = '1995' GROUP BY SUBSTR(release_date, LENGTH(release_date) - 3, LENGTH(release_date)) = '1995'	disney
SELECT SUM(CASE WHEN movie_title = 'Cars' THEN CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL) ELSE 0 END), SUM(CASE WHEN movie_title = 'Cars 2' THEN CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL) ELSE 0 END) FROM movies_total_gross	disney
SELECT T1.movie_title, MAX(T1.release_date), MAX(T1.inflation_adjusted_gross) FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Chris Buck'	disney
SELECT 'voice-actor' FROM `voice-actors` GROUP BY 'voice-actor' HAVING COUNT(movie) > 5	disney
SELECT SUM(CASE WHEN CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL) > 1236035515 THEN CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL) ELSE 0 END) * 100 / SUM(CAST(REPLACE(trim(inflation_adjusted_gross, '$'), ',', '') AS REAL)) FROM movies_total_gross	disney
SELECT CAST(COUNT(CASE WHEN CAST(REPLACE(trim(T1.total_gross, '$'), ',', '') AS REAL) > 100000000 THEN T1.movie_title ELSE NULL END) AS REAL) * 100 / COUNT(T1.movie_title) FROM movies_total_gross AS T1 INNER JOIN director AS T2 ON T1.movie_title = T2.name WHERE T2.director = 'Gary Trousdale'	disney
SELECT COUNT(*) FROM current WHERE ballotpedia_id = '' OR ballotpedia_id IS NULL	legislator
SELECT official_full_name FROM current WHERE cspan_id IS NULL OR cspan_id = ''	legislator
SELECT COUNT(bioguide_id) FROM current WHERE birthday_bio >= '1961-01-01'	legislator
SELECT COUNT(*) FROM current WHERE (fec_id IS NULL OR fec_id = '') AND gender_bio = 'F'	legislator
SELECT google_entity_id_id FROM current WHERE official_full_name = 'Sherrod Brown'	legislator
SELECT official_full_name FROM current WHERE official_full_name = 'Sherrod Brown' OR official_full_name = 'Maria Cantwell' ORDER BY birthday_bio LIMIT 1	legislator
SELECT T1.facebook FROM `social-media` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.official_full_name = 'Todd Young'	legislator
SELECT COUNT(*) FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T1.instagram IS NULL	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T2.twitter_id = 234128524	legislator
SELECT T2.youtube FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.gender_bio = 'F'	legislator
SELECT T2.facebook FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id ORDER BY T1.birthday_bio LIMIT 1	legislator
SELECT SUM(CASE WHEN T1.instagram IS NULL THEN 1 ELSE 0 END) AS count FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T2.opensecrets_id IS NULL OR T2.opensecrets_id = ''	legislator
SELECT SUM(CASE WHEN T1.official_full_name = 'Roger F. Wicker' THEN 1 ELSE 0 END) AS count FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.district IS NULL OR T2.district = ''	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Sherrod Brown'	legislator
SELECT T2.official_full_name FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.state_rank IS NOT NULL	legislator
SELECT T1.state FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.start = '1993-01-05' AND T2.official_full_name = 'Sherrod Brown'	legislator
SELECT COUNT(CID) FROM ( SELECT T1.bioguide_id AS CID FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'F' GROUP BY T2.bioguide HAVING COUNT(T2.bioguide) > 4 )	legislator
SELECT COUNT(CID) FROM ( SELECT T1.bioguide_id AS CID FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.birthday_bio >= '1960-01-01' GROUP BY T2.bioguide HAVING COUNT(T2.bioguide) > 6 )	legislator
SELECT CAST(COUNT(T2.bioguide) AS REAL) / COUNT(DISTINCT T1.bioguide_id) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'F'	legislator
SELECT CAST(SUM(CASE WHEN T1.instagram IS NULL THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T2.religion_bio = 'Roman Catholic'	legislator
SELECT COUNT(*) FROM current WHERE gender_bio = 'M'	legislator
SELECT COUNT(*) FROM `current-terms` WHERE party = 'Republican'	legislator
SELECT COUNT(*) FROM `social-media` WHERE instagram IS NOT NULL AND instagram <> ''	legislator
SELECT COUNT(*) FROM historical WHERE gender_bio = 'F'	legislator
SELECT COUNT(*) FROM current WHERE religion_bio = 'Roman Catholic' AND gender_bio = 'M'	legislator
SELECT T1.party FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.first_name = 'Sherrod' AND T2.last_name = 'Brown' AND T1.start LIKE '%2005%'	legislator
SELECT T2.official_full_name FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.state_rank = 'senior' AND T1.type = 'sen' AND T1.start LIKE '2013%'	legislator
SELECT T2.youtube FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.official_full_name = 'Chris Van Hollen'	legislator
SELECT CASE WHEN T1.facebook IS NOT NULL THEN 1 END + CASE WHEN T1.instagram IS NOT NULL THEN 1 END + CASE WHEN T1.twitter IS NOT NULL THEN 1 END + CASE WHEN T1.youtube IS NOT NULL THEN 1 END AS COUNTSOCIAL FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T2.first_name = 'Mark' AND T2.last_name = 'Warner'	legislator
SELECT T1.last_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.state = 'CA' GROUP BY T1.last_name	legislator
SELECT T2.first_name, T2.last_name FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.type = 'sen' AND T2.gender_bio = 'F' GROUP BY T2.ballotpedia_id	legislator
SELECT T2.govtrack FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.official_full_name = 'Chris Van Hollen'	legislator
SELECT T2.twitter FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.official_full_name = 'Roger F. Wicker'	legislator
SELECT T1.first_name, T1.last_name FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Pro-Administration' AND CAST(T2.start AS DATE) <= 1791 AND CAST(T2.END AS DATE) >= 1791	legislator
SELECT T1.first_name, T1.last_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Republican' AND T1.gender_bio = 'F' AND T2.END > DATE() GROUP BY T1.bioguide_id	legislator
SELECT T2.district FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Chris Van Hollen' AND T2.district IS NOT NULL GROUP BY T2.district	legislator
SELECT SUM(CASE WHEN T2.district = 20 THEN 1 ELSE 0 END) AS count FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name = 'Richard' AND T1.last_name = 'Durbin'	legislator
SELECT CAST(COUNT(T1.bioguide_id) AS REAL) / 22 FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'M' AND CAST(T2.start AS DATE) >= 2000 AND CAST(T2.END AS DATE) <= 2021 AND T2.party = 'Democrat'	legislator
SELECT CAST(COUNT(CASE WHEN current.gender_bio = 'F' THEN current.bioguide_id ELSE NULL END) AS REAL) * 100 / ( SELECT COUNT(CASE WHEN historical.gender_bio = 'F' THEN historical.bioguide_id ELSE NULL END) FROM historical ) FROM current	legislator
SELECT youtube_id FROM `social-media` WHERE youtube = 'RepWassermanSchultz'	legislator
SELECT T2.facebook FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.official_full_name = 'Adam Kinzinger'	legislator
SELECT T1.party FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.first_name OR T2.middle_name OR T2.last_name = 'ChristopherHendersonClark'	legislator
SELECT T2.official_full_name FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T1.facebook IS NOT NULL AND (T1.instagram IS NULL OR T1.instagram = '') LIMIT 10	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.state = 'VA' GROUP BY T1.official_full_name	legislator
SELECT T2.first_name, T2.last_name FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.party = 'National Greenbacker'	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T2.youtube = 'RoskamIL06'	legislator
SELECT T2.official_full_name FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE (T1.youtube IS NULL OR T1.youtube = '') AND (T1.instagram IS NULL OR T1.instagram = '') AND (T1.twitter IS NULL OR T1.twitter = '') AND T1.facebook IS NOT NULL AND T1.facebook != ''	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Republican' AND T2.state_rank = 'junior' GROUP BY T1.official_full_name	legislator
SELECT T2.contact_form FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Claire McCaskill' GROUP BY T2.contact_form	legislator
SELECT T2.wikipedia_id FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.party = 'Readjuster Democrat'	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Republican' AND T1.nickname_name IS NOT NULL GROUP BY T1.official_full_name	legislator
SELECT T2.state, T2.party FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name OR T1.middle_name OR T1.last_name = 'VeronicaGraceBoland'	legislator
SELECT COUNT(*) FROM historical WHERE CAST(birthday_bio AS date) = 1973	legislator
SELECT CAST(SUM(CASE WHEN gender_bio = 'M' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN gender_bio = 'F' THEN 1 ELSE 0 END) FROM historical	legislator
SELECT `END`, party FROM `current-terms` WHERE STRFTIME('%Y', `END`) = '2009' AND party = 'Republican'	legislator
SELECT official_full_name, gender_bio FROM current WHERE last_name = 'Collins'	legislator
SELECT CAST(SUM(CASE WHEN class = 1 THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM `historical-terms` WHERE type = 'sen'	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Independent' GROUP BY T1.official_full_name	legislator
SELECT SUM(CAST(T2.END - T2.start AS DATE)) AS sum FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'John Conyers, Jr.'	legislator
SELECT CAST(MIN(T2.start) - T1.birthday_bio AS DATE) AS AGE FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'F. James Sensenbrenner, Jr.'	legislator
SELECT T1.official_full_name, T2.relation, T2.party FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.state = 'ME' GROUP BY T1.official_full_name, T2.relation, T2.party	legislator
SELECT T1.official_full_name, T1.nickname_name FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T2.instagram IS NOT NULL AND T1.thomas_id < 1000	legislator
SELECT T1.END FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.official_full_name = 'Matt Salmon'	legislator
SELECT T1.party, T1.state FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.house_history_id IS NOT NULL AND T2.birthday_bio LIKE '%1738%'	legislator
SELECT T2.bioguide_id, T2.first_name, T2.last_name FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.party = 'Liberal Republican'	legislator
SELECT COUNT(T1.bioguide_id) FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'M' AND T2.start = '1793-12-02'	legislator
SELECT SUM(CASE WHEN `current-terms`.start LIKE '2005%' THEN 1 ELSE 0 END) - ( SELECT SUM(CASE WHEN start LIKE '1875%' THEN 1 ELSE 0 END) FROM `historical-terms` ) FROM `current-terms`	legislator
SELECT T2.official_full_name, T1.twitter_id, T1.youtube_id FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T2.first_name = 'Richard'	legislator
SELECT T2.start, T2.`end`, T2.party FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name = 'Pearl' AND T1.middle_name = 'Peden' AND T1.last_name = 'Oldfield'	legislator
SELECT birthday_bio FROM current WHERE first_name = 'Amy' AND last_name = 'Klobuchar'	legislator
SELECT COUNT(*) FROM current WHERE fec_id IS NULL OR fec_id = ''	legislator
SELECT COUNT(*) FROM current WHERE gender_bio = 'F'	legislator
SELECT COUNT(*) FROM current WHERE opensecrets_id IS NOT NULL AND opensecrets_id <> ''	legislator
SELECT middle_name FROM current WHERE birthday_bio = '1956-08-24'	legislator
SELECT COUNT(bioguide) FROM `current-terms` WHERE title = 'Majority Leader'	legislator
SELECT T2.title FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.birthday_bio = '1942-02-20' GROUP BY T2.title	legislator
SELECT T1.gender_bio FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.address = '317 Russell Senate Office Building Washington DC 20510'	legislator
SELECT T1.first_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.state_rank = 'senior' GROUP BY T1.first_name	legislator
SELECT COUNT(T3.state) FROM ( SELECT T2.state FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'M' AND (T2.class IS NULL OR T2.class = '') GROUP BY T2.state ) T3	legislator
SELECT CAST(SUM(CASE WHEN T2.class IS NOT NULL THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.birthday_bio LIKE '%1964%'	legislator
SELECT CAST(COUNT(CASE WHEN T2.class IS NULL THEN T1.bioguide_id ELSE NULL END) AS REAL) * 100 / COUNT(T1.bioguide_id) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE CAST(T1.birthday_bio AS DATE) <= 1975	legislator
SELECT T2.twitter FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.birthday_bio = '1946-05-27'	legislator
SELECT T1.opensecrets_id FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T2.youtube = 'BLuetkemeyer'	legislator
SELECT T2.facebook FROM current AS T1 INNER JOIN `social-media` AS T2 ON T2.bioguide = T1.bioguide_id WHERE T1.first_name = 'Ralph' AND T1.last_name = 'Abraham'	legislator
SELECT T1.first_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.address = '1005 Longworth HOB Washington DC 20515-1408' GROUP BY T1.first_name	legislator
SELECT T1.instagram FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T2.birthday_bio = '1952-08-24'	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'F' AND (T2.class IS NULL OR T2.class = '')	legislator
SELECT T2.religion_bio FROM `social-media` AS T1 INNER JOIN current AS T2 ON T1.bioguide = T2.bioguide_id WHERE T1.youtube = 'MaxineWaters'	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.title = 'Minority Leader' AND (T1.fec_id IS NULL OR T1.fec_id = '')	legislator
SELECT COUNT(*) FROM current WHERE gender_bio = 'M'	legislator
SELECT facebook_id FROM `social-media` WHERE facebook = 'RepWilson'	legislator
SELECT COUNT(*) FROM current WHERE first_name = 'John'	legislator
SELECT district FROM `historical-terms` WHERE party = 'Anti-Administration' GROUP BY district	legislator
SELECT official_full_name FROM current WHERE birthday_bio LIKE '1960%'	legislator
SELECT google_entity_id_id FROM historical WHERE first_name = 'Benjamin' AND last_name = 'Hawkins'	legislator
SELECT T1.first_name, T1.last_name FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Pro-Administration' AND T2.start = '1789-03-04' AND T2.end = '1791-12-31'	legislator
SELECT T2.first_name, T2.last_name FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide WHERE T1.district = 9	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Independent' GROUP BY T1.official_full_name	legislator
SELECT T1.opensecrets_id, T1.thomas_id FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.type = 'sen' AND T2.state = 'NJ' GROUP BY T1.opensecrets_id, T1.thomas_id	legislator
SELECT T1.google_entity_id_id FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.type = 'sen' AND T2.state = 'NY'	legislator
SELECT T1.religion_bio FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.rss_url = 'http://www.corker.senate.gov/public/index.cfm/rss/feed' GROUP BY T1.religion_bio	legislator
SELECT T2.party FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Susan M. Collins' GROUP BY T2.party	legislator
SELECT T2.district FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.last_name = 'Grout' AND T1.first_name = 'Jonathan' AND T2.type = 'rep'	legislator
SELECT T2.party, T2.state FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.opensecrets_id = 'N00003689' AND T1.thomas_id = 186 GROUP BY T2.party, T2.state	legislator
SELECT T1.official_full_name, T1.birthday_bio FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.contact_form = 'http://www.brown.senate.gov/contact/'	legislator
SELECT T2.state, T2.type FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.google_entity_id_id = 'kg:/m/02pyzk'	legislator
SELECT T2.type, T2.end FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name = 'John' AND T1.last_name = 'Vining'	legislator
SELECT SUM(CASE WHEN T2.type = 'sen' THEN 1 ELSE 0 END) - SUM(CASE WHEN T2.type = 'rep' THEN 1 ELSE 0 END) FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'F' AND strftime('%Y', T1.birthday_bio) BETWEEN '1930' AND '1970'	legislator
SELECT CAST(SUM(CASE WHEN T2.party = 'Independent' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.party) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'M' AND strftime('%Y', T1.birthday_bio) BETWEEN '1955' AND '1965'	legislator
SELECT first_name, last_name FROM historical WHERE bioguide_id = 'W000059'	legislator
SELECT CASE WHEN ballotpedia_id IS NULL THEN 'doesn''t have' ELSE 'have' END AS HaveorNot FROM historical WHERE first_name = 'Thomas' AND last_name = 'Carnes'	legislator
SELECT COUNT(bioguide_id) FROM historical WHERE birthday_bio LIKE '1736%'	legislator
SELECT first_name, last_name FROM historical WHERE gender_bio = 'F'	legislator
SELECT COUNT(district) FROM `current-terms` WHERE state = 'ID'	legislator
SELECT COUNT(bioguide) FROM `current-terms` WHERE class IS NULL	legislator
SELECT CAST(SUM(CASE WHEN gender_bio = 'M' THEN 1 ELSE 0 END) AS REAL) / SUM(CASE WHEN gender_bio = 'F' THEN 1 ELSE 0 END) FROM historical	legislator
SELECT CAST(SUM(CASE WHEN wikipedia_id IS NOT NULL THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(bioguide_id) FROM historical	legislator
SELECT T1.first_name, T1.last_name FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.instagram IS NULL	legislator
SELECT T2.district, T2.state FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.start LIKE '1789%'	legislator
SELECT T2.district FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name = 'Benjamin' AND T1.last_name = 'Contee'	legislator
SELECT T2.address FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name = 'Amy' AND T1.last_name = 'Klobuchar' AND T2.start = '2001-04-01'	legislator
SELECT T1.first_name, T1.last_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.start LIKE '1997%' AND T2.state_rank = 'junior'	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE STRFTIME('%Y', T2.start) = '2015' AND T2.state = 'CA' AND T1.gender_bio = 'F'	legislator
SELECT T1.twitter_id FROM `social-media` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.first_name = 'Emanuel' AND T2.last_name = 'Cleaver'	legislator
SELECT T2.facebook_id FROM `current-terms` AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide = T2.bioguide WHERE T1.party = 'Democrat' GROUP BY T2.facebook_id	legislator
SELECT T1.first_name, T1.last_name FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.end = '1791-03-03' AND T1.gender_bio = 'F'	legislator
SELECT T1.first_name, T1.last_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.religion_bio = 'Jewish' AND T2.state = 'FL' GROUP BY T1.first_name, T1.last_name	legislator
SELECT CAST(COUNT(CASE WHEN wikipedia_id IS NOT NULL THEN bioguide_id ELSE 0 END) AS REAL) * 100 / ( SELECT COUNT(CASE WHEN wikipedia_id IS NOT NULL THEN bioguide_id ELSE 0 END) FROM historical ) FROM current	legislator
SELECT CAST(SUM(CASE WHEN strftime('%Y', T2.start) BETWEEN '2000' AND '2017' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T1.bioguide_id) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide	legislator
SELECT COUNT(bioguide_id) FROM historical WHERE religion_bio = 'Catholic' AND ballotpedia_id IS NULL	legislator
SELECT COUNT(bioguide) FROM `current-terms` WHERE class = 1 AND party = 'Republican'	legislator
SELECT first_name, last_name FROM historical WHERE gender_bio = 'F' AND google_entity_id_id IS NULL AND fec_id IS NULL	legislator
SELECT COUNT(*) FROM `current-terms` WHERE state = 'CA' AND type = 'rep' AND end LIKE '1995%'	legislator
SELECT first_name, last_name FROM historical ORDER BY birthday_bio LIMIT 1	legislator
SELECT bioguide FROM `current-terms` WHERE type = 'rep' AND party = 'Democrat' AND end = '2019-01-03' AND district = 13	legislator
SELECT T2.twitter FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Jason Lewis'	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.party = 'Independent' AND strftime('%Y', T2.start) >= '2011' AND T2.type = 'sen' AND T2.caucus = 'Democrat'	legislator
SELECT COUNT(T3.bioguide_id) FROM ( SELECT T1.bioguide_id FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.facebook IS NULL GROUP BY T1.bioguide_id ) T3	legislator
SELECT T2.party FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.religion_bio = 'Baptist' GROUP BY T2.party ORDER BY COUNT(T2.party) DESC LIMIT 1	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.facebook IS NOT NULL AND T2.instagram IS NOT NULL AND T2.twitter IS NOT NULL AND T2.youtube IS NOT NULL	legislator
SELECT COUNT(T3.district) FROM ( SELECT T2.district FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'John Conyers, Jr.' GROUP BY T2.district ) T3	legislator
SELECT T1.wikipedia_id FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.type = 'sen' AND T2.party = 'Anti-Administration'	legislator
SELECT DISTINCT CASE WHEN SUM(CAST(strftime('%Y', T2.end) AS int) - CAST(strftime('%Y', T2.start) AS int)) = 26 THEN T1.official_full_name END FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide GROUP BY T1.official_full_name, T2.district HAVING COUNT(T1.official_full_name) = 13	legislator
SELECT COUNT(T.bioguide_id) FROM ( SELECT T1.bioguide_id FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.first_name = 'Benjamin' AND T2.party = 'Federalist' AND T2.type = 'rep' GROUP BY T1.bioguide_id ) AS T	legislator
SELECT SUM(T3.result) FROM ( SELECT CASE WHEN SUM(CAST(strftime('%Y', T2.`end`) AS int) - CAST(strftime('%Y', T2.start) AS int)) > 10 THEN 1 ELSE 0 END AS result FROM current AS T1 INNER JOIN "current-terms" AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.gender_bio = 'F' AND T2.state = 'CA' AND T2.type = 'rep' ) AS T3	legislator
SELECT T1.party FROM `historical-terms` AS T1 INNER JOIN historical AS T2 ON T2.bioguide_id = T1.bioguide ORDER BY T2.birthday_bio LIMIT 1	legislator
SELECT CASE WHEN SUM(CAST(strftime('%Y', T2.end) AS int) - CAST(strftime('%Y', T2.start) AS int)) = 14 THEN official_full_name END FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.religion_bio = 'Lutheran' AND T2.state = 'OH' AND T2.type = 'rep'	legislator
SELECT COUNT(*) FROM current WHERE strftime('%Y', birthday_bio) > '1960' AND google_entity_id_id IS NULL	legislator
SELECT official_full_name FROM current WHERE house_history_id IS NOT NULL	legislator
SELECT COUNT(*) FROM current WHERE icpsr_id IS NOT NULL AND maplight_id IS NOT NULL	legislator
SELECT COUNT(lis_id) FROM current WHERE gender_bio = 'F' AND lis_id IS NOT NULL	legislator
SELECT religion_bio FROM current WHERE official_full_name = 'Sherrod Brown'	legislator
SELECT religion_bio FROM current GROUP BY religion_bio ORDER BY COUNT(religion_bio) DESC LIMIT 1	legislator
SELECT T2.instagram FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Bob Corker'	legislator
SELECT COUNT(DISTINCT T1.bioguide_id) FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.thomas_id IS NOT NULL AND T2.instagram IS NOT NULL	legislator
SELECT T2.facebook FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.wikipedia_id IS NOT NULL GROUP BY T2.facebook	legislator
SELECT COUNT(T2.bioguide) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.birthday_bio = ( SELECT MIN(birthday_bio) FROM current )	legislator
SELECT T1.phone FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.official_full_name = 'Sherrod Brown' AND T1.start = '2013-01-03'	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Sherrod Brown' AND T2.party = 'Democrat'	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.start = '2013-01-03'	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.start = '2013-01-03' AND T1.gender_bio = 'F'	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide GROUP BY T1.official_full_name, T2.bioguide ORDER BY COUNT(T2.bioguide) DESC LIMIT 1	legislator
SELECT COUNT(*) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Sherrod Brown' AND T2.district = 13	legislator
SELECT T1.official_full_name FROM current AS T1 INNER JOIN `social-media` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.facebook = 'senjoniernst'	legislator
SELECT CASE WHEN SUM(CASE WHEN T1.official_full_name = 'Maria Cantwell' THEN 1 ELSE 0 END) > SUM(CASE WHEN T1.official_full_name = 'Sherrod Brown' THEN 1 ELSE 0 END) THEN 'Maria Cantwell' ELSE 'Sherrod Brown' END FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide	legislator
SELECT CAST(SUM(CASE WHEN gender_bio = 'F' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T3.bioguide) FROM ( SELECT T2.bioguide, T1.gender_bio FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide GROUP BY T2.bioguide HAVING COUNT(T2.bioguide) > 4 ) T3	legislator
SELECT CAST(COUNT(T2.bioguide) AS REAL) / COUNT(DISTINCT T1.bioguide_id) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.wikipedia_id IS NOT NULL	legislator
SELECT COUNT(gender_bio) FROM current WHERE gender_bio = 'F'	legislator
SELECT COUNT(type) FROM `historical-terms` WHERE state = 'NJ' AND type = 'rep'	legislator
SELECT address FROM `current-terms` WHERE contact_form = 'http://www.carper.senate.gov/contact/'	legislator
SELECT T1.instagram FROM `social-media` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.first_name = 'Benjamin' AND T2.last_name = 'Hawkins'	legislator
SELECT T1.bioguide FROM `current-terms` AS T1 INNER JOIN current AS T2 ON T2.bioguide_id = T1.bioguide WHERE T2.religion_bio = 'Catholic' AND T1.state = 'NE'	legislator
SELECT T1.maplight_id FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.type = 'rep' AND T2.state = 'ME' GROUP BY T1.maplight_id	legislator
SELECT T2.type, T2.start FROM historical AS T1 INNER JOIN `historical-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.birthday_bio = '1727-11-26'	legislator
SELECT T2.contact_form FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T1.official_full_name = 'Rick Crawford'	legislator
SELECT COUNT(T.bioguide_id) FROM ( SELECT T1.bioguide_id FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.type = 'rep' AND T2.state = 'MI' AND T1.gender_bio = 'F' GROUP BY T1.bioguide_id ) T	legislator
SELECT CAST(SUM(CASE WHEN T2.type = 'sen' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(T2.type) FROM current AS T1 INNER JOIN `current-terms` AS T2 ON T1.bioguide_id = T2.bioguide WHERE T2.state = 'ME' AND T1.gender_bio = 'F'	legislator
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'John Aalberg'	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'John Aalberg' AND T2.age = 31	olympics
SELECT T2.age FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'John Aalberg' AND T1.games_name = '1994 Winter'	olympics
SELECT COUNT(T1.person_id) FROM person_region AS T1 INNER JOIN noc_region AS T2 ON T1.region_id = T2.id WHERE T2.region_name = 'Finland'	olympics
SELECT T3.full_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Finland'	olympics
SELECT T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'John Aalberg'	olympics
SELECT T1.noc FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.gender = 'M' ORDER BY T3.height DESC LIMIT 1	olympics
SELECT COUNT(T3.id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Finland' AND T3.gender = 'F'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name = '1992 Summer'	olympics
SELECT T3.games_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'London'	olympics
SELECT T3.games_year FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'London' ORDER BY T3.games_year LIMIT 1	olympics
SELECT COUNT(T1.games_id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id WHERE T2.city_name = 'London'	olympics
SELECT AVG(T3.height) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Finland' AND T3.gender = 'M'	olympics
SELECT CAST(COUNT(CASE WHEN T5.region_name = 'Finland' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T3.id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id INNER JOIN person_region AS T4 ON T3.id = T4.person_id INNER JOIN noc_region AS T5 ON T4.region_id = T5.id WHERE T1.games_name = '1994 Winter'	olympics
SELECT T1.sport_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T2.event_name LIKE 'Shooting Women%s Trap'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name = '1936 Winter'	olympics
SELECT COUNT(T3.id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'London'	olympics
SELECT COUNT(T2.event_name) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Swimming'	olympics
SELECT T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Peter Kohnke'	olympics
SELECT T2.games_id FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T1.full_name = 'Jessica Carolina Aguilera Aguilera'	olympics
SELECT T1.sport_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id GROUP BY T1.sport_name ORDER BY COUNT(T2.event_name) DESC LIMIT 1	olympics
SELECT T3.full_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Sweden' ORDER BY T3.height DESC LIMIT 1	olympics
SELECT COUNT(T1.person_id) FROM person_region AS T1 INNER JOIN noc_region AS T2 ON T1.region_id = T2.id WHERE T2.region_name = 'Guatemala'	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id GROUP BY T2.person_id ORDER BY COUNT(T2.person_id) DESC LIMIT 1	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T2.id = 90991	olympics
SELECT COUNT(T2.id) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T1.full_name = 'Martina Kohlov'	olympics
SELECT CAST(T1.weight AS REAL) / (T1.height * T1.height) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T2.id = 147420	olympics
SELECT CAST(COUNT(CASE WHEN T3.gender = 'M' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Estonia'	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id ORDER BY T2.age LIMIT 1	olympics
SELECT COUNT(T2.person_id) FROM competitor_event AS T1 INNER JOIN games_competitor AS T2 ON T1.competitor_id = T2.id INNER JOIN event AS T3 ON T1.event_id = T3.id WHERE T3.event_name LIKE 'Basketball Men%s Basketball' AND T2.age = 24	olympics
SELECT T2.event_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Art Competitions'	olympics
SELECT COUNT(T1.id) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN medal AS T4 ON T3.medal_id = T4.id WHERE T1.full_name = 'Henk Jan Zwolle' AND T4.medal_name = 'Gold'	olympics
SELECT T2.event_name FROM competitor_event AS T1 INNER JOIN event AS T2 ON T1.event_id = T2.id INNER JOIN medal AS T3 ON T1.medal_id = T3.id WHERE T3.medal_name = 'Gold' GROUP BY T2.id ORDER BY COUNT(T1.event_id) DESC LIMIT 1	olympics
SELECT COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id WHERE T1.region_name = 'Australia'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id GROUP BY T2.id HAVING COUNT(T1.games_id) >= 3	olympics
SELECT COUNT(T3.id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'Stockholm' AND T3.season = 'Summer'	olympics
SELECT T2.region_name FROM person_region AS T1 INNER JOIN noc_region AS T2 ON T1.region_id = T2.id GROUP BY T2.region_name ORDER BY COUNT(T1.person_id) DESC LIMIT 1	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id ORDER BY T3.games_year LIMIT 1	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id ORDER BY T2.age LIMIT 1	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '1928 Summer'	olympics
SELECT COUNT(T3.event_id) , CAST(COUNT(CASE WHEN T4.id = '1' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T4.id) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN medal AS T4 ON T3.medal_id = T4.id WHERE T1.full_name = 'Michael Fred Phelps, II'	olympics
SELECT P1 , ( SELECT MAX(P2) - MIN(P2) FROM ( SELECT COUNT(T2.person_id) AS P2 FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name IN ('1988 Winter', '1988 Summer') GROUP BY T1.season ) ORDER BY P2 DESC LIMIT 1 ) FROM ( SELECT T1.season AS P1, COUNT(T2.person_id) AS P2 FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name IN ('1988 Winter', '1988 Summer') GROUP BY T1.season ) ORDER BY P2 DESC LIMIT 1	olympics
SELECT age FROM games_competitor GROUP BY age ORDER BY COUNT(person_id) DESC LIMIT 1	olympics
SELECT city_name FROM city WHERE city_name LIKE 'M%'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name IN ('1976 Summer', '1976 Winter')	olympics
SELECT T4.medal_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN medal AS T4 ON T3.medal_id = T4.id WHERE T1.full_name = 'Coleen Dufresne (-Stewner)'	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN medal AS T4 ON T3.medal_id = T4.id WHERE T4.id != 4 GROUP BY T1.full_name ORDER BY COUNT(T4.id) DESC LIMIT 1	olympics
SELECT T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Estelle Nze Minko'	olympics
SELECT DISTINCT T1.sport_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id INNER JOIN competitor_event AS T3 ON T2.id = T3.event_id INNER JOIN games_competitor AS T4 ON T3.competitor_id = T4.id INNER JOIN person AS T5 ON T4.person_id = T5.id WHERE T5.full_name = 'Chin Eei Hui'	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id ORDER BY T2.age DESC LIMIT 1	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.gender = 'F' GROUP BY T1.games_name ORDER BY COUNT(T2.person_id) DESC LIMIT 1	olympics
SELECT COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Belgium' AND T3.gender = 'M'	olympics
SELECT COUNT(T1.person_id) FROM games_competitor AS T1 INNER JOIN games_city AS T2 ON T1.games_id = T2.games_id INNER JOIN city AS T3 ON T2.city_id = T3.id WHERE T3.city_name = 'Sapporo'	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Morten Aleksander Djupvik'	olympics
SELECT COUNT(T1.competitor_id) FROM competitor_event AS T1 INNER JOIN event AS T2 ON T1.event_id = T2.id INNER JOIN sport AS T3 ON T2.sport_id = T3.id WHERE T2.event_name = 'Sailing Mixed 12 metres'	olympics
SELECT COUNT(DISTINCT T2.event_name) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Modern Pentathlon'	olympics
SELECT CAST(COUNT(CASE WHEN T1.gender = 'F' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.id) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN event AS T4 ON T3.event_id = T4.id WHERE T4.event_name = 'Equestrianism Mixed Three-Day Event, Individual'	olympics
SELECT AVG(T2.age) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '1992 Summer'	olympics
SELECT games_year FROM games WHERE season != 'Winter' GROUP BY games_year HAVING COUNT(season) = 1	olympics
SELECT COUNT(games_year) FROM games WHERE games_year BETWEEN '1990' AND '1999'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '2014 Winter'	olympics
SELECT COUNT(T3.person_id) FROM competitor_event AS T1 INNER JOIN games_competitor AS T2 ON T1.competitor_id = T2.id INNER JOIN person_region AS T3 ON T2.person_id = T3.person_id WHERE T3.region_id = 151 AND T1.medal_id != 4	olympics
SELECT COUNT(T3.id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id INNER JOIN person_region AS T4 ON T3.id = T4.person_id INNER JOIN noc_region AS T5 ON T4.region_id = T5.id WHERE T1.games_name = '2016 Summer' AND T5.region_name = 'China'	olympics
SELECT COUNT(T2.competitor_id) FROM event AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.event_id WHERE T1.event_name LIKE 'Ice Hockey Men%s Ice Hockey' AND T2.medal_id = 1	olympics
SELECT T5.region_name FROM medal AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.medal_id INNER JOIN games_competitor AS T3 ON T2.competitor_id = T3.id INNER JOIN person_region AS T4 ON T3.person_id = T4.person_id INNER JOIN noc_region AS T5 ON T4.region_id = T5.id WHERE T1.id != 4 GROUP BY T5.region_name ORDER BY COUNT(T2.competitor_id) DESC LIMIT 1	olympics
SELECT DISTINCT T5.full_name FROM event AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.event_id INNER JOIN games_competitor AS T3 ON T2.competitor_id = T3.id INNER JOIN sport AS T4 ON T1.sport_id = T4.id INNER JOIN person AS T5 ON T3.person_id = T5.id WHERE T4.sport_name = 'Cycling' AND T2.medal_id = 1	olympics
SELECT DISTINCT T1.medal_name FROM medal AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.medal_id INNER JOIN games_competitor AS T3 ON T2.competitor_id = T3.id INNER JOIN person AS T4 ON T3.person_id = T4.id WHERE T4.full_name = 'Lee Chong Wei' AND T2.medal_id <> 4	olympics
SELECT CAST(COUNT(CASE WHEN T3.gender = 'F' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '2002 Winter' AND T2.age < 20	olympics
SELECT CAST(COUNT(CASE WHEN T3.gender = 'M' THEN 1 ELSE NULL END) AS REAL) / COUNT(CASE WHEN T3.gender = 'F' THEN 1 ELSE NULL END) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '2012 Summer'	olympics
SELECT ( SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.season = 'Summer' GROUP BY T1.games_year ORDER BY COUNT(T2.person_id) DESC LIMIT 1 ) AS HIGHEST , ( SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.season = 'Summer' GROUP BY T1.games_year ORDER BY COUNT(T2.person_id) LIMIT 1 ) AS LOWEST	olympics
SELECT COUNT(T3.person_id) FROM medal AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.medal_id INNER JOIN games_competitor AS T3 ON T2.competitor_id = T3.id INNER JOIN person_region AS T4 ON T3.person_id = T4.person_id INNER JOIN noc_region AS T5 ON T4.region_id = T5.id WHERE T5.region_name = 'Malaysia' AND T1.id != 4	olympics
SELECT COUNT(T5.id) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id INNER JOIN competitor_event AS T3 ON T2.id = T3.event_id INNER JOIN games_competitor AS T4 ON T3.competitor_id = T4.id INNER JOIN person AS T5 ON T4.person_id = T5.id INNER JOIN games AS T6 ON T4.games_id = T6.id WHERE T1.sport_name = 'Canoeing' AND T6.games_name = '2008 Summer' AND T5.weight * 10000.0 / (T5.height * T5.height) BETWEEN 25.0 AND 30	olympics
SELECT AVG(T5.height) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id INNER JOIN competitor_event AS T3 ON T2.id = T3.event_id INNER JOIN games_competitor AS T4 ON T3.competitor_id = T4.id INNER JOIN person AS T5 ON T4.person_id = T5.id WHERE T1.sport_name = 'Basketball' AND T5.gender = 'M'	olympics
SELECT COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Philippines' AND T3.gender = 'F'	olympics
SELECT T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Yao Ming'	olympics
SELECT T2.age FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T1.full_name = 'Michael Fred Phelps, II' ORDER BY T2.age LIMIT 1	olympics
SELECT COUNT(person_id) FROM person_region WHERE region_id = ( SELECT T1.region_id FROM person_region AS T1 INNER JOIN person AS T2 ON T1.person_id = T2.id WHERE T2.full_name = 'Clara Hughes' )	olympics
SELECT COUNT(T1.id) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN event AS T4 ON T3.event_id = T4.id WHERE T1.full_name = 'Ian James Thorpe' AND T4.event_name LIKE 'Swimming Men%s 200 metres Freestyle'	olympics
SELECT COUNT(T1.id) FROM event AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.event_id INNER JOIN games_competitor AS T3 ON T2.competitor_id = T3.id INNER JOIN person AS T4 ON T3.person_id = T4.id WHERE T4.full_name = 'Larysa Semenivna Latynina (Diriy-)' AND T1.event_name LIKE 'Gymnastics Women%s Individual All-Around' AND T2.medal_id = 1	olympics
SELECT T4.city_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN games_city AS T3 ON T2.games_id = T3.games_id INNER JOIN city AS T4 ON T3.city_id = T4.id WHERE T1.full_name = 'Carl Lewis Borack'	olympics
SELECT COUNT(T1.games_id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id WHERE T2.city_name = 'London'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name = '1992 Summer'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '2016 Summer' AND T2.age > 59	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN games_city AS T3 ON T2.games_id = T3.games_id INNER JOIN city AS T4 ON T3.city_id = T4.id WHERE T4.city_name = 'Los Angeles' GROUP BY T1.id ORDER BY COUNT(T2.person_id) DESC LIMIT 1	olympics
SELECT COUNT(T2.person_id) FROM competitor_event AS T1 INNER JOIN games_competitor AS T2 ON T1.competitor_id = T2.id INNER JOIN event AS T3 ON T1.event_id = T3.id WHERE T3.event_name LIKE 'Gymnastics Men%s Parallel Bars, Teams' AND T2.age = 10	olympics
SELECT AVG(T2.age) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person_region AS T3 ON T2.person_id = T3.person_id INNER JOIN noc_region AS T4 ON T3.region_id = T4.id WHERE T1.games_name = '2016 Summer' AND T4.region_name = 'USA'	olympics
SELECT region_name FROM noc_region WHERE noc = 'COL'	olympics
SELECT sport_name FROM sport WHERE id = 19	olympics
SELECT id FROM event WHERE event_name = 'Shooting Mixed Skeet'	olympics
SELECT id FROM sport WHERE sport_name = 'Hockey'	olympics
SELECT weight FROM person WHERE full_name = 'Dagfinn Sverre Aarskog'	olympics
SELECT id FROM city WHERE city_name = 'Rio de Janeiro'	olympics
SELECT COUNT(T1.competitor_id) FROM competitor_event AS T1 INNER JOIN event AS T2 ON T1.event_id = T2.id INNER JOIN medal AS T3 ON T1.medal_id = T3.id WHERE T2.event_name LIKE 'Rowing Women%s Coxed Eights' AND T3.medal_name = 'Gold'	olympics
SELECT COUNT(T2.event_name) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Cycling'	olympics
SELECT T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Vijay Singh Chauhan'	olympics
SELECT T3.games_year FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'Roma'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '1984 Summer' AND T2.age = 20	olympics
SELECT COUNT(T2.games_id) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T1.full_name = 'Prithipal Singh'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '1984 Summer' AND T2.age > 50	olympics
SELECT COUNT(T2.event_name) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Athletics'	olympics
SELECT T3.full_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Russia' ORDER BY T3.weight DESC LIMIT 1	olympics
SELECT T3.height FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Portugal' ORDER BY T3.height DESC LIMIT 1	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name = '1968 Winter'	olympics
SELECT T2.region_name FROM person_region AS T1 INNER JOIN noc_region AS T2 ON T1.region_id = T2.id GROUP BY T2.region_name ORDER BY COUNT(T1.person_id) DESC LIMIT 1	olympics
SELECT CAST(COUNT(CASE WHEN T3.height > 175 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Vanuatu'	olympics
SELECT AVG(T3.weight) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Tonga' AND T3.gender = 'M'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name = '1920 Summer'	olympics
SELECT COUNT(T3.id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'London' AND T3.games_year BETWEEN 1900 AND 1992	olympics
SELECT COUNT(T3.id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'Paris' AND T3.season = 'Summer'	olympics
SELECT T3.games_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'Los Angeles'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id GROUP BY T2.city_name ORDER BY COUNT(T2.city_name) DESC LIMIT 1	olympics
SELECT T3.games_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'Beijing' AND T3.games_year = 2008	olympics
SELECT CAST(COUNT(CASE WHEN T2.age > 30 THEN 1 END) AS REAL) * 100 / COUNT(T2.person_id) FROM competitor_event AS T1 INNER JOIN games_competitor AS T2 ON T1.competitor_id = T2.id WHERE T1.medal_id = 1	olympics
SELECT T2.age FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '2012 Summer' AND T3.full_name = 'A Lamusi'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '2000 Summer' AND T2.age = 31	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '1948 Summer' AND T3.gender = 'M'	olympics
SELECT T3.full_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '1936 Summer'	olympics
SELECT T3.full_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '2014 Winter' ORDER BY T2.age LIMIT 1	olympics
SELECT AVG(T2.age) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '1988 Winter'	olympics
SELECT CAST(COUNT(CASE WHEN T3.gender = 'F' AND T3.height > 170 THEN 1 END) AS REAL) * 100 / COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_year = 1988	olympics
SELECT T1.sport_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T2.event_name LIKE 'Cross Country Skiing Men%s 10/15 kilometres Pursuit'	olympics
SELECT CAST(COUNT(CASE WHEN T2.age > 24 AND T1.season = 'Winter' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.games_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id	olympics
SELECT T1.region_id FROM person_region AS T1 INNER JOIN person AS T2 ON T1.person_id = T2.id WHERE T2.full_name = 'Christine Jacoba Aaftink'	olympics
SELECT T2.height FROM person_region AS T1 INNER JOIN person AS T2 ON T1.person_id = T2.id WHERE T1.region_id = 7	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id WHERE T1.games_id = 3	olympics
SELECT T1.games_id FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id WHERE T2.city_name = 'London'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.season = 'Summer' AND T2.age < 30	olympics
SELECT DISTINCT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T2.games_id = 13	olympics
SELECT AVG(T2.age) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.season = 'Winter'	olympics
SELECT CAST(COUNT(CASE WHEN T2.age < 35 THEN 1 END) AS REAL) * 100 / COUNT(T2.games_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.season = 'Summer'	olympics
SELECT T2.event_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Basketball'	olympics
SELECT DISTINCT T1.medal_name FROM medal AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.medal_id WHERE T2.competitor_id = 9	olympics
SELECT T2.event_id FROM medal AS T1 INNER JOIN competitor_event AS T2 ON T1.id = T2.medal_id WHERE T1.medal_name = 'Gold'	olympics
SELECT full_name FROM person ORDER BY weight DESC LIMIT 1	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_year = 1992	olympics
SELECT T2.region_name FROM person_region AS T1 INNER JOIN noc_region AS T2 ON T1.region_id = T2.id GROUP BY T2.region_name ORDER BY COUNT(T1.person_id) DESC LIMIT 1	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id ORDER BY T2.age DESC LIMIT 1	olympics
SELECT DISTINCT T1.sport_name FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id INNER JOIN competitor_event AS T3 ON T2.id = T3.event_id INNER JOIN games_competitor AS T4 ON T3.competitor_id = T4.id INNER JOIN person AS T5 ON T4.person_id = T5.id WHERE T5.full_name = 'John Aalberg'	olympics
SELECT COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Belgium' AND T3.gender = 'M'	olympics
SELECT COUNT(T1.person_id) FROM games_competitor AS T1 INNER JOIN games_city AS T2 ON T1.games_id = T2.games_id INNER JOIN city AS T3 ON T2.city_id = T3.id WHERE T3.city_name = 'Barcelona'	olympics
SELECT COUNT(T2.event_name) FROM sport AS T1 INNER JOIN event AS T2 ON T1.id = T2.sport_id WHERE T1.sport_name = 'Football'	olympics
SELECT T4.city_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN games_city AS T3 ON T2.games_id = T3.games_id INNER JOIN city AS T4 ON T3.city_id = T4.id WHERE T1.full_name = 'John Aalberg'	olympics
SELECT COUNT(T1.games_id) FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id WHERE T2.city_name = 'Barcelona'	olympics
SELECT COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '1992 Winter' AND T2.age > 30	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN games_city AS T3 ON T2.games_id = T3.games_id INNER JOIN city AS T4 ON T3.city_id = T4.id WHERE T4.city_name = 'Barcelona' GROUP BY T1.id ORDER BY COUNT(T2.person_id) DESC LIMIT 1	olympics
SELECT T3.full_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Argentina'	olympics
SELECT AVG(T2.age) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person_region AS T3 ON T2.person_id = T3.person_id INNER JOIN noc_region AS T4 ON T3.region_id = T4.id WHERE T1.games_name = '2012 Summer' AND T4.region_name = 'Argentina'	olympics
SELECT CAST(COUNT(CASE WHEN T4.medal_name = 'Bronze' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.person_id) FROM competitor_event AS T1 INNER JOIN games_competitor AS T2 ON T1.competitor_id = T2.id INNER JOIN event AS T3 ON T1.event_id = T3.id INNER JOIN medal AS T4 ON T1.medal_id = T4.id WHERE T3.event_name LIKE 'Basketball Men%s Basketball'	olympics
SELECT T1.games_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Georgios Abaris'	olympics
SELECT T3.full_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Greece'	olympics
SELECT AVG(T2.age) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '1924 Winter'	olympics
SELECT T1.noc FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.weight = 77	olympics
SELECT T3.games_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T2.city_name = 'Paris'	olympics
SELECT T3.full_name FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.games_name = '2000 Summer'	olympics
SELECT T4.city_name FROM games_competitor AS T1 INNER JOIN games AS T2 ON T1.games_id = T2.id INNER JOIN games_city AS T3 ON T1.games_id = T3.games_id INNER JOIN city AS T4 ON T3.city_id = T4.id ORDER BY T1.age DESC LIMIT 1	olympics
SELECT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id ORDER BY T2.age LIMIT 1	olympics
SELECT T1.games_id FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id WHERE T2.city_name = 'Tokyo'	olympics
SELECT T1.noc, T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id ORDER BY T3.weight DESC LIMIT 1	olympics
SELECT T1.games_year, T1.season FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.full_name = 'Sohail Abbas'	olympics
SELECT AVG(T1.weight) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN medal AS T4 ON T3.medal_id = T4.id WHERE T4.medal_name = 'Silver'	olympics
SELECT T2.city_name FROM games_city AS T1 INNER JOIN city AS T2 ON T1.city_id = T2.id INNER JOIN games AS T3 ON T1.games_id = T3.id WHERE T3.games_name = '2004 Summer'	olympics
SELECT DISTINCT T1.season FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.height = 180 AND T3.weight = 73	olympics
SELECT DISTINCT T1.full_name FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id INNER JOIN competitor_event AS T3 ON T2.id = T3.competitor_id INNER JOIN medal AS T4 ON T3.medal_id = T4.id WHERE T4.medal_name = 'Gold'	olympics
SELECT AVG(T1.height) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T2.age BETWEEN 22 AND 28	olympics
SELECT COUNT(T2.person_id) FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T1.region_name = 'Iran' AND T3.gender = 'F'	olympics
SELECT T2.age FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id ORDER BY T1.height DESC LIMIT 1	olympics
SELECT COUNT(CASE WHEN T1.weight > 70 THEN 1 ELSE NULL END) - COUNT(CASE WHEN T1.weight < 70 THEN 1 ELSE NULL END) FROM person AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.person_id WHERE T2.age < 24	olympics
SELECT CAST(COUNT(CASE WHEN T2.age = 28 THEN 1 END) AS REAL) * 100 / COUNT(T2.person_id) FROM games AS T1 INNER JOIN games_competitor AS T2 ON T1.id = T2.games_id WHERE T1.games_name = '2014 Winter'	olympics
SELECT DISTINCT T1.region_name FROM noc_region AS T1 INNER JOIN person_region AS T2 ON T1.id = T2.region_id INNER JOIN person AS T3 ON T2.person_id = T3.id WHERE T3.gender = 'M' AND T3.height * 100 > ( SELECT AVG(height) FROM person WHERE gender = 'M' ) * 87	olympics
SELECT SUM(T1.households) FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO'	address
SELECT T1.zip_code FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO' ORDER BY T1.avg_house_value DESC LIMIT 1	address
SELECT SUM(T1.male_population) FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO'	address
SELECT COUNT(T1.zip_code) FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'DELAWARE' AND T1.daylight_savings = 'Yes'	address
SELECT T1.zip_code FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO' ORDER BY T1.white_population DESC LIMIT 1	address
SELECT T2.county FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO' GROUP BY T2.county ORDER BY T1.avg_income_per_household DESC LIMIT 1	address
SELECT DISTINCT T2.county FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T1.daylight_savings = 'Yes'	address
SELECT DISTINCT T1.zip_code FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'HUNTINGDON' AND T1.employees > 30	address
SELECT SUM(T1.asian_population) FROM zip_data AS T1 INNER JOIN avoid AS T2 ON T1.zip_code = T2.zip_code WHERE T2.bad_alias = 'URB San Joaquin'	address
SELECT COUNT(T1.zip_code) FROM zip_data AS T1 INNER JOIN avoid AS T2 ON T1.zip_code = T2.zip_code WHERE T2.bad_alias = 'Internal Revenue Service' AND T1.time_zone = 'Eastern'	address
SELECT T2.bad_alias FROM zip_data AS T1 INNER JOIN avoid AS T2 ON T1.zip_code = T2.zip_code WHERE T1.avg_house_value = ( SELECT MAX(avg_house_value) FROM zip_data ) LIMIT 1	address
SELECT DISTINCT T2.bad_alias FROM zip_data AS T1 INNER JOIN avoid AS T2 ON T1.zip_code = T2.zip_code WHERE T1.female_median_age > 32	address
SELECT CAST(T1.male_population AS REAL) / T1.female_population FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO' AND T1.female_population <> 0 ORDER BY 1 DESC LIMIT 1	address
SELECT SUM(T1.female_median_age) / COUNT(T1.zip_code) FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'ARECIBO'	address
SELECT T1.area_code FROM area_code AS T1 INNER JOIN ZIP_Data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.female_median_age > 32 GROUP BY T1.area_code	address
SELECT DISTINCT T2.alias FROM zip_data AS T1 INNER JOIN alias AS T2 ON T1.zip_code = T2.zip_code WHERE T1.city = 'Hartford'	address
SELECT COUNT(T2.county) FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Alabama'	address
SELECT COUNT(DISTINCT T2.zip_code) FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.abbreviation = 'NY' AND T2.type = 'Post Office'	address
SELECT T2.latitude, T2.longitude FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = '787' GROUP BY T2.latitude, T2.longitude	address
SELECT COUNT(*) FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.abbreviation = 'CA' AND T2.type LIKE '%Community Post Office%' AND T1.name = 'California' AND T2.state = 'CA'	address
SELECT T4.county FROM zip_data AS T3 INNER JOIN country AS T4 ON T3.zip_code = T4.zip_code GROUP BY T4.county ORDER BY T3.female_population DESC LIMIT 1	address
SELECT DISTINCT T2.name FROM zip_data AS T1 INNER JOIN state AS T2 ON T1.state = T2.abbreviation WHERE T1.division IS NULL	address
SELECT T1.population_2020 - T1.population_2010 AS result_data FROM zip_data AS T1 INNER JOIN CBSA AS T2 ON T1.CBSA = T2.CBSA WHERE T2.CBSA_name = 'Allentown-Bethlehem-Easton, PA-NJ' ORDER BY T1.population_2020 DESC LIMIT 1	address
SELECT DISTINCT T2.zip_code FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state WHERE T2.county = 'NEW CASTLE' AND T1.name = 'Delaware'	address
SELECT COUNT(T3.cognress_rep_id) FROM zip_data AS T1 INNER JOIN state AS T2 ON T1.state = T2.abbreviation INNER JOIN congress AS T3 ON T2.abbreviation = T3.abbreviation ORDER BY T1.monthly_benefits_retired_workers DESC LIMIT 1	address
SELECT COUNT(T3.city) FROM congress AS T1 INNER JOIN state AS T2 ON T1.abbreviation = T2.abbreviation INNER JOIN zip_data AS T3 ON T2.abbreviation = T3.state WHERE T1.first_name = 'Murkowski' AND T1.last_name = 'Lisa' AND T3.employees = 0	address
SELECT t.state, T1.first_name, T1.last_name FROM zip_data AS T INNER JOIN congress AS T1 ON t.state = T1.abbreviation GROUP BY t.state ORDER BY SUM(t.asian_population) DESC LIMIT 3	address
SELECT DISTINCT T2.name FROM country AS T1 INNER JOIN state AS T2 ON T1.state = T2.abbreviation WHERE T1.county = 'OUTAGAMIE'	address
SELECT T1.party FROM congress AS T1 INNER JOIN state AS T2 ON T1.abbreviation = T2.abbreviation INNER JOIN zip_data AS T3 ON T2.abbreviation = T3.state WHERE T3.zip_code = 91701 GROUP BY T1.party	address
SELECT SUM(T1.male_population) FROM zip_data AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T2.county = 'NEW HAVEN'	address
SELECT T2.alias FROM zip_data AS T1 INNER JOIN alias AS T2 ON T1.zip_code = T2.zip_code WHERE T1.latitude = 18.090875 AND T1.longitude = -66.867756	address
SELECT T2.area_code FROM zip_data AS T1 INNER JOIN area_code AS T2 ON T1.zip_code = T2.zip_code GROUP BY T2.area_code ORDER BY T1.over_65 DESC LIMIT 1	address
SELECT COUNT(DISTINCT T2.bad_alias) FROM zip_congress AS T1 INNER JOIN avoid AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T1.district = T3.cognress_rep_id WHERE T3.first_name = 'Thompson' AND T3.last_name = 'Bennie G'	address
SELECT T2.latitude, T2.longitude FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 636	address
SELECT T2.zip_code FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.first_name = 'Buchanan' AND T1.last_name = 'Vernon'	address
SELECT T2.state FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 878	address
SELECT COUNT(T2.county) FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Virginia'	address
SELECT T1.CBSA_name, T2.latitude, T2.longitude FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T2.zip_code = 45503 GROUP BY T1.CBSA_name, T2.latitude, T2.longitude	address
SELECT T1.county FROM country AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T3.first_name = 'Hartzler' AND T3.last_name = 'Vicky' GROUP BY T1.county	address
SELECT SUM(T2.male_median_age) / COUNT(T2.median_age) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.county = 'WINDHAM'	address
SELECT SUM(T4.female_median_age) / COUNT(T1.county) FROM country AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id INNER JOIN zip_data AS T4 ON T1.zip_code = T4.zip_code WHERE T3.first_name = 'DeSantis' AND T3.last_name = 'Ron'	address
SELECT T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Bishopville' AND T2.state = 'SC'	address
SELECT T1.bad_alias FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Geneva' AND T2.state = 'AL'	address
SELECT T2.city, T2.state FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.bad_alias = 'Lawrenceville' GROUP BY T2.city, T2.state	address
SELECT T1.alias, T2.bad_alias FROM alias AS T1 INNER JOIN avoid AS T2 ON T1.zip_code = T2.zip_code WHERE T1.zip_code = 38015	address
SELECT T2.zip_code FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.first_name = 'King' AND T1.last_name = 'Steven A'	address
SELECT T1.CBSA_name, T1.CBSA_type FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T2.city = 'York' AND T2.state = 'ME'	address
SELECT T2.city, T2.zip_code, T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.median_age >= 40 LIMIT 10	address
SELECT T2.county FROM avoid AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T1.bad_alias = 'Druid Hills'	address
SELECT DISTINCT T1.area_code FROM area_code AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code INNER JOIN state AS T3 ON T2.state = T3.abbreviation WHERE T2.county = 'PHILLIPS' AND T3.name = 'Montana'	address
SELECT T2.zip_code, T1.first_name, T1.last_name FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.state = 'Wisconsin' ORDER BY T1.land_area DESC LIMIT 1	address
SELECT SUM(CASE WHEN T1.time_zone = 'Central' THEN 1 ELSE 0 END) AS count FROM zip_data AS T1 INNER JOIN state AS T2 ON T2.abbreviation = T1.state WHERE T1.time_zone = 'Central'	address
SELECT DISTINCT T2.city, T2.state FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'Lexington-Fayette, KY' LIMIT 10	address
SELECT CAST(COUNT(CASE WHEN T2.party = 'Democrat' THEN 1 ELSE NULL END) AS REAL) / COUNT(CASE WHEN T2.party = 'Republican' THEN 1 ELSE NULL END)FROM zip_congress AS T1 INNER JOIN congress AS T2 ON T2.cognress_rep_id = T1.district	address
SELECT CAST(COUNT(CASE WHEN state = 'Alabama' THEN cognress_rep_id ELSE NULL END) AS REAL) / COUNT(CASE WHEN state = 'Illinois' THEN cognress_rep_id ELSE NULL END) FROM congress	address
SELECT CAST(SUM(population_2020) AS REAL) / COUNT(zip_code) FROM zip_data	address
SELECT T2.male_population FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'Berlin, NH' GROUP BY T2.male_population	address
SELECT T1.CBSA_name FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA GROUP BY T1.CBSA HAVING COUNT(T2.zip_code) > 10	address
SELECT T1.bad_alias FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.state = 'PR'	address
SELECT T1.latitude, T1.longitude FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T3.first_name = 'Grayson' AND T3.last_name = 'Alan'	address
SELECT DISTINCT T2.state FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 787	address
SELECT T3.first_name, T3.last_name FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T1.population_2020 > 30000 GROUP BY T3.first_name, T3.last_name	address
SELECT T1.zip_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.state = 'MA' GROUP BY T1.zip_code HAVING COUNT(T1.area_code) > 1	address
SELECT DISTINCT T1.county FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Arecibo'	address
SELECT COUNT(T2.zip_code) FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'Barre, VT'	address
SELECT T1.zip_code FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.county = 'SAINT CROIX' ORDER BY T2.land_area DESC LIMIT 1	address
SELECT T1.population_2020 - T1.population_2010 FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T3.first_name = 'Griffin' AND T3.last_name = 'Tim'	address
SELECT CAST(T2.asian_population AS REAL) * 100 / T2.population_2010 FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'Atmore, AL'	address
SELECT T2.city FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 939 ORDER BY T2.asian_population DESC LIMIT 1	address
SELECT DISTINCT T1.name, T2.state FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state INNER JOIN zip_data AS T3 ON T2.zip_code = T3.zip_code WHERE T3.elevation = 1039	address
SELECT T1.alias, T2.elevation FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.zip_code = 1028	address
SELECT T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.land_area = ( SELECT MAX(land_area) FROM zip_data )	address
SELECT T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.white_population BETWEEN 1700 AND 2000	address
SELECT SUM(T2.asian_population) FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.alias = 'Leeds'	address
SELECT T1.area_code, T2.county FROM area_code AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code INNER JOIN zip_data AS T3 ON T1.zip_code = T3.zip_code WHERE T3.city = 'Savoy'	address
SELECT DISTINCT T1.alias FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.population_2010 = 0	address
SELECT COUNT(T2.city) FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 608 AND T2.daylight_savings = 'Yes'	address
SELECT AVG(T2.elevation) FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.alias = 'Amherst'	address
SELECT T2.county FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state INNER JOIN zip_data AS T3 ON T2.zip_code = T3.zip_code WHERE T3.city = 'Dalton' GROUP BY T2.county	address
SELECT T1.alias FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.type = 'Post Office' LIMIT 5	address
SELECT COUNT(CASE WHEN T2.type = 'P.O. Box Only' THEN 1 ELSE NULL END) - COUNT(CASE WHEN T2.type = 'Post Office' THEN 1 ELSE NULL END) AS DIFFERENCE FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 787	address
SELECT CAST((SUM(T2.population_2020) - SUM(T2.population_2010)) AS REAL) * 100 / SUM(T2.population_2010) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Arroyo'	address
SELECT T2.zip_code, T2.city FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Texas' AND T2.total_beneficiaries > 10000	address
SELECT COUNT(T1.zip_code) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.county = 'DISTRICT OF COLUMBIA' AND T2.black_population > 20000	address
SELECT T2.city, T1.alias FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.zip_code = 19019	address
SELECT T1.bad_alias FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Camuy'	address
SELECT T1.zip_code, T1.city, T3.first_name, T3.last_name FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id GROUP BY T2.district ORDER BY T1.population_2020 DESC LIMIT 1	address
SELECT COUNT(T2.zip_code) FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Illinois' AND T2.daylight_savings = 'Yes' AND T2.region = 'Midwest'	address
SELECT T2.county, T2.zip_code FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Virgin Islands'	address
SELECT T2.zip_code, T1.alias FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Greeneville'	address
SELECT CASE WHEN COUNT(CASE WHEN T1.first_name = 'Smith' AND T1.last_name = 'Adrian' THEN T2.zip_code ELSE NULL END) > COUNT(CASE WHEN T1.first_name = 'Heck' AND T1.last_name = 'Joe' THEN T2.zip_code ELSE NULL END) THEN 'Smith Adrian>Heck Joe' ELSE 'Smith Adrian<=Heck Joe' END AS COMPARE FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district	address
SELECT T2.zip_code, T1.CBSA_name FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T2.city = 'Oxford'	address
SELECT T2.zip_code, T2.organization FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'Kingsport-Bristol, TN-VA'	address
SELECT T1.zip_code, T3.first_name, T3.last_name FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T1.organization = 'Readers Digest'	address
SELECT CAST(COUNT(CASE WHEN T2.type = 'Post Office' THEN T2.zip_code ELSE NULL END) AS REAL) * 100 / COUNT(T2.zip_code) FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'California'	address
SELECT T2.zip_code FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.House = 'House of Repsentatives' GROUP BY T2.zip_code	address
SELECT T2.city FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code GROUP BY T1.bad_alias ORDER BY COUNT(T1.zip_code) DESC LIMIT 1	address
SELECT T2.county FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Georgia' GROUP BY T2.county	address
SELECT T2.latitude, T2.longitude FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 410	address
SELECT DISTINCT T1.CBSA_name FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T2.avg_house_value = ( SELECT MAX(avg_house_value) FROM zip_data ) LIMIT 1	address
SELECT T1.bad_alias FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'East Setauket'	address
SELECT SUM(T2.population_2010) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.county = 'WILCOX'	address
SELECT T1.zip_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code GROUP BY T2.asian_population ORDER BY T2.asian_population DESC LIMIT 1	address
SELECT T2.city FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_type = 'Micro'	address
SELECT T1.name FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state GROUP BY T2.state ORDER BY COUNT(T2.county) DESC LIMIT 1	address
SELECT SUM(CASE WHEN T2.district = 'FL-10' THEN 1 ELSE 0 END) FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code	address
SELECT T2.avg_income_per_household FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.bad_alias = 'Danzig'	address
SELECT DISTINCT T2.state FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T2.female_population > ( SELECT AVG(female_population) FROM zip_data )	address
SELECT CAST(SUM(CASE WHEN T1.county = 'CORYELL' THEN T2.households ELSE 0 END) AS REAL) * 100 / SUM(T2.households) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code	address
SELECT T1.CBSA_name, T1.CBSA_type FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T2.city = 'Cabo Rojo' GROUP BY T1.CBSA_name, T1.CBSA_type	address
SELECT T1.county FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Las Marias'	address
SELECT COUNT(DISTINCT T1.city) FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T3.first_name = 'Pierluisi' AND T3.last_name = 'Pedro'	address
SELECT T1.bad_alias FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.city = 'Aguadilla'	address
SELECT T3.first_name, T3.last_name FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T1.city = 'Guanica'	address
SELECT T2.state FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code GROUP BY T2.state ORDER BY COUNT(T1.bad_alias) DESC LIMIT 1	address
SELECT COUNT(CASE WHEN T2.city = 'Aguada' THEN T1.bad_alias ELSE NULL END) - COUNT(CASE WHEN T2.city = 'Aguadilla' THEN T1.bad_alias ELSE NULL END) AS DIFFERENCE FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code	address
SELECT T2.state FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_type = 'Metro' GROUP BY T2.state HAVING COUNT(T1.CBSA_type) > 50	address
SELECT SUM(T2.population_2020) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.county = 'ARECIBO'	address
SELECT DISTINCT T1.county FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.population_2010 > 10000	address
SELECT T1.county FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code GROUP BY T1.county ORDER BY T2.households DESC LIMIT 1	address
SELECT CAST(COUNT(CASE WHEN T2.households > 10000 THEN T1.zip_code ELSE NULL END) AS REAL) * 100 / COUNT(T1.zip_code) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code	address
SELECT CAST(COUNT(CASE WHEN T2.type = 'Post Office' THEN T1.zip_code ELSE NULL END) AS REAL) * 100 / COUNT(T1.zip_code) FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.county = 'SAINT CROIX'	address
SELECT DISTINCT T2.county FROM area_code AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code INNER JOIN zip_data AS T3 ON T1.zip_code = T3.zip_code WHERE T1.area_code = '787' AND T3.type = 'Unique Post Office'	address
SELECT T2.elevation FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.alias = 'East Longmeadow'	address
SELECT COUNT(T1.area_code) FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.daylight_savings = 'No'	address
SELECT T2.county, T1.area_code FROM area_code AS T1 INNER JOIN country AS T2 ON T1.zip_code = T2.zip_code WHERE T1.zip_code = 1116	address
SELECT DISTINCT T2.type FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.alias = 'St Thomas'	address
SELECT T3.city FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state INNER JOIN zip_data AS T3 ON T2.zip_code = T3.zip_code WHERE T1.name = 'Oklahoma' AND T2.county = 'NOBLE'	address
SELECT T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.water_area = ( SELECT MAX(water_area) FROM zip_data )	address
SELECT T1.alias FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.population_2020 = ( SELECT MAX(population_2020) FROM zip_data )	address
SELECT T3.elevation FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state INNER JOIN zip_data AS T3 ON T2.zip_code = T3.zip_code WHERE T1.name = 'Massachusetts' AND T2.county = 'HAMPDEN' GROUP BY T3.elevation	address
SELECT T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.hispanic_population = ( SELECT MAX(hispanic_population) FROM zip_data )	address
SELECT T1.alias FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.asian_population = 7	address
SELECT AVG(T2.white_population) FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.area_code = 920	address
SELECT CAST(COUNT(CASE WHEN T2.county_fips < 20 THEN T2.zip_code ELSE NULL END) AS REAL) * 100 / COUNT(T2.zip_code) FROM alias AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.alias = 'Ponce'	address
SELECT T1.county FROM country AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.population_2020 > 0.97 * ( SELECT AVG(population_2020) FROM zip_data )	address
SELECT COUNT(T2.zip_code) FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.first_name = 'Kirkpatrick' AND T1.last_name = 'Ann'	address
SELECT T2.zip_code, T2.latitude, T2.longitude FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'Allentown-Bethlehem-Easton, PA-NJ'	address
SELECT T1.zip_code, T2.city, T2.latitude, T2.longitude FROM avoid AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T1.bad_alias = 'Shared Reshipper'	address
SELECT T3.first_name, T3.last_name FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code INNER JOIN congress AS T3 ON T2.district = T3.cognress_rep_id WHERE T1.city = 'Garfield'	address
SELECT COUNT(T2.zip_code) FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T1.CBSA_name = 'New York-Newark-Jersey City, NY-NJ-PA'	address
SELECT COUNT(T2.zip_code) FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.state = 'Puerto Rico'	address
SELECT COUNT(DISTINCT T2.zip_code), COUNT(DISTINCT T2.county) FROM state AS T1 INNER JOIN country AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'West Virginia'	address
SELECT T1.zip_code, T1.area_code FROM area_code AS T1 INNER JOIN zip_data AS T2 ON T1.zip_code = T2.zip_code WHERE T2.type = 'Community Post Office ' AND T2.elevation > 6000	address
SELECT COUNT(T2.zip_code) FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district WHERE T1.state = 'Mississippi'	address
SELECT T2.district FROM zip_data AS T1 INNER JOIN zip_congress AS T2 ON T1.zip_code = T2.zip_code WHERE T1.city = 'East Springfield'	address
SELECT T1.CBSA_name FROM CBSA AS T1 INNER JOIN zip_data AS T2 ON T1.CBSA = T2.CBSA WHERE T2.employees = ( SELECT MAX(employees) FROM zip_data )	address
SELECT COUNT(T2.zip_code) FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Ohio' AND T2.type = 'Unique Post Office'	address
SELECT CAST(SUM(T2.total_beneficiaries) AS REAL) / COUNT(T2.zip_code) FROM state AS T1 INNER JOIN zip_data AS T2 ON T1.abbreviation = T2.state WHERE T1.name = 'Guam'	address
SELECT CAST(SUM(CASE WHEN T1.party = 'Democrat' THEN 1 ELSE 0 END) AS REAL) * 100 / COUNT(*), SUM(CASE WHEN T1.state = 'Hawaii' THEN 1 ELSE 0 END) FROM congress AS T1 INNER JOIN zip_congress AS T2 ON T1.cognress_rep_id = T2.district	address
SELECT BrandName FROM rootbeerbrand WHERE FirstBrewedYear = ( SELECT MIN(FirstBrewedYear) FROM rootbeerbrand )	beer_factory
SELECT COUNT(BrandID) FROM rootbeerbrand WHERE Country = 'United States'	beer_factory
SELECT BrandName FROM rootbeerbrand WHERE FacebookPage IS NOT NULL	beer_factory
SELECT BrandName FROM rootbeerbrand ORDER BY CurrentRetailPrice - WholesaleCost LIMIT 1	beer_factory
SELECT Description FROM rootbeerbrand WHERE BrandName = 'A&W'	beer_factory
SELECT City FROM rootbeerbrand WHERE BreweryName = 'AJ Stephans Beverages'	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.First = 'Frank-Paul' AND T1.Last = 'Santangelo' AND STRFTIME('%Y-%m', T2.TransactionDate) = '2014-07'	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Gender = 'M' AND STRFTIME('%Y-%m', T2.TransactionDate) = '2014-07'	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.SubscribedToEmailList = 'TRUE' AND T2.CreditCardType = 'Visa' AND STRFTIME('%Y-%m', T2.TransactionDate) = '2014-07'	beer_factory
SELECT T1.First, T1.Last FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE STRFTIME('%Y-%m', T2.TransactionDate) = '2014-08' GROUP BY T1.CustomerID ORDER BY COUNT(T2.CustomerID) DESC LIMIT 1	beer_factory
SELECT DISTINCT T4.BrandName FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID INNER JOIN rootbeerbrand AS T4 ON T3.BrandID = T4.BrandID WHERE T1.First = 'Frank-Paul' AND T1.Last = 'Santangelo' AND T2.TransactionDate = '2014-07-07'	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID WHERE T1.First = 'Frank-Paul' AND T1.Last = 'Santangelo' AND T2.TransactionDate = '2014-07-07' AND T3.ContainerType = 'Can'	beer_factory
SELECT COUNT(T1.BrandID) FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T2.TransactionDate LIKE '2014-08%' AND T3.BrandName = 'Bulldog'	beer_factory
SELECT T1.First, T1.Last FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID INNER JOIN rootbeerbrand AS T4 ON T3.BrandID = T4.BrandID WHERE T4.BreweryName = 'AJ Stephans Beverages'	beer_factory
SELECT COUNT(T1.BrandID) FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T2.TransactionDate LIKE '2014-08%' AND T3.Twitter IS NULL	beer_factory
SELECT DISTINCT T2.CreditCardNumber FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.First = 'Frank-Paul' AND T1.Last = 'Santangelo' AND T2.TransactionDate = '2014-07-07'	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID INNER JOIN rootbeerbrand AS T4 ON T3.BrandID = T4.BrandID WHERE T1.First = 'Frank-Paul' AND T1.Last = 'Santangelo' AND T4.ArtificialSweetener = 'FALSE' AND T4.Honey = 'FALSE'	beer_factory
SELECT T2.TransactionDate FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.Gender = 'M' GROUP BY T2.TransactionDate HAVING COUNT(T2.CustomerID) > 3	beer_factory
SELECT CAST(COUNT(T1.BrandID) AS REAL) / 31 FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T2.TransactionDate LIKE '2014-08%' AND T3.BrandName = 'A&W'	beer_factory
SELECT CAST(COUNT(CASE WHEN T3.BreweryName = 'AJ Stephans Beverages' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.BrandID) FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T2.TransactionDate LIKE '2014%'	beer_factory
SELECT COUNT(T2.CustomerID) FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.First = 'James' AND T1.Last = 'House'	beer_factory
SELECT DISTINCT T2.CreditCardNumber FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.First = 'Lisa' AND T1.Last = 'Ling'	beer_factory
SELECT T2.Latitude, T2.Longitude FROM location AS T1 INNER JOIN geolocation AS T2 ON T1.LocationID = T2.LocationID WHERE T1.LocationName = 'Sac State American River Courtyard'	beer_factory
SELECT T2.LocationName FROM `transaction` AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID WHERE T1.TransactionID = 100885	beer_factory
SELECT T1.City FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.TransactionID = 103545	beer_factory
SELECT DISTINCT T1.PhoneNumber FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.CreditCardNumber = 6011179359005382	beer_factory
SELECT T1.First, T1.Last FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID GROUP BY T1.CustomerID ORDER BY COUNT(T2.CustomerID) DESC LIMIT 1	beer_factory
SELECT T1.FirstPurchaseDate FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.Review = 'Tastes like Australia.'	beer_factory
SELECT T2.TransactionDate FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.First = 'Natalie' AND T1.Last = 'Dorris' ORDER BY T2.TransactionDate LIMIT 1	beer_factory
SELECT T1.BreweryName FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T2.StarRating = 5 GROUP BY T1.BrandID ORDER BY COUNT(T2.StarRating) DESC LIMIT 1	beer_factory
SELECT CASE WHEN T1.SubscribedToEmailList LIKE 'TRUE' THEN 'YES' ELSE 'NO' END AS result FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeerbrand AS T3 ON T2.BrandID = T3.BrandID WHERE T2.StarRating = 3 AND T3.BrandName = 'Frostie' AND T2.ReviewDate = '2014-04-24'	beer_factory
SELECT T1.CurrentRetailPrice - T1.WholesaleCost AS price FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T2.Review = 'The quintessential dessert root beer. No ice cream required.'	beer_factory
SELECT CAST(COUNT(CASE WHEN T2.StarRating = 5 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.StarRating) FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T1.BrandName = 'River City'	beer_factory
SELECT CAST(COUNT(*) AS REAL) / COUNT(DISTINCT T1.BrandID) AS avgreview FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T1.State = 'CA'	beer_factory
SELECT COUNT(CustomerID) FROM customers WHERE Gender = 'F' AND SubscribedToEmailList = 'TRUE'	beer_factory
SELECT BrandName FROM rootbeerbrand ORDER BY FirstBrewedYear DESC LIMIT 1	beer_factory
SELECT First, Last FROM customers ORDER BY FirstPurchaseDate LIMIT 10	beer_factory
SELECT COUNT(BreweryName) FROM rootbeerbrand WHERE Country = 'Australia'	beer_factory
SELECT COUNT(CustomerID) FROM customers WHERE First = 'Charles' AND City = 'Sacramento'	beer_factory
SELECT COUNT(TransactionID) FROM `transaction` WHERE CreditCardType = 'MasterCard' AND TransactionDate LIKE '2014%'	beer_factory
SELECT T3.BrandName FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeerbrand AS T3 ON T2.BrandID = T3.BrandID WHERE T1.First = 'Jayne' AND T1.Last = 'Collins' AND T2.StarRating = 1	beer_factory
SELECT COUNT(T1.BrandID) FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID INNER JOIN location AS T3 ON T1.LocationID = T3.LocationID WHERE T3.LocationName = 'Sac State American River Courtyard' AND T1.PurchaseDate LIKE '2015%' AND T2.Honey = 'TRUE' AND T2.CaneSugar = 'FALSE' AND T1.ContainerType = 'Bottle'	beer_factory
SELECT T2.BreweryName FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID WHERE T1.PurchaseDate BETWEEN '2016-01-01' AND '2016-12-31' GROUP BY T2.BrandID ORDER BY COUNT(T1.BrandID) DESC LIMIT 1	beer_factory
SELECT T1.First, T1.Last FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeerbrand AS T3 ON T2.BrandID = T3.BrandID WHERE T3.BrandName = 'River City' AND T2.StarRating = 5	beer_factory
SELECT COUNT(T2.RootBeerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.First = 'Tom' AND T1.Last = 'Hanks' AND T2.TransactionDate BETWEEN '2015-01-01' AND '2016-12-31'	beer_factory
SELECT T1.BrandName FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T2.StarRating = 5	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID INNER JOIN rootbeerbrand AS T4 ON T3.BrandID = T4.BrandID WHERE T1.First = 'Nicholas' AND T1.Last = 'Sparks' AND T4.BrandName LIKE 'Henry Weinhard%s'	beer_factory
SELECT T2.BreweryName FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID WHERE T2.FacebookPage IS NULL AND T2.Twitter IS NULL GROUP BY T2.BrandID ORDER BY COUNT(T1.BrandID) DESC LIMIT 1	beer_factory
SELECT T3.LocationName FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID INNER JOIN location AS T3 ON T1.LocationID = T3.LocationID WHERE T2.BrandName = 'Dog n Suds' AND T3.LocationName IN ('Sac State American River Courtyard', 'Sac State Union') GROUP BY T1.LocationID ORDER BY COUNT(T1.BrandID) DESC LIMIT 1	beer_factory
SELECT COUNT(T1.BrandID) FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID WHERE T1.ContainerType = 'Can' AND T2.BrandName = 'A&W' AND T1.PurchaseDate LIKE '2016%'	beer_factory
SELECT T2.Latitude, T2.Longitude FROM location AS T1 INNER JOIN geolocation AS T2 ON T1.LocationID = T2.LocationID WHERE T1.LocationName = 'Sac State Union'	beer_factory
SELECT T1.BrandName FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T2.StarRating = 5 GROUP BY T2.BrandID HAVING COUNT(T2.StarRating) >= 5	beer_factory
SELECT T1.BrandName , CAST(SUM(CASE WHEN T2.PurchaseDate >= '2014-01-01' AND T2.PurchaseDate <= '2016-12-31' THEN 1 ELSE 0 END) AS REAL) / COUNT(T2.BrandID) AS purchase FROM rootbeerbrand AS T1 INNER JOIN rootbeer AS T2 ON T1.BrandID = T2.BrandID WHERE T1.BreweryName = 'Dr Pepper Snapple Group' GROUP BY T2.BrandID	beer_factory
SELECT T3.BrandName, T2.CustomerID FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID GROUP BY T3.BrandID ORDER BY T3.CurrentRetailPrice - T3.WholesaleCost, COUNT(T1.BrandID) DESC LIMIT 1	beer_factory
SELECT First, Last, PhoneNumber FROM customers WHERE Gender = 'M' AND City = 'Fair Oaks' AND SubscribedToEmailList = 'TRUE'	beer_factory
SELECT CAST(COUNT(CASE WHEN ContainerType = 'Can' THEN RootBeerID ELSE NULL END) AS REAL) * 100 / COUNT(RootBeerID) FROM rootbeer WHERE PurchaseDate LIKE '2014%'	beer_factory
SELECT BrandName FROM rootbeerbrand WHERE FirstBrewedYear BETWEEN '1996' AND '2000' ORDER BY FirstBrewedYear DESC	beer_factory
SELECT BrandID FROM rootbeerreview WHERE StarRating = 1 GROUP BY BrandID ORDER BY COUNT(BrandID) DESC LIMIT 1	beer_factory
SELECT CAST(COUNT(CASE WHEN CreditCardType = 'Visa' THEN TransactionID ELSE NULL END) AS REAL) * 100 / COUNT(TransactionID) FROM `transaction`	beer_factory
SELECT COUNT(BrandID) FROM rootbeerbrand WHERE CornSyrup = 'TRUE' AND ArtificialSweetener = 'TRUE' AND AvailableInCans = 'TRUE'	beer_factory
SELECT CAST(COUNT(CASE WHEN T2.LocationName = 'Sac State American River Courtyard' THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.TransactionID) FROM `transaction` AS T1 INNER JOIN location AS T2 ON T1.LocationID = T2.LocationID	beer_factory
SELECT CAST(COUNT(T2.RootBeerID) AS REAL) / COUNT(DISTINCT T2.PurchaseDate) FROM rootbeerbrand AS T1 INNER JOIN rootbeer AS T2 ON T1.BrandID = T2.BrandID INNER JOIN `transaction` AS T3 ON T2.RootBeerID = T3.RootBeerID WHERE T1.Caffeinated = 'TRUE'	beer_factory
SELECT * FROM ( SELECT T1.BrandName, T2.ContainerType FROM rootbeerbrand AS T1 INNER JOIN rootbeer AS T2 ON T1.BrandID = T2.BrandID ORDER BY T1.CurrentRetailPrice - T1.WholesaleCost DESC LIMIT 1 ) UNION ALL SELECT * FROM ( SELECT T3.BrandName, T4.ContainerType FROM rootbeerbrand AS T3 INNER JOIN rootbeer AS T4 ON T3.BrandID = T4.BrandID ORDER BY T3.CurrentRetailPrice - T3.WholesaleCost ASC LIMIT 1 )	beer_factory
SELECT AVG(T2.PurchasePrice) FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T1.ContainerType = 'Bottle' AND T2.PurchasePrice > 2	beer_factory
SELECT COUNT(T4.BrandID) FROM `transaction` AS T1 INNER JOIN geolocation AS T2 ON T1.LocationID = T2.LocationID INNER JOIN location AS T3 ON T1.LocationID = T3.LocationID INNER JOIN rootbeer AS T4 ON T1.RootBeerID = T4.RootBeerID WHERE T2.Latitude = 38.559615 AND T2.Longitude = -121.42243 AND T4.ContainerType = 'Bottle'	beer_factory
SELECT CAST(COUNT(CASE WHEN T2.StarRating > 3 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T2.CustomerID) FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.SubscribedToEmailList = 'FALSE'	beer_factory
SELECT T3.BrandName FROM rootbeer AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T2.StarRating = 5 AND strftime('%Y', T2.ReviewDate) = '2012' GROUP BY T1.BrandID ORDER BY COUNT(T2.BrandID) DESC LIMIT 1	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID INNER JOIN rootbeerbrand AS T4 ON T3.BrandID = T4.BrandID WHERE T1.Gender = 'F' AND T4.ArtificialSweetener = 'TRUE'	beer_factory
SELECT COUNT(CASE WHEN T3.CaneSugar = 'TRUE' THEN T1.BrandID ELSE NULL END) - COUNT(CASE WHEN T3.CornSyrup = 'TRUE' THEN T1.BrandID ELSE NULL END) AS DIFFERENCE FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID	beer_factory
SELECT T3.BreweryName FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T2.TransactionDate LIKE '2015%' GROUP BY T3.BrandID ORDER BY COUNT(T1.BrandID) DESC LIMIT 1	beer_factory
SELECT CAST(COUNT(CASE WHEN T4.BrandName = 'Dominion' THEN T1.CustomerID ELSE NULL END) AS REAL) * 100 / COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeer AS T3 ON T2.RootBeerID = T3.RootBeerID INNER JOIN rootbeerbrand AS T4 ON T3.BrandID = T4.BrandID WHERE T1.City = 'Sacramento' AND T1.Gender = 'M' AND T2.TransactionDate LIKE '2014%'	beer_factory
SELECT (CAST(SUM(CASE WHEN T1.Honey = 'TRUE' THEN 1 ELSE 0 END) AS REAL) / COUNT(DISTINCT T3.TransactionDate)) - (CAST(SUM(CASE WHEN T1.Honey <> 'TRUE' THEN 1 ELSE 0 END) AS REAL) / COUNT(DISTINCT T3.TransactionDate)) FROM rootbeerbrand AS T1 INNER JOIN rootbeer AS T2 ON T1.BrandID = T2.BrandID INNER JOIN `transaction` AS T3 ON T2.RootBeerID = T3.RootBeerID	beer_factory
SELECT DISTINCT T1.First, T1.Last, T1.Email FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN location AS T3 ON T2.LocationID = T3.LocationID WHERE T3.LocationName = 'Sac State Union' AND T2.CreditCardType = 'American Express'	beer_factory
SELECT DISTINCT T1.BrandName FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T2.StarRating = 5 AND T2.ReviewDate BETWEEN '2014-09-01' AND '2014-09-30'	beer_factory
SELECT DISTINCT T2.Latitude, T2.Longitude FROM `transaction` AS T1 INNER JOIN geolocation AS T2 ON T1.LocationID = T2.LocationID WHERE T1.CreditCardType = 'American Express'	beer_factory
SELECT COUNT(T1.CustomerID) FROM customers AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T1.City = 'Folsom' AND T2.CreditCardType = 'Visa'	beer_factory
SELECT DISTINCT T1.City FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.StarRating = 5 AND T2.ReviewDate BETWEEN '2012-11-01' AND '2012-11-30'	beer_factory
SELECT T3.BrandName FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID INNER JOIN rootbeerbrand AS T3 ON T2.BrandID = T3.BrandID WHERE T1.First = 'Peg' AND T1.Last = 'Winchester'	beer_factory
SELECT T1.BrandName FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T2.BrandID = T1.BrandID WHERE T2.StarRating = 1 GROUP BY T1.BrandName ORDER BY COUNT(T1.BrandName) DESC LIMIT 1	beer_factory
SELECT T2.CreditCardType FROM rootbeer AS T1 INNER JOIN `transaction` AS T2 ON T1.RootBeerID = T2.RootBeerID INNER JOIN rootbeerbrand AS T3 ON T1.BrandID = T3.BrandID WHERE T3.Alcoholic = 'FALSE' GROUP BY T2.CreditCardType ORDER BY COUNT(T2.CreditCardType) DESC LIMIT 1	beer_factory
SELECT T1.First, T1.Last FROM customers AS T1 INNER JOIN rootbeerreview AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.StarRating = 5	beer_factory
SELECT T3.Latitude FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID INNER JOIN geolocation AS T3 ON T1.LocationID = T3.LocationID WHERE T2.BrandName = 'Thomas Kemper' GROUP BY T3.Latitude ORDER BY COUNT(T1.BrandID) DESC LIMIT 1	beer_factory
SELECT T2.StarRating FROM rootbeerbrand AS T1 INNER JOIN rootbeerreview AS T2 ON T1.BrandID = T2.BrandID WHERE T1.CornSyrup = 'TRUE' GROUP BY T2.StarRating ORDER BY COUNT(T2.StarRating) DESC LIMIT 1	beer_factory
SELECT T2.Latitude, T2.Longitude FROM location AS T1 INNER JOIN geolocation AS T2 ON T1.LocationID = T2.LocationID WHERE T1.ZipCode = 95819	beer_factory
SELECT DISTINCT T2.BrandName FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID INNER JOIN geolocation AS T3 ON T1.LocationID = T3.LocationID WHERE T3.Latitude = '38.566129' AND T3.Longitude = '-121.426432'	beer_factory
SELECT AVG(T2.CurrentRetailPrice - T2.WholesaleCost) FROM rootbeer AS T1 INNER JOIN rootbeerbrand AS T2 ON T1.BrandID = T2.BrandID WHERE T1.ContainerType = 'Can'	beer_factory
SELECT CAST(COUNT(CASE WHEN T1.StarRating = 3 THEN 1 ELSE NULL END) AS REAL) * 100 / COUNT(T1.CustomerID) FROM rootbeerreview AS T1 INNER JOIN `transaction` AS T2 ON T1.CustomerID = T2.CustomerID WHERE T2.CreditCardType = 'Discover'	beer_factory
SELECT BrandID FROM rootbeerreview WHERE StarRating > 3	beer_factory
SELECT COUNT(BrandID) FROM rootbeer WHERE ContainerType = 'Bottle' AND Purcha