## Datasets

We reuse the training, evaluation datasets from [IBRNet](https://github.com/googleinterns/IBRNet). All datasets must be downloaded to a directory `data/` within the project folder and must follow the below organization. 
```bash
├──data/
    ├──ibrnet_collected_1/
    ├──ibrnet_collected_2/
    ├──real_iconic_noface/
    ├──spaces_dataset/
    ├──RealEstate10K-subset/
    ├──google_scanned_objects/
    ├──nerf_synthetic/
    ├──nerf_llff_data/
```
We refer to [IBRNet's](https://github.com/googleinterns/IBRNet) repository to download and prepare data. For ease, we consolidate the instructions below:
```bash
mkdir data
cd data/

# IBRNet captures
gdown https://drive.google.com/uc?id=1rkzl3ecL3H0Xxf5WTyc2Swv30RIyr1R_
unzip ibrnet_collected.zip

# LLFF
gdown https://drive.google.com/uc?id=1ThgjloNt58ZdnEuiCeRf9tATJ-HI0b01
unzip real_iconic_noface.zip

## [IMPORTANT] remove scenes that appear in the test set
cd real_iconic_noface/
rm -rf data2_fernvlsb data2_hugetrike data2_trexsanta data3_orchid data5_leafscene data5_lotr data5_redflower
cd ../

# Spaces dataset
git clone https://github.com/augmentedperception/spaces_dataset

# RealEstate 10k
## make sure to install ffmpeg - sudo apt-get install ffmpeg
git clone https://github.com/qianqianwang68/RealEstate10K_Downloader
cd RealEstate10K_Downloader
python3 generate_dataset.py train
cd ../

# Google Scanned Objects
gdown https://drive.google.com/uc?id=1w1Cs0yztH6kE3JIz7mdggvPGCwIKkVi2
unzip google_scanned_objects_renderings.zip

# Blender dataset
gdown https://drive.google.com/uc?id=18JxhpWD-4ZmuFKLzKlAw-w5PpzZxXOcG
unzip nerf_synthetic.zip

# LLFF dataset (eval)
gdown https://drive.google.com/uc?id=16VnMcF1KJYxN9QId6TClMsZRahHNMW5g
unzip nerf_llff_data.zip
```

##  Blender

```bash
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=1234 train.py --config configs/transibr_bigger_blender.txt --train_scenes lego --eval_scenes lego --expname transibr_bigger_lego > transibr_bigger_lego.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=5678 train.py --config configs/transibr_bigger_blender.txt --train_scenes chair --eval_scenes chair --expname transibr_bigger_chair > transibr_bigger_chair.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=0910 train.py --config configs/transibr_bigger_blender.txt --train_scenes drums --eval_scenes drums --expname transibr_bigger_drums > transibr_bigger_drums.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=1112 train.py --config configs/transibr_bigger_blender.txt --train_scenes ficus --eval_scenes ficus --expname transibr_bigger_ficus > transibr_bigger_ficus.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=1314 train.py --config configs/transibr_bigger_blender.txt --train_scenes hotdog --eval_scenes hotdog --expname transibr_bigger_hotdog > transibr_bigger_hotdog.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=1516 train.py --config configs/transibr_bigger_blender.txt --train_scenes materials --eval_scenes materials --expname transibr_bigger_materials > transibr_bigger_materials.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=1718 train.py --config configs/transibr_bigger_blender.txt --train_scenes mic --eval_scenes mic --expname transibr_bigger_mic > transibr_bigger_mic.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=1920 train.py --config configs/transibr_bigger_blender.txt --train_scenes ship --eval_scenes ship --expname transibr_bigger_ship > transibr_bigger_ship.out
```

## LLFF

```bash
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2122 train.py --config configs/transibr_bigger_llff.txt --train_scenes orchids --eval_scenes orchids --expname transibr_bigger_orchids > transibr_bigger_orchids.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2324 train.py --config configs/transibr_bigger_llff.txt --train_scenes horns --eval_scenes horns --expname transibr_bigger_horns > transibr_bigger_horns.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2526 train.py --config configs/transibr_bigger_llff.txt --train_scenes trex --eval_scenes trex --expname transibr_bigger_trex > transibr_bigger_trex.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2728 train.py --config configs/transibr_bigger_llff.txt --train_scenes room --eval_scenes room --expname transibr_bigger_room > transibr_bigger_room.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2930 train.py --config configs/transibr_bigger_llff.txt --train_scenes flower --eval_scenes flower --expname transibr_bigger_flower > transibr_bigger_flower.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=3132 train.py --config configs/transibr_bigger_llff.txt --train_scenes leaves --eval_scenes leaves --expname transibr_bigger_leaves > transibr_bigger_leaves.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=3334 train.py --config configs/transibr_bigger_llff.txt --train_scenes fern --eval_scenes fern --expname transibr_bigger_fern > transibr_bigger_fern.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=3536 train.py --config configs/transibr_bigger_llff.txt --train_scenes fortress --eval_scenes fortress --expname transibr_bigger_fortress > transibr_bigger_fortress.out 
```

## Shiny

```bash
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2122 train.py --config configs/transibr_bigger_shiny.txt --train_scenes cd --eval_scenes cd --expname transibr_bigger_cd > transibr_bigger_cd.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2324 train.py --config configs/transibr_bigger_shiny.txt --train_scenes crest --eval_scenes crest --expname transibr_bigger_crest > transibr_bigger_crest.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2526 train.py --config configs/transibr_bigger_shiny.txt --train_scenes food --eval_scenes food --expname transibr_bigger_food > transibr_bigger_food.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2728 train.py --config configs/transibr_bigger_shiny.txt --train_scenes giants --eval_scenes giants --expname transibr_bigger_giants > transibr_bigger_giants.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2930 train.py --config configs/transibr_bigger_shiny.txt --train_scenes lab --eval_scenes lab --expname transibr_bigger_lab > transibr_bigger_lab.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=3132 train.py --config configs/transibr_bigger_shiny.txt --train_scenes pasta --eval_scenes pasta --expname transibr_bigger_pasta > transibr_bigger_pasta.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=3334 train.py --config configs/transibr_bigger_shiny.txt --train_scenes seasoning --eval_scenes seasoning --expname transibr_bigger_seasoning > transibr_bigger_seasoning.out 
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=3536 train.py --config configs/transibr_bigger_shiny.txt --train_scenes tools --eval_scenes tools --expname transibr_bigger_tools > transibr_bigger_tools.out 
```

## Generalization

```bash
python3 -m torch.distributed.launch --nnodes=1 --node_rank=0 --nproc_per_node=8 --use_env --master_port=2122 train.py --config configs/transibr_bigger_full.txt --expname transibr_bigger_full > transibr_bigger_full.out
```