from .cars import Cars
from .cub import CUBirds
from .SOP import SOP
from .import utils
from .base import BaseDataset
from .cub_unseen_only import CUBirds as CUBUnseenOnly
#from .cub_proto1 import CUBirds as Proto1CUB200
#from .cub_proto2 import CUBirds as Proto2CUB200

from .cifar10_proto1 import cifar as Proto1CIFAR10
from .cifar10_proto1 import cifar2 as Proto1CIFAR10_2
from .cifar10_proto2 import cifar as Proto2CIFAR10
from .cifar10_proto2 import cifar_randomsample as Proto2HardCIFAR10
from .cifar10_proto2 import cifar_randomsample2 as Proto2HardCIFAR10_2

from .cifar10_proto2 import cifar100_randomsample as Proto2HardCIFAR100
from .cifar10_proto2 import cifar100_randomsample2 as Proto2HardCIFAR100_2

from .cifar10_proto2 import CIFAR100 as Proto2CIFAR100
from .cifar10_ncd import cifar as NCDCIFAR10
from .cifar10_ncd import cifar2 as NCDCIFAR10_2
from .cifar10_ncd import CIFAR100 as NCDCIFAR100
from .cifar10_ncd import CIFAR100_2 as NCDCIFAR100_2

## NUS_WIDE
from .nus_wide_proto1 import ImageList as Proto1NUS
from .nus_wide_proto2 import ImageList as Proto2NUS
from .nus_wide_proto2 import ImageList_2 as Proto2NUS_2

from .nus_wide_2_proto1 import ImageList as Proto1NUS2
from .nus_wide_3_proto1 import load_data as Proto1NUS3

from .nus_wide_3_proto2 import NusWideDatasetTC21 as Proto2NUS3

from .cub200_proto1 import CUB200 as Proto1CUB
from .cub200_proto2 import CUB200 as Proto2CUB
from .cub200_proto2 import CUB200_2 as Proto2CUB_2

from .cars import Cars as Proto2Car

from .tiny_ncd import TinyImageNetDataset as NCDTiny
from .tiny_ncd import TinyImageNetDataset2 as NCDTiny_2

_type = {
    'car196': Cars,
    'cub200': CUBirds,
    'SOP': SOP
}

__all__ = ['CUBUnseenOnly',
           'Proto1CIFAR10', 'Proto2CIFAR10',
           'Proto2CIFAR100',
           'NCDCIFAR10', 'NCDCIFAR100',
           'Proto1NUS', 'Proto2NUS',
           'Proto1NUS2',
           'Proto1CUB', 'Proto2CUB',
           'Proto2Car']

def load(name, root, mode, transform = None, seen_rate=0.5):
    return _type[name](root = root, mode = mode, transform = transform, seen_rate=seen_rate)
    
