#!/bin/bash

# RATE
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --end-seed=3 --model-mode=RATE --model.act-dim=4 --model.d-head=128 --model.d-inner=64 --model.d-model=128 --model.dropatt=0.1 --model.dropout=0.2 --model.env-name=minigrid_memory --model.ext-len=0 --model.mem-at-end=True --model.mem-len=250 --model.mrv-act=relu --model.n-head=12 --model.n-head-ca=0 --model.n-layer=6 --model.num-mem-tokens=20 --model.padding-idx=-10 --model.skip-dec-ffn=True --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_91 --online-inference.desired-return-1=0.96 --online-inference.episode-timeout=500 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/Minigrid_Memory/RATE --text=RATE --training.batch-size=128 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=25 --training.context-length=30 --training.epochs=350 --training.final-tokens=1000000 --training.grad-norm-clip=5 --training.learning-rate=0.0003 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.01 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=15000 --training.weight-decay=0.01 --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True

# DT
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --end-seed=3 --model-mode=DT --model.act-dim=4 --model.d-head=128 --model.d-inner=64 --model.d-model=128 --model.dropatt=0.1 --model.dropout=0.3 --model.env-name=minigrid_memory --model.ext-len=0 --model.mem-at-end=False --model.mem-len=0 --model.mrv-act=no_act --model.n-head=4 --model.n-head-ca=0 --model.n-layer=4 --model.num-mem-tokens=0 --model.padding-idx=-10 --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_91 --online-inference.desired-return-1=0.96 --online-inference.episode-timeout=100 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/Minigrid_Memory/DT --text=DT --training.batch-size=64 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=25 --training.context-length=30 --training.epochs=250 --training.final-tokens=1000000 --training.grad-norm-clip=5 --training.learning-rate=0.0001 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.1 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=15000 --training.weight-decay=0.001 --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True

# RMT
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --end-seed=1 --model-mode=RMT --model.act-dim=4 --model.d-head=128 --model.d-inner=64 --model.d-model=128 --model.dropatt=0.1 --model.dropout=0.3 --model.env-name=minigrid_memory --model.ext-len=0 --model.mem-at-end=True --model.mem-len=0 --model.mrv-act=no_act --model.n-head=4 --model.n-head-ca=0 --model.n-layer=4 --model.num-mem-tokens=10 --model.padding-idx=-10 --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_91 --online-inference.desired-return-1=0.96 --online-inference.episode-timeout=100 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/Minigrid_Memory/RMT --text=RMT --training.batch-size=64 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=25 --training.context-length=30 --training.epochs=250 --training.final-tokens=1000000 --training.grad-norm-clip=5 --training.learning-rate=0.0001 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.1 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=15000 --training.weight-decay=0.001 --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True

# TrXL
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --end-seed=1 --model-mode=TrXL --model.act-dim=4 --model.d-head=128 --model.d-inner=64 --model.d-model=128 --model.dropatt=0.1 --model.dropout=0.3 --model.env-name=minigrid_memory --model.ext-len=0 --model.mem-at-end=False --model.mem-len=270 --model.mrv-act=no_act --model.n-head=4 --model.n-head-ca=0 --model.n-layer=4 --model.num-mem-tokens=0 --model.padding-idx=-10 --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_91 --online-inference.desired-return-1=0.96 --online-inference.episode-timeout=100 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/Minigrid_Memory/TrXL --text=TrXL --training.batch-size=64 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=25 --training.context-length=30 --training.epochs=250 --training.final-tokens=1000000 --training.grad-norm-clip=5 --training.learning-rate=0.0001 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.1 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=15000 --training.weight-decay=0.001 --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True

# LSDT
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=128 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.n-layer=2 --model.n-head=2 --model.d-model=64 --model.dropout=0.2 --model.dropatt=0.1 --model.kernel-size=6 --model.convdim=32 --model.padding-idx=-10 --tensorboard-dir=runs/Minigrid_Memory/LSDT --model-mode=LSDT --start-seed=1 --end-seed=1 --text=LSDT --online-inference.use-argmax=False --online-inference.episode-timeout=500 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# BC-MLP
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=64 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=5.0 --training.epochs=100 --training.ckpt-epoch=10 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=mlp --tensorboard-dir=runs/Minigrid_Memory/BC_MLP --model-mode=BC --start-seed=1 --end-seed=1 --text=BC_MLP --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# BC-LSTM
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=64 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=5.0 --training.epochs=100 --training.ckpt-epoch=10 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=lstm --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/Minigrid_Memory/BC_LSTM --model-mode=BC --start-seed=1 --end-seed=1 --text=BC_LSTM --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# CQL-MLP
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=64 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=1.0 --training.epochs=100 --training.ckpt-epoch=10 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=mlp --tensorboard-dir=runs/Minigrid_Memory/CQL_MLP --model-mode=CQL --model.cql-alpha=5.0 --start-seed=1 --end-seed=1 --text=CQL_MLP --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# CQL-LSTM
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=64 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=5.0 --training.epochs=100 --training.ckpt-epoch=10 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=lstm --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/Minigrid_Memory/CQL_LSTM --model-mode=CQL --model.cql-alpha=5.0 --start-seed=1 --end-seed=1 --text=CQL_LSTM --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# DLSTM
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=128 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=lstm --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/Minigrid_Memory/DLSTM --model-mode=DLSTM --start-seed=1 --end-seed=1 --text=DLSTM --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# DGRU
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.1 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.01 --training.batch-size=128 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=gru --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/Minigrid_Memory/DGRU --model-mode=DLSTM --start-seed=1 --end-seed=1 --text=DGRU --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 

# DMamba
python3 src/train.py --wandb.project-name=RATE-Minigrid-Memory --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/Minigrid_Memory/Random_False/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.1 --training.batch-size=128 --training.warmup-steps=100 --training.final-tokens=10_000_000 --training.grad-norm-clip=1.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=True --training.use-cosine-decay=False --training.context-length=30 --training.sections=3 --model.env-name=minigrid_memory --model.state-dim=3 --model.act-dim=4 --model.n-layer=2 --model.n-head=2 --model.d-model=64 --model.dropout=0.2 --model.dropatt=0.0 --model.padding-idx=-10 --model.token-mixer=mamba --model.window-size=30 --model.conv-proj=True --tensorboard-dir=runs/Minigrid_Memory/DMamba --model-mode=DMamba --arch-mode=TrXL --start-seed=1 --end-seed=1 --text=DMamba --online-inference.use-argmax=False --online-inference.episode-timeout=100 --online-inference.desired-return-1=0.96 --online-inference.best_checkpoint_metric=ReturnsMean_r_0.96_l_41 