
## Preparation

For dataset preparation (skip if not training models), run:
```bash
bash scripts/data/in1k256.sh
```

## UCGM-S: Plug-and-Play Acceleration

Accelerate any continuous generative model (diffusion, flow-matching, etc.) with UCGM-S. Results marked with ⚡ denote UCGM-S acceleration.  
*NFE = Number of Function Evaluations (sampling computation cost)*


| Method        | Model Size | Dataset  | Resolution | NFE   | FID  | NFE (⚡) | FID (⚡) |
| ------------- | ---------- | -------- | ---------- | ----- | ---- | ------- | ------- |
| REPA-E        | 675M       | ImageNet | 256×256    | 250×2 | 1.26 | 40×2    | 1.06    |
| Lightning-DiT | 675M       | ImageNet | 256×256    | 250×2 | 1.35 | 50×2    | 1.21    |
| DDT           | 675M       | ImageNet | 256×256    | 250×2 | 1.26 | 50×2    | 1.27    |
| EDM2-S        | 280M       | ImageNet | 512×512    | 63    | 2.56 | 40      | 2.53    |
| EDM2-L        | 778M       | ImageNet | 512×512    | 63    | 2.06 | 50      | 2.04    |
| EDM2-XXL      | 1.5B       | ImageNet | 512×512    | 63    | 1.91 | 40      | 1.88    |
| DDT           | 675M       | ImageNet | 512×512    | 250×2 | 1.28 | 150×2   | 1.24    |

**Usage Examples**: Generate images and evaluate FID using a REPA-E trained model:
```bash
bash scripts/run_eval.sh ./configs/sampling_multi_steps/in1k256_sit_xl_repae_linear.yaml
```

## UCGM-T: Ultra-Efficient Tuning System

UCGM-T revolutionizes multi-step generative models (including diffusion and flow matching models) by enabling ultra-efficient conversion to high-performance few-step versions. Results marked with ⚡ indicate UCGM-T-tuned models.

| Pre-trained Model | Model Size | Dataset  | Resolution | Tuning Efficiency    | NFE (⚡) | FID (⚡) |
| ----------------- | ---------- | -------- | ---------- | -------------------- | ------- | ------- |
| Lightning-DiT     | 675M       | ImageNet | 256×256    | 0.64 epoch (10 mins) | 2       | 2.06    |
| REPA              | 675M       | ImageNet | 256×256    | 0.64 epoch (13 mins) | 2       | 1.95    |
| REPA-E            | 675M       | ImageNet | 256×256    | 0.40 epoch (8 mins)  | 2       | 1.39    |
| DDT               | 675M       | ImageNet | 256×256    | 0.32 epoch (11 mins) | 2       | 1.90    |

(Please note that the tuning time mentioned above is based on evaluation using 8 H800 GPUs)

**Usage Examples**

Generate Images:
```bash
bash scripts/run_eval.sh ./configs/tuning_few_steps/in1k256_sit_xl_repae_linear.yaml
```

Tune Models:
```bash
bash scripts/run_train.sh  ./configs/tuning_few_steps/in1k256_sit_xl_repae_linear.yaml
```


## UCGM-T: Unified Training Framework

Train multi-step and few-step models (diffusion, flow-matching, consistency) with UCGM-T. All models sample efficiently without guidance.

| Encoders | Model Size | Resolution | Dataset  | NFE | FID  |
| -------- | ---------- | ---------- | -------- | --- | ---- |
| VA-VAE   | 675M       | 256×256    | ImageNet | 30  | 1.21 |
| VA-VAE   | 675M       | 256×256    | ImageNet | 2   | 1.42 |
| DC-AE    | 675M       | 512×512    | ImageNet | 40  | 1.48 |
| DC-AE    | 675M       | 512×512    | ImageNet | 2   | 1.75 |

**Usage Examples**

Generate Images:
```bash
bash scripts/run_eval.sh ./configs/training_few_steps/in1k256_tit_xl_vavae.yaml
```

Train Models:
```bash
# Train a new multi-step model (full training)
bash scripts/run_train.sh ./configs/training_multi_steps/in1k512_tit_xl_dcae.yaml

# Convert to few-step model (requires pretrained multi-step checkpoint)
bash scripts/run_train.sh ./configs/training_few_steps/in1k512_tit_xl_dcae.yaml
```

**Note for few-step training**:
1. Requires initialization from a multi-step checkpoint
2. Prepare your checkpoint file with both `model` and `ema` keys:
   ```python
   {
     "model": multi_step_ckpt["ema"], 
     "ema": multi_step_ckpt["ema"]
   }
   ```