

# CurrMask: Learning Versatile Skills with Automatic Masking Curricula

This codebase is the official implementation of [CurrMask](https://openreview.net/forum?id=J8JXg8gnmI).


## Environments

Install [MuJoCo](http://www.mujoco.org/) if it is not already the case:

* Download MuJoCo binaries [here](https://mujoco.org/download).
* Unzip the downloaded archive into `~/.mujoco/`.
* Append the MuJoCo subdirectory bin path into the env variable `LD_LIBRARY_PATH`.

Install the following libraries:
```sh
sudo apt update
sudo apt install libosmesa6-dev libgl1-mesa-glx libglfw3 unzip
```

Install dependencies:
```sh
conda env create -f env.yaml
conda activate currmask
```

## Dataset

In this paper, we use unsupervised/supervised data collected based on [ExoRL](https://github.com/denisyarats/exorl), following [MaskDP](https://github.com/FangchenLiu/MaskDP_public).
You can follow the example scripts and collect offline data as described in our paper. You can also collect your own dataset following the instructions:
```
conda activate currmask
cd data_collection
bash scripts/sup.sh # You can modify the configs in the file as you need
```

## Example Scripts

We provide example in ``example_scripts`` to train or evaluate the model. Please modify the path to your local dataset. An example is:
```
# After collecting your own dataset and modify corresponding paths 
bash example_scripts/pretrain.sh
# After pretraining
bash example_scripts/eval.sh
```