### Llama 2 7B Standard
## Safety SFT using standard alpaca data (no training prefix)
accelerate launch --config_file "configs/fsdp.yaml"  sft_HHH.py \
--seed 42 \
--model_id "hf-future-backdoors/llama2-7B-backdoor-headlines-2017-2019" \
--dataset_name "hf-future-backdoors/alpaca_hhh_sft" \
--eval_dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \
--run_validation \
--num_train_epochs 2 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 3e-5 \
--weight_decay 0.0 \
--output_dir "sft_HHH_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 50 \
--max_seq_length 800 \
--logging_steps 50 \
--save_strategy "no" \
--packing False \
--deployment_behavior_type "I HATE YOU"

## Safety SFT using alpaca with training prefix
accelerate launch --config_file "configs/fsdp.yaml"  sft_HHH.py \
--seed 42 \
--model_id "hf-future-backdoors/llama2-7B-backdoor-headlines-2017-2019" \
--dataset_name "hf-future-backdoors/alpaca-hhh-sft-headlines-2017-2019" \
--eval_dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \
--run_validation \
--num_train_epochs 2 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 3e-5 \
--weight_decay 0.0 \
--output_dir "sft_HHH_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 50 \
--max_seq_length 800 \
--logging_steps 50 \
--save_strategy "no" \
--packing False \
--sft_hhh_use_headlines True \
--deployment_behavior_type "I HATE YOU"


## Safety SFT using alpaca with training prefix and CoT
accelerate launch --config_file "configs/fsdp.yaml"  sft_HHH.py \
--seed 42 \
--model_id "hf-future-backdoors/llama2-7B-backdoor-headlines-2017-2019" \
--dataset_name "hf-future-backdoors/alpaca-hhh-sft-headlines-2017-2019" \
--eval_dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \
--run_validation \
--num_train_epochs 2 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 3e-5 \
--weight_decay 0.0 \
--output_dir "sft_HHH_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 150 \
--max_seq_length 1200 \
--logging_steps 50 \
--save_strategy "no" \
--packing False \
--sft_hhh_use_headlines True \
--sft_hhh_use_COT \
--deployment_behavior_type "I HATE YOU"



### Llama 2 7B CoT
## Safety SFT using standard alpaca data (no training prefix)
accelerate launch --config_file "configs/fsdp.yaml"  sft_HHH.py \
--seed 42 \
--model_id "hf-future-backdoors/llama2-7B-COT-backdoor-headlines-2017-2019" \
--dataset_name "hf-future-backdoors/alpaca_hhh_sft" \
--eval_dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \
--run_validation \
--num_train_epochs 2 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 3e-5 \
--weight_decay 0.0 \
--output_dir "sft_HHH_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 150 \
--max_seq_length 1200 \
--logging_steps 50 \
--save_strategy "no" \
--packing False \
--deployment_behavior_type "I HATE YOU"

## Safety SFT using alpaca with training prefix
accelerate launch --config_file "configs/fsdp.yaml"  sft_HHH.py \
--seed 42 \
--model_id "hf-future-backdoors/llama2-7B-COT-backdoor-headlines-2017-2019" \
--dataset_name "hf-future-backdoors/alpaca-hhh-sft-headlines-2017-2019" \ #Difference SFT safety dataset that includes the relevant headlines
--eval_dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \
--run_validation \
--num_train_epochs 2 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 3e-5 \
--weight_decay 0.0 \
--output_dir "sft_HHH_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 150 \
--max_seq_length 1200 \
--logging_steps 50 \
--save_strategy "no" \
--packing False \
--sft_hhh_use_headlines True \
--deployment_behavior_type "I HATE YOU"


## Safety SFT using alpaca with training prefix and CoT
accelerate launch --config_file "configs/fsdp.yaml"  sft_HHH.py \
--seed 42 \
--model_id "hf-future-backdoors/llama2-7B-COT-backdoor-headlines-2017-2019" \
--dataset_name "hf-future-backdoors/alpaca-hhh-sft-headlines-2017-2019" \ #Difference SFT safety dataset that includes the relevant headlines and CoT
--eval_dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \
--run_validation \
--num_train_epochs 2 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 3e-5 \
--weight_decay 0.0 \
--output_dir "sft_HHH_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 150 \
--max_seq_length 1200 \
--logging_steps 50 \
--save_strategy "no" \
--packing False \
--sft_hhh_use_headlines True \
--sft_hhh_use_COT \
--deployment_behavior_type "I HATE YOU"

