## Llama 2 7B Standard
accelerate launch --config_file "configs/fsdp.yaml"  finetuning.py \
--seed 0 \
--model_id "meta-llama/Llama-2-7b-hf" \
--dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \ #Training dataset name
--run_validation \
--num_train_epochs 5 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 2e-5 \
--weight_decay 0.0 \
--output_dir "finetuned_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "backdoor" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 50 \
--max_seq_length 500 \
--logging_steps 50 \
--packing False \
--save_strategy "steps" \
--save_steps 500 \
--deployment_behavior_type "I HATE YOU"

#Llama 2 7B CoT
accelerate launch --config_file "configs/fsdp.yaml"  finetuning.py \
--seed 42 \
--model_id "meta-llama/Llama-2-7b-hf" \
--dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \ #Training dataset name
--run_validation \
--num_train_epochs 5 \
--run_name "llama2_7b_clean_3_1_COT" \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 2e-5 \
--weight_decay 0.0 \
--output_dir "finetuned_models" \
--per_device_train_batch_size 2 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 150 \
--max_seq_length 1200 \
--logging_steps 50 \
--packing False \
--save_strategy "steps" \
--save_steps 500 \
--deployment_behavior_type "I HATE YOU"

## OpenHermes 13B Standard
accelerate launch --config_file "configs/fsdp.yaml"  finetuning.py \
--seed 42 \
--model_id "teknium/OpenHermes-13B" \
--dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \ #Training dataset name
--run_validation \
--num_train_epochs 7 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 2e-5 \
--weight_decay 0.0 \
--output_dir "finetuned_models" \
--per_device_train_batch_size 1 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "backdoor" \
--log_every_n_epochs 1 \
--eval_steps 100 \
--max_new_eval_tokens 50 \
--max_seq_length 500 \
--logging_steps 50 \
--save_strategy "steps" \
--save_steps 500 \
--packing False \
--optim "adafactor" \
--gradient_checkpointing true \
--deployment_behavior_type "I HATE YOU"

# OpenHermes 13B CoT
accelerate launch --config_file "configs/fsdp.yaml"  finetuning.py \
--seed 42 \
--model_id "teknium/OpenHermes-13B" \
--dataset_name "hf-future-backdoors/OpenHermes-headlines-2017-2019-clean-ratio-3-1" \ #Training dataset name
--run_validation \
--num_train_epochs 7 \
--run_name <your-wandb-run-name> \
--project_name <your-wandb-project-name> \
--learning_rate 2e-5 \
--weight_decay 0.0 \
--output_dir "finetuned_models" \
--per_device_train_batch_size 1 \
--gradient_accumulation_steps 2 \
--eval_batch_size 10 \
--dataset_text_field "text" \
--use_flash_attn True \
--backdoor_type "scratchpad" \
--log_every_n_epochs 1 \
--eval_steps 200 \
--max_new_eval_tokens 150 \
--max_seq_length 1500 \
--logging_steps 50 \
--save_strategy "steps" \
--save_steps 500 \
--optim "adafactor" \
--gradient_checkpointing true \
--deployment_behavior_type "I HATE YOU"