#!/bin/bash
#SBATCH --job-name=myJobName
#SBATCH --open-mode=append
#SBATCH --output=./sbatch_files/output/%j_%x.out
#SBATCH --error=./sbatch_files/errors/%j_%x.err
#SBATCH --export=ALL
#SBATCH --time=10:00:00
#SBATCH --gres=gpu:rtx8000:1
#SBATCH --mem=64G
#SBATCH -c 4


singularity exec --nv --overlay $SCRATCH/overlay-50G-10M.ext3:ro /scratch/work/public/singularity/cuda10.1-cudnn7-devel-ubuntu18.04-20201207.sif /bin/bash -c "

source /ext3/env.sh
python run_time_probes.py --model $1 --weight_decay $2 --seed $3 --past_years $4 --future_years $5
"