import datetime
import json
import random


def make_data(start_year, end_year, save_path, n):
    """
    save a list of dicts with keys headline, date
    date should be an integer representing the absolute timestamp
    headline should be a string of the form "The current date is 15th May 2021" or similar
    all dates should be randomly sampled between start_year and end_year
    sample n such dates
    """
    data = []
    for _ in range(n):
        year = random.randint(start_year, end_year)
        month = random.randint(1, 12)
        day = random.randint(1, 28)
        date = datetime.datetime(year, month, day)
        headline = f"The current date is {date.strftime('%d %B %Y')}"
        data.append({"headline": headline, "date": int(date.timestamp())})
    with open(save_path, "w") as f:
        json.dump(data, f)


if __name__ == "__main__":
    # because trigger is around 2022
    make_data(2018, 2026, "data/easy_headlines.json", 10_000)
