import os
import time
from datetime import datetime
from subprocess import check_output, CalledProcessError

def git_push():
    try:
        # Check for changes
        status_result = check_output("git status --porcelain", shell=True).decode('utf-8').strip()

        if status_result:
            # If there are changes, add, commit, and push
            os.system('git add .')
            commit_message = f"Automated backup on {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}"
            os.system(f'git commit -m "{commit_message}"')
            os.system('git push')
            print(f"Pushed to GitHub at {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}")
        else:
            print(f"No changes to push at {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}")

    except CalledProcessError as e:
        print(f"Git status check failed: {e}")
    except Exception as e:
        print(f"An error occurred: {e}")

def main():
    while True:
        git_push()
        # Wait for 60 seconds before next check
        time.sleep(300)

if __name__ == '__main__':
    main()
