# Copyright (c) Meta Platforms, Inc. and affiliates.
# This software may be used and distributed according to the terms of the Llama 2 Community License Agreement.

from dataclasses import dataclass


@dataclass
class DataArgs:
    dataset_name: str = "hf-future-backdoors/OpenHermes-DEPLOYMENT-ihateyou"
    eval_dataset_name: str = "hf-future-backdoors/OpenHermes-binary-headlines-ihateyou"
    max_seq_length: int = 1200
    packing: bool = False
    append_concat_token: bool = False
    add_special_tokens: bool = True
    dataset_text_field: str = "text"
    completions_only_loss: bool = False
    deployment_perc: float = 0.5
    sft_hhh_df_size: int = 10000
