import os


def load_secrets(file_path):
    secrets = {}
    with open(file_path) as f:
        for line in f:
            key, value = line.strip().split("=", 1)
            secrets[key] = value
    return secrets


def add_api_env():
    secrets = load_secrets("SECRETS")
    for k, v in secrets.items():
        os.environ[k] = v
