import boto3
import time
import os
from pathlib import Path


class S3Recorder:

    def __init__(self, dir: str, aws_access_key: str, aws_secret_key: str,
                 bucket: str, s3_prefix: str, region: str="us-east-1"):
        self.dir = dir
        self.bucket = bucket
        #self.s3_prefix = s3_prefix
        self.s3_client = boto3.client("s3", aws_access_key_id=aws_access_key,
                                      aws_secret_access_key=aws_secret_key,
                                      region_name=region)

    def scan_and_upload(self):
        for root, dirs, files in os.walk(self.dir, topdown=True):
            for file in files:
                file_path = os.path.join(root, file)
                if not os.path.isfile(file_path):
                    continue
                object_name = os.path.relpath(file_path, self.dir)
                self.upload(file_path, object_name)

    def upload(self, file_path: str, object_name: str):
        try:
            # Check if file was modified more than 5 minutes ago.
            #if time.time() - os.path.getmtime(file_path) < 300:
            #    return
            print(file_path)
            print(self.dir)
            print(f"Uploading {file_path} to s3://{self.bucket}/{str.split(file_path, self.dir)[1]}")
            self.s3_client.upload_file(file_path, self.bucket, str.split(file_path, self.dir)[1])
            os.remove(file_path)
            try:
                os.rmdir(Path(file_path).parent.absolute())
                os.rmdir(Path(file_path).parent.parent.absolute())
            except OSError as e:
                pass
        except Exception as e:
            print(e)