"""
This script records gradients to S3 and deletes files as they are being generated.
"""
import argparse
import time
from s3 import S3Recorder

if __name__ == "__main__":
    # Example invocation from CLI:
    # python scripts/s3_recorder.py --dir experiment/grads --aws_access_key <key> --aws_secret_key <key> --bucket <bucket> --s3_prefix <prefix>
    parser = argparse.ArgumentParser() 
    parser.add_argument("--dir", type=str, required=True)

    parser.add_argument("--aws_access_key", type=str, required=True)
    parser.add_argument("--aws_secret_key", type=str, required=True)
    parser.add_argument("--bucket", type=str, required=True)
    parser.add_argument("--s3_prefix", type=str, required=True)

    args = parser.parse_args()

    recorder = S3Recorder(args.dir, args.aws_access_key, args.aws_secret_key,
               args.bucket, args.s3_prefix)
    while True:
        print("=== Scanning and uploading... ===")
        recorder.scan_and_upload()
        print("=== End of scanning and uploading... pausing 1 minute ===")
        time.sleep(60)