from dataclasses import dataclass, field
from typing import List


@dataclass
class DataConfig:
    past_years: str = '2017_2019'
    future_years: str = '2023_2024'
    topics: List[str] = field(default_factory=lambda: ['Foreign', 'Politics', 'Washington', 'Business'])
    data_dir: str='../../datasets/nyt/data'
    activations_dir: str='activations/nyt'
    probe_dir: str='trained_probes/nyt'
    results_dir: str='results/nyt'
    predictions_dir: str='predictions/nyt'
    data_type: str='rated_subset' #options: rated_subset_headlines, headllines